<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Log;


class InventoryController extends Controller
{
    private function fetchApiData($url) {
        $token = session('token');
        $curl = curl_init();
    
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $token,
                'Accept: application/json',
            ],
        ));
    
        $response = curl_exec($curl);
    
        if (curl_errno($curl)) {
            $error_msg = curl_error($curl);
            curl_close($curl);
            \Log::error("cURL Error: " . $error_msg);
            return null;
        }
    
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
    
        if ($httpCode !== 200) {
            \Log::error("API HTTP Code: $httpCode | Response: $response");
            return null;
        }
    
        $decoded = json_decode($response, true); // return as array
        if ($decoded === null) {
            \Log::error("JSON Decode Error: $response");
            return null;
        }
    
        return $decoded; // ✅ now this is an array
    }
    
    
    public function allInventory(){
        $accred_type = $this->fetchApiData('https://ac-api.omsdev.in:2002/api/master/getAllAccreditationType?pageNo=0&pageSize=30');
        
        if(isset($accred_type['status']) && $accred_type['status'] == 0){
            $accred_type = $accred_type['response']['dataSet'];
        }   

        $inventory = $this->fetchApiData('https://ac-api.omsdev.in:2002/api/master/getAllInventory?pageNo=0&pageSize=30');
        
        if(isset($inventory['status']) && $inventory['status'] == 0){
            $inventory = $inventory['response']['dataSet'];
        }   
        // dd( $inventory);
        // dd( $accred_type);
        return view('inventory.list',compact('accred_type', 'inventory')); 
    }

   

    public function addInventory(Request $request){
        // dd($request->all());
        $token = session('token'); 
        $inventoryData = $request->input('inventory');

        // Prepare JSON-encoded payload
        $payload = json_encode($inventoryData);

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://ac-api.omsdev.in:2002/api/master/saveOrUpdateInventory',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer ' . $token,
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);
        // dd($response);
        // $error = curl_error($curl);
        // curl_close($curl);

        // if ($error) {
        //     return response()->json(['error' => $error], 500);
        // }

        return redirect()->back(); 
    }


}
