<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;



class MasterController extends Controller
{
    //Accredation 

    public function allAccredation(){
        return view('masters.accredation_types.list');
    }

    public function getAddAccredation(){
        return view('masters.accredation_types.add');
    }

    public function addAccredation(Request $request)
    {
        $data = [
            "accreditationTypeId" => 0,
            "name" => $request->name,
            "isActive" => $request->isActive === 'true',
        ];
        $token = session('token');

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://ac-api.omsdev.in:2002/api/master/saveOrUpdateAccreditationType',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data), // ✅ JSON-encoded data
            CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer ' . $token,
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);
       
        curl_close($curl);

        return redirect('accredation-types/list')->with('success', 'Accredation types added successfully.');
    }

    public function getUpdateAccredation($accredation_type_id){
        $token = session('token');
        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => "https://ac-api.omsdev.in:2002/api/master/getAccreditationTypeById?accreditationTypeId=$accredation_type_id",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => [
            'Authorization: Bearer ' . $token,
            'Accept: application/json',
        ],
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $data = json_decode($response, true);
        if($data['status'] == 0){
            $accredation = $data['response'];
            return view('masters.accredation_types.update')->with('accredation', $accredation);
        }
        return view('masters.accredation_types.update', compact('accredation_type_id'));
    }

    public function updateAccredation(Request $request)
    {
        $token = session('token');
        $data = [
            "accreditationTypeId" => (int)$request->accreditationTypeId,
            "name" => $request->name,
            "isActive" => $request->isActive === 'true',
        ];

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://ac-api.omsdev.in:2002/api/master/saveOrUpdateAccreditationType',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data), // ✅ JSON-encoded data
            CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer ' . $token,
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        return redirect('accredation-types/list')->with('success', 'accredation type updated successfully.');
    }

    public function deleteAccredation($id){
        $token = session('token');
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://ac-api.omsdev.in:2002/api/master/deleteAccreditationTypeById?accreditationTypeId={$id}",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'DELETE',
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $token,
                'Accept: application/json',
            ],
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        $json = json_decode($response, true);

        if (isset($json['status']) && $json['status'] == 0) {
            return redirect()->back()->with('success', 'Accredation types deleted successfully.');
        } else {
            return redirect()->back()->with('error', 'Failed to delete Accredation type.');
        }
    }


    //Designations
    public function allDesignations(){
        return view('masters.designations.list');
    }
    public function getAddDesignations(){
        return view('masters.designations.add');
    }

    public function addDesignation(Request $request)
    {
        $data = [
            "designationDescription" => $request->designationDescription,
            "designationMasterId" => 0,
            "designationName" => $request->designationName,
            "isActive" => $request->isActive === 'true',
        ];
        $token = session('token');
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://ac-api.omsdev.in:2002/api/master/saveOrUpdateDesignation',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data), // ✅ JSON-encoded data
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $token,
                'Accept: application/json',
            ],
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        return redirect('designations/list')->with('success', 'Designation added successfully.');
    }

    public function getUpdateDesignation($designation_id){
        $token = session('token');
        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => "https://ac-api.omsdev.in:2002/api/master/getDesignationById?roleId=$designation_id",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => [
            'Authorization: Bearer ' . $token,
            'Accept: application/json',
        ],
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $data = json_decode($response, true);
        if($data['status'] == 0){
            $designation = $data['response'];
            return view('masters.designations.update')->with('designation', $designation);
        }
        return view('masters.designations.update', compact('designation_id'));
    }

    public function updateDesignation(Request $request)
    {
        $data = [
            "designationDescription" => $request->designationDescription,
            "designationMasterId" => (int)$request->designationMasterId,
            "designationName" => $request->designationName,
            "isActive" => $request->isActive === 'true',
        ];
        $token = session('token');
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://ac-api.omsdev.in:2002/api/master/saveOrUpdateDesignation',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data), // ✅ JSON-encoded data
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $token,
                'Accept: application/json',
            ],
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        return redirect('designations/list')->with('success', 'Designation updated successfully.');
    }

    public function deleteDesignations($id){
        $token = session('token');
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://ac-api.omsdev.in:2002/api/master/deleteDesignationById?roleId={$id}",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'DELETE',
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $token,
                'Accept: application/json',
            ],
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        $json = json_decode($response, true);

        if (isset($json['status']) && $json['status'] == 0) {
            return redirect()->back()->with('success', 'Designation deleted successfully.');
        } else {
            return redirect()->back()->with('error', 'Failed to delete designation.');
        }
    }



    //Access Areas 
    public function allAccessAreas(){
        return view('masters.access_areas.list');
        
    }

    public function getAddAccessAreas(){
        return view('masters.access_areas.add');
    }

    public function addAccessAreas(Request $request)
    {
        $token = session('token');
        $data = [
            "accessAreaId" => 0,
            "name" => $request->name,
            "areaCode" => $request->areaCode,
            "isActive" => $request->isActive === 'true',
        ];
        // dd($data);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://ac-api.omsdev.in:2002/api/master/saveOrUpdateAccessArea',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data), // ✅ JSON-encoded data
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $token,
                'Accept: application/json',
            ],
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        return redirect('access-areas/list')->with('success', 'access area added successfully.');
    }

    public function getUpdateAccessAreas($access_id){
        $token = session('token');
        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => "https://ac-api.omsdev.in:2002/api/master/getAccessAreaById?accessAreaId=$access_id",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => [
            'Authorization: Bearer ' . $token,
            'Accept: application/json',
        ],
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $data = json_decode($response, true);
        if($data['status'] == 0){
            $access_area = $data['response'];
            return view('masters.access_areas.update')->with('access_area', $access_area);
        }
        return view('masters.access_areas.update', compact('access_id'));
    }

    public function updateAccessAreas(Request $request)
    {
        $data = [
            "accessAreaId"=> (int)$request->accessAreaId,
            "areaCode" => $request->areaCode,
            "isActive"=> $request->isActive === 'true',
            "name"=> $request->name,
        ];
        // dd($data);
        $token = session('token');
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://ac-api.omsdev.in:2002/api/master/saveOrUpdateAccessArea',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data), // ✅ JSON-encoded data
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $token,
                'Accept: application/json',
            ],
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        // dd($response);
        return redirect('access-areas/list')->with('success', 'access area updated successfully.');
    }

    public function deleteAccessAreas($id){
        $token = session('token');
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://ac-api.omsdev.in:2002/api/master/deleteAccessAreaById?accessAreaId={$id}",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'DELETE',
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $token,
                'Accept: application/json',
            ],
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        // dd($id);
        $json = json_decode($response, true);

        if (isset($json['status']) && $json['status'] == 0) {
            return redirect()->back()->with('success', 'Access area deleted successfully.');
        } else {
            return redirect()->back()->with('error', 'Failed to delete Access area.');
        }
    }


    //Vendor Types
    public function allVendorTypes(){
        return view('masters.vendor_types.list');
    }
    public function getAddVendorTypes(){
        return view('masters.vendor_types.add');
    }

    public function addVendorTypes(Request $request)
    {
        $token = session('token');
        $data = [
            "vendorTypeId" => 0,
            "name" => $request->name,
            "isActive" => $request->isActive === 'true',
        ];

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://ac-api.omsdev.in:2002/api/master/saveOrUpdateVendorType',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data), // ✅ JSON-encoded data
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $token,
                'Accept: application/json',
            ],
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        return redirect('vendor-types/list')->with('success', 'vendor types added successfully.');
    }

    public function getUpdateVendorTypes($vendor_type_id){
        // dd($vendor_type_id);
        $token = session('token');
        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => "https://ac-api.omsdev.in:2002/api/master/getVendorTypeById?vendorTypeId=$vendor_type_id",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => [
            'Authorization: Bearer ' . $token,
            'Accept: application/json',
        ],
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $data = json_decode($response, true);
        if($data['status'] == 0){
            $vendor_types = $data['response'];
            return view('masters.vendor_types.update')->with('vendor_types', $vendor_types);
        }
        return view('masters.vendor_types.update', compact('vendor_types'));
    }

    public function updateVendorTypes(Request $request)
    {
        $data = [
            "vendorTypeId" => (int)$request->vendorTypeId,
            "name" => $request->name,
            "isActive" => $request->isActive === 'true',
        ];
        $token = session('token');
        
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://ac-api.omsdev.in:2002/api/master/saveOrUpdateVendorType',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data), // ✅ JSON-encoded data
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $token,
                'Accept: application/json',
            ],
        ));

        $response = curl_exec($curl);
        // dd($response);
        curl_close($curl);

        return redirect('vendor-types/list')->with('success', 'vendor types updated successfully.');
    }

    public function deleteVendorTypes($id){
        $token = session('token');
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://ac-api.omsdev.in:2002/api/master/deleteVendorTypeById?vendorTypeId={$id}",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'DELETE',
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $token,
                'Accept: application/json',
            ],
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        $json = json_decode($response, true);

        if (isset($json['status']) && $json['status'] == 0) {
            return redirect()->back()->with('success', 'vendor types deleted successfully.');
        } else {
            return redirect()->back()->with('error', 'Failed to delete vendor type.');
        }
    }

}
