<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Session;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Support\Facades\Config;

class PublicController extends Controller
{

    public $baseUrl;

    public function __construct()
    {
        // Initialize from config
        $this->baseUrl = config('app.base_url');
        
    }

    private function fetchApiData($url) {
        $token = session('token'); // Get token from session
    
        $curl = curl_init();
    
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $token,
                'Accept: application/json',
            ],
        ));
    
        $response = curl_exec($curl);
        // dd($response);
        if (curl_errno($curl)) {
            $error_msg = curl_error($curl);
            curl_close($curl);
            dd("cURL Error: " . $error_msg);
        }
    
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
    
        if ($httpCode !== 200) {
            dd("HTTP Code: $httpCode", $response);
        }
    
        $decoded = json_decode($response, true);
        if ($decoded === null) {
            dd("JSON Decode Error", $response);
        }
    
        return $decoded;
    }

    private function fetchApiStaffData($url) {
        
        $curl = curl_init();
    
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => [
                'Accept: application/json',
            ],
        ));
    
        $response = curl_exec($curl);
    
        if (curl_errno($curl)) {
            $error_msg = curl_error($curl);
            curl_close($curl);
            dd("cURL Error: " . $error_msg);
        }
    
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
    
        if ($httpCode !== 200) {
            dd("HTTP Code: $httpCode", $response);
        }
    
        $decoded = json_decode($response, true);
        if ($decoded === null) {
            dd("JSON Decode Error", $response);
        }
    
        return $decoded;
    }
    
    
    public function dashboard(){
        // $value = session('type');
        // dd($value);
        $dashboard_data = $this->fetchApiData('https://ac-api.omsdev.in:2002/api/vendor/getDashboard');
        
        if(isset($dashboard_data['status']) && $dashboard_data['status'] == 0){
            $dashboard_data = $dashboard_data['response'];
        }
        // dd($dashboard_data);
        return view('index', compact('dashboard_data'));
    }

    public function vendorDashboard(){
        $value = session('token');
        // dd($value);
        $dashboard_data = $this->fetchApiData($this->baseUrl . '/vendor/getDashboard');
        
        if(isset($dashboard_data['status']) && $dashboard_data['status'] == 0){
            $dashboard_data = $dashboard_data['response'];
        }
        // dd($dashboard_data);
        return view('vendor_dashboard', compact('dashboard_data'));
    }

    public function getURL($event_name, $vendor_id){
        return view('register_staff', compact('event_name', 'vendor_id'));
    }

    public function registerStaff(Request $request){
        
        return view('add_registered_staff');
    }

    public function verifyStaffOtp(Request $request){
        //    dd($request->all());
        $otp = $request->input('otp');
        $phone = $request->input('phone');
        $vendorId = $request->input('vendorId');
        $event_name = $request->input('event_name');
        $curl = curl_init();

        $url = "https://ac-api.omsdev.in:2003/api/staff/verifyOtp?phone={$phone}&otp={$otp}&vendorId={$vendorId}";

        curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        // Optional: Decode and use the response
       // Decode the JSON response
        $result = json_decode($response, true);
        // dd($result);
        // Check for successful response
        if (isset($result['status']) && $result['status'] === 0 && isset($result['response']['staffId'])) {
            $staff_id = $result['response']['staffId'];
            $event_name_encoded = urlencode($event_name);

            // Build the redirect URL
            $url = "/company/{$event_name_encoded}/{$vendorId}/{$staff_id}/{$phone}";
            // dd($url);
            // Redirect
            return redirect($url);
        } else {
            $errorMessage = isset($result['response']) ? $result['response'] : 'OTP verification failed';
            return back()->withErrors(['login_error' => $errorMessage]);

        }

    }

    public function getStaffForm($event, $vendor_id, $staffId, $phone){
       
        $all_access_area = $this->fetchApiStaffData("https://ac-api.omsdev.in:2003/api/master/getAllAccessAreaByVendorId?pageNo=0&pageSize=30&vendorId=$vendor_id");
       
        if(isset($all_access_area['status']) && $all_access_area['status'] == 0){
            $all_access_area = $all_access_area['response']['dataSet'];
        }
       
        $designations = $this->fetchApiStaffData("https://ac-api.omsdev.in:2003/api/master/getAllDesignationByVendorId?pageNo=0&pageSize=30&vendorId=$vendor_id");
            
        if(isset($designations['status']) && $designations['status'] == 0){
            $designations = $designations['response']['dataSet'];
        }
        $all_countries = $this->fetchApiStaffData('https://ac-api.omsdev.in:2003/api/master/getAllCountry?pageNo=0&pageSize=300');
            
        if(isset($all_countries['status']) && $all_countries['status'] == 0){
            $all_countries = $all_countries['response']['dataSet'];
        }
        // dd($all_countries);
        return view('add_staff', compact('all_countries', 'designations', 'all_access_area', 'vendor_id', 'staffId', 'phone'));
    }

    public function addForm(Request $request){
        // dd($request->all());
        // Handle profilePicture upload
        $token = session('token');
        if ($request->hasFile('profilePicture')) {
            $file = $request->file('profilePicture');
    
            $client = new Client();
    
            $response = $client->post('https://ac-api.omsdev.in:2003/api/staff/uploadImage', [
                'headers' => [
                      
                        'Accept'        => 'application/json',
                    ],
                    'multipart' => [
                        [
                            'name'     => 'file',
                            'contents' => fopen($file->getPathname(), 'r'),
                            'filename' => $file->getClientOriginalName(),
                        ],
                    ],
            ]);
            // $image_nm = $file->getClientOriginalName();
            
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);
            $profileImage = $data['response'];
        }
        
        if ($request->hasFile('idProofFront')) {
            $file = $request->file('idProofFront');
    
            $client = new Client();
    
            $response = $client->post('https://ac-api.omsdev.in:2003/api/staff/uploadImage', [
                'multipart' => [
                    [
                        'name'     => 'file',
                        'contents' => fopen($file->getPathname(), 'r'),
                        'filename' => $file->getClientOriginalName(),
                        'headers'  => [
                           
                            'Content-Type' => $file->getMimeType(),
                        ],
                    ],
                ],
            ]);
            // $image_nm = $file->getClientOriginalName();
            
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);
        }
        $idFrontimage = $data['response'];
       
        if ($request->hasFile('idProofBack')) {
            $file = $request->file('idProofBack');
    
            $client = new Client();
    
            $response = $client->post('https://ac-api.omsdev.in:2003/api/staff/uploadImage', [
                'multipart' => [
                    [
                        'name'     => 'file',
                        'contents' => fopen($file->getPathname(), 'r'),
                        'filename' => $file->getClientOriginalName(),
                        'headers'  => [
                           
                            'Content-Type' => $file->getMimeType(),
                        ],
                    ],
                ],
            ]);
            // $image_nm = $file->getClientOriginalName();
            
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);
        }
        $idBackImage = $data['response'];
       
       
        $data = [
            "profilePicture" => $profileImage ? $profileImage :'',
            "addressLine1" => $request->addressLine1,
            "addressLine2" => $request->addressLine2,
            "city" => $request->city,
            "country" => $request->country,
            "countryCode" => $request->countryCode,
            "designationMasterId" => (int)$request->designationMasterId,
            "dob" => $request->dob,
            "email" => $request->email,
            "fatherName" => $request->fatherName,
            "firstName" => $request->first_name,
            "gender" => $request->gender,
            "idNumber" => $request->idNumber,
            "idProofBack" => $idBackImage ? $idBackImage :'',
            "idProofFront" => $idFrontimage? $idFrontimage :'',
            "idType" => $request->idType,
            "lastName" => $request->last_name,
            "middleName" => $request->middle_name,
            "onlyConcourseAccess" => $request->onlyConcourseAccess === 'true',
            "phone" => $request->phone,
            "postalCode" => $request->postalCode,
            "staffAccessAreaList" => $request->input('accessAreaId', []),
            "staffId" => 0,
            "vendorId" => $request->vendorId,
            "state" => $request->state
        ];
        
        // dd($data);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://ac-api.omsdev.in:2003/api/staff/updateStaffDetails',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => array(
               
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);
        
        curl_close($curl);
        // dd($response);
        return redirect('thanks');
    }

    public function profile(){
        $check = session::all();
        // dd($check);
        $value = session('type');
        if($value == 'vendor'){
            $profile_data = $this->fetchApiData('https://ac-api.omsdev.in:2003/api/vendor/getVendorById');
        
            if(isset($profile_data['status']) && $profile_data['status'] == 0){
                $profile_data = $profile_data['response'];
            }
        }else{
            $profile_data = $this->fetchApiData('https://ac-api.omsdev.in:2002/api/VendorAdmin/getVendorAdminById');
        
            if(isset($profile_data['status']) && $profile_data['status'] == 0){
                $profile_data = $profile_data['response'];
            }
        }
        // dd($profile_data);
       
        return view('profile', compact('profile_data'));
    }

    public function addProfile(Request $request){
        // dd($request->all());
        $profileImage = null;
        $value = session('type');
        $token = session('token');
        if ($request->hasFile('profilePicture')) {
            $file = $request->file('profilePicture');
    
            $client = new \GuzzleHttp\Client();

            if($value == 'vendor'){
                $response = $client->post('https://ac-api.omsdev.in:2003/api/staff/uploadImage', [
                    'headers' => [
                            // 'Authorization' => 'Bearer ' . $token,
                            'Accept'        => 'application/json',
                        ],
                        'multipart' => [
                            [
                                'name'     => 'file',
                                'contents' => fopen($file->getPathname(), 'r'),
                                'filename' => $file->getClientOriginalName(),
                            ],
                        ],
                ]);
            }else{
                $response = $client->post('https://ac-api.omsdev.in:2002/api/master/uploadImage', [
                    'headers' => [
                            'Authorization' => 'Bearer ' . $token,
                            'Accept'        => 'application/json',
                        ],
                        'multipart' => [
                            [
                                'name'     => 'file',
                                'contents' => fopen($file->getPathname(), 'r'),
                                'filename' => $file->getClientOriginalName(),
                            ],
                        ],
                ]);
                

                if ($response->getStatusCode() !== 200) {
                    dd('Unexpected status', $response->getStatusCode());
                }

                $data = json_decode((string) $response->getBody(), true);
                $profileImage = $data['response'] ?? null;
                
            }
           
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);
            
            // image_nm = $file->getClientOriginalName();
            
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);
        }
        $data = [
            "contactPerson" => $request->contactPerson,
            "mobileNumber" => $request->mobileNumber,
            "smsSummaryFrequency" => $request->smsSummaryFrequency
        ];

        if ($profileImage) {
            $data['profilePicture'] = $profileImage;
        }

        if($value == 'vendor'){
            // dd($data);
            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://ac-api.omsdev.in:2003/api/vendor/updateVendor',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($data),
                CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer ' . $token,
                    'Content-Type: application/json'
                ),
            ));
        }else{
            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://ac-api.omsdev.in:2002/api/VendorAdmin/updateVendorAdmin',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($data),
                CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer ' . $token,
                    'Content-Type: application/json'
                ),
            ));
        }

        $response = curl_exec($curl);
        
        curl_close($curl);
        $response = json_decode($response, true);
        // dd($response);
        if ($response['status'] == 0) {
            return redirect('profile')->with('success', $response['response']);
        } else {
            // dd($response['response']);
            return redirect()->back()->with('error', $response['error']);
        
        }
    }
    
}
