<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use GuzzleHttp\Client;

class StaffController extends Controller
{
    
    private function fetchApiData($url) {
        $token = session('token');
        $curl = curl_init();
    
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $token,
                'Accept: application/json',
            ],
        ));
    
        $response = curl_exec($curl);
    
        if (curl_errno($curl)) {
            // Log cURL error
            $error_msg = curl_error($curl);
            curl_close($curl);
            dd("cURL Error: " . $error_msg);  // Temporarily dump for debugging
        }
    
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
    
        // Dump the raw response if it's not 200
        if ($httpCode !== 200) {
            dd("HTTP Code: $httpCode", $response);
        }
    
        $decoded = json_decode($response, true);
        if ($decoded === null) {
            dd("JSON Decode Error", $response);
        }
    
        return $decoded;
    }
    
    
    public function allStaff(){
        $value = session('type');
       
        if($value == 'vendor'){
            $all_designations = $this->fetchApiData('https://ac-api.omsdev.in:2003/api/master/getAllDesignation?pageNo=0&pageSize=30');
        
            if(isset($all_designations['status']) && $all_designations['status'] == 0){
                $all_designations = $all_designations['response']['dataSet'];
            }
            $counts = $this->fetchApiData('https://ac-api.omsdev.in:2003/api/vendor/getDashboard');
            $staff_counts = [];
            if(isset($counts['status']) && $counts['status'] == 0){
                $staff_counts = $counts['response'];
                return view('staffs.list', compact( 'staff_counts', 'value', 'all_designations'));
            }
        
           
    
        }else{
            $counts = $this->fetchApiData('https://ac-api.omsdev.in:2002/api/vendor/getDashboard');
            $staff_counts = [];
        
            if(isset($counts['status']) && $counts['status'] == 0){
                $staff_counts = $counts['response']['formStatus'];
            }

            $all_vendors = $this->fetchApiData('https://ac-api.omsdev.in:2002/api/vendor/getAllVendorCountByName?pageNo=0&pageSize=30&vendorName=');
        
            if(isset($all_vendors['status']) && $all_vendors['status'] == 0){
                $all_vendors = $all_vendors['response']['dataSet'];
            }

            $all_access_area = $this->fetchApiData('https://ac-api.omsdev.in:2002/api/master/getAllAccessArea?pageNo=0&pageSize=30');
        
            if(isset($all_access_area['status']) && $all_access_area['status'] == 0){
                $all_access_area = $all_access_area['response']['dataSet'];
            }

            $all_designations = $this->fetchApiData('https://ac-api.omsdev.in:2002/api/master/getAllDesignation?pageNo=0&pageSize=30');
        
            if(isset($all_designations['status']) && $all_designations['status'] == 0){
                $all_designations = $all_designations['response']['dataSet'];
            }
            
            $data = $this->fetchApiData('https://ac-api.omsdev.in:2002/api/master/getAllAccreditationType?pageNo=0&pageSize=30');
         
            if(isset($data['status']) && $data['status'] == 0){
                $accredation_types = $data['response']['dataSet'];
            //    dd($accredation_types);
                return view('staffs.list', compact('accredation_types', 'staff_counts', 'all_vendors', 'all_access_area', 'all_designations', 'value'));
            }


        }
        
        return view('staffs.list'); 
    }
    

    public function getAddStaff(){
        
        $type = session('type'); 
        $token = session('token'); 
        if($type == 'vendor'){
            $designations = $this->fetchApiData('https://ac-api.omsdev.in:2003/api/master/getAllDesignation?pageNo=0&pageSize=300');
       
            if(isset($designations['status']) && $designations['status'] == 0){
                $designations = $designations['response']['dataSet'];
            }

            $all_access_area = $this->fetchApiData('https://ac-api.omsdev.in:2003/api/master/getAllAccessArea?pageNo=0&pageSize=300');
            
            if(isset($all_access_area['status']) && $all_access_area['status'] == 0){
                $all_access_area = $all_access_area['response']['dataSet'];
            }

            $all_countries = $this->fetchApiData('https://ac-api.omsdev.in:2003/api/master/getAllCountry?pageNo=0&pageSize=300');
            
            if(isset($all_countries['status']) && $all_countries['status'] == 0){
                $all_countries = $all_countries['response']['dataSet'];
            }
        
        }else{

            $designations = $this->fetchApiData('https://ac-api.omsdev.in:2002/api/master/getAllDesignation?pageNo=0&pageSize=300');
        
            if(isset($designations['status']) && $designations['status'] == 0){
                $designations = $designations['response']['dataSet'];
            }

            $all_access_area = $this->fetchApiData('https://ac-api.omsdev.in:2002/api/master/getAllAccessArea?pageNo=0&pageSize=30');
            
            if(isset($all_access_area['status']) && $all_access_area['status'] == 0){
                $all_access_area = $all_access_area['response']['dataSet'];
            }

            $all_countries = $this->fetchApiData('https://ac-api.omsdev.in:2002/api/master/getAllCountry?pageNo=0&pageSize=300');
            
            if(isset($all_countries['status']) && $all_countries['status'] == 0){
                $all_countries = $all_countries['response']['dataSet'];
            }
        }
        // dd($all_access_area);
        return view('staffs.add', compact('designations', 'all_access_area', 'all_countries'));
    }

    public function addStaff(Request $request){
        // dd($request->all());
        
        $token = session('token'); 
        // Handle profilePicture upload
        if ($request->hasFile('profilePicture')) {
            $file = $request->file('profilePicture');
    
            $client = new Client();
    
            $response = $client->post('https://ac-api.omsdev.in:2003/api/staff/uploadImage', [
                'multipart' => [
                    [
                        'name'     => 'file',
                        'contents' => fopen($file->getPathname(), 'r'),
                        'filename' => $file->getClientOriginalName(),
                        'headers'  => [
                            'Authorization: Bearer ' . $token,
                            'Content-Type' => $file->getMimeType(),
                        ],
                    ],
                ],
            ]);
            // $image_nm = $file->getClientOriginalName();
            
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);
            $profileImage = $data['response'];
        }
        
        if ($request->hasFile('idProofFront')) {
            $file = $request->file('idProofFront');
    
            $client = new Client();
    
            $response = $client->post('https://ac-api.omsdev.in:2003/api/staff/uploadImage', [
                'multipart' => [
                    [
                        'name'     => 'file',
                        'contents' => fopen($file->getPathname(), 'r'),
                        'filename' => $file->getClientOriginalName(),
                        'headers'  => [
                            'Authorization: Bearer ' . $token,
                            'Content-Type' => $file->getMimeType(),
                        ],
                    ],
                ],
            ]);
            // $image_nm = $file->getClientOriginalName();
            
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);
        }
        $idFrontimage = $data['response'];
       
        if ($request->hasFile('idProofBack')) {
            $file = $request->file('idProofBack');
    
            $client = new Client();
    
            $response = $client->post('https://ac-api.omsdev.in:2003/api/staff/uploadImage', [
                'multipart' => [
                    [
                        'name'     => 'file',
                        'contents' => fopen($file->getPathname(), 'r'),
                        'filename' => $file->getClientOriginalName(),
                        'headers'  => [
                            'Authorization: Bearer ' . $token,
                            'Content-Type' => $file->getMimeType(),
                        ],
                    ],
                ],
            ]);
            // $image_nm = $file->getClientOriginalName();
            
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);
        }
        $idBackImage = $data['response'];
       
       
        $data = [
            "profilePicture" => $profileImage ? $profileImage :'',
            "addressLine1" => $request->addressLine1,
            "addressLine2" => $request->addressLine2,
            "city" => $request->city,
            "country" => $request->country,
            "countryCode" => $request->countryCode,
            "designationMasterId" => (int)$request->designationMasterId,
            "dob" => $request->dob,
            "email" => $request->email,
            "fatherName" => $request->fatherName,
            "firstName" => $request->first_name,
            "gender" => $request->gender,
            "idNumber" => $request->idNumber,
            "idProofBack" => $idBackImage ? $idBackImage :'',
            "idProofFront" => $idFrontimage? $idFrontimage :'',
            "idType" => $request->idType,
            "lastName" => $request->last_name,
            "middleName" => $request->middle_name,
            "onlyConcourseAccess" => $request->onlyConcourseAccess === 'true',
            "phone" => $request->phone,
            "postalCode" => $request->postalCode,
            "staffAccessAreaList" => $request->input('accessAreaId', []),
            "staffId" => (int)$request->staffId,
            "state" => $request->state
        ];
        $token = session('token');
        // dd($data);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://ac-api.omsdev.in:2003/api/staff/saveOrUpdateStaffDetails',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer ' . $token,
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        // dd($response);
        $response = json_decode($response, true);
        if ($response['status'] == 0) {
            return redirect('staff/list')->with('success', $response['response']);
        } else {
         
            return redirect()->back()->with('error', $response['response']);
        
        }
       

        
    }

    public function getUpdateStaff($staff_id){
        $type = session('type'); 
        if($type == 'vendor'){
            $staff = $this->fetchApiData("https://ac-api.omsdev.in:2003/api/staff/getStaffDetailsById?staffId=$staff_id");
       
            if(isset($staff['status']) && $staff['status'] == 0){
                $staff = $staff['response'];
            }
    
            $designations = $this->fetchApiData('https://ac-api.omsdev.in:2003/api/master/getAllDesignation?pageNo=0&pageSize=30');
            
            if(isset($designations['status']) && $designations['status'] == 0){
                $designations = $designations['response']['dataSet'];
            }
    
            $all_access_area = $this->fetchApiData('https://ac-api.omsdev.in:2003/api/master/getAllAccessArea?pageNo=0&pageSize=30');
            
            if(isset($all_access_area['status']) && $all_access_area['status'] == 0){
                $all_access_area = $all_access_area['response']['dataSet'];
            }

            $all_countries = $this->fetchApiData('https://ac-api.omsdev.in:2003/api/master/getAllCountry?pageNo=0&pageSize=300');
            
            if(isset($all_countries['status']) && $all_countries['status'] == 0){
                $all_countries = $all_countries['response']['dataSet'];
            }
            // dd($staff);
        }else{
            $staff = $this->fetchApiData("https://ac-api.omsdev.in:2002/api/staff/getStaffDetailsById?staffId=$staff_id");
       
            if(isset($staff['status']) && $staff['status'] == 0){
                $staff = $staff['response'];
            }

            $designations = $this->fetchApiData('https://ac-api.omsdev.in:2002/api/master/getAllDesignation?pageNo=0&pageSize=30');
            
            if(isset($designations['status']) && $designations['status'] == 0){
                $designations = $designations['response']['dataSet'];
            }

            $all_access_area = $this->fetchApiData('https://ac-api.omsdev.in:2002/api/master/getAllAccessArea?pageNo=0&pageSize=30');
            
            if(isset($all_access_area['status']) && $all_access_area['status'] == 0){
                $all_access_area = $all_access_area['response']['dataSet'];
            }

            $all_countries = $this->fetchApiData('https://ac-api.omsdev.in:2002/api/master/getAllCountry?pageNo=0&pageSize=300');
            
            if(isset($all_countries['status']) && $all_countries['status'] == 0){
                $all_countries = $all_countries['response']['dataSet'];
            }
        }
        
        
        return view('staffs.update', compact('designations', 'staff', 'all_access_area', 'all_countries'));
    }

    public function updateStaff(Request $request){
        // dd($request->all());
        $token = session('token');
        $profileImage = null;
        $idFrontimage = null;
        $idBackImage = null;

        if ($request->hasFile('profilePicture')) {
            $file = $request->file('profilePicture');
    
            $client = new Client();
    
            $response = $client->post('https://ac-api.omsdev.in:2003/api/staff/uploadImage', [
                'headers' => [
                        'Authorization' => 'Bearer ' . $token,
                        'Accept'        => 'application/json',
                    ],
                    'multipart' => [
                        [
                            'name'     => 'file',
                            'contents' => fopen($file->getPathname(), 'r'),
                            'filename' => $file->getClientOriginalName(),
                        ],
                    ],
            ]);
            // $image_nm = $file->getClientOriginalName();
            
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);
            $profileImage = $data['response'];
        }
        
        if ($request->hasFile('idProofFront')) {
            $file = $request->file('idProofFront');
    
            $client = new Client();
    
            $response = $client->post('https://ac-api.omsdev.in:2003/api/staff/uploadImage', [
                'multipart' => [
                    [
                        'name'     => 'file',
                        'contents' => fopen($file->getPathname(), 'r'),
                        'filename' => $file->getClientOriginalName(),
                        'headers'  => [
                            'Authorization: Bearer ' . $token,
                            'Content-Type' => $file->getMimeType(),
                        ],
                    ],
                ],
            ]);
            // $image_nm = $file->getClientOriginalName();
            
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);
            $idFrontimage = $data['response'];
        }
       
       
        if ($request->hasFile('idProofBack')) {
            $file = $request->file('idProofBack');
    
            $client = new Client();
    
            $response = $client->post('https://ac-api.omsdev.in:2003/api/staff/uploadImage', [
                'multipart' => [
                    [
                        'name'     => 'file',
                        'contents' => fopen($file->getPathname(), 'r'),
                        'filename' => $file->getClientOriginalName(),
                        'headers'  => [
                            'Authorization: Bearer ' . $token,
                            'Content-Type' => $file->getMimeType(),
                        ],
                    ],
                ],
            ]);
            // $image_nm = $file->getClientOriginalName();
            
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);
            $idBackImage = $data['response'];
        }
        
       
       
        $data = [
            "addressLine1" => $request->addressLine1,
            "addressLine2" => $request->addressLine2,
            "city" => $request->city,
            "country" => $request->country,
            "countryCode" => $request->countryCode,
            "designationMasterId" => (int)$request->designationMasterId,
            "dob" => $request->dob,
            "email" => $request->email,
            "fatherName" => $request->fatherName,
            "firstName" => $request->first_name,
            "gender" => $request->gender,
            "idNumber" => $request->idNumber,
            "idType" => $request->idType,
            "lastName" => $request->last_name,
            "middleName" => $request->middle_name,
            "onlyConcourseAccess" => $request->onlyConcourseAccess === 'true',
            "phone" => $request->phone,
            "postalCode" => $request->postalCode,
            "staffAccessAreaList" => $request->input('staffAccessAreaList', []),
            "staffId" => (int)$request->staffId,
            "state" => $request->state
        ];

        // Conditionally add images
        if ($profileImage) {
            $data['profilePicture'] = $profileImage;
        }
        if ($idFrontimage) {
            $data['idProofFront'] = $idFrontimage;
        }
        if ($idBackImage) {
            $data['idProofBack'] = $idBackImage;
        }

        // dd($data);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://ac-api.omsdev.in:2003/api/staff/saveOrUpdateStaffDetails',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer ' . $token,
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $response = json_decode($response, true);
       
        if ($response['status'] == 0) {
            return redirect('staff/list')->with('success', $response['response']);
        } else {
         
            return redirect()->back()->with('error', $response['response']);
        
        }
       
        

    }

    public function getViewStaff($staff_id){
        $staff_details = $this->fetchApiData('https://ac-api.omsdev.in:2003/api/staff/getStaffDetailsById?staffId=' . $staff_id);
        
        if(isset($staff_details['status']) && $staff_details['status'] == 0){
            $staff_details = $staff_details['response'];
        }
        // dd($staff_details);
        return view('staffs.view', compact('staff_details'));
     
    }

    public function getViewStaffAdmin($staff_id){
        $staff_details = $this->fetchApiData('https://ac-api.omsdev.in:2002/api/staff/getStaffDetailsById?staffId=' . $staff_id);
        
        if(isset($staff_details['status']) && $staff_details['status'] == 0){
            $staff_details = $staff_details['response'];
        }
        // dd($staff_details);
        return view('staffs.view_staff_admin', compact('staff_details'));
    }


    function uploadImage($filePath){
        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://ac-api.omsdev.in:2002/api/master/uploadImage',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_POSTFIELDS => array('file' => new \CURLFile($filePath)),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $decoded = json_decode($response, true);

        // Return only the image name
        return isset($decoded['response']) ? $decoded['response'] : null;
    }

    private function checkStaffLimit(){
        $staffLimit = $this->fetchApiData('https://ac-api.omsdev.in:2003/api/staff/checkMaximumStaffLimit');
       
        // if($staffLimit['status'] == 0){
        //     $staffLimit = $staffLimit['response'];
        // }
        return $staffLimit;
    }
}
