<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use GuzzleHttp\Client;

class VendorController extends Controller
{
    private function fetchApiData($url) {
        $token = session('token');
        // dd($token);
        $curl = curl_init();
    
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $token,
                'Accept: application/json',
            ],
        ));
    
        $response = curl_exec($curl);
    
        if (curl_errno($curl)) {
            // Log cURL error
            $error_msg = curl_error($curl);
            curl_close($curl);
            dd("cURL Error: " . $error_msg);  // Temporarily dump for debugging
        }
    
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
    
        // Dump the raw response if it's not 200
        if ($httpCode !== 200) {
            dd("HTTP Code: $httpCode", $response);
        }
    
        $decoded = json_decode($response, true);
        if ($decoded === null) {
            dd("JSON Decode Error", $response);
        }
    
        return $decoded;
    }

    public function allVendor(){
        return view('allvendors.list');
    }

    public function getAddVendor(){
        $token = session('token');
        $vendor_types = $this->fetchApiData('https://ac-api.omsdev.in:2002/api/master/getAllVendorType?pageNo=0&pageSize=30');
        
        if(isset($vendor_types['status']) && $vendor_types['status'] == 0){
            $vendor_types = $vendor_types['response']['dataSet'];
        }

        $access_areas = $this->fetchApiData('https://ac-api.omsdev.in:2002/api/master/getAllAccessArea?pageNo=0&pageSize=30');
        
        if(isset($access_areas['status']) && $access_areas['status'] == 0){
            $access_areas = $access_areas['response']['dataSet'];
        }

        $dashboard_data = $this->fetchApiData('https://ac-api.omsdev.in:2002/api/vendor/getDashboard');
        
        if(isset($dashboard_data['status']) && $dashboard_data['status'] == 0){
            $endDate = $dashboard_data['response']['event']['endDate'];
        }

        // dd($endDate);
        return view('allvendors.add', compact('vendor_types', 'access_areas', 'dashboard_data', 'endDate'));
    }

    public function addVendor(Request $request){
        // dd($request->all());
        $token = session('token'); 
        // Handle profilePicture upload
        

        $profileImage = null;
            // Handle profilePicture upload

        if ($request->hasFile('profilePicture')) {
            // dd($request->all());
            $file = $request->file('profilePicture');
    
            $client = new Client();
            
            $response = $client->post('https://ac-api.omsdev.in:2002/api/master/uploadImage', [
                'multipart' => [
                    [
                        'name'     => 'file',
                        'contents' => fopen($file->getRealPath(), 'r'),
                        'filename' => $file->getClientOriginalName(),
                        'headers'  => [
                            'Authorization: Bearer ' . $token,
                            'Content-Type' => $file->getMimeType(),
                        ],
                    ],
                ],
                
            ]);
            // $image_nm = $file->getClientOriginalName();
            
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);
            
            $profileImage = $data['response'];
        }

        // Example: getting image name if present
        // $newImageName = isset($data['response']) ? pathinfo($data['response'], PATHINFO_FILENAME) . '_' . rand(1000, 9999) . '.' . pathinfo($data['response'], PATHINFO_EXTENSION) : null;
        
        $data = [
            "vendorId" => 0,
            "vendorTypeId" => (int) $request->input('vendorTypeId'),
            "vendorName" => $request->input('vendorName'),
            "contactPerson" => $request->input('contactPerson'),
            "email" => $request->input('email'),
            "countryCode" => $request->input('countryCode'),
            "mobileNumber" => (int) $request->input('mobileNumber'),
            "smsSummaryFrequency" => $request->input('smsSummaryFrequency'),
            "username" => $request->input('username'),
            "password" => $request->input('password'),
            "maxStaffNumbers" => (int) $request->input('maxStaffNumbers'),
            "customDeadline" => $request->input('customDeadline'),
            "eventId" => 1,
            "isChangePassword" => true,
            "vendorAccessAreaList" => $request->input('accessAreaId', []) // pass array if applicable
        ];
        if ($profileImage) {
            $data['profilePicture'] = $profileImage;
        }
        // dd($data);
        $curl = curl_init();
    
        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://ac-api.omsdev.in:2002/api/vendor/saveOrUpdateVendor',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $token,
                'Content-Type: application/json'
            ],
        ]);
    
        $response = curl_exec($curl);
        
        curl_close($curl);
        $responseData = json_decode($response, true);
        // dd($responseData['status']);
        if ($responseData['status'] == 0) {
            return redirect()->route('vendor.list')->with('success', $responseData['response']);
        } else {
         
            return redirect()->back()->with('error', $responseData['response']);
        
        }
        
        
    }

    public function getUpdateVendor($vendor_id){
        $vendor = $this->fetchApiData("https://ac-api.omsdev.in:2002/api/vendor/getVendorById?vendorId=$vendor_id");
        
        if(isset($vendor['status']) && $vendor['status'] == 0){
            $vendor = $vendor['response'];
        }

        $vendor_types = $this->fetchApiData("https://ac-api.omsdev.in:2002/api/master/getAllVendorType?pageNo=0&pageSize=30");
        
        if(isset($vendor_types['status']) && $vendor_types['status'] == 0){
            $vendor_types = $vendor_types['response']['dataSet'];
        }
        
       
        $all_access_area = $this->fetchApiData('https://ac-api.omsdev.in:2002/api/master/getAllAccessArea?pageNo=0&pageSize=30');
        
        if(isset($all_access_area['status']) && $all_access_area['status'] == 0){
            $all_access_area = $all_access_area['response']['dataSet'];
        }

        $dashboard_data = $this->fetchApiData('https://ac-api.omsdev.in:2002/api/vendor/getDashboard');
        
        if(isset($dashboard_data['status']) && $dashboard_data['status'] == 0){
            $eventdate = $dashboard_data['response']['event']['endDate'];
            $endDate = \Carbon\Carbon::parse($eventdate)->format('Y-m-d H:i');
        }
        // dd( $endDate);
        return view('allvendors.update', compact('vendor_types', 'vendor', 'all_access_area', 'endDate'));
    }

    public function updateVendor(Request $request){

        $token = session('token'); 
        $profileImage = null;
        // Handle profilePicture upload
        if ($request->hasFile('profilePicture')) {
            // dd($request->all());
            $file = $request->file('profilePicture');
    
            $client = new Client();
            
            $response = $client->post('https://ac-api.omsdev.in:2002/api/master/uploadImage', [
                'multipart' => [
                    [
                        'name'     => 'file',
                        'contents' => fopen($file->getRealPath(), 'r'),
                        'filename' => $file->getClientOriginalName(),
                        'headers'  => [
                            'Authorization: Bearer ' . $token,
                            'Content-Type' => $file->getMimeType(),
                        ],
                    ],
                ],
                
            ]);
            // $image_nm = $file->getClientOriginalName();
            
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);
            
            $profileImage = $data['response'];
        }
        // Example: getting image name if present
        // $newImageName = isset($data['response']) ? pathinfo($data['response'], PATHINFO_FILENAME) . '_' . rand(1000, 9999) . '.' . pathinfo($data['response'], PATHINFO_EXTENSION) : null;
        
        $data = [
            "vendorId" => (int) $request->input('vendorId'),
            "vendorTypeId" => (int) $request->input('vendorTypeId'),
            "vendorName" => $request->input('vendorName'),
            "contactPerson" => $request->input('contactPerson'),
            "email" => $request->input('email'),
            "countryCode" => $request->input('countryCode'),
            "mobileNumber" => (int) $request->input('mobileNumber'),
            "smsSummaryFrequency" => $request->input('smsSummaryFrequency'),
            "username" => $request->input('username'),
            "password" => $request->input('password'),
            "maxStaffNumbers" => (int) $request->input('maxStaffNumbers'),
            "customDeadline" => $request->input('customDeadline'),
            "eventId" => 1,
            "isChangePassword" => true,
            
            "vendorAccessAreaList" => $request->input('accessAreaId', []) // pass array if applicable
        ];

        if ($profileImage) {
            $data['profilePicture'] = $profileImage;
        }
        // dd($data);
        $curl = curl_init();
    
        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://ac-api.omsdev.in:2002/api/vendor/saveOrUpdateVendor',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $token,
                'Content-Type: application/json'
            ],
        ]);
    
        $response = curl_exec($curl);
        
        if (curl_errno($curl)) {
            // Log cURL error
            $error_msg = curl_error($curl);
            curl_close($curl);
            dd("cURL Error: " . $error_msg);  // Temporarily dump for debugging
        }
    
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
    
        // Dump the raw response if it's not 200
        if ($httpCode !== 200) {
            dd("HTTP Code: $httpCode", $response);
        }
    
        $decoded = json_decode($response, true);
        if ($decoded === null) {
            dd("JSON Decode Error", $response);
        }
        if($decoded['status'] != 0){
            return redirect()->back()->with('error', $decoded['response']);
        }
                
        return redirect('vendor/list');
    }

    public function getVendorTypes(){
        $vendor_types = $this->fetchApiData("https://ac-api.omsdev.in:2002/api/master/getAllVendorType?pageNo=0&pageSize=30");
       
        if(isset($vendor_types['status']) && $vendor_types['status'] == 0){
            $vendor_types = $vendor_types['response']['dataSet'];
        }
        // dd($vendor_types);
        
        return view('allvendors.vendor_types', compact('vendor_types'));
    }

    public function deleteVendor($id){
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://ac-api.omsdev.in:2002/api/vendor/deleteVendorById?vendorId={$id}",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'DELETE',
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        $json = json_decode($response, true);


        if (isset($json['status']) && $json['status'] == 0) {
            return redirect()->back()->with('success', 'Vendor deleted successfully.');
        } else {
            return redirect()->back()->with('error', 'Failed to delete vendor.');
        }
    }

    function uploadImage($filePath){
        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://ac-api.omsdev.in:2002/api/master/uploadImage',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_POSTFIELDS => array('file' => new \CURLFile($filePath)),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $decoded = json_decode($response, true);

        // Return only the image name
        return isset($decoded['response']) ? $decoded['response'] : null;
    }
}
