@extends('layouts.app')
@section('content')


    <!-- Main Content Wrapper -->
      <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <div class="flex items-center justify-between flex-wrap py-5 lg:py-6">
          <!-- Left side: Heading + Breadcrumbs -->
            <div class="flex items-center space-x-4">
                <h2 class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl">
                    All Vendors
                </h2>
                <div class="hidden h-full py-1 sm:flex">
                    <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
                </div>
                <ul class="hidden flex-wrap items-center space-x-2 sm:flex">
                    <li class="flex items-center space-x-2">
                        <a class="text-primary transition-colors hover:text-primary-focus dark:text-accent-light dark:hover:text-accent" href="#">
                            Vendors
                        </a>
                        <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                        </svg>
                    </li>
                    <li>List</li>
                </ul>
            </div>

            <!-- Right side: Add button -->
            <a href="{{ route('vendor.add') }}">
                <button class="btn px-3 py-1.5 text-sm space-x-2 bg-primary font-medium text-white shadow-md shadow-primary/40 hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:shadow-accent/40 dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 text-indigo-50" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                    </svg>
                    <span>Add</span>
                </button>
            </a>
        </div>
          <div class="card mt-3">
              <div class="is-scrollbar-hidden min-w-full overflow-x-auto">
                <table class="is-hoverable w-full text-left">
                  <thead>
                    <tr>
                      
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Date
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Vendor Name
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Form Limit
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Saved
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        All Approved 
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Submitted
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Pending
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Incorrect
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Rejected
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Verified
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Approved
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Printed
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Reprinted
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Action
                      </th>

                      
                    </tr>
                  </thead>
                  <tbody id="vendor-list">
                    <!-- <tr class="border-y border-transparent border-b-slate-200 dark:border-b-navy-500">
                      
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p class="font-medium">25 May 2021</p>
                        <p class="mt-0.5 text-xs">01:25 AM</p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <div class="flex items-center space-x-4">
                          <div class="avatar size-9">
                            <img
                              class="mask is-squircle"
                              src="{{url('images/200x200.png')}}"
                              alt="avatar"
                            />
                          </div>

                          <span
                            class="font-medium text-slate-700 dark:text-navy-100"
                            >Anthony Jensen
                          </span>
                        </div>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>

                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          0
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          0
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          0
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          0
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          0
                        </p>
                      </td>
                      <td data-column-id="actions" class="gridjs-td"><span><div class="flex justify-center space-x-2">
                            <button @click="editItem" class="btn size-8 p-0 text-info hover:bg-info/20 focus:bg-info/20 active:bg-info/25">
                                <i class="fa fa-edit"></i>
                            </button>
                            <button @click="deleteItem" class="btn size-8 p-0 text-error hover:bg-error/20 focus:bg-error/20 active:bg-error/25">
                                <i class="fa fa-trash-alt"></i>
                            </button>
                        </div></span>
                      </td>
                      
                    </tr> -->
                    
                  </tbody>
                </table>
              </div>
              <div
                class="flex flex-col justify-between space-y-4 px-4 py-4 sm:flex-row sm:items-center sm:space-y-0 sm:px-5"
                >
                <div id="entry-range" class="text-xs-plus">1 - 10 of 10 entries</div>
                <!-- Page numbers -->
                <ol id="pagination" class="pagination">
                    <!-- JS will populate -->
                </ol>

                <!-- Info -->
                <div id="pagination-info" class="text-xs-plus">
                    <!-- JS will populate -->
                </div>
              </div>
            </div>
      </main>
      
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

<script>
  let currentPage = 1;
  let pageSize = 10;
  let totalEntries = 0;

  document.addEventListener('DOMContentLoaded', () => {
    loadPage(currentPage);
  });
  const token = "{{ session('token') }}";
  function loadPage(page) {
    fetch(`https://ac-api.omsdev.in:2002/api/vendor/getAllVendorCountByName?pageNo=${page - 1}&pageSize=${pageSize}&vendorName=`, {
          method: 'GET',
          headers: {
              'Authorization': `Bearer ${token}`,
              'Accept': 'application/json'
          }
      })
      .then(res => res.json())
      .then(json => {
        if (json.status !== 0) throw new Error('API error');
        const resp = json.response;
        totalEntries = resp.totalElements;
        renderTable(resp.dataSet);
        renderPagination(resp.totalPages);
        updateEntryRange(); 
      })
      .catch(err => console.error(err));
  }

  function renderTable(rows) {
    const tbody = document.getElementById('vendor-list');
    tbody.innerHTML = '';
    rows.forEach((item) => {
      const createdAt = item.createdAt ? new Date(item.createdAt).toLocaleString('en-GB') : 'N/A';
      const fullName = item.vendorName;
      const imageUrl = item.profilePicture || 'https://via.placeholder.com/50';

      tbody.insertAdjacentHTML('beforeend', `
        <tr class="border-y border-transparent border-b-slate-200 dark:border-b-navy-500">
          <td class="whitespace-nowrap px-4 py-3 sm:px-5">
            <p class="font-medium">${createdAt.split(',')[0]}</p>
            <p class="mt-0.5 text-xs">${createdAt.split(',')[1] || ''}</p>
          </td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5">
            <div class="flex items-center space-x-4">
              <div class="avatar size-9">
                <img class="mask is-squircle" src="${imageUrl}" alt="avatar" />
              </div>
              <span class="font-medium text-slate-700 dark:text-navy-100">${fullName}</span>
            </div>
          </td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5"><p class="text-sm-plus font-medium">${item.formLimit ?? 0}</p></td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5"><p class="text-sm-plus font-medium">${item.saved ?? 0}</p></td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5"><p class="text-sm-plus font-medium">${item.allApproved ?? 0}</p></td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5"><p class="text-sm-plus font-medium">${item.submitted ?? 0}</p></td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5"><p class="text-sm-plus font-medium">${item.pending ?? 0}</p></td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5"><p class="text-sm-plus font-medium">${item.incorrect ?? 0}</p></td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5"><p class="text-sm-plus font-medium">${item.rejected ?? 0}</p></td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5"><p class="text-sm-plus font-medium">${item.verified ?? 0}</p></td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5"><p class="text-sm-plus font-medium">${item.approved ?? 0}</p></td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5"><p class="text-sm-plus font-medium">${item.printed ?? 0}</p></td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5"><p class="text-sm-plus font-medium">${item.reprinted ?? 0}</p></td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5">
            <div class="flex justify-center space-x-2">
              <a href="/vendor/update/${item.vendorId}">
                <button class="btn size-8 p-0 text-info hover:bg-info/20">
                  <i class="fa fa-edit"></i>
                </button>
              </a>
              
                <button onclick="confirmDelete(${item.vendorId})" class="btn size-8 p-0 text-error hover:bg-error/20">
                  <i class="fa fa-trash-alt"></i>
                </button>
              
            </div>
          </td>
        </tr>
      `);
    });
  }

  function confirmDelete(id) {
            if (confirm("Are you sure you want to delete this vendor?")) {
                window.location.href = "{{ url('/vendor/delete') }}/" + id;
            }
        }

  function renderPagination(totalPages) {
    const ol = document.getElementById('pagination');
    ol.innerHTML = '';

    // Previous Button
    ol.insertAdjacentHTML('beforeend', `
      <li>
        <a href="#" onclick="if(currentPage > 1){ currentPage--; loadPage(currentPage); } return false;"
          class="flex size-8 items-center justify-center rounded-full bg-slate-150 text-slate-500 hover:bg-slate-300 dark:bg-navy-500 dark:text-navy-200">
          <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
          </svg>
        </a>
      </li>
    `);

    // Page Numbers
    for (let i = 1; i <= totalPages; i++) {
      const isActive = currentPage === i;
      ol.insertAdjacentHTML('beforeend', `
        <li>
          <a href="#" onclick="currentPage=${i}; loadPage(currentPage); return false;"
            class="flex h-8 min-w-[2rem] items-center justify-center rounded-full ${isActive ? 'bg-primary text-white' : 'bg-slate-150 text-slate-700'} px-3 leading-tight hover:bg-slate-300">
            ${i}
          </a>
        </li>
      `);
    }

    // Next Button
    ol.insertAdjacentHTML('beforeend', `
      <li>
        <a href="#" onclick="if(currentPage < ${totalPages}){ currentPage++; loadPage(currentPage); } return false;"
          class="flex size-8 items-center justify-center rounded-full bg-slate-150 text-slate-500 hover:bg-slate-300 dark:bg-navy-500 dark:text-navy-200">
          <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
          </svg>
        </a>
      </li>
    `);
  }

  function updateEntryRange() {
  const start = (currentPage - 1) * pageSize + 1;
  const end = Math.min(currentPage * pageSize, totalEntries);
  let rangeText = '';

  if (totalEntries === 0) {
    rangeText = '0 entries';
  } else if (start === end) {
    // When only one entry is shown on the page
    rangeText = `Showing entry ${start} of ${totalEntries} entries`;
  } else {
    rangeText = `${start} - ${end} of ${totalEntries} entries`;
  }

  document.getElementById('entry-range').textContent = rangeText;
}


</script>



@endsection