@extends('layouts.app')
@section('content')
    <!-- Main Content Wrapper -->
    <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <div class="flex items-center justify-between flex-wrap py-5 lg:py-6">
            <!-- Left side: Heading + Breadcrumbs -->
            <div class="flex items-center space-x-4">
                <h2 class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl">
                    All Inventory
                </h2>
                <div class="hidden h-full py-1 sm:flex">
                    <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
                </div>
                <ul class="hidden flex-wrap items-center space-x-2 sm:flex">
                    <li class="flex items-center space-x-2">
                        <a class="text-primary transition-colors hover:text-primary-focus dark:text-accent-light dark:hover:text-accent" href="#">
                            Inventories
                        </a>
                        <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                        </svg>
                    </li>
                    <li>List</li>
                </ul>
            </div>

           
        </div>
        <form action="{{ url('/inventory/add') }}" method="post" enctype="multipart/form-data">
        @csrf
        <!-- Inventory Table -->
        <div class="card mt-3">
            <div class="is-scrollbar-hidden min-w-full overflow-x-auto">
                <table class="is-hoverable w-full text-left" id="designation-table">
                    <thead>
                        <tr>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Type</th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Total Stock</th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Used</th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Available</th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">New Stock</th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Total</th>

                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Date</th>
                        </tr>
                    </thead>
                    <tbody id="designation-list">
                        <!-- rows injected by JS -->
                        @foreach($inventory as $index => $type)
                        <tr>
                            {{-- Accreditation Type Name (readonly) --}}
                            <td class="whitespace-nowrap px-2 py-2 sm:px-3 lg:px-5">
                                <input
                                    type="hidden"
                                    name="inventory[{{ $index }}][accreditationTypeId]"
                                    value="{{ $type['accreditationTypeId'] }}"
                                />
                                <input
                                    class="form-input mt-1.5 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    type="text"
                                    value="{{ $type['accreditationType'] }}"
                                    readonly
                                />
                            </td>

                            {{-- Total Stock --}}
                            <td class="whitespace-nowrap px-2 py-2 sm:px-3 lg:px-5">
                                <span class="font-medium text-slate-700 dark:text-navy-100">{{ $type['totalStock'] }}</span>
                                <input type="hidden" name="inventory[{{ $index }}][totalStock]" value="{{ $type['totalStock'] }}" />
                            </td>

                            {{-- Used Stock --}}
                            <td class="whitespace-nowrap px-2 py-2 sm:px-3 lg:px-5">
                                <span class="font-medium text-slate-700 dark:text-navy-100">{{ $type['usedStock'] }}</span>
                                <input type="hidden" value="{{ $type['usedStock'] }}" />
                            </td>

                            {{-- Available Stock --}}
                            <td class="whitespace-nowrap px-2 py-2 sm:px-3 lg:px-5">
                                <span class="font-medium text-slate-700 dark:text-navy-100">{{ $type['availableStock'] }}</span>
                                <input type="hidden"  value="{{ $type['availableStock'] }}" />
                            </td>

                            {{-- New Stock (Editable) --}}
                            <td class="whitespace-nowrap px-2 py-2 sm:px-3 lg:px-5">
                                <input
                                    name="inventory[{{ $index }}][newStock]"
                                    class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="Enter stock"
                                    type="number"
                                    value="0"
                                />
                            </td>

                            {{-- Update Total Stock (Editable) --}}
                            <td class="whitespace-nowrap px-2 py-2 sm:px-3 lg:px-5">
                                <input
                                    name="inventory[{{ $index }}][updatedTotalStock]"
                                    class="form-input mt-1.5 w-full  bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="Enter total"
                                    type="text"
                                    value="{{ $type['updatedTotalStock'] }}" readonly style="var(--color-slate-700);"
                                />
                            </td>

                            {{-- Last Inventory Date --}}
                            <td class="whitespace-nowrap px-2 py-2 sm:px-3 lg:px-5">
                                <input
                                    type="text"
                                    name="inventory[{{ $index }}][lastInventoryDate]"
                                    class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 text-slate-700 dark:text-navy-100"
                                    value="{{ $type['lastInventoryDate'] }}"
                                    readonly
                                />
                                <input type="hidden" name="inventory[{{ $index }}][inventoryId]" value="{{ $type['inventoryId'] }}" />
                            </td>
                        </tr>
                        @endforeach


                    </tbody>
                </table>
            </div>
        </div>

        <div class="flex justify-end space-x-2 mt-6">
            <button
                type="submit"
                class="btn min-w-[7rem] bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
                >
              Save
            </button>
        </div>
        </form>
    </main>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
        const rows = document.querySelectorAll('tr');

        rows.forEach((row) => {
            const newStockInput = row.querySelector('input[name*="[newStock]"]');
            const totalStockInput = row.querySelector('input[name*="[totalStock]"]');
            const updateTotalStockInput = row.querySelector('input[name*="[updatedTotalStock]"]');
            const lastInventoryDate = row.querySelector('input[name*="[lastInventoryDate]"]');
            if (newStockInput && totalStockInput && updateTotalStockInput && lastInventoryDate) {
                newStockInput.addEventListener('input', () => {
                    const totalStock = parseInt(totalStockInput.value) || 0;
                    const newStock = parseInt(newStockInput.value) || 0;
                    updateTotalStockInput.value = totalStock + newStock;

                    // ✅ Update lastInventoryDate with today's date (in YYYY-MM-DD format)
                    const today = new Date();
                    const formattedDate = today.toISOString().split('T')[0];
                    lastInventoryDate.value = formattedDate;
                });
            }
        });
    });
</script>

    <!-- <script>
        let currentPage = 1;
        let pageSize = 10;
        let totalEntries = 0;

        document.addEventListener('DOMContentLoaded', () => {
            loadPage(currentPage);
            document.getElementById('entries-select').addEventListener('change', (e) => {
                pageSize = parseInt(e.target.value, 10);
                currentPage = 1;
                loadPage(currentPage);
            });
        });

        function loadPage(page) {
            const token = "{{ session('token') }}";
            fetch(`https://ac-api.omsdev.in:2002/api/master/getAllDesignation?pageNo=${page - 1}&pageSize=${pageSize}`, {
                    method: 'GET',
                    headers: {
                        'Authorization': `Bearer ${token}`,
                        'Accept': 'application/json'
                    }
                })
                .then(res => res.json())
                .then(json => {
                    if (json.status !== 0) throw new Error('API error');
                    const resp = json.response;
                    totalEntries = resp.totalElements;
                    renderTable(resp.dataSet);
                    renderPagination(resp.totalPages);
                    renderInfo(page);
                })
                .catch(err => console.error(err));
        }

        function renderTable(rows) {
            const tbody = document.getElementById('designation-list');
            tbody.innerHTML = '';
            rows.forEach(item => {
                const d = new Date(item.updatedAt);
                const date = d.toLocaleDateString('en-GB',{day:'2-digit',month:'short',year:'numeric'});
                const time = d.toLocaleTimeString('en-GB',{hour:'2-digit',minute:'2-digit'});
                const status = item.isActive ? 'Active' : 'Inactive';

                tbody.insertAdjacentHTML('beforeend', `
                    <tr class="border-y border-transparent border-b-slate-200 dark:border-b-navy-500">
                      <td class="whitespace-nowrap px-2 py-2 sm:px-3 lg:px-5">
                        <p class="font-medium">${date}</p>
                        <p class="mt-0.5 text-xs">${time}</p>
                      </td>
                      <td class="whitespace-nowrap px-2 py-2 sm:px-3 lg:px-5">
                        <span class="font-medium text-slate-700 dark:text-navy-100">${item.designationName}</span>
                      </td>
                      <td class="whitespace-nowrap px-2 py-2 sm:px-3 lg:px-5">
                        <label class="inline-flex items-center space-x-2">
                            <input
                                class="form-switch h-5 w-10 rounded-full bg-slate-300 before:rounded-full before:bg-slate-50 checked:!bg-success checked:before:bg-white dark:bg-navy-900 dark:before:bg-navy-300 dark:checked:before:bg-white"
                                type="checkbox"
                                ${item.isActive ? 'checked' : ''}
                                onchange="updateStatus(this.checked, '${item.designationMasterId}')"
                                />

                        </label>
                      </td>
                      <td class="whitespace-nowrap px-2 py-2 sm:px-3 lg:px-5">
                        <div class="flex space-x-2">
                          <a href="/designations/update/${item.designationMasterId}" class="btn size-8 p-0 text-info hover:bg-info/20">
                            <i class="fa fa-edit"></i>
                          </a>
                          <button onclick="confirmDelete(${item.designationMasterId})" class="btn size-8 p-0 text-error hover:bg-error/20">
                            <i class="fa fa-trash-alt"></i>
                          </button>
                        </div>
                      </td>
                    </tr>
                `);
            });
        }

        function renderPagination(totalPages) {
            const ol = document.getElementById('pagination');
            ol.innerHTML = '';

            // Prev
            ol.insertAdjacentHTML('beforeend', `
              <li class="rounded-l-lg bg-slate-150 dark:bg-navy-500">
                <a href="#" class="flex size-8 items-center justify-center rounded-lg text-slate-500 transition-colors hover:bg-slate-300" ${currentPage===1?' tabindex="-1" aria-disabled="true"':''}
                   onclick="if(currentPage>1){ currentPage--; loadPage(currentPage);} return false;">
                  <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                  </svg>
                </a>
              </li>
            `);

            // Numbers
            for (let i = 1; i <= totalPages; i++) {
                ol.insertAdjacentHTML('beforeend', `
                  <li class="bg-slate-150 dark:bg-navy-500">
                    <a href="#" class="flex h-8 min-w-[2rem] items-center justify-center rounded-lg px-3 leading-tight transition-colors ${i===currentPage?' bg-primary text-white':''} hover:bg-slate-300"
                       onclick="currentPage=${i}; loadPage(${i}); return false;">
                      ${i}
                    </a>
                  </li>
                `);
            }

            // Next
            ol.insertAdjacentHTML('beforeend', `
              <li class="rounded-r-lg bg-slate-150 dark:bg-navy-500">
                <a href="#" class="flex size-8 items-center justify-center rounded-lg text-slate-500 transition-colors hover:bg-slate-300" ${currentPage===totalPages?' tabindex="-1" aria-disabled="true"':''}
                   onclick="if(currentPage<${totalPages}){ currentPage++; loadPage(currentPage);} return false;">
                  <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                  </svg>
                </a>
              </li>
            `);
        }

        function renderInfo(page) {
            const start = (page - 1) * pageSize + 1;
            const end = Math.min(page * pageSize, totalEntries);
            document.getElementById('pagination-info').textContent =
              `${start} - ${end} of ${totalEntries} entries`;
        }

        function confirmDelete(id) {
            if (confirm("Are you sure you want to delete this designation?")) {
                window.location.href = "{{ url('/designations/delete') }}/" + id;
            }
        }

        function updateStatus(isChecked, roleId) {
            const token = "{{ session('token') }}";
            fetch(`https://ac-api.omsdev.in:2002/api/master/changeStatusDesignation?roleId=${roleId}`, {
                method: 'PUT',
                headers: {
                    'Authorization': `Bearer ${token}`,
                    'Content-Type': 'application/json'
                }
            })
            .then(response => {
                if (!response.ok) throw new Error('Failed');
                return response.json();
            })
            .then(data => {
                alert('Status updated successfully');
                // Reload the updated table data
                loadPage(currentPage);

            })
            .catch(error => {
                console.error('Error updating status:', error);
                alert('Failed to update status');
            });
        }
    </script> -->
@endsection
