@php
    $userType = session('type');
    $userName = session('name');
    $profilePicture = session('profilePicture');
@endphp       
       <!-- Sidebar -->
        <div class="sidebar print:hidden">
            <!-- Main Sidebar -->
            <div class="main-sidebar">
            <div
                class="flex h-full w-full flex-col items-center border-r border-slate-150 bg-white dark:border-navy-700 dark:bg-navy-800"
                >
                <!-- Application Logo -->
                @if($userType === 'vendor')
                <div class="flex pt-4">
                <a href="{{route('vendor_dashboard')}}">
                    <img
                    class="size-11 transition-transform duration-500 ease-in-out hover:rotate-[360deg]"
                    src="{{url('images/logo3.png')}}"
                    alt="logo"
                    />
                </a>
                </div>
                @else
                <div class="flex pt-4">
                <a href="{{route('dashboard')}}">
                    <img
                    class="size-11 transition-transform duration-500 ease-in-out hover:rotate-[360deg]"
                    src="{{url('images/logo3.png')}}"
                    alt="logo"
                    />
                </a>
                </div>
                @endif

                <!-- Main Sections Links -->
                <div
                class="is-scrollbar-hidden flex grow flex-col space-y-4 overflow-y-auto pt-6"
                >
                @if($userType === 'vendor_admin')
                
                <!-- Dashobards -->
                <a
                    href="{{route('dashboard')}}"
                    class="flex size-11 items-center justify-center rounded-lg 
                    active:bg-primary/25 outline-hidden transition-colors duration-200 hover:bg-primary/20 
                    focus:bg-primary/20  dark:bg-navy-600 dark:text-accent-light 
                    dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90 
                    {{request()->is('index') ? 'bg-primary/10  text-primary' : ''}}"
                    x-tooltip.placement.right="'Dashboards'"
                 >
                    <svg
                    class="size-7"
                    xmlns="http://www.w3.org/2000/svg"
                    fill="none"
                    viewBox="0 0 24 24"
                    >
                    <path
                        fill="currentColor"
                        fill-opacity=".3"
                        d="M5 14.059c0-1.01 0-1.514.222-1.945.221-.43.632-.724 1.453-1.31l4.163-2.974c.56-.4.842-.601 1.162-.601.32 0 .601.2 1.162.601l4.163 2.974c.821.586 1.232.88 1.453 1.31.222.43.222.935.222 1.945V19c0 .943 0 1.414-.293 1.707C18.414 21 17.943 21 17 21H7c-.943 0-1.414 0-1.707-.293C5 20.414 5 19.943 5 19v-4.94Z"
                    />
                    <path
                        fill="currentColor"
                        d="M3 12.387c0 .267 0 .4.084.441.084.041.19-.04.4-.204l7.288-5.669c.59-.459.885-.688 1.228-.688.343 0 .638.23 1.228.688l7.288 5.669c.21.163.316.245.4.204.084-.04.084-.174.084-.441v-.409c0-.48 0-.72-.102-.928-.101-.208-.291-.355-.67-.65l-7-5.445c-.59-.459-.885-.688-1.228-.688-.343 0-.638.23-1.228.688l-7 5.445c-.379.295-.569.442-.67.65-.102.208-.102.448-.102.928v.409Z"
                    />
                    <path
                        fill="currentColor"
                        d="M11.5 15.5h1A1.5 1.5 0 0 1 14 17v3.5h-4V17a1.5 1.5 0 0 1 1.5-1.5Z"
                    />
                    <path
                        fill="currentColor"
                        d="M17.5 5h-1a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 .5.5h1a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5Z"
                    />
                    </svg>
                </a>
                
                <!-- Masters -->
                 <a
                    href="{{ url('accredation-types/list') }}"
                    class="flex size-11 items-center justify-center rounded-lg outline-hidden transition-colors duration-200 hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
                    x-tooltip.placement.right="'Masters'"
                    >
                    <svg
                    class="size-7"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                    >
                    <path
                        d="M13.3111 14.75H5.03356C3.36523 14.75 2.30189 12.9625 3.10856 11.4958L5.24439 7.60911L7.24273 3.96995C8.07689 2.45745 10.2586 2.45745 11.0927 3.96995L13.1002 7.60911L14.0627 9.35995L15.2361 11.4958C16.0427 12.9625 14.9794 14.75 13.3111 14.75Z"
                        fill="currentColor"
                    />
                    <path
                        fill-opacity="0.3"
                        d="M21.1667 15.2083C21.1667 18.4992 18.4992 21.1667 15.2083 21.1667C11.9175 21.1667 9.25 18.4992 9.25 15.2083C9.25 15.0525 9.25917 14.9058 9.26833 14.75H13.3108C14.9792 14.75 16.0425 12.9625 15.2358 11.4958L14.0625 9.36C14.4292 9.28666 14.8142 9.25 15.2083 9.25C18.4992 9.25 21.1667 11.9175 21.1667 15.2083Z"
                        fill="currentColor"
                    />
                    </svg>
                </a>
               
                <!-- Inventory -->
                <a href="{{ url('inventory/list') }}"
                    class="flex size-11 items-center justify-center rounded-lg 
                    active:bg-primary/25 outline-hidden transition-colors duration-200 hover:bg-primary/20 
                    focus:bg-primary/20  dark:bg-navy-600 dark:text-accent-light 
                    dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90 
                    {{request()->is('inventory/list') ? 'bg-primary/10  text-primary' : ''}}"                    
                    x-tooltip.placement.right="'Inventory'">

                    <svg class="h-7 w-7" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path fill-opacity="0.25" d="M21.0001 16.05V18.75C21.0001 20.1 20.1001 21 18.7501 21H6.6001C6.9691 21 7.3471 20.946 7.6981 20.829C7.7971 20.793 7.89609 20.757 7.99509 20.712C8.31009 20.586 8.61611 20.406 8.88611 20.172C8.96711 20.109 9.05711 20.028 9.13811 19.947L9.17409 19.911L15.2941 13.8H18.7501C20.1001 13.8 21.0001 14.7 21.0001 16.05Z" fill="currentColor"></path>
                  <path fill-opacity="0.5" d="M17.7324 11.361L15.2934 13.8L9.17334 19.9111C9.80333 19.2631 10.1993 18.372 10.1993 17.4V8.70601L12.6384 6.26701C13.5924 5.31301 14.8704 5.31301 15.8244 6.26701L17.7324 8.17501C18.6864 9.12901 18.6864 10.407 17.7324 11.361Z" fill="currentColor"></path>
                  <path d="M7.95 3H5.25C3.9 3 3 3.9 3 5.25V17.4C3 17.643 3.02699 17.886 3.07199 18.12C3.09899 18.237 3.12599 18.354 3.16199 18.471C3.20699 18.606 3.252 18.741 3.306 18.867C3.315 18.876 3.31501 18.885 3.31501 18.885C3.32401 18.885 3.32401 18.885 3.31501 18.894C3.44101 19.146 3.585 19.389 3.756 19.614C3.855 19.731 3.95401 19.839 4.05301 19.947C4.15201 20.055 4.26 20.145 4.377 20.235L4.38601 20.244C4.61101 20.415 4.854 20.559 5.106 20.685C5.115 20.676 5.11501 20.676 5.11501 20.685C5.25001 20.748 5.385 20.793 5.529 20.838C5.646 20.874 5.76301 20.901 5.88001 20.928C6.11401 20.973 6.357 21 6.6 21C6.969 21 7.347 20.946 7.698 20.829C7.797 20.793 7.89599 20.757 7.99499 20.712C8.30999 20.586 8.61601 20.406 8.88601 20.172C8.96701 20.109 9.05701 20.028 9.13801 19.947L9.17399 19.911C9.80399 19.263 10.2 18.372 10.2 17.4V5.25C10.2 3.9 9.3 3 7.95 3ZM6.6 18.75C5.853 18.75 5.25 18.147 5.25 17.4C5.25 16.653 5.853 16.05 6.6 16.05C7.347 16.05 7.95 16.653 7.95 17.4C7.95 18.147 7.347 18.75 6.6 18.75Z" fill="currentColor"></path>
                </svg>
                </a>

                <a href="{{ url('vendor/list') }}"
                    class="flex size-11 items-center justify-center rounded-lg 
                    active:bg-primary/25 outline-hidden transition-colors duration-200 hover:bg-primary/20 
                    focus:bg-primary/20  dark:bg-navy-600 dark:text-accent-light 
                    dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90 
                    {{request()->is('vendor/list') ? 'bg-primary/10  text-primary' : ''}}"                    
                    x-tooltip.placement.right="'Vendors'">

                    <svg
                    class="size-7"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                    >
                    <path
                        d="M9.85714 3H4.14286C3.51167 3 3 3.51167 3 4.14286V9.85714C3 10.4883 3.51167 11 4.14286 11H9.85714C10.4883 11 11 10.4883 11 9.85714V4.14286C11 3.51167 10.4883 3 9.85714 3Z"
                        fill="currentColor"
                    />
                    <path
                        d="M9.85714 12.8999H4.14286C3.51167 12.8999 3 13.4116 3 14.0428V19.757C3 20.3882 3.51167 20.8999 4.14286 20.8999H9.85714C10.4883 20.8999 11 20.3882 11 19.757V14.0428C11 13.4116 10.4883 12.8999 9.85714 12.8999Z"
                        fill="currentColor"
                        fill-opacity="0.3"
                    />
                    <path
                        d="M19.757 3H14.0428C13.4116 3 12.8999 3.51167 12.8999 4.14286V9.85714C12.8999 10.4883 13.4116 11 14.0428 11H19.757C20.3882 11 20.8999 10.4883 20.8999 9.85714V4.14286C20.8999 3.51167 20.3882 3 19.757 3Z"
                        fill="currentColor"
                        fill-opacity="0.3"
                    />
                    <path
                        d="M19.757 12.8999H14.0428C13.4116 12.8999 12.8999 13.4116 12.8999 14.0428V19.757C12.8999 20.3882 13.4116 20.8999 14.0428 20.8999H19.757C20.3882 20.8999 20.8999 20.3882 20.8999 19.757V14.0428C20.8999 13.4116 20.3882 12.8999 19.757 12.8999Z"
                        fill="currentColor"
                        fill-opacity="0.3"
                    />
                    </svg>
                </a>

                @endif
                @if($userType === 'vendor')
                <!-- Dashobards -->
                <a
                    href="{{route('vendor_dashboard')}}"
                    class="flex size-11 items-center justify-center rounded-lg 
                    active:bg-primary/25 outline-hidden transition-colors duration-200 hover:bg-primary/20 
                    focus:bg-primary/20  dark:bg-navy-600 dark:text-accent-light 
                    dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90 
                    {{request()->is('index') ? 'bg-primary/10  text-primary' : ''}}"
                    x-tooltip.placement.right="'Dashboards'"
                 >
                    <svg
                    class="size-7"
                    xmlns="http://www.w3.org/2000/svg"
                    fill="none"
                    viewBox="0 0 24 24"
                    >
                    <path
                        fill="currentColor"
                        fill-opacity=".3"
                        d="M5 14.059c0-1.01 0-1.514.222-1.945.221-.43.632-.724 1.453-1.31l4.163-2.974c.56-.4.842-.601 1.162-.601.32 0 .601.2 1.162.601l4.163 2.974c.821.586 1.232.88 1.453 1.31.222.43.222.935.222 1.945V19c0 .943 0 1.414-.293 1.707C18.414 21 17.943 21 17 21H7c-.943 0-1.414 0-1.707-.293C5 20.414 5 19.943 5 19v-4.94Z"
                    />
                    <path
                        fill="currentColor"
                        d="M3 12.387c0 .267 0 .4.084.441.084.041.19-.04.4-.204l7.288-5.669c.59-.459.885-.688 1.228-.688.343 0 .638.23 1.228.688l7.288 5.669c.21.163.316.245.4.204.084-.04.084-.174.084-.441v-.409c0-.48 0-.72-.102-.928-.101-.208-.291-.355-.67-.65l-7-5.445c-.59-.459-.885-.688-1.228-.688-.343 0-.638.23-1.228.688l-7 5.445c-.379.295-.569.442-.67.65-.102.208-.102.448-.102.928v.409Z"
                    />
                    <path
                        fill="currentColor"
                        d="M11.5 15.5h1A1.5 1.5 0 0 1 14 17v3.5h-4V17a1.5 1.5 0 0 1 1.5-1.5Z"
                    />
                    <path
                        fill="currentColor"
                        d="M17.5 5h-1a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 .5.5h1a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5Z"
                    />
                    </svg>
                </a>
                @endif
                <!-- Staffs -->
                <a
                    href="{{ url('staff/list') }}"
                    class="flex size-11 items-center justify-center rounded-lg 
                    active:bg-primary/25 outline-hidden transition-colors duration-200 hover:bg-primary/20 
                    focus:bg-primary/20  dark:bg-navy-600 dark:text-accent-light 
                    dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90 
                    {{request()->is('staff/list') ? 'bg-primary/10  text-primary' : ''}}" 
                    x-tooltip.placement.right="'Staffs'"
                 >
                    <svg
                    class="size-7"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                    >
                    <path
                        fill-opacity="0.5"
                        d="M14.2498 16C14.2498 17.5487 13.576 18.9487 12.4998 19.9025C11.5723 20.7425 10.3473 21.25 8.99976 21.25C6.10351 21.25 3.74976 18.8962 3.74976 16C3.74976 13.585 5.39476 11.5375 7.61726 10.9337C8.22101 12.4562 9.51601 13.6287 11.1173 14.0662C11.5548 14.1887 12.0185 14.25 12.4998 14.25C12.981 14.25 13.4448 14.1887 13.8823 14.0662C14.1185 14.6612 14.2498 15.3175 14.2498 16Z"
                        fill="currentColor"
                    />
                    <path
                        d="M17.75 9.00012C17.75 9.68262 17.6187 10.3389 17.3825 10.9339C16.7787 12.4564 15.4837 13.6289 13.8825 14.0664C13.445 14.1889 12.9813 14.2501 12.5 14.2501C12.0187 14.2501 11.555 14.1889 11.1175 14.0664C9.51625 13.6289 8.22125 12.4564 7.6175 10.9339C7.38125 10.3389 7.25 9.68262 7.25 9.00012C7.25 6.10387 9.60375 3.75012 12.5 3.75012C15.3962 3.75012 17.75 6.10387 17.75 9.00012Z"
                        fill="currentColor"
                    />
                    <path
                        fill-opacity="0.3"
                        d="M21.25 16C21.25 18.8962 18.8962 21.25 16 21.25C14.6525 21.25 13.4275 20.7425 12.5 19.9025C13.5763 18.9487 14.25 17.5487 14.25 16C14.25 15.3175 14.1187 14.6612 13.8825 14.0662C15.4837 13.6287 16.7787 12.4562 17.3825 10.9337C19.605 11.5375 21.25 13.585 21.25 16Z"
                        fill="currentColor"
                    />
                    </svg>
                </a>

                
                </div>

                

                <!-- Profile -->
                <div
                    x-data="usePopper({placement:'right-end',offset:12})"
                    @click.outside="isShowPopper && (isShowPopper = false)"
                    class="flex">
                    <button
                    @click="isShowPopper = !isShowPopper"
                    x-ref="popperRef"
                    class="avatar size-12 cursor-pointer"
                    >
                    <img
                        class="rounded-full"
                        src="{{$profilePicture}}"
                        alt="avatar"
                    />
                    <span
                        class="absolute right-0 size-3.5 rounded-full border-2 border-white bg-success dark:border-navy-700"
                    ></span>
                    </button>

                    <div
                    :class="isShowPopper && 'show'"
                    class="popper-root fixed"
                    x-ref="popperRoot"
                    >
                    <div
                        class="popper-box w-64 rounded-lg border border-slate-150 bg-white shadow-soft dark:border-navy-600 dark:bg-navy-700"
                    >
                        <div
                        class="flex items-center space-x-4 rounded-t-lg bg-slate-100 py-5 px-4 dark:bg-navy-800"
                        >
                        <div class="avatar size-14">
                            <img
                            class="rounded-full"
                            src="{{$profilePicture}}"
                            alt="avatar"
                            />
                        </div>
                        <div>
                            <a
                            href="#"
                            class="text-base font-medium text-slate-700 hover:text-primary focus:text-primary dark:text-navy-100 dark:hover:text-accent-light dark:focus:text-accent-light"
                            >
                           
                            Hello {{$userName}}!
                            </a>
                            
                        </div>
                        </div>
                        <div class="flex flex-col pt-2 pb-5">
                        <a
                            
                            href="{{ url('profile') }}"
                            class="group flex items-center space-x-3 py-2 px-4 tracking-wide outline-hidden transition-all hover:bg-slate-100 focus:bg-slate-100 dark:hover:bg-navy-600 dark:focus:bg-navy-600"
                            >
                            <div
                            class="flex size-8 items-center justify-center rounded-lg bg-warning text-white"
                            >
                            <svg
                                xmlns="http://www.w3.org/2000/svg"
                                class="size-4.5"
                                fill="none"
                                viewBox="0 0 24 24"
                                stroke="currentColor"
                                stroke-width="2"
                            >
                                <path
                                stroke-linecap="round"
                                stroke-linejoin="round"
                                d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"
                                />
                            </svg>
                            </div>

                            <div>
                            <h2
                                class="font-medium text-slate-700 transition-colors group-hover:text-primary group-focus:text-primary dark:text-navy-100 dark:group-hover:text-accent-light dark:group-focus:text-accent-light"
                            >
                                Profile
                            </h2>
                            
                            </div>
                        </a>
                            
                            
                           
                            

                           
                        <div class="mt-3 px-4">
                        <a href="{{ url('/logout') }}">
                            <button
                                type="submit"
                                class="btn h-9 w-full space-x-2 bg-primary text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
                            >
                                <svg
                                    xmlns="http://www.w3.org/2000/svg"
                                    class="size-5"
                                    fill="none"
                                    viewBox="0 0 24 24"
                                    stroke="currentColor"
                                >
                                    <path
                                        stroke-linecap="round"
                                        stroke-linejoin="round"
                                        stroke-width="1.5"
                                        d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"
                                    />
                                </svg>
                                <span>Logout</span>
                            </button>
                        </a>

                        </div>
                        </div>
                    </div>
                    </div>
                </div>
                </div>
            </div>
            </div>

            <!-- Sidebar Panel -->
            <div class="sidebar-panel">
                <div class="flex h-full grow flex-col bg-white pl-[var(--main-sidebar-width)] dark:bg-navy-750" >
                    
                    <!-- Sidebar Panel Body -->
                    <div x-data="{expandedItem:null}" class="h-[calc(100%-4.5rem)] overflow-x-hidden pb-6" x-init="$el._x_simplebar = new SimpleBar($el);">
                        <ul class="flex flex-1 flex-col px-4 font-inter">
                           
                            @if (Request::is('vendor/*'))
                            <!-- Sidebar Panel Header -->
                            <div
                                class="flex h-18 w-full items-center justify-between pl-4 pr-1"
                                >
                                <p
                                    class="text-base tracking-wider text-slate-800 dark:text-navy-100"
                                >
                                    Vendors
                                </p>
                                <button
                                    @click="$store.global.isSidebarExpanded = false"
                                    class="btn size-7 rounded-full p-0 text-primary hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:text-accent-light/80 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25 xl:hidden"
                                >
                                    <svg
                                    xmlns="http://www.w3.org/2000/svg"
                                    class="size-6"
                                    fill="none"
                                    viewBox="0 0 24 24"
                                    stroke="currentColor"
                                    >
                                    <path
                                        stroke-linecap="round"
                                        stroke-linejoin="round"
                                        stroke-width="2"
                                        d="M15 19l-7-7 7-7"
                                    />
                                    </svg>
                                </button>
                            </div>
                            <div
                                class=" h-18 w-full items-center justify-between pl-4 pr-1"
                                >
                                <li>
                                    <a x-data="navLink"
                                        href="{{ route('vendor.list') }}"
                                        :class="isActive ? 'font-medium text-primary dark:text-accent-light' : 'text-slate-600 hover:text-slate-900 dark:text-navy-200 dark:hover:text-navy-50'" class="flex py-2 text-xs-plus tracking-wide outline-hidden transition-colors duration-300 ease-in-out font-medium text-primary dark:text-accent-light">
                                        List
                                    </a>
                                </li>
                                <li>
                                    <a x-data="navLink"
                                        href="{{ route('vendor.add') }}"
                                        :class="isActive ? 'font-medium text-primary dark:text-accent-light' : 'text-slate-600 hover:text-slate-900 dark:text-navy-200 dark:hover:text-navy-50'" class="flex py-2 text-xs-plus tracking-wide outline-hidden transition-colors duration-300 ease-in-out font-medium text-primary dark:text-accent-light">
                                        Add
                                    </a>
                                </li>
                                <li>
                                    <a x-data="navLink"
                                        href="{{ route('vendor.getVendorTypes') }}"
                                        :class="isActive ? 'font-medium text-primary dark:text-accent-light' : 'text-slate-600 hover:text-slate-900 dark:text-navy-200 dark:hover:text-navy-50'" class="flex py-2 text-xs-plus tracking-wide outline-hidden transition-colors duration-300 ease-in-out font-medium text-primary dark:text-accent-light">
                                        Vendor Typewise Data
                                    </a>
                                </li>
                            </div>
                            @endif
                            @if (Request::is('staff*'))
                            <div
                            class="flex h-18 w-full items-center justify-between pl-4 pr-1"
                            >
                            <p
                                class="text-base tracking-wider text-slate-800 dark:text-navy-100"
                            >
                                Staffs
                            </p>
                            <button
                                @click="$store.global.isSidebarExpanded = false"
                                class="btn size-7 rounded-full p-0 text-primary hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:text-accent-light/80 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25 xl:hidden"
                                >
                                <svg
                                xmlns="http://www.w3.org/2000/svg"
                                class="size-6"
                                fill="none"
                                viewBox="0 0 24 24"
                                stroke="currentColor"
                                >
                                <path
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                    stroke-width="2"
                                    d="M15 19l-7-7 7-7"
                                />
                                </svg>
                            </button>
                            </div>
                            <div
                            class=" h-18 w-full items-center justify-between pl-4 pr-1"
                            >
                            <li>
                                <a x-data="navLink"
                                    href="{{ route('staff.list') }}"
                                    :class="isActive ? 'font-medium text-primary dark:text-accent-light' : 'text-slate-600 hover:text-slate-900 dark:text-navy-200 dark:hover:text-navy-50'" class="flex py-2 text-xs-plus tracking-wide outline-hidden transition-colors duration-300 ease-in-out font-medium text-primary dark:text-accent-light">
                                    List
                                </a>
                            </li>
                            <li>
                            @if($userType === 'vendor')
                            @php
                                $token = session('token');
                            @endphp
                            
                                <a href="javascript:void(0)"
                                x-data
                                @click="
                                    fetch('https://ac-api.omsdev.in:2003/api/staff/checkMaximumStaffLimit', {
                                        method: 'GET',
                                        headers: {
                                            'Authorization': 'Bearer {{ $token }}',
                                            'Accept': 'application/json'
                                        }
                                    })
                                    .then(res => res.json())
                                    .then(data => {
                                    console.log(data);
                                        if (data.status === 0 && data.response === false) {
                                            window.location.href = '{{ route('staff.add') }}';
                                        
                                        } else {
                                            alert('The maximum staff limit has been reached. Please contact the administrator for assistance');
                                            
                                        }
                                    })
                                    .catch(err => {
                                        alert('Something went wrong.');
                                        console.error(err);
                                    })
                                "
                                class="flex py-2 text-xs-plus tracking-wide outline-hidden transition-colors duration-300 ease-in-out font-medium text-primary dark:text-accent-light">
                                Add
                                </a>


                            </li>
                            @endif
                            </div>
                            @endif
                            @if (Request::is('accredation-types/*','designations/*','access-areas/*','vendor-types/*'))
                            <div
                            class="flex h-18 w-full items-center justify-between pl-4 pr-1"
                            >
                            <p
                                class="text-base tracking-wider text-slate-800 dark:text-navy-100"
                            >
                                Masters
                            </p>
                            <button
                                @click="$store.global.isSidebarExpanded = false"
                                class="btn size-7 rounded-full p-0 text-primary hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:text-accent-light/80 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25 xl:hidden"
                                >
                                <svg
                                xmlns="http://www.w3.org/2000/svg"
                                class="size-6"
                                fill="none"
                                viewBox="0 0 24 24"
                                stroke="currentColor"
                                >
                                <path
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                    stroke-width="2"
                                    d="M15 19l-7-7 7-7"
                                />
                                </svg>
                            </button>
                            </div>
                            <div
                            class=" h-18 w-full items-center justify-between pl-4 pr-1"
                            >
                            <li>
                                <a x-data="navLink"
                                    href="{{ route('accredation_types.list') }}"
                                    :class="isActive ? 'font-medium text-primary dark:text-accent-light' : 'text-slate-600 hover:text-slate-900 dark:text-navy-200 dark:hover:text-navy-50'" class="flex py-2 text-xs-plus tracking-wide outline-hidden transition-colors duration-300 ease-in-out font-medium text-primary dark:text-accent-light">
                                    Accreditation Types
                                </a>
                            </li>
                            <li>
                                <a x-data="navLink"
                                    href="{{ route('access_areas.list') }}"
                                    :class="isActive ? 'font-medium text-primary dark:text-accent-light' : 'text-slate-600 hover:text-slate-900 dark:text-navy-200 dark:hover:text-navy-50'" class="flex py-2 text-xs-plus tracking-wide outline-hidden transition-colors duration-300 ease-in-out font-medium text-primary dark:text-accent-light">
                                    Access Areas
                                </a>
                            </li>
                            <li>
                                <a x-data="navLink"
                                    href="{{ route('designations.list') }}"
                                    :class="isActive ? 'font-medium text-primary dark:text-accent-light' : 'text-slate-600 hover:text-slate-900 dark:text-navy-200 dark:hover:text-navy-50'" class="flex py-2 text-xs-plus tracking-wide outline-hidden transition-colors duration-300 ease-in-out font-medium text-primary dark:text-accent-light">
                                    Designations
                                </a>
                            </li>
                            
                            </div>
                            @endif
                        </ul>
                    </div>

                </div>
            </div>

        <!-- App Header Wrapper-->
        <nav class="header before:bg-white dark:before:bg-navy-750 print:hidden">
            <!-- App Header  -->
            <div class="header-container relative flex w-full print:hidden">
                <!-- Header Items -->
                <div class="flex w-full items-center justify-between">
                    <!-- Left: Sidebar Toggle Button -->
                    @if (!Request::is('dashboard') && !Request::is('vendor-dashboard'))

                    <div class="size-7">
                        <button
                            class="menu-toggle cursor-pointer ml-0.5 flex size-7 flex-col justify-center space-y-1.5 text-primary outline-hidden focus:outline-hidden dark:text-accent-light/80"
                            :class="$store.global.isSidebarExpanded && 'active'"
                            @click="$store.global.isSidebarExpanded = !$store.global.isSidebarExpanded"
                            >
                            <span></span>
                            <span></span>
                            <span></span>
                        </button>
                    </div>
                    @endif
                    <!-- Right: Header buttons -->
                    <div class="-mr-1.5 flex items-center space-x-2">
                        <!-- Dark Mode Toggle -->
                        <button
                            @click="$store.global.isDarkModeEnabled = !$store.global.isDarkModeEnabled"
                            class="btn size-8 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
                            >
                            <svg
                            x-show="$store.global.isDarkModeEnabled"
                            x-transition:enter="transition-transform duration-200 ease-out absolute origin-top"
                            x-transition:enter-start="scale-75"
                            x-transition:enter-end="scale-100 static"
                            class="size-6 text-amber-400"
                            fill="currentColor"
                            viewBox="0 0 24 24"
                            >
                            <path
                                d="M11.75 3.412a.818.818 0 01-.07.917 6.332 6.332 0 00-1.4 3.971c0 3.564 2.98 6.494 6.706 6.494a6.86 6.86 0 002.856-.617.818.818 0 011.1 1.047C19.593 18.614 16.218 21 12.283 21 7.18 21 3 16.973 3 11.956c0-4.563 3.46-8.31 7.925-8.948a.818.818 0 01.826.404z"
                            />
                            </svg>
                            <svg
                            xmlns="http://www.w3.org/2000/svg"
                            x-show="!$store.global.isDarkModeEnabled"
                            x-transition:enter="transition-transform duration-200 ease-out absolute origin-top"
                            x-transition:enter-start="scale-75"
                            x-transition:enter-end="scale-100 static"
                            class="size-6 text-amber-400"
                            viewBox="0 0 20 20"
                            fill="currentColor"
                            >
                            <path
                                fill-rule="evenodd"
                                d="M10 2a1 1 0 011 1v1a1 1 0 11-2 0V3a1 1 0 011-1zm4 8a4 4 0 11-8 0 4 4 0 018 0zm-.464 4.95l.707.707a1 1 0 001.414-1.414l-.707-.707a1 1 0 00-1.414 1.414zm2.12-10.607a1 1 0 010 1.414l-.706.707a1 1 0 11-1.414-1.414l.707-.707a1 1 0 011.414 0zM17 11a1 1 0 100-2h-1a1 1 0 100 2h1zm-7 4a1 1 0 011 1v1a1 1 0 11-2 0v-1a1 1 0 011-1zM5.05 6.464A1 1 0 106.465 5.05l-.708-.707a1 1 0 00-1.414 1.414l.707.707zm1.414 8.486l-.707.707a1 1 0 01-1.414-1.414l.707-.707a1 1 0 011.414 1.414zM4 11a1 1 0 100-2H3a1 1 0 000 2h1z"
                                clip-rule="evenodd"
                            />
                            </svg>
                        </button>
                        <!-- Monochrome Mode Toggle -->
                        <button
                            @click="$store.global.isMonochromeModeEnabled = !$store.global.isMonochromeModeEnabled"
                            class="btn size-8 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
                            >
                            <i
                            class="fa-solid fa-palette bg-gradient-to-r from-sky-400 to-blue-600 bg-clip-text text-lg font-semibold text-transparent"
                            ></i>
                        </button>
                    </div>
                </div>
            </div>
        </nav>

      

        