@extends('layouts.app')
@section('content')
<style>
  .radius-right {
    border-top-right-radius: var(--radius-lg);
    border-bottom-right-radius: var(--radius-lg);
  }
</style>
    <!-- Main Content Wrapper -->
    <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <div
          class="flex flex-col items-center justify-between space-y-4 py-5 sm:flex-row sm:space-y-0 lg:py-6"
            >
          <div class="flex items-center space-x-1">
            <svg
              xmlns="http://www.w3.org/2000/svg"
              class="size-6"
              fill="none"
              viewBox="0 0 24 24"
              stroke="currentColor"
            >
              <path
                stroke-linecap="round"
                stroke-linejoin="round"
                stroke-width="2"
                d="M9 13h6m-3-3v6m5 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"
              />
            </svg>
            <h2
              class="text-xl font-medium text-slate-700 line-clamp-1 dark:text-navy-50"
            >
              Update Access Area
            </h2>
          </div>
          <div class="flex justify-center space-x-2">
            <a href="{{ route('access_areas.list') }}">
            <button
              class="btn min-w-[7rem] bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
            >
              Preveious
            </button>
            </a>
          </div>
        </div>
         
        
        <div class="flex items-center justify-center min-h-screen bg-gray-50">
          
            <div class="card p-5 w-full max-w-5xl shadow-lg rounded-xl bg-white dark:bg-gray-800">
              <form action="{{ url('/access-areas/update') }}" method="post" enctype="multipart/form-data">
              @csrf
              <input type="hidden" name="accessAreaId" value="{{$access_area['accessAreaId']}}"/>
                <div class="flex flex-col gap-6">
                    <!-- access_area Name -->
                    <div>
                      <label class="block">
                        <span class="font-medium text-slate-600 dark:text-navy-100">Access Area</span>
                        <input
                          name="name"
                          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                          placeholder="Enter access area"
                          type="text"
                          value="{{$access_area['name']}}"
                        />
                      </label>
                    </div>
                    <div>
                      <label class="block">
                        <span class="font-medium text-slate-600 dark:text-navy-100">Area Code</span>
                        <input
                          name="areaCode"
                          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                          placeholder="Enter access area code"
                          type="text"
                          value="{{$access_area['areaCode']}}"
                        />
                      </label>
                    </div>

                    <!-- Status Type -->
                    <div>
                      <label class="block">
                        <span class="font-medium text-slate-600 dark:text-navy-100">Status Type</span>
                        <select
                          name="isActive"
                          class="mt-1.5 w-full"
                          x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
                          >
                          <option value="true" {{ $access_area['isActive'] === true ? 'selected' : '' }}>Active</option>
                          <option value="false" {{ $access_area['isActive'] === false ? 'selected' : '' }}>Inactive</option>
                        </select>
                      </label>
                    </div>
                  </div>
                  <div class="flex justify-end space-x-2 mt-6">
                  <button
                  type="submit"
                    class="btn min-w-[7rem] bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
                  >
                    Save
                  </button>
                </div>
              </form>
            </div>
         
        </div>

    </main>
@endsection 