@extends('layouts.app')
@section('content')
<style>
  .radius-right {
    border-top-right-radius: var(--radius-lg);
    border-bottom-right-radius: var(--radius-lg);
  }
</style>

 
    <!-- Main Content Wrapper -->
    <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <div
          class="flex flex-col items-center justify-between space-y-4 py-5 sm:flex-row sm:space-y-0 lg:py-6"
            >
          <div class="flex items-center space-x-1">
            <svg
              xmlns="http://www.w3.org/2000/svg"
              class="size-6"
              fill="none"
              viewBox="0 0 24 24"
              stroke="currentColor"
            >
              <path
                stroke-linecap="round"
                stroke-linejoin="round"
                stroke-width="2"
                d="M9 13h6m-3-3v6m5 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"
              />
            </svg>
            <h2
              class="text-xl font-medium text-slate-700 line-clamp-1 dark:text-navy-50"
            >
              Add Staffs
            </h2>
          </div>
          
        </div>
        @if(session('error'))
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-2 rounded mb-4" style="margin-bottom: 20px;
          color: red;">
          <span class="mr-2 text-xl">ⓘ</span>
          {{ session('error') }}
        </div>
        @endif
        <form action="{{ url('/staff/add') }}" method="post" enctype="multipart/form-data">  
        @csrf
        <div class="grid grid-cols-12 gap-6">
           <!-- Staff Name -->
           <div class="col-span-12 lg:col-span-6">
            <label class="block">
              <span class="font-medium text-slate-600 dark:text-navy-100">First Name</span>
              <input
                name="first_name"
                class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                placeholder="Enter first name"
                type="text" required
              />
            </label>
          </div>
           <!-- Middle Name -->
           <div class="col-span-12 lg:col-span-6">
            <label class="block">
              <span class="font-medium text-slate-600 dark:text-navy-100">Middle Name</span>
              <input
                name="middle_name"
                class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                placeholder="Enter middle name"
                type="text" required
              />
            </label>
          </div>
          <!-- Last Name -->
          <div class="col-span-12 lg:col-span-6">
            <label class="block">
              <span class="font-medium text-slate-600 dark:text-navy-100">Last Name</span>
              <input
                name="last_name"
                class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                placeholder="Enter surname"
                type="text" required
              />
            </label>
          </div>
          <!-- Staff Profile -->
          <div class="col-span-12 lg:col-span-6">
            <span class="font-medium text-slate-600 dark:text-navy-100">Photo  </span>            
            <!-- Upload new profile picture -->
            <div class="filepond fp-bordered fp-grid mt-3 [--fp-grid:2]">
              <input type="file" name="profilePicture" class="form-control" accept="image/png, image/jpeg, image/jpg" required/>
            </div>
          </div>
          
          <!-- Father's / Guardian's Name -->
          <div class="col-span-12 lg:col-span-6">
            <label class="block">
              <span class="font-medium text-slate-600 dark:text-navy-100">Father's / Guardian's Name</span>
              <input
                name="fatherName"
                class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                placeholder="Enter name"
                type="text"
              />
            </label>
          </div>
          <!-- Gender -->
          <div class="col-span-12 lg:col-span-6">
              <label class="block">
                <span class="font-medium text-slate-600 dark:text-navy-100"
                  >Gender</span>
                <select
                  name="gender"
                  class="mt-1.5 w-full"
                  x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
                >
                  <option value>Select --</option>
                  <option value="Male">Male</option>
                  <option value="Female">Female</option>
                  <option value="Other">Other</option>
                </select>
              </label>
          </div>

          <!-- Date Of Birth -->
          <div class="col-span-12 lg:col-span-6">
            <label class="block">
              <span class="font-medium text-slate-600 dark:text-navy-100">Date Of Birth</span>
              <input  
                name="dob"
                id="dobInput"
                class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                placeholder="Enter DOB"
                type="date"
              />
            </label>
          </div>

          <!-- Mobile -->
          <div class="col-span-12 lg:col-span-6">
            <label class="block">
              <span class="font-medium text-slate-600 dark:text-navy-100">Phone</span>
              <div class="flex mt-2 -space-x-px">
                <select
                  name="countryCode"
                  class="form-select rounded-l-full border border-slate-300 bg-white px-3 py-2 pr-9 hover:z-10 hover:border-slate-400 focus:z-10 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent">
                  <option value="+91" selected>India (+91)</option>
                  <option value="+93">Afghanistan (+93)</option>
                  <option value="+355">Albania (+355)</option>
                  <option value="+213">Algeria (+213)</option>
                  <option value="+1684">American Samoa (+1684)</option>
                  <option value="+376">Andorra (+376)</option>
                  <option value="+244">Angola (+244)</option>
                  <option value="+1264">Anguilla (+1264)</option>
                  <option value="+1268">Antigua and Barbuda (+1268)</option>
                  <option value="+54">Argentina (+54)</option>
                  <option value="+374">Armenia (+374)</option>
                  <option value="+297">Aruba (+297)</option>
                  <option value="+61">Australia (+61)</option>
                  <option value="+43">Austria (+43)</option>
                  <option value="+994">Azerbaijan (+994)</option>
                  <option value="+1242">Bahamas (+1242)</option>
                  <option value="+973">Bahrain (+973)</option>
                  <option value="+880">Bangladesh (+880)</option>
                  <option value="+1246">Barbados (+1246)</option>
                  <option value="+375">Belarus (+375)</option>
                  <option value="+32">Belgium (+32)</option>
                  <option value="+501">Belize (+501)</option>
                  <option value="+229">Benin (+229)</option>
                  <option value="+1441">Bermuda (+1441)</option>
                  <option value="+975">Bhutan (+975)</option>
                  <option value="+591">Bolivia (+591)</option>
                  <option value="+387">Bosnia and Herzegovina (+387)</option>
                  <option value="+267">Botswana (+267)</option>
                  <option value="+55">Brazil (+55)</option>
                  <option value="+246">British Indian Ocean Territory (+246)</option>
                  <option value="+673">Brunei (+673)</option>
                  <option value="+359">Bulgaria (+359)</option>
                  <option value="+226">Burkina Faso (+226)</option>
                  <option value="+257">Burundi (+257)</option>
                  <option value="+855">Cambodia (+855)</option>
                  <option value="+237">Cameroon (+237)</option>
                  <option value="+1">Canada (+1)</option>
                  <option value="+238">Cape Verde (+238)</option>
                  <option value="+1345">Cayman Islands (+1345)</option>
                  <option value="+236">Central African Republic (+236)</option>
                  <option value="+235">Chad (+235)</option>
                  <option value="+56">Chile (+56)</option>
                  <option value="+86">China (+86)</option>
                  <option value="+61">Christmas Island (+61)</option>
                  <option value="+57">Colombia (+57)</option>
                  <option value="+269">Comoros (+269)</option>
                  <option value="+242">Congo (+242)</option>
                  <option value="+682">Cook Islands (+682)</option>
                  <option value="+506">Costa Rica (+506)</option>
                  <option value="+385">Croatia (+385)</option>
                  <option value="+53">Cuba (+53)</option>
                  <option value="+357">Cyprus (+357)</option>
                  <option value="+420">Czech Republic (+420)</option>
                  <option value="+243">DR Congo (+243)</option>
                  <option value="+45">Denmark (+45)</option>
                  <option value="+253">Djibouti (+253)</option>
                  <option value="+1767">Dominica (+1767)</option>
                  <option value="+1809">Dominican Republic (+1809)</option>
                  <option value="+593">Ecuador (+593)</option>
                  <option value="+20">Egypt (+20)</option>
                  <option value="+503">El Salvador (+503)</option>
                  <option value="+240">Equatorial Guinea (+240)</option>
                  <option value="+291">Eritrea (+291)</option>
                  <option value="+372">Estonia (+372)</option>
                  <option value="+251">Ethiopia (+251)</option>
                  <option value="+679">Fiji (+679)</option>
                  <option value="+358">Finland (+358)</option>
                  <option value="+33">France (+33)</option>
                  <option value="+594">French Guiana (+594)</option>
                  <option value="+241">Gabon (+241)</option>
                  <option value="+220">Gambia (+220)</option>
                  <option value="+995">Georgia (+995)</option>
                  <option value="+49">Germany (+49)</option>
                  <option value="+233">Ghana (+233)</option>
                  <option value="+350">Gibraltar (+350)</option>
                  <option value="+30">Greece (+30)</option>
                  <option value="+299">Greenland (+299)</option>
                  <option value="+1473">Grenada (+1473)</option>
                  <option value="+590">Guadeloupe (+590)</option>
                  <option value="+1671">Guam (+1671)</option>
                  <option value="+502">Guatemala (+502)</option>
                  <option value="+224">Guinea (+224)</option>
                  <option value="+245">Guinea-Bissau (+245)</option>
                  <option value="+592">Guyana (+592)</option>
                  <option value="+509">Haiti (+509)</option>
                  <option value="+504">Honduras (+504)</option>
                  <option value="+852">Hong Kong (+852)</option>
                  <option value="+36">Hungary (+36)</option>
                  <option value="+354">Iceland (+354)</option>
                  <option value="+91" selected>India (+91)</option>
                  <option value="+62">Indonesia (+62)</option>
                  <option value="+98">Iran (+98)</option>
                  <option value="+964">Iraq (+964)</option>
                  <option value="+353">Ireland (+353)</option>
                  <option value="+972">Israel (+972)</option>
                  <option value="+39">Italy (+39)</option>
                  <option value="+1876">Jamaica (+1876)</option>
                  <option value="+81">Japan (+81)</option>
                  <option value="+962">Jordan (+962)</option>
                  <option value="+7">Kazakhstan (+7)</option>
                  <option value="+254">Kenya (+254)</option>
                  <option value="+686">Kiribati (+686)</option>
                  <option value="+850">North Korea (+850)</option>
                  <option value="+82">South Korea (+82)</option>
                  <option value="+965">Kuwait (+965)</option>
                  <option value="+996">Kyrgyzstan (+996)</option>
                  <option value="+856">Laos (+856)</option>
                  <option value="+371">Latvia (+371)</option>
                  <option value="+961">Lebanon (+961)</option>
                  <option value="+266">Lesotho (+266)</option>
                  <option value="+231">Liberia (+231)</option>
                  <option value="+218">Libya (+218)</option>
                  <option value="+423">Liechtenstein (+423)</option>
                  <option value="+370">Lithuania (+370)</option>
                  <option value="+352">Luxembourg (+352)</option>
                  <option value="+853">Macau (+853)</option>
                  <option value="+389">North Macedonia (+389)</option>
                  <option value="+261">Madagascar (+261)</option>
                  <option value="+265">Malawi (+265)</option>
                  <option value="+60">Malaysia (+60)</option>
                  <option value="+960">Maldives (+960)</option>
                  <option value="+223">Mali (+223)</option>
                  <option value="+356">Malta (+356)</option>
                  <option value="+692">Marshall Islands (+692)</option>
                  <option value="+596">Martinique (+596)</option>
                  <option value="+222">Mauritania (+222)</option>
                  <option value="+230">Mauritius (+230)</option>
                  <option value="+262">Mayotte (+262)</option>
                  <option value="+52">Mexico (+52)</option>
                  <option value="+691">Micronesia (+691)</option>
                  <option value="+373">Moldova (+373)</option>
                  <option value="+377">Monaco (+377)</option>
                  <option value="+976">Mongolia (+976)</option>
                  <option value="+382">Montenegro (+382)</option>
                  <option value="+1664">Montserrat (+1664)</option>
                  <option value="+212">Morocco (+212)</option>
                  <option value="+258">Mozambique (+258)</option>
                  <option value="+95">Myanmar (+95)</option>
                  <option value="+264">Namibia (+264)</option>
                  <option value="+674">Nauru (+674)</option>
                  <option value="+977">Nepal (+977)</option>
                  <option value="+31">Netherlands (+31)</option>
                  <option value="+599">Netherlands Antilles (+599)</option>
                  <option value="+687">New Caledonia (+687)</option>
                  <option value="+64">New Zealand (+64)</option>
                  <option value="+505">Nicaragua (+505)</option>
                  <option value="+227">Niger (+227)</option>
                  <option value="+234">Nigeria (+234)</option>
                  <option value="+683">Niue (+683)</option>
                  <option value="+672">Norfolk Island (+672)</option>
                  <option value="+1670">Northern Mariana Islands (+1670)</option>
                  <option value="+47">Norway (+47)</option>
                  <option value="+968">Oman (+968)</option>
                  <option value="+92">Pakistan (+92)</option>
                  <option value="+680">Palau (+680)</option>
                  <option value="+970">Palestinian Territory (+970)</option>
                  <option value="+507">Panama (+507)</option>
                  <option value="+675">Papua New Guinea (+675)</option>
                  <option value="+595">Paraguay (+595)</option>
                  <option value="+51">Peru (+51)</option>
                  <option value="+63">Philippines (+63)</option>
                  <option value="+48">Poland (+48)</option>
                  <option value="+351">Portugal (+351)</option>
                  <option value="+1787">Puerto Rico (+1787)</option>
                  <option value="+974">Qatar (+974)</option>
                  <option value="+262">Réunion (+262)</option>
                  <option value="+40">Romania (+40)</option>
                  <option value="+7">Russia (+7)</option>
                  <option value="+250">Rwanda (+250)</option>
                  <option value="+590">Saint Barthélemy (+590)</option>
                  <option value="+290">Saint Helena (+290)</option>
                  <option value="+1869">Saint Kitts and Nevis (+1869)</option>
                  <option value="+1758">Saint Lucia (+1758)</option>
                  <option value="+590">Saint Martin (+590)</option>
                  <option value="+508">Saint Pierre and Miquelon (+508)</option>
                  <option value="+1784">Saint Vincent and the Grenadines (+1784)</option>
                  <option value="+685">Samoa (+685)</option>
                  <option value="+378">San Marino (+378)</option>
                  <option value="+239">São Tomé and Príncipe (+239)</option>
                  <option value="+966">Saudi Arabia (+966)</option>
                  <option value="+221">Senegal (+221)</option>
                  <option value="+381">Serbia (+381)</option>
                  <option value="+248">Seychelles (+248)</option>
                  <option value="+232">Sierra Leone (+232)</option>
                  <option value="+65">Singapore (+65)</option>
                  <option value="+421">Slovakia (+421)</option>
                  <option value="+386">Slovenia (+386)</option>
                  <option value="+677">Solomon Islands (+677)</option>
                  <option value="+252">Somalia (+252)</option>
                  <option value="+27">South Africa (+27)</option>
                  <option value="+211">South Sudan (+211)</option>
                  <option value="+34">Spain (+34)</option>
                  <option value="+94">Sri Lanka (+94)</option>
                  <option value="+249">Sudan (+249)</option>
                  <option value="+597">Suriname (+597)</option>
                  <option value="+268">Swaziland (+268)</option>
                  <option value="+46">Sweden (+46)</option>
                  <option value="+41">Switzerland (+41)</option>
                  <option value="+963">Syria (+963)</option>
                  <option value="+886">Taiwan (+886)</option>
                  <option value="+992">Tajikistan (+992)</option>
                  <option value="+255">Tanzania (+255)</option>
                  <option value="+66">Thailand (+66)</option>
                  <option value="+670">Timor-Leste (+670)</option>
                  <option value="+228">Togo (+228)</option>
                  <option value="+690">Tokelau (+690)</option>
                  <option value="+676">Tonga (+676)</option>
                  <option value="+1868">Trinidad and Tobago (+1868)</option>
                  <option value="+216">Tunisia (+216)</option>
                  <option value="+90">Turkey (+90)</option>
                  <option value="+993">Turkmenistan (+993)</option>
                  <option value="+1649">Turks and Caicos Islands (+1649)</option>
                  <option value="+688">Tuvalu (+688)</option>
                  <option value="+256">Uganda (+256)</option>
                  <option value="+380">Ukraine (+380)</option>
                  <option value="+971">United Arab Emirates (+971)</option>
                  <option value="+44">United Kingdom (+44)</option>
                  <option value="+1">United States (+1)</option>
                  <option value="+598">Uruguay (+598)</option>
                  <option value="+998">Uzbekistan (+998)</option>
                  <option value="+678">Vanuatu (+678)</option>
                  <option value="+58">Venezuela (+58)</option>
                  <option value="+84">Vietnam (+84)</option>
                  <option value="+1284">British Virgin Islands (+1284)</option>
                  <option value="+1340">U.S. Virgin Islands (+1340)</option>
                  <option value="+681">Wallis and Futuna (+681)</option>
                  <option value="+967">Yemen (+967)</option>
                  <option value="+260">Zambia (+260)</option>
                  <option value="+263">Zimbabwe (+263)</option>

                </select>
              
                <input
                  name="phone"
                 class="form-input w-full border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:z-10 hover:border-slate-400 focus:z-10 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent radius-right"
                  placeholder="Enter mobile"
                  type="text" 
                  maxlength="10"
                  pattern="\d{10}"
                  inputmode="numeric"
                  oninput="this.value = this.value.replace(/[^0-9]/g, '')" required/>
              </div>
            </label>
          </div>
          
          <!-- Email ID -->
          <div class="col-span-12 lg:col-span-6">
            <label class="block">
              <span class="font-medium text-slate-600 dark:text-navy-100">Email ID</span>
              <input
                class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                placeholder="Enter you email"
                type="email"
                name="email"
                
              />
            </label>
          </div>
          <!-- Address Line 1 -->
          <div class="col-span-12 lg:col-span-6">
            <label class="block">
              <span class="font-medium text-slate-600 dark:text-navy-100">Address Line 1</span>
              <input
                class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                placeholder="Enter address"
                type="text"
                name = "addressLine1"
              />
            </label>
          </div>
          
          <!-- Address Line 2 -->
          <div class="col-span-12 lg:col-span-6">
            <label class="block">
              <span class="font-medium text-slate-600 dark:text-navy-100">Address Line 2</span>
              <input
                class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                placeholder="Enter address"
                type="text"
                name = "addressLine2"
              />
            </label>
          </div>
          <!-- Country -->
          <div class="col-span-12 lg:col-span-6">
              <label class="block">
                <span class="font-medium text-slate-600 dark:text-navy-100"
                  >Country</span
                >
                <select class="mt-1.5 w-full"
                  name="country" id="country_select" 
                  x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})">
                  <option value="">-- Select Country --</option>
                  @foreach($all_countries as $country)
                  <option value="{{$country['countryName']}}" data-country-id="{{ $country['countryId'] }}">{{$country['countryName']}}</option>
                  @endforeach
                </select>
              </label>
          </div>
          <!-- State -->
          <div class="col-span-12 lg:col-span-6">
            <label class="block">
              <span class="font-medium text-slate-600 dark:text-navy-100">state</span>
              <select class="mt-1.5 w-full" name="state" id="state_select" required>
                <option value="">-- Select State --</option>
            </select>

            </label>
          </div>
          <!-- City -->
          <div class="col-span-12 lg:col-span-6">
            <label class="block">
              <span class="font-medium text-slate-600 dark:text-navy-100">City</span>
              <input
                name = "city"
                class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                placeholder="Enter state"
                type="text"
              />
            </label>
          </div>
          <!-- Postal Code -->
          <div class="col-span-12 lg:col-span-6">
            <label class="block">
              <span class="font-medium text-slate-600 dark:text-navy-100">Postal Code</span>
              <input
                name = "postalCode"
                class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                placeholder="Enter Postal Code"
                type="text"
              />
            </label>
          </div>
          <div class="col-span-12 mt-8">
            <!-- Divider with more bottom spacing -->
            <hr class="border-t border-slate-300 mb-6" />

            <!-- Heading with top margin to push it down further from the line -->
            <h2 class="text-lg font-semibold text-slate-700 dark:text-navy-50 mb-4 mt-4">
              Identification
            </h2>
          </div>
          <!-- ID Type -->
          <div class="col-span-12 lg:col-span-6">
              <label class="block">
                <span class="font-medium text-slate-600 dark:text-navy-100"
                  >ID Type</span>
                <select
                  name = "idType"
                  class="mt-1.5 w-full"
                  x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
                >
                  <option value>Select --</option>
                  <option value="Passport">Passport</option>
                  <option value="Driving License">Driving License</option>
                  <option value="Aadhar Card">Aadhar Card</option>
                  <option value="Pan Card">Pan Card</option>
                  <option value="Voters ID">Voters ID</option>
                </select>
              </label>
          </div>
          <!-- ID Number -->
          <div class="col-span-12 lg:col-span-6">
            <label class="block">
              <span class="font-medium text-slate-600 dark:text-navy-100">ID Number</span>
              <input
                name="idNumber"
                class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                placeholder="Enter number"
                type="text"
              />
            </label>
          </div>
          
          <!-- Id Proof Front -->
          <div class="col-span-12 lg:col-span-6">
            <span class="font-medium text-slate-600 dark:text-navy-100">Id Proof Front </span>
            <div class="filepond fp-bordered fp-grid mt-1.5 [--fp-grid:2]">
           
              <input type="file" class="form-control"   name="idProofFront" accept="image/png, image/jpeg, image/jpg" required/>
            </div>
          </div>

          <!-- Id Proof Back  -->
          <div class="col-span-12 lg:col-span-6">
            <span class="font-medium text-slate-600 dark:text-navy-100">Id Proof Back </span>
            <div class="filepond fp-bordered fp-grid mt-1.5 [--fp-grid:2]">
              <input type="file" class="form-control"  name="idProofBack" accept="image/png, image/jpeg, image/jpg" required/>
            </div>
          </div>

          <div class="col-span-12 mt-8">
            <!-- Divider with more bottom spacing -->
            <hr class="border-t border-slate-300 mb-6" />

            <!-- Heading with top margin to push it down further from the line -->
            <h2 class="text-lg font-semibold text-slate-700 dark:text-navy-50 mb-4 mt-4">
            Accreditation Details
            </h2>
          </div>
          <!-- Designation -->
          <div class="col-span-12 lg:col-span-6">
              <label class="block">
                <span class="font-medium text-slate-600 dark:text-navy-100"
                  >Designations/Duties</span>
                <select
                  name = "designationMasterId"
                  class="mt-1.5 w-full"
                  x-data="{ concurrenceAccess: '' }"
                  x-model="concurrenceAccess"
                  x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
                >
                  <option value>Select --</option>
                  @foreach($designations as $designation)
                  <option value="{{$designation['designationMasterId']}}">{{$designation['designationName']}}</option>
                  @endforeach
                </select>
              </label>
          </div>
          <!-- Concurrence Access -->
          <div class="col-span-12 lg:col-span-6">
              <label class="block">
                <span class="font-medium text-slate-600 dark:text-navy-100"
                  >Only Concurrence Access</span>
                <select
                  name = "onlyConcourseAccess"
                  class="mt-1.5 w-full"
                  id="concurrence_access"
                  x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
                  
                  >
                  <option value>Select --</option>
                  <option value="Yes">Yes</option>
                  <option value="No">No</option>
                </select>
              </label>
          </div>
          <!-- Access Area Section -->
          <div
            class="col-span-12 lg:col-span-6"
            id="access_area"
            style="display: none;"
          >
            <span class="font-medium text-slate-600 dark:text-navy-100">Access Area</span>
            <div class="mt-2 grid grid-cols-1 gap-4 sm:grid-cols-4 sm:gap-5 lg:gap-6">
            @foreach($all_access_area as $area)

              <label class="inline-flex items-center space-x-2">
                <input name="accessAreaId[]"
                  class="form-checkbox is-basic size-5 rounded-sm border-slate-400/70 checked:!border-success checked:bg-success hover:!border-success focus:!border-success dark:border-navy-400"
                  type="checkbox"
                  value="{{$area['accessAreaId']}}"
                />
                <span>{{$area['name']}} ({{$area['accessAreaCode']}})</span>
              </label>
            @endforeach  
            </div>
          </div>
          


        </div>
        <div class="flex pt-5 space-x-2" style="justify-content:end;">
           
          <button
          type="submit"
              class="btn min-w-[7rem] bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
            >
              Save
          </button>
        </div>
        </form>
    </main>

    
<script>
  
  // Get references to the dropdown and Access Area div
  const concurrenceSelect = document.getElementById('concurrence_access');
  const accessAreaDiv = document.getElementById('access_area');

  // Add an event listener to handle the change event on the dropdown
  concurrenceSelect.addEventListener('change', function () {
    if (this.value === 'No') {
      accessAreaDiv.style.display = 'block'; // Show the Access Area section
    } else {
      accessAreaDiv.style.display = 'none'; // Hide the Access Area section
    }
  });
</script>
<script>
  document.addEventListener("DOMContentLoaded", function () {
    const dobInput = document.getElementById("dobInput");

    // Calculate today's date minus 18 years
    const today = new Date();
    const year = today.getFullYear() - 18;
    const month = String(today.getMonth() + 1).padStart(2, '0');
    const day = String(today.getDate()).padStart(2, '0');

    const maxDate = `${year}-${month}-${day}`;
    dobInput.max = maxDate;
  });
</script>
<script>
  document.addEventListener("DOMContentLoaded", function () {
    const dobInput = document.querySelector('input[name="dob"]');
    const saveButton = document.querySelector('button[type="submit"]');

    dobInput.addEventListener("change", function () {
      const dob = new Date(this.value);
      const today = new Date();
      const ageDiff = today.getFullYear() - dob.getFullYear();
      const m = today.getMonth() - dob.getMonth();
      const age = m < 0 || (m === 0 && today.getDate() < dob.getDate()) ? ageDiff - 1 : ageDiff;

      if (age < 18) {
        alert("You must be at least 18 years old to register.");
        saveButton.style.display = "none";
      } else {
        saveButton.style.display = "inline-block";
      }
    });
  });
</script>
<script>
  document.addEventListener('DOMContentLoaded', function () {
    const countrySelect = document.getElementById('country_select');
    const stateSelect = document.getElementById('state_select');

    countrySelect.addEventListener('change', function () {
      const selectedOption = countrySelect.options[countrySelect.selectedIndex];
      const countryId = selectedOption.getAttribute('data-country-id');

      if (!countryId) return;

      // Clear and show loading
      stateSelect.innerHTML = '<option value="">Loading...</option>';

      // Call API
      fetch(`https://ac-api.omsdev.in:2003/api/master/getStateByCountry?countryId=${countryId}&pageNo=0&pageSize=300`)
        .then(response => response.json())
        .then(data => {
          const states = data.response?.dataSet || [];

          stateSelect.innerHTML = '<option value="">-- Select State --</option>';

          states.forEach(state => {
            const option = document.createElement('option');
            option.value = state.stateName; // Or state.stateId if needed
            option.textContent = state.stateName;
            stateSelect.appendChild(option);
          });
        })
        .catch(error => {
          console.error('Error fetching states:', error);
          stateSelect.innerHTML = '<option value="">Failed to load states</option>';
        });
    });
  });
</script>
@endsection 