<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use App\Http\Controllers\PublicController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\VendorController;
use App\Http\Controllers\StaffController;
use App\Http\Controllers\MasterController;
use App\Http\Controllers\InventoryController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/login', function () {
    session()->forget('token');
    return view('login'); // e.g., 'auth.login' or 'login'
})->name('login');

Route::get('/thanks', function () {
    
    return view('thanks'); // e.g., 'auth.login' or 'login'
})->name('thanks');

Route::get('/company/{event_name}/{vendor_id}', [App\Http\Controllers\PublicController::class, 'getURL']);
Route::get('/company/{event_name}/{vendor_id}/{staff_id}/{phone}', [App\Http\Controllers\PublicController::class, 'getStaffForm']);
Route::post('/add-form', [App\Http\Controllers\PublicController::class, 'addForm']);
Route::get('/register-staff', [App\Http\Controllers\PublicController::class, 'registerStaff'])->name('register_staff');
Route::post('/verify-staff-otp', [App\Http\Controllers\PublicController::class, 'verifyStaffOtp'])->name('verifyStaffOtp');

Route::get('/cls', function () {    
    Artisan::call('cache:clear');
    Artisan::call('view:clear');
    Artisan::call('config:clear');
    session()->flush();
    return "cache cleared";
});

Route::post('/login', [LoginController::class, 'login'])->name('login');
Route::post('/login/admin/send-otp', [LoginController::class, 'sendOtp'])->name('login.admin.sendOtp');
Route::post('/login/admin/verify-otp', [LoginController::class, 'verifyOtp'])->name('login.admin.verifyOtp');

Route::middleware(['auth.token'])->group(function () {
    Route::get('/logout', [LoginController::class, 'logout'])->name('logout');

// Route::get('/index', function () {
//     return view('index');
// })->name('index');
Route::get('/dashboard', [PublicController::class, 'dashboard'])->name('dashboard');
Route::get('/vendor-dashboard', [PublicController::class, 'vendorDashboard'])->name('vendor_dashboard');
Route::get('/profile', [PublicController::class, 'profile'])->name('profile');
Route::post('/add-profile', [PublicController::class, 'addProfile'])->name('addProfile');



// Route::middleware(['web'])->get('logout', [LoginController::class, 'logout'])->name('logout');
Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

// vendor routes
Route::get('vendor/list', [VendorController::class, 'allVendor'])->name('vendor.list');
Route::get('vendor/add', [VendorController::class, 'getAddVendor'])->name('vendor.add');
Route::post('/vendor/add', [VendorController::class, 'addVendor']);
Route::get('vendor/update/{id}', [VendorController::class, 'getUpdateVendor'])->name('vendor.update');
Route::post('vendor/update', [VendorController::class, 'updateVendor']);
Route::get('vendor/vendor-types', [VendorController::class, 'getVendorTypes'])->name('vendor.getVendorTypes');
Route::get('vendor/delete/{id}', [VendorController::class, 'deleteVendor'])->name('vendor.delete');

//Inventory
Route::get('inventory/list', [InventoryController::class, 'allInventory'])->name('inventory.list');
Route::get('inventory/add', [InventoryController::class, 'getAddInventory'])->name('inventory.add');
Route::post('inventory/add', [InventoryController::class, 'addInventory']);


// staff routes
Route::get('staff/list', [StaffController::class, 'allStaff'])->name('staff.list');
Route::get('staff/add', [StaffController::class, 'getAddStaff'])->name('staff.add');
Route::post('/staff/add', [StaffController::class, 'addStaff']);
Route::get('staff/update/{id}', [StaffController::class, 'getUpdateStaff'])->name('staff.update');
Route::post('staff/update/', [StaffController::class, 'updateStaff']);
Route::get('staff/view/{id}', [StaffController::class, 'getViewStaff'])->name('staff.view');
Route::get('staff/view-staff/{id}', [StaffController::class, 'getViewStaffAdmin'])->name('staff.view_admin');



// master routes
Route::get('accredation-types/list', [MasterController::class, 'allAccredation'])->name('accredation_types.list');
Route::get('accredation-types/add', [MasterController::class, 'getAddAccredation'])->name('accredation_types.add');
Route::post('/accredation-types/add', [MasterController::class, 'addAccredation']);
Route::get('accredation-types/update/{id}', [MasterController::class, 'getUpdateAccredation'])->name('accredation_types.update');
Route::post('/accredation-types/update', [MasterController::class, 'updateAccredation']);
Route::get('accredation-types/delete/{id}', [MasterController::class, 'deleteAccredation'])->name('accredation_types.delete');

Route::get('designations/list', [MasterController::class, 'allDesignations'])->name('designations.list');
Route::get('designations/add', [MasterController::class, 'getAddDesignations'])->name('designations.add');
Route::post('/designations/add', [MasterController::class, 'addDesignation']);
Route::get('designations/update/{id}', [MasterController::class, 'getUpdateDesignation'])->name('designations.update');
Route::post('/designations/update', [MasterController::class, 'updateDesignation']);
Route::get('designations/delete/{id}', [MasterController::class, 'deleteDesignations'])->name('designations.delete');

Route::get('access-areas/list', [MasterController::class, 'allAccessAreas'])->name('access_areas.list');
Route::get('access-areas/add', [MasterController::class, 'getAddAccessAreas'])->name('access_areas.add');
Route::post('/access-areas/add', [MasterController::class, 'addAccessAreas']);
Route::get('access-areas/update/{id}', [MasterController::class, 'getUpdateAccessAreas'])->name('access_areas.update');
Route::post('/access-areas/update', [MasterController::class, 'updateAccessAreas']);
Route::get('access-areas/delete/{id}', [MasterController::class, 'deleteAccessAreas'])->name('access_areas.delete');

Route::get('vendor-types/list', [MasterController::class, 'allVendorTypes'])->name('vendor_types.list');
Route::get('vendor-types/add', [MasterController::class, 'getAddVendorTypes'])->name('vendor_types.add');
Route::post('/vendor-types/add', [MasterController::class, 'addVendorTypes']);
Route::get('vendor-types/update/{id}', [MasterController::class, 'getUpdateVendorTypes'])->name('vendor_types.update');
Route::post('/vendor-types/update', [MasterController::class, 'updateVendorTypes']);
Route::get('vendor-types/delete/{id}', [MasterController::class, 'deleteVendorTypes'])->name('vendor_types.delete');


});