
<?php $__env->startSection('content'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<style>
  .donut-chart {
  max-width: 100%;
  height: auto;
}
.legend-item {
  display: flex;
  align-items: center;
  margin: 4px;
}
.legend-color {
  width: 12px;
  height: 12px;
  margin-right: 5px;
  display: inline-block;
}
.w-56 {
    width: calc(var(--spacing) * 64)!important;
}

#chart-container {
     
  margin: auto;
  position: relative;
}
.chart-label {
  position: absolute;
  top:44%;
  left: 50%;
  transform: translate(-50%, -50%);
  font-weight: bold;
  font-size: 1.2rem;
}
</style>

   <!-- Main Content Wrapper -->
      <main class="w-full main-content px-[var(--margin-x)] pb-8">
      <div class=" mt-4 grid grid-cols-12 gap-4 sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6">
      <div class="col-span-12 grid grid-cols-12 rounded-lg bg-gradient-to-r from-blue-500 to-indigo-600 py-5 sm:py-6"
            >
            <div class="col-span-12 sm:col-span-6 lg:col-span-8">
              <div class="px-4 text-white sm:px-5">
                <div class="mt-3 " style=" margin-bottom: 14px;">
                  
                  <p class="text-2xl font-semibold">Event Info - <?php echo e($dashboard_data['event']['eventName']); ?></p>
                 
                </div>
                <?php
                      $dateString = $dashboard_data['event']['startDate'];

                      // Create DateTime object in UTC
                      $date = new DateTime($dateString, new DateTimeZone("UTC"));

                      // Convert to IST (Asia/Kolkata)
                      $date->setTimezone(new DateTimeZone("Asia/Kolkata"));

                      // Format as "31 Jan, 2025 | 02:54 PM IST"
                      $formattedDate = $date->format("d M, Y | h:i A") . " IST";

                    ?>
                <div class="-mt-1 flex items-center space-x-2">
                  <div class="mt-3">
                    <p class="text-base font-medium tracking-wide">Date of Event</p>
                    <p class="text-xs"><?php echo e($formattedDate); ?></p>
                  </div>
                  
                </div>
                <div class="-mt-1 flex items-center space-x-2">
                  <div class="mt-3">
                    <p class="text-base font-medium tracking-wide">Venue</p>
                    <p class="text-xs"><?php echo e($dashboard_data['event']['venue']); ?></p>
                  </div>
                  
                </div>
              </div>
            </div>

            <div class="col-span-12 sm:col-span-6 lg:col-span-4" style="margin-top: 60px;">
              <div class="px-4 text-white sm:px-5">
               
                <div class="-mt-1 flex items-center space-x-2">
                  <div class="mt-3">
                  <?php
                        $dateString = $dashboard_data['event']['endDate'];

                        // Create DateTime object in UTC
                        $date = new DateTime($dateString, new DateTimeZone("UTC"));

                        // Convert to IST (Asia/Kolkata)
                        $date->setTimezone(new DateTimeZone("Asia/Kolkata"));

                        // Format as "31 Jan, 2025 | 02:54 PM IST"
                        $formattedendDate = $date->format("d M, Y | h:i A") . " IST";

                      ?>
                    <p class="text-base font-medium tracking-wide">Event End Date</p>
                    <p class="text-xs"><?php echo e($formattedendDate); ?></p>
                  </div>
                </div>
                <div class="mt-3 " >
                  
                  <p class="text-2xl font-semibold">Event is Live</p>
                 
                </div>
              </div>
            </div>
          </div>
          <div class=" col-span-12 lg:col-span-8">
            
              <div class="flex items-center justify-between">
                <h2
                  class="text-sm-plus font-medium tracking-wide text-slate-700 dark:text-navy-100"
                >
                  Statictics
                </h2>
                
              </div>
              <?php
                  $crewUsed = $dashboard_data['statistics']['crewCount']['usedCrewCount'] ?? 0;
                  $crewTotal = $dashboard_data['statistics']['crewCount']['totalCrewCount'] ?? 0;
                  $crewPercent = $crewTotal > 0 ? round(($crewUsed / $crewTotal) * 100) : 0;

                  $formsCompleted = $dashboard_data['statistics']['formAction']['usedFormActionCount'] ?? 0;
                  $formsTotal = $dashboard_data['statistics']['formAction']['totalFormActionCount'] ?? 0;
                  $formsPercent = $formsTotal > 0 ? round(($formsCompleted / $formsTotal) * 100) : 0;

                  $formsApproved = $dashboard_data['statistics']['formApproved']['usedFormApprovedCount'] ?? 0;
                  $formsApprovedTotal = $dashboard_data['statistics']['formApproved']['totalFormApprovedCount'] ?? 0;
                  $approvedPercent = $formsApprovedTotal > 0 ? round(($formsApproved / $formsApprovedTotal) * 100) : 0;

                  $cardsPrinted = $dashboard_data['statistics']['printedCards']['usedPrintedCardsCount'] ?? 0;
                  $cardsTotal = $dashboard_data['statistics']['printedCards']['totalPrintedCardsCount'] ?? 0;
                  $printedPercent = $cardsTotal > 0 ? round(($cardsPrinted / $cardsTotal) * 100) : 0;
              ?>

              <div class="mt-3 space-y-3.5">
                <div class="card p-5">
                  <div class="flex items-center space-x-3">
                    <img class="size-10 rounded-lg object-cover object-center" src="images/illustrations/lms-ui.svg" alt="image" />
                    <div class="flex-1">
                      <div class="flex justify-between">
                        <p class="font-medium text-slate-700 dark:text-navy-100">Crew Count</p>
                      </div>
                      <div class="mt-0.5 flex text-xs text-slate-400 dark:text-navy-300">
                        <p>Utilised</p>
                        <div class="mx-2 my-1 hidden w-px bg-slate-200 dark:bg-navy-500 sm:flex"></div>
                        <p class="hidden sm:flex"><?php echo e($crewUsed); ?> out of <?php echo e($crewTotal); ?></p>
                      </div>
                    </div>
                  </div>
                  <p class="-mt-3 text-right text-xs font-medium text-primary dark:text-accent-light"><?php echo e($crewPercent); ?>%</p>
                  <div class="progress mt-2 h-1.5 bg-slate-150 dark:bg-navy-500">
                    <div class="is-active relative overflow-hidden rounded-full bg-primary dark:bg-accent" style="width: <?php echo e($crewPercent); ?>%;"></div>
                  </div>
                </div>
                <div class="card p-5">
                  <div class="flex items-center space-x-3">
                    <img class="size-10 rounded-lg object-cover object-center" src="images/illustrations/store-ui.svg" alt="image" />
                    <div class="flex-1">
                      <div class="flex justify-between">
                        <p class="font-medium text-slate-700 dark:text-navy-100">Forms Action</p>
                      </div>
                      <div class="mt-0.5 flex text-xs text-slate-400 dark:text-navy-300">
                        <p>Completed</p>
                        <div class="mx-2 my-1 hidden w-px bg-slate-200 dark:bg-navy-500 sm:flex"></div>
                        <p class="hidden sm:flex"><?php echo e($formsCompleted); ?> out of <?php echo e($formsTotal); ?></p>
                      </div>
                    </div>
                  </div>
                  <p class="-mt-3 text-right text-xs font-medium text-secondary dark:text-secondary-light"><?php echo e($formsPercent); ?>%</p>
                  <div class="progress mt-2 h-1.5 bg-secondary/15 dark:bg-secondary-light/25">
                    <div class="rounded-full bg-secondary" style="width: <?php echo e($formsPercent); ?>%;"></div>
                  </div>
                </div>
                <div class="card p-5">
                  <div class="flex items-center space-x-3">
                    <img class="size-10 rounded-lg object-cover object-center" src="images/illustrations/chat-ui.svg" alt="image" />
                    <div class="flex-1">
                      <div class="flex justify-between">
                        <p class="font-medium text-slate-700 dark:text-navy-100">Forms Approved</p>
                      </div>
                      <div class="mt-0.5 flex text-xs text-slate-400 dark:text-navy-300">
                        <p>Approved</p>
                        <div class="mx-2 my-1 hidden w-px bg-slate-200 dark:bg-navy-500 sm:flex"></div>
                        <p class="hidden sm:flex"><?php echo e($formsApproved); ?> out of <?php echo e($formsApprovedTotal); ?></p>
                      </div>
                    </div>
                  </div>
                  <p class="-mt-3 text-right text-xs font-medium text-warning"><?php echo e($approvedPercent); ?>%</p>
                  <div class="progress mt-2 h-1.5 bg-warning/15 dark:bg-warning/25">
                    <div class="rounded-full bg-warning" style="width: <?php echo e($approvedPercent); ?>%;"></div>
                  </div>
                </div>
                <div class="card p-5">
                  <div class="flex items-center space-x-3">
                    <img class="size-10 rounded-lg object-cover object-center" src="images/illustrations/nft.svg" alt="image" />
                    <div class="flex-1">
                      <div class="flex justify-between">
                        <p class="font-medium text-slate-700 dark:text-navy-100">Printed Cards</p>
                      </div>
                      <div class="mt-0.5 flex text-xs text-slate-400 dark:text-navy-300">
                        <p>Printed</p>
                        <div class="mx-2 my-1 hidden w-px bg-slate-200 dark:bg-navy-500 sm:flex"></div>
                        <p class="hidden sm:flex"><?php echo e($cardsPrinted); ?> out of <?php echo e($cardsTotal); ?></p>
                      </div>
                    </div>
                  </div>
                  <p class="-mt-3 text-right text-xs font-medium text-info"><?php echo e($printedPercent); ?>%</p>
                  <div class="progress mt-2 h-1.5 bg-info/15 dark:bg-info/25">
                    <div class="rounded-full bg-info" style="width: <?php echo e($printedPercent); ?>%;"></div>
                  </div>
                </div>
              </div>
            
            </div>
          <div
            class="col-span-12 grid grid-cols-2 gap-4 sm:grid-cols-4 sm:gap-5 lg:col-span-4 lg:grid-cols-2 lg:gap-6"
            >
            <div class="card col-span-2 px-4 pb-5 sm:px-5">
              <div class="flex items-center justify-between py-3">
                <h2
                  class="font-medium tracking-wide text-slate-700 dark:text-navy-100"
                >
                  Form Status
                </h2>
                
              </div>
              <div class="bg-white rounded-xl shadow p-4 w-full max-w-md mx-auto">
                <!-- <div class="flex flex-col items-center">
                  <svg id="donutChart" class="w-full max-h-[300px]" viewBox="0 0 250 250" preserveAspectRatio="xMidYMid meet"></svg>
                  <div id="chartLegend" class="flex flex-wrap justify-center gap-2 mt-4 text-sm text-gray-700"></div>
                </div> -->
                <div id="chart-container">
                  <canvas id="donutChart"></canvas>
                  <div class="chart-label" id="chartLabel"><?php echo e($dashboard_data['formStatus']['crewPercentage']); ?>% Used</div>
                </div>
              </div>



            </div>
            
          </div>
          
          <!-- <div class="col-span-12">
            <div class="flex items-center justify-between">
              <h2
                class="text-base font-medium tracking-wide text-slate-700 line-clamp-1 dark:text-navy-100"
              >
                All Vendor Overview
              </h2>
              <div class="flex">
                <div class="flex items-center" x-data="{isInputActive:false}">
                  <label class="block">
                    <input
                      x-effect="isInputActive === true && $nextTick(() => { $el.focus()});"
                      :class="isInputActive ? 'w-32 lg:w-48' : 'w-0'"
                      class="form-input bg-transparent px-1 text-right transition-all duration-100 placeholder:text-slate-500 dark:placeholder:text-navy-200"
                      placeholder="Search here..."
                      type="text"
                    />
                  </label>
                  <button
                    @click="isInputActive = !isInputActive"
                    class="btn size-8 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
                  >
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      class="size-4.5"
                      fill="none"
                      viewBox="0 0 24 24"
                      stroke="currentColor"
                    >
                      <path
                        stroke-linecap="round"
                        stroke-linejoin="round"
                        stroke-width="1.5"
                        d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"
                      />
                    </svg>
                  </button>
                </div>
                <div
                  x-data="usePopper({placement:'bottom-end',offset:4})"
                  @click.outside="isShowPopper && (isShowPopper = false)"
                  class="inline-flex"
                  >
                  <button
                    x-ref="popperRef"
                    @click="isShowPopper = !isShowPopper"
                    class="btn size-8 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
                  >
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      class="size-4.5"
                      fill="none"
                      viewBox="0 0 24 24"
                      stroke="currentColor"
                    >
                      <path
                        stroke-linecap="round"
                        stroke-linejoin="round"
                        stroke-width="2"
                        d="M12 5v.01M12 12v.01M12 19v.01M12 6a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2z"
                      />
                    </svg>
                  </button>
                  <div
                    x-ref="popperRoot"
                    class="popper-root"
                    :class="isShowPopper && 'show'"
                    >
                    <div
                      class="popper-box rounded-md border border-slate-150 bg-white py-1.5 font-inter dark:border-navy-500 dark:bg-navy-700"
                    >
                      <ul>
                        <li>
                          <a
                            href="#"
                            class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                            >Action</a
                          >
                        </li>
                        <li>
                          <a
                            href="#"
                            class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                            >Another Action</a
                          >
                        </li>
                        <li>
                          <a
                            href="#"
                            class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                            >Something else</a
                          >
                        </li>
                      </ul>
                      <div
                        class="my-1 h-px bg-slate-150 dark:bg-navy-500"
                      ></div>
                      <ul>
                        <li>
                          <a
                            href="#"
                            class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                            >Separated Link</a
                          >
                        </li>
                      </ul>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="card mt-3">
              <div class="is-scrollbar-hidden min-w-full overflow-x-auto">
                <table class="is-hoverable w-full text-left">
                  <thead>
                    <tr>
                      
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Date
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Vendor Name
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Form Limit
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Saved
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        All Approved 
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Submitted
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Pending
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Incorrect
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Rejected
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Verified
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Approved
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Printed
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Reprinted
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Action
                      </th>
                      
                    </tr>
                  </thead>
                  <tbody>
                    <tr class="border-y border-transparent border-b-slate-200 dark:border-b-navy-500">
                      
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p class="font-medium">25 May 2021</p>
                        <p class="mt-0.5 text-xs">01:25 AM</p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <div class="flex items-center space-x-4">
                          <div class="avatar size-9">
                            <img
                              class="mask is-squircle"
                              src="images/200x200.png"
                              alt="avatar"
                            />
                          </div>

                          <span
                            class="font-medium text-slate-700 dark:text-navy-100"
                            >Anthony Jensen
                          </span>
                        </div>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>

                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          0
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          0
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          0
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          0
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          0
                        </p>
                      </td>
                      <td data-column-id="actions" class="gridjs-td"><span><div class="flex justify-center space-x-2">
                            <button @click="editItem" class="btn size-8 p-0 text-info hover:bg-info/20 focus:bg-info/20 active:bg-info/25">
                                <i class="fa fa-edit"></i>
                            </button>
                            <button @click="deleteItem" class="btn size-8 p-0 text-error hover:bg-error/20 focus:bg-error/20 active:bg-error/25">
                                <i class="fa fa-trash-alt"></i>
                            </button>
                        </div></span>
                      </td>
                    </tr>
                    <tr class="border-y border-transparent border-b-slate-200 dark:border-b-navy-500">
                      
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p class="font-medium">25 May 2021</p>
                        <p class="mt-0.5 text-xs">01:25 AM</p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <div class="flex items-center space-x-4">
                          <div class="avatar size-9">
                            <img
                              class="mask is-squircle"
                              src="images/200x200.png"
                              alt="avatar"
                            />
                          </div>

                          <span
                            class="font-medium text-slate-700 dark:text-navy-100"
                            >Anthony Jensen
                          </span>
                        </div>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>

                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          0
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          0
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          0
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          0
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          0
                        </p>
                      </td>
                      <td data-column-id="actions" class="gridjs-td"><span><div class="flex justify-center space-x-2">
                            <button @click="editItem" class="btn size-8 p-0 text-info hover:bg-info/20 focus:bg-info/20 active:bg-info/25">
                                <i class="fa fa-edit"></i>
                            </button>
                            <button @click="deleteItem" class="btn size-8 p-0 text-error hover:bg-error/20 focus:bg-error/20 active:bg-error/25">
                                <i class="fa fa-trash-alt"></i>
                            </button>
                        </div></span>
                      </td>
                    </tr>
                    <tr class="border-y border-transparent border-b-slate-200 dark:border-b-navy-500">
                      
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p class="font-medium">25 May 2021</p>
                        <p class="mt-0.5 text-xs">01:25 AM</p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <div class="flex items-center space-x-4">
                          <div class="avatar size-9">
                            <img
                              class="mask is-squircle"
                              src="images/200x200.png"
                              alt="avatar"
                            />
                          </div>

                          <span
                            class="font-medium text-slate-700 dark:text-navy-100"
                            >Anthony Jensen
                          </span>
                        </div>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>

                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          0
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          7
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          0
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          0
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          0
                        </p>
                      </td>
                      <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                        <p
                          class="text-sm-plus font-medium text-slate-700 dark:text-navy-100"
                        >
                          0
                        </p>
                      </td>
                      <td data-column-id="actions" class="gridjs-td"><span><div class="flex justify-center space-x-2">
                            <button @click="editItem" class="btn size-8 p-0 text-info hover:bg-info/20 focus:bg-info/20 active:bg-info/25">
                                <i class="fa fa-edit"></i>
                            </button>
                            <button @click="deleteItem" class="btn size-8 p-0 text-error hover:bg-error/20 focus:bg-error/20 active:bg-error/25">
                                <i class="fa fa-trash-alt"></i>
                            </button>
                        </div></span>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
              <div
                class="flex flex-col justify-between space-y-4 px-4 py-4 sm:flex-row sm:items-center sm:space-y-0 sm:px-5"
              >
                <div class="flex items-center space-x-2 text-xs-plus">
                  <span>Show</span>
                  <label class="block">
                    <select
                      class="form-select rounded-full border border-slate-300 bg-white px-2 py-1 pr-6 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent"
                    >
                      <option>10</option>
                      <option>30</option>
                      <option>50</option>
                    </select>
                  </label>
                  <span>entries</span>
                </div>

                <ol class="pagination">
                  <li class="rounded-l-lg bg-slate-150 dark:bg-navy-500">
                    <a
                      href="#"
                      class="flex size-8 items-center justify-center rounded-lg text-slate-500 transition-colors hover:bg-slate-300 focus:bg-slate-300 active:bg-slate-300/80 dark:text-navy-200 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90"
                    >
                      <svg
                        xmlns="http://www.w3.org/2000/svg"
                        class="size-4"
                        fill="none"
                        viewBox="0 0 24 24"
                        stroke="currentColor"
                        stroke-width="2"
                      >
                        <path
                          stroke-linecap="round"
                          stroke-linejoin="round"
                          d="M15 19l-7-7 7-7"
                        />
                      </svg>
                    </a>
                  </li>
                  <li class="bg-slate-150 dark:bg-navy-500">
                    <a
                      href="#"
                      class="flex h-8 min-w-[2rem] items-center justify-center rounded-lg px-3 leading-tight transition-colors hover:bg-slate-300 focus:bg-slate-300 active:bg-slate-300/80 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90"
                      >1</a
                    >
                  </li>
                  <li class="bg-slate-150 dark:bg-navy-500">
                    <a
                      href="#"
                      class="flex h-8 min-w-[2rem] items-center justify-center rounded-lg bg-primary px-3 leading-tight text-white transition-colors hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
                      >2</a
                    >
                  </li>
                  <li class="bg-slate-150 dark:bg-navy-500">
                    <a
                      href="#"
                      class="flex h-8 min-w-[2rem] items-center justify-center rounded-lg px-3 leading-tight transition-colors hover:bg-slate-300 focus:bg-slate-300 active:bg-slate-300/80 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90"
                      >3</a
                    >
                  </li>
                  <li class="bg-slate-150 dark:bg-navy-500">
                    <a
                      href="#"
                      class="flex h-8 min-w-[2rem] items-center justify-center rounded-lg px-3 leading-tight transition-colors hover:bg-slate-300 focus:bg-slate-300 active:bg-slate-300/80 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90"
                      >4</a
                    >
                  </li>
                  <li class="bg-slate-150 dark:bg-navy-500">
                    <a
                      href="#"
                      class="flex h-8 min-w-[2rem] items-center justify-center rounded-lg px-3 leading-tight transition-colors hover:bg-slate-300 focus:bg-slate-300 active:bg-slate-300/80 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90"
                      >5</a
                    >
                  </li>
                  <li class="rounded-r-lg bg-slate-150 dark:bg-navy-500">
                    <a
                      href="#"
                      class="flex size-8 items-center justify-center rounded-lg text-slate-500 transition-colors hover:bg-slate-300 focus:bg-slate-300 active:bg-slate-300/80 dark:text-navy-200 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90"
                    >
                      <svg
                        xmlns="http://www.w3.org/2000/svg"
                        class="size-4"
                        fill="none"
                        viewBox="0 0 24 24"
                        stroke="currentColor"
                      >
                        <path
                          stroke-linecap="round"
                          stroke-linejoin="round"
                          stroke-width="2"
                          d="M9 5l7 7-7 7"
                        />
                      </svg>
                    </a>
                  </li>
                </ol>

                <div class="text-xs-plus">1 - 10 of 10 entries</div>
              </div>
            </div>
          </div> -->
        </div>
        <div class="mt-4 grid grid-cols-12 gap-4 sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6" >
            <div class="card col-span-12">
              <div class="my-3 flex items-center justify-between px-4 sm:px-5">
                <h2
                  class="font-medium tracking-wide text-slate-700 dark:text-navy-100"
                >
                  Top Vendors
                </h2>
                
              </div>
              <div
                class="scrollbar-sm flex space-x-3 overflow-x-auto px-4 pb-3 sm:px-5"
                >
                <?php $__currentLoopData = $dashboard_data['topVendors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div
                  class="w-56 shrink-0 rounded-xl bg-slate-50 p-4 dark:bg-navy-600"
                  >
                  <div class="flex flex-col items-center space-y-3 text-center">
                    <div
                      class="size-16 rounded-full bg-gradient-to-r from-sky-400 to-blue-600 p-0.5"
                    >
                      <img
                        class="h-full w-full rounded-full border-2 border-white object-cover object-center dark:border-navy-700"
                        src="<?php echo e(url('images/200x200.png')); ?>"
                        alt="image"
                      />
                    </div>
                    <div>
                      <p
                        class="text-base font-medium text-slate-700 dark:text-navy-100"
                      >
                        <?php echo e($data['vendorName']); ?>

                      </p>
                      <p class="text-xs-plus text-slate-400 dark:text-navy-300">
                      <?php echo e($data['vendorType']); ?>

                      </p>
                    </div>
                  </div>
                  <div class="mt-5">
                    <div>
                      <p>Max Staff</p>
                      <div class="mt-0.5 flex space-x-2">
                        <p
                          class="text-xl font-semibold text-slate-700 dark:text-navy-100"
                        >
                        <?php echo e($data['staffCount']); ?>

                        </p>
                        
                      </div>
                    </div>
                    
                  </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
              </div>
            </div>
        </div>
      </main>
  
<script src="https://d3js.org/d3.v6.min.js"></script>


<!-- <script>
  const response = <?php echo json_encode($dashboard_data, 15, 512) ?>;
  console.log(response);
  const stats = response.formStatus;

  // Data for donut
  const data = [
    { label: "Printed", value: stats.printed || 0, color: "#fbbc05" },
    { label: "Approved", value: stats.approved || 0, color: "#6a1b9a" },
    { label: "Rejected", value: stats.rejected || 0, color: "#f8bbd0" },
    { label: "Reprinted", value: stats.reprinted || 0, color: "#34a853" },
    { label: "Blacklisted", value: stats.blacklisted || 0, color: "#ea4335" },
    { label: "Incorrect Data", value: stats.incorrect || 0, color: "#e0e0e0" }
  ];

  // Size settings
  const width = 250;
  const height = 250;
  const radius = Math.min(width, height) / 2;

  // Create SVG group
  const svg = d3.select("#donutChart")
    .html("")  // Clear previous chart if rerendered
    .append("svg")
    .attr("width", width)
    .attr("height", height)
    .append("g")
    .attr("transform", `translate(${width / 2}, ${height / 2})`);

  // Pie and arc setup
  const arc = d3.arc()
    .innerRadius(radius - 50)
    .outerRadius(radius - 5);

  const pie = d3.pie()
    .value(d => d.value)
    .sort(null);

  // Draw chart
  const g = svg.selectAll(".arc")
    .data(pie(data))
    .enter().append("g")
    .attr("class", "arc");

  g.append("path")
    .attr("d", arc)
    .style("fill", d => d.data.color);

  // Calculate usage percent
  let usedPercent = 0;
  if (stats.formLimit > 0) {
    usedPercent = (stats.approved / stats.formLimit) * 100;
  }

  // Center Text
  svg.append("text")
    .attr("text-anchor", "middle")
    .attr("dy", "-0.3em")
    .style("font-size", "16px")
    .style("font-weight", "bold")
    .text(stats.formLimit > 0 ? `${stats.saved} of ${stats.formLimit} Used` : `${stats.saved} Saved`);

  svg.append("text")
    .attr("text-anchor", "middle")
    .attr("dy", "1.2em")
    .style("font-size", "14px")
    .text(stats.formLimit > 0 ? `${Math.round(usedPercent)}%` : '');

  // Draw legend
  const legendContainer = d3.select("#chartLegend").html(""); // Clear previous
  data.forEach(d => {
    legendContainer.append("div")
      .attr("class", "flex items-center space-x-2 text-sm mb-1")
      .html(`
        <span class="inline-block w-3 h-3 rounded-full" style="background-color: ${d.color};"></span>
        <span>${d.label}</span>
      `);
  });
</script> -->
<script>
    const response = <?php echo json_encode($dashboard_data, 15, 512) ?>;
    console.log(response);
    const stats = response.formStatus;
   
    const data = {
      labels: ['Printed', 'Approved', 'Rejected', 'Reprinted', 'Blacklisted', 'Incorrect Data'],
      datasets: [{
        data: [stats.printed, stats.approved, stats.rejected, stats.reprinted, stats.blacklisted, stats.incorrect],
        backgroundColor: ['#fbbc05', '#6a1b9a', '#f8bbd0', '#34a853', '#ea4335', '#e0e0e0'],
        hoverOffset: 10
      }]
    };

    const config = {
      type: 'doughnut',
      data: data,
      options: {
        cutout: '70%',
        plugins: {
          tooltip: {
            callbacks: {
              label: function(context) {
                const label = context.label || '';
                const value = context.raw || 0;
                return `${label}: ${value}%`;
              }
            }
          },
          legend: {
            position: 'bottom'
          }
        }
      }
    };

    const donutChart = new Chart(
      document.getElementById('donutChart'),
      config
    );
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Laravel\eventManagement\resources\views/index.blade.php ENDPATH**/ ?>