<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Profile & Document Viewer</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <link href='https://fonts.googleapis.com/css?family=Inter' rel='stylesheet'>
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" media="print">

  <style>
    body {
      font-family: 'Inter';
    }
    .image-container {
      position: relative;
      background: #545454;
      text-align: center;
      padding: 1rem;
      overflow: hidden;
      height: 260px;
    }

    .zoom-percentage {
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      background: rgba(0, 0, 0, 0.5);
      color: white;
      font-weight: normal;
      padding: 0.5rem 1rem;
      border-radius: 8px;
      font-size: 1rem;
      opacity: 0;
      transition: opacity 0.3s ease;
      pointer-events: none;
    }

    .image-container:hover .zoom-percentage {
      opacity: 1;
    }

    .doc-image {
      max-height: 100%;
      max-width: 100%;
      transition: transform 0.3s ease;
      transform-origin: center center;
      display: inline-block;
    }

    .image-controls {
      margin-top: 1rem;
      flex-wrap: wrap;
    }

    .zoom-icon-top {
      position: absolute;
      top: -8px;
      right: -6px;
      background: rgb(199 199 199 / 90%);
      border-radius: 50%;
      padding: 11px;
      cursor: pointer;
    }

    .doc-box {
      border: 1px solid #ccc;
      border-radius: 6px;
      padding: 1rem;
    }

    .h-100-container {
      height: 100%;
      display: flex;
      flex-direction: column;
    }

    .nav-pills .nav-link.active, .nav-pills .show>.nav-link {
      color: #ffffff !important;
      background-color: #959698 !important;
    }

    @media (max-width: 576px) {
      .image-container {
        height: auto;
        padding: 0.5rem;
      }

      .doc-image {
        max-height: 200px;
        width: 100%;
      }

      .zoom-icon-top {
        top: 4px;
        right: 4px;
        padding: 8px;
      }

      .zoom-percentage {
        font-size: 0.875rem;
        padding: 0.25rem 0.5rem;
      }

      .doc-box {
        padding: 0.75rem;
      }

      ul.list-unstyled li {
        font-size: 0.875rem;
      }

      h6, .fw-bold {
        font-size: 1rem;
      }
    }

    @media print {
        body * {
            visibility: hidden;
        }

        #cardBlock, #cardBlock * {
            visibility: visible;
        }

        #cardBlock {
            position: absolute;
            left: 0;
            top: 0;
            width: 100%;
        }
        }
  </style>
</head>
<body>
    <div class="p-2 bg-light shadow-sm rounded">
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-center align-items-md-center gap-2">
          
          <!-- Back Button -->
         
      
          <!-- Application Barcode and Cloned From Info -->
          <div class="flex-grow-1 w-100">
            <div class="d-flex flex-column flex-md-row justify-content-start align-items-start gap-3">
                <div>
                  
                    <?php if($staff_details['verificationStatus'] == 'PRINTED'): ?>
                    <button class="btn btn-outline-primary rounded-5"><i class="bi bi-printer"></i> Printed</button>
                    <?php else: ?>
                    <button class="btn btn-outline-primary rounded-5"></i> <?php echo e($staff_details['verificationStatus']); ?></button>

                    <?php endif; ?>
                  </div>
                  <?php if($staff_details['verificationStatus'] == 'PRINTED' || $staff_details['verificationStatus'] == 'REPRINTED'): ?>
                  <div>
                    <div class="small text-muted">Application id</div>
                    <div class="fw-semibold text-wrap"><?php echo e($staff_details['applicationId']); ?></div>
                  </div>
                  <?php endif; ?>
              <div>
              <?php if($staff_details['verificationStatus'] == 'PRINTED' || $staff_details['verificationStatus'] == 'REPRINTED'): ?>
                <div class="small text-muted">Application Barcode</div>
                <div class="fw-semibold text-wrap"><?php echo e($staff_details['barcode']); ?></div>
              <?php endif; ?>
              </div>
             
              
            </div>
          </div>
          <div class="flex-grow-1 w-100">
            <div class="d-flex flex-column flex-md-row justify-content-end align-items-end gap-3">
                <button class="btn"> Mark As</button>
                <?php if($staff_details['verificationStatus'] == 'APPROVED'): ?>
                    <button class="btn btn-outline-primary rounded-5"
                        data-bs-toggle="modal" data-bs-target="#printModal">
                        <i class="bi bi-printer"></i> Send to Print
                    </button>
                <?php endif; ?>

                <?php if($staff_details['verificationStatus'] == 'PRINTED'): ?>
                    <button class="btn btn-outline-primary rounded-5"
                        data-bs-toggle="modal" data-bs-target="#printModal">
                        <i class="bi bi-printer"></i> Send to Re-Print
                    </button>
                <?php endif; ?>
              
                <button class="btn btn-outline-danger rounded-5" onclick="submitBulkStatus(0, 'BLACKLISTED')"><i class="bi bi-printer"></i> Blacklist</button>
                <button class="btn"> <i class="bi bi-three-dots-vertical"></i></button>
            </div>
          </div>
      
          <!-- Prev/Next Buttons -->
          <div class="d-flex gap-2 flex-nowrap">
          <div class="flex justify-center space-x-2">
            <a href="<?php echo e(route('staff.list')); ?>">
            <button
              class="btn min-w-[7rem] bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
            >
              Previous
            </button>
            </a>
          </div>
          </div>
      
        </div>
    </div>
      
    <div class="shadow p-2">
        
        <div class="row mt-3" style="min-height: 100vh;">
        
        <!-- Left Section -->
        <div class="col-md-6 h-100 d-flex flex-column">
            <div class="row flex-grow-1">
            
            <!-- Sidebar -->
            <div class="col-md-5">
                <div class="h-100">
                <div class="text-center shadow p-1 w-100 h-100 border bgimg rounded" id="cardBlock">
                    <div class="mb-3 mt-5">
                    <img src="<?php echo e($staff_details['profilePicture']); ?>" class="img-fluid rounded shadow border" style="max-height: 140px;" alt="Profile Image">
                    </div>
                    <div class="fw-bold mt-2" style="font-size: 14px;">
                    <div><?php echo e($staff_details['firstName']); ?> <?php echo e($staff_details['middleName']); ?> <?php echo e($staff_details['lastName']); ?></div>
                    <div><?php echo e($staff_details['designationDetails']); ?></div>
                    <div><?php echo e($staff_details['city']); ?></div>
                    <div><?php echo e($staff_details['accreditationTypeName']); ?></div>
                    </div>

                    <!-- Grid Boxes -->
                    <?php
    // Get access areas from staff details
    $accessAreas = $staff_details['vendorAccessAreaList'] ?? [];

    // Filter only selected access areas
    $selectedAreas = collect($accessAreas)
        ->filter(fn($area) => $area['isSelectedByStaff'])
        ->values();

    // Extract access area codes
    $codes = $selectedAreas->pluck('accessAreaCode')->toArray();

    // Fill 6 positions with blank initially
    $finalBoxes = array_fill(0, 6, '');

    // Populate the boxes with numeric codes
    foreach ($codes as $code) {
        if (is_numeric($code)) {
            $position = (int)$code - 1;
            if ($position >= 0 && $position < 6) {
                $finalBoxes[$position] = $code;
            }
        }
    }

    // If '#' is in codes, place it at the last position
    if (in_array('#', $codes)) {
        $finalBoxes[5] = '#';
    }
?>

<div class="container mt-5">
    <?php for($row = 0; $row < 2; $row++): ?>
        <div class="row justify-content-center g-2 mt-2" style="gap: 6px !important;">
            <?php for($col = 0; $col < 3; $col++): ?>
                <?php
                    $index = $row * 3 + $col;
                ?>
                <div class="col-2 border border-2 rounded border-black d-flex align-items-center justify-content-center" 
                    style="height: 40px; width: 40px;">
                    <?php echo e($finalBoxes[$index] ?: ''); ?>

                </div>
            <?php endfor; ?>
        </div>
    <?php endfor; ?>
</div>


                    <div class="mt-3 fw-bold" >
                    <button class="btn btn-outline-primary"  onclick="printDiv('cardBlock')">
                        <i class="bi bi-printer"></i> Print Card
                    </button>
                    </div>
                </div>
                </div>
            </div>

            <!-- Details -->
            <div class="col-md-7 d-flex flex-column">
                <div class="container  rounded p-4 flex-grow-1" style="font-size: 12.6px;">
                    


                <ul class="list-unstyled">
                    <li class="d-flex mb-2"><div class="col-4">Father's Name:</div><div class="col"><?php echo e($staff_details['fatherName']); ?></div></li>
                    <li class="d-flex mb-2"><div class="col-4">Gender:</div><div class="col"><?php echo e($staff_details['gender']); ?></div></li>
                    <li class="d-flex mb-2"><div class="col-4">Date of Birth:</div><div class="col"><?php echo e($staff_details['dob']); ?></div></li>
                    <li class="d-flex mb-2"><div class="col-4">Address:</div><div class="col"><?php echo e($staff_details['addressLine1']); ?></div></li>
                    <li class="d-flex mb-2"><div class="col-4">Address Line 2:</div><div class="col"><?php echo e($staff_details['addressLine2']); ?></div></li>
                    <li class="d-flex mb-2"><div class="col-4">Country:</div><div class="col"><?php echo e($staff_details['country']); ?></div></li>
                    <li class="d-flex mb-2"><div class="col-4">State:</div><div class="col"><?php echo e($staff_details['state']); ?></div></li>
                    <li class="d-flex mb-2"><div class="col-4">City:</div><div class="col"><?php echo e($staff_details['city']); ?></div></li>
                    <li class="d-flex mb-2"><div class="col-4">Pincode:</div><div class="col"><?php echo e($staff_details['postalCode']); ?></div></li>
                </ul>

             
                <ul class="list-unstyled">
                   
                    <li class="d-flex mb-2">
                        <div class="col-4">Only Concourse Access:</div>
                        <div class="col"><?php echo e($staff_details['onlyConcourseAccess'] ? 'Yes' : 'No'); ?></div>
                    </li>
                    <?php if($staff_details['onlyConcourseAccess'] == false): ?>
                    <li class="d-flex mb-2">
                        <div class="col-4">Access Areas:</div>
                        <div class="col"><?php echo e($staff_details['accessAreas']); ?> </div>
                    </li>
                    <?php endif; ?>
                </div>
            </div>

            </div>
        </div>

        <!-- Right Section -->
        <div class="col-md-6 h-100 d-flex flex-column">
            <div class="container flex-grow-1 d-flex flex-column">
            <div class="doc-box flex-grow-1 d-flex flex-column">
                <!-- Tabs -->
                <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active text-dark" id="front-tab" data-bs-toggle="pill" data-bs-target="#front" type="button" role="tab">ID Proof Front</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link text-dark" id="back-tab" data-bs-toggle="pill" data-bs-target="#back" type="button" role="tab">ID Proof Back</button>
                </li>
                </ul>

                <!-- Tab Content -->
                <div class="tab-content flex-grow-1" id="pills-tabContent">
                <div class="tab-pane fade show active h-100" id="front" role="tabpanel">
                    <div class="image-container">
                    <img src="<?php echo e($staff_details['idProofFront']); ?>" alt="Uploaded Document" class="doc-image">
                    <i class="bi bi-arrows-fullscreen zoom-icon-top" onclick="openFullscreen()"></i>
                    <div class="zoom-percentage" id="zoomPercentage">100%</div>

                    </div>
                    <div class="image-controls justify-content-center d-flex">
                    <button class="btn  me-2" onclick="zoom(1.1)"><i class="bi bi-zoom-in"></i></button>
                    <button class="btn  me-2" onclick="zoom(0.9)"><i class="bi bi-zoom-out"></i></button>
                    <button class="btn  me-2" onclick="rotate(-90)"><i class="bi bi-arrow-counterclockwise"></i></button>
                    <button class="btn " onclick="rotate(90)"><i class="bi bi-arrow-clockwise"></i></button>
                    </div>
                    <div class="mt-3">
                        <h6 class="fw-bold">Id Proof Front Details</h6>
                        <div class="d-flex justify-content-between">
                        <p>Id Type: <?php echo e($staff_details['idType']); ?></p>
                        <p>Id Number: <?php echo e($staff_details['idNumber']); ?></p>
                        </div>
                    </div>
                </div>

                <div class="tab-pane fade h-100" id="back" role="tabpanel">
                    <div class="image-container">
                    <img src="<?php echo e($staff_details['idProofBack']); ?>" alt="Uploaded Document" class="doc-image">
                    <i class="bi bi-arrows-fullscreen zoom-icon-top" onclick="openFullscreen()"></i>
                    <div class="zoom-percentage" id="zoomPercentage">100%</div>

                    </div>
                    <div class="image-controls justify-content-center d-flex">
                    <button class="btn  me-2" onclick="zoom(1.1)"><i class="bi bi-zoom-in"></i></button>
                    <button class="btn  me-2" onclick="zoom(0.9)"><i class="bi bi-zoom-out"></i></button>
                    <button class="btn  me-2" onclick="rotate(-90)"><i class="bi bi-arrow-counterclockwise"></i></button>
                    <button class="btn " onclick="rotate(90)"><i class="bi bi-arrow-clockwise"></i></button>
                    </div>
                    <div class="mt-3">
                    <h6 class="fw-bold">Id Proof Back Details</h6>
                    <div class="d-flex justify-content-between">

                    <p>Id Type: <?php echo e($staff_details['idType']); ?></p>
                    <p>Id Number: <?php echo e($staff_details['idNumber']); ?></p>
                    </div>
                    
                    </div>
                </div>
                </div>
            </div>
            </div>

            <!-- Fullscreen Modal -->
            <div class="modal fade" id="fullscreenModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-fullscreen">
                <div class="modal-content bg-dark text-white">
                <div class="modal-header border-0">
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body d-flex justify-content-center align-items-center">
                    <img src="<?php echo e(url('images/sample-pan-card.jpg')); ?>" id="fullscreenImg" class="img-fluid" alt="Fullscreen">
                </div>
                </div>
            </div>
            </div>
        </div>

        </div>
    </div>

    <div class="modal fade" id="printModal" tabindex="-1" aria-labelledby="printModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-lg">
          <div class="modal-content rounded-4">
          <div class="modal-header">
              <h5 class="modal-title" id="printModalLabel">Print Information</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <form id="printForm">
              <input type="hidden" id="staffId" class="form-control" name="staffId" value="<?php echo e($staff_details['staffId']); ?>" >
              <div class="modal-body">
              <div class="row g-3">
                  <div class="col-md-6">
                  <label for="printDate" class="form-label">Date</label>
                  <input type="date" id="printDate" class="form-control" name="print_date" required>
                  </div>
                  <div class="col-md-6">
                  <label for="printTime" class="form-label">Time</label>
                  <input type="time" id="printTime" class="form-control" name="print_time" required>
                  </div>
                  <div class="col-md-6">
                  <label for="printType" class="form-label">Type of Print</label>
                  <?php if($staff_details['verificationStatus'] == 'APPROVED'): ?>
                  <input type="text" class="form-control" id="printType" name="print_type" value="PRINT" required readonly>
                  <?php endif; ?>  
                  <?php if($staff_details['verificationStatus'] == 'PRINTED'): ?>
                  <input type="text" class="form-control" id="printType" name="print_type" value="REPRINT" required readonly>
                  <?php endif; ?>   
                
                  </div>
                  <div class="col-md-6">
                  <label for="serialNo" class="form-label">Serial Number</label>
                  <input type="text" class="form-control" id="serialNo" name="serial_no">
                  </div>
                  <div class="col-12">
                  <label for="reason" class="form-label">Reason for Print</label>
                  <textarea class="form-control" id="reason" name="reason" rows="2" placeholder="Enter reason..." required></textarea>
                  </div>
                  <div class="col-md-6">
                  <label for="accreditationType" class="form-label">Accreditation Type</label>
                  <input type="hidden" class="form-control" id="accreditationType" name="accreditation_type" value="<?php echo e($staff_details['accreditationTypeId']); ?>">
                  <input type="text" class="form-control"   value="<?php echo e($staff_details['accreditationTypeName']); ?>" readonly>
                  </div>
                  <div class="col-md-6">
                  <label for="barcode" class="form-label">Barcode</label>
                  <input type="text" class="form-control" id="barcode" name="barcode" placeholder="Enter barcode">
                  </div>
                  
                  
              </div>
              </div>
              <div class="modal-footer">
              <button type="button" class="btn btn-secondary rounded-5" data-bs-dismiss="modal">Cancel</button>
              <button type="submit" class="btn btn-primary rounded-5">Submit</button>
              </div>
          </form>
          </div>
      </div>
    </div>


    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
  document.addEventListener('DOMContentLoaded', function () {
    const dateInput = document.getElementById('printDate');
    const timeInput = document.getElementById('printTime');

    const now = new Date();

    // Set today's date in YYYY-MM-DD format
    dateInput.value = now.toISOString().split('T')[0];

    // Set current time in HH:MM format
    const hours = now.getHours().toString().padStart(2, '0');
    const minutes = now.getMinutes().toString().padStart(2, '0');
    timeInput.value = `${hours}:${minutes}`;
  });
</script>

  <script>
    let scale = 1;
    let rotation = 0;

    const zoomStep = 0.1;
    const minZoom = 0.5;
    const maxZoom = 3;

    function applyTransform() {
      const img = document.querySelector('.tab-pane.active img.doc-image');
      const zoomText = document.querySelector('.tab-pane.active .zoom-percentage');
      if (img && zoomText) {
        img.style.transform = `scale(${scale}) rotate(${rotation}deg)`;
        zoomText.textContent = `${Math.round(scale * 100)}%`;

        zoomText.style.opacity = 1;
        clearTimeout(zoomText._fadeTimeout);
        zoomText._fadeTimeout = setTimeout(() => {
          zoomText.style.opacity = 0;
        }, 1000);
      }
    }

    function zoom(factor) {
      scale *= factor;
      scale = Math.max(minZoom, Math.min(maxZoom, scale));
      applyTransform();
    }

    function rotate(deg) {
      rotation += deg;
      applyTransform();
    }

    function openFullscreen() {
      const modal = new bootstrap.Modal(document.getElementById('fullscreenModal'));
      const currentImg = document.querySelector('.tab-pane.active img.doc-image');
      const fullscreenImg = document.getElementById('fullscreenImg');
      if (currentImg && fullscreenImg) {
        fullscreenImg.src = currentImg.src;
        modal.show();
      }
    }

    document.querySelectorAll('.image-container').forEach(container => {
      container.addEventListener('wheel', function(e) {
        e.preventDefault();
        zoom(e.deltaY < 0 ? 1 + zoomStep : 1 - zoomStep);
      }, { passive: false });
    });

    
  </script>



<script>
function printDiv(divId) {
    const content = document.getElementById(divId).innerHTML;

    const printWindow = window.open('', '', 'width=1000,height=700');
    printWindow.document.write(`
        <html>
        <head>
            <title>Print Card</title>
            <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
            <style>
                .print-container {
                    padding: 20px;
                    max-width: 500px;
                    margin: auto;
                }
                .border-black {
                    border-color: #000 !important;
                }
                .bgimg {
                    background-size: cover;
                    background-position: center;
                    background-repeat: no-repeat;
                }
                @media print {
                    body {
                        margin: 0;
                        padding: 0;
                    }
                    .btn {
                        display: none;
                    }
                }
            </style>
        </head>
        <body>
            <div class="container print-container">
                <div class="row justify-content-center">
                    <div class="col-md-5">
                        <div class="h-100">
                            <div class="text-center shadow p-1 w-100 h-100 border bgimg rounded">
                                ${content}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <script>
                window.onload = function () {
                    window.print();
                    window.close();
                };
            <\/script>
        </body>
        </html>
    `);
    printWindow.document.close();
}
</script>
<script>
    function submitBulkStatus(typeId, status) {
    const selectedIds = [];
    const staffId = document.getElementById('staffId').value;
    const token = "<?php echo e(session('token')); ?>";
    description = 'Bulk Approved';
    selectedIds.push(staffId);

    const payload = {
      accreditationTypeId: typeId,
      description: description,
      staffIds: selectedIds,
      verificationStatus: status
    };
    console.log(payload);
    fetch("https://ac-api.omsdev.in:2002/api/staff/updateStaffVerificationStatus", {
      method: "PUT",
      headers: {
        'Authorization': `Bearer ${token}`,
        "Content-Type": "application/json"
      },
      body: JSON.stringify(payload)
    })
    .then(res => res.json())
    .then(() => {
      alert("Status updated successfully");
      window.location.reload();
    })
    .catch(err => {
      console.error(err);
      alert("Error during bulk update");
    });
  }
</script>
<script>
    document.getElementById('printForm').addEventListener('submit', async function (e) {
    e.preventDefault();


    // Collect form values
    const staffId = document.getElementById('staffId').value;
    const printType = document.getElementById('printType').value;
    const reason = document.getElementById('reason').value;
    const barcode = document.getElementById('barcode').value;
    const serialNo = document.getElementById('serialNo').value;
    const accreditationType = document.getElementById('accreditationType').value;
    const token = "<?php echo e(session('token')); ?>";

    // First API: Bulk update verification status
    const status = (printType === 'PRINT') ? 'PRINTED' : 'REPRINTED';
    const typeId = accreditationType || 0;
     console.log(status);   
    // await submitBulkStatus(typeId, status);

    const payload = {
        accreditationTypeId: typeId,
        staffId: staffId,
        serialNumber: serialNo,
        barcode: barcode,
        printDetailsId: 0,
        reasonOfPrint: reason,
        typeOfPrint: status
    };
    console.log(payload);
    try {
        const res = await fetch("https://ac-api.omsdev.in:2002/api/master/saveOrUpdatePrint", {
        method: "POST",
        headers: {
            'Authorization': `Bearer ${token}`,
            'Accept': 'application/json',
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(payload)
        });

        if (!res.ok) {
        throw new Error(`Print API failed `);
        }

        console.log(`Print record saved `);
        window.location.reload();
    } catch (error) {
        console.error(error);
        alert(`Failed to save print `);
    }

    alert("Print submitted successfully");
    document.getElementById('printForm').reset();
    const modal = bootstrap.Modal.getInstance(document.getElementById('printModal'));
    modal.hide();

    });
</script>




</body>

</html>
<?php /**PATH C:\Laravel\eventManagement\resources\views/staffs/view_staff_admin.blade.php ENDPATH**/ ?>