<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Session;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Support\Facades\Config;
use Kreait\Firebase\Factory;
use Kreait\Firebase\Auth;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;
use Kreait\Laravel\Firebase\Facades\Firebase;

class PublicController extends Controller
{

    public $adminbaseUrl;
    public $vendorbaseUrl;
    protected $auth;

    public function __construct()
    {
        // Initialize from config
        $this->adminbaseUrl = config('app.admin_base_url');
        $this->vendorbaseUrl = config('app.vendor_base_url');
        
        
    }

    private function fetchApiData($url) {
        $token = session('token'); // Get token from session
    
        $curl = curl_init();
    
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $token,
                'Accept: application/json',
            ],
        ));
    
        $response = curl_exec($curl);
        // dd($response);
        if (curl_errno($curl)) {
            $error_msg = curl_error($curl);
            curl_close($curl);
            dd("cURL Error: " . $error_msg);
        }
    
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
    
        if ($httpCode !== 200) {
            dd("HTTP Code: $httpCode", $response);
        }
    
        $decoded = json_decode($response, true);
        if ($decoded === null) {
            dd("JSON Decode Error", $response);
        }
    
        return $decoded;
    }

    private function fetchApiStaffData($url) {
        
        $curl = curl_init();
    
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => [
                'Accept: application/json',
            ],
        ));
    
        $response = curl_exec($curl);
    
        if (curl_errno($curl)) {
            $error_msg = curl_error($curl);
            curl_close($curl);
            dd("cURL Error: " . $error_msg);
        }
    
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
    
        if ($httpCode !== 200) {
            dd("HTTP Code: $httpCode", $response);
        }
    
        $decoded = json_decode($response, true);
        if ($decoded === null) {
            dd("JSON Decode Error", $response);
        }
    
        return $decoded;
    }

    
    public function dashboard(){

    //     $imagePath = public_path('images/images.jpg');
    // $outputPath = public_path('images/output.png');

    // // Wrap paths in quotes to handle spaces
    // $command = "rembg i \"$imagePath\" \"$outputPath\"";

    // // Run the command
    // $output = shell_exec($command);

    // // Check if the output file was created
    // if (!file_exists($outputPath)) {
    //     return response()->json([
    //         'error' => 'Output file was not created',
    //         'command_output' => $output,
    //     ]);
    // }

    // // Return the file for download
    // return response()->download($outputPath);
        









        // $apiKey = 'sk_pr_f9556c6b52660874b582c904326810322489d37d';
        // $imagePath = public_path('images/images.jpg');
        // $outputPath = public_path('images/output.png');

        // $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL, 'https://sdk.photoroom.com/v1/segment');
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        // curl_setopt($ch, CURLOPT_POST, 1);

        // $data = [
        //     'image_file' => new \CURLFile($imagePath),
        //     'size' => 'auto',
        // ];

        // curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        // curl_setopt($ch, CURLOPT_HTTPHEADER, [
        //     "X-Api-Key: $apiKey"
        // ]);

        // $response = curl_exec($ch);

        // if(curl_getinfo($ch, CURLINFO_HTTP_CODE) == 200){
        //     file_put_contents($outputPath, $response);
        // } else {
        //     echo 'Error: ' . curl_error($ch);
        // }

        // curl_close($ch);


        // dd($response);
        $dashboard_data = $this->fetchApiData($this->adminbaseUrl . '/api/vendor/getDashboard');
        
        if(isset($dashboard_data['status']) && $dashboard_data['status'] == 0){
            $dashboard_data = $dashboard_data['response'];
        }
        // dd($dashboard_data);
        return view('index', compact('dashboard_data'));
    }

    public function vendorDashboard(){
        $value = session('token');
        // dd($value);
        $dashboard_data = $this->fetchApiData($this->vendorbaseUrl . '/api/vendor/getDashboard');
        
        if(isset($dashboard_data['status']) && $dashboard_data['status'] == 0){
            $dashboard_data = $dashboard_data['response'];
        }
        // dd($dashboard_data);
        return view('vendor_dashboard', compact('dashboard_data'));
    }

    public function getURL($event_name, $vendor_id){
        return view('register_staff', compact('event_name', 'vendor_id'));
    }

    public function registerStaff(Request $request){
        
        return view('add_registered_staff');
    }

    // public function verifyOtp(Request $request)
    // {
    //     $idToken = $request->input('idToken');

    //     $firebase = (new Factory)->withServiceAccount(storage_path('app/firebase_credentials.json'));
    //     $auth = $firebase->createAuth();

    //     try {
    //         $verifiedIdToken = $auth->verifyIdToken($idToken);
    //         $uid = $verifiedIdToken->claims()->get('sub');

    //         $firebaseUser = $auth->getUser($uid);

    //         // Create or find user
    //         $user = User::firstOrCreate([
    //             'firebase_uid' => $firebaseUser->uid,
    //         ], [
    //             'name' => $firebaseUser->displayName ?? 'Firebase User',
    //             'email' => $firebaseUser->email,
    //             'phone' => $firebaseUser->phoneNumber,
    //         ]);

    //         auth()->login($user);

    //         return response()->json(['status' => 'success', 'message' => 'OTP verified']);
    //     } catch (\Throwable $e) {
    //         return response()->json(['status' => 'error', 'message' => 'Invalid token'], 401);
    //     }
    // }

    public function storeDeviceToken(Request $request)
    {
        $request->validate([
            'device_token' => 'required|string',
            'phone' => 'required|string'
        ]);

        // Store in cache or database
        Cache::put('device_token_' . $request->phone, $request->device_token, 300); // 5 minutes

        return response()->json(['message' => 'Device token stored.']);
    }

    // 📲 Send OTP to device using FCM
    public function sendOtp(Request $request)
    {
        $request->validate([
            'phone' => 'required|string'
        ]);

        $deviceToken = Cache::get('device_token_' . $request->phone);

        if (!$deviceToken) {
            return response()->json(['error' => 'Device token not found.'], 404);
        }

        // Generate OTP
        $otp = rand(100000, 999999);
        Cache::put('otp_' . $request->phone, $otp, 300); // 5 minutes

        // Send FCM message
        $serverKey = env('FCM_SERVER_KEY'); // set this in .env

        $fcmResponse = Http::withHeaders([
            'Authorization' => 'key=' . $serverKey,
            'Content-Type' => 'application/json',
        ])->post('https://fcm.googleapis.com/fcm/send', [
            'to' => $deviceToken,
            'notification' => [
                'title' => 'Your OTP Code',
                'body' => "Your OTP is: $otp"
            ],
        ]);

        if ($fcmResponse->failed()) {
            Log::error('FCM send failed: ' . $fcmResponse->body());
            return response()->json(['error' => 'Failed to send OTP'], 500);
        }

        return response()->json(['message' => 'OTP sent successfully.']);
    }

    // ✅ Verify OTP
    public function verifyOtp(Request $request)
    {
        $request->validate([
            'otp' => 'required|string'
        ]);

        // This assumes the phone number is known (e.g. from session or re-submitted)
        $phone = $request->session()->get('phone'); // You can also accept phone in the request

        if (!$phone) {
            return response()->json(['error' => 'Phone number missing from session'], 400);
        }

        $cachedOtp = Cache::get('otp_' . $phone);

        if ($request->otp === $cachedOtp) {
            // OTP verified
            Cache::forget('otp_' . $phone);
            return response()->json(['message' => 'OTP verified successfully.']);
        } else {
            return response()->json(['error' => 'Invalid OTP.'], 401);
        }
    }



    public function verifyStaffOtp(Request $request){
        //    dd($request->all())      ;
        $otp = $request->input('otp');
        $phone = $request->input('phone');
        $vendorId = $request->input('vendorId');
        $event_name = $request->input('event_name');
        $curl = curl_init();

        $url = $this->vendorbaseUrl . "/api/staff/verifyOtp?phone={$phone}&otp={$otp}&vendorId={$vendorId}";

        curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        // dd($result);
        // Optional: Decode and use the response
       // Decode the JSON response
        $result = json_decode($response, true);
        
        // Check for successful response
        if (isset($result['status']) && $result['status'] === 0 && isset($result['response']['staffId'])) {
            $staff_id = $result['response']['staffId'];
            $event_name_encoded = urlencode($event_name);

            // Build the redirect URL
            $url = "/company/{$event_name_encoded}/{$vendorId}/{$staff_id}/{$phone}";
            // dd($url);
            // Redirect
            return redirect($url);
        } else {
            $errorMessage = isset($result['response']) ? $result['response'] : 'OTP verification failed';
            return back()->withErrors(['login_error' => $errorMessage]);

        }

    }

    public function getStaffForm($event, $vendor_id, $staffId, $phone){
       
        $all_access_area = $this->fetchApiStaffData($this->vendorbaseUrl . "/api/master/getAllAccessAreaByVendorId?pageNo=0&pageSize=3000&vendorId=$vendor_id");
       
        if(isset($all_access_area['status']) && $all_access_area['status'] == 0){
            $all_access_area = $all_access_area['response']['dataSet'];
        }
       
        $designations = $this->fetchApiStaffData($this->vendorbaseUrl . "/api/master/getAllDesignationByVendorId?pageNo=0&pageSize=3000&vendorId=$vendor_id");
            
        if(isset($designations['status']) && $designations['status'] == 0){
            $designations = $designations['response']['dataSet'];
        }
        $all_countries = $this->fetchApiStaffData($this->vendorbaseUrl . '/api/master/getAllCountry?pageNo=0&pageSize=300');
            
        if(isset($all_countries['status']) && $all_countries['status'] == 0){
            $all_countries = $all_countries['response']['dataSet'];
        }

        $all_states = $this->fetchApiStaffData($this->vendorbaseUrl . '/api/master/getStateByCountry?countryId=101&pageNo=0&pageSize=300');
            
        if(isset($all_states['status']) && $all_states['status'] == 0){
            $all_states = $all_states['response']['dataSet'];
        }

        $vendor_type = $this->fetchApiStaffData($this->vendorbaseUrl . "/api/vendor/getVendorTypeById?vendorId={$vendor_id}");
        if(isset($vendor_type['status']) && $vendor_type['status'] == 0){
            $vendor_type = $vendor_type['response']['vendorTypeId'];
        }
        
        // dd($vendor_type);    
        return view('add_staff', compact('vendor_type', 'all_states', 'all_countries', 'designations', 'all_access_area', 'vendor_id', 'staffId', 'phone'));
    }

    public function uploadImageToServer($file, $token = null)
    {
        $client = new Client();

        $headers = [
            'Accept' => 'application/json',
        ];

       

        $response = $client->post($this->vendorbaseUrl . '/api/staff/uploadImage', [
            'headers' => $headers,
            'multipart' => [
                [
                    'name'     => 'file',
                    'contents' => fopen($file->getPathname(), 'r'),
                    'filename' => $file->getClientOriginalName(),
                ],
            ],
            'timeout' => 60,
        ]);

        $body = $response->getBody()->getContents();
        return json_decode($body, true);
    }

    public function addForm(Request $request){
        // dd($request->all());
        $request->validate([
            'profilePicture' => 'nullable|file|max:2048',  // 2048 KB = 2 MB
            'idProofFront'   => 'nullable|file|max:2048',
            'idProofBack'    => 'nullable|file|max:2048',
        ], [
            'profilePicture.max' => 'The profile picture must not be larger than 2MB.',
            'idProofFront.max'   => 'The front side of ID proof must not be larger than 2MB.',
            'idProofBack.max'    => 'The back side of ID proof must not be larger than 2MB.',
        ]);
        // Handle profilePicture upload
        $token = session('token');
        $document_file = null;
        $profilePicture = null;
        $idFrontimage = null;
        $idBackImage = null;
        if ($request->hasFile('profilePicture')) {
            // $data = $this->uploadImageToServer($request->file('profilePicture'), $token);
            // $profileImage = $data['response'];
            $file = $request->file('profilePicture');

                $uniqueName = \Illuminate\Support\Str::uuid()->toString();
                $extension = $file->getClientOriginalExtension();
                
                $tempDir = storage_path('app/temp');
                if (!file_exists($tempDir)) mkdir($tempDir, 0755, true);
                
                $originalPath = "$tempDir/{$uniqueName}.{$extension}";
                $transparentPath = "$tempDir/{$uniqueName}_transparent.png";
                
                // Save uploaded file quickly
                file_put_contents($originalPath, file_get_contents($file->getRealPath()));
                
                $rembgPath = '/home/ubuntu/.local/bin/rembg';
                
                // $cmd = "NUMBA_DISABLE_JIT=1 PYTHONPATH={$pythonLibPath} {$pythonPath} {$rembgPath} i \"$originalPath\" \"$transparentPath\" 2>&1";
                
                $pythonPath = '/usr/bin/python3';
                $pythonWrapper = '/home/ubuntu/run_rembg_wrapper.py';
                $pythonLibPath = '/home/ubuntu/.local/lib/python3.10/site-packages';
                $xdgCache = '/tmp/rembg-cache';

                $u2netHome = '/tmp/rembg-cache';
                $envVars = "NUMBA_DISABLE_JIT=1 PYTHONPATH={$pythonLibPath} XDG_CACHE_HOME={$xdgCache} U2NET_HOME={$u2netHome}";
                $cmd = "{$envVars} {$pythonPath} {$pythonWrapper} \"$originalPath\" \"$transparentPath\" 2>&1";

                exec($cmd, $output, $returnVar);
                \Log::error("rembg output: " . implode("\n", $output));
                \Log::error("rembg return code: $returnVar");
                \Log::info("Original path: $originalPath");

                // Upload original image
                $client = new Client();
                $tokenHeader = [
                    'Authorization' => 'Bearer ' . $token,
                    'Accept'        => 'application/json',
                ];
                
                $originalRes = $client->post($this->vendorbaseUrl . '/api/staff/uploadImage', [
                    'headers' => $tokenHeader,
                    'multipart' => [
                        [
                            'name'     => 'file',
                            'contents' => fopen($originalPath, 'r'),
                            'filename' => "{$uniqueName}.{$extension}",
                        ],
                    ],
                ]);
                
                $profileImage = json_decode($originalRes->getBody(), true)['response'] ?? null;
                
                // Upload transparent image if exists
                $transparentImage = null;
                if (file_exists($transparentPath)) {
                    $transparentRes = $client->post($this->vendorbaseUrl . '/api/staff/uploadImage', [
                        'headers' => $tokenHeader,
                        'multipart' => [
                            [
                                'name'     => 'file',
                                'contents' => fopen($transparentPath, 'r'),
                                'filename' => "{$uniqueName}_transparent.png",
                            ],
                        ],
                    ]);
                    $transparentImage = json_decode($transparentRes->getBody(), true)['response'] ?? null;
                }
                
                // Clean up
                @unlink($originalPath);
                @unlink($transparentPath);

        }
        
        if ($request->hasFile('idProofFront')) {
            $data1 = $this->uploadImageToServer($request->file('idProofFront'), $token);
            $idFrontimage = $data1['response'];
        }
        
        if ($request->hasFile('idProofBack')) {
            $data2 = $this->uploadImageToServer($request->file('idProofBack'), $token);
            $idBackImage = $data2['response'];
        }
        
       
        if ($request->hasFile('document')) {
                $file = $request->file('document');
        
                $client = new Client();
        
                $response = $client->post($this->vendorbaseUrl . '/api/staff/uploadImage', [
                    'multipart' => [
                        [
                            'name'     => 'file',
                            'contents' => fopen($file->getPathname(), 'r'),
                            'filename' => $file->getClientOriginalName(),
                            'headers'  => [
                                'Authorization: Bearer ' . $token,
                                'Content-Type' => $file->getMimeType(),
                            ],
                        ],
                    ],
                ]);
                // $image_nm = $file->getClientOriginalName();
                
                $body = $response->getBody()->getContents();
                $data3 = json_decode($body, true);
                $document_file = $data3['response'];
        }
        $data = [
            // "profilePicture" => $profileImage ? $profileImage :'',
            "addressLine1" => $request->addressLine1,
            "addressLine2" => $request->addressLine2,
            "city" => $request->city,
            "country" => $request->country,
            "countryCode" => $request->countryCode,
            "designationMasterId" => (int)$request->designationMasterId,
            "dob" => $request->dob,
            "email" => $request->email,
            "fatherName" => $request->fatherName,
            "firstName" => $request->first_name,
            "gender" => $request->gender,
            "idNumber" => $request->idNumber,
            "idProofBack" => $idBackImage ? $idBackImage :'',
            "idProofFront" => $idFrontimage? $idFrontimage :'',
            "idType" => $request->idType,
            "lastName" => $request->last_name,
            "middleName" => $request->middle_name,
            "onlyConcourseAccess" => $request->onlyConcourseAccess === 'true',
            "phone" => $request->phone,
            "postalCode" => $request->postalCode,
            "staffAccessAreaList" => $request->input('accessAreaId', []),
            "staffId" => 0,
            "vendorId" => $request->vendorId,
            "state" => $request->state
        ];
        if ($profileImage) {
            $data['profilePicture'] = $profileImage;
            // $data['transparentProfilePicture'] = $transparentImage;
        }
        if ($transparentImage) {
            $data['transparentProfilePicture'] = $transparentImage;
        }
        if ($document_file) {
            $data['document'] = $document_file;
        }
        // dd($data);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->vendorbaseUrl . '/api/staff/updateStaffDetails',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => array(
               
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);
        
        curl_close($curl);
        // dd($response);
        $response = json_decode($response, true);
        // dd($response);
        if ($response['status'] == 0) {
            return redirect('thanks')->with('success', $response['response']);
        } else {
            // dd($response['response']);
            return redirect()->back()->withInput()->with('error', $response['response']);
        
        }
        
    }

    public function profile(){
        $check = session::all();
        // dd($check);
        $value = session('type');
        if($value == 'vendor'){
            $profile_data = $this->fetchApiData($this->vendorbaseUrl . '/api/vendor/getVendorById');
        
            if(isset($profile_data['status']) && $profile_data['status'] == 0){
                $profile_data = $profile_data['response'];
            }
        }else{
            $profile_data = $this->fetchApiData($this->adminbaseUrl . '/api/VendorAdmin/getVendorAdminById');
        
            if(isset($profile_data['status']) && $profile_data['status'] == 0){
                $profile_data = $profile_data['response'];
            }
        }
        // dd($profile_data);
       
        return view('profile', compact('profile_data'));
    }

    public function addProfile(Request $request){
        // dd($request->all());
        $profileImage = null;
        $value = session('type');
        $token = session('token');
        if ($request->hasFile('profilePicture')) {
            $file = $request->file('profilePicture');
    
            $client = new \GuzzleHttp\Client();

            if($value == 'vendor'){
                $response = $client->post($this->vendorbaseUrl . '/api/staff/uploadImage', [
                    'headers' => [
                            // 'Authorization' => 'Bearer ' . $token,
                            'Accept'        => 'application/json',
                        ],
                        'multipart' => [
                            [
                                'name'     => 'file',
                                'contents' => fopen($file->getPathname(), 'r'),
                                'filename' => $file->getClientOriginalName(),
                            ],
                        ],
                ]);
            }else{
                $response = $client->post($this->adminbaseUrl . '/api/master/uploadImage', [
                    'headers' => [
                            'Authorization' => 'Bearer ' . $token,
                            'Accept'        => 'application/json',
                        ],
                        'multipart' => [
                            [
                                'name'     => 'file',
                                'contents' => fopen($file->getPathname(), 'r'),
                                'filename' => $file->getClientOriginalName(),
                            ],
                        ],
                ]);
                

                if ($response->getStatusCode() !== 200) {
                    dd('Unexpected status', $response->getStatusCode());
                }

                $data = json_decode((string) $response->getBody(), true);
                $profileImage = $data['response'] ?? null;
                
            }
           
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);
            
            // image_nm = $file->getClientOriginalName();
            
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);
        }
        

        if($value == 'vendor'){
            $data = [
                "contactPerson" => $request->contactPerson,
                "mobileNumber" => $request->mobileNumber,
                "smsSummaryFrequency" => $request->smsSummaryFrequency
            ];
            // dd($data);
            if ($profileImage) {
                $data['profilePicture'] = $profileImage;
            }
            // dd($data);
            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => $this->vendorbaseUrl . '/api/vendor/updateVendor',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($data),
                CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer ' . $token,
                    'Content-Type: application/json'
                ),
            ));
        }else{
            $data = [
                "name" => $request->contactPerson,
                "mobileNumber" => $request->mobileNumber,
                "smsSummaryFrequency" => $request->smsSummaryFrequency
            ];
            // dd($data);
            if ($profileImage) {
                $data['profilePicture'] = $profileImage;
            }
            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => $this->vendorbaseUrl . '/api/VendorAdmin/updateVendorAdmin',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($data),
                CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer ' . $token,
                    'Content-Type: application/json'
                ),
            ));
        }

        $response = curl_exec($curl);
        
        curl_close($curl);
        $response = json_decode($response, true);
        // dd($response);
        if ($response['status'] == 0) {
            return redirect('profile')->with('success', $response['response']);
        } else {
            // dd($response['response']);
            return redirect()->back()->with('error', $response['response']);
        
        }
    }

    public function privacyPolicy(){
        return view('privacy_policy');
    }

    public function termsConditions(){
        return view('terms_conditions');
    }

    public function resetPassword(Request $request){
        
        $token = $request->query('token');
        return view('reset_password', ['token' => $token]);
    }
    
}
