<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Storage;


class StaffController extends Controller
{
    public $adminbaseUrl;
    public $vendorbaseUrl;

    public function __construct()
    {
        // Initialize from config
        $this->adminbaseUrl = config('app.admin_base_url');
        $this->vendorbaseUrl = config('app.vendor_base_url');
        
    }
    
    private function fetchApiData($url) {
        $token = session('token');
        $curl = curl_init();
    
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $token,
                'Accept: application/json',
            ],
        ));
    
        $response = curl_exec($curl);
    
        if (curl_errno($curl)) {
            // Log cURL error
            $error_msg = curl_error($curl);
            curl_close($curl);
            dd("cURL Error: " . $error_msg);  // Temporarily dump for debugging
        }
    
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
    
        // Dump the raw response if it's not 200
        if ($httpCode !== 200) {
            dd("HTTP Code: $httpCode", $response);
        }
    
        $decoded = json_decode($response, true);
        if ($decoded === null) {
            dd("JSON Decode Error", $response);
        }
    
        return $decoded;
    }
    
    
    public function allStaff(){
        

        $value = session('type');
       
        if($value == 'vendor'){
            $all_designations = $this->fetchApiData($this->vendorbaseUrl . '/api/master/getAllDesignation?pageNo=0&pageSize=3000');
        
            if(isset($all_designations['status']) && $all_designations['status'] == 0){
                $all_designations = $all_designations['response']['dataSet'];
            }
            $counts = $this->fetchApiData($this->vendorbaseUrl . '/api/vendor/getDashboard');
            $staff_counts = [];
            if(isset($counts['status']) && $counts['status'] == 0){
                $staff_counts = $counts['response'];
                return view('staffs.list', compact( 'staff_counts', 'value', 'all_designations'));
            }
        
           
    
        }else{
            
            $counts = $this->fetchApiData($this->adminbaseUrl . '/api/vendor/getDashboard');
            $staff_counts = [];
        
            if(isset($counts['status']) && $counts['status'] == 0){
                $staff_counts = $counts['response']['formStatus'];
            }
            // dd($staff_counts);
            $all_vendors = $this->fetchApiData($this->adminbaseUrl . '/api/vendor/getAllVendorCountByName?pageNo=0&pageSize=3000&vendorName=');
        
            if(isset($all_vendors['status']) && $all_vendors['status'] == 0){
                $all_vendors = $all_vendors['response']['dataSet'];
            }

            $all_access_area = $this->fetchApiData($this->adminbaseUrl . '/api/master/getAllAccessArea?pageNo=0&pageSize=30');
        
            if(isset($all_access_area['status']) && $all_access_area['status'] == 0){
                $all_access_area = $all_access_area['response']['dataSet'];
            }

            $all_designations = $this->fetchApiData($this->adminbaseUrl . '/api/master/getAllDesignation?pageNo=0&pageSize=3000');
        
            if(isset($all_designations['status']) && $all_designations['status'] == 0){
                $all_designations = $all_designations['response']['dataSet'];
            }
           
            $data = $this->fetchApiData($this->adminbaseUrl . '/api/master/getAllAccreditationType?pageNo=0&pageSize=30');
         
            if(isset($data['status']) && $data['status'] == 0){
                $accredation_types = $data['response']['dataSet'];
            //    dd($accredation_types);
                return view('staffs.list', compact('accredation_types', 'staff_counts', 'all_vendors', 'all_access_area', 'all_designations', 'value'));
            }


        }
        
        return view('staffs.list'); 
    }
    

    public function getAddStaff(){
        $type = session('type'); 
        $name = session('name');
       
        $token = session('token'); 
        if($type == 'vendor'){
            $designations = $this->fetchApiData($this->vendorbaseUrl . '/api/master/getAllDesignation?pageNo=0&pageSize=3000');
       
            if(isset($designations['status']) && $designations['status'] == 0){
                $designations = $designations['response']['dataSet'];
            }
           
            $all_access_area = $this->fetchApiData($this->vendorbaseUrl . '/api/master/getAllAccessArea?pageNo=0&pageSize=3000');
            
            if(isset($all_access_area['status']) && $all_access_area['status'] == 0){
                $all_access_area = $all_access_area['response']['dataSet'];
            }
            
            $all_countries = $this->fetchApiData($this->vendorbaseUrl . '/api/master/getAllCountry?pageNo=0&pageSize=300');
            
            if(isset($all_countries['status']) && $all_countries['status'] == 0){
                $all_countries = $all_countries['response']['dataSet'];
            }
            $encodedName = urlencode($name); 
            // dd($this->baseUrl . ":7001/api/vendor/getVendorSearchByName?name={$encodedName}&pageNo=0&pageSize=30");
            $vendor_type = $this->fetchApiData($this->vendorbaseUrl . "/api/vendor/getVendorSearchByName?name={$encodedName}&pageNo=0&pageSize=30");
            if(isset($vendor_type['status']) && $vendor_type['status'] == 0){
                $vendor_type = $vendor_type['response']['dataSet'][0]['vendorTypeId'];
            }
            // dd($vendor_type);
        }else{

            $designations = $this->fetchApiData($this->adminbaseUrl . '/api/master/getAllDesignation?pageNo=0&pageSize=3000');
        
            if(isset($designations['status']) && $designations['status'] == 0){
                $designations = $designations['response']['dataSet'];
            }

            $all_access_area = $this->fetchApiData($this->adminbaseUrl . '/api/master/getAllAccessArea?pageNo=0&pageSize=3000');
            
            if(isset($all_access_area['status']) && $all_access_area['status'] == 0){
                $all_access_area = $all_access_area['response']['dataSet'];
            }

            $all_countries = $this->fetchApiData($this->adminbaseUrl . '/api/master/getAllCountry?pageNo=0&pageSize=300');
            
            if(isset($all_countries['status']) && $all_countries['status'] == 0){
                $all_countries = $all_countries['response']['dataSet'];
            }
        }
        
        return view('staffs.add', compact('vendor_type', 'designations', 'all_access_area', 'all_countries'));
    }

    public function addStaff(Request $request){
        // dd($request->all());
        $request->validate([
            'profilePicture' => 'nullable|file|max:2048',  // 2048 KB = 2 MB
            'idProofFront'   => 'nullable|file|max:2048',
            'idProofBack'    => 'nullable|file|max:2048',
        ], [
            'profilePicture.max' => 'The profile picture must not be larger than 2MB.',
            'idProofFront.max'   => 'The front side of ID proof must not be larger than 2MB.',
            'idProofBack.max'    => 'The back side of ID proof must not be larger than 2MB.',
        ]);
        $profilePicture = null;
        $idFrontimage = null;
        $idBackImage = null;
        $token = session('token'); 
        // Handle profilePicture upload
        if ($request->hasFile('profilePicture')) {
            // $file = $request->file('profilePicture');
    
            // $client = new Client();
    
            // $response = $client->post($this->vendorbaseUrl . '/api/staff/uploadImage', [
            //     'multipart' => [
            //         [
            //             'name'     => 'file',
            //             'contents' => fopen($file->getPathname(), 'r'),
            //             'filename' => $file->getClientOriginalName(),
            //             'headers'  => [
            //                 'Authorization: Bearer ' . $token,
            //                 'Content-Type' => $file->getMimeType(),
            //             ],
            //         ],
            //     ],
            // ]);
            // // $image_nm = $file->getClientOriginalName();
            
            // $body = $response->getBody()->getContents();
            // $data = json_decode($body, true);
            // $profileImage = $data['response'];

            $file = $request->file('profilePicture');

                $uniqueName = \Illuminate\Support\Str::uuid()->toString();
                $extension = $file->getClientOriginalExtension();
                
                $tempDir = storage_path('app/temp');
                if (!file_exists($tempDir)) mkdir($tempDir, 0755, true);
                
                $originalPath = "$tempDir/{$uniqueName}.{$extension}";
                $transparentPath = "$tempDir/{$uniqueName}_transparent.png";
                
                // Save uploaded file quickly
                file_put_contents($originalPath, file_get_contents($file->getRealPath()));
                
                $rembgPath = '/home/ubuntu/.local/bin/rembg';
                
                // $cmd = "NUMBA_DISABLE_JIT=1 PYTHONPATH={$pythonLibPath} {$pythonPath} {$rembgPath} i \"$originalPath\" \"$transparentPath\" 2>&1";
                
                $pythonPath = '/usr/bin/python3';
                $pythonWrapper = '/home/ubuntu/run_rembg_wrapper.py';
                $pythonLibPath = '/home/ubuntu/.local/lib/python3.10/site-packages';
                $xdgCache = '/tmp/rembg-cache';

                $u2netHome = '/tmp/rembg-cache';
                $envVars = "NUMBA_DISABLE_JIT=1 PYTHONPATH={$pythonLibPath} XDG_CACHE_HOME={$xdgCache} U2NET_HOME={$u2netHome}";
                $cmd = "{$envVars} {$pythonPath} {$pythonWrapper} \"$originalPath\" \"$transparentPath\" 2>&1";

                exec($cmd, $output, $returnVar);
                \Log::error("rembg output: " . implode("\n", $output));
                \Log::error("rembg return code: $returnVar");
                \Log::info("Original path: $originalPath");

                // Upload original image
                $client = new Client();
                $tokenHeader = [
                    'Authorization' => 'Bearer ' . $token,
                    'Accept'        => 'application/json',
                ];
                
                $originalRes = $client->post($this->vendorbaseUrl . '/api/staff/uploadImage', [
                    'headers' => $tokenHeader,
                    'multipart' => [
                        [
                            'name'     => 'file',
                            'contents' => fopen($originalPath, 'r'),
                            'filename' => "{$uniqueName}.{$extension}",
                        ],
                    ],
                ]);
                
                $profileImage = json_decode($originalRes->getBody(), true)['response'] ?? null;
                
                // Upload transparent image if exists
                $transparentImage = null;
                if (file_exists($transparentPath)) {
                    $transparentRes = $client->post($this->vendorbaseUrl . '/api/staff/uploadImage', [
                        'headers' => $tokenHeader,
                        'multipart' => [
                            [
                                'name'     => 'file',
                                'contents' => fopen($transparentPath, 'r'),
                                'filename' => "{$uniqueName}_transparent.png",
                            ],
                        ],
                    ]);
                    $transparentImage = json_decode($transparentRes->getBody(), true)['response'] ?? null;
                }
                
                // Clean up
                @unlink($originalPath);
                @unlink($transparentPath);
        }
        
        if ($request->hasFile('idProofFront')) {
            $file = $request->file('idProofFront');
    
            $client = new Client();
    
            $response = $client->post($this->vendorbaseUrl . '/api/staff/uploadImage', [
                'multipart' => [
                    [
                        'name'     => 'file',
                        'contents' => fopen($file->getPathname(), 'r'),
                        'filename' => $file->getClientOriginalName(),
                        'headers'  => [
                            'Authorization: Bearer ' . $token,
                            'Content-Type' => $file->getMimeType(),
                        ],
                    ],
                ],
            ]);
            // $image_nm = $file->getClientOriginalName();
            
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);
        }
        $idFrontimage = $data['response'];
       
        if ($request->hasFile('idProofBack')) {
            $file = $request->file('idProofBack');
    
            $client = new Client();
    
            $response = $client->post($this->vendorbaseUrl . '/api/staff/uploadImage', [
                'multipart' => [
                    [
                        'name'     => 'file',
                        'contents' => fopen($file->getPathname(), 'r'),
                        'filename' => $file->getClientOriginalName(),
                        'headers'  => [
                            'Authorization: Bearer ' . $token,
                            'Content-Type' => $file->getMimeType(),
                        ],
                    ],
                ],
            ]);
            // $image_nm = $file->getClientOriginalName();
            
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);
        }
        $idBackImage = $data['response'];
       
       
        $data = [
            // "profilePicture" => $profileImage ? $profileImage :'',
            "addressLine1" => $request->addressLine1,
            "addressLine2" => $request->addressLine2,
            "city" => $request->city,
            "country" => $request->country,
            "countryCode" => $request->countryCode,
            "designationMasterId" => (int)$request->designationMasterId,
            "dob" => $request->dob,
            "email" => $request->email,
            "fatherName" => $request->fatherName,
            "firstName" => $request->first_name,
            "gender" => $request->gender,
            "idNumber" => $request->idNumber,
            // "idProofBack" => $idBackImage ? $idBackImage :'',
            // "idProofFront" => $idFrontimage? $idFrontimage :'',
            "idType" => $request->idType,
            "lastName" => $request->last_name,
            "middleName" => $request->middle_name,
            // "onlyConcourseAccess" => $request->onlyConcourseAccess === 'true',
            "onlyConcourseAccess" => 'false',
            "phone" => $request->phone,
            "postalCode" => $request->postalCode,
            "staffAccessAreaList" => $request->input('accessAreaId', []),
            "staffId" => (int)$request->staffId,
            "state" => $request->state
        ];

        if ($profileImage) {
            $data['profilePicture'] = $profileImage;
            // $data['transparentProfilePicture'] = $transparentImage;
        }
        if ($idFrontimage) {
            $data['idProofFront'] = $idFrontimage;
        }
        if ($idBackImage) {
            $data['idProofBack'] = $idBackImage;
        }
        if ($transparentImage) {
            $data['transparentProfilePicture'] = $transparentImage;
        }
        $token = session('token');
        // dd($data);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->vendorbaseUrl . '/api/staff/saveOrUpdateStaffDetails',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer ' . $token,
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        // dd($response);
        $response = json_decode($response, true);
        if ($response['status'] == 0) {
            return redirect('staff/list')->with('success', $response['response']);
        } else {
         
            // return redirect()->back()->with('error', $response['response']);
            return redirect()->back()
            ->with('error', $response['response'])
            ->withInput();
        
        }
       

        
    }

    public function getUpdateStaff($staff_id){
        $type = session('type'); 
        if($type == 'vendor'){
            $staff = $this->fetchApiData($this->vendorbaseUrl . "/api/staff/getStaffDetailsById?staffId=$staff_id");
       
            if(isset($staff['status']) && $staff['status'] == 0){
                $staff = $staff['response'];
            }
    
            $designations = $this->fetchApiData($this->vendorbaseUrl . '/api/master/getAllDesignation?pageNo=0&pageSize=3000');
            
            if(isset($designations['status']) && $designations['status'] == 0){
                $designations = $designations['response']['dataSet'];
            }
    
            $all_access_area = $this->fetchApiData($this->vendorbaseUrl . '/api/master/getAllAccessArea?pageNo=0&pageSize=3000');
            
            if(isset($all_access_area['status']) && $all_access_area['status'] == 0){
                $all_access_area = $all_access_area['response']['dataSet'];
            }

            $all_countries = $this->fetchApiData($this->vendorbaseUrl . '/api/master/getAllCountry?pageNo=0&pageSize=3000');
            
            if(isset($all_countries['status']) && $all_countries['status'] == 0){
                $all_countries = $all_countries['response']['dataSet'];
            }

            $all_states = $this->fetchApiData($this->vendorbaseUrl . "/api/master/getStateByCountry?countryId=$staff_id&pageNo=0&pageSize=300");
            
            if(isset($all_states['status']) && $all_states['status'] == 0){
                $all_states = $all_states['response']['dataSet'];
            }
            // dd($staff);
        }else{
            $staff = $this->fetchApiData($this->adminbaseUrl . "/api/staff/getStaffDetailsById?staffId=$staff_id");
       
            if(isset($staff['status']) && $staff['status'] == 0){
                $staff = $staff['response'];
            }

            $designations = $this->fetchApiData($this->adminbaseUrl . '/api/master/getAllDesignation?pageNo=0&pageSize=3000');
            
            if(isset($designations['status']) && $designations['status'] == 0){
                $designations = $designations['response']['dataSet'];
            }

            $all_access_area = $this->fetchApiData($this->adminbaseUrl . '/api/master/getAllAccessArea?pageNo=0&pageSize=3000');
            
            if(isset($all_access_area['status']) && $all_access_area['status'] == 0){
                $all_access_area = $all_access_area['response']['dataSet'];
            }

            $all_countries = $this->fetchApiData($this->adminbaseUrl . '/api/master/getAllCountry?pageNo=0&pageSize=3000');
            
            if(isset($all_countries['status']) && $all_countries['status'] == 0){
                $all_countries = $all_countries['response']['dataSet'];
            }

            $all_states = $this->fetchApiData($this->adminbaseUrl . "/api/master/getStateByCountry?countryId=$staff_id&pageNo=0&pageSize=300");
            
            if(isset($all_states['status']) && $all_states['status'] == 0){
                $all_states = $all_states['response']['dataSet'];
            }
        }
        
        
        return view('staffs.update', compact('all_states', 'designations', 'staff', 'all_access_area', 'all_countries'));
    }

    /* public function updateStaff(Request $request){
        // dd($request->all());
        $token = session('token');
        $profileImage = null;
        $idFrontimage = null;
        $idBackImage = null;

        if ($request->hasFile('profilePicture')) {
            $file = $request->file('profilePicture');
    
            $client = new Client();
    
            $response = $client->post($this->baseUrl . ':7001/api/staff/uploadImage', [
                'headers' => [
                        'Authorization' => 'Bearer ' . $token,
                        'Accept'        => 'application/json',
                    ],
                    'multipart' => [
                        [
                            'name'     => 'file',
                            'contents' => fopen($file->getPathname(), 'r'),
                            'filename' => $file->getClientOriginalName(),
                        ],
                    ],
            ]);
            // $image_nm = $file->getClientOriginalName();
            
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);
            $profileImage = $data['response'];





            $file = $request->file('profilePicture');

                $uniqueName = \Illuminate\Support\Str::uuid()->toString();
                $extension = $file->getClientOriginalExtension();

                $tempDir = storage_path('app/temp');
                if (!file_exists($tempDir)) mkdir($tempDir, 0755, true);

                $originalPath = "$tempDir/{$uniqueName}.{$extension}";
                $transparentPath = "$tempDir/{$uniqueName}_transparent.png";

                // Save uploaded file quickly
                file_put_contents($originalPath, file_get_contents($file->getRealPath()));

                // Run rembg (faster if rembg has been warmed up once)
                exec("rembg i \"$originalPath\" \"$transparentPath\"");

                // Upload original image
                $client = new Client();
                $tokenHeader = [
                    'Authorization' => 'Bearer ' . $token,
                    'Accept'        => 'application/json',
                ];

                $originalRes = $client->post($this->baseUrl . ':7001/api/staff/uploadImage', [
                    'headers' => $tokenHeader,
                    'multipart' => [
                        [
                            'name'     => 'file',
                            'contents' => fopen($originalPath, 'r'),
                            'filename' => "{$uniqueName}.{$extension}",
                        ],
                    ],
                ]);

                $profileImage = json_decode($originalRes->getBody(), true)['response'] ?? null;

                // Upload transparent image
                $transparentImage = null;
                if (file_exists($transparentPath)) {
                    $transparentRes = $client->post($this->baseUrl . ':7001/api/staff/uploadImage', [
                        'headers' => $tokenHeader,
                        'multipart' => [
                            [
                                'name'     => 'file',
                                'contents' => fopen($transparentPath, 'r'),
                                'filename' => "{$uniqueName}_transparent.png",
                            ],
                        ],
                    ]);
                    $transparentImage = json_decode($transparentRes->getBody(), true)['response'] ?? null;
                }

                // Clean up
                @unlink($originalPath);
                @unlink($transparentPath);

                return response()->json([
                    'original_image_url' => $profileImage,
                    'transparent_image_url' => $transparentImage,
                ]);
        }
        
        if ($request->hasFile('idProofFront')) {
            $file = $request->file('idProofFront');
    
            $client = new Client();
    
            $response = $client->post($this->baseUrl . ':7001/api/staff/uploadImage', [
                'multipart' => [
                    [
                        'name'     => 'file',
                        'contents' => fopen($file->getPathname(), 'r'),
                        'filename' => $file->getClientOriginalName(),
                        'headers'  => [
                            'Authorization: Bearer ' . $token,
                            'Content-Type' => $file->getMimeType(),
                        ],
                    ],
                ],
            ]);
            // $image_nm = $file->getClientOriginalName();
            
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);
            $idFrontimage = $data['response'];
        }
       
       
        if ($request->hasFile('idProofBack')) {
            $file = $request->file('idProofBack');
    
            $client = new Client();
    
            $response = $client->post($this->baseUrl . ':7001/api/staff/uploadImage', [
                'multipart' => [
                    [
                        'name'     => 'file',
                        'contents' => fopen($file->getPathname(), 'r'),
                        'filename' => $file->getClientOriginalName(),
                        'headers'  => [
                            'Authorization: Bearer ' . $token,
                            'Content-Type' => $file->getMimeType(),
                        ],
                    ],
                ],
            ]);
            // $image_nm = $file->getClientOriginalName();
            
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);
            $idBackImage = $data['response'];
        }
        
       
       
        $data = [
            "addressLine1" => $request->addressLine1,
            "addressLine2" => $request->addressLine2,
            "city" => $request->city,
            "country" => $request->country,
            "countryCode" => $request->countryCode,
            "designationMasterId" => (int)$request->designationMasterId,
            "dob" => $request->dob,
            "email" => $request->email,
            "fatherName" => $request->fatherName,
            "firstName" => $request->first_name,
            "gender" => $request->gender,
            "idNumber" => $request->idNumber,
            "idType" => $request->idType,
            "lastName" => $request->last_name,
            "middleName" => $request->middle_name,
            "onlyConcourseAccess" => $request->onlyConcourseAccess === 'true',
            "phone" => $request->phone,
            "postalCode" => $request->postalCode,
            "staffAccessAreaList" => $request->input('staffAccessAreaList', []),
            "staffId" => (int)$request->staffId,
            "state" => $request->state
        ];

        // Conditionally add images
        if ($profileImage) {
            $data['profilePicture'] = $profileImage;
        }
        if ($idFrontimage) {
            $data['idProofFront'] = $idFrontimage;
        }
        if ($idBackImage) {
            $data['idProofBack'] = $idBackImage;
        }

        // dd($data);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->baseUrl . ':7001/api/staff/saveOrUpdateStaffDetails',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer ' . $token,
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $response = json_decode($response, true);
       
        if ($response['status'] == 0) {
            return redirect('staff/list')->with('success', $response['response']);
        } else {
         
            return redirect()->back()->with('error', $response['response']);
        
        }
       
        //transparant image for local
                $file = $request->file('profilePicture');

                $uniqueName = \Illuminate\Support\Str::uuid()->toString();
                $extension = $file->getClientOriginalExtension();

                $tempDir = storage_path('app/temp');
                if (!file_exists($tempDir)) mkdir($tempDir, 0755, true);

                $originalPath = "$tempDir/{$uniqueName}.{$extension}";
                $transparentPath = "$tempDir/{$uniqueName}_transparent.png";

                // Save uploaded file quickly
                file_put_contents($originalPath, file_get_contents($file->getRealPath()));

                // Run rembg (faster if rembg has been warmed up once)
                exec("rembg i \"$originalPath\" \"$transparentPath\"");

                // Upload original image
                $client = new Client();
                $tokenHeader = [
                    'Authorization' => 'Bearer ' . $token,
                    'Accept'        => 'application/json',
                ];

                $originalRes = $client->post($this->baseUrl . ':7001/api/staff/uploadImage', [
                    'headers' => $tokenHeader,
                    'multipart' => [
                        [
                            'name'     => 'file',
                            'contents' => fopen($originalPath, 'r'),
                            'filename' => "{$uniqueName}.{$extension}",
                        ],
                    ],
                ]);

                $profileImage = json_decode($originalRes->getBody(), true)['response'] ?? null;

                // Upload transparent image
                $transparentImage = null;
                if (file_exists($transparentPath)) {
                    $transparentRes = $client->post($this->baseUrl . ':7001/api/staff/uploadImage', [
                        'headers' => $tokenHeader,
                        'multipart' => [
                            [
                                'name'     => 'file',
                                'contents' => fopen($transparentPath, 'r'),
                                'filename' => "{$uniqueName}_transparent.png",
                            ],
                        ],
                    ]);
                    $transparentImage = json_decode($transparentRes->getBody(), true)['response'] ?? null;
                }

                // Clean up
                @unlink($originalPath);
                @unlink($transparentPath);

                return response()->json([
                    'original_image_url' => $profileImage,
                    'transparent_image_url' => $transparentImage,
                ]);
    }*/
    
    
    
    public function updateStaff(Request $request){
        // dd($request->all());
        $type = session('type'); 
        
        $token = session('token');
        $profileImage = null;
        $idFrontimage = null;
        $idBackImage = null;
        $document_file = null;

        if($type == 'vendor'){

            if ($request->hasFile('profilePicture')) {
                //  $file = $request->file('profilePicture');
        
                //  $client = new Client();
        
                //  $response = $client->post($this->vendorbaseUrl . '/api/staff/uploadImage', [
                //      'headers' => [
                //              'Authorization' => 'Bearer ' . $token,
                //              'Accept'        => 'application/json',
                //          ],
                //          'multipart' => [
                //              [
                //                  'name'     => 'file',
                //                  'contents' => fopen($file->getPathname(), 'r'),
                //                  'filename' => $file->getClientOriginalName(),
                //              ],
                //           ],
                //    ]);
                
                //    $body = $response->getBody()->getContents();
                //    $data = json_decode($body, true);
                //    $profileImage = $data['response'];


                $file = $request->file('profilePicture');

                $uniqueName = \Illuminate\Support\Str::uuid()->toString();
                $extension = $file->getClientOriginalExtension();
                
                $tempDir = storage_path('app/temp');
                if (!file_exists($tempDir)) mkdir($tempDir, 0755, true);
                
                $originalPath = "$tempDir/{$uniqueName}.{$extension}";
                $transparentPath = "$tempDir/{$uniqueName}_transparent.png";
                
                // Save uploaded file quickly
                file_put_contents($originalPath, file_get_contents($file->getRealPath()));
                
                $rembgPath = '/home/ubuntu/.local/bin/rembg';
                
                // $cmd = "NUMBA_DISABLE_JIT=1 PYTHONPATH={$pythonLibPath} {$pythonPath} {$rembgPath} i \"$originalPath\" \"$transparentPath\" 2>&1";
                
                $pythonPath = '/usr/bin/python3';
                $pythonWrapper = '/home/ubuntu/run_rembg_wrapper.py';
                $pythonLibPath = '/home/ubuntu/.local/lib/python3.10/site-packages';
                $xdgCache = '/tmp/rembg-cache';

                $u2netHome = '/tmp/rembg-cache';
                $envVars = "NUMBA_DISABLE_JIT=1 PYTHONPATH={$pythonLibPath} XDG_CACHE_HOME={$xdgCache} U2NET_HOME={$u2netHome}";
                $cmd = "{$envVars} {$pythonPath} {$pythonWrapper} \"$originalPath\" \"$transparentPath\" 2>&1";

                exec($cmd, $output, $returnVar);
                \Log::error("rembg output: " . implode("\n", $output));
                \Log::error("rembg return code: $returnVar");
                \Log::info("Original path: $originalPath");

                // Upload original image
                $client = new Client();
                $tokenHeader = [
                    'Authorization' => 'Bearer ' . $token,
                    'Accept'        => 'application/json',
                ];
                
                $originalRes = $client->post($this->vendorbaseUrl . '/api/staff/uploadImage', [
                    'headers' => $tokenHeader,
                    'multipart' => [
                        [
                            'name'     => 'file',
                            'contents' => fopen($originalPath, 'r'),
                            'filename' => "{$uniqueName}.{$extension}",
                        ],
                    ],
                ]);
                
                $profileImage = json_decode($originalRes->getBody(), true)['response'] ?? null;
                
                // Upload transparent image if exists
                $transparentImage = null;
                if (file_exists($transparentPath)) {
                    $transparentRes = $client->post($this->vendorbaseUrl . '/api/staff/uploadImage', [
                        'headers' => $tokenHeader,
                        'multipart' => [
                            [
                                'name'     => 'file',
                                'contents' => fopen($transparentPath, 'r'),
                                'filename' => "{$uniqueName}_transparent.png",
                            ],
                        ],
                    ]);
                    $transparentImage = json_decode($transparentRes->getBody(), true)['response'] ?? null;
                }
                
                // Clean up
                @unlink($originalPath);
                @unlink($transparentPath);
                
                // return response()->json([
                //     'original_image_url' => $profileImage,
                //     'transparent_image_url' => $transparentImage,
                // ]);
                
            }
            // dd("done");  
            if ($request->hasFile('idProofFront')) {
                $file = $request->file('idProofFront');
        
                $client = new Client();
        
                $response = $client->post($this->vendorbaseUrl . '/api/staff/uploadImage', [
                    'multipart' => [
                        [
                            'name'     => 'file',
                            'contents' => fopen($file->getPathname(), 'r'),
                            'filename' => $file->getClientOriginalName(),
                            'headers'  => [
                                'Authorization: Bearer ' . $token,
                                'Content-Type' => $file->getMimeType(),
                            ],
                        ],
                    ],
                ]);
                // $image_nm = $file->getClientOriginalName();
                
                $body = $response->getBody()->getContents();
                $data = json_decode($body, true);
                $idFrontimage = $data['response'];
            }
        
        
            if ($request->hasFile('idProofBack')) {
                $file = $request->file('idProofBack');
        
                $client = new Client();
        
                $response = $client->post($this->vendorbaseUrl . '/api/staff/uploadImage', [
                    'multipart' => [
                        [
                            'name'     => 'file',
                            'contents' => fopen($file->getPathname(), 'r'),
                            'filename' => $file->getClientOriginalName(),
                            'headers'  => [
                                'Authorization: Bearer ' . $token,
                                'Content-Type' => $file->getMimeType(),
                            ],
                        ],
                    ],
                ]);
                // $image_nm = $file->getClientOriginalName();
                
                $body = $response->getBody()->getContents();
                $data = json_decode($body, true);
                $idBackImage = $data['response'];
            }
            
            if ($request->hasFile('document')) {
                $file = $request->file('document');
        
                $client = new Client();
        
                $response = $client->post($this->vendorbaseUrl . '/api/staff/uploadImage', [
                    'multipart' => [
                        [
                            'name'     => 'file',
                            'contents' => fopen($file->getPathname(), 'r'),
                            'filename' => $file->getClientOriginalName(),
                            'headers'  => [
                                'Authorization: Bearer ' . $token,
                                'Content-Type' => $file->getMimeType(),
                            ],
                        ],
                    ],
                ]);
                // $image_nm = $file->getClientOriginalName();
                
                $body = $response->getBody()->getContents();
                $data = json_decode($body, true);
                $document_file = $data['response'];
            }
        
            $data = [
                "addressLine1" => $request->addressLine1,
                "addressLine2" => $request->addressLine2,
                "city" => $request->city,
                "country" => $request->country,
                "countryCode" => $request->countryCode,
                "designationMasterId" => (int)$request->designationMasterId,
                "dob" => $request->dob,
                "email" => $request->email,
                "fatherName" => $request->fatherName,
                "firstName" => $request->first_name,
                "gender" => $request->gender,
                "idNumber" => $request->idNumber,
                "idType" => $request->idType,
                "lastName" => $request->last_name,
                "middleName" => $request->middle_name,
                "onlyConcourseAccess" => 'false',
                "phone" => $request->phone,
                "postalCode" => $request->postalCode,
                "staffAccessAreaList" => $request->input('staffAccessAreaList', []),
                "staffId" => (int)$request->staffId,
                "state" => $request->state,
                
            ];

            // Conditionally add images
            if ($profileImage) {
                $data['profilePicture'] = $profileImage;
                // $data['transparentProfilePicture'] = $transparentImage;
            }
            if ($idFrontimage) {
                $data['idProofFront'] = $idFrontimage;
            }
            if ($idBackImage) {
                $data['idProofBack'] = $idBackImage;
            }
            if ($transparentImage) {
                $data['transparentProfilePicture'] = $transparentImage;
            }

            // dd($data);
            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => $this->vendorbaseUrl . '/api/staff/saveOrUpdateStaffDetails',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($data),
                CURLOPT_HTTPHEADER => array(
                    'Authorization: Bearer ' . $token,
                    'Content-Type: application/json'
                ),
            ));

            $response = curl_exec($curl);
            curl_close($curl);
            $response = json_decode($response, true);
        
            if ($response['status'] == 0) {
                return redirect('staff/list')->with('success', $response['response']);
            } else {
            
                return redirect()->back()->with('error', $response['response']);
            
            }

        } else{

            // $imageFile = $request->file('profilePicture');
            // $inputPath = $imageFile->getRealPath();

            // $originalName = pathinfo($imageFile->getClientOriginalName(), PATHINFO_FILENAME);
            // $outputFileName = $originalName . '_transparent_' . time() . '.png';
            // $outputPath = storage_path('app/public/processed/' . $outputFileName);

            // Storage::makeDirectory('public/processed');

            // $bgColor = 'white'; // or "rgb(255,255,255)"
            // $fuzz = 20; // fuzz percentage

            // $magickPath = '"C:\\Program Files\\ImageMagick-7.1.1-Q16-HDRI\\magick.exe"';

            // $command = $magickPath . ' convert ' .
            //         escapeshellarg($inputPath) .
            //         " -fuzz {$fuzz}% -transparent {$bgColor} " .
            //         escapeshellarg($outputPath);

            // exec($command, $output, $returnVar);

            // if ($returnVar === 0 && file_exists($outputPath)) {
            //     return response()->json([
            //         'success' => true,
            //         'url' => asset('storage/processed/' . $outputFileName),
            //     ]);
            // } else {
            //     return response()->json(['error' => 'Image processing failed', 'output' => $output], 500);
            // }

            if ($request->hasFile('profilePicture')) {
                $file = $request->file('profilePicture');
        
                $client = new Client();
        
                $response = $client->post($this->adminbaseUrl . '/api/master/uploadImage', [
                    'headers' => [
                            'Authorization' => 'Bearer ' . $token,
                            'Accept'        => 'application/json',
                        ],
                        'multipart' => [
                            [
                                'name'     => 'file',
                                'contents' => fopen($file->getPathname(), 'r'),
                                'filename' => $file->getClientOriginalName(),
                            ],
                        ],
                ]);
                // $image_nm = $file->getClientOriginalName();
                
                $body = $response->getBody()->getContents();
                $data = json_decode($body, true);
                $profileImage = $data['response'];
            }
            
            if ($request->hasFile('idProofFront')) {
                $file = $request->file('idProofFront');
        
                $client = new Client();
        
                $response = $client->post($this->adminbaseUrl . '/api/master/uploadImage', [
                    'multipart' => [
                        [
                            'name'     => 'file',
                            'contents' => fopen($file->getPathname(), 'r'),
                            'filename' => $file->getClientOriginalName(),
                            'headers'  => [
                                'Authorization: Bearer ' . $token,
                                'Content-Type' => $file->getMimeType(),
                            ],
                        ],
                    ],
                ]);
                // $image_nm = $file->getClientOriginalName();
                
                $body = $response->getBody()->getContents();
                $data = json_decode($body, true);
                $idFrontimage = $data['response'];
            }
        
        
            if ($request->hasFile('idProofBack')) {
                $file = $request->file('idProofBack');
        
                $client = new Client();
        
                $response = $client->post($this->adminbaseUrl . '/api/master/uploadImage', [
                    'multipart' => [
                        [
                            'name'     => 'file',
                            'contents' => fopen($file->getPathname(), 'r'),
                            'filename' => $file->getClientOriginalName(),
                            'headers'  => [
                                'Authorization: Bearer ' . $token,
                                'Content-Type' => $file->getMimeType(),
                            ],
                        ],
                    ],
                ]);
                // $image_nm = $file->getClientOriginalName();
                
                $body = $response->getBody()->getContents();
                $data = json_decode($body, true);
                $idBackImage = $data['response'];
            }
            
        
        
            $data = [
                "addressLine1" => $request->addressLine1,
                "addressLine2" => $request->addressLine2,
                "city" => $request->city,
                "country" => $request->country,
                "countryCode" => $request->countryCode,
                "designationMasterId" => (int)$request->designationMasterId,
                "dob" => $request->dob,
                "email" => $request->email,
                "fatherName" => $request->fatherName,
                "firstName" => $request->first_name,
                "gender" => $request->gender,
                "idNumber" => $request->idNumber,
                "idType" => $request->idType,
                "lastName" => $request->last_name,
                "middleName" => $request->middle_name,
                "onlyConcourseAccess" => $request->onlyConcourseAccess === 'true',
                "phone" => $request->phone,
                "postalCode" => $request->postalCode,
                "staffAccessAreaList" => $request->input('staffAccessAreaList', []),
                "staffId" => (int)$request->staffId,
                "state" => $request->state
            ];

            // Conditionally add images
            if ($profileImage) {
                $data['profilePicture'] = $profileImage;
            }
            if ($idFrontimage) {
                $data['idProofFront'] = $idFrontimage;
            }
            if ($idBackImage) {
                $data['idProofBack'] = $idBackImage;
            }

            //  dd(json_encode($data));

            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => $this->adminbaseUrl . '/api/staff/updateStaffDetails',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($data),
                CURLOPT_HTTPHEADER => array(
                    'Authorization: Bearer ' . $token,
                    'Content-Type: application/json'
                ),
            ));
            // dd(json_encode($data));

            $response = curl_exec($curl);
            // dd($response);
            curl_close($curl);
            $response = json_decode($response, true);
        
            if ($response['status'] == 0) {
                return redirect('staff/list')->with('success', $response['response']);
            } else {
            
                return redirect()->back()->with('error', $response['response']);
            
            }
        }
       
        

    }



    public function getViewStaff($staff_id){
        
        $staff_details = $this->fetchApiData($this->vendorbaseUrl . '/api/staff/getStaffDetailsById?staffId=' . $staff_id);
        
        if(isset($staff_details['status']) && $staff_details['status'] == 0){
            $staff_details = $staff_details['response'];
        }
         //dd($staff_details);
        return view('staffs.view', compact('staff_details'));
     
    }

    public function getViewStaffAdmin($staff_id){
        
        $staff_details = $this->fetchApiData($this->adminbaseUrl . '/api/staff/getStaffDetailsById?staffId=' . $staff_id);
        
        if(isset($staff_details['status']) && $staff_details['status'] == 0){
            $staff_details = $staff_details['response'];
        }
        // dd($staff_details);
        
        //new code
        $data = $this->fetchApiData($this->adminbaseUrl . '/api/master/getAllAccreditationType?pageNo=0&pageSize=30');

        if(isset($data['status']) && $data['status'] == 0){
            $accredation_types = $data['response']['dataSet'];
        }
        //end code
        // dd($accredation_types);
        return view('staffs.view_staff_admin', compact('staff_details','accredation_types'));
    }


    function uploadImage($filePath){
        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => $this->adminbaseUrl . '/api/master/uploadImage',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_POSTFIELDS => array('file' => new \CURLFile($filePath)),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $decoded = json_decode($response, true);

        // Return only the image name
        return isset($decoded['response']) ? $decoded['response'] : null;
    }

    private function checkStaffLimit(){
        $staffLimit = $this->fetchApiData($this->vendorbaseUrl . '/api/staff/checkMaximumStaffLimit');
       
        // if($staffLimit['status'] == 0){
        //     $staffLimit = $staffLimit['response'];
        // }
        return $staffLimit;
    }


    public function uploadStaffProfile(Request $request){
        $staff_id = $request->staffId;
        // Handle profilePicture upload
        if ($request->hasFile('profilePicture')) {
            $file = $request->file('profilePicture');
            
            $client = new Client();
            
            $response = $client->post($this->adminbaseUrl . '/api/staff/uploadStaffImage'   , [
                'multipart' => [
                    [
                        'name'     => 'file',
                        'contents' => fopen($file->getRealPath(), 'r'),
                        'filename' => $file->getClientOriginalName(),
                        'headers'  => [
                            'Content-Type' => $file->getMimeType(),
                        ],
                    ],
                    [
                        'name'     => 'staffId',
                        'contents' => $staff_id,
                    ],
                ],
                            
            ]);
            // dd($response);
            // $image_nm = $file->getClientOriginalName();
            
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);

            return response()->json([
                'status' => $data['status'],
                'response' => $data['response'],
            ]);
            // dd($data);
        }

        return response()->json(['status' => 0, 'error' => 'No file uploaded'], 400);
    }
}
