@extends('layouts.app')
@section('content')
<!-- Main Content Wrapper -->
      <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <div class="flex items-center space-x-4 py-5 lg:py-6">
          <h2
            class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl"
          >
           Profile
          </h2>
          <div class="hidden h-full py-1 sm:flex">
            <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
          </div>
          
        </div>
        @if(session('error'))
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-2 rounded mb-4" style="margin-bottom: 20px;
          color: red;">
          <span class="mr-2 text-xl">ⓘ</span>
          {{ session('error') }}
        </div>
        @endif
        <form action="{{ url('/add-profile') }}" method="post" enctype="multipart/form-data">  
        @csrf
        <div class="grid grid-cols-12 gap-4 sm:gap-5 lg:gap-6">
          <div class="col-span-12 lg:col-span-4">
            <div class="card p-4 sm:p-5">
              <div class="flex items-center space-x-4">
                <div class="avatar size-14">
                  <img
                    class="rounded-full"
                    src="{{$profile_data['profilePicture']}}"
                    alt="avatar"
                  />
                </div>
                <div>
                  <h3
                    class="text-base font-medium text-slate-700 dark:text-navy-100"
                  >
                  {{$profile_data['name']}}
                  </h3>
                  <p class="text-xs-plus">{{$profile_data['countryCode']}}{{$profile_data['mobileNumber']}}</p>
                </div>
              </div>
              <ul class="mt-6 space-y-1.5 font-inter font-medium">
                <li>
                  <a
                    class="flex items-center space-x-2 rounded-lg bg-primary px-4 py-2.5 tracking-wide text-white outline-hidden transition-all dark:bg-accent"
                    href="#"
                  >
                    
                    <span>{{$profile_data['event']['eventName']}}</span>
                  </a>
                </li>
                
              </ul>
            </div>
          </div>
          
          <div class="col-span-12 lg:col-span-8">
            <div class="card">
              <div
                class="flex flex-col items-center space-y-4 border-b border-slate-200 p-4 dark:border-navy-500 sm:flex-row sm:justify-between sm:space-y-0 sm:px-5"
              >
                <h2
                  class="text-lg font-medium tracking-wide text-slate-700 dark:text-navy-100"
                >
                  Profile Details
                </h2>
                <div class="flex justify-center space-x-2">
                  <button
                    class="btn min-w-[7rem] rounded-full border border-slate-300 font-medium text-slate-700 hover:bg-slate-150 focus:bg-slate-150 active:bg-slate-150/80 dark:border-navy-450 dark:text-navy-100 dark:hover:bg-navy-500 dark:focus:bg-navy-500 dark:active:bg-navy-500/90"
                  >
                    Cancel
                  </button>
                  <button
                    class="btn min-w-[7rem] rounded-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
                  >
                    Save
                  </button>
                </div>
              </div>
              <div class="p-4 sm:p-5">
                <div class="flex flex-col">
                  <span
                    class="text-base font-medium text-slate-600 dark:text-navy-100"
                    >Avatar</span
                  >
                  <div class="avatar mt-1.5 size-20 filepond fp-bordered label-icon w-28 relative">
                    <!-- Profile Image -->
                    <img
                        id="profile-preview"
                        class="mask is-squircle"
                        src="{{ $profile_data['profilePicture'] }}"
                        alt="avatar"
                    />

                    <!-- Edit Button -->
                    <div
                        class="absolute bottom-0 right-0 flex items-center justify-center rounded-full bg-white dark:bg-navy-700"
                    >
                        <button
                        type="button"
                        onclick="document.getElementById('profilePicture').click()"
                        class="btn size-6 rounded-full border border-slate-200 p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:border-navy-500 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
                        >
                        <svg
                            xmlns="http://www.w3.org/2000/svg"
                            class="size-3.5"
                            viewBox="0 0 20 20"
                            fill="currentColor"
                        >
                            <path
                            d="M13.586 3.586a2 2 0 112.828 2.828l-.793.793-2.828-2.828.793-.793zM11.379 5.793L3 14.172V17h2.828l8.38-8.379-2.83-2.828z"
                            />
                        </svg>
                        </button>
                    </div>

                    <!-- Hidden File Input -->
                    <input
                        type="file"
                        name="profilePicture"
                        id="profilePicture"
                        class="hidden"
                        accept="image/*"
                        onchange="previewProfile(this)"
                    />
                    </div>

                    <script>
                    function previewProfile(input) {
                        if (input.files && input.files[0]) {
                        const reader = new FileReader();
                        reader.onload = function (e) {
                            document.getElementById('profile-preview').src = e.target.result;
                        };
                        reader.readAsDataURL(input.files[0]);
                        }
                    }
                    </script>

                </div>
                <div class="my-7 h-px bg-slate-200 dark:bg-navy-500"></div>
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                  <label class="block">
                    <span>Display name </span>
                    <span class="relative mt-1.5 flex">
                      <input
                        name="contactPerson"
                        class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                        placeholder="Enter name"
                        type="text"
                        value="{{$profile_data['name']}}"
                      />
                      <span
                        class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
                      >
                        <i class="fa-regular fa-user text-base"></i>
                      </span>
                    </span>
                  </label>
                  
                  <label class="block">
                    <span>Phone Number</span>
                    <span class="relative mt-1.5 flex">
                      <input
                        name="mobileNumber"
                        class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                        placeholder="Enter phone number"
                        type="text"
                        value="{{$profile_data['mobileNumber']}}"
                      />
                      <span
                        class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
                      >
                        <i class="fa fa-phone"></i>
                      </span>

                  </label>
                </div>
                <div class="my-7 h-px bg-slate-200 dark:bg-navy-500"></div>
                <div>
                  <h3
                    class="text-base font-medium text-slate-600 dark:text-navy-100"
                  >
                    Advanced Settings
                  </h3>
                  
                  <div class=" items-center justify-between pt-4">
                    <div class=" items-center space-x-4">
                        <label class="block">
                            <span>SMS Summary Frequency</span>
                            <select name="smsSummaryFrequency"
                            class="form-select mt-1.5 w-full rounded-full border border-slate-300 bg-white px-4 py-2 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent"
                            >
                                <option value="">Please Select </option>
                                <option value="Immedialtely">Immedialtely</option>
                                <option value="Every Hour">Every Hour</option>
                                <option value="Every 6 Hour">Every 6 Hour</option>
                                <option value="Daily">Daily</option>
                            </select>
                        </label>
                    </div>
                    
                  </div>
                </div>
              </div>
            </div>
          </div>
           
        </div>
        </form>
      </main>

@endsection