@extends('layouts.app')
@section('content')
@php
    $userType = session('type');
@endphp  
<style>
  .dynamic-box {
    display: inline-block;
    white-space: pre-wrap;
    word-wrap: break-word;
    padding: 4px;
    border: none;
    background: transparent;
    font-family: inherit;
    font-size: inherit;
    min-width: 1em;
    max-width: 100%; /* Optional if you want to restrict width */
  }
  .box-css{
    margin-left: 11px;
    font-size: 16px;
  }
  .popper-margin{
    margin-bottom:6px;
  }
  .bg-red{
    background-color: red;
  }

  @media print {
    body, html {
        margin: 0;
        padding: 0;
    }

    @page {
        size: 3.5in 2.25in; /* Or 4in 3in for larger badge */
        margin: 0;
    }

    body * {
        visibility: hidden;
    }

    #cardBlock, #cardBlock * {
        visibility: visible;
    }

    #cardBlock {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        padding: 10px;
        box-sizing: border-box;
        background-color: white !important;
    }

    button, header, footer, nav {
        display: none !important;
    }
  }

</style>

    <!-- Main Content Wrapper -->
      <main class="main-content w-full px-[var(--margin-x)] pb-8">
        @if(session('success'))
        <div class="alert flex rounded-full bg-success/10 py-4 px-4 text-success dark:bg-accent-light/15 dark:text-accent-light sm:px-5">
            {{ session('success') }}
        </div>
    @endif
    @if(session('error'))
        <div class="alert flex rounded-full bg-error/10 py-4 px-4 text-error dark:bg-accent-light/15 dark:text-accent-light sm:px-5">
            {{ session('error') }}
        </div>
    @endif
          <div class="flex items-center justify-between flex-wrap py-5 lg:py-6">
            <!-- Left side: Heading + Breadcrumbs -->
            <div class="flex items-center space-x-4">
                <h2 class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl">
                    All Staffs
                </h2>
                <div class="hidden h-full py-1 sm:flex">
                    <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
                </div>
                <ul class="hidden flex-wrap items-center space-x-2 sm:flex">
                    <li class="flex items-center space-x-2">
                        <a class="text-primary transition-colors hover:text-primary-focus dark:text-accent-light dark:hover:text-accent" href="#">
                            Staffs
                        </a>
                        <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                        </svg>
                    </li>
                    <li>List</li>
                </ul>
            </div>
            @if($userType == 'vendor')
            @php
                                $token = session('token');
                            @endphp
                            
            <!-- Right side: Add button -->
            <a href="javascript:void(0)"
                                x-data
                                @click="
                                    fetch('{{ config('app.vendor_base_url') }}/api/staff/checkMaximumStaffLimit', {
                                        method: 'GET',
                                        headers: {
                                            'Authorization': 'Bearer {{ $token }}',
                                            'Accept': 'application/json'
                                        }
                                    })
                                    .then(res => res.json())
                                    .then(data => {
                                    console.log(data);
                                        if (data.status === 0 && data.response === false) {
                                            window.location.href = '{{ route('staff.add') }}';
                                        
                                        } else {
                                            alert('The maximum staff limit has been reached. Please contact the administrator for assistance');
                                            
                                        }
                                    })
                                    .catch(err => {
                                        alert('Something went wrong.');
                                        console.error(err);
                                    })
                                ">
                <button class="btn px-3 py-1.5 text-sm space-x-2 bg-primary font-medium text-white shadow-md shadow-primary/40 hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:shadow-accent/40 dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 text-indigo-50" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                    </svg>
                    <span>Add</span>
                </button>
            </a>
            @else
            <!-- Right side: Add button -->
            
              <button id="exportBtn" class="exportBtn btn px-3 py-1.5 text-sm space-x-2 bg-primary font-medium text-white shadow-md shadow-primary/40 hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:shadow-accent/40 dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
                  <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 text-indigo-50" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                  </svg>
                  <span>Export</span>
              </button>
           
            @endif
        </div>
        
        <div class="grid grid-cols-1 gap-4 sm:gap-5 lg:gap-6">
        <div class="min-w-full overflow-x-auto" >
          <table class="w-full text-left" id="staffCounts">
            <thead>
              <tr class="border border-transparent  dark:border-b-navy-500">
                <th
                  class="whitespace-nowrap  font-semibold uppercase text-slate-800 dark:text-navy-100 " style="cursor: pointer;"
                >
                  <div class="badge bg-navy-700 text-white dark:bg-navy-900">All Data</div>
                </th>
                @if($userType == 'vendor')
              
                <th
                  class="whitespace-nowrap font-semibold uppercase text-slate-800 dark:text-navy-100" style="cursor: pointer;"
                >
                  <div class="badge bg-primary text-white dark:bg-accent">Saved As Draft</div>
                </th>
                @endif
                <th
                  class="whitespace-nowrap font-semibold uppercase text-slate-800 dark:text-navy-100" style="cursor: pointer;"
                >
                  <div class="badge text-white dark:bg-accent" style="background-color: blueviolet;">Verified</div>
                </th>
                <th
                  class="whitespace-nowrap font-semibold uppercase text-slate-800 dark:text-navy-100 " style="cursor: pointer;"
                >
                  <div class="badge bg-secondary text-white">Pending</div>                
                </th>
                <th
                  class="whitespace-nowrap font-semibold uppercase text-slate-800 dark:text-navy-100 " style="cursor: pointer;"
                >
                <div class="badge bg-success text-white">Approved</div>
                  
                </th>
                <th
                  class="whitespace-nowrap font-semibold uppercase text-slate-800 dark:text-navy-100" style="cursor: pointer;"
                >
                <div class="badge bg-warning text-white">Incorrect</div>                
                </th>
                <th
                  class="whitespace-nowrap  font-semibold uppercase text-slate-800 dark:text-navy-100 " style="cursor: pointer;"
                >
                <div class="badge bg-error text-white">Rejected</div>
                  
                </th>
                <th
                  class="whitespace-nowrap font-semibold uppercase text-slate-800 dark:text-navy-100" style="cursor: pointer;"
                >
                <div class="badge bg-info text-white">Printed</div>
                  
                </th>
                <th
                  class="whitespace-nowrap font-semibold uppercase text-slate-800 dark:text-navy-100 " style="cursor: pointer;"
                >
                <div class="badge bg-slate-150 text-slate-800">Re-Printed</div>
                 
                </th>
                <th
                  class="whitespace-nowrap font-semibold uppercase text-slate-800 dark:text-navy-100 " style="cursor: pointer;"
                >
                <div class="badge bg-red text-white">Blacklisted</div>

                  
                </th>
              </tr>
            </thead>
            <tbody>
              <tr class="border border-transparent border-b-slate-200 dark:border-b-navy-500">
                <td class="whitespace-nowrap px-4 py-3 font-medium text-slate-700 dark:text-navy-100 sm:px-5">{{$staff_counts['totalStaffCount']}}</td>
                @if($userType == 'vendor')
                <td class="whitespace-nowrap px-4 py-3 font-medium text-slate-700 dark:text-navy-100 sm:px-5">{{$staff_counts['draft']}}</td>
                @endif
                <td class="whitespace-nowrap px-4 py-3 font-medium text-slate-700 dark:text-navy-100 sm:px-5">{{$staff_counts['verified']}}</td>

                <td class="whitespace-nowrap px-4 py-3 font-medium text-slate-700 dark:text-navy-100 sm:px-5">{{$staff_counts['pending']}}</td>
                <td class="whitespace-nowrap px-4 py-3 font-medium text-slate-700 dark:text-navy-100 sm:px-5">{{$staff_counts['approved']}}</td>
                <td class="whitespace-nowrap px-4 py-3 font-medium text-slate-700 dark:text-navy-100 sm:px-5">{{$staff_counts['incorrect']}}</td>
                <td class="whitespace-nowrap px-4 py-3 font-medium text-slate-700 dark:text-navy-100 sm:px-5">{{$staff_counts['rejected']}}</td>
                <td class="whitespace-nowrap px-4 py-3 font-medium text-slate-700 dark:text-navy-100 sm:px-5">{{$staff_counts['printed']}}</td>
                <td class="whitespace-nowrap px-4 py-3 font-medium text-slate-700 dark:text-navy-100 sm:px-5">{{$staff_counts['reprinted']}}</td>
                <td class="whitespace-nowrap px-4 py-3 font-medium text-slate-700 dark:text-navy-100 sm:px-5">{{$staff_counts['blacklisted']}}</td>
              </tr>
              
              
            </tbody>
          </table>
        </div>
          <!-- Table With Filter -->
          <div x-data="{isFilterExpanded:false}">
            
            <div class="flex items-center justify-between">
              <h2
                class="text-base font-medium tracking-wide text-slate-700 line-clamp-1 dark:text-navy-100"
              >
                Staff List
              </h2>
              <div class="flex">
              @if($userType != 'vendor')
                <div id="remove" class="badge space-x-2 bg-slate-150 text-slate-800 dark:bg-navy-500 dark:text-navy-100" style="margin-right: 8px;cursor:pointer;">
                    <svg xmlns="http://www.w3.org/2000/svg" class="size-5 shrink-0 text-primary dark:text-accent" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5">
                      <path stroke-linecap="round" stroke-linejoin="round" d="M9 3v2m6-2v2M9 19v2m6-2v2M5 9H3m2 6H3m18-6h-2m2 6h-2M7 19h10a2 2 0 002-2V7a2 2 0 00-2-2H7a2 2 0 00-2 2v10a2 2 0 002 2zM9 9h6v6H9V9z"></path>
                    </svg>
                  <span>Remove BG</span>
                </div>
                <div id="restore" class="badge space-x-2 bg-slate-150 text-slate-800 dark:bg-navy-500 dark:text-navy-100" style="margin-right: 8px;cursor:pointer;">
                  <svg xmlns="http://www.w3.org/2000/svg" class="size-4" viewBox="0 0 20 20" fill="currentColor">
                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-8.707l-3-3a1 1 0 00-1.414 0l-3 3a1 1 0 001.414 1.414L9 9.414V13a1 1 0 102 0V9.414l1.293 1.293a1 1 0 001.414-1.414z" clip-rule="evenodd"></path>
                  </svg>
                  <span>Restore BG</span>
                </div>
                
                <div x-data="{showModal:false}">
                  <button
                    @click="showModal = true"
                    class="btn bg-slate-150 font-medium text-slate-800 hover:bg-slate-200 focus:bg-slate-200 active:bg-slate-200/80 dark:bg-navy-500 dark:text-navy-50 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90"
                    style="font-size: smaller;">
                    <svg xmlns="http://www.w3.org/2000/svg" class="size-5 text-info" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5">
                      <path stroke-linecap="round" stroke-linejoin="round" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                    </svg>
                    <span style="padding-left:5px;">Change Access Area</span>
                  </button>
                  <template x-teleport="#x-teleport-target">
                    <div
                      class="fixed inset-0 z-[100] flex flex-col items-center justify-center overflow-hidden px-4 py-6 sm:px-5"
                      x-show="showModal"
                      role="dialog"
                      @keydown.window.escape="showModal = false"
                    >
                      <div
                        class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300"
                        @click="showModal = false"
                        x-show="showModal"
                        x-transition:enter="ease-out"
                        x-transition:enter-start="opacity-0"
                        x-transition:enter-end="opacity-100"
                        x-transition:leave="ease-in"
                        x-transition:leave-start="opacity-100"
                        x-transition:leave-end="opacity-0"
                      ></div>
                      <div
                        class="relative w-full max-w-lg origin-top rounded-lg bg-white transition-all duration-300 dark:bg-navy-700"
                        x-show="showModal"
                        x-transition:enter="easy-out"
                        x-transition:enter-start="opacity-0 scale-95"
                        x-transition:enter-end="opacity-100 scale-100"
                        x-transition:leave="easy-in"
                        x-transition:leave-start="opacity-100 scale-100"
                        x-transition:leave-end="opacity-0 scale-95"
                      >
                        <div
                          class="flex justify-between rounded-t-lg bg-slate-200 px-4 py-3 dark:bg-navy-800 sm:px-5"
                        >
                          <h3 class="text-base font-medium text-slate-700 dark:text-navy-100">
                            Change Access Area
                          </h3>
                          <button
                            @click="showModal = !showModal"
                            class="btn -mr-1.5 size-7 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
                          >
                            <svg
                              xmlns="http://www.w3.org/2000/svg"
                              class="size-4.5"
                              fill="none"
                              viewBox="0 0 24 24"
                              stroke="currentColor"
                              stroke-width="2"
                            >
                              <path
                                stroke-linecap="round"
                                stroke-linejoin="round"
                                d="M6 18L18 6M6 6l12 12"
                              ></path>
                            </svg>
                          </button>
                        </div>
                        <div class="px-4 py-4 sm:px-5">
                        <div
                            class="col-span-12 lg:col-span-6"
                            id="access_area"
                           
                          >
                            <span class="font-medium text-slate-600 dark:text-navy-100">Access Area</span>
                            <div class="mt-2 grid grid-cols-1 gap-4 sm:grid-cols-4 sm:gap-5 lg:gap-6">
                            @foreach($all_access_area as $area)

                              <label class="inline-flex items-center space-x-2">
                                <input name="accessAreaId[]"
                                  class="form-checkbox is-basic size-5 rounded-sm border-slate-400/70 checked:!border-success checked:bg-success hover:!border-success focus:!border-success dark:border-navy-400"
                                  type="checkbox"
                                  value="{{$area['accessAreaId']}}"
                                />
                                <span>{{$area['name']}} ({{$area['areaCode'] }})</span>
                              </label>
                            @endforeach  
                            </div>
                          </div>
          
                          <div class="mt-4 space-y-4">              
                            <div class="space-x-2 text-right">
                              <button
                                @click="showModal = false"
                                class="btn min-w-[7rem] rounded-full border border-slate-300 font-medium text-slate-800 hover:bg-slate-150 focus:bg-slate-150 active:bg-slate-150/80 dark:border-navy-450 dark:text-navy-50 dark:hover:bg-navy-500 dark:focus:bg-navy-500 dark:active:bg-navy-500/90"
                              >
                                Cancel
                              </button>
                              <button
                                  @click="showModal = false; submitAccessAreas();"
                                  class="btn min-w-[7rem] rounded-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
                                >
                                Apply
                              </button>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </template>
                </div>
              @endif
                <button
                  @click="isFilterExpanded = !isFilterExpanded"
                  class="btn size-8 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
                  >
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    class="size-4.5"
                    fill="none"
                    viewBox="0 0 24 24"
                  >
                    <path
                      stroke="currentColor"
                      stroke-linecap="round"
                      stroke-width="2"
                      d="M18 11.5H6M21 4H3m6 15h6"
                    />
                  </svg>
                </button>
                @if($userType != 'vendor')
                <div
                  x-data="usePopper({placement:'bottom-end',offset:4})"
                  @click.outside="isShowPopper && (isShowPopper = false)"
                  class="inline-flex"
                  >
                  <button
                    x-ref="popperRef"
                    @click="isShowPopper = !isShowPopper"
                    class="btn size-8 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
                  >
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      class="size-4.5"
                      fill="none"
                      viewBox="0 0 24 24"
                      stroke="currentColor"
                    >
                      <path
                        stroke-linecap="round"
                        stroke-linejoin="round"
                        stroke-width="2"
                        d="M12 5v.01M12 12v.01M12 19v.01M12 6a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2z"
                      />
                    </svg>
                  </button>
                  
                  <div
                    x-ref="popperRoot"
                    class="popper-root"
                    :class="isShowPopper && 'show'"
                    >
                    <div
                      class="popper-box rounded-md border border-slate-150 bg-white py-1.5 font-inter dark:border-navy-500 dark:bg-navy-700"
                    >
                      <ul>
                        <li class="popper-margin" x-data="{ showModal: false, selectedType: '' }">
                          <a
                            href="#"
                            @click.prevent="showModal = true"
                            class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                          >
                          
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                              <circle cx="12" cy="8" r="4" stroke="#28a745" stroke-width="2" />
                              <path d="M4 20c0-2.5 4-4 8-4s8 1.5 8 4" stroke="#28a745" stroke-width="2" stroke-linecap="round" />
                            </svg>
                            <span class="box-css">Approve</span>
                          </a>
                          <!-- Modal -->
                          <template x-teleport="#x-teleport-target">
                            <div
                              class="fixed inset-0 z-[100] flex flex-col items-center justify-center overflow-hidden px-4 py-6 sm:px-5"
                              x-show="showModal"
                              role="dialog"
                              @keydown.window.escape="showModal = false"
                            >
                              <div
                                class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300"
                                @click="showModal = false"
                                x-show="showModal"
                                x-transition:enter="ease-out"
                                x-transition:enter-start="opacity-0"
                                x-transition:enter-end="opacity-100"
                                x-transition:leave="ease-in"
                                x-transition:leave-start="opacity-100"
                                x-transition:leave-end="opacity-0"
                              ></div>

                              <div
                                class="relative w-full max-w-lg origin-top rounded-lg bg-white transition-all duration-300 dark:bg-navy-700"
                                x-show="showModal"
                                x-transition:enter="easy-out"
                                x-transition:enter-start="opacity-0 scale-95"
                                x-transition:enter-end="opacity-100 scale-100"
                                x-transition:leave="easy-in"
                                x-transition:leave-start="opacity-100 scale-100"
                                x-transition:leave-end="opacity-0 scale-95"
                              >
                                <div class="flex justify-between rounded-t-lg bg-slate-200 px-4 py-3 dark:bg-navy-800 sm:px-5">
                                  <h3 class="text-base font-medium text-slate-700 dark:text-navy-100">Select Accredation Type</h3>
                                  <button
                                    @click="showModal = false"
                                    class="btn -mr-1.5 size-7 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
                                  >
                                    <svg xmlns="http://www.w3.org/2000/svg" class="size-4.5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                      <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"></path>
                                    </svg>
                                  </button>
                                </div>
                                <div class="px-4 py-4 sm:px-5">
                                  <label class="block">
                                    <span>Choose Type :</span>
                                    <select x-model="selectedType"
                                      class="form-select mt-1.5 w-full rounded-lg border border-slate-300 bg-white px-3 py-2 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent"
                                    >
                                    <option value="">Select...</option>
                                    @foreach($accredation_types as $type)                                    
                                      <option value="{{$type['accreditationTypeId']}}">{{$type['name']}} ({{$type['inventoryAvailableStock']}})</option>
                                    @endforeach
                                    </select>
                                  </label>
                                                                  
                                  <div class="mt-4 space-x-2 text-right">
                                    <button
                                      @click="
                                      showModal = false"
                                      class="btn min-w-[7rem] rounded-full border border-slate-300 font-medium text-slate-800 hover:bg-slate-150 focus:bg-slate-150 active:bg-slate-150/80 dark:border-navy-450 dark:text-navy-50 dark:hover:bg-navy-500 dark:focus:bg-navy-500 dark:active:bg-navy-500/90"
                                    
                                      >
                                      Cancel
                                    </button>
                                    <button
                                      @click="
                                        submitBulkStatus(selectedType, 'APPROVED');
                                        showModal = false
                                      "
                                      class="btn min-w-[7rem] rounded-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
                                    >
                                      Approve
                                    </button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </template>
                        </li>
                        <li class="popper-margin" x-data="{ showModal: false, selectedType: '' }">
                          <a
                            href="#"
                            @click.prevent="showModal = true"
                            class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                          >
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
                              <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z" stroke="#f1c40f" stroke-width="2"/>
                              <polyline points="14 2 14 8 20 8" stroke="#f1c40f" stroke-width="2" fill="none"/>
                            </svg>
                            <span class="box-css">Incorrect</span>
                          </a>

                          <!-- Modal -->
                          <template x-teleport="#x-teleport-target">
                            <div
                              class="fixed inset-0 z-[100] flex flex-col items-center justify-center overflow-hidden px-4 py-6 sm:px-5"
                              x-show="showModal"
                              role="dialog"
                              @keydown.window.escape="showModal = false"
                            >
                              <div
                                class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300"
                                @click="showModal = false"
                                x-show="showModal"
                                x-transition:enter="ease-out"
                                x-transition:enter-start="opacity-0"
                                x-transition:enter-end="opacity-100"
                                x-transition:leave="ease-in"
                                x-transition:leave-start="opacity-100"
                                x-transition:leave-end="opacity-0"
                              ></div>

                              <div
                                class="relative w-full max-w-lg origin-top rounded-lg bg-white transition-all duration-300 dark:bg-navy-700"
                                x-show="showModal"
                                x-transition:enter="ease-out"
                                x-transition:enter-start="opacity-0 scale-95"
                                x-transition:enter-end="opacity-100 scale-100"
                                x-transition:leave="ease-in"
                                x-transition:leave-start="opacity-100 scale-100"
                                x-transition:leave-end="opacity-0 scale-95"
                              >
                                <div class="flex justify-between rounded-t-lg bg-slate-200 px-4 py-3 dark:bg-navy-800 sm:px-5">
                                  <h3 class="text-base font-medium text-slate-700 dark:text-navy-100">Select Reason</h3>
                                  <button
                                    @click="showModal = false"
                                    class="btn -mr-1.5 size-7 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
                                  >
                                    <svg xmlns="http://www.w3.org/2000/svg" class="size-4.5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                      <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"></path>
                                    </svg>
                                  </button>
                                </div>

                                <div class="px-4 py-4 sm:px-5">
                                  <label class="block">
                                    <span>Select Reason :</span>
                                    <select
                                      x-model="selectedType"
                                      class="form-select mt-1.5 w-full rounded-lg border border-slate-300 bg-white px-3 py-2 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent"
                                      >
                                      <option>Please Select</option>
                                      <option>Designation Incorrect</option>
                                      <option>DOB Incorrect</option>
                                      <option>ID Number Incorrect</option>
                                      <option>ID Proof Incorrect</option>
                                      <option>ID Proof insufficient - both sides required</option>
                                      <option>ID Proof unclear - submit new copy</option>
                                      <option>ID Proof and Photo do not match</option>
                                      <option>Photo needs to be cropped</option>
                                      <option>Photo not acceptable</option>
                                      <option>Residential Address Incorrect - must match ID</option>
                                      <option>Other</option>
                                    </select>
                                  </label>

                                  <div class="mt-4 space-x-2 text-right">
                                    <button
                                      @click="showModal = false"
                                      class="btn min-w-[7rem] rounded-full border border-slate-300 font-medium text-slate-800 hover:bg-slate-150 focus:bg-slate-150 active:bg-slate-150/80 dark:border-navy-450 dark:text-navy-50 dark:hover:bg-navy-500 dark:focus:bg-navy-500 dark:active:bg-navy-500/90"
                                    >
                                      Cancel
                                    </button>
                                    <button
                                      @click="
                                          submitBulkStatus(selectedType, 'INCORRECT');
                                          showModal = false
                                        "
                                      class="btn min-w-[7rem] rounded-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
                                    >
                                      Submit
                                    </button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </template>
                        </li>
                        <li class="popper-margin">
                          <a
                            href="#"
                            data-status="Verified"
                            @click.prevent="submitBulkStatus(1, 'VERIFIED')"
                            class="status-action flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                          >
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                              <circle cx="12" cy="12" r="10" stroke="#28a745" stroke-width="2" />
                              <path d="M8 12l3 3 5-5" stroke="#28a745" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                            <span class="box-css">Verified</span>
                          </a>
                        </li>

                        <li class="popper-margin" >
                          <a
                            href="#" data-status="Unapprove"
                            @click.prevent="submitBulkStatus(0, 'UNAPPROVED')"
                            class="status-action flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                            >
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                              <circle cx="10" cy="8" r="4" stroke="#fd7e14" stroke-width="2"/>
                              <path d="M3 20c0-2.5 5-4 9-4" stroke="#fd7e14" stroke-width="2" stroke-linecap="round"/>
                              <line x1="18" y1="8" x2="22" y2="12" stroke="#fd7e14" stroke-width="2"/>
                              <line x1="22" y1="8" x2="18" y2="12" stroke="#fd7e14" stroke-width="2"/>
                            </svg>
                            <span class="box-css">Unapprove</span></a
                          >
                        </li>
                        <li class="popper-margin" x-data="{ showModal: false, selectedType: '' }">
                          <a
                            href="#"
                            @click.prevent="showModal = true"
                            class="status-action flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                            data-status="Reject"
                          >
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                              <circle cx="12" cy="12" r="10" stroke="#dc3545" stroke-width="2"/>
                              <line x1="8" y1="8" x2="16" y2="16" stroke="#dc3545" stroke-width="2"/>
                              <line x1="16" y1="8" x2="8" y2="16" stroke="#dc3545" stroke-width="2"/>
                            </svg>
                            <span class="box-css">Reject</span>
                          </a>

                          <!-- Modal -->
                          <template x-teleport="#x-teleport-target">
                            <div
                              class="fixed inset-0 z-[100] flex flex-col items-center justify-center overflow-hidden px-4 py-6 sm:px-5"
                              x-show="showModal"
                              role="dialog"
                              @keydown.window.escape="showModal = false"
                            >
                              <div
                                class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300"
                                @click="showModal = false"
                                x-show="showModal"
                                x-transition:enter="ease-out"
                                x-transition:enter-start="opacity-0"
                                x-transition:enter-end="opacity-100"
                                x-transition:leave="ease-in"
                                x-transition:leave-start="opacity-100"
                                x-transition:leave-end="opacity-0"
                              ></div>

                              <div
                                class="relative w-full max-w-lg origin-top rounded-lg bg-white transition-all duration-300 dark:bg-navy-700"
                                x-show="showModal"
                                x-transition:enter="ease-out"
                                x-transition:enter-start="opacity-0 scale-95"
                                x-transition:enter-end="opacity-100 scale-100"
                                x-transition:leave="ease-in"
                                x-transition:leave-start="opacity-100 scale-100"
                                x-transition:leave-end="opacity-0 scale-95"
                              >
                                <div class="flex justify-between rounded-t-lg bg-slate-200 px-4 py-3 dark:bg-navy-800 sm:px-5">
                                  <h3 class="text-base font-medium text-slate-700 dark:text-navy-100">Reason for Rejection</h3>
                                  <button
                                    @click="showModal = false"
                                    class="btn -mr-1.5 size-7 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
                                  >
                                    <svg xmlns="http://www.w3.org/2000/svg" class="size-4.5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                      <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"></path>
                                    </svg>
                                  </button>
                                  
                                </div>

                                <div class="px-4 py-4 sm:px-5">
                                  <label class="block">
                                    <span>Select Reason :</span>
                                    <select
                                      x-model="selectedType"
                                      class="form-select mt-1.5 w-full rounded-lg border border-slate-300 bg-white px-3 py-2 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent"
                                    >
                                      <option>Please Select</option>
                                      <option>Accreditation no longer required</option>
                                      <option>Applicant Underage</option>
                                      <option>Duplicate application</option>
                                      <option>Non Working Role</option>
                                      <option>Rejected by Police</option>
                                      <option>Other</option>
                                    </select>
                                  </label>

                                  <div class="mt-4 space-x-2 text-right">
                                    <button
                                      @click="showModal = false"
                                      class="btn min-w-[7rem] rounded-full border border-slate-300 font-medium text-slate-800 hover:bg-slate-150 focus:bg-slate-150 active:bg-slate-150/80 dark:border-navy-450 dark:text-navy-50 dark:hover:bg-navy-500 dark:focus:bg-navy-500 dark:active:bg-navy-500/90"
                                    >
                                      Cancel
                                    </button>
                                    <button
                                        @click="
                                          submitBulkStatus(selectedType, 'REJECTED');
                                          showModal = false
                                        "
                                      class="btn min-w-[7rem] rounded-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
                                    >
                                      Submit
                                    </button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </template>
                        </li>

                        <li class="popper-margin" >
                          <a
                            href="#" data-status="Unreject"
                            @click.prevent="submitBulkStatus(0, 'UNREJECTED')"
                            class="status-action flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                            >
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                              <circle cx="12" cy="12" r="10" stroke="#ffc107" stroke-width="2"/>
                              <line x1="12" y1="8" x2="12" y2="16" stroke="#ffc107" stroke-width="2"/>
                              <line x1="8" y1="12" x2="16" y2="12" stroke="#ffc107" stroke-width="2"/>
                            </svg>
                            <span class="box-css">Unreject</span></a
                          >
                        </li>
                        <li class="popper-margin" x-data="{ showModal: false, selectedType: '' }">
                          <a
                            href="#" data-status="RePrint"
                            @click.prevent="showModal = true"
                            class="status-action flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                            >
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                              <rect x="6" y="3" width="12" height="5" stroke="#17a2b8" stroke-width="2"/>
                              <rect x="6" y="16" width="12" height="5" stroke="#17a2b8" stroke-width="2"/>
                              <path d="M6 8H5a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2h-1" stroke="#17a2b8" stroke-width="2"/>
                            </svg>
                            <span class="box-css">Send to Re-Print</span></a
                          >
                          <!-- Modal -->
                          <template x-teleport="#x-teleport-target">
                            <div
                              class="fixed inset-0 z-[100] flex flex-col items-center justify-center overflow-hidden px-4 py-6 sm:px-5"
                              x-show="showModal"
                              role="dialog"
                              @keydown.window.escape="showModal = false"
                            >
                              <div
                                class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300"
                                @click="showModal = false"
                                x-show="showModal"
                                x-transition:enter="ease-out"
                                x-transition:enter-start="opacity-0"
                                x-transition:enter-end="opacity-100"
                                x-transition:leave="ease-in"
                                x-transition:leave-start="opacity-100"
                                x-transition:leave-end="opacity-0"
                              ></div>

                              <div
                                class="relative w-full max-w-lg origin-top rounded-lg bg-white transition-all duration-300 dark:bg-navy-700"
                                x-show="showModal"
                                x-transition:enter="easy-out"
                                x-transition:enter-start="opacity-0 scale-95"
                                x-transition:enter-end="opacity-100 scale-100"
                                x-transition:leave="easy-in"
                                x-transition:leave-start="opacity-100 scale-100"
                                x-transition:leave-end="opacity-0 scale-95"
                              >
                                <div class="flex justify-between rounded-t-lg bg-slate-200 px-4 py-3 dark:bg-navy-800 sm:px-5">
                                  <h3 class="text-base font-medium text-slate-700 dark:text-navy-100">Select Reason : </h3>
                                  <button
                                    @click="showModal = false"
                                    class="btn -mr-1.5 size-7 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
                                  >
                                    <svg xmlns="http://www.w3.org/2000/svg" class="size-4.5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                      <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"></path>
                                    </svg>
                                  </button>
                                </div>
                                <div class="px-4 py-4 sm:px-5">
                                  <label class="block">
                                    <span>Choose Reason :</span>
                                    <select
                                      x-model="selectedType"
                                      class="form-select mt-1.5 w-full rounded-lg border border-slate-300 bg-white px-3 py-2 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent"
                                    >
                                      <option>Please Select</option>
                                      <option>Card Damanged </option>
                                      <option>Card Lost</option>
                                      <option>Access Area Changed</option>
                                      <option>Wrong Data Printed </option>
                                      
                                    </select>
                                  </label>
                                                                  
                                  <div class="mt-4 space-x-2 text-right">
                                    <button
                                      @click="
                                      showModal = false"
                                      class="btn min-w-[7rem] rounded-full border border-slate-300 font-medium text-slate-800 hover:bg-slate-150 focus:bg-slate-150 active:bg-slate-150/80 dark:border-navy-450 dark:text-navy-50 dark:hover:bg-navy-500 dark:focus:bg-navy-500 dark:active:bg-navy-500/90"
                                    
                                      >
                                      Cancel
                                    </button>
                                    <button
                                      @click="
                                        submitBulkStatus(selectedType, 'REPRINTED');
                                        showModal = false
                                      "
                                      class="btn min-w-[7rem] rounded-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
                                    >
                                      Reprint
                                    </button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </template>
                        </li>
                      
                        <li class="popper-margin" x-data="{ showModal: false, selectedType: '' }">
                          <a
                            href="#"
                            @click.prevent="showModal = true" 
                            class="status-action flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                            data-status="Blacklist"
                          >
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                              <circle cx="12" cy="12" r="10" stroke="#dc3545" stroke-width="2"/>
                              <line x1="6.5" y1="6.5" x2="17.5" y2="17.5" stroke="#dc3545" stroke-width="2"/>
                            </svg>
                            <span class="box-css">Blacklist</span>
                          </a>

                          <!-- Blacklist Modal -->
                          <template x-teleport="#x-teleport-target">
                            <div
                              class="fixed inset-0 z-[100] flex flex-col items-center justify-center overflow-hidden px-4 py-6 sm:px-5"
                              x-show="showModal" 
                              role="dialog"
                              @keydown.window.escape="showModal = false"
                            >
                              <div
                                class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300"
                                @click="showModal = false" 
                                x-show="showModal" 
                                x-transition:enter="ease-out"
                                x-transition:enter-start="opacity-0"
                                x-transition:enter-end="opacity-100"
                                x-transition:leave="ease-in"
                                x-transition:leave-start="opacity-100"
                                x-transition:leave-end="opacity-0"
                              ></div>

                              <div
                                class="relative w-full max-w-lg origin-top rounded-lg bg-white transition-all duration-300 dark:bg-navy-700"
                                x-show="showModal" 
                                x-transition:enter="ease-out"
                                x-transition:enter-start="opacity-0 scale-95"
                                x-transition:enter-end="opacity-100 scale-100"
                                x-transition:leave="ease-in"
                                x-transition:leave-start="opacity-100 scale-100"
                                x-transition:leave-end="opacity-0 scale-95"
                              >
                                <div class="flex justify-between rounded-t-lg bg-slate-200 px-4 py-3 dark:bg-navy-800 sm:px-5">
                                  <h3 class="text-base font-medium text-slate-700 dark:text-navy-100">Reason for Blacklist</h3>
                                  <button
                                    @click="showModal = false" 
                                    class="btn -mr-1.5 size-7 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
                                  >
                                    <svg xmlns="http://www.w3.org/2000/svg" class="size-4.5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                      <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"></path>
                                    </svg>
                                  </button>
                                </div>

                                <div class="px-4 py-4 sm:px-5">
                                  <label class="block">
                                    <span>Select Reason :</span>
                                    <select
                                      x-model="selectedType"
                                      class="form-select mt-1.5 w-full rounded-lg border border-slate-300 bg-white px-3 py-2 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent"
                                    >
                                      <option>Please Select</option>
                                      <option>Accreditation no longer required</option>
                                      <option>Company no longer contracted</option>
                                      <option>Individual no longer contracted</option>
                                      <option>Misuse of accreditation</option>
                                      <option>Playoffs / Finals</option>
                                      <option>Other</option>
                                    </select>
                                  </label>

                                  <div class="mt-4 space-x-2 text-right">
                                    <button
                                      @click="showModal = false"
                                      class="btn min-w-[7rem] rounded-full border border-slate-300 font-medium text-slate-800 hover:bg-slate-150 focus:bg-slate-150 active:bg-slate-150/80 dark:border-navy-450 dark:text-navy-50 dark:hover:bg-navy-500 dark:focus:bg-navy-500 dark:active:bg-navy-500/90"
                                    >
                                      Cancel
                                    </button>
                                    <button
                                      @click="submitBulkStatus(selectedType, 'BLACKLISTED'); showModal = false" 
                                      class="btn min-w-[7rem] rounded-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
                                    >
                                      Submit
                                    </button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </template>
                        </li>


                      </ul>
                      
                    </div>
                  </div>
                 
                </div>
                @else
                <div
                  x-data="usePopper({placement:'bottom-end',offset:4})"
                  @click.outside="isShowPopper && (isShowPopper = false)"
                  class="inline-flex"
                  >
                  <button
                    x-ref="popperRef"
                    @click="isShowPopper = !isShowPopper"
                    class="btn size-8 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
                  >
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      class="size-4.5"
                      fill="none"
                      viewBox="0 0 24 24"
                      stroke="currentColor"
                    >
                      <path
                        stroke-linecap="round"
                        stroke-linejoin="round"
                        stroke-width="2"
                        d="M12 5v.01M12 12v.01M12 19v.01M12 6a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2z"
                      />
                    </svg>
                  </button>
                  
                  <div
                    x-ref="popperRoot"
                    class="popper-root"
                    :class="isShowPopper && 'show'"
                    >
                    <div
                      class="popper-box rounded-md border border-slate-150 bg-white py-1.5 font-inter dark:border-navy-500 dark:bg-navy-700"
                    >
                      <ul>
                        
                        <li class="popper-margin" >
                          <a
                            href="#" data-status="Pending"
                            @click.prevent="submitBulkStatus(0, 'PENDING')"
                            class="status-action flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                            >
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                              <circle cx="12" cy="8" r="4" stroke="#28a745" stroke-width="2" />
                              <path d="M4 20c0-2.5 4-4 8-4s8 1.5 8 4" stroke="#28a745" stroke-width="2" stroke-linecap="round" />
                            </svg>
                            <span class="box-css">Send To Submit</span></a
                          >
                        </li>
                        
                      </ul>
                      
                    </div>
                  </div>
                 
                </div>
                @endif
              </div>
            </div>
         
            <div x-show="isFilterExpanded" x-collapse >
                <div class=" py-3">
                  <div class="grid grid-cols-1 gap-4 sm:grid-cols-3 sm:gap-5 lg:gap-6" >
                    <input type="hidden" id="type" value="{{$value}}">
                    <label class="block">
                      <span>Staff name:</span>
                      <div class="relative mt-1.5 flex">
                        <input
                          name="staffName"
                          class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                          placeholder="Enter Staff Name"
                          type="text"
                        />
                        <span
                          class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
                        >
                          <svg
                            xmlns="http://www.w3.org/2000/svg"
                            class="size-4.5 transition-colors duration-200"
                            fill="none"
                            viewBox="0 0 24 24"
                          >
                            <path
                              stroke="currentColor"
                              stroke-width="1.5"
                              d="M3.082 13.944c-.529-.95-.793-1.425-.793-1.944 0-.519.264-.994.793-1.944L4.43 7.63l1.426-2.381c.559-.933.838-1.4 1.287-1.66.45-.259.993-.267 2.08-.285L12 3.26l2.775.044c1.088.018 1.631.026 2.08.286.45.26.73.726 1.288 1.659L19.57 7.63l1.35 2.426c.528.95.792 1.425.792 1.944 0 .519-.264.994-.793 1.944L19.57 16.37l-1.426 2.381c-.559.933-.838 1.4-1.287 1.66-.45.259-.993.267-2.08.285L12 20.74l-2.775-.044c-1.088-.018-1.631-.026-2.08-.286-.45-.26-.73-.726-1.288-1.659L4.43 16.37l-1.35-2.426z"
                            />
                            <circle
                              cx="12"
                              cy="12"
                              r="3"
                              stroke="currentColor"
                              stroke-width="1.5"
                            />
                          </svg>
                        </span>
                      </div>
                    </label>
                    @if($userType != 'vendor')
                    
                    <label class="block">
                      <span>Vendor name:</span>
                      <div class="relative mt-1.5 flex">
                        
                        <select
                          name="vendorId"
                          class="mt-1.5 w-full"
                          x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
                          >
                          <option value>Select the vendor name</option>
                          @foreach($all_vendors as $vendor)
                          <option value="{{$vendor['vendorId']}}">{{$vendor['vendorName']}}</option>
                          @endforeach
                        </select>
                      </div>
                    </label>
                    <label class="block">
                      <span>All Accredation Types:</span>
                      <div class="relative mt-1.5 flex">
                        
                        <select
                          name="accreditationTypeId"
                          class="mt-1.5 w-full"
                          x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
                          >
                          <option value>Select accredation type</option>
                          @foreach($accredation_types as $type)
                          <option value="{{$type['accreditationTypeId']}}">{{$type['name']}}</option>
                          @endforeach
                        </select>
                      </div>
                    </label>
                    <label class="block">
                      <span>All Access Area:</span>
                      <div class="relative mt-1.5 flex">
                        
                        <select
                          name="accessAreaId"
                          class="mt-1.5 w-full"
                          x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
                          >
                          <option value>Select access area</option>
                          @foreach($all_access_area as $area)
                          <option value="{{$area['accessAreaId']}}">{{$area['name']}}</option>
                          @endforeach
                        </select>
                      </div>
                    </label>
                    
                    @endif
                    <label class="block">
                      <span>All Designations:</span>
                      <div class="relative mt-1.5 flex">
                        
                        <select
                          name="designationMasterId"
                          class="mt-1.5 w-full"
                          x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
                          >
                          <option value>Select designation</option>
                          @foreach($all_designations as $designation)
                          <option value="{{$designation['designationMasterId']}}">{{$designation['designationName']}}</option>
                          @endforeach
                        </select>
                      </div>
                    </label>
                    <label class="block">
                      <span>All Data:</span>
                      <div class="relative mt-1.5 flex">
                      @php
                          $lastYear = now()->subYear()->year;
                          $startDate = \Carbon\Carbon::create($lastYear, 1, 1)->format('Y-m-d');
                          $endDate = \Carbon\Carbon::create($lastYear, 12, 31)->format('Y-m-d');
                      @endphp
                        <select
                          name="filterType"
                          class="mt-1.5 w-full"
                          x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
                          >
                          <option value="allData">All Data</option>
                          <option value="lastYearData">Last Year Data</option>
                          
                        </select>
                      </div>
                    </label>
                    
                    <label class="block">
                      <span>From:</span>
                      <div class="relative mt-1.5 flex">
                        <input
                          name="startDate"
                          x-init="$el._x_flatpickr = flatpickr($el)"
                          class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                          placeholder="Choose start date..."
                          type="text"
                        />
                        <span
                          class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
                        >
                          <svg
                            xmlns="http://www.w3.org/2000/svg"
                            class="size-5 transition-colors duration-200"
                            fill="none"
                            viewBox="0 0 24 24"
                            stroke="currentColor"
                            stroke-width="1.5"
                          >
                            <path
                              stroke-linecap="round"
                              stroke-linejoin="round"
                              d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"
                            />
                          </svg>
                        </span>
                      </div>
                    </label>
                    <label class="block">
                      <span>To:</span>
                      <div class="relative mt-1.5 flex">
                        <input
                          name="endDate"
                          x-init="$el._x_flatpickr = flatpickr($el)"
                          class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                          placeholder="Choose start date..."
                          type="text"
                        />
                        <div
                          class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
                        >
                          <svg
                            xmlns="http://www.w3.org/2000/svg"
                            class="size-5 transition-colors duration-200"
                            fill="none"
                            viewBox="0 0 24 24"
                            stroke="currentColor"
                            stroke-width="1.5"
                          >
                            <path
                              stroke-linecap="round"
                              stroke-linejoin="round"
                              d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"
                            />
                          </svg>
                        </div>
                      </div>
                    </label>
                    
                    <div class="sm:col-span-2">
                      <span>Project Status:</span>
                      <div
                        class="mt-2 grid grid-cols-1 gap-4 sm:grid-cols-4 sm:gap-5 lg:gap-6"
                        >
                        <label class="inline-flex items-center space-x-2">
                          <input name="projectStatus[]" value="SUBMITTED"
                          class="form-checkbox is-basic size-5 rounded-sm border-slate-400/70 checked:!border-success checked:bg-success hover:!border-success focus:!border-success dark:border-navy-400"
                          type="checkbox"
                          />
                          <span>SUBMITTED</span>
                        </label>
                        <label class="inline-flex items-center space-x-2">
                          <input name="projectStatus[]" value="APPROVED"
                          class="form-checkbox is-basic size-5 rounded-sm border-slate-400/70 checked:!border-success checked:bg-success hover:!border-success focus:!border-success dark:border-navy-400"
                          type="checkbox"
                          />
                          <span>APPROVED</span>
                        </label>
                        <label class="inline-flex items-center space-x-2">
                          <input
                            name="projectStatus[]" value="INCORRECT"
                            class="form-checkbox is-basic size-5 rounded-sm border-slate-400/70 checked:!border-success checked:bg-success hover:!border-success focus:!border-success dark:border-navy-400"
                            type="checkbox"
                          />
                          <span>INCORRECT</span>
                        </label>
                        <label class="inline-flex items-center space-x-2">
                          <input name="projectStatus[]" value="REJECTED"                          
                          class="form-checkbox is-basic size-5 rounded-sm border-slate-400/70 checked:!border-success checked:bg-success hover:!border-success focus:!border-success dark:border-navy-400"
                          type="checkbox"
                          />
                          <span>REJECTED</span>
                        </label>
                        <label class="inline-flex items-center space-x-2">
                          <input
                            name="projectStatus[]" value="PRINTED"
                          class="form-checkbox is-basic size-5 rounded-sm border-slate-400/70 checked:!border-success checked:bg-success hover:!border-success focus:!border-success dark:border-navy-400"
                          type="checkbox"
                          />
                          <span>
                            PRINTED
                          </span>
                        </label>
                        <label class="inline-flex items-center space-x-2">
                          <input
                            name="projectStatus[]" value="REPRINTED"
                            class="form-checkbox is-basic size-5 rounded-sm border-slate-400/70 checked:!border-success checked:bg-success hover:!border-success focus:!border-success dark:border-navy-400"
                            type="checkbox"
                          />
                          <span>REPRINTED</span>
                        </label>
                        <label class="inline-flex items-center space-x-2">
                          <input
                            name="projectStatus[]" value="BLACKLISTED"
                          class="form-checkbox is-basic size-5 rounded-sm border-slate-400/70 checked:!border-success checked:bg-success hover:!border-success focus:!border-success dark:border-navy-400"
                          type="checkbox"
                          />
                          <span>BLACKLISTED</span>
                        </label>
                        <label class="inline-flex items-center space-x-2">
                          <input name="projectStatus[]" value="DELIVERED"
                          class="form-checkbox is-basic size-5 rounded-sm border-slate-400/70 checked:!border-success checked:bg-success hover:!border-success focus:!border-success dark:border-navy-400"
                          type="checkbox"
                          />
                          <span>DELIVERED</span>
                        </label>
                      </div>
                    </div>
                  </div>
                  <div class="mt-4 space-x-1 text-right">
                    <button
                      @click="isFilterExpanded = ! isFilterExpanded"
                      class="btn font-medium text-slate-700 hover:bg-slate-300/20 active:bg-slate-300/25 dark:text-navy-100 dark:hover:bg-navy-300/20 dark:active:bg-navy-300/25"
                    >
                      Cancel
                    </button>

                    <button
                      type = "submit"
                      @click="isFilterExpanded = ! isFilterExpanded; loadPage(1)"
                      class="btn bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
                    >
                      Apply
                    </button>
                  </div>
                </div>
              
            </div>
          
            <div class="card mt-3">
              <div class="min-w-full overflow-x-auto">
                <table class="is-hoverable w-full text-left">
                  <thead>
                    <tr>
                      <th id="checkbox-header"
                        class="whitespace-nowrap rounded-tl-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                      <input type="checkbox" id="select-all-checkbox" />

                      </th>
                      <th
                        class="whitespace-nowrap rounded-tl-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Photo
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Name
                      </th>
                      @if($userType != 'vendor')
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Company
                      </th>
                      @endif
                      <th id="accredation"
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Accreditation Type
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Designation
                      </th>
                      <th
                        class="whitespace-nowrap rounded-tr-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Access Requested
                      </th>
                      <th
                        class="whitespace-nowrap rounded-tr-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Verification Status
                      </th>
                      <!-- <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Status
                      </th> -->
                      <th
                      class="whitespace-nowrap rounded-tr-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Actions
                      </th>
                    </tr>
                  </thead>
                  <tbody id="staff-list">

                    
                  </tbody>
                </table>
              </div>

              <div
                class="flex flex-col justify-between space-y-4 px-4 py-4 sm:flex-row sm:items-center sm:space-y-0 sm:px-5"
                >
                <div id="entry-range" class="text-xs-plus">1 - 10 of 10 entries</div>
                <!-- Page numbers -->
                <ol id="pagination" class="pagination">
                    <!-- JS will populate -->
                </ol>

                <!-- Info -->
                <div id="pagination-info" class="text-xs-plus">
                    <!-- JS will populate -->
                </div>
              </div>
            </div>
          </div>
        </div>
      </main>
<script>
  
  document.querySelector('.exportBtn').addEventListener('click', async function () {
    
    const params = new URLSearchParams();
    const ADMIN_BASE_URL = "{{ config('app.admin_base_url') }}";
    const VENDOR_BASE_URL = "{{ config('app.vendor_base_url') }}";
    const adminbaseUrl = `${ADMIN_BASE_URL}/api/staff/exportStaffCsv`;
    function addIfExists(key, selector) {
      const el = document.querySelector(selector);
      if (el && el.value && el.value.trim() !== '') {
        params.append(key, el.value.trim());
      }
    }

    addIfExists('staffName', 'input[name="staffName"]');
    addIfExists('designationMasterId', 'select[name="designationMasterId"]');
    addIfExists('filterType', 'select[name="filterType"]');
    addIfExists('startDate', 'input[name="startDate"]');
    addIfExists('endDate', 'input[name="endDate"]');

    // Append optional params only if needed
    params.append('accessAreaId', '');
    params.append('accreditationTypeId', '');
    params.append('vendorId', '');
    params.append('vendorTypeId', '');
    params.append('pageNo', '0');
    params.append('pageSize', '30');

    // Append multiple checkboxes
    const statusCheckboxes = document.querySelectorAll('input[name="projectStatus[]"]:checked');
    statusCheckboxes.forEach(cb => {
      params.append('verificationStatus', cb.value);
    });

    const finalUrl = `${baseUrl}?${params.toString()}`;

    try {
      const response = await fetch(finalUrl, {
        method: 'GET',
        headers: {
          'Accept': 'text/csv',
          // Add Authorization header if needed
          // 'Authorization': 'Bearer your_token_here'
        }
      });

      if (!response.ok) {
        throw new Error(`Error: ${response.status}`);
      }

      const blob = await response.blob();
      const downloadUrl = window.URL.createObjectURL(blob);
      const a = document.createElement('a');
      a.href = downloadUrl;
      a.download = 'staff_export.csv'; // desired filename
      document.body.appendChild(a);
      a.click();
      a.remove();
      window.URL.revokeObjectURL(downloadUrl);
    } catch (error) {
      console.error('Export failed:', error);
      alert('Export failed. Please try again.');
    }
  });
</script>

<script>
  

function printDiv(divId) {
    window.print();
}
</script>
<script>
  let currentPage = 1;
  let pageSize = 30;
  let totalEntries = 0;
  let verificationStatus = '';
  const ADMIN_BASE_URL = `{{ config('app.admin_base_url') }}`;
    const VENDOR_BASE_URL = "{{ config('app.vendor_base_url') }}";

    // alert(ADMIN_BASE_URL); // This will alert the correct value
  document.addEventListener('DOMContentLoaded', () => {
    loadPage(currentPage, verificationStatus); // Initial load

    // Badge buttons
    document.querySelectorAll('.badge').forEach(button => {
      button.addEventListener('click', (event) => {
        let status = event.target.innerText.trim();

        if (status.toLowerCase() === 'saved as draft'.toLowerCase()) status = 'DRAFT';
        if (status === 'RE-PRINTED') status = 'REPRINTED';
        if (status === 'ALL DATA') status = '';

        verificationStatus = status;
        currentPage = 1;
        loadPage(currentPage, verificationStatus);
      });
    });

    // Select all checkbox
    const selectAllCheckbox = document.getElementById('select-all-checkbox');
    if (selectAllCheckbox) {
      selectAllCheckbox.addEventListener('change', (e) => {
        const checked = e.target.checked;
        document.querySelectorAll('.row-checkbox').forEach(cb => cb.checked = checked);
      });
    }
    
  });

  function loadPage(page, status) {
   
    const staffName = document.querySelector('[name="staffName"]')?.value.trim() || '';
    const vendorId = document.querySelector('[name="vendorId"]')?.value || '';
    const startDate = document.querySelector('[name="startDate"]')?.value || '';
    const endDate = document.querySelector('[name="endDate"]')?.value || '';
    const accreditationTypeId = document.querySelector('[name="accreditationTypeId"]')?.value || '';
    const accessAreaId = document.querySelector('[name="accessAreaId"]')?.value || '';
    const designationMasterId = document.querySelector('[name="designationMasterId"]')?.value || '';
    const filterType = document.querySelector('[name="filterType"]')?.value || '';

    const projectStatusNodes = document.querySelectorAll('[name="projectStatus[]"]:checked');
    let projectStatus1 = Array.from(projectStatusNodes).map(cb => cb.value).join(',');
    
    const type = document.getElementById('type').value;

    let url = ''; // ✅ Declare outside
    const checkboxHeader = document.getElementById('checkbox-header');
    const accredation = document.getElementById('accredation');
    // if(status !== ''){
    //   projectStatus = status;
    // }
   var projectStatus;
    if(status != ''){
      // alert(status);
      projectStatus = status;
    }
    
    if(projectStatus == undefined){
      // alert(status);
      projectStatus = '';
    }

    if(projectStatus1 != ''){
      // alert(status);
      projectStatus = projectStatus1;
    }
    
    if (type === "vendor") {
      // checkboxHeader.style.display = 'none';
      accredation.style.display = 'none';
      url = `${VENDOR_BASE_URL}/api/staff/getAllStaffDetails?pageNo=${page - 1}&pageSize=${pageSize}` +
        `&nameOrId=${encodeURIComponent(staffName)}` +
        `&startDate=${encodeURIComponent(startDate)}` +
        `&endDate=${encodeURIComponent(endDate)}` +
        `&designationMasterId=${encodeURIComponent(designationMasterId)}` +
        `&filterType=${encodeURIComponent(filterType)}` +
        `&verificationStatus=${encodeURIComponent(projectStatus)}`;
    } else {
      checkboxHeader.style.display = '';
      accredation.style.display = '';
      url = `${ADMIN_BASE_URL}/api/staff/getStaffDetailsSearch?pageNo=${page - 1}&pageSize=${pageSize}` +
        `&staffName=${encodeURIComponent(staffName)}` +
        `&vendorId=${encodeURIComponent(vendorId)}` +
        `&startDate=${encodeURIComponent(startDate)}` +
        `&endDate=${encodeURIComponent(endDate)}` +
        `&accreditationTypeId=${encodeURIComponent(accreditationTypeId)}` +
        `&accessAreaId=${encodeURIComponent(accessAreaId)}` +
        `&designationMasterId=${encodeURIComponent(designationMasterId)}` +
        `&filterType=${encodeURIComponent(filterType)}` +
        `&verificationStatus=${encodeURIComponent(projectStatus)}`;
    }
    const token = "{{ session('token') }}";
    localStorage.setItem('staff_list_url', url);
    const savedUrl = localStorage.getItem('staff_list_url');

    console.log(savedUrl);
    fetch(url, {
          method: 'GET',
          headers: {
              'Authorization': `Bearer ${token}`,
              'Accept': 'application/json'
          }
      })
      .then(res => res.json())
      .then(json => {
        if (json.status !== 0) throw new Error('API error');
        const resp = json.response;
        totalEntries = resp.totalElements;
        renderTable(resp.dataSet);
        renderPagination(resp.totalPages);
        updatePageInfo(resp.totalElements);
        updateEntryRange(); 
      })
      .catch(err => console.error(err));
  }


  function renderTable(rows) {
    const tbody = document.getElementById('staff-list');
    const type = document.getElementById('type').value;
    
    tbody.innerHTML = '';
    rows.forEach(item => {
      const fullName = `${item.firstName} ${item.middleName ?? ''} ${item.lastName}`.trim();
      const date = item.createdAt ? new Date(item.createdAt).toLocaleDateString('en-GB', { day: '2-digit', month: 'short' }) : 'N/A';
      let viewLink = '';

      if (type === "vendor") {
        let editLink = '';
  
        // Show edit button only if status is 'pending' or 'draft'
        if (item.verificationStatus === 'DRAFT' || item.verificationStatus === 'INCORRECT') {
          editLink = `
            <div class="bg-warning flex items-center justify-center rounded shadow shadow-warning/50 size-6">
              <a href="/staff/update/${item.staffId}">
                <svg xmlns="http://www.w3.org/2000/svg" class="size-4 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                    d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" />
                </svg>
              </a>
            </div>`;
        }
        viewLink = `
        ${editLink}
        
          <div class="bg-primary flex items-center justify-center rounded shadow shadow-primary/50 size-6">
            <a href="#" class="view-button" data-id="${item.staffId}">
              <svg xmlns="http://www.w3.org/2000/svg" class="size-4 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.477 0 8.268 2.943 9.542 7-1.274 4.057-5.065 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
              </svg>
            </a>
          </div>`;
      } 
      
      /*else {
        viewLink = `
          <div class="bg-primary flex items-center justify-center rounded shadow shadow-primary/50 size-6">
            <a href="/staff/view-staff/${item.staffId}">
              <svg xmlns="http://www.w3.org/2000/svg" class="size-4 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.477 0 8.268 2.943 9.542 7-1.274 4.057-5.065 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
              </svg>
            </a>
          </div>`;
      }*/
      
      
      
       if (type === "VENDOR_ADMIN") {
        let editLink = '';
  
        // Show edit button only if status is 'pending' or 'draft'
        if (item.verificationStatus === 'PENDING' || item.verificationStatus === 'DRAFT') {
          editLink = `
            <div class="bg-warning flex items-center justify-center rounded shadow shadow-warning/50 size-6">
              <a href="/staff/update/${item.staffId}">
                <svg xmlns="http://www.w3.org/2000/svg" class="size-4 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                    d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" />
                </svg>
              </a>
            </div>`;
        }
        viewLink = `
        ${editLink}
        
          <div class="bg-primary flex items-center justify-center rounded shadow shadow-primary/50 size-6">
            <a href="#" class="view-button" data-id="${item.staffId}">
              <svg xmlns="http://www.w3.org/2000/svg" class="size-4 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.477 0 8.268 2.943 9.542 7-1.274 4.057-5.065 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
              </svg>
            </a>
          </div>`;
       } 


      tbody.insertAdjacentHTML('beforeend', `
        <tr class="border-y border-transparent border-b-slate-200 dark:border-b-navy-500">
         <td class="whitespace-nowrap px-4 py-3"><input type="checkbox" class="row-checkbox" value="${item.staffId}" /></td>         
          <td>
            <div class="avatar flex" style="margin-left: 20px!important;">
              <img class="rounded-full" src="${item.profilePicture || 'https://via.placeholder.com/50'}" alt="avatar">
            </div>
          </td>
          <td class="whitespace-nowrap px-4 py-3">${fullName}</td>
          ${type !== "vendor" ? `
          <td class="whitespace-nowrap px-4 py-3">${item.vendorName|| 'N/A'}</td>
          ` : ''} 
          
          ${type !== "vendor" ? `
          <td class="whitespace-nowrap px-4 py-3">${item.accreditationTypeName|| 'N/A'}</td>
          ` : ''} 
          <td class="whitespace-nowrap px-4 py-3">${item.designationDetails || 'N/A'}</td>
          
          <td class="whitespace-nowrap px-4 py-3">
            <div class="dynamic-box">${item.accessAreas || 'N/A'}</div>
          </td>


          <td class="whitespace-nowrap px-4 py-3 sm:px-5">
            <div class="flex space-x-2">
              <div class="${getStatusBadgeClass(item.verificationStatus)}" title="${item.currentVerificationStatus || 'No additional info'}">
                ${item.verificationStatus || 'N/A'}
              </div>   
            </div>
          </td>        
          
          <td class="whitespace-nowrap px-4 py-3 sm:px-5">
            <div class="flex gap-3 p-4 sm:p-5">
              
              ${viewLink}
            </div>
          </td>
        </tr>
      `);

    });
  }

  function getStatusBadgeClass(status) {
    switch ((status || '').toUpperCase()) {
      case 'DRAFT':
        return 'badge rounded-full border border-primary text-primary';
      case 'PENDING':
        return 'badge rounded-full border border-secondary text-secondary';
      case 'APPROVED':
        return 'badge rounded-full border border-success text-success';
      case 'REJECTED':
        return 'badge rounded-full border border-error text-error';
      case 'SUBMITTED':
        return 'badge rounded-full border border-blue-500 text-blue-500';
      case 'INCORRECT':
        return 'badge rounded-full border border-warning text-warning';
      case 'PRINTED':
        return 'badge rounded-full border border-info text-info';
      case 'REPRINTED':
        return 'badge rounded-full border border-slate-400 text-slate-500';
      case 'BLACKLISTED':
        return 'badge rounded-full border border-red-500 text-red-500';
      case 'DELIVERED':
        return 'badge rounded-full border border-green-600 text-green-600';
      case 'VERIFIED':
        return 'badge rounded-full border border-teal-500 text-teal-500';
      default:
        return 'badge rounded-full border border-slate-400 text-slate-600'; // fallback
    }
  }


  function renderPagination(totalPages) {
    const ol = document.getElementById('pagination');
    ol.innerHTML = '';

    // Show Previous button
    ol.insertAdjacentHTML('beforeend', `
      <li>
        <a href="#" 
          onclick="if(currentPage > 1) { currentPage--; loadPage(currentPage, verificationStatus); } return false;"
          class="flex size-8 items-center justify-center rounded-full bg-slate-150 text-slate-500 hover:bg-slate-300">
          <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
          </svg>
        </a>
      </li>
    `);

    // Calculate page range to show
    let startPage = Math.max(1, currentPage - 2);
    let endPage = Math.min(totalPages, currentPage + 2);

    // Adjust if near beginning
    if (currentPage <= 3) {
      endPage = Math.min(5, totalPages);
    }

    // Adjust if near end
    if (currentPage >= totalPages - 2) {
      startPage = Math.max(1, totalPages - 4);
    }

    // Show page numbers within range
    for (let i = startPage; i <= endPage; i++) {
      ol.insertAdjacentHTML('beforeend', `
        <li>
          <a href="#" 
            onclick="currentPage = ${i}; loadPage(currentPage, verificationStatus); return false;"
            class="flex h-8 w-8 items-center justify-center rounded-full ${currentPage === i ? 'bg-primary text-white' : 'bg-slate-150 text-slate-500 hover:bg-slate-300'}">
            ${i}
          </a>
        </li>
      `);
    }

    // Show Next button
    ol.insertAdjacentHTML('beforeend', `
      <li>
        <a href="#" 
          onclick="if(currentPage < totalPages) { currentPage++; loadPage(currentPage, verificationStatus); } return false;"
          class="flex size-8 items-center justify-center rounded-full bg-slate-150 text-slate-500 hover:bg-slate-300">
          <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
          </svg>
        </a>
      </li>
    `);
  }


  function updatePageInfo(total) {
    const info = document.getElementById('pagination-info');
    const start = (currentPage - 1) * pageSize + 1;
    const end = Math.min(currentPage * pageSize, total);
    info.innerText = `${start} - ${end} of ${total} entries`;
  }

  function updateStatus(isChecked, accreditationTypeId) {
    fetch(`${ADMIN_BASE_URL}/api/master/changeStatusAccreditationType?accreditationTypeId=${accreditationTypeId}`, {
      method: 'PUT',
      headers: {
        'Content-Type': 'application/json'
      }
    })
    .then(res => {
      if (!res.ok) throw new Error('Failed');
      return res.json();
    })
    .then(() => {
      alert('Status updated successfully');
      loadPage(currentPage, verificationStatus);
    })
    .catch(err => {
      console.error('Error updating status:', err);
      alert('Failed to update status');
    });
  }

  function getCheckedStaffIds() {
    return Array.from(document.querySelectorAll('.row-checkbox:checked')).map(cb => parseInt(cb.value));
  }

  document.addEventListener('click', function (e) {
    if (e.target.closest('.view-button')) {
      e.preventDefault();

      const btn = e.target.closest('.view-button');
      const staffId = parseInt(btn.getAttribute('data-id'));
      const allCheckedIds = getCheckedStaffIds().filter(id => id !== staffId);
      const type = document.getElementById('type').value;
      let url = ''; // Declare it outside
      console.log(type);
      if(type == 'vendor'){
        url = `/staff/view/${staffId}`;
      }else{
        url = `/staff/view-staff/${staffId}`;
      }

      
      
      // If other checkboxes are selected, include them in query string
      if (allCheckedIds.length > 0) {
        url += `?ids=${allCheckedIds.join(',')}`;
      }

      window.location.href = url;
    }
  });

  function submitBulkStatus(typeId, status) {
    const selectedIds = getCheckedStaffIds();
    if (selectedIds.length === 0) {
      alert('Please select at least one staff member.');
      return;
    }
    description = 'Bulk Approved';
    if(status != 'APPROVED'){
      description = typeId;    
      typeId = 0;
    } 
    console.log(status);
    const payload = {
      accreditationTypeId: typeId,
      description: description,
      staffIds: selectedIds,
      verificationStatus: status
    };
    console.log(payload);
    fetch(`${ADMIN_BASE_URL}/api/staff/updateStaffVerificationStatus`, {
      method: "PUT",
      headers: {
        "Content-Type": "application/json"
      },
      body: JSON.stringify(payload)
    })
    .then(res => res.json())
    .then(() => {
      alert("Status updated successfully");
      loadPage(currentPage, verificationStatus);
      window.location.reload();
    })
    .catch(err => {
      console.error(err);
      alert("Error during bulk update");
    });
  }

  // function updateEntryRange() {
  //   const start = (currentPage - 1) * pageSize + 1;
  //   const end = Math.min(currentPage * pageSize, totalEntries);
  //   const rangeText = totalEntries > 0
  //     ? `${start} - ${end} of ${totalEntries} entries`
  //     : `0 entries`;

  //   document.getElementById('entry-range').textContent = rangeText;
  // }
  function updateEntryRange() {
    const start = (currentPage - 1) * pageSize + 1;
    let end = currentPage * pageSize;
    if (end > totalEntries) end = totalEntries;
    document.getElementById('entry-range').innerText = `${start} - ${end} of ${totalEntries} entries`;
  }

</script>

<script>
function getCheckedAccessAreaIds() {
    const checkboxes = document.querySelectorAll('#access_area input[name="accessAreaId[]"]:checked');
    return Array.from(checkboxes).map(cb => parseInt(cb.value));
}

function getCheckedStaffIds() {
  return Array.from(document.querySelectorAll('.row-checkbox:checked')).map(cb => parseInt(cb.value));
}

function submitAccessAreas() {
    const staffIdIdList = getCheckedStaffIds();
    const accessAreaIdList = getCheckedAccessAreaIds();

    if (staffIdIdList.length === 0 || accessAreaIdList.length === 0) {
        alert('Please select at least one staff and one access area.');
        return;
    }

    const payload = {
        accessAreaIdList,
        staffIdIdList
    };

    fetch(`${ADMIN_BASE_URL}/api/staff/updateStaffAccessAreas`, {
        method: "PUT",
        headers: {
            "Content-Type": "application/json"
        },
        body: JSON.stringify(payload)
    })
    .then(res => res.json())
    .then(response => {
      console.log(response.response);
        alert(response.response);
        window.location.reload();
    })
    .catch(error => {
        console.error(error);
        alert("Error updating access areas.");
    });
}

document.getElementById("remove").addEventListener("click", function () {
    const staffIdIdList = getCheckedStaffIds();
   

    if (staffIdIdList.length === 0) {
        alert('Please select at least one staff.');
        return;
    }

    const payload = {
        staffIdIdList
    };
    // alert(staffIdIdList);
    fetch(`${ADMIN_BASE_URL}/api/staff/removeProfileBackground?isTransparentProfilePicture=true&staffId=${staffIdIdList}`, {
        method: "post",
        headers: {
            "Content-Type": "application/json"
        },
        body: JSON.stringify(payload)
    })
    .then(res => res.json())
    .then(response => {
        console.log(response.response);
        alert("Updated Successfully!");
        window.location.reload();
    })
    .catch(error => {
        console.error(error);
        alert("Error updating bg");
  });
});

document.getElementById("restore").addEventListener("click", function () {
    const staffIdIdList = getCheckedStaffIds();
   

    if (staffIdIdList.length === 0) {
        alert('Please select at least one staff.');
        return;
    }

    const payload = {
        staffIdIdList
    };
    // alert(staffIdIdList);
    fetch(`${ADMIN_BASE_URL}/api/staff/removeProfileBackground?isTransparentProfilePicture=false&staffId=${staffIdIdList}`, {
        method: "post",
        headers: {
            "Content-Type": "application/json"
        },
        body: JSON.stringify(payload)
    })
    .then(res => res.json())
    .then(response => {
      console.log(response.response);
        alert("Updated Successfully!");
        window.location.reload();
    })
    .catch(error => {
        console.error(error);
        alert("Error updating bg");
  });
});
</script>

@endsection
