<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Profile & Document Viewer</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <link href='https://fonts.googleapis.com/css?family=Inter' rel='stylesheet'>
  <style>
    body {
      font-family: 'Inter';
    }
    .image-container {
      position: relative;
      background: #545454;
      text-align: center;
      padding: 1rem;
      overflow: hidden;
      height: 260px;
    }

    .zoom-percentage {
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      background: rgba(0, 0, 0, 0.5);
      color: white;
      font-weight: normal;
      padding: 0.5rem 1rem;
      border-radius: 8px;
      font-size: 1rem;
      opacity: 0;
      transition: opacity 0.3s ease;
      pointer-events: none;
    }

    .image-container:hover .zoom-percentage {
      opacity: 1;
    }

    .doc-image {
      max-height: 70%;
      max-width: 100%;
      transition: transform 0.3s ease;
      transform-origin: center center;
      display: inline-block;
    }

    .image-controls {
      margin-top: 1rem;
      flex-wrap: wrap;
    }

    .zoom-icon-top {
      position: absolute;
      top: -8px;
      right: -6px;
      background: rgb(199 199 199 / 90%);
      border-radius: 50%;
      padding: 11px;
      cursor: pointer;
    }

    .doc-box {
      border: 1px solid #ccc;
      border-radius: 6px;
      padding: 1rem;
    }

    .h-100-container {
      height: 100%;
      display: flex;
      flex-direction: column;
    }

    .nav-pills .nav-link.active, .nav-pills .show>.nav-link {
      color: #ffffff !important;
      background-color: #959698 !important;
    }

    @media (max-width: 576px) {
      .image-container {
        height: auto;
        padding: 0.5rem;
      }

      .doc-image {
        max-height: 200px;
        width: 100%;
      }

      .zoom-icon-top {
        top: 4px;
        right: 4px;
        padding: 8px;
      }

      .zoom-percentage {
        font-size: 0.875rem;
        padding: 0.25rem 0.5rem;
      }

      .doc-box {
        padding: 0.75rem;
      }

      ul.list-unstyled li {
        font-size: 0.875rem;
      }

      h6, .fw-bold {
        font-size: 1rem;
      }
    }
  </style>
</head>
<body>
    <div class="p-2 bg-light shadow-sm rounded">
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-2">
          
          <!-- Back Button -->
          <!-- <div>
          <a href="{{ route('staff.list') }}">
            <button class="btn btn-light d-flex align-items-center">
              <i class="bi bi-arrow-left me-1"></i> <span>Back</span>
            </button>
          </a>
          </div> -->
          
      
          <!-- Application Barcode and Cloned From Info -->
          <div class="flex-grow-1 w-100">
            <div class="d-flex flex-column flex-md-row justify-content-start align-items-start gap-3">
              @if($staff_details['barcode'])  
              <div>
                <div class="small text-muted">Barcode</div>
                <div class="fw-semibold text-wrap">{{$staff_details['barcode']}}</div>
              </div>
              @endif
              <!-- <div>
                <div class="small text-muted">Cloned From</div>
                <div class="fw-semibold text-wrap">India vs New Zealand 2nd Test - Pune (Printed)</div>
              </div> -->
            </div>
          </div>
      
          <!-- Prev/Next Buttons -->
          <div class="d-flex gap-2 flex-nowrap">
          <div class="flex justify-center space-x-2">
            <a href="{{ route('staff.list') }}">
            <button
              class="btn min-w-[7rem] bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
            >
              Previous
            </button>
            </a>
          </div>
          </div>
      
        </div>
      </div>
      
      
      
  <div class=" shadow p-2">
    @if($staff_details['applicationId'])  
    <span class="ps-2">Application ID: <strong>{{$staff_details['applicationId']}}</strong> </span>
    @endif
    <div class="row mt-3" style="min-height: 100vh;">
      
      <!-- Left Section -->
      <div class="col-md-6 h-100 d-flex flex-column">
        <div class="row flex-grow-1">
          
          <!-- Sidebar -->
          <div class="col-md-5">
            <div class="h-100">
              <div class="text-center shadow p-1 w-100 h-100 border bgimg rounded">
                <div class="mb-3">
                  <img src="{{$staff_details['profilePicture']}}" class="img-fluid rounded shadow border" style="max-height: 140px;" alt="Profile Image">
                </div>
                <div class="fw-bold" style="font-size: 14px;">
                    <div>{{$staff_details['firstName']}} {{$staff_details['middleName']}} {{$staff_details['lastName']}}</div>
                    <div>{{$staff_details['accreditationTypeName']}}</div>
                    <div>{{$staff_details['city']}}</div>
                    <!-- <div>ALL ACCESS</div> -->
                </div>
                          <!-- Grid Boxes -->
                          @php
                      // Get access areas from staff details
                      $accessAreas = $staff_details['vendorAccessAreaList'] ?? [];

                      // Filter only selected access areas
                      $selectedAreas = collect($accessAreas)
                          ->filter(fn($area) => $area['isSelectedByStaff'])
                          ->values();

                      // Extract access area codes
                      $codes = $selectedAreas->pluck('accessAreaCode')->toArray();

                      // Fill 6 positions with blank initially
                      $finalBoxes = array_fill(0, 6, '');

                      // Populate the boxes with numeric codes
                      foreach ($codes as $code) {
                          if (is_numeric($code)) {
                              $position = (int)$code - 1;
                              if ($position >= 0 && $position < 6) {
                                  $finalBoxes[$position] = $code;
                              }
                          }
                      }

                      // If '#' is in codes, place it at the last position
                      if (in_array('#', $codes)) {
                          $finalBoxes[5] = '#';
                      }
                  @endphp
                <div class="container mt-5">
                    @for ($row = 0; $row < 2; $row++)
                        <div class="row justify-content-center g-2 mt-2" style="gap: 6px !important;">
                            @for ($col = 0; $col < 3; $col++)
                                @php
                                    $index = $row * 3 + $col;
                                @endphp
                                <div class="col-2 border border-2 rounded border-black d-flex align-items-center justify-content-center" 
                                    style="height: 40px; width: 40px;">
                                    {{ $finalBoxes[$index] }}
                                </div>
                            @endfor
                        </div>
                    @endfor
                </div>

                <!-- <div class="mt-3 fw-bold">
                    <button class="btn btn-outline-primary "><i class="bi bi-printer"></i> Print Card</button>
                </div> -->
              </div>
            </div>
          </div>

          <!-- Details -->
          <div class="col-md-7 d-flex flex-column">
            <div class="container shadow rounded p-4 flex-grow-1" style="font-size: 12.6px;">
              <h6 class="fw-bold">Personal Details :</h6>
              <ul class="list-unstyled">
                    <li class="d-flex mb-2"><div class="col-4">Father's Name:</div><div class="col">{{$staff_details['fatherName']}}</div></li>
                    <li class="d-flex mb-2"><div class="col-4">Gender:</div><div class="col">{{$staff_details['gender']}}</div></li>
                    <li class="d-flex mb-2"><div class="col-4">Date of Birth:</div><div class="col">{{$staff_details['dob']}}</div></li>
                    <li class="d-flex mb-2"><div class="col-4">Address:</div><div class="col">{{$staff_details['addressLine1']}}</div></li>
                    <li class="d-flex mb-2"><div class="col-4">Address Line 2:</div><div class="col">{{$staff_details['addressLine2']}}</div></li>
                    <li class="d-flex mb-2"><div class="col-4">Country:</div><div class="col">{{$staff_details['country']}}</div></li>
                    <li class="d-flex mb-2"><div class="col-4">State:</div><div class="col">{{$staff_details['state']}}</div></li>
                    <li class="d-flex mb-2"><div class="col-4">City:</div><div class="col">{{$staff_details['city']}}</div></li>
                    <li class="d-flex mb-2"><div class="col-4">Pincode:</div><div class="col">{{$staff_details['postalCode']}}</div></li>
                </ul>

              <h6 class="fw-bold">Accreditation Details :</h6>
              <ul class="list-unstyled">
                <li class="d-flex mb-2"><div class="col-4">Designation:</div><div class="col">{{$staff_details['designationDetails']}}</div></li>
                <li class="d-flex mb-2">
                  <div class="col-4">Only Concourse Access:</div>
                  <div class="col">{{ $staff_details['onlyConcourseAccess'] ? 'Yes' : 'No' }}</div>
                </li>
                @if($staff_details['onlyConcourseAccess'] == false)
                <li class="d-flex mb-2">
                  <div class="col-4">Access Areas:</div>
                  <div class="col">{{$staff_details['accessAreas'] }}</div>
                </li>
                @endif
              </ul>
            </div>
          </div>

        </div>
      </div>

      <!-- Right Section -->
      <div class="col-md-6 h-100 d-flex flex-column">
        <div class="container flex-grow-1 d-flex flex-column">
          <div class="doc-box flex-grow-1 d-flex flex-column">
            <!-- Tabs -->
            <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
              <li class="nav-item" role="presentation">
                <button class="nav-link active text-dark" id="front-tab" data-bs-toggle="pill" data-bs-target="#front" type="button" role="tab">ID Proof Front</button>
              </li>
              <li class="nav-item" role="presentation">
                <button class="nav-link text-dark" id="back-tab" data-bs-toggle="pill" data-bs-target="#back" type="button" role="tab">ID Proof Back</button>
              </li>
            </ul>

            <!-- Tab Content -->
            <div class="tab-content flex-grow-1" id="pills-tabContent">
              <div class="tab-pane fade show active h-100" id="front" role="tabpanel">
                <div class="image-container">
                  <img src="{{$staff_details['idProofFront']}}" alt="Uploaded Document" class="doc-image">
                  <i class="bi bi-arrows-fullscreen zoom-icon-top" onclick="openFullscreen()"></i>
                  <div class="zoom-percentage" id="zoomPercentage">100%</div>

                </div>
                <div class="image-controls justify-content-center d-flex">
                  <button class="btn  me-2" onclick="zoom(1.1)"><i class="bi bi-zoom-in"></i></button>
                  <button class="btn  me-2" onclick="zoom(0.9)"><i class="bi bi-zoom-out"></i></button>
                  <button class="btn  me-2" onclick="rotate(-90)"><i class="bi bi-arrow-counterclockwise"></i></button>
                  <button class="btn " onclick="rotate(90)"><i class="bi bi-arrow-clockwise"></i></button>
                </div>
                <div class="mt-3">
                    <h6 class="fw-bold">Id Proof Back Details</h6>
                    <p>Id Type: {{$staff_details['idType']}}</p>
                        <p>Id Number: {{$staff_details['idNumber']}}</p>
                  </div>
              </div>

              <div class="tab-pane fade h-100" id="back" role="tabpanel">
                <div class="image-container">
                  <img src="{{$staff_details['idProofBack']}}" alt="Uploaded Document" class="doc-image">
                  <i class="bi bi-arrows-fullscreen zoom-icon-top" onclick="openFullscreen()"></i>
                  <div class="zoom-percentage" id="zoomPercentage">100%</div>

                </div>
                <div class="image-controls justify-content-center d-flex">
                  <button class="btn  me-2" onclick="zoom(1.1)"><i class="bi bi-zoom-in"></i></button>
                  <button class="btn  me-2" onclick="zoom(0.9)"><i class="bi bi-zoom-out"></i></button>
                  <button class="btn  me-2" onclick="rotate(-90)"><i class="bi bi-arrow-counterclockwise"></i></button>
                  <button class="btn " onclick="rotate(90)"><i class="bi bi-arrow-clockwise"></i></button>
                </div>
                <div class="mt-3">
                  <h6 class="fw-bold">Id Proof Back Details</h6>
                  <p>Id Type: {{$staff_details['idType']}}</p>
                        <p>Id Number: {{$staff_details['idNumber']}}</p>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- Fullscreen Modal -->
        <div class="modal fade" id="fullscreenModal" tabindex="-1" aria-hidden="true">
          <div class="modal-dialog modal-fullscreen">
            <div class="modal-content bg-dark text-white">
              <div class="modal-header border-0">
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
              </div>
              <div class="modal-body d-flex justify-content-center align-items-center">
                <img src="./image/sample-pan-card.jpg" id="fullscreenImg" class="img-fluid" alt="Fullscreen">
              </div>
            </div>
          </div>
        </div>
      </div>

    </div>
  </div>

  <script>
    let scale = 1;
    let rotation = 0;

    const zoomStep = 0.1;
    const minZoom = 0.5;
    const maxZoom = 3;

    function applyTransform() {
      const img = document.querySelector('.tab-pane.active img.doc-image');
      const zoomText = document.querySelector('.tab-pane.active .zoom-percentage');
      if (img && zoomText) {
        img.style.transform = `scale(${scale}) rotate(${rotation}deg)`;
        zoomText.textContent = `${Math.round(scale * 100)}%`;

        zoomText.style.opacity = 1;
        clearTimeout(zoomText._fadeTimeout);
        zoomText._fadeTimeout = setTimeout(() => {
          zoomText.style.opacity = 0;
        }, 1000);
      }
    }

    function zoom(factor) {
      scale *= factor;
      scale = Math.max(minZoom, Math.min(maxZoom, scale));
      applyTransform();
    }

    function rotate(deg) {
      rotation += deg;
      applyTransform();
    }

    function openFullscreen() {
      const modal = new bootstrap.Modal(document.getElementById('fullscreenModal'));
      const currentImg = document.querySelector('.tab-pane.active img.doc-image');
      const fullscreenImg = document.getElementById('fullscreenImg');
      if (currentImg && fullscreenImg) {
        fullscreenImg.src = currentImg.src;
        modal.show();
      }
    }

    document.querySelectorAll('.image-container').forEach(container => {
      container.addEventListener('wheel', function(e) {
        e.preventDefault();
        zoom(e.deltaY < 0 ? 1 + zoomStep : 1 - zoomStep);
      }, { passive: false });
    });
  </script>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
