@extends('layouts.app')
@section('content')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<style>
  .donut-chart {
  max-width: 100%;
  height: auto;
}
.legend-item {
  display: flex;
  align-items: center;
  margin: 4px;
}
.legend-color {
  width: 12px;
  height: 12px;
  margin-right: 5px;
  display: inline-block;
}
.w-56 {
    width: calc(var(--spacing) * 64)!important;
}

#chart-container {
  margin: auto;
  position: relative;
}
.chart-label {
  position: absolute;
  top:44%;
  left: 50%;
  transform: translate(-50%, -50%);
  font-weight: bold;
  font-size: 1.2rem;
}
</style>

   <!-- Main Content Wrapper -->
      <main class="main-content px-[var(--margin-x)] pb-8">
      <div class="mt-5  transition-all duration-[.25s]">
          <p class="text-base font-medium text-slate-700 dark:text-navy-100" style="font-size: x-large;">
            Welcome {{$dashboard_data['vendorName']}},
           
          </p>
          <p class="text-base font-medium text-slate-700 dark:text-navy-100" >            
          {{$dashboard_data['usedCrewForm']}} out of {{$dashboard_data['totalCrewForm']}} crew forms have been submitted for {{$dashboard_data['event']['eventName']}}
          </p>
        </div>
        <div class="mt-4 grid grid-cols-12 gap-4 sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6">
            <div
                class="col-span-12 grid grid-cols-12 rounded-lg bg-gradient-to-r from-blue-500 to-indigo-600 py-5 sm:py-6"
                >
                <div class="col-span-12 sm:col-span-6 lg:col-span-8">
                <div class="px-4 text-white sm:px-5">
                    <div class="mt-3 " style=" margin-bottom: 14px;">
                    
                    <p class="text-2xl font-semibold">Event Info</p>
                    
                    </div>
                    <div class="-mt-1 flex items-center space-x-2">
                    <div class="mt-3">
                    <?php
                      $dateString = $dashboard_data['event']['startDate'];

                      // Create DateTime object in UTC
                      $date = new DateTime($dateString, new DateTimeZone("UTC"));

                      // Convert to IST (Asia/Kolkata)
                      $date->setTimezone(new DateTimeZone("Asia/Kolkata"));

                      // Format as "31 Jan, 2025 | 02:54 PM IST"
                      $formattedDate = $date->format("d M, Y | h:i A") . " IST";

                    ?>
                        <p class="text-base font-medium tracking-wide">Date of Event</p>
                        <p class="text-xs">{{$formattedDate}}</p>
                    </div>
                    
                    </div>
                    <div class="-mt-1 flex items-center space-x-2">
                    <div class="mt-3">
                        <p class="text-base font-medium tracking-wide">Venue</p>
                        <p class="text-xs">{{$dashboard_data['event']['venue']}}</p>
                    </div>
                    
                    </div>
                </div>
                </div>

                <div class="col-span-12 sm:col-span-6 lg:col-span-4" style="margin-top: 60px;">
                <div class="px-4 text-white sm:px-5">
                
                    <div class="-mt-1 flex items-center space-x-2">
                    <div class="mt-3">
                      <?php
                        $dateString = $dashboard_data['event']['endDate'];

                        // Create DateTime object in UTC
                        $date = new DateTime($dateString, new DateTimeZone("UTC"));

                        // Convert to IST (Asia/Kolkata)
                        $date->setTimezone(new DateTimeZone("Asia/Kolkata"));

                        // Format as "31 Jan, 2025 | 02:54 PM IST"
                        $formattedendDate = $date->format("d M, Y | h:i A") . " IST";

                      ?>
                        <p class="text-base font-medium tracking-wide">Event End Date</p>
                        <p class="text-xs">{{$formattedendDate}}</p>
                    </div>
                    </div>
                    <div class="mt-3 " >
                    
                    <p class="text-2xl font-semibold">Event is Live</p>
                    
                    </div>
                </div>
                </div>
            </div>
          
          <div
            class="col-span-12 grid grid-cols-2 gap-4 sm:grid-cols-4 sm:gap-5 lg:col-span-4 lg:grid-cols-2 lg:gap-6"
            >
            <div class=" col-span-2 px-4 pb-5 sm:px-5">
              <div class="flex items-center justify-between py-3">
                <h2
                  class="font-medium tracking-wide text-slate-700 dark:text-navy-100"
                >
                  Form Status
                </h2>
                
              </div>
              <div class="bg-white rounded-xl shadow p-4 w-full max-w-md mx-auto">
                <!-- <div class="flex flex-col items-center">
                  <svg id="donutChart" class="w-full max-h-[300px]" viewBox="0 0 250 250" preserveAspectRatio="xMidYMid meet"></svg>
                  <div id="chartLegend" class="flex flex-wrap justify-center gap-2 mt-4 text-sm text-gray-700"></div>
                </div> -->
                <div id="chart-container">
                  <canvas id="donutChart"></canvas>
                  <div class="chart-label" id="chartLabel">{{$dashboard_data['percentage']}}% Used</div>
                </div>
              </div>



            </div>
            
          </div>
          <div class="col-span-12 lg:col-span-8 grid grid-cols-1 sm:grid-cols-2 gap-6">

          <div class="card p-4 sm:p-5" style="height: fit-content;">
            <div class="avatar size-12">
              <div class="is-initial rounded-full bg-secondary text-white">
                <i class="fa-solid fa-users text-xl"></i>
              </div>
            </div>
            <h2
              class="mt-5 text-base font-medium tracking-wide text-slate-700 line-clamp-1 dark:text-navy-100"
            >
            Staff
            </h2>
            <p class="mt-1">
            Click on View Staff button to view the list of applications submitted. Click on Add Staff button to submit a new application.
            </p>
            <div class="mt-5 pb-1">
            <a href="{{ route('staff.list') }}" class="tag rounded-full border border-success/30 bg-success/10 text-success hover:bg-success/20 focus:bg-success/20 active:bg-success/25">
                View Staff
            </a>
            <a href="{{ route('staff.add') }}" class="tag rounded-full border border-info/30 bg-info/10 text-info hover:bg-info/20 focus:bg-info/20 active:bg-info/25">
                Add Staff
            </a>
            </div>
          </div>
          <div class="card p-4 sm:p-5" style="height: fit-content;">
            <div class="avatar size-12">
              <div class="is-initial rounded-full bg-primary text-white">
                <svg xmlns="http://www.w3.org/2000/svg" class="size-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                  <path stroke-linecap="round" stroke-linejoin="round" d="M3 15a4 4 0 004 4h9a5 5 0 10-.1-9.999 5.002 5.002 0 10-9.78 2.096A4.001 4.001 0 003 15z"></path>
                </svg>
              </div>
            </div>
            <h2
              class="mt-5 text-base font-medium tracking-wide text-slate-700 line-clamp-1 dark:text-navy-100"
            >
            Share form link
            </h2>
            <p class="mt-1">
              In case you wish to circulate the link to your staff so that they can input their own details, you may share the following link.
            </p>
            <div class="mt-5 pb-1">
           
                <a class="tag rounded-full border border-info/30 bg-info/10 text-info hover:bg-info/20 focus:bg-info/20 active:bg-info/25">
                <p >Copy link to clipboard</p>
                <p id="clipboardContent1" style="display: none;">
                    {{ url('/company/' . $dashboard_data['event']['eventName'] . '/' . $dashboard_data['vendorId']) }}
                </p>                <button
                class="btn h-6 shrink-0 rounded-sm bg-white/20 px-2 text-xs text-white active:bg-white/25"
                @click="$clipboard({
                  content: document.querySelector('#clipboardContent1').innerText,
                  success: () => $notification({ text: 'Link copied!', variant: 'success' }),
                  error: () => $notification({ text: 'Failed to copy.', variant: 'error' })
                })"
                >
                <svg class="ml-2 w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" style="color:black;"
                    viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                  <path stroke-linecap="round" stroke-linejoin="round"
                        d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2M8 16h8a2 2 0 002-2v-8a2 2 0 00-2-2H8a2 2 0 00-2 2v2m0 8v2a2 2 0 002 2h8a2 2 0 002-2v-2">
                  </path>
                </svg>
                </button>
                </a>

                <!-- <button
                type="button"
                class="inline-flex items-center px-4 py-2 bg-gray-800 text-sm font-semibold rounded-lg hover:bg-gray-700"
                @click="$clipboard({
                  content: document.querySelector('#clipboardContent1').innerText,
                  success: () => $notification({ text: 'Link copied!', variant: 'success' }),
                  error: () => $notification({ text: 'Failed to copy.', variant: 'error' })
                })"
              >
                Copy link to clipboard
                <svg class="ml-2 w-4 h-4" fill="none" stroke="currentColor" stroke-width="2"
                    viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                  <path stroke-linecap="round" stroke-linejoin="round"
                        d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2M8 16h8a2 2 0 002-2v-8a2 2 0 00-2-2H8a2 2 0 00-2 2v2m0 8v2a2 2 0 002 2h8a2 2 0 002-2v-2">
                  </path>
                </svg>
              </button> -->

            </div>

            
          </div>
       
          <div class="card p-4 sm:p-5 lg:col-span-10 lg:col-span-2" style="height: fit-content; margin-top: -15px;">
           
              
            <h2
              class=" text-base font-medium tracking-wide text-slate-700 line-clamp-1 dark:text-navy-100"
            >
                Application process
            </h2>
            
            <div class="mt-5 pb-1">
            <ol class="timeline line-space max-w-sm [--size:1.5rem]">
                <li class="timeline-item">
                <div
                    class="timeline-item-point rounded-full border border-current bg-white text-secondary dark:bg-navy-700 dark:text-secondary-light"
                >
                    <i class="fa fa-user-edit text-tiny"></i>
                </div>
                <div class="timeline-item-content flex-1 pl-4 sm:pl-8">
                    <div class="flex flex-col justify-between pb-2 sm:flex-row sm:pb-0">
                    <p
                        class="pb-2 font-medium leading-none text-slate-600 dark:text-navy-100 sm:pb-0"
                    >
                    Step 01
                    </p>
                    
                    </div>
                    <p class="py-1">Fill application form</p>
                    
                </div>
                </li>
                
                <li class="timeline-item">
                <div
                    class="timeline-item-point rounded-full border border-current bg-white text-success dark:bg-navy-700"
                >
                    <i class="fa fa-leaf text-tiny"></i>
                </div>
                <div class="timeline-item-content flex-1 pl-4 sm:pl-8">
                    <div class="flex flex-col justify-between pb-2 sm:flex-row sm:pb-0">
                    <p
                        class="pb-2 font-medium leading-none text-slate-600 dark:text-navy-100 sm:pb-0"
                    >
                    Step 02
                    </p>
                   
                    </div>
                    <p class="py-1">
                    Submit form with documents
                    </p>
                    
                    
                </div>
                </li>
                <li class="timeline-item">
                <div
                    class="timeline-item-point rounded-full border border-current bg-white text-warning dark:bg-navy-700"
                >
                    <i class="fa fa-project-diagram text-tiny"></i>
                </div>
                <div class="timeline-item-content flex-1 pl-4 sm:pl-8">
                    <div class="flex flex-col justify-between pb-2 sm:flex-row sm:pb-0">
                    <p
                        class="pb-2 font-medium leading-none text-slate-600 dark:text-navy-100 sm:pb-0"
                    >
                    Step 03
                    </p>
                   
                    </div>
                    <p class="py-1">Await Approval</p>
                    <div>
                    
                    </div>
                </div>
                </li>
                <li class="timeline-item">
                <div
                    class="timeline-item-point rounded-full border border-current bg-white text-error dark:bg-navy-700"
                >
                    <i class="fa fa-history text-tiny"></i>
                </div>
                <div class="timeline-item-content flex-1 pl-4 sm:pl-8">
                    <div class="flex flex-col justify-between pb-2 sm:flex-row sm:pb-0">
                    <p
                        class="pb-2 font-medium leading-none text-slate-600 dark:text-navy-100 sm:pb-0"
                    >
                    Step 04
                    </p>
                    
                    </div>
                    <p class="py-1">Collect accreditation card from designated location</p>
                </div>
                </li>
            </ol>
            </div>
          </div>
        </div>



        </div>
        
      </main>
        
 
  
<script src="https://d3js.org/d3.v6.min.js"></script>


<!-- <script>
  const response = @json($dashboard_data);
  console.log(response);
  const stats = response; 

  const data = [
    { label: "Printed", value: stats.printed || 0, color: "#fbbc05" },         // yellow
    { label: "Approved", value: stats.approved || 0, color: "#6a1b9a" },       // purple
    { label: "Rejected", value: stats.rejected || 0, color: "#f8bbd0" },       // pink
    { label: "Reprinted", value: stats.reprinted || 0, color: "#34a853" },     // green
    { label: "Blacklisted", value: stats.blacklist || 0, color: "#ea4335" },   // red
    { label: "Incorrect Data", value: stats.incorrect || 0, color: "#e0e0e0" } // light gray
  ];

  const width = 250;
  const height = 250;
  const radius = Math.min(width, height) / 2;

  const svg = d3.select("#donutChart")
    .append("g")
    .attr("transform", `translate(${width / 2}, ${height / 2})`);

  const arc = d3.arc()
    .innerRadius(radius - 50)
    .outerRadius(radius - 5);

  const pie = d3.pie()
    .value(d => d.value)
    .sort(null);

  const g = svg.selectAll(".arc")
    .data(pie(data))
    .enter().append("g")
    .attr("class", "arc");

  g.append("path")
    .attr("d", arc)
    .style("fill", d => d.data.color);

  svg.append("text")
    .attr("text-anchor", "middle")
    .attr("dy", "-0.3em")
    .style("font-size", "16px")
    .text("89% Used");

  svg.append("text")
    .attr("text-anchor", "middle")
    .attr("dy", "1.2em")
    .style("font-size", "14px")
    .text("95.9%");

  // Add legend
  const legendContainer = d3.select("#chartLegend");
  data.forEach(d => {
    legendContainer.append("div")
      .attr("class", "flex items-center space-x-1")
      .html(`
        <span class="inline-block w-3 h-3 rounded-full" style="background-color: ${d.color};"></span>
        <span>${d.label}</span>
      `);
  });


</script> -->
<!-- <script>
  const response = @json($dashboard_data);
  console.log(response);
  const stats = response;

  // Data for donut
  const data = [
    { label: "Printed", value: stats.printed || 0, color: "#fbbc05" },
    { label: "Approved", value: stats.approved || 0, color: "#6a1b9a" },
    { label: "Rejected", value: stats.rejected || 0, color: "#f8bbd0" },
    { label: "Reprinted", value: stats.reprinted || 0, color: "#34a853" },
    { label: "Blacklisted", value: stats.blacklisted || 0, color: "#ea4335" },
    { label: "Incorrect Data", value: stats.incorrect || 0, color: "#e0e0e0" }
  ];

  // Size settings
  const width = 250;
  const height = 250;
  const radius = Math.min(width, height) / 2;

  // Create SVG group
  const svg = d3.select("#donutChart")
    .html("")  // Clear previous chart if rerendered
    .append("svg")
    .attr("width", width)
    .attr("height", height)
    .append("g")
    .attr("transform", `translate(${width / 2}, ${height / 2})`);

  // Pie and arc setup
  const arc = d3.arc()
    .innerRadius(radius - 50)
    .outerRadius(radius - 5);

  const pie = d3.pie()
    .value(d => d.value)
    .sort(null);

  // Draw chart
  const g = svg.selectAll(".arc")
    .data(pie(data))
    .enter().append("g")
    .attr("class", "arc");

  g.append("path")
    .attr("d", arc)
    .style("fill", d => d.data.color);

  // Calculate usage percent
  let usedPercent = 0;
  if (stats.formLimit > 0) {
    usedPercent = (stats.saved / stats.formLimit) * 100;
  }

  // Center Text
  svg.append("text")
    .attr("text-anchor", "middle")
    .attr("dy", "-0.3em")
    .style("font-size", "16px")
    .style("font-weight", "bold")
    .text(stats.formLimit > 0 ? `${stats.saved} of ${stats.formLimit} Used` : `${stats.saved} Saved`);

  svg.append("text")
    .attr("text-anchor", "middle")
    .attr("dy", "1.2em")
    .style("font-size", "14px")
    .text(stats.formLimit > 0 ? `${Math.round(usedPercent)}%` : '');

  // Draw legend
  const legendContainer = d3.select("#chartLegend").html(""); // Clear previous
  data.forEach(d => {
    legendContainer.append("div")
      .attr("class", "flex items-center space-x-2 text-sm mb-1")
      .html(`
        <span class="inline-block w-3 h-3 rounded-full" style="background-color: ${d.color};"></span>
        <span>${d.label}</span>
      `);
  });
</script> -->
<script>
    const response = @json($dashboard_data);
    console.log(response);
    const stats = response;
   
    const data = {
      labels: ['Printed', 'Approved', 'Rejected', 'Reprinted', 'Blacklisted', 'Incorrect Data'],
      datasets: [{
        data: [stats.printed, stats.approved, stats.rejected, stats.reprinted, stats.blacklisted, stats.incorrect],
        backgroundColor: ['#fbbc05', '#6a1b9a', '#f8bbd0', '#34a853', '#ea4335', '#e0e0e0'],
        hoverOffset: 10
      }]
    };

    const config = {
      type: 'doughnut',
      data: data,
      options: {
        cutout: '70%',
        plugins: {
          tooltip: {
            callbacks: {
              label: function(context) {
                const label = context.label || '';
                const value = context.raw || 0;
                return `${label}: ${value}%`;
              }
            }
          },
          legend: {
            position: 'bottom'
          }
        }
      }
    };

    const donutChart = new Chart(
      document.getElementById('donutChart'),
      config
    );
</script>
@endsection