<!doctype html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title>Accred Events</title>
    <link rel="icon" type="image/png" href="images/logo.png" />

    <!-- CSS Assets -->
    <link rel="stylesheet" href="<?php echo e(url('css/app.css')); ?>" />

    <!-- Javascript Assets -->
    <script src="<?php echo e(url('js/app.js')); ?>" defer></script>
      <!-- Javascript Assets -->
     
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <style>
      .bg-blue-600 {
          --tw-bg-opacity: 1;
          background-color: #2a0134!important;
      }

      .text-blue-600 {
          --tw-text-opacity: 1;
          color: #2a0134!important;
      }

      .border-blue-500 {
          --tw-border-opacity: 1;
          border-color: #2a0134!important;
      }
    </style>
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
    <script>
      


      // Function to show the OTP step and hide the username step
      function sendOtp() {
          // Hide username input (Step 1)
          document.getElementById('adminStep1').classList.add('hidden');
          // Show OTP input (Step 2)
          document.getElementById('adminStep2').classList.remove('hidden');
      }
  </script>
  </head>
  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->
    <div
      class="app-preloader fixed z-50 grid h-full w-full place-content-center bg-slate-50 dark:bg-navy-900"
    >
      <div class="app-preloader-inner relative inline-block size-48"></div>
    </div>

    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <div class="fixed top-0 hidden p-6 lg:block lg:px-12">
        <a href="#" class="flex items-center space-x-2">
        <img src="<?php echo e(url('images/logo2.png')); ?>" alt="logo" />
         
        </a>
      </div>
      <div class="hidden w-full place-items-center lg:grid">
        <div class="w-full max-w-lg p-6">
        <img
            class="w-full"
            x-show="!$store.global.isDarkModeEnabled"
            src="<?php echo e(url('images/illustrations/dashboard-check.svg')); ?>"
            alt="image"
          />
        </div>
      </div>
      <main
        class="flex w-full flex-col items-center bg-white dark:bg-navy-700 lg:max-w-md"
      >
        <div class="flex w-full max-w-sm grow flex-col justify-center p-5">
          <div class="text-center">
            <img
              class="mx-auto size-16 lg:hidden"
              src="images/app-logo.svg"
              alt="logo"
            />
            <div class="mt-4">
              <h2
                class="text-2xl font-semibold text-slate-600 dark:text-navy-100"
              >
              Welcome Back
              </h2>
              <p class="text-slate-400 dark:text-navy-300">
                Please sign in to continue
              </p>
            </div>
          </div>

        
          <div class="mt-4 space-y-4">
          <div class="mt-16">
              <!-- Tab Header -->
              <form method="POST" action="<?php echo e(route('verifyStaffOtp')); ?>">
              <input type="hidden" id="vendorId"  name="vendorId" value="<?php echo e($vendor_id); ?>">
              <input type="hidden" id="event_name"  name="event_name" value="<?php echo e($event_name); ?>">

              <?php echo csrf_field(); ?>
                <!-- Admin Login Step 1: Enter Username -->
                <div id="adminForm" >
                    <div id="adminStep1">
                        <h3 class="font-bold mb-4 pt-5 " style="color:black;">Enter Your Phone Number</h3>

                        <input
                        type="text"
                        id="staffphone"
                        name="phone"
                        placeholder="Enter Phone"
                        class="w-full mb-4 px-4 py-2 border rounded"
                        maxlength="10"
                        pattern="\d{10}"
                        inputmode="numeric"
                        oninput="this.value = this.value.replace(/[^0-9]/g, '')"
                      />
                        <button type="button" onclick="sendOtp()" class="w-full bg-blue-600 text-white py-2 rounded">Send OTP </button>
                    </div>

                    <!-- Admin Login Step 2: OTP Entry -->
                    <div id="adminStep2" class="hidden">
                    <h3 class="font-bold mb-4 pt-5 " style="color:black;">Enter OTP</h3>
                    <input type="text" name="otp" placeholder="OTP" class="w-full mb-4 px-4 py-2 border rounded">
                        <button class="w-full bg-green-600 text-white py-2 rounded">Submit</button>
                    </div>
                </div>
               
              </form>
              <?php if($errors->has('login_error')): ?>
                    <div class="alert alert-danger p-5" style="color:red;">
                        <?php echo e($errors->first('login_error')); ?>

                    </div>
                <?php endif; ?>
            </div>
          </div>
          <button
            class="btn mt-10 h-10 w-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
          >
            Sign In
          </button>
          <div
          class="my-5 flex justify-center text-xs text-slate-400 dark:text-navy-300"
        > 
          <a href="#">Privacy Notice</a>
          <div class="mx-3 my-1 w-px bg-slate-200 dark:bg-navy-500"></div>
          <a href="#">Term of service</a>
        </div>
        </div>
      </main>
    </div>

    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
    <script>
        function phone() {
            const phone = $('#staffphone').val();
            
            if (!phone) {
                alert("Please enter a phone.");
                return;
            }

            $('#adminStep1').addClass('hidden');
           
        }
        function sendOtp() {
          var phone = document.getElementById('staffphone').value;
          var vendorId = document.getElementById('vendorId').value;
          // alert(vendorId);
          fetch(`https://ac-api.omsdev.in:2003/api/staff/sendOtp?phone=${phone}&vendorId=${vendorId}`, {
              method: 'POST',
              headers: {
                  'Content-Type': 'application/json'
              }
          })
          .then(response => {
              if (!response.ok) throw new Error('Failed to send OTP');
              
              return response.json(); // Parse JSON response
          })
          .then(data => {
            if(data['status'] == -1){
              alert(data['response']);
            }else{
              alert("OTP sent successfully");
              console.log('OTP Response:', data);
              if (data && data.response) {
                  const otp = data.response;
                  // alert("OTP received: " + otp);

                  // Now show OTP input step
                  document.getElementById('adminStep1').classList.add('hidden');
                  document.getElementById('adminStep2').classList.remove('hidden');
              } else {
                  alert("No OTP received.");
              }
            }
            
           
              
          })
          .catch(error => {
              console.error('Error sending OTP:', error);
              alert('Failed to send OTP');
          });
      }

    </script>
    
  </body>
</html>
<?php /**PATH /var/www/event-console/eventManagement/resources/views/register_staff.blade.php ENDPATH**/ ?>