
<?php $__env->startSection('content'); ?>
    <!-- Main Content Wrapper -->
    <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <div class="flex items-center justify-between flex-wrap py-5 lg:py-6">
            <!-- Left side: Heading + Breadcrumbs -->
            <div class="flex items-center space-x-4">
                <h2 class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl">
                    All Vendor Types
                </h2>
                <div class="hidden h-full py-1 sm:flex">
                    <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
                </div>
                <ul class="hidden flex-wrap items-center space-x-2 sm:flex">
                    <li class="flex items-center space-x-2">
                        <a class="text-primary transition-colors hover:text-primary-focus dark:text-accent-light dark:hover:text-accent" href="#">
                            Vendor Types
                        </a>
                        <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                        </svg>
                    </li>
                    <li>List</li>
                </ul>
            </div>

            <!-- Right side: Add button -->
            <a href="<?php echo e(route('vendor_types.add')); ?>">
                <button class="btn px-3 py-1.5 text-sm space-x-2 bg-primary font-medium text-white shadow-md shadow-primary/40 hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:shadow-accent/40 dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 text-indigo-50" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                    </svg>
                    <span>Add</span>
                </button>
            </a>
        </div>

        <!-- Vendor Types Table -->
        <div class="card mt-3">
            <div class="is-scrollbar-hidden min-w-full overflow-x-auto">
                <table class="is-hoverable w-full text-left" id="vendor-table">
                    <thead>
                        <tr>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Date</th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Designation</th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Status</th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Action</th>
                        </tr>
                    </thead>
                    <tbody id="vendor-list">
                        <!-- rows injected by JS -->
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Pagination & Show Entries -->
        <div
            class="flex flex-col justify-between space-y-4 px-4 py-4 sm:flex-row sm:items-center sm:space-y-0 sm:px-5"
        >
            <!-- Show entries -->
            <div class="flex items-center space-x-2 text-xs-plus">
                <span>Show</span>
                <label class="block">
                    <select
                        id="entries-select"
                        class="form-select rounded-full border border-slate-300 bg-white px-2 py-1 pr-6 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent"
                    >
                        <option value="10">10</option>
                        <option value="30">30</option>
                        <option value="50">50</option>
                    </select>
                </label>
                <span>entries</span>
            </div>

            <!-- Page numbers -->
            <ol id="pagination" class="pagination">
                <!-- JS will populate -->
            </ol>

            <!-- Info -->
            <div id="pagination-info" class="text-xs-plus">
                <!-- JS will populate -->
            </div>
        </div>
    </main>

    <script>
        let currentPage = 1;
        let pageSize = 10;
        let totalEntries = 0;

        document.addEventListener('DOMContentLoaded', () => {
            loadPage(currentPage);
            document.getElementById('entries-select').addEventListener('change', (e) => {
                pageSize = parseInt(e.target.value, 10);
                currentPage = 1;
                loadPage(currentPage);
            });
        });

        function loadPage(page) {
            fetch(`https://ac-api.omsdev.in:2002/api/master/getAllVendorType?pageNo=${page - 1}&pageSize=${pageSize}`)
                .then(res => res.json())
                .then(json => {
                    if (json.status !== 0) throw new Error('API error');
                    const resp = json.response;
                    totalEntries = resp.totalElements;
                    renderTable(resp.dataSet);
                    renderPagination(resp.totalPages);
                    renderInfo(page);
                })
                .catch(err => console.error(err));
        }

        function renderTable(rows) {
            const tbody = document.getElementById('vendor-list');
            tbody.innerHTML = '';
            rows.forEach(item => {
                const d = new Date(item.updatedAt);
                const date = d.toLocaleDateString('en-GB',{day:'2-digit',month:'short',year:'numeric'});
                const time = d.toLocaleTimeString('en-GB',{hour:'2-digit',minute:'2-digit'});
                const status = item.isActive ? 'Active' : 'Inactive';

                tbody.insertAdjacentHTML('beforeend', `
                    <tr class="border-y border-transparent border-b-slate-200 dark:border-b-navy-500">
                      <td class="whitespace-nowrap px-2 py-2 sm:px-3 lg:px-5">
                        <p class="font-medium">${date}</p>
                        <p class="mt-0.5 text-xs">${time}</p>
                      </td>
                      <td class="whitespace-nowrap px-2 py-2 sm:px-3 lg:px-5">
                        <span class="font-medium text-slate-700 dark:text-navy-100">${item.name}</span>
                      </td>
                      <td class="whitespace-nowrap px-2 py-2 sm:px-3 lg:px-5">
                        <label class="inline-flex items-center space-x-2">
                            <input
                                class="form-switch h-5 w-10 rounded-full bg-slate-300 before:rounded-full before:bg-slate-50 checked:!bg-success checked:before:bg-white dark:bg-navy-900 dark:before:bg-navy-300 dark:checked:before:bg-white"
                                type="checkbox"
                                ${item.isActive ? 'checked' : ''}
                                onchange="updateStatus(this.checked, '${item.vendorTypeId}')"
                                />

                        </label>
                      </td>
                      <td class="whitespace-nowrap px-2 py-2 sm:px-3 lg:px-5">
                        <div class="flex space-x-2">
                          <a href="/vendor-types/update/${item.vendorTypeId}" class="btn size-8 p-0 text-info hover:bg-info/20">
                            <i class="fa fa-edit"></i>
                          </a>
                          <button onclick="confirmDelete(${item.vendorTypeId})" class="btn size-8 p-0 text-error hover:bg-error/20">
                            <i class="fa fa-trash-alt"></i>
                          </button>
                        </div>
                      </td>
                    </tr>
                `);
            });
        }

        function renderPagination(totalPages) {
            const ol = document.getElementById('pagination');
            ol.innerHTML = '';

            // Prev
            ol.insertAdjacentHTML('beforeend', `
              <li class="rounded-l-lg bg-slate-150 dark:bg-navy-500">
                <a href="#" class="flex size-8 items-center justify-center rounded-lg text-slate-500 transition-colors hover:bg-slate-300" ${currentPage===1?' tabindex="-1" aria-disabled="true"':''}
                   onclick="if(currentPage>1){ currentPage--; loadPage(currentPage);} return false;">
                  <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                  </svg>
                </a>
              </li>
            `);

            // Numbers
            for (let i = 1; i <= totalPages; i++) {
                ol.insertAdjacentHTML('beforeend', `
                  <li class="bg-slate-150 dark:bg-navy-500">
                    <a href="#" class="flex h-8 min-w-[2rem] items-center justify-center rounded-lg px-3 leading-tight transition-colors ${i===currentPage?' bg-primary text-white':''} hover:bg-slate-300"
                       onclick="currentPage=${i}; loadPage(${i}); return false;">
                      ${i}
                    </a>
                  </li>
                `);
            }

            // Next
            ol.insertAdjacentHTML('beforeend', `
              <li class="rounded-r-lg bg-slate-150 dark:bg-navy-500">
                <a href="#" class="flex size-8 items-center justify-center rounded-lg text-slate-500 transition-colors hover:bg-slate-300" ${currentPage===totalPages?' tabindex="-1" aria-disabled="true"':''}
                   onclick="if(currentPage<${totalPages}){ currentPage++; loadPage(currentPage);} return false;">
                  <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                  </svg>
                </a>
              </li>
            `);
        }

        function renderInfo(page) {
            const start = (page - 1) * pageSize + 1;
            const end = Math.min(page * pageSize, totalEntries);
            document.getElementById('pagination-info').textContent =
              `${start} - ${end} of ${totalEntries} entries`;
        }

        function confirmDelete(id) {
            if (confirm("Are you sure you want to delete this vendor type?")) {
                window.location.href = "<?php echo e(url('/vendor-types/delete')); ?>/" + id;
            }
        }
        function updateStatus(isChecked, vendorTypeId) {
            fetch(`https://ac-api.omsdev.in:2002/api/master/changeStatusVendorType?vendorTypeId=${vendorTypeId}`, {
                method: 'PUT',
                headers: {
                    'Content-Type': 'application/json'
                }
            })
            .then(response => {
                if (!response.ok) throw new Error('Failed');
                return response.json();
            })
            .then(data => {
                alert('Status updated successfully');
                // Reload the updated table data
                loadPage(currentPage);

            })
            .catch(error => {
                console.error('Error updating status:', error);
                alert('Failed to update status');
            });
        }
    </script>
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/event-console/eventManagement/resources/views/masters/vendor_types/list.blade.php ENDPATH**/ ?>