<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Config;

class LoginController extends Controller
{
    /**
     * Where to redirect users after login.
     *
     * @var string
     * 
     * 
     */

     public $adminbaseUrl;
     public $vendorbaseUrl;


    
    protected $redirectTo = '/vendor-dashboard';

    public function __construct()
    {
        $this->middleware('guest')->except('logout');
        $this->middleware('auth')->only('logout');
        $this->adminbaseUrl = config('app.admin_base_url');
        $this->vendorbaseUrl = config('app.vendor_base_url');
        
    }

    // Override default login to use static credentials
    // public function login(Request $request)
    // {
        
    //     $email = $request->input('email');
    //     $password = $request->input('password');
    //     // dd($email);
    //     // Static credentials
    //     // if ($email === 'admin@gmail.com' && $password === '12345678') {
    //         // Simulate a logged-in user
    //         session(['user_email' => $email]);
    //         return redirect($this->redirectTo);
    //     // }

    //     return back()->withErrors([
    //         'email' => 'Invalid static credentials.',
    //     ]);
    // }


    public function login(Request $request)
    {
            
           
            // session([ 'type' => 'vendor']); // save token if needed
            // $value = session('type');
            // dd($this->vendorbaseUrl . '/api/auth/Login');
            // return redirect('/vendor-dashboard'); 
            $data = [
                "password" => $request->password,
                "username" => $request->username,
            ];
           
            $curl = curl_init();
    
            curl_setopt_array($curl, array(
            CURLOPT_URL => $this->vendorbaseUrl . '/api/auth/Login',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS =>json_encode($data),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
            ));
            
    
            $response = curl_exec($curl);
            // dd($response);
            if (curl_errno($curl)) {
                dd('Curl error: ' . curl_error($curl));
            }
            curl_close($curl);
        
            $result = json_decode($response, true); // true => get associative array
            // dd($result);
            if (isset($result['status']) && $result['status'] === 0) {
                // Login successful
                session(['token' => $result['response']['token'], 'type' => $result['response']['role'], 'name' => $result['response']['name'], 'profilePicture' => $result['response']['profilePicture']]); // save token if needed
               
                return redirect('/vendor-dashboard'); // or wherever
            }
            

        // Login failed
        return back()->withErrors(['login_error' => $result['response'] ?? 'Login failed.']);
    }

    public function sendOtp(Request $request)
    {
        
        // Validate the username input.
        set_time_limit(300); // 300 seconds = 5 minutes
        $request->validate([
            'username' => 'required|string',
        ]);
        
        $username = $request->username;
        $url = $this->adminbaseUrl . '/api/auth/loginWithUsernameOTP?username=' . urlencode($username);
       
     
        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $result = json_decode($response, true); 
        // dd($result);
       
        if($result['status'] == 0){
            // return $this->sendOtp($request);
            return $result;
        }else{
            return back()->withErrors(['otp_error' => $response['response'] ?? 'Failed to send OTP']);
        }
        

        // Return error message if OTP send failed.
        // return back()->withErrors(['otp_error' => $response['response'] ?? 'Failed to send OTP']);
    }

    public function verifyOtp(Request $request)
    {
        // session(['token' => $request->token, 'type' =>'vendor_admin']);
        // Validate the OTP input.
        $emailOtp = $request->otp;
        $username = $request->username;

        // session([ 'type' => 'vendor_admin']);
        // $value = session('type');
        // dd($value);
        // Redirect to the dashboard upon successful verification.
        // return redirect('/dashboard');
              
        $curl = curl_init();
        $url = $this->adminbaseUrl . "/api/auth/verifyOTPWithUsername?emailOtp={$emailOtp}&username={$username}";
        
        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $result = json_decode($response, true); 
        // dd($result);
        // Check if the response is successful (status 0).
        if (isset($result['status']) && $result['status'] === 0) {
              
            // Store the authentication token in session.
            session(['token' => $result['response']['token'], 'type' => $result['response']['role'], 'name' => $result['response']['name'], 'profilePicture' => $result['response']['profilePicture']]);

            // Redirect to the dashboard upon successful verification.
            return redirect('/dashboard');
        }

        // Return error message if OTP verification failed.
        return back()->withErrors(['otp_error' => $response['response'] ?? 'Invalid OTP']);
    }
    // Optional logout to clear session
    // public function logout (Request $request)
    // {
    //     // Debugging: Check all session data
    //     dd($request->all()); 
        
    //     // Forget the token from the session
    //     // $request->session()->forget('token');
    //     $request->session()->forget('type');
        
    //     // Optionally, invalidate the session (if needed)
    //     $request->session()->invalidate();
    //     $request->session()->regenerateToken();

    //     // Redirect to home or login page after logout
    //     return redirect('/');
    // }

    public function logout()
    {
      
        session()->forget('token');
        return redirect()->route('login');
    }
}
