@extends('layouts.app')
@section('content')


    <!-- Main Content Wrapper -->
      <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <div class="flex items-center justify-between flex-wrap py-5 lg:py-6">
          <!-- Left side: Heading + Breadcrumbs -->
            <div class="flex items-center space-x-4">
                <h2 class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl">
                    All Reports
                </h2>
                <div class="hidden h-full py-1 sm:flex">
                    <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
                </div>
                <ul class="hidden flex-wrap items-center space-x-2 sm:flex">
                    <li class="flex items-center space-x-2">
                        <a class="text-primary transition-colors hover:text-primary-focus dark:text-accent-light dark:hover:text-accent" href="#">
                            Reports
                        </a>
                        <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                        </svg>
                    </li>
                    <li>One Time Vendor Registration</li>
                </ul>
            </div>
            
           <!-- Right side: export buttons -->
            <div class="flex justify-end items-center space-x-2">
                <button id="exportBtn" class="exportBtn btn px-3 py-1.5 text-sm space-x-2 bg-success font-medium text-white shadow-md shadow-primary/40 hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:shadow-accent/40 dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 text-indigo-50" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                    </svg>
                    <span>Export to Excel</span>
                </button>
                <button id="exportBtnPdf" class=" exportBtnPdf btn px-3 py-1.5 text-sm space-x-2 bg-error font-medium text-white shadow-md shadow-primary/40 hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:shadow-accent/40 dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 text-indigo-50" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                        </svg>
                        <span>Export To PDF</span>
                    </button>
            </div> 
        </div>
        

          <div class="card mt-3">
              <div class="is-scrollbar-hidden min-w-full overflow-x-auto">
                <table class="is-hoverable w-full text-left">
                  <thead>
                    <tr>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Username
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        First Name
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Last Name
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Type 
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Mobile
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Email
                      </th>
                      
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Company Name
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Form Limit
                      </th>
                      <th
                        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                      >
                        Project Name
                      </th>
                      
                      
                    </tr>
                  </thead>
                  <tbody id="vendor-list">
                    
                  </tbody>
                </table>
              </div>
              <div
                class="flex flex-col justify-between space-y-4 px-4 py-4 sm:flex-row sm:items-center sm:space-y-0 sm:px-5"
                >
                <div id="entry-range" class="text-xs-plus">1 - 10 of 10 entries</div>
                <!-- Page numbers -->
                <ol id="pagination" class="pagination">
                    <!-- JS will populate -->
                </ol>

                <!-- Info -->
                <div id="pagination-info" class="text-xs-plus">
                    <!-- JS will populate -->
                </div>
              </div>
            </div>
      </main>
      
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

<script>
  const BASE_URL = "{{ config('app.admin_base_url') }}"; // Inject from config
  let currentPage = 1;
  let pageSize = 10;
  let totalEntries = 0;

  document.addEventListener('DOMContentLoaded', () => {
    loadPage(currentPage);
  });
  const token = "{{ session('token') }}";
  function loadPage(page) {
    fetch(`${BASE_URL}/api/vendor/getOneTimeVendorRegistrationReport?pageNo=${page - 1}&pageSize=${pageSize}&vendorName=`, {
          method: 'GET',
          headers: {
              'Authorization': `Bearer ${token}`,
              'Accept': 'application/json'
          }
      })
      .then(res => res.json())
      .then(json => {
        if (json.status !== 0) throw new Error('API error');
        const resp = json.response;
        totalEntries = resp.totalElements;
        renderTable(resp.dataSet);
        renderPagination(resp.totalPages);
        updatePageInfo(resp.totalElements);
        updateEntryRange(); 
      })
      .catch(err => console.error(err));
  }

  function renderTable(rows) {
    const tbody = document.getElementById('vendor-list');
    tbody.innerHTML = '';
    rows.forEach((item) => {
      const createdAt = item.createdAt ? new Date(item.createdAt).toLocaleString('en-GB') : 'N/A';
      const fullName = item.vendorName;
      const imageUrl = item.profilePicture || 'https://via.placeholder.com/50';

      tbody.insertAdjacentHTML('beforeend', `
        <tr class="border-y border-transparent border-b-slate-200 dark:border-b-navy-500">
          
          <td class="whitespace-nowrap px-4 py-3 sm:px-5"><p class="text-sm-plus font-medium">${item.username ?? 0}</p></td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5"><p class="text-sm-plus font-medium">${item.firstname ?? 0}</p></td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5"><p class="text-sm-plus font-medium">${item.lastname ?? 0}</p></td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5"><p class="text-sm-plus font-medium">${item.type ?? 0}</p></td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5"><p class="text-sm-plus font-medium">${item.mobile ?? 0}</p></td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5"><p class="text-sm-plus font-medium">${item.email ?? 0}</p></td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5"><p class="text-sm-plus font-medium">${item.companyName ?? 0}</p></td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5"><p class="text-sm-plus font-medium">${item.formLimit ?? 0}</p></td>

          <td class="whitespace-nowrap px-4 py-3 sm:px-5"><p class="text-sm-plus font-medium">${item.projectName ?? 0}</p></td>
          
        </tr>
      `);
    });
  }


  function renderPagination(totalPages) {
    const ol = document.getElementById('pagination');
    ol.innerHTML = '';

    // Previous Button
    ol.insertAdjacentHTML('beforeend', `
      <li>
        <a href="#" onclick="if(currentPage > 1){ currentPage--; loadPage(currentPage); } return false;"
          class="flex size-8 items-center justify-center rounded-full bg-slate-150 text-slate-500 hover:bg-slate-300 dark:bg-navy-500 dark:text-navy-200">
          <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
          </svg>
        </a>
      </li>
    `);

    // Page Numbers
    // Calculate page range to show
    let startPage = Math.max(1, currentPage - 2);
    let endPage = Math.min(totalPages, currentPage + 2);

    // Adjust if near beginning
    if (currentPage <= 3) {
      endPage = Math.min(5, totalPages);
    }

    // Adjust if near end
    if (currentPage >= totalPages - 2) {
      startPage = Math.max(1, totalPages - 4);
    }

    // Show page numbers within range
    for (let i = startPage; i <= endPage; i++) {
      ol.insertAdjacentHTML('beforeend', `
        <li>
          <a href="#" 
            onclick="currentPage = ${i}; loadPage(currentPage); return false;"
            class="flex h-8 w-8 items-center justify-center rounded-full ${currentPage === i ? 'bg-primary text-white' : 'bg-slate-150 text-slate-500 hover:bg-slate-300'}">
            ${i}
          </a>
        </li>
      `);
    }

    // Show Next button
    ol.insertAdjacentHTML('beforeend', `
      <li>
        <a href="#" 
          onclick="if(currentPage < totalPages) { currentPage++; loadPage(currentPage); } return false;"
          class="flex size-8 items-center justify-center rounded-full bg-slate-150 text-slate-500 hover:bg-slate-300">
          <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
          </svg>
        </a>
      </li>
    `);
  }
  function updatePageInfo(total) {
    const info = document.getElementById('pagination-info');
    const start = (currentPage - 1) * pageSize + 1;
    const end = Math.min(currentPage * pageSize, total);
    info.innerText = `${start} - ${end} of ${total} entries`;
  }


</script>

<script>
  
  document.querySelector('.exportBtn').addEventListener('click', async function () {
    const ADMIN_BASE_URL = "{{ config('app.admin_base_url') }}";
    const params = new URLSearchParams();
    const adminbaseUrl = `${ADMIN_BASE_URL}/api/vendor/getOneTimeVendorRegistrationReportExcel`;
    function addIfExists(key, selector) {
      const el = document.querySelector(selector);
      if (el && el.value && el.value.trim() !== '') {
        params.append(key, el.value.trim());
      }
    }

    try {
      const response = await fetch(adminbaseUrl, {
        method: 'GET',
        headers: {
          'Accept': 'text/csv',
          // Add Authorization header if needed
          // 'Authorization': 'Bearer your_token_here'
        }
      });

      if (!response.ok) {
        throw new Error(`Error: ${response.status}`);
      }

      const blob = await response.blob();
      const downloadUrl = window.URL.createObjectURL(blob);
      const a = document.createElement('a');
      a.href = downloadUrl;
      a.download = 'vendor_registration.xlsx'; // desired filename
      document.body.appendChild(a);
      a.click();
      a.remove();
      window.URL.revokeObjectURL(downloadUrl);
    } catch (error) {
      console.error('Export failed:', error);
      alert('Export failed. Please try again.');
    }
  });
</script>
<script>
  
  document.querySelector('.exportBtnPdf').addEventListener('click', async function () {
    const ADMIN_BASE_URL = "{{ config('app.admin_base_url') }}";
    const params = new URLSearchParams();
    const adminbaseUrl = `${ADMIN_BASE_URL}/api/vendor/getOneTimeVendorRegistrationReportPdf`;
    function addIfExists(key, selector) {
      const el = document.querySelector(selector);
      if (el && el.value && el.value.trim() !== '') {
        params.append(key, el.value.trim());
      }
    }

    try {
      const response = await fetch(adminbaseUrl, {
        method: 'GET',
        headers: {
          'Accept': 'text/pdf',
          // Add Authorization header if needed
          // 'Authorization': 'Bearer your_token_here'
        }
      });

      if (!response.ok) {
        throw new Error(`Error: ${response.status}`);
      }

      const blob = await response.blob();
      const downloadUrl = window.URL.createObjectURL(blob);
      const a = document.createElement('a');
      a.href = downloadUrl;
      a.download = 'vendor_registration.pdf'; // desired filename
      document.body.appendChild(a);
      a.click();
      a.remove();
      window.URL.revokeObjectURL(downloadUrl);
    } catch (error) {
      console.error('Export failed:', error);
      alert('Export failed. Please try again.');
    }
  });
</script>
@endsection