<!doctype html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title>Accred Events</title>
    <link rel="icon" type="image/png" href="<?php echo e(url('images/logo.png')); ?>" />

    <!-- CSS Assets -->
    <link rel="stylesheet" href="css/app.css" />

    <!-- Javascript Assets -->
    <script src="js/app.js" defer></script>
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
        function showTab(tab) {
        // Hide both forms
        document.getElementById('userForm').classList.add('hidden');
        document.getElementById('adminForm').classList.add('hidden');

        // Show selected tab's form
        document.getElementById(tab).classList.remove('hidden');

        // Reset tab styles
        document.getElementById('userTab').classList.remove('border-blue-500', 'text-blue-600');
        document.getElementById('userTab').classList.add('text-gray-600', 'border-transparent');

        document.getElementById('adminTab').classList.remove('border-blue-500', 'text-blue-600');
        document.getElementById('adminTab').classList.add('text-gray-600', 'border-transparent');

        // Set active tab styles
        if (tab === 'userForm') {
            document.getElementById('userTab').classList.add('border-blue-500', 'text-blue-600');
            document.getElementById('userTab').classList.remove('text-gray-600', 'border-transparent');
        } else {
            document.getElementById('adminTab').classList.add('border-blue-500', 'text-blue-600');
            document.getElementById('adminTab').classList.remove('text-gray-600', 'border-transparent');
        }
    }

    // Optional: Set default tab
    window.onload = () => showTab('userForm');

        function showOtpStep() {
           // Prevent form submission if it's inside a form
            event.preventDefault();
            document.getElementById('adminStep1').classList.add('hidden');
            document.getElementById('adminStep2').classList.remove('hidden');
            return false;
        }
    </script>
    <style>
      .bg-blue-600 {
          --tw-bg-opacity: 1;
          background-color: #2a0134!important;
      }

      .text-blue-600 {
          --tw-text-opacity: 1;
          color: #2a0134!important;
      }

      .border-blue-500 {
          --tw-border-opacity: 1;
          border-color: #2a0134!important;
      }
    </style>
  </head>
  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->
    <div
      class="app-preloader fixed z-50 grid h-full w-full place-content-center bg-slate-50 dark:bg-navy-900"
    >
      <div class="app-preloader-inner relative inline-block size-48"></div>
    </div>

    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
      >
      <div class="fixed top-0 hidden p-6 lg:block lg:px-12">
        <a href="#" class="flex items-center space-x-2">
          <img src="images/logo2.png" alt="logo" />
          
        </a>
      </div>
      <div class="hidden w-full place-items-center lg:grid">
        <div class="w-full max-w-lg p-6">
          <img
            class="w-full"
            x-show="!$store.global.isDarkModeEnabled"
            src="images/illustrations/dashboard-check.svg"
            alt="image"
          />
          <img
            class="w-full"
            x-show="$store.global.isDarkModeEnabled"
            src="images/illustrations/dashboard-check.svg"
            alt="image"
          />
        </div>
      </div>
      <main
        class="flex w-full flex-col items-center bg-white dark:bg-navy-700 lg:max-w-md"
      >
        <div class="flex w-full max-w-sm grow flex-col justify-center p-5">
          <div class="text-center">
            <img
              class="mx-auto size-16 lg:hidden"
              src="images/app-logo.svg"
              alt="logo"
            />
            <div class="mt-4">
              <h2
                class="text-2xl font-semibold text-slate-600 dark:text-navy-100"
              >
              Welcome Back
              </h2>
              <p class="text-slate-400 dark:text-navy-300">
                Please sign in to continue
              </p>
            </div>
          </div>

        
          <div class="mt-4 space-y-4">
          <div class="mt-16">
              <!-- Tab Header -->
              <div class="flex border-b">
                  <button id="userTab" onclick="showTab('userForm')" class="flex-1 text-center py-2 font-semibold text-gray-600 border-b-2 border-transparent">User Login</button>
                  <button id="adminTab" onclick="showTab('adminForm')" class="flex-1 text-center py-2 font-semibold text-gray-600 border-b-2 border-transparent">Admin Login</button>
              </div>

              <form method="POST" action="<?php echo e(route('login')); ?>">
                <?php echo csrf_field(); ?>
                <!-- User Login Form -->
                <div id="userForm">
                    <h2 class="text-2xl font-bold mb-4 pt-5" style="color:black;">Welcome Back</h2>

                    <input type="text" name="username" placeholder="username" class="w-full mb-4 px-4 py-2 border rounded">
                    <input type="password" name="password" placeholder="Password" class="w-full mb-4 px-4 py-2 border rounded">
                    
                    <button type="submit" class="w-full bg-blue-600 text-white py-2 rounded">Sign In</button>
                </div>
              </form> 
              <form method="POST" action="<?php echo e(route('login.admin.verifyOtp')); ?>">
              <?php echo csrf_field(); ?>
                <!-- Admin Login Step 1: Enter Username -->
                <div id="adminForm" class="hidden">
                    <div id="adminStep1">
                        <h3 class="font-bold mb-4 pt-5 " style="color:black;">Enter Your Username</h3>

                        <input type="text" id="username" placeholder="Enter Username" class="w-full mb-4 px-4 py-2 border rounded" name="username">
                        <button type="button" onclick="sendOtp()" class="w-full bg-blue-600 text-white py-2 rounded">Send OTP </button>
                    </div>

                    <!-- Admin Login Step 2: OTP Entry -->
                    <div id="adminStep2" class="hidden">
                    <h3 class="font-bold mb-4 pt-5 " style="color:black;">Enter OTP</h3>
                    <input type="text" name="otp" placeholder="OTP" class="w-full mb-4 px-4 py-2 border rounded">
                        <button class="w-full bg-green-600 text-white py-2 rounded">Submit</button>
                    </div>
                </div>
               
              </form>
              <?php if($errors->has('login_error')): ?>
                    <div class="alert alert-danger p-5" style="color:red;">
                        <?php echo e($errors->first('login_error')); ?>

                    </div>
              <?php endif; ?>

              <?php if(request('unauthenticated')): ?>
                  <div class="alert alert-danger">
                      You must be logged in to access that page.
                  </div>
              <?php endif; ?>

            </div>
          </div>
          <button
            class="btn mt-10 h-10 w-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
          >
            Sign In
          </button>
          <div
          class="my-5 flex justify-center text-xs text-slate-400 dark:text-navy-300"
        > 
          <a href="#">Privacy Notice</a>
          <div class="mx-3 my-1 w-px bg-slate-200 dark:bg-navy-500"></div>
          <a href="#">Term of service</a>
        </div>
        </div>
      </main>
    </div>

    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
      
    </script>

    <script>
        function sendOtp() {
        
            const username = $('#username').val();
           
            if (!username) {
                alert("Please enter a username.");
                return;
            }
            console.log(username);
            // $('#adminStep1').addClass('hidden');
            //             $('#adminStep2').removeClass('hidden');
            $.ajax({
                url: "<?php echo e(route('login.admin.sendOtp')); ?>",
                method: 'POST',
                data: {
                    username: username,
                    _token: '<?php echo e(csrf_token()); ?>' // CSRF token for Laravel
                },
                success: function(response) {
                    console.log("Response:", response.status);
                    if (response.status == 0) {
                        alert('OTP sent successfully');

                        // ✅ Move to Step 2
                        $('#adminStep1').addClass('hidden');
                        $('#adminStep2').removeClass('hidden');
                    } else {
                        alert(response.message || "Something went wrong.");
                    }
                    // Show OTP field if needed
                },
                error: function(xhr) {
                    console.error("Error:", xhr.responseText);
                    alert('Failed to send OTP');
                }
            });
        }
    </script>

    
  </body>
</html>
<?php /**PATH /var/www/event-console/eventManagement/resources/views/login.blade.php ENDPATH**/ ?>