
<?php $__env->startSection('content'); ?>
    <!-- Main Content Wrapper -->
      <main class="main-content w-full px-[var(--margin-x)] pb-8">
          <div class="flex items-center justify-between flex-wrap py-5 lg:py-6">
            <!-- Left side: Heading + Breadcrumbs -->
            <div class="flex items-center space-x-4">
              <h2 class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl">
                All Vendor Types
              </h2>
              <div class="hidden h-full py-1 sm:flex">
                <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
              </div>
              <ul class="hidden flex-wrap items-center space-x-2 sm:flex">
                <li class="flex items-center space-x-2">
                  <a class="text-primary transition-colors hover:text-primary-focus dark:text-accent-light dark:hover:text-accent" href="#">
                    Vendor Types
                  </a>
                  <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                  </svg>
                </li>
                
              </ul>
            </div>

            <!-- Right side: Add button -->
            <a href="<?php echo e(route('vendor_types.add')); ?>">
                <button class="btn px-3 py-1.5 text-sm space-x-2 bg-primary font-medium text-white shadow-md shadow-primary/40 hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:shadow-accent/40 dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 text-indigo-50" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                    </svg>
                    <span>Add</span>
                </button>
            </a>

          </div>
            <div class="flex flex-col space-y-4 sm:space-y-5 lg:space-y-6">
                <?php $__currentLoopData = $vendor_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div @click="expanded = !expanded; fetchData(<?php echo e($type['vendorTypeId']); ?>)" x-data="{expanded:false}" class="overflow-hidden rounded-lg border border-slate-150 dark:border-navy-500" >
                    <div
                        class="flex items-center justify-between bg-slate-150 px-4 py-4 dark:bg-navy-500 sm:px-5"
                        >
                        <div
                        class="flex items-center space-x-3.5 tracking-wide outline-hidden transition-all"
                        >
                        <?php
                            $name = $type['name'];
                            $initials = collect(explode(' ', $name))->map(function($word) {
                                return strtoupper(substr($word, 0, 1));
                            })->implode('');
                        ?>
                        <div class="avatar size-10">
                            <div
                            class="is-initial rounded-full bg-warning uppercase text-white"
                            >
                            <?php echo e($initials); ?>

                            </div>
                        </div>
                        <div>
                            <p class="text-slate-700 line-clamp-1 dark:text-navy-100">
                            <?php echo e($type['name']); ?>

                            </p>
                            <p class="text-xs text-slate-500 dark:text-navy-300">
                            <?php echo e($type['vendorCount']); ?> Vendors
                            </p>
                        </div>
                        <a href="/vendor-types/update/<?php echo e($type['vendorTypeId']); ?>" >
                        <button class="btn size-7 rounded-full bg-slate-150 p-0 font-medium text-slate-800 hover:bg-slate-200 focus:bg-slate-200 active:bg-slate-200/80 dark:bg-navy-500 dark:text-navy-50 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90">
                            <svg xmlns="http://www.w3.org/2000/svg" class="size-5 rotate-45" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 11l5-5m0 0l5 5m-5-5v12"></path>
                            </svg>
                        </button>
                        </a>
                        </div>
                        
                        <!-- <button
                        @click="expanded = !expanded"
                        class="btn -mr-1.5 size-8 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
                        >
                        <i
                            :class="expanded && '-rotate-180'"
                            class="fas fa-chevron-down text-sm transition-transform"
                        ></i>
                        </button> -->
                    </div>
                    <div x-collapse x-show="expanded">
                        <div class="px-4 py-4 sm:px-5" >
                        <div class="grid grid-cols-1 gap-4 sm:grid-cols-2 sm:gap-5 lg:grid-cols-3 lg:gap-6 xl:grid-cols-4" id="vendor-container-<?php echo e($type['vendorTypeId']); ?>">
                        </div>  
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
      </main>
<script>
    function fetchData(vendor_type_id) {
        // Construct the dynamic container ID
        const containerId = `vendor-container-${vendor_type_id}`;
        const vendorContainer = document.getElementById(containerId);
        const token = "<?php echo e(session('token')); ?>";
        if (!vendorContainer) {
            console.warn(`Container with ID ${containerId} not found.`);
            return;
        }

        vendorContainer.innerHTML = ""; // Clear previous content

        fetch(`https://ac-api.omsdev.in:2002/api/vendor/getVendorSearchByName?pageNo=0&pageSize=30&vendorTypeId=${vendor_type_id}`, {
                method: 'GET',
                headers: {
                    'Authorization': `Bearer ${token}`,
                    'Accept': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                const vendors = data?.response?.dataSet;
                if (Array.isArray(vendors)) {
                    vendors.forEach(vendor => {
                        const vendorCard = `
                            <div class="card">
                                <div class="flex grow flex-col items-center px-4 pb-5 mt-5 sm:px-5">
                                    <div class="avatar size-20">
                                        <img class="rounded-full" src="${vendor.profilePicture}" alt="avatar" />
                                    </div>
                                    <h3 class="pt-3 text-lg font-medium text-slate-700 dark:text-navy-100">${vendor.vendorName ?? 'N/A'}</h3>
                                    <p class="text-xs-plus">Max Staff: ${vendor.maxStaffNumbers ?? 'N/A'}</p>
                                    <div class="inline-space mt-3 flex grow flex-wrap items-start">
                                        <a href="#" class="tag rounded-full bg-success/10 text-success hover:bg-success/20 focus:bg-success/20 active:bg-success/25">
                                            Application Deadline:  ${formatDate(vendor.customDeadline)}
                                        </a>
                                    </div>
                                    <div class="mt-5 flex justify-center space-x-2">
                                        <a href="/vendor/update/${vendor.vendorId}">
                                            <button
                                                class="btn size-8 rounded-full bg-primary/10 p-0 text-primary hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:bg-accent-light/10 dark:text-accent-light dark:hover:bg-accent-light/20 dark:focus:bg-accent-light/20 dark:active:bg-accent-light/25"
                                                >
                                                <svg xmlns="http://www.w3.org/2000/svg" class="size-3.5" viewBox="0 0 20 20" fill="currentColor">
                                                <path d="M13.586 3.586a2 2 0 112.828 2.828l-.793.793-2.828-2.828.793-.793zM11.379 5.793L3 14.172V17h2.828l8.38-8.379-2.83-2.828z"></path>
                                                </svg>
                                            </button>
                                        </a>
                                            <button
                                                class="btn size-8 rounded-full bg-primary/10 p-0 text-primary hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:bg-accent-light/10 dark:text-accent-light dark:hover:bg-accent-light/20 dark:focus:bg-accent-light/20 dark:active:bg-accent-light/25"
                                                >
                                                <i class="fa fa-project-diagram text-tiny"></i>
                                            </button>
                                        <a href="/company/${vendor.eventName}/${vendor.vendorId}">    
                                            <button
                                                class="btn size-8 rounded-full bg-primary/10 p-0 text-primary hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:bg-accent-light/10 dark:text-accent-light dark:hover:bg-accent-light/20 dark:focus:bg-accent-light/20 dark:active:bg-accent-light/25"
                                            >
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" fill="currentColor" width="18" height="18">
                                            <path d="M326.6 185.4c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l67.9 67.9c25 25 25 65.5 0 90.5l-90.5 90.5c-25 25-65.5 25-90.5 0l-67.9-67.9c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l67.9 67.9c37.5 37.5 98.3 37.5 135.8 0l90.5-90.5c37.5-37.5 37.5-98.3 0-135.8l-67.9-67.9zM185.4 326.6c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-67.9-67.9c-25-25-25-65.5 0-90.5l90.5-90.5c25-25 65.5-25 90.5 0l67.9 67.9c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-67.9-67.9c-37.5-37.5-98.3-37.5-135.8 0l-90.5 90.5c-37.5 37.5-37.5 98.3 0 135.8l67.9 67.9z"/>
                                            </svg>
                                            </button>
                                        </a>
                                        </div>
                                        
                                </div>
                            </div>
                        `;
                        vendorContainer.innerHTML += vendorCard;
                    });
                } else {
                    vendorContainer.innerHTML = "<p class='text-center text-slate-500'>No vendors found.</p>";
                }
            })
            .catch(error => {
                console.error("Error fetching vendor data:", error);
                vendorContainer.innerHTML = "<p class='text-center text-red-500'>Failed to load vendors.</p>";
            });
    }

    function formatDate(dateString) {
        if (!dateString) return 'N/A';
        const date = new Date(dateString);
        const options = { month: 'short', day: '2-digit', year: 'numeric' };
        return date.toLocaleDateString('en-US', options).replace(',', '');
    }

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/event-console/eventManagement/resources/views/allvendors/vendor_types.blade.php ENDPATH**/ ?>