<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Model\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;

class AdminController extends Controller
{
   
    
     public function index(){
        $title='Dashboard';
        $customers=DB::table('customers')->where('deleted_at',null)->count();
        $suppliers=DB::table('suppliers')->where('deleted_at',null)->count();
        $purchase_invoice=DB::table('inward_invoice')->count();
        $sale_invoice=DB::table('order_receipt')->count();
        $orders=DB::table('orders')->where('deleted_at',null)->count();
        $purchase_orders=DB::table('purchase_orders')->where('deleted_at',null)->count();
        
        $totalSaleAmount = DB::table('orders')
        ->whereNull('deleted_at')
        ->sum('grandtotal'); 

        // $totalPurchaseAmount = DB::table('purchase_orders')
        // ->whereNull('deleted_at')
        // ->sum('grand_total'); 

        // $totalinwardAmount = DB::table('inventory')
        // ->whereNull('deleted_at')
        // ->sum('retail_price'); 

          $totalPurchaseAmount = DB::table('inventory')
        ->join('estimated_po','inventory.id','=','estimated_po.inward_id')
        ->whereNull('inventory.deleted_at')
        ->sum('estimated_po.amount'); 
        
        $default_logo = url('uploads/images.jpeg');
        $topSellingProduct = DB::table('order_items')
        ->join('products', 'order_items.product_id', '=', 'products.id')
         ->join('pricing', 'pricing.product_id', '=', 'products.id')
        ->join('product_variant', 'order_items.varient_id', '=', 'product_variant.id') 
        ->select('products.id', 'products.product_name', 'products.product_image','product_variant.varient_name','pricing.retail_price',DB::raw('SUM(order_items.quantity) as total_sold'))
        ->groupBy('products.id', 'products.product_name','products.product_image','product_variant.varient_name','pricing.retail_price')
        ->orderByDesc('total_sold')
        ->limit(4) 
        ->get()
        ->map(function($product) use ($default_logo) {
             
            $product->product_image = $product->product_image 
                ? url('uploads/products/' . $product->product_image) 
                : url($default_logo);
            return $product;
        });
        
        //dd($topSellingProduct);

         //dd($topSellingProduct);
        return view('admin.index', compact(
            'customers', 
            'suppliers', 
            'purchase_invoice', 
            'sale_invoice', 
            'orders', 
            'purchase_orders', 
            'totalSaleAmount', 
            'totalPurchaseAmount', 
            'topSellingProduct',
            'title'
        ));
      
    }
    
    
    public function sales_dashboard(){
        return view('admin.sales-dashboard');
    }
    
    public function dataset(){
     dd('dataset');
     }

    
     public function view_category($id){
        $title='View Category';
        $category=DB::table('categories')->where('id',$id)->first();
        $subcategory=DB::table('sub_categories')->where('category_id',$id)->where('deleted_at',null)->orderBy('id','desc')->get();
        
      
      return view('admin.viewcategory',compact('category','subcategory','title'));
    }

    public function delete_subcategory($id){
        DB::table('sub_categories')->where('id', $id)->update(['deleted_at' => date('Y-m-d H:i:s')]);
        return response()->json(['success' => 'Sub category deleted successfully']);
    }
    

    public function inactive_subcategory($id){
        DB::table('sub_categories')->where('id', $id)->update([
            'status' => 0,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Sub category status changed successfully');
    }

    public function active_subcategory($id){
        DB::table('sub_categories')->where('id', $id)->update([
            'status' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Sub Category status changed successfully');
    }

    public function add_subcategory(Request $request) {
        $categoryId = $request->category_id;
        $subcategories = $request->subcategories;
        $statuses = $request->status;
        $images = $request->file('images');
    
        foreach ($subcategories as $key => $subcategory) {
    
            $imagePath = null; 
            $image = null;
    
            if (isset($images[$key])) {
                $file = $images[$key];
                $extension = $file->getClientOriginalExtension();
                $image = rand(11111111, 99999999) . '.' . $extension;
                $directory = public_path('uploads/subcategories'); 
                $file->move($directory, $image); 
                $imagePath = 'uploads/subcategories/' . $image;
            }
    
            DB::table('sub_categories')->insert([
                'category_id' => $categoryId,
                'sub_category_name' => $subcategory,
                'status' => $statuses[$key],
                'image' => $image, // Use imagePath
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    
        return redirect()->back()->with('success','Subcategory added successfully');
    }



    public function edit_subcategory(Request $request){
        $id = $request->id;
        $name = $request->name;
        $status = $request->status;
       

        $dbs=DB::table('sub_categories')->where('id',$id)->first();

        if($request->hasfile('image')){
            $file = $request->file('image');
            $extension = $file->getClientOriginalExtension();
            $image = rand(11111111,99999999).'.'.$extension;
            $image_path = public_path('uploads/subcategories');
            $file->move($image_path,$image);            
        }else{
            $image = $dbs->image;
        }
    
        DB::table('sub_categories')->where('id', $id)->update([
            'sub_category_name' => $name,
            'image'=>$image,
            'status' => $status,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Sub category updated successfully');
    }


    public function add_category(Request $request){
      
        $name=$request->name;
        $status=$request->status;
        
        if($request->hasfile('image')){
            $file = $request->file('image');
            $extension = $file->getClientOriginalExtension();
            $image = rand(11111111,99999999).'.'.$extension;
            $image_path = public_path('uploads/category');
            $file->move($image_path,$image);            
        }else{
            $image = "Null";
        }
        
  
        DB::table('categories')->insert([
          'category_name'=>$name,
          'image'=>$image,
          'status' =>$status,
          'created_at' =>  date('Y-m-d H:i:s'),
          'updated_at' => date('Y-m-d H:i:s'),
      ]);
  
      return redirect()->back()->with('success','Category added successfully');
      }

      public function edit_category(Request $request){
        $id = $request->id;
        $name = $request->name;
        $status = $request->status;
        
         $dbs=DB::table('categories')->where('id',$id)->first();

        if($request->hasfile('image')){
            $file = $request->file('image');
            $extension = $file->getClientOriginalExtension();
            $image = rand(11111111,99999999).'.'.$extension;
            $image_path = public_path('uploads/category');
            $file->move($image_path,$image);            
        }else{
            $image = $dbs->image;
        }
        
    
        DB::table('categories')->where('id', $id)->update([
            'category_name' => $name,
             'image'=>$image,
            'status' => $status,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Category updated successfully');
    }

    public function delete_category($id){
        DB::table('categories')->where('id', $id)->update(['deleted_at' => date('Y-m-d H:i:s')]);
        return response()->json(['success' => 'Category deleted successfully']);
    }

    public function inactive_category($id){
        DB::table('categories')->where('id', $id)->update([
            'status' => 0,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Category status changed successfully');
    }

    public function active_category($id){
        DB::table('categories')->where('id', $id)->update([
            'status' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Category status changed successfully');
    }

    public function category_list(){
        $title='Category List';
        $categories=DB::table('categories')->where('deleted_at',null)->orderBy('id','desc')->get();
        return view('admin.category-list',compact('categories','title'));
    }

    public function add_brand(Request $request){
      
        $name=$request->name;
        $status=$request->status;

        if($request->hasfile('logo')){
            $file = $request->file('logo');
            $extension = $file->getClientOriginalExtension();
            $logo = rand(11111111,99999999).'.'.$extension;
            $image_path = public_path('uploads/brand');
            $file->move($image_path,$logo);            
        }else{
            $logo = "Null";
        }

  
        DB::table('brands')->insert([
          'brand_name'=>$name,
          'status' =>$status,
          'brand_logo'=>$logo,
          'created_at' =>  date('Y-m-d H:i:s'),
          'updated_at' => date('Y-m-d H:i:s'),
      ]);
  
      return redirect()->back()->with('success','Brand added successfully');
    }
      
    public function add_brand_dynamic(Request $request){
      

        $brand_id = DB::table('brands')->insertGetId([
            'brand_name' => $request->name,
        ]);
    
      
        $brand = DB::table('brands')->where('id', $brand_id)->first();
    
        
        return response()->json([
            'success' => true,
            'brand' => $brand,
        ]);
    }

    public function add_unit_dynamic(Request $request){
      

        $unit_id = DB::table('units')->insertGetId([
            'unit_name' => $request->name,
        ]);
    
       
        $unit = DB::table('units')->where('id', $unit_id)->first();
    
       
        return response()->json([
            'success' => true,
            'unit' => $unit,
        ]);
    }
      
    public function add_category_dynamic(Request $request){
        $category_id = DB::table('categories')->insertGetId([
            'category_name' => $request->name,
        ]);
        $categories = DB::table('categories')->where('id', $category_id)->first();
        return response()->json([
            'success' => true,
            'category' => $categories,
        ]);
    }

    public function add_subcategory_dynamic(Request $request){
     
        $sub_categories_id = DB::table('sub_categories')->insertGetId([
            'category_id' => $request->category,
            'sub_category_name' => $request->subcategory,
        ]);
        $sub_categories = DB::table('sub_categories')->where('id', $sub_categories_id)->first();
        return response()->json([
            'success' => true,
            'subcategory' => $sub_categories,
        ]);
    }


    public function edit_brand(Request $request){
        $id = $request->id;
        $name = $request->name;
        $status = $request->status;
        
        $brandata=DB::table('brands')->where('id',$id)->first();
        if($request->hasfile('logo')){
            $file = $request->file('logo');
            $extension = $file->getClientOriginalExtension();
            $logo = rand(11111111,99999999).'.'.$extension;
            $image_path = public_path('uploads/brand');
            $file->move($image_path,$logo);            
        }else{
            $logo = $brandata->brand_logo;
        }
        
        DB::table('brands')->where('id', $id)->update([
            'brand_name' => $name,
            'status' => $status,
            'brand_logo'=>$logo,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Brand updated successfully');
    }

    public function delete_brand($id){
        DB::table('brands')->where('id', $id)->update(['deleted_at' => date('Y-m-d H:i:s')]);
        return response()->json(['success' => 'Brand deleted successfully']);
    }

    public function inactive_brand($id){
        DB::table('brands')->where('id', $id)->update([
            'status' => 0,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Brand status changed successfully');
    }

    public function active_brand($id){
        DB::table('brands')->where('id', $id)->update([
            'status' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Brand status changed successfully');
    }

    public function brand_list(){
        $title="Brand List";
        $brands=DB::table('brands')->where('deleted_at',null)->orderBy('id','desc')->get();
        return view('admin.brand-list',compact('brands','title'));
    }


    public function add_unit(Request $request){
      
        $name=$request->name;
        $status=$request->status;
  
        DB::table('units')->insert([
          'unit_name'=>$name,
          'status' =>$status,
          'created_at' =>  date('Y-m-d H:i:s'),
          'updated_at' => date('Y-m-d H:i:s'),
      ]);
  
      return redirect()->back()->with('success','Unit added successfully');
    }

    public function edit_unit(Request $request){
        $id = $request->id;
        $name = $request->unit_name;
        $status = $request->status;
    
        DB::table('units')->where('id', $id)->update([
            'unit_name' => $name,
            'status' => $status,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Unit updated successfully');
    }

    public function delete_unit($id){
        DB::table('units')->where('id', $id)->update(['deleted_at' => date('Y-m-d H:i:s')]);
        return response()->json(['success' => 'Unit deleted successfully']);
    }

    public function inactive_unit($id){
        DB::table('units')->where('id', $id)->update([
            'status' => 0,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Unit status changed successfully');
    }

    public function active_unit($id){
        DB::table('units')->where('id', $id)->update([
            'status' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Unit status changed successfully');
    }


    public function unit_list(){
        $title="Unit List";
        $units=DB::table('units')->where('deleted_at',null)->orderBy('id','desc')->get();
       
        return view('admin.unit-list',compact('units','title'));
    }
    public function manage_stocks(){
        return view('admin.manage-stocks');
    }
    public function stock_adjustment(){
        return view('admin.stock-adjustment');
    }
    public function stock_transfer(){
        return view('admin.stock-transfer');
    }
    public function sales_list(){
        return view('admin.sales-list');
    }
    
    public function sales_returns(){
        return view('admin.sales-returns');
    }

    public function quotation_list(){
        return view('admin.quotation-list');
    }
    public function pos(){
        return view('admin.pos');
    }
    public function purchase_list(){
        return view('admin.purchase-list');
    }
    public function purchase_order_report(){
        return view('admin.purchase-order-report');
    }
    public function purchase_returns(){
        return view('admin.purchase-returns');
    }
    
    
    public function store_list(){
        return view('admin.store-list');
    }
    public function add_warehouse(Request $request){
      
        $name=$request->warehouse_name;
        $city=$request->city;
        $state=$request->state;
         $phone_no=$request->phone_no;
        $address=$request->address;
        $capacity=$request->capacity;
        $status=$request->status;
  
        DB::table('warehouses')->insert([
          'warehouse_name'=>$name,
          'address'=>$address,
            'phone_no'=>$phone_no,
          'city'=>$city,
          'state'=>$state,
          'capacity'=>$capacity,
          'status' =>$status,
          'created_at' =>  date('Y-m-d H:i:s'),
          'updated_at' => date('Y-m-d H:i:s'),
      ]);
  
      return redirect()->back()->with('success','Warehouse added successfully');
      }

      public function edit_warehouse(Request $request){
        $id = $request->id;
        $name=$request->warehouse_name;
        $city=$request->city;
         $phone_no=$request->phone_no;
        $state=$request->state;
        $address=$request->address;
        $capacity=$request->capacity;
        $status=$request->status;
    
        DB::table('warehouses')->where('id', $id)->update([
            'warehouse_name'=>$name,
            'address'=>$address,
               'phone_no'=>$phone_no,
            'city'=>$city,
            'state'=>$state,
            'capacity'=>$capacity,
            'status' => $status,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Warehouse updated successfully');
    }

    public function delete_warehouse($id){
        DB::table('warehouses')->where('id', $id)->update(['deleted_at' => date('Y-m-d H:i:s')]);
        return response()->json(['success' => 'Warehouses deleted successfully']);
    }

    public function inactive_warehouse($id){
        DB::table('warehouses')->where('id', $id)->update([
            'status' => 0,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Warehouses status changed successfully');
    }

    public function active_warehouse($id){
        DB::table('warehouses')->where('id', $id)->update([
            'status' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Warehouses status changed successfully');
    }
    public function warehouse(){
        $title='Warehouse List';
        $warehouses=DB::table('warehouses')->where('deleted_at',null)->orderBy('id','desc')->get();
        return view('admin.warehouse',compact('warehouses','title'));
    }
       public function staff(){
        $title='Staff List';
        $staff=DB::table('staffs')->where('deleted_at',null)->orderBy('id','desc')->get();
        return view('admin.staff',compact('staff','title'));
    }

    

    public function add_staff(){
        $title='Add New Staff';
        $users=DB::table('users')->where('type_id',4)->where('deleted_at',null)->get();
        
        $lastStaff = DB::table('staffs')->orderBy('staff_id', 'desc')->where('deleted_at',null)->first();

    
        if ($lastStaff) {
            $lastIdNumber = (int) substr($lastStaff->staff_id, 2); 
            $newStaffId = 'ST' . str_pad($lastIdNumber + 1, 6, '0', STR_PAD_LEFT); 
        } else {
            $newStaffId = 'ST000001';
        }

        
     return view('admin.add-staff',compact('users','newStaffId','title'));
    }

    public function save_staff(Request $request){
        

        $user_id=$request->user_id;
        $staff_id=$request->staff_id;
        $payment=$request->payment;
        $payment_date=$request->payment_date;
        $phone1=$request->phone1;
        $phone2=$request->phone2;
         $city=$request->city;
        $state=$request->state;
        $pincode=$request->pincode;
        $address=$request->address;

        DB::table('staffs')->insert([
        'user_id'=>$user_id,
        'staff_id'=>$staff_id,
        'payment'=>$payment,
        'payment_date'=>$payment_date,
        'phone1'=>$phone1,
        'phone2'=>$phone2,
        'city'=>$city,
        'state'=>$state,
        'pincode'=>$pincode,
        'address'=>$address,
        'created_at' =>  date('Y-m-d H:i:s'),
        'updated_at' => date('Y-m-d H:i:s'),
        ]);
        return redirect()->route('staff')->with('success', 'Staff added successfully');

    }

    public function edit_staff($id){
        $title='Edit Staff';
        $users=DB::table('users')->where('type_id',4)->where('deleted_at',null)->get();
        $staff=DB::table('staffs')->where('id',$id)->where('deleted_at',null)->first();
        return view('admin.edit_staff',compact('users','staff','title'));

    }

    public function update_staff(Request $request){
        $id=$request->id;
        $user_id=$request->user_id;
        $staff_id=$request->staff_id;
        $payment=$request->payment;
        $payment_date=$request->payment_date;
        $phone1=$request->phone1;
        $phone2=$request->phone2;
        $city=$request->city;
        $state=$request->state;
        $pincode=$request->pincode;
        $address=$request->address;

        DB::table('staffs')->where('id',$id)->update([
        'user_id'=>$user_id,
        'staff_id'=>$staff_id,
        'payment'=>$payment,
        'payment_date'=>$payment_date,
        'phone1'=>$phone1,
        'phone2'=>$phone2,
        'city'=>$city,
        'state'=>$state,
        'pincode'=>$pincode,
        'address'=>$address,
        'updated_at' => date('Y-m-d H:i:s'),
        ]);
        return redirect()->route('staff')->with('success', 'Staff updated successfully');
    }

    public function inactive_staff($id){
        DB::table('staffs')->where('id', $id)->update([
            'status' => 0,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Staff status changed successfully');
    }

    public function active_staff($id){
        DB::table('staffs')->where('id', $id)->update([
            'status' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Staff  status changed successfully');
    }

    public function delete_staff($id){
        DB::table('staffs')->where('id', $id)->update(['deleted_at' => date('Y-m-d H:i:s')]);
        return response()->json(['success' => 'Staff deleted successfully']);
    }
    public function tailor(){
        return view('admin.tailor');
    }
    
     public function installer(){
        $title='Installer List';
        $installer=DB::table('installers')->where('deleted_at',null)->orderBy('id','desc')->get();
        return view('admin.installer',compact('installer','title'));
    }

    

    public function add_installer(){
        $title='Add New Installer';
        $users=DB::table('users')->where('type_id',5)->where('deleted_at',null)->get();
          $products=DB::table('products')->where('deleted_at',null)->get();
        $lastInstaller = DB::table('installers')->orderBy('installer_id', 'desc')->first();

          $assignedUserIds = DB::table('installers')->pluck('user_id'); 
        $users = DB::table('users')
            ->whereNotIn('id', $assignedUserIds) 
            ->where('type_id',5)
            ->get();

    
        if ($lastInstaller) {
            $lastIdNumber = (int) substr($lastInstaller->installer_id, 2); // Get numeric part
            $newInstallerId = 'IN' . str_pad($lastIdNumber + 1, 6, '0', STR_PAD_LEFT); // Increment and format with leading zeros
        } else {
            $newInstallerId = 'IN000001';
        }
        
        //dd($newInstallerId);
        
     return view('admin.add-installer',compact('users','newInstallerId','title','products'));
    }

    public function save_installer(Request $request)
    {
        DB::beginTransaction();
        try {
            // Validate request (optional but recommended)
           

            // Insert into installers table
            $installerId = DB::table('installers')->insertGetId([
                'installer_id' => $request->installer_id,
                'user_id'      => $request->user_id,
                'phone1'       => $request->phone1,
                'phone2'       => $request->phone2,
                'address'      => $request->address,
                'city'         => $request->city,
                'state'        => $request->state,
                'pincode'      => $request->pincode,
                'created_at'   => now(),
                'updated_at'   => now(),
            ]);

            // Insert into installer_charges table
            $productIds = $request->product_id;
            $rates = $request->rate;

            $chargeData = [];
            for ($i = 0; $i < count($productIds); $i++) {
                if (!empty($productIds[$i]) && !empty($rates[$i])) {
                    $chargeData[] = [
                        'installer_id' => $installerId,
                        'user_id'      => $request->user_id,
                        'product_id'   => $productIds[$i],
                        'rate'         => $rates[$i],
                        'created_at'   => now(),
                        'updated_at'   => now(),
                    ];
                }
            }

            if (!empty($chargeData)) {
                DB::table('installer_charges')->insert($chargeData);
            }

            DB::commit();

            return redirect()->route('installer')->with('success', 'Installer and charges added successfully');

        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()->with('error', 'Error saving installer: ' . $e->getMessage());
        }
    }

  public function edit_installer($id){
       $products=DB::table('products')->where('deleted_at',null)->get();
       $assignedUserIds = DB::table('installers')->pluck('user_id'); 
        $users = DB::table('users')
            ->whereNotIn('id', $assignedUserIds) 
            ->where('type_id',5)
            ->get();
        $installer=DB::table('installers')->join('users','users.id','=','installers.user_id')
        ->select('installers.*','users.full_name')
        ->where('installers.id',$id)
        ->where('users.deleted_at',null)
        ->first();


        $users = DB::table('users')->whereNull('deleted_at')->get();

            if (!$users->contains('id', $installer->user_id)) {
                $users->push((object)[
                    'id' => $installer->user_id,
                    'full_name' => $installer->full_name
                ]);
            }


        //dd($installer);
         $charges = DB::table('installer_charges')
        ->where('installer_id', $id)
        ->whereNull('deleted_at')
        ->get();
        return view('admin.edit_installer',compact('users','installer','products','charges'));

    }

    public function update_installer(Request $request)
    {
        $id = $request->id;

        // Update installer main details
        DB::table('installers')->where('id', $id)->update([
            'user_id'    => $request->user_id,
            'installer_id' => $request->installer_id,
            'phone1'     => $request->phone1,
            'phone2'     => $request->phone2,
            'address'    => $request->address,
            'city'       => $request->city,
            'state'      => $request->state,
            'pincode'    => $request->pincode,
            'updated_at' => now(),
        ]);

        // Delete old charges
        DB::table('installer_charges')->where('installer_id', $id)->delete();

        // Insert new charges (if provided)
        if ($request->has('product_id') && is_array($request->product_id)) {
            foreach ($request->product_id as $index => $productId) {
                if (!empty($productId) && isset($request->rate[$index])) {
                    DB::table('installer_charges')->insert([
                        'installer_id' => $id,
                        'user_id'      => $request->user_id,
                        'product_id'   => $productId,
                        'rate'         => $request->rate[$index] ?? 0,
                        'created_at'   => now(),
                        'updated_at'   => now(),
                    ]);
                }
            }
        }

        return redirect()->route('installer')->with('success', 'Installer updated successfully!');
    }

    public function inactive_installer($id){
        DB::table('installers')->where('id', $id)->update([
            'status' => 0,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Installer status changed successfully');
    }

    public function active_installer($id){
        DB::table('installers')->where('id', $id)->update([
            'status' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Installer  status changed successfully');
    }

    public function delete_installer($id){
        DB::table('installers')->where('id', $id)->update(['deleted_at' => date('Y-m-d H:i:s')]);
        return response()->json(['success' => 'Installer deleted successfully']);
    }
    
    public function godown_manager(){
        $title='Godown Manager List';
        $godown_managers=DB::table('godown_manager')->where('deleted_at',null)->orderBy('id','desc')->get();
        return view('admin.godown_managers',compact('godown_managers','title'));
    }
    
      public function add_installer_dynamic(Request $request){
      

        $installer_id = DB::table('users')->insertGetId([
            'full_name' => $request->name,
             'email' => $request->email,
              'password' => bcrypt($request->password),
            'type_id'=>5,
            'username'=>$request->name
        ]);
    
        $installer = DB::table('users')->where('id', $installer_id)->first();
        
    
        return response()->json([
            'success' => true,
            'installer' => $installer,
        ]);
      }

      public function add_staff_dynamic(Request $request){

        //  dd($request->all());
      
        $lastStaff = DB::table('staffs')->orderBy('staff_id', 'desc')->where('deleted_at',null)->first();

    
        if ($lastStaff) {
            $lastIdNumber = (int) substr($lastStaff->staff_id, 2); 
            $newStaffId = 'ST' . str_pad($lastIdNumber + 1, 6, '0', STR_PAD_LEFT); 
        } else {
            $newStaffId = 'ST000001';
        }

       // dd($request->all());

        $staff_id = DB::table('users')->insertGetId([
            'full_name' => $request->name,
             'email' => $request->email,
              'password' => bcrypt($request->password),
            'type_id'=>4,
              'username'=>$request->name
        ]);
    
        $staff = DB::table('users')->where('id', $staff_id)->first();
       // dd($staff);

        // DB::table('staffs')->insert([
        //     'staff_id'=>$newStaffId,
        //     'staff_name' => $request->name,
        //     'user_id'=>$staff_id,
        //     'address'=>$request->address,
        //     'state'=>$request->state,
        //     'city'=>$request->city,
        //     'pincode'=>$request->pincode,
        //     'phone1'=>$request->phone1,
        //     'phone2'=>$request->phone2,
        //     'payment'=>$request->payment,
        //     'payment_date'=>$request->payment_date,

        // ]);
        
        
    
        return response()->json([
            'success' => true,
            'staff' => $staff,
        ]);
    }

      public function add_godownmanager_dynamic(Request $request){
      

        $godownmanager_id = DB::table('users')->insertGetId([
            'full_name' => $request->name,
             'email' => $request->email,
              'password' => bcrypt($request->password),
            'type_id'=>6,
              'username'=>$request->name
        ]);
    
        $godownmanager = DB::table('users')->where('id', $godownmanager_id)->first();
        
    
        return response()->json([
            'success' => true,
            'godownmanager' => $godownmanager,
        ]);
    }


    

    public function add_godown_manager(){
        $title='Add Godown Manager';
        $users=DB::table('users')->where('type_id',6)->where('deleted_at',null)->get();
        $lastCompany = DB::table('godown_manager')->orderBy('godown_manager_id', 'desc')->where('deleted_at',null)->first();

    
        if ($lastCompany) {
            $lastIdNumber = (int) substr($lastCompany->godown_manager_id, 2); // Get numeric part
            $newGodownmangerId = 'GM' . str_pad($lastIdNumber + 1, 6, '0', STR_PAD_LEFT); // Increment and format with leading zeros
        } else {
            $newGodownmangerId = 'GM000001';
        }
     return view('admin.add-godown-manager',compact('users','newGodownmangerId','title'));
    }

    public function save_godown_manager(Request $request){
        $user_id=$request->user_id;
        $godown_manager_id=$request->godown_manager_id;
        $phone1=$request->phone1;
        $phone2=$request->phone2;
        $city=$request->city; 
        $state=$request->state; 
        $pincode=$request->pincode;
        $address=$request->address;

        DB::table('godown_manager')->insert([
        'user_id'=>$user_id,
        'godown_manager_id'=>$godown_manager_id,
        'phone1'=>$phone1,
        'phone2'=>$phone2,
        'address'=>$address,
        'city'=>$city,
        'state'=>$state,
        'pincode'=>$pincode,
        'created_at' =>  date('Y-m-d H:i:s'),
        'updated_at' => date('Y-m-d H:i:s'),
        ]);
        return redirect()->route('godown_manager')->with('success', 'Godown Manager added successfully');

    }

    public function edit_godown_manager($id){
        $title='Edit Godown Manager';
        $users=DB::table('users')->where('type_id',6)->where('deleted_at',null)->get();
        $godown_manager=DB::table('godown_manager')->where('id',$id)->where('deleted_at',null)->first();
        return view('admin.edit_godown_manager',compact('users','godown_manager','title'));

    }

    public function update_godown_manager(Request $request){
        $id=$request->id;
        $user_id=$request->user_id;
        $godown_manager_id=$request->godown_manager_id;
        $phone1=$request->phone1;
        $phone2=$request->phone2;
         $city=$request->city; 
        $state=$request->state; 
        $pincode=$request->pincode;
        $address=$request->address;

        DB::table('godown_manager')->where('id',$id)->update([
        'user_id'=>$user_id,
        'godown_manager_id'=>$godown_manager_id,
        'phone1'=>$phone1,
        'phone2'=>$phone2,
        'address'=>$address,
         'city'=>$city,
        'state'=>$state,
        'pincode'=>$pincode,
        'updated_at' => date('Y-m-d H:i:s'),
        ]);
        return redirect()->route('godown_manager')->with('success', 'Godown Manager updated successfully');
    }

    public function inactive_godown_manager($id){
        DB::table('godown_manager')->where('id', $id)->update([
            'status' => 0,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Godown Manager status changed successfully');
    }

    public function active_godown_manager($id){
        DB::table('godown_manager')->where('id', $id)->update([
            'status' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Godown Manager  status changed successfully');
    }

    public function delete_godown_manager($id){
        DB::table('godown_manager')->where('id', $id)->update(['deleted_at' => date('Y-m-d H:i:s')]);
        return response()->json(['success' => 'Godown Manager deleted successfully']);
    }

    public function accounts(){
        return view('admin.accounts');
    }
    public function sales_report(){
        return view('admin.sales-report');
    }
    public function purchase_report(){
        return view('admin.purchase-report');
    }
    public function inventory_report(){
        return view('admin.inventory-report');
    }
    public function invoice_report(){
        return view('admin.invoice-report');
    }
    
    public function supplier_report(){
        return view('admin.supplier-report');
    }
    public function customer_report(){
        return view('admin.customer-report');
    }
    public function expense_report(){
        return view('admin.expense-report');
    }
    public function income_report(){
        return view('admin.income-report');
    }
    public function tax_reports(){
        return view('admin.tax-reports');
    }
    public function profit_and_loss(){
        return view('admin.profit-and-loss');
    }

    public function usertype(){
        $title='User Type';
        $usertype=DB::table('user_type')->where('deleted_at',null)->get();
        return view('admin.usertype',compact('usertype','title'));
    }

    public function add_usertype(Request $request){
      
      $name=$request->name;
      $status=$request->status;

      DB::table('user_type')->insert([
        'type_name'=>$name,
        'status' =>$status,
        'created_at' =>  date('Y-m-d H:i:s'),
        'updated_at' => date('Y-m-d H:i:s'),
    ]);

    return redirect()->back()->with('success','User type added successfully');
    }

    public function edit_usertype(Request $request){
        $id = $request->id;
        $name = $request->type_name;
        $status = $request->status;
    
        DB::table('user_type')->where('id', $id)->update([
            'type_name' => $name,
            'status' => $status,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'User type updated successfully');
    }

    public function inactive_usertype($id){
        DB::table('user_type')->where('id', $id)->update([
            'status' => 0,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'User type status changed successfully');
    }

    public function active_usertype($id){
        DB::table('user_type')->where('id', $id)->update([
            'status' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'User type status changed successfully');
    }

    public function users(){
        $title='Users';
        $users=DB::table('users')
        ->leftJoin('user_type','user_type.id','=','users.type_id')
        ->select('users.id as userid','users.username','users.full_name','users.email','users.last_login','user_type.type_name','user_type.id','users.status')
        ->where('users.deleted_at',null)
        ->where('users.email','<>',null)
        ->orderBy('users.id','desc')
        ->get();
       
        
        $usertype=DB::table('user_type')->where('status',1)->where('deleted_at',null)->get();
        return view('admin.users',compact('users','usertype','title'));
    }

    public function add_user(Request $request){
        $name=$request->name;
        $username=$request->username;
        $email=$request->email;
        $password=bcrypt($request->password);
        $viewpassword=$request->password;
        $role=$request->role;

        if($request->hasfile('avatar')){
            $file = $request->file('avatar');
            $extension = $file->getClientOriginalExtension();
            $avatar = rand(11111111,99999999).'.'.$extension;
            $image_path = public_path('uploads/user-profile');
            $file->move($image_path,$avatar);            
        }else{
            $avatar = "Null";
        }

  
        DB::table('users')->insert([
          'full_name'=>$name,
          'username' =>$username,
          'email' =>$email,
          'password' =>$password,
          'password1' =>$viewpassword,
          'username' =>$username,
          'type_id'=>$role,
          'avatar'=>$avatar,
          'created_at' =>  date('Y-m-d H:i:s'),
          'updated_at' => date('Y-m-d H:i:s'),
      ]);
  
      return redirect()->back()->with('success','User  added successfully');

    }

    public function edit_user($id)
    {
     
        $user = DB::table('users')->where('id', $id)->first();
      
   
        $usertype = DB::table('user_type')->where('id', $user->type_id)->first()->type_name;



        $response = [
            'user_id'=>$user->id,
            'name' => $user->full_name,
            'username' => $user->username,
            'email' => $user->email,
            'role' => $user->type_id,
            'avatar' => $user->avatar,
            'usertype' => $usertype ,
            'password' =>$user->password1,
            'avatar' => $user->avatar ? asset('uploads/user-profile/' . $user->avatar) : null,
        ];
        
        
        
        return response()->json($response);
    }

    public function update_user(Request $request)
    {
    //dd($request->all());
    
      $id=$request->user_id;
        $user = DB::table('users')->where('id', $id);

        $updateData = [
            'full_name' => $request->name,
            'username' => $request->username,
            'email' => $request->email,
            'type_id' => $request->role,
        ];
        

        if ($request->has('password') && $request->input('password') != '') {
            $updateData['password'] = bcrypt($request->input('password'));
             $updateData['password1'] = $request->input('password');
        }

        if ($request->hasFile('avatar')) {
            $file = $request->file('avatar');
            $filename = time() . '.' . $file->getClientOriginalExtension();
            $file->move(public_path('uploads/user-profile'), $filename);
            $updateData['avatar'] = $filename;
        }

        $user->update($updateData);

        return redirect()->back()->with('success', 'User updated successfully');
    }
    

    public function inactive_user($id){
        DB::table('users')->where('id', $id)->update([
            'status' => 0,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'User  status changed successfully');
    }

    public function active_user($id){
  
        DB::table('users')->where('id', $id)->update([
            'status' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'User  status changed successfully');
    }

   

    public function delete_usertype($id){
        DB::table('user_type')->where('id', $id)->update(['deleted_at' => date('Y-m-d H:i:s')]);
        return response()->json(['success' => 'User type deleted successfully']);
    }

    public function delete_user($id){
   
        DB::table('users')->where('id', $id)->update(['deleted_at' => date('Y-m-d H:i:s')]);
        return response()->json(['success' => 'User deleted successfully']);
    }


    public function roles_permissions(){
        return view('admin.roles-permissions');
    }
    
      public function company_list(){
        $title='Company List';
        $companies=DB::table('companies')->where('deleted_at',null)->orderBy('company_id','desc')->get();
       
        return view('admin.company-list',compact('companies','title'));
    }

    public function add_company(){
        $title='Add Company';
       $warehouses=DB::table('warehouses')->where('deleted_at',null)->where('status',1)->get();
       $lastCompany = DB::table('companies')->orderBy('company_id', 'desc')->where('deleted_at',null)->first();

    
        if ($lastCompany) {
            $lastIdNumber = (int) substr($lastCompany->company_id, 2); // Get numeric part
            $newCompanyId = 'CO' . str_pad($lastIdNumber + 1, 6, '0', STR_PAD_LEFT); // Increment and format with leading zeros
        } else {
            $newCompanyId = 'CO000001';
        }
       return view('admin.add-company',compact('warehouses','newCompanyId','title')); 
    }

    public function save_company(Request $request){
        $company_id=$request->company_id;
        $company_name=$request->company_name;
          $warehouse_id=$request->warehouse_id;
           $gst=$request->gst;
        $gst_no=$request->gst_no;
        $code=$request->code;
        $msme=$request->msme;
        $phone1=$request->phone1;
        $phone2=$request->phone2;
        $fax=$request->fax;
        $address=$request->address;
        $city=$request->city;
        $state=$request->state;
         $status=$request->status;
         $pincode=$request->pincode;


       $datas= DB::table('companies')->insertGetId([
            'company_id'=>$company_id,
            'company_name'=>$company_name,
            'warehouse_id'=>implode(',',$warehouse_id),
             'gst' =>$gst,
            'gst_no' =>$gst_no,
             'code' =>$code,
            'msme' =>$msme,
            'phone1' =>$phone1,
            'phone2' =>$phone2,
            'address' =>$address,
             'zip_code' =>$pincode,
            'fax'=>$fax,
            'city'=>$city,
            'state'=>$state,
            'status'=>1,
            'created_at' =>  date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
        
        foreach ($warehouse_id as $warehouse) {
            DB::table('warehouse_company')->insert([
                'company_id' => $datas,
                'warehouse_id' => $warehouse,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ]);
        }
    
        return redirect()->route('company_list')->with('success','Company  added successfully');
    }

    public function inactive_company($id){
        DB::table('companies')->where('id', $id)->update([
            'status' => 0,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Company  status changed successfully');
    }

    public function active_company($id){
        DB::table('companies')->where('id', $id)->update([
            'status' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Company  status changed successfully');
    }

    public function delete_company($id){
        DB::table('companies')->where('id', $id)->update(['deleted_at' => date('Y-m-d H:i:s')]);
        return response()->json(['success' => 'Company deleted successfully']);
    }

    public function edit_company($id){
        $title='Edit Company';
        $company=DB::table('companies')->where('id',$id)->first();
        $warehouses=DB::table('warehouses')->where('deleted_at',null)->get();
        return view('admin.edit-company',compact('company','warehouses','title'));
    }

    public function update_company(Request $request){
        $id=$request->id;
        $company_id=$request->company_id;
        $warehouse_id=$request->warehouse_id;
        $company_name=$request->company_name;
         $gst=$request->gst;
        $gst_no=$request->gst_no;
         $code=$request->code;
        $msme=$request->msme;
        $phone1=$request->phone1;
        $phone2=$request->phone2;
        $fax=$request->fax;
        $address=$request->address;
        $city=$request->city;
        $state=$request->state;
        $status=$request->status;
          $pincode=$request->pincode;

        DB::table('companies')->where('id', $id)->update([
            'company_id' => $company_id,
            'company_name' => $company_name,
            'warehouse_id'=>implode(',',$warehouse_id),
            'gst_no' => $gst_no,
             'gst' =>$gst,
            'code' =>$code,
            'msme' => $msme,
            'phone1' => $phone1,
            'phone2' => $phone2,
            'fax' => $fax,
            'address' => $address,
            'city' => $city,
            'state' => $state,
             'zip_code' =>$pincode,
             'status' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
        
       
    if (!empty($warehouse_id)) {
        foreach ($warehouse_id as $row) {
          
            $exists = DB::table('warehouse_company')
                ->where('company_id', $id)
                ->where('warehouse_id', $row)
                ->exists();

          
            if (!$exists) {
                DB::table('warehouse_company')->insert([
                    'company_id' => $id,
                    'warehouse_id' => $row,
                    'created_at' => now(), 
                    'updated_at' => now(),
                ]);
            }
        }
    }

    
        return redirect()->route('company_list')->with('success', 'Company updated successfully');
    }
    
    
    public function transporters(){
        $title='Transporter List';
        $transporters=DB::table('transporters')->where('deleted_at',null)->orderBy('id','desc')->get();
        return view('admin.transporters',compact('transporters','title'));    
    }

    public function add_transporter(){
        $title='Add New Transporter';
    $lastCompany = DB::table('transporters')->orderBy('transporter_id', 'desc')->where('deleted_at',null)->first();

        if ($lastCompany) {
            $lastIdNumber = (int) substr($lastCompany->transporter_id, 2); // Get numeric part
            $newTransporter = 'TR' . str_pad($lastIdNumber + 1, 6, '0', STR_PAD_LEFT); // Increment and format with leading zeros
        } else {
            $newTransporter = 'TR000001';
        }
   
        
        return view('admin.add_transporter',compact('newTransporter','title'));
    }

    public function save_transporter(Request $request){
        $transporter_name=$request->transporter_name;
        $contact_person=$request->contact_person;
        $transporter_id=$request->transporter_id;
        $gst_no=$request->gst_no;
        $msme=$request->msme;
        $email=$request->email;
        $city=$request->city;
        $pincode=$request->pincode;
        $state=$request->state;
        $address=$request->address;
        $phone1=$request->phone1;
        $phone2=$request->phone2;
        $created_by= auth()->id();
       
        DB::table('transporters')->insert([
            'transporter_name'=>$transporter_name,
            'transporter_id'=>$transporter_id,
            'contact_person'=>$contact_person,
            'email' =>$email,
            'phone1' =>$phone1,
            'phone2' =>$phone2,
            'gst_no' =>$gst_no,
            'msme' =>$msme,
            'city'=>$city,
            'state'=>$state,
            'pincode'=>$pincode,
            'address'=>$address,
            'created_by'=>$created_by,
            'created_at' =>  date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->route('transporters')->with('success','Transporter  added successfully');
    }

    public function edit_transporter($id){
        $title='Edit Transporter';
       $data=DB::table('transporters')->where('id',$id)->first();
       return view('admin.edit_transporter',compact('data','title'));
    }

    public function update_transporter(Request $request){
        $id=$request->id;
        $transporter_name=$request->transporter_name;
        $contact_person=$request->contact_person;
        $transporter_id=$request->transporter_id;
        $email=$request->email;
        $city=$request->city;
        $pincode=$request->pincode;
        $state=$request->state;
         $address=$request->address;
        $phone1=$request->phone1;
        $phone2=$request->phone2;
        $status=$request->status;
        $gst_no=$request->gst_no;
        $msme=$request->msme;
        $created_by= auth()->id();

        DB::table('transporters')->where('id', $id)->update([
            'transporter_name'=>$transporter_name,
            'transporter_id'=>$transporter_id,
            'contact_person'=>$contact_person,
            'email' =>$email,
            'phone1' =>$phone1,
            'phone2' =>$phone2,
             'gst_no' =>$gst_no,
            'msme' =>$msme,
            'city'=>$city,
            'state'=>$state,
            'pincode'=>$pincode,
            'address'=>$address,
            'status'=>$status,
            'created_by'=>$created_by,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);

        return redirect()->route('transporters')->with('success','Transporter  updated successfully');

    }

    public function inactive_transporter($id){
        DB::table('transporters')->where('id', $id)->update([
            'status' => 0,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Transporter  status changed successfully');
    }

    public function active_transporter($id){
        DB::table('transporters')->where('id', $id)->update([
            'status' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Transporter  status changed successfully');
    }

    public function delete_transporter($id){
        DB::table('transporters')->where('id', $id)->update(['deleted_at' => date('Y-m-d H:i:s')]);
        return response()->json(['success' => 'Transporter deleted successfully']);
    }
    
     public function suppliers(){
        $title='Supplier List';
        $suppliers=DB::table('suppliers')->where('deleted_at',null)->orderBy('id','desc')->get();
        return view('admin.suppliers',compact('suppliers','title'));
    }

    public function add_supplier(){
        $title='Add New Supplier';
        $warehouses=DB::table('warehouses')->where('deleted_at',null)->get();
        $lastCompany = DB::table('suppliers')->orderBy('supplier_id', 'desc')->where('deleted_at',null)->first();

    
        if ($lastCompany) {
            $lastIdNumber = (int) substr($lastCompany->supplier_id, 2); // Get numeric part
            $newSupplierId = 'SP' . str_pad($lastIdNumber + 1, 6, '0', STR_PAD_LEFT); // Increment and format with leading zeros
        } else {
            $newSupplierId = 'SP000001';
        }
        return view('admin.add-supplier',compact('warehouses','newSupplierId','title'));
    }

    public function save_supplier(Request $request){
       

        $supplier_id    =  $request->supplier_id;
        $supplier_name  =  $request->supplier_name;
        $warehouse_id   =  $request->warehouse_id;
        $gst_no         =  $request->gst_no;
        $top            =  $request->top;
        $msme           =  $request->msme;
        $email          =  $request->email;
        $phone1         =  $request->phone1;
        $phone2         =  $request->phone2;
        $fax            =  $request->fax;
        $mobile_no      =  $request->mobile_no;
        $address        =  $request->address;
        $city           =  $request->city;
        $state          =  $request->state;
        $pincode        =  $request->pincode;
        $code           =  $request->code;
        $contact_person =  $request->contact_person;


        DB::table('suppliers')->insert([
            'supplier_id'   => $supplier_id,
            'supplier_name' => $supplier_name,
            'contact_person'=> $contact_person,
            'warehouse_id'  => implode(',',$warehouse_id),
            'gst_number'    => $gst_no,
            'top'           => $top,
            'msme'          => $msme,
            'code'          => $code,
            'mobile'        => $mobile_no,
            'email'         => $email,
            'phone1'        => $phone1,
            'phone2'        => $phone2,
            'address'       => $address,
            'fax'           => $fax,
            'city'          => $city,
            'state'         => $state,
            'pincode'       => $pincode,
            'created_at'    => date('Y-m-d H:i:s'),
            'updated_at'    => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->route('suppliers')->with('success','Supplier  added successfully');

    }

    public function edit_supplier($id){
    $title='Edit Supplier';
    $warehouses=DB::table('warehouses')->where('deleted_at',null)->get();
    $data=DB::table('suppliers')->where('id',$id)->first();
    return view('admin.edit-supplier',compact('data','warehouses','title'));
    }

    public function update_supplier(Request $request){
        $id=$request->id;
        $supplier_id=$request->supplier_id;
        $supplier_name=$request->supplier_name;
        $warehouse_id=$request->warehouse_id;
        $gst_no=$request->gst_no;
        $msme=$request->msme;
        $phone1=$request->phone1;
        $phone2=$request->phone2;
        $fax=$request->fax;
        $mobile_no=$request->mobile_no;
        $address=$request->address;
        $city=$request->city;
        $state=$request->state;
         $pincode=$request->pincode;
        $email=$request->email;
        $code=$request->code;
        $contact_person=$request->contact_person;


        DB::table('suppliers')->where('id', $id)->update([
            'supplier_id'=>$supplier_id,
            'supplier_name'=>$supplier_name,
            'contact_person'=>$contact_person,
            'warehouse_id'=>implode(',',$warehouse_id),
            'gst_number' =>$gst_no,
            'msme' =>$msme,
            'code' =>$code,
            'mobile' =>$mobile_no,
            'email' =>$email,
            'phone1' =>$phone1,
            'phone2' =>$phone2,
            'address' =>$address,
            'fax'=>$fax,
            'city'=>$city,
            'state'=>$state,
            'pincode'=>$pincode,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->route('suppliers')->with('success','Supplier  updated successfully');
    }



    public function inactive_supplier($id){
        DB::table('suppliers')->where('id', $id)->update([
            'status' => 0,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Supplier  status changed successfully');
    }

    public function active_supplier($id){
        DB::table('suppliers')->where('id', $id)->update([
            'status' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Supplier  status changed successfully');
    }

    public function delete_supplier($id){
        DB::table('suppliers')->where('id', $id)->update(['deleted_at' => date('Y-m-d H:i:s')]);
        return response()->json(['success' => 'Supplier deleted successfully']);
    }
    
    
     public function customers(){
        $title='Customer List';
        $customers=DB::table('customers')->where('deleted_at',null)->orderBy('id','desc')->get();
       
        return view('admin.customers',compact('customers','title'));
    }

   

    public function add_customer(){
        $title='Add Customer';
        $warehouses=DB::table('warehouses')->where('deleted_at',null)->get();
        $lastCompany = DB::table('customers')->orderBy('customer_id', 'desc')->where('deleted_at',null)->first();

    
        if ($lastCompany) {
            $lastIdNumber = (int) substr($lastCompany->customer_id, 2); // Get numeric part
            $newCustomerId = 'CU' . str_pad($lastIdNumber + 1, 6, '0', STR_PAD_LEFT); // Increment and format with leading zeros
        } else {
            $newCustomerId = 'CU000001';
        }


        return view('admin.add-customer',compact('warehouses','newCustomerId','title'));
    }

    public function save_customer(Request $request){
       
          //dd($request->all());
        $customer_id=$request->customer_id;
        $customer_name=$request->customer_name;
        $customer_type=$request->customer_type;
        $customer_discount=$request->customer_discount;
        $warehouse_id=1;
        $gst=$request->gst;
        $gst_no=$request->gst_no;
        $msme=$request->msme;
        $email=$request->email;
        $phone1=$request->phone1;
        $phone2=$request->phone2;
        $fax=$request->fax;
        $mobile_no=$request->mobile_no;
        $address=$request->address;
        $city=$request->city;
        $state=$request->state;
        $pincode=$request->pincode;
        $code=$request->code;
        $contact_person=$request->contact_person;
        
        if($request->hasfile('profile')){
            $file = $request->file('profile');
            $extension = $file->getClientOriginalExtension();
            $profile = rand(11111111,99999999).'.'.$extension;
            $image_path = public_path('uploads/user-profile');
            $file->move($image_path,$profile);            
        }else{
            $profile = "Null";
        }

    //dd($profile);
$password=123456;
        DB::table('customers')->insert([
            'customer_id'=>$customer_id,
            'customer_name'=>$customer_name,
            'customer_type'=>$customer_type,
            'customer_discount'=>$customer_discount,
              'profile'=>$profile,
            'contact_person'=>$contact_person,
            'warehouse_id'=>$warehouse_id,
            'gst' =>$gst,
            'gst_number' =>$gst_no,
            'msme' =>$msme,
            'telephone_code' =>$code,
            'mobile' =>$mobile_no,
            'email' =>$email,
              'password' =>bcrypt($password),
            'phone1' =>$phone1,
            'phone2' =>$phone2,
            'address' =>$address,
            'fax'=>$fax,
            'city'=>$city,
            'state'=>$state,
              'zipcode'=>$pincode,
            'created_at' =>  date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->route('customers')->with('success','Customer  added successfully');

    }

    public function edit_customer($id){
        $title='Edit Customer';
    $warehouses=DB::table('warehouses')->where('deleted_at',null)->get();
    $data=DB::table('customers')->where('id',$id)->first();
    return view('admin.edit-customer',compact('data','warehouses','title'));
    }

    public function update_customer(Request $request){
        $id=$request->id;
        $customer_id=$request->customer_id;
        $customer_name=$request->customer_name;
        $customer_type=$request->customer_type;
        $warehouse_id=$request->warehouse_id;
         $gst=$request->gst;
        $gst_no=$request->gst_no;
        $msme=$request->msme;
        $phone1=$request->phone1;
        $phone2=$request->phone2;
        $fax=$request->fax;
        $mobile_no=$request->mobile_no;
        $address=$request->address;
        $city=$request->city;
        $state=$request->state;
         $pincode=$request->pincode;
        $email=$request->email;
        $code=$request->code;
        $contact_person=$request->contact_person;
           $customer_discount=$request->customer_discount;
        
         $datas=DB::table('customers')->where('id',$id)->first();
        if($request->hasfile('profile')){
            $file = $request->file('profile');
            $extension = $file->getClientOriginalExtension();
            $profile = rand(11111111,99999999).'.'.$extension;
            $image_path = public_path('uploads/user-profile');
            $file->move($image_path,$profile);            
        }else{
            $profile = $datas->profile;
        }
        


        DB::table('customers')->where('id', $id)->update([
            'customer_id'=>$customer_id,
            'customer_name'=>$customer_name,
            'customer_type'=>$customer_type,
            'contact_person'=>$contact_person,
            'customer_discount'=>$customer_discount,
            'warehouse_id'=>$warehouse_id,
             'gst' =>$gst,
            'gst_number' =>$gst_no,
            'msme' =>$msme,
            'telephone_code' =>$code,
            'mobile' =>$mobile_no,
              'profile' =>$profile,
            'email' =>$email,
            'phone1' =>$phone1,
            'phone2' =>$phone2,
            'address' =>$address,
            'fax'=>$fax,
            'city'=>$city,
            'state'=>$state,
             'zipcode'=>$pincode,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->route('customers')->with('success','Customer  updated successfully');
    }



    public function inactive_customer($id){
        DB::table('customers')->where('id', $id)->update([
            'status' => 0,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Customer  status changed successfully');
    }

    public function active_customer($id){
        DB::table('customers')->where('id', $id)->update([
            'status' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Customer  status changed successfully');
    }

    public function delete_customer($id){
        DB::table('customers')->where('id', $id)->update(['deleted_at' => date('Y-m-d H:i:s')]);
        return response()->json(['success' => 'Customer deleted successfully']);
    }
    
    
    
    public function coupons(){
        $title='Coupons';
       $coupons=DB::table('coupons')->where('deleted_at',null)->get();
        return view('admin.coupons',compact('coupons','title'));

    }

    public function add_coupon(){
        $title='Add Coupon';
        return view('admin.add-coupon',compact('title'));

    }

    public function save_coupon(Request $request){
      $data=$request->all();

      if($request->hasfile('coupon_image')){
        $file = $request->file('coupon_image');
        $extension = $file->getClientOriginalExtension();
        $profile = rand(11111111,99999999).'.'.$extension;
        $image_path = public_path('uploads/coupons');
        $file->move($image_path,$profile);            
    }else{
        $profile = "Null";
    }



    DB::table('coupons')->insert([
        'coupon_code'=>$data['coupon_code'],
        'discount_type'=>$data['discount_type'],
        'discount_value'=>$data['discount_value'],
        'coupon_image'=>$profile,
        'start_date'=>$data['start_date'],
        'end_date'=>$data['end_date'],
        'description'=>$data['description'],
        'created_at' =>  date('Y-m-d H:i:s'),
        'updated_at' => date('Y-m-d H:i:s'),
        'is_active'  => 1
    ]);

    return redirect()->route('coupons')->with('success','Coupon  added successfully');


    }

    public function edit_coupon(Request $request){
      $title='Edit Coupon';
      $id=$request->id;
      $datas=DB::table('coupons')->where('id',$id)->first();
      return view('admin.edit-coupon',compact('datas','title'));
    }

    public function update_coupon(Request $request){
        $coupon=DB::table('coupons')->where('id',$request->id)->first();
        if($request->hasfile('coupon_image')){
            $file = $request->file('coupon_image');
            $extension = $file->getClientOriginalExtension();
            $profile = rand(11111111,99999999).'.'.$extension;
            $image_path = public_path('uploads/coupons');
            $file->move($image_path,$profile);            
        }else{
            $profile = $coupon->coupon_image;
        }
       
        DB::table('coupons')->where('id',$request->id)->update([
            'coupon_code'=>$request->coupon_code,
            'discount_type'=>$request->discount_type,
            'discount_value'=>$request->discount_value,
            'coupon_image'=>$profile,
            'start_date'=>$request->start_date,
            'end_date'=>$request->end_date,
            'description'=>$request->description,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);

        return redirect()->route('coupons')->with('success','Coupon  updated successfully');
    }

    public function inactive_coupon($id){
        DB::table('coupons')->where('id', $id)->update([
            'is_active' => 0,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Coupon  status changed successfully');
    }

    public function active_coupon($id){
        DB::table('coupons')->where('id', $id)->update([
            'is_active' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Coupon  status changed successfully');
    }
    
      public function view_company($id)
    {
        $title='View Company';
        $warehouses=DB::table('warehouses')->where('deleted_at',null)->get();
        $company=DB::table('companies')->where('id',$id)->first();
        return view('admin.view_company',compact('company','warehouses','title'));
    }
    
    
      public function view_customer($id){
        $title='View Customer';
        $warehouses=DB::table('warehouses')->where('deleted_at',null)->get();
        $data=DB::table('customers')->where('id',$id)->first();
        
        return view('admin.view-customer',compact('data','warehouses','title'));
    }
    
    public function change_password(Request $request){
        
        $title='Change Password';
        return view('admin.change_password',compact('title'));
       
    }

    public function update_password(Request $request){
        $data=$request->all();
        $rules = array(
            'id' => 'required|exists:users,id',
            'crpassword' => 'required',
            'password' => 'required',
            'cnfpassword' => 'required|same:password',
        );
       
        $validator = Validator::make($data, $rules);
        
        if ($validator->fails()) {
            return redirect()->back()->with('error', 'New Password and Confirm Password must match');
            
        } {

        $id=$request->id;
        $crpassword= $request->crpassword;
        $password= $request->password;
        

        $user = DB::table('users')->where('id', $id)->first();
    
          
        if (Hash::check($crpassword, $user->password)) {
           
            DB::table('users')->where('id', $id)->update([
                'password' => bcrypt($password),
            ]);
            return redirect()->back()->with('success','Password changed successfully.');
            
        } else {
            return redirect()->back()->with('error','Current password does not match.');
            
        }

        }

       
    }
    
      public function delete_coupon($id){
        DB::table('coupons')->where('id', $id)->update(['deleted_at' => date('Y-m-d H:i:s')]);
        return response()->json(['success' => 'Coupon deleted successfully']);
    }
    
    
    public function add_customer_dynamic(Request $request){
      
        $lastCustomer = DB::table('customers')->orderBy('customer_id', 'desc')->first();

        if ($lastCustomer) {
            $lastIdNumber = (int) substr($lastCustomer->customer_id, 2); 
            $newCustomerId = 'CU' . str_pad($lastIdNumber + 1, 6, '0', STR_PAD_LEFT); 
        } else {
            $newCustomerId = 'CU000001';
        }
        $password=123456;
        $customer_id = DB::table('customers')->insertGetId([
            'customer_id' => $newCustomerId,
            'customer_name' => $request->name,
            'customer_type' => $request->customer_type,
            'customer_discount' => $request->customer_discount ?? '',
            'email' => $request->email,
            'phone1' => $request->phone,
            'mobile' => $request->mobile_no,
            'gst_number' => $request->gst_no,
            'address' => $request->address,
            'zipcode' => $request->pincode,
            'password' => bcrypt($password)
        ]);
    
        // Retrieve the inserted brand
        $customer = DB::table('customers')->where('id', $customer_id)->first();
    
        // Return the newly added brand in JSON format
        return response()->json([
            'success' => true,
            'customer' => $customer,
        ]);
      }

public function checkEmailExists(Request $request)
{
    $exists = DB::table('users')->where('email', $request->email)->where('deleted_at',null)->exists();
    return response()->json(['exists' => $exists]);
}

public function checkUsertypeExists(Request $request)
{
    $exists = DB::table('user_type')->where('type_name', $request->type)->where('deleted_at',null)->exists();
    return response()->json(['exists' => $exists]);
}

public function checkCategoryExists(Request $request)
{

    $exists = DB::table('categories')->where('category_name', $request->category)->where('deleted_at',null)->exists();
    
    return response()->json(['exists' => $exists]);
}

public function checkBrandExists(Request $request)
{

    $exists = DB::table('brands')->where('brand_name', $request->brand)->where('deleted_at',null)->exists();
    
    return response()->json(['exists' => $exists]);
}

public function checkUnitExists(Request $request)
{

    $exists = DB::table('units')->where('unit_name', $request->unit)->where('deleted_at',null)->exists();
    
    return response()->json(['exists' => $exists]);
}
 
 
 public function checkCustomeremailExists(Request $request)
{

    $exists = DB::table('customers')->where('email', $request->email)->where('deleted_at',null)->exists();
    
    return response()->json(['exists' => $exists]);
}


     public function checkCompanyExists(Request $request)
{

    $exists = DB::table('companies')->where('company_name', $request->company_name)->where('deleted_at',null)->exists();
    
    return response()->json(['exists' => $exists]);
}

public function checkCouponExists(Request $request){

$exists = DB::table('coupons')->where('coupon_code', $request->coupon)->where('deleted_at',null)->exists();
    
    return response()->json(['exists' => $exists]);

}

public function checkSupplierExists(Request $request){

$exists = DB::table('suppliers')->where('supplier_name', $request->supplier_name)->where('deleted_at',null)->exists();
    
    return response()->json(['exists' => $exists]);

}

public function checkWarehouseExists(Request $request){

$exists = DB::table('warehouses')->where('warehouse_name', $request->warehouse)->where('deleted_at',null)->exists();
    
    return response()->json(['exists' => $exists]);

}

public function checkTransporterExists(Request $request){

$exists = DB::table('transporters')->where('transporter_name', $request->transporter)->where('deleted_at',null)->exists();
    
    return response()->json(['exists' => $exists]);

}


public function checkInstallerExists(Request $request){

$exists = DB::table('users')->where('full_name', $request->installer)->where('deleted_at',null)->where('type_id',5)->exists();
    
    return response()->json(['exists' => $exists]);

}

public function checkStaffExists(Request $request){

$exists = DB::table('users')->where('full_name', $request->staff)->where('deleted_at',null)->where('type_id',4)->exists();
    
    return response()->json(['exists' => $exists]);

}

public function checkGmngrExists(Request $request){

$exists = DB::table('users')->where('full_name', $request->godownmanager)->where('deleted_at',null)->where('type_id',6)->exists();
    
    return response()->json(['exists' => $exists]);

}


public function add_bank(Request $request){
      
        $name=$request->name;
        $status=$request->status;
  
        DB::table('banks')->insert([
          'bank_name'=>$name,
          'status' =>$status,
          'created_at' =>  date('Y-m-d H:i:s'),
          'updated_at' => date('Y-m-d H:i:s'),
      ]);
  
      return redirect()->back()->with('success','Bank added successfully');
    }



      public function edit_bank(Request $request){
        $id = $request->id;
        $name = $request->bank_name;
        $status = $request->status;
    
        DB::table('banks')->where('id', $id)->update([
            'bank_name' => $name,
            'status' => $status,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Bank updated successfully');
    }


    public function bank_list(){
        $title='Bank List';
        $banks=DB::table('banks')->where('deleted_at',null)->get();
        return view('admin.bank-list',compact('banks','title'));
    }

    public function delete_bank($id){
        DB::table('banks')->where('id', $id)->update(['deleted_at' => date('Y-m-d H:i:s')]);
        return response()->json(['success' => 'Bank deleted successfully']);
    }

    public function inactive_bank($id){
        DB::table('banks')->where('id', $id)->update([
            'status' => 0,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Bank status changed successfully');
    }

    public function active_bank($id){
        DB::table('banks')->where('id', $id)->update([
            'status' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Bank status changed successfully');
    }
    
    public function getSalesPurchaseData(Request $request)
    {
        $year = $request->year ?? date('Y'); // Default to current year

        // Fetch sales data from the orders table
        $salesData = DB::table('orders')
            ->selectRaw('MONTH(order_date) as month, SUM(grandtotal) as total_sales')
            ->whereYear('order_date', $year)
            ->groupBy('month')
            ->pluck('total_sales', 'month');

        // Fetch purchase data from the purchase_orders table
        $purchaseData = DB::table('purchase_orders')
            ->selectRaw('MONTH(po_date) as month, SUM(grand_total) as total_purchase')
            ->whereYear('po_date', $year)
            ->groupBy('month')
            ->pluck('total_purchase', 'month');

        // Format data for the chart (ensure all 12 months are included)
        $formattedSales = [];
        $formattedPurchase = [];
        for ($i = 1; $i <= 12; $i++) {
            $formattedSales[] = $salesData[$i] ?? 0;
            $formattedPurchase[] = $purchaseData[$i] ?? 0;
        }
       //dd($formattedPurchase);
        return response()->json([
            'sales' => $formattedSales,
            'purchase' => $formattedPurchase,
        ]);
    }


    public function checkGSTExistssupplier($gst)
    {
        $exists = DB::table('suppliers') 
            ->where('gst_number', $gst)
            ->exists();

        return response()->json(['exists' => $exists]);
    }

    public function checkGSTExistscustomer($gst)
    {
        $exists = DB::table('customers') 
            ->where('gst_number', $gst)
            ->exists();

        return response()->json(['exists' => $exists]);
    }

    public function checkGSTExistscompany($gst)
    {
        $exists = DB::table('companies') 
            ->where('gst_no', $gst)
            ->exists();

        return response()->json(['exists' => $exists]);
    }



    public function checkGSTExiststransporter($gst)
    {
        $exists = DB::table('transporters') 
            ->where('gst_no', $gst)
            ->exists();

        return response()->json(['exists' => $exists]);
    }

    public function checkMsmeCustomer(Request $request)
{
    $exists = DB::table('customers') 
                ->where('msme', $request->msme_number)
                ->exists();

    return response()->json(['exists' => $exists]);
}

public function checkMsmeSupplier(Request $request)
{
    $exists = DB::table('suppliers') 
                ->where('msme', $request->msme_number)
                ->exists();

    return response()->json(['exists' => $exists]);
}


public function checkMsmeTransporter(Request $request)
{
    $exists = DB::table('transporters') 
                ->where('msme', $request->msme_number)
                ->exists();

    return response()->json(['exists' => $exists]);
}

public function checkMsmeCompany(Request $request)
{
    $exists = DB::table('companies') 
                ->where('msme', $request->msme_number)
                ->exists();

    return response()->json(['exists' => $exists]);
}


  public function add_transporter_dynamic(Request $request){
    
        $lastCompany = DB::table('transporters')->orderBy('transporter_id', 'desc')->where('deleted_at',null)->first();

        if ($lastCompany) {
            $lastIdNumber = (int) substr($lastCompany->transporter_id, 2);
            $newTransporter = 'TR' . str_pad($lastIdNumber + 1, 6, '0', STR_PAD_LEFT);
        } else {
            $newTransporter = 'TR000001';
        }

        $transporter_id = DB::table('transporters')->insertGetId([
            'transporter_id' => $newTransporter,
            'transporter_name' => $request->transporter_name,
            'contact_person' => $request->contact_person,
            'phone1' => $request->phone1,
            'phone2' => $request->phone2 ?? '',
            'email' => $request->email,
            'city' => $request->city,
            'state' => $request->state,
            'pincode' => $request->pincode,
            'address' => $request->address,
            'gst_no' => $request->gst_no,
            'msme' => $request->msme,
        ]);

        $transporter = DB::table('transporters')->where('id', $transporter_id)->first();

        return response()->json([
            'success' => true,
            'transporter' => $transporter,
        ]);
     }


       public function add_supplier_dynamic(Request $request){
         //  dd($request->all());
        $lastCompany = DB::table('suppliers')->orderBy('supplier_id', 'desc')->where('deleted_at',null)->first();

    
        if ($lastCompany) {
            $lastIdNumber = (int) substr($lastCompany->supplier_id, 2); // Get numeric part
            $newSupplierId = 'SP' . str_pad($lastIdNumber + 1, 6, '0', STR_PAD_LEFT); // Increment and format with leading zeros
        } else {
            $newSupplierId = 'SP000001';
        }

        $supplier_id = DB::table('suppliers')->insertGetId([
            'supplier_id' => $newSupplierId,
            'supplier_name' => $request->supplier_name,
            'contact_person' => $request->contact_person,
             'warehouse_id' => implode(',',$request->warehouse_id),
            'phone1' => $request->phone1 ?? '',
            'mobile' => $request->mobile ?? '',
            'email' => $request->email,
              'code' => 91,
            'city' => $request->city,
            'state' => $request->state,
            'pincode' => $request->pincode,
            'address' => $request->address,
            'gst_number' => $request->gst_no,
            'msme' => $request->msme,
        ]);

        $supplier = DB::table('suppliers')->where('id', $supplier_id)->first();

        return response()->json([
            'success' => true,
            'supplier' => $supplier,
        ]);
     }
    

}

