<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Http;



class CatalogController extends Controller
{
    
    public function get_all_brands(){
       
             $default_logo = url('uploads/images.jpeg');
	     $allbrands = DB::table('brands')
		->where('deleted_at', null)
		->where('status', 1)
		->get()
		->map(function($brand) use ($default_logo) {
		 
		    $brand->brand_logo = ($brand->brand_logo && strtolower($brand->brand_logo) != 'null') 
		        ? url('/uploads/brand/' . $brand->brand_logo)
		        : $default_logo;
		    return $brand;
		});
        
            
        return $this->sendResponse($allbrands, 'All Brands get  successfully.');

     }

     

   public function get_all_categories() {
    $default_logo = url('uploads/images.jpg');

    $allcategories = DB::table('categories')
        ->leftJoin('sub_categories', 'categories.id', '=', 'sub_categories.category_id')
        ->whereNull('categories.deleted_at')
        ->where('categories.status', 1)
        ->select(
            'categories.id', 
            'categories.category_name', 
            'categories.status', 
            'categories.image', 
            'categories.created_at', 
            'categories.updated_at', 
            DB::raw('GROUP_CONCAT(sub_categories.id) as subcategory_ids'), 
            DB::raw('GROUP_CONCAT(sub_categories.sub_category_name) as subcategory_names'),
            DB::raw('GROUP_CONCAT(sub_categories.image) as subcategory_images')
        )
        ->groupBy('categories.id')
        ->where('sub_categories.deleted_at',null)
         ->where('categories.deleted_at',null)
        ->get()
        ->map(function($category) use ($default_logo) {
           
            $category->image = ($category->image && strtolower($category->image) != 'null') 
                ? url('/uploads/category/' . $category->image) 
                : $default_logo;

           
            $subcategory_ids = explode(',', $category->subcategory_ids);
            $subcategory_names = explode(',', $category->subcategory_names);
            $subcategory_images = explode(',', $category->subcategory_images);

           
            $category->sub_categories = collect($subcategory_ids)->zip($subcategory_names, $subcategory_images)->map(function ($subCategory) use ($default_logo) {
                return [
                    'id' => $subCategory[0],
                    'sub_category_name' => $subCategory[1],
                    'image' => ($subCategory[2] && strtolower($subCategory[2]) != 'null') 
                        ? url('/uploads/subcategory/' . $subCategory[2]) 
                        : $default_logo
                ];
            });

           
            unset($category->subcategory_ids, $category->subcategory_names, $category->subcategory_images);

            return $category;
        });

    return $this->sendResponse($allcategories, 'All categories retrieved successfully.');
}

    
    
     public function get_transporters(){
    $transporters = DB::table('transporters')
    ->where('status', 1) 
    ->where('deleted_at',null)
    ->get();
      return $this->sendResponse($transporters, 'Transporters retrieved successfully.');
   }
   
   
     public function transporter_details(Request $request){
    $data = $request->all();
    $rules = array(
        'transporter_id' => 'required',
    );

    $validator = Validator::make($data, $rules);
    
    if ($validator->fails()) {
        return $this->sendError($validator->errors()->first());
    } else {
    $transporter = DB::table('transporters')
    ->where('id',$data['transporter_id'])
    ->where('status', 1) 
    ->first();
      return $this->sendResponse($transporter, 'Transporter details get successfully.');
   }
}


public function add_transporter(Request $request){
    $data = $request->all();
   
    $rules = array(
        'transporter_name' => 'required',
        'contact_person' => 'required',
        'email'=>'required',
        'phone1'=>'required',
        'city'=>'required'
    );

    $validator = Validator::make($data, $rules);
    
    if ($validator->fails()) {
        return $this->sendError($validator->errors()->first());
    } else {

        $lastCompany = DB::table('transporters')->orderBy('transporter_id', 'desc')->first();

        if ($lastCompany) {
            $lastIdNumber = (int) substr($lastCompany->transporter_id, 2); 
            $newTransporter = 'TR' . str_pad($lastIdNumber + 1, 6, '0', STR_PAD_LEFT); 
        } else {
            $newTransporter = 'TR000001';
        }

       $transporter_name=$data['transporter_name'];
       $contact_person=$data['contact_person'];
       $email=$data['email'];
       $email=$data['email'];
       $city=$data['city'];
       $phone1=$data['phone1'];
       $phone2=$request->phone2;
        $created_by= auth()->id();

       $transporter=DB::table('transporters')->insertGetId([
        'transporter_name'=>$transporter_name,
        'transporter_id'=>$newTransporter,
        'contact_person'=>$contact_person,
        'email' =>$email,
        'phone1' =>$phone1,
        'phone2' =>$phone2,
        'city'=>$city,
        'status'=>1,
        'created_by'=>$created_by,
        'created_at' =>  date('Y-m-d H:i:s'),
        'updated_at' => date('Y-m-d H:i:s'),
    ]);
    
    $transdata=DB::table('transporters')->where('id',$transporter)->first();

    return $this->sendResponse($transdata, 'Transporter added successfully.');



    }
}

public function update_transporter(Request $request){
    $data = $request->all();
    
    $rules = array(
     'transporter_id' => 'required',
        'transporter_name' => 'required',
        'contact_person' => 'required',
        'email'=>'required',
        'phone1'=>'required',
        'city'=>'required',

    );

    $validator = Validator::make($data, $rules);
    
    if ($validator->fails()) {
        return $this->sendError($validator->errors()->first());
    } else {

        
       $id=$data['transporter_id'];
       $transporter_name=$data['transporter_name'];
       $contact_person=$data['contact_person'];
       $email=$data['email'];
       $email=$data['email'];
       $city=$data['city'];
       $phone1=$data['phone1'];
       $phone2=$data['phone2'];
       $created_by= auth()->id();

       $transporter=DB::table('transporters')->where('id',$id)->update([
        'transporter_name'=>$transporter_name,
        'contact_person'=>$contact_person,
        'email' =>$email,
        'phone1' =>$phone1,
        'phone2' =>$phone2,
        'city'=>$city,
          'created_by'=>$created_by,
        'updated_at' => date('Y-m-d H:i:s'),
    ]);
        $transdata=DB::table('transporters')->where('id',$id)->first();

    return $this->sendResponse($transdata, 'Transporter updated successfully.');



    }
}



public function delete_transporter(Request $request){
    $data = $request->all();
    $rules = array(
        'transporter_id' => 'required',
        

    );

    $validator = Validator::make($data, $rules);
    
    if ($validator->fails()) {
        return $this->sendError($validator->errors()->first());
    } else {

        DB::table('transporters')->where('id',$data['transporter_id'])->update([
            'deleted_at'=>now(),
        ]);

        $datas=DB::table('transporters')->where('id',$data['transporter_id'])->first();
        return $this->sendResponse([], 'Transporter deleted successfully.');

      
    }
}



	public function brandwise_category(Request $request) {
    $data = $request->all();
    $rules = array(
        'brand_id' => 'required',
    );

    $validator = Validator::make($data, $rules);
    
    if ($validator->fails()) {
        return $this->sendError($validator->errors()->first());
    } else {
        // Fetch categories along with their subcategories
        $categories = DB::table('products')
            ->join('categories', 'products.category_id', '=', 'categories.id')
            ->leftJoin('sub_categories', 'categories.id', '=', 'sub_categories.category_id')
            ->where('products.brand_id', $data['brand_id'])
            ->where('products.deleted_at',null)
            ->select(
                'categories.id as id',
                'categories.category_name as category_name',
                'categories.status as status',
                'categories.image as category_image',
                'categories.created_at as created_at',
                'categories.updated_at as updated_at',
                'sub_categories.id as subcategory_id',
                'sub_categories.sub_category_name as sub_category_name',
                'sub_categories.image as subcategory_image'
            )
            ->distinct()
            ->where('categories.deleted_at', null)
            ->where('sub_categories.deleted_at', null)
            ->where('categories.status',1)
            ->get();

        // Structure the response
        $groupedCategories = [];
        foreach ($categories as $category) {
            // Initialize category if it doesn't exist
            if (!isset($groupedCategories[$category->id])) {
                $groupedCategories[$category->id] = [
                    'id' => $category->id,
                    'category_name' => $category->category_name,
                    'status' => $category->status,
                    'image' => url('/uploads/categories/' . $category->category_image),
                    'created_at' => $category->created_at,
                    'updated_at' => $category->updated_at,
                    'sub_categories' => [],
                ];
            }

            // Add subcategory if it exists
            if ($category->subcategory_id) {
                $groupedCategories[$category->id]['sub_categories'][] = [
                    'sub_category_id' => $category->subcategory_id,
                    'sub_category_name' => $category->sub_category_name,
                    'image' => ($category->subcategory_image && strtolower($category->subcategory_image) != 'null') 
                        ? url('/uploads/subcategories/' . $category->subcategory_image)
                        : url('uploads/images.jpg'), // Default image if none provided
                ];
            }
        }

        // Re-index the categories array
        $responseCategories = array_values($groupedCategories);

        return response()->json([
            'success' => true,
            'data' => $responseCategories,
            'status' => 200,
            'message' => 'All categories retrieved successfully.'
        ]);
    }
}

	
public function categorywise_product(Request $request)
{
    $default_logo = url('uploads/images.jpg');
    $data = $request->all();

    $rules = array(
        'category_id' => 'required',
    );

    $validator = Validator::make($data, $rules);

    if ($validator->fails()) {
        return $this->sendError($validator->errors()->first());
    } else {
      $logged_in_user_id = auth()->id();
        $products = DB::table('products')
    ->leftJoin('categories', 'categories.id', '=', 'products.category_id')
    ->leftJoin('units', 'units.id', '=', 'products.unit_id')
    ->leftJoin('pricing', 'products.id', '=', 'pricing.product_id')
    ->leftJoin('wishlist', function ($join) use ($logged_in_user_id) {
        $join->on('products.id', '=', 'wishlist.product_id')
             ->where('wishlist.user_id', '=', $logged_in_user_id)
             ->whereNull('wishlist.deleted_at');
    })
    ->select(
        'products.id as product_id',
        'products.product_name',
        'products.product_code',
         'products.quantityroll',
        
        DB::raw('MAX(products.product_image) as product_image'),
        DB::raw('MAX(categories.category_name) as category_name'),
        DB::raw('MAX(units.unit_name) as unit_name'),
        DB::raw('MAX(pricing.retail_price) as retail_price'),
         DB::raw('MAX(pricing.converted_price) as converted_price'),
          'pricing.converted_price as persqftprice',
        DB::raw('IF(MAX(wishlist.id) IS NOT NULL, 1, 0) as is_in_wishlist'),
    //    DB::raw('CASE 
    //         WHEN products.quantityroll > 0 
    //         THEN CONCAT(FORMAT(MAX(pricing.converted_price) / products.quantityroll, 2), "/", MAX(units.unit_name)) 
    //         ELSE "0" 
    //      END as persqftprice'),
         
        DB::raw('MAX(wishlist.id) as wishlist_id')
    )
    ->where('products.category_id', $data['category_id'])
    ->where('products.deleted_at',null)
     ->where('products.status',1)
    ->groupBy('products.id')
    ->get()
    ->map(function ($product) use ($default_logo) {
        $product->product_image = ($product->product_image && strtolower($product->product_image) != 'null')
            ? url('/uploads/products/' . $product->product_image)
            : $default_logo;
        return $product;
    });

    
        $productCount = DB::table('products')
            ->where('category_id', $data['category_id'])
            ->where('products.status',1)
            ->count();

        if ($productCount > 0) {
            return $this->sendResponse($products, 'Categorywise products retrieved successfully.');
        } else {
            return $this->sendError('Not found');
        }
    }
}


     
   /* public function sub_categorywise_product(Request $request){
        $default_logo = url('uploads/images.jpg');
       $data = $request->all();
		    $rules = array(
			'sub_category_id' => 'required',
		    );

		    $validator = Validator::make($data, $rules);
		    
		    if ($validator->fails()) {
			return $this->sendError($validator->errors()->first());
		    } else {
                $logged_in_user_id = auth()->id();
                $products = DB::table('products')
    ->leftJoin('categories', 'categories.id', '=', 'products.category_id')
    ->join('sub_categories', 'products.sub_category_id', '=', 'sub_categories.id')
    ->leftJoin('units', 'units.id', '=', 'products.unit_id')
    ->leftJoinSub(
        DB::table('pricing')
            ->select('product_id', DB::raw('MAX(retail_price) as retail_price'),'converted_price')
            ->groupBy('product_id','converted_price'),
        'pricing',
        'products.id',
        '=',
        'pricing.product_id'
    )
    ->leftJoinSub(
        DB::table('wishlist')
            ->select('product_id', DB::raw('COUNT(id) as wishlist_count'))
            ->where('user_id', $logged_in_user_id)
            ->whereNull('deleted_at')
            ->groupBy('product_id'),
        'wishlist',
        'products.id',
        '=',
        'wishlist.product_id'
    )
    ->select(
        'products.id as product_id',
        'products.product_name',
        'products.product_code',
        'products.product_image',
        'categories.category_name',
        'sub_categories.sub_category_name',
        'units.unit_name',
        'pricing.retail_price',
        'pricing.converted_price',
        DB::raw('IF(wishlist.wishlist_count > 0, 1, 0) as is_in_wishlist')
    )
    ->where('products.sub_category_id', $data['sub_category_id'])
     ->where('products.deleted_at',null)
     ->where('products.status',1)
    ->get()
    ->map(function ($product) use ($default_logo) {
        $product->product_image = ($product->product_image && strtolower($product->product_image) != 'null') 
            ? url('/uploads/products/' . $product->product_image)
            : $default_logo;
        return $product;
    });


		
			$productCount = DB::table('products')
			    ->where('sub_category_id', $data['sub_category_id'])
			    ->join('sub_categories', 'products.sub_category_id', '=', 'sub_categories.id')
			    ->where('products.status',1)
			    ->count();
			    

			if($productCount > 0){
			    return $this->sendResponse($products, 'Sub categorywise products retrieved successfully.');
			} else {
			    return $this->sendError('Not found');
			}
		    }
    }*/
    
    
    public function sub_categorywise_product(Request $request)
{
    $default_logo = url('uploads/images.jpg');
    $data = $request->all();

    $rules = array(
        'sub_category_id' => 'required',
    );

    $validator = Validator::make($data, $rules);

    if ($validator->fails()) {
        return $this->sendError($validator->errors()->first());
    } else {
        $logged_in_user_id = auth()->id();

        $products = DB::table('products')
            ->leftJoin('categories', 'categories.id', '=', 'products.category_id')
            ->join('sub_categories', 'products.sub_category_id', '=', 'sub_categories.id')
            ->leftJoin('units', 'units.id', '=', 'products.unit_id')
            ->leftJoinSub(
                DB::table('pricing')
                    ->select('product_id', DB::raw('MAX(retail_price) as retail_price'), DB::raw('MAX(converted_price) as converted_price'))
                    ->groupBy('product_id'),
                'pricing',
                'products.id',
                '=',
                'pricing.product_id'
            )
            ->leftJoinSub(
                DB::table('wishlist')
                    ->select(
                        'product_id',
                        DB::raw('MAX(id) as wishlist_id'), 
                        DB::raw('COUNT(id) as wishlist_count')
                    )
                    ->where('user_id', $logged_in_user_id)
                    ->whereNull('deleted_at')
                    ->groupBy('product_id'),
                'wishlist',
                'products.id',
                '=',
                'wishlist.product_id'
            )
            ->select(
                'products.id as product_id',
                'products.product_name',
                'products.product_code',
                'products.product_image',
                'products.quantityroll',
                'categories.category_name',
                'sub_categories.sub_category_name',
                'units.unit_name',
               
                DB::raw('IFNULL(pricing.retail_price, 0) as retail_price'),
                DB::raw('IFNULL(pricing.converted_price, 0) as converted_price'),
                 'pricing.converted_price as persqftprice',
                DB::raw('IFNULL(MAX(wishlist.wishlist_id), 0) as wishlist_id'), // Used MAX()
                DB::raw('IF(MAX(wishlist.wishlist_count) > 0, 1, 0) as is_in_wishlist'), // Used MAX()
        //         DB::raw('CASE 
        //     WHEN products.quantityroll > 0 
        //     THEN CONCAT(FORMAT(MAX(pricing.converted_price) / products.quantityroll, 2), "/", MAX(units.unit_name)) 
        //     ELSE "0" 
        //  END as persqftprice'),
        //     )
            
            )
            ->where('products.sub_category_id', $data['sub_category_id'])
            ->whereNull('products.deleted_at')
            ->where('products.status', 1)
            ->groupBy(
                'products.id',
                'products.product_name',
                'products.product_code',
                'products.product_image',
                'categories.category_name',
                'sub_categories.sub_category_name',
                'units.unit_name',
                'pricing.retail_price',
                'pricing.converted_price'
            ) // Ensured all fields are included
            ->get()
            ->map(function ($product) use ($default_logo) {
                $product->product_image = ($product->product_image && strtolower($product->product_image) != 'null')
                    ? url('/uploads/products/' . $product->product_image)
                    : $default_logo;
                return $product;
            });

        $productCount = DB::table('products')
            ->where('sub_category_id', $data['sub_category_id'])
            ->join('sub_categories', 'products.sub_category_id', '=', 'sub_categories.id')
            ->where('products.status', 1)
            ->count();

        if ($productCount > 0) {
            return $this->sendResponse($products, 'Sub category-wise products retrieved successfully.');
        } else {
            return $this->sendError('Not found');
        }
    }
}


    
    
     public function address_list(Request $request){
        $userId = auth()->id();
        if (!$userId) {
            return response()->json(['message' => 'User not authenticated'], 401);
        }
        $customer_addresses = DB::table('customer_addresses')
        ->whereNull('deleted_at')
        ->where('customer_id', $userId)
        ->get();
    
        $filteredAddress = $customer_addresses->map(function ($address) {
        return collect($address)->except(['created_at', 'updated_at', 'deleted_at']);
        });
    
      
        if($filteredAddress->isEmpty()){
           
            return $this->sendResponse([], 'No address found');
            
        }else{
            return $this->sendResponse($filteredAddress, 'All addresses retrieved successfully.');
        }

        
      }


      public function add_address(Request $request){
        $userId = auth()->id();
        if (!$userId) {
            return response()->json(['message' => 'User not authenticated'], 401);
        }

        $data = $request->all();
        $rules = array(
        'full_name' => 'required',
        'email' => 'required',
        'phone_number' => 'required',
        'address1' => 'required',
        'state' => 'required',
        'city' => 'required',
        'pincode' => 'required',
        );

        $validator = Validator::make($data, $rules);
        
        if ($validator->fails()) {
        return $this->sendError($validator->errors()->first());
        } else {
            $dats=DB::table('customer_addresses')->insertGetId([
                  'customer_id' => $userId ,
                  'full_name'=>$data['full_name'],
                  'email'=>$data['email'],
                  'phone_no'=>$data['phone_number'],
                  'address1'=>$data['address1'],
                  'address2'=>$data['address2'],
                  'state'=>$data['state'],
                  'city'=>$data['city'],
                  'pincode'=>$data['pincode'],
                   'created_at'=>date('Y-m-d H:i:s'),
                  'updated_at'=>date('Y-m-d H:i:s')
            ]);

            $address=DB::table('customer_addresses')->where('id',$dats)->first();
            $filteredAddress = collect($address)->except(['created_at', 'updated_at', 'deleted_at']);

            return $this->sendResponse($filteredAddress, 'Addresse added successfully.');

        }

      }
      
      
      public function delete_address(Request $request){
     
	      $userId = auth()->id();
		if (!$userId) {
		    return response()->json(['message' => 'User not authenticated'], 401);
		}
		
		 $data = $request->all();
			$rules = array(
			'address_id' => 'required',
			);

		$validator = Validator::make($data, $rules);
		
		if ($validator->fails()) {
		return $this->sendError($validator->errors()->first());
		} else {
        
	         $address_id=$data['address_id'];
	       
		 DB::table('customer_addresses')->where('id',$address_id)->update([
		     'deleted_at'=>now(),
		]);
		 return $this->sendResponse([], 'Address deleted successfully.');
	     }
      
      }

      public function pickup_points(){
    $pickups=DB::table('warehouses')->select('warehouse_name','city','address')->where('deleted_at',null)->get();
     if($pickups->isEmpty()){
       return $this->sendError('No data found');
     }else{
         return $this->sendResponse($pickups, 'Pickup Points get successfully.');
     }

            
      }
      
      
      public function coupons(){
    $default_logo = url('uploads/images.jpg');
    $coupons=DB::table('coupons')->select('id as coupon_id','coupon_code','discount_type','discount_value','start_date','end_date','title','description','coupon_image')
    ->where('deleted_at',null)->where('is_active',1)->whereDate('end_date', '>=', now())->get()->map(function($coupon) use ($default_logo) {
        
        $coupon->coupon_image = ($coupon->coupon_image && strtolower($coupon->coupon_image) != 'null') 
            ? url('/uploads/coupons/' . $coupon->coupon_image)
            : $default_logo;
        return $coupon;
    });
         if($coupons->isEmpty()){
           return $this->sendError('No data found');
         }else{
             return $this->sendResponse($coupons, 'Coupons get successfully.');
         }
   }
   
   
public function applyCoupon(Request $request)
{
    $user = auth()->user(); 

    if (!$user) {
        return $this->sendError('Unauthorized', 401);
    }

    $request->validate([
        'coupon_code' => 'required|string',
        'total_amount' => 'required|numeric',
    ]);

    if ($request->total_amount <= 0) {
        return $this->sendError('Coupon cannot be applied to amount less than or equal to zero.');
    }

   
    $coupon = DB::table('coupons')
        ->where('coupon_code', $request->coupon_code)
        ->where('deleted_at', null)
        ->whereDate('start_date', '<=', now())
        ->whereDate('end_date', '>=', now())
        ->first();
       // dd($coupon);

    if (!$coupon) {
        return $this->sendError('Invalid or expired coupon.');
    }

    $discountAmount = 0;

    if ($coupon->discount_type === 'percentage') {
        
        $discountAmount = ($request->total_amount * $coupon->discount_value) / 100;
    } elseif ($coupon->discount_type === 'fixed') {
       
        $discountAmount = $coupon->discount_value;
    }

    $finalAmount = $request->total_amount - $discountAmount;

    
    DB::table('user_coupons')->updateOrInsert(
        ['user_id' => $user->id],
        [
            'coupon_id' => $coupon->id,
            'coupon_code' => $coupon->coupon_code,
            'discount_amount' => $discountAmount,
            'final_amount' => $finalAmount,
            'applied_at' => now()
        ]
    );

    return $this->sendResponse([
        'user_id' => $user->id,
        'coupon_id' => $coupon->id,
        'coupon_code' => $coupon->coupon_code,
        'discount_type' => $coupon->discount_type,
        'discount_value' => $coupon->discount_value,
        'discount_amount' => $discountAmount,
        'final_amount' => $finalAmount
    ], 'Coupon applied successfully.');
}




    public function removeCoupon(Request $request)
{
    $user = auth()->user(); 

    if (!$user) {
        return $this->sendError('Unauthorized', 401);
    }

    
    $appliedCoupon = DB::table('user_coupons')->where('user_id', $user->id)->first();

    if (!$appliedCoupon) {
        return $this->sendError('No coupon applied for this user.');
    }

    
    DB::table('user_coupons')->where('user_id', $user->id)->delete();

    return $this->sendResponse([], 'Coupon removed successfully.');
}

    
   
   public function update_location(Request $request){
    $data = $request->all();
   //dd($data);
    $rules = array(
        'latitude' => 'required',
        'longitude' => 'required',
    );

    $validator = Validator::make($data, $rules);
    
        if ($validator->fails()) {
            return $this->sendError($validator->errors()->first());
        } else {

        $locationid=DB::table('customer_locations')->insertGetId([
            'customer_id'=>Auth::user()->id,
            'latitude'=>$data['latitude'],
            'longitude'=>$data['longitude'],
            'created_at'=>date('Y-m-d H:i:s'),
            'updated_at'=>date('Y-m-d H:i:s')
        ]);
        $location=DB::table('customer_locations')->where('id',$locationid)->first();
        return $this->sendResponse($location, 'Location added successfully.');

    }
   }

	
	
	

public function get_current_location(Request $request)
{
    $lat = $request->lat;
    $lng = $request->long;

    $apiKey = env('GOOGLE_MAPS_API_KEY');
    //dd($apiKey);
    $url = "https://maps.googleapis.com/maps/api/geocode/json?latlng=$lat,$lng&key=$apiKey";

    $response = Http::get($url);
    $data = $response->json();

    if ($data['status'] === 'OK') {
        $result = $data['results'][0];
        $address = $result['formatted_address'];
        $components = $result['address_components'];

        $city = $state = $country = $pincode = null;

        foreach ($components as $component) {
            $types = $component['types'];

            if (in_array('locality', $types)) {
                $city = $component['long_name'];
            }
            if (in_array('administrative_area_level_1', $types)) {
                $state = $component['long_name'];
            }
            if (in_array('country', $types)) {
                $country = $component['long_name'];
            }
            if (in_array('postal_code', $types)) {
                $pincode = $component['long_name'];
            }
        }

        $location = [
            'address'  => $address,
            'city'     => $city,
            'state'    => $state,
            'country'  => $country,
            'pincode'  => $pincode,
        ];

        return $this->sendResponse($location, 'Location added successfully.');
    }

    return $this->sendError('Unable to fetch location details.');
}

 


  /*  public function calculateDistance(Request $request)
    {
        $request->validate([
            'origin' => 'required|string',
            'destination' => 'required|string',
            'mode' => 'nullable|string|in:driving,walking,bicycling,transit', 
        ]);

        $origin = $request->input('origin');
        $destination = $request->input('destination');
        $mode = $request->input('mode', 'driving'); 
        $apiKey = env('GOOGLE_MAPS_API_KEY');

        // Call the Google Distance Matrix API
        $response = Http::get("https://maps.googleapis.com/maps/api/distancematrix/json", [
            'origins' => $origin,
            'destinations' => $destination,
            'mode' => $mode,
            'key' => $apiKey,
        ]);

        
        if ($response->failed()) {
            return response()->json(['error' => 'Failed to fetch distance and time'], 500);
        }

        $data = $response->json();

        if (empty($data['rows'][0]['elements'][0]) || $data['rows'][0]['elements'][0]['status'] !== 'OK') {
            return response()->json(['error' => 'Invalid origin or destination'], 400);
        }

        $element = $data['rows'][0]['elements'][0];

        $distance = $element['distance']['text']; 
        $distanceValue = $element['distance']['value']; 
        $duration = $element['duration']['text'];  
        $durationValue = $element['duration']['value']; 

        return response()->json([
            'origin' => $origin,
            'destination' => $destination,
            'mode' => $mode,
            'distance' => $distance,
            'distance_km' => round($distanceValue / 1000, 2), 
            'duration' => $duration,
            'duration_minutes' => round($durationValue / 60, 2), 
        ]);
    }*/
    
    public function calculateDistance(Request $request)
{
    $request->validate([
        'origin_lat' => 'required|numeric',
        'origin_lng' => 'required|numeric',
        'destination_lat' => 'required|numeric',
        'destination_lng' => 'required|numeric',
        'mode' => 'nullable|string|in:driving,walking,bicycling,transit', 
    ]);

    // Extract inputs
    $originLat = $request->input('origin_lat');
    $originLng = $request->input('origin_lng');
    $destinationLat = $request->input('destination_lat');
    $destinationLng = $request->input('destination_lng');
    $mode = $request->input('mode', 'driving'); 
    $apiKey = env('GOOGLE_MAPS_API_KEY');

    // Construct origin and destination as lat,lng
    $origin = "$originLat,$originLng";
    $destination = "$destinationLat,$destinationLng";

    // Call the Google Distance Matrix API
    $response = Http::get("https://maps.googleapis.com/maps/api/distancematrix/json", [
        'origins' => $origin,
        'destinations' => $destination,
        'mode' => $mode,
        'key' => $apiKey,
    ]);

    if ($response->failed()) {
        return response()->json(['error' => 'Failed to fetch distance and time'], 500);
    }

    $data = $response->json();

    if (empty($data['rows'][0]['elements'][0]) || $data['rows'][0]['elements'][0]['status'] !== 'OK') {
        return response()->json(['error' => 'Invalid origin or destination'], 400);
    }

    $element = $data['rows'][0]['elements'][0];

    $distance = $element['distance']['text']; 
    $distanceValue = $element['distance']['value']; 
    $duration = $element['duration']['text'];  
    $durationValue = $element['duration']['value']; 

    return response()->json([
        'origin' => $origin,
        'destination' => $destination,
        'mode' => $mode,
        'distance' => $distance,
        'distance_km' => round($distanceValue / 1000, 2), 
        'duration' => $duration,
        'duration_minutes' => round($durationValue / 60, 2), 
    ]);
}


   
   
   
}
