<?php 

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Http;


class OrderController extends Controller
{

   public function order_save(Request $request)
{
    $data = $request->all();
   
    $order_amount = '';
    $rules = [
        'company_id' => 'required',
        'order_items' => 'required|array',
        'order_items.*.product_id' => 'required',
        'order_items.*.varient_id' => 'required',
        'order_items.*.qty' => 'required',
        'order_items.*.price' => 'required',
    ];

    $validator = Validator::make($data, $rules);
    if ($validator->fails()) {
        return response()->json(['error' => $validator->errors()->first()], 400);
    }

    try {
        DB::beginTransaction();

         $lastCompany = DB::table('orders')
	    ->whereNull('deleted_at')
	    ->orderBy('order_code', 'desc')
	    ->first();

	if ($lastCompany) {
	    $lastIdNumber = (int) substr($lastCompany->order_code, 3); // Extract numeric part correctly
	    $newId = 'ORD' . str_pad($lastIdNumber + 1, 5, '0', STR_PAD_LEFT);
	} else {
	    $newId = 'ORD00001';
	}

        $order_amount = collect($request->order_items)->reduce(function ($total, $item) {
         
           return $total + ($item['price']);
         //  return $total + ($item['qty'] * $persqftprice);
            
        }, 0);
        
        
   
         $customers = DB::table('customers')->where('id', auth()->id())->first();

	 $cpercentage = $customers->customer_discount ?? 0;

	
	$discountAmount = is_numeric($request->discount_amount) ? $request->discount_amount : 0;//coupon discount
	$additional_discountAmount = is_numeric($request->additional_discount) ? $request->additional_discount : 0;//additional discount


	$grandTotal = $order_amount - $discountAmount - $additional_discountAmount;

	
        $orderId = DB::table('orders')->insertGetId([
            'order_code' => $newId,
            'company_id' => $request->company_id,
            'customer_id' => auth()->id(),
            'order_date' => date('Y-m-d'),
            'order_amount' => round($order_amount,2),
            'subtotal' => round($order_amount,2),
            'tax_percent' => 0.00,
            'tax' => 0.00,
            'grandtotal' => round($grandTotal,2),
            'discount'=> round($discountAmount, 2),
            'order_type' => $request->order_type,
            'pickup_point' => $request->pickup_point,
            'address_id' => $request->address_id,
            'payment_method' => 'Cash On Delivery',
            'discount_percentage' => round($cpercentage, 2),
            'customer_discount_amount' =>  round($additional_discountAmount, 2),
            'order_from'=> 1,
            'status' => 'Ordered',
            'created_at' => now(),
            'updated_at' => now(),
        ]);

       
        foreach ($request->order_items as $item) {
        
         $datas = DB::table('products')->where('id', $item['product_id'])->first();
         // Calculate per square foot price
        $persqftprice = ($datas->quantityroll > 0) ? ($item['price'] / $datas->quantityroll) : 0;
        $unitdata=DB::table('products')->where('id', $item['product_id'])->first();
       // $carts = DB::table('carts')->where('varient_id', $item['varient_id'])->where('user_id',auth()->id())->first();
        //$warehouseId = $request->pickup_point 
         // ?? ($carts->warehouse_id ?: 4);

         //$wrhs=DB::table('warehouses')->where('warehouse_name',$item['warehouse_id'])->first();

	    $orderItemId = DB::table('order_items')->insertGetId([
		'order_id' => $orderId,
		'product_id' => $item['product_id'],
		'varient_id' => $item['varient_id'],
		'quantity' => $item['qty'],
		'price' => $item['price'],
        'uom' => $unitdata->unit_id,
         'warehouse_id' => 4,
		//'price'=>$persqftprice,
		'created_at' => now(),
		'updated_at' => now(),
	    ]);

    
         }

        DB::table('track_orders')->insert([
            'order_id' => $orderId,
            'status' => 'Ordered',
            'created_at' => now(),
        ]);

        // Process Rolls for Order Mapping
        foreach ($request->order_items as $item) {
        
         $datasnew = DB::table('products')->where('id', $item['product_id'])->first();
         // Calculate per square foot price
      //  $persqftpricedata = ($datasnew->quantityroll > 0) ? ($item['price'] / $datasnew->quantityroll) : 0;
         $persqftpricedata = $item['price'];
            $varientId = $item['varient_id'];
            $requiredQuantity = $item['qty'];
            $totalUsed = 0;

            $rolldata = DB::table('rolls')
                ->where('varient_id', $varientId)
                ->where('availability', '>', 0)
                  ->where('defective_status',0)
                ->orderBy('availability', 'desc')
                ->get();

            foreach ($rolldata as $row) {
                if ($totalUsed >= $requiredQuantity) break;

                $remainingToRemove = $requiredQuantity - $totalUsed;
                $usedQty = min($row->availability, $remainingToRemove);
                $newAvailability = $row->availability - $usedQty;
                 $roll_price=$persqftpricedata*$usedQty;
                DB::table('order_roll_mapping')->insert([
                    'roll_id' => $row->id,
                    'customer_id' => auth()->id(),
                    'order_id' => $orderId,
                    'order_item_id' =>$orderItemId,
                    'installer_id' => null,
                    'installer_status' => 'Measurement',
                    'order_receipt' => null,
                    'total_quantity' => $row->quantity,
                    'used_quantity' => $usedQty,
                    'available_quantity' => $newAvailability,
                    'roll_price'=>$roll_price,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);

                DB::table('rolls')->where('id', $row->id)->update([
                    'availability' => $newAvailability,
                    'remark' => ($newAvailability == 0) ? 'sold' : 'partial sold',
                    'updated_at' => now(),
                ]);

                $totalUsed += $usedQty;
            }
        }

        $varient_ids = collect($request->order_items)->pluck('varient_id')->toArray();
        DB::table('carts')->where('user_id', auth()->id())->whereIn('varient_id', $varient_ids)->delete();
        DB::table('wishlist')->where('user_id', auth()->id())->whereIn('varient_id', $varient_ids)->delete();

        DB::commit();
        
        
        
        
               /*  $senderadmin = 'info@rush.speakwise.site';
		// $recieveradmin = $customer->email;
		$recieveradmin = 'rushikeshwakde.oms@gmail.com';
		$fromNameadmin = 'Floor Factory';

		$orders = DB::table('orders')
		    ->join('companies', 'orders.company_id', '=', 'companies.id')
		    ->join('customers', 'orders.customer_id', '=', 'customers.id')
		    ->select('orders.*', 'companies.company_name', 'customers.customer_name', 'customers.email as customer_email', 'companies.email as company_email') // Added company & customer emails
		    ->where('orders.id', $OrderId)
		    ->first(); // Use `get()` if expecting multiple orders

		if ($orders) {
		    // Send email to Customer
		    Mail::send('emails.order_customer_email', ['orders' => $orders], function ($message) use ($orders, $senderadmin, $fromNameadmin) {
			$message->to($orders->customer_email) // Sending to the customer
			    ->subject('Your Order Confirmation')
			    ->from($senderadmin, $fromNameadmin);
		    });

		    // Send email to Company
		    Mail::send('emails.order_company_email', ['orders' => $orders], function ($message) use ($orders, $senderadmin, $fromNameadmin) {
			$message->to($orders->company_email) // Sending to the company
			    ->subject('New Order Received')
			    ->from($senderadmin, $fromNameadmin);
		    });

		    // Send email to Admin
		    Mail::send('emails.order_admin_email', ['orders' => $orders], function ($message) use ($recieveradmin, $senderadmin, $fromNameadmin) {
			$message->to($recieveradmin) // Sending to Admin
			    ->subject('New Order Notification')
			    ->from($senderadmin, $fromNameadmin);
		    });
		}*/
		
        return response()->json(['success' => true, 'message' => 'Order and items saved successfully.'], 201);
    } catch (\Exception $e) {
        DB::rollBack();
        return response()->json(['error' => 'Failed to save order: ' . $e->getMessage()], 500);
    }
}




     
    public function order_list()
{
    $customer_id = auth()->id();
    $default_logo = url('uploads/images.jpg');
    $apiKey = env('GOOGLE_MAPS_API_KEY');

    $orders = DB::table('orders')
        ->where('orders.customer_id', $customer_id)
        ->leftJoin(DB::raw('(SELECT order_id, COUNT(*) as order_items FROM order_items GROUP BY order_id) as oi'), 'orders.id', '=', 'oi.order_id')
        ->leftJoin('warehouses', 'orders.pickup_point', '=', 'warehouses.id')
        ->select(
            'orders.id as order_id',
            'orders.order_code',
            'orders.order_type',
            'orders.order_date',
            'orders.order_amount',
            'orders.status',
            'orders.grandtotal',
            'orders.address_id',
            'orders.payment_method',
            'orders.payment_status',
            DB::raw('IFNULL(oi.order_items, 0) as order_item_count'),
            'warehouses.id as pickup_id',
            'warehouses.warehouse_name as pickup_point',
            'warehouses.address as pickup_address',
            'warehouses.open_time',
            'warehouses.close_time'
        )
        ->orderBy('orders.id', 'desc')
        ->get();

    foreach ($orders as $order) {
        // ✅ Check if pickup address exists before hitting the Google API
        if (!empty($order->pickup_address)) {
            $geoResponse = Http::get("https://maps.googleapis.com/maps/api/geocode/json", [
                'address' => $order->pickup_address,
                'key' => $apiKey
            ]);

            $geoData = $geoResponse->json();

            if (isset($geoData['status']) && $geoData['status'] === 'OK') {
                $order->lat = (float) $geoData['results'][0]['geometry']['location']['lat'];
                $order->lng = (float) $geoData['results'][0]['geometry']['location']['lng'];
            } else {
                $order->lat = null;
                $order->lng = null;
            }
        } else {
            $order->lat = null;
            $order->lng = null;
        }

        // ✅ Fetch order items
        $order->order_items = DB::table('order_items')
            ->join('products', 'products.id', '=', 'order_items.product_id')
            ->leftJoin('product_variant', 'product_variant.id', '=', 'order_items.varient_id')
            ->leftJoin('warehouse_products', function ($join) use ($order) {
                $join->on('products.id', '=', 'warehouse_products.product_id')
                    ->where('warehouse_products.warehouse', '=', $order->pickup_id);
            })
            ->where('order_items.order_id', $order->order_id)
            ->select(
                'order_items.order_id as id',
                'products.id as product_id',
                'products.product_name',
                'product_variant.id as varient_id',
                'product_variant.varient_name',
                'product_variant.varient_image',
                'order_items.quantity',
                'order_items.price',
                'warehouse_products.warehouse as warehouse_id'
            )
            ->get()
            ->map(function ($item) use ($default_logo) {
                $item->varient_image = $item->varient_image
                    ? url('uploads/products/' . $item->varient_image)
                    : $default_logo;
                return $item;
            });
    }

    if ($orders->isEmpty()) {
        return $this->sendResponse([], 'No orders found.');
    }

    return $this->sendResponse($orders, 'Order list retrieved successfully.');
}





     public function view_order(Request $request)
     {
         $data = $request->all();
         $order_id = $request->order_id;
         $default_logo = url('uploads/images.jpg');
     
         $rules = [
             'order_id' => 'required',
         ];
     
         $validator = Validator::make($data, $rules);
         if ($validator->fails()) {
             return response()->json(['error' => $validator->errors()->first()], 400);
         }
     
         // Fetch the order details
         $orderDetails = DB::table('orders')
             ->join('customers', 'customers.id', '=', 'orders.customer_id')
             ->where('orders.id', $order_id)
             ->select('orders.id as order_id', 'orders.order_code','orders.order_type','orders.pickup_point', 'orders.order_date', 'customers.customer_name','orders.order_amount', 'orders.status','orders.grandtotal','orders.address_id','orders.payment_method','orders.payment_status')
             ->first();
     
         if (!$orderDetails) {
             return response()->json(['error' => 'Order not found.'], 404);
         }
         
         if ($orderDetails->status === 'Pending') {
        $orderDetails->status = 'Ordered';
    }
     
         // Fetch the order items
         $orderItems = DB::table('order_items')
             ->join('products', 'products.id', '=', 'order_items.product_id')
             ->leftJoin('product_variant', 'product_variant.id', '=', 'order_items.varient_id')
             ->where('order_items.order_id', $order_id)
             ->select('order_items.id as order_id', 'products.product_name', 'product_variant.varient_name', 'product_variant.varient_image','order_items.quantity','order_items.price')
             ->get()
             ->map(function ($variant) use ($default_logo) {
                 $variant->varient_image = $variant->varient_image
                     ? url('uploads/products/' . $variant->varient_image)
                     : $default_logo;
                 return $variant;
             });
             
             $ordertracks=DB::table('track_orders')->select('id','order_id','status as order_status','created_at','message')->where('order_id',$order_id)->get();
     
         // Combine order details and order items
         $response = [
             'order_details' => $orderDetails,
             'order_items' => $orderItems,
             'order_track' => $ordertracks
         ];
     
         return $this->sendResponse($response, 'Order retrieved successfully.');
     }
     
     
        public function order_again(Request $request) {
	    $order_id = $request->order_id;
	    
	    $orders = DB::table('orders')->where('id', $order_id)->where('status','Delivered')->first();
	    if (!$orders) {
		return response()->json(['error' => 'Order is not completed '], 404);
	    }

	    $order_items = DB::table('order_items')->where('order_id', $order_id)->get();

	   
	    $lastCompany = DB::table('orders')
		->whereNull('deleted_at')
		->orderBy('order_code', 'desc')
		->first();

	    if ($lastCompany) {
		$lastIdNumber = (int) substr($lastCompany->order_code, 3); 
		$newId = 'ORD' . str_pad($lastIdNumber + 1, 5, '0', STR_PAD_LEFT);
	    } else {
		$newId = 'ORD00001';
	    }
            
           // dd($order_items);
	   
	    $orderId = DB::table('orders')->insertGetId([
		'order_code' => $newId,
		'company_id' => $orders->company_id,
		'customer_id' => $orders->customer_id,
		'order_date' => $orders->order_date,
		'order_amount' => $orders->order_amount,
		'tax_percent' => $orders->tax_percent,
		'transporter_id'=>$orders->transporter_id,
		'subtotal'=>$orders->subtotal,
		'tax' => $orders->tax,
		'grandtotal' => $orders->grandtotal,
		'status' => $orders->status,
		'created_at' => now(),
		'updated_at' => now(),
	    ]);

	   
	    if (!$order_items->isEmpty()) {
		$orderItems = [];
		foreach ($order_items as $item) {
		    $orderItems[] = [
		        'order_id' => $orderId,
		        'product_id' => $item->product_id,
		        'varient_id' => $item->varient_id, 
		        'quantity' => $item->quantity, 
		        'price' => $item->price, 
		        'total' => $item->total, 
		        'created_at' => now(),
		        'updated_at' => now(),
		    ];
		}
		DB::table('order_items')->insert($orderItems);
	    }

	    // Insert tracking data
	    DB::table('track_orders')->insert([
		'order_id' => $orderId,
		'status' => 'Ordered',
		'message' => 'Your order has been placed',
		'created_at' => now(),
	    ]);

	    return response()->json(['success' => 'Order placed again successfully', 'order_code' => $newId], 201);
	    
	}


}
  
