<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Http;


class ProductController extends Controller
{
    
     public function get_all_products(){
       // $allproducts=DB::table('products')->where('deleted_at',null)->where('status',1)->get();
             $default_logo = url('uploads/images.jpeg');
        $allproducts = DB::table('products')
        ->leftJoin('categories', 'categories.id', '=', 'products.category_id')
        ->leftJoin('sub_categories', 'sub_categories.id', '=', 'products.sub_category_id')
        ->leftJoin('brands', 'brands.id', '=', 'products.brand_id')
        ->leftJoin('units', 'units.id', '=', 'products.unit_id')
        ->leftJoin('companies', 'companies.id', '=', 'products.company_id')
        ->leftJoin('suppliers', 'suppliers.id', '=', 'products.supplier_id')
        ->leftJoin('warehouses', 'warehouses.id', '=', 'products.warehouse_id')
        ->select(
            'products.*', 
            'categories.category_name',
            'sub_categories.sub_category_name',
            'brands.brand_name',
            'units.unit_name',
            'companies.company_name',
            'suppliers.supplier_name',
            'warehouses.warehouse_name'
        )
        ->where('products.deleted_at', null)
        ->get()
         ->map(function($product) use ($default_logo) {
             
          $product->product_image = $product->product_image 
              ? url('uploads/products/' . $product->product_image) 
              : url($default_logo);
          return $product;
      });
    
                     
        return $this->sendResponse($allproducts, 'All Products get  successfully.');
     }

     
 /*public function product_details(Request $request)
     {
         $data = $request->all();
     
         $rules = array(
             'product_id' => 'required',
         );
     
         $validator = Validator::make($data, $rules);
     
         if ($validator->fails()) {
             return $this->sendError($validator->errors()->first());
         } else {
             $default_logo = url('uploads/images.jpg');
             
             // Fetch product details
             $product = DB::table('products')
                 ->leftJoin('categories', 'categories.id', '=', 'products.category_id')
                 ->leftJoin('sub_categories', 'sub_categories.id', '=', 'products.sub_category_id')
                 ->leftJoin('brands', 'brands.id', '=', 'products.brand_id')
                 ->leftJoin('units', 'units.id', '=', 'products.unit_id')
                 ->leftJoin('companies', 'companies.id', '=', 'products.company_id')
                 ->leftJoin('suppliers', 'suppliers.id', '=', 'products.supplier_id')
                 ->leftJoin('warehouses', 'warehouses.id', '=', 'products.warehouse_id')
                 ->select(
                     'products.*',
                     'categories.category_name',
                     'sub_categories.sub_category_name',
                     'brands.brand_name',
                     'units.unit_name',
                     'companies.company_name',
                     'suppliers.supplier_name',
                     'warehouses.warehouse_name'
                 )
                 ->where('products.id', $data['product_id'])
                 ->where('products.deleted_at', null)
                 ->first();
     
             if (!$product) {
                 return $this->sendError('Product not found.');
             }
     
             // Strip HTML tags from description and technical details
             $product->description = strip_tags($product->description);
             $product->technical_details = strip_tags($product->technical_details);
     
             // Set the full path for the product image or default if not found
             if ($product->product_image) {
                 $product->product_image = url('products/uploads/' . $product->product_image);
             } else {
                 $product->product_image = $default_logo;
             }
     
             // Fetch pricing details with unit names
             $pricing = DB::table('pricing')
                 ->leftJoin('units as landing_cost_unit', 'landing_cost_unit.id', '=', 'pricing.landing_cost_unit')
                 ->leftJoin('units as wholesale_price_unit', 'wholesale_price_unit.id', '=', 'pricing.wholesale_price_unit')
                 ->leftJoin('units as retail_price_unit', 'retail_price_unit.id', '=', 'pricing.retail_price_unit')
                 ->leftJoin('units as mrp_unit', 'mrp_unit.id', '=', 'pricing.mrp_unit')
                 ->leftJoin('units as cutting_rate_unit', 'cutting_rate_unit.id', '=', 'pricing.cutting_rate_unit')
                 ->select(
                     'pricing.*',
                     'landing_cost_unit.unit_name as landing_cost_unit_name',
                     'retail_price_unit.unit_name as retail_price_unit_name',
                     'wholesale_price_unit.unit_name as wholesale_price_unit_name',
                     'mrp_unit.unit_name as mrp_unit_name',
                     'cutting_rate_unit.unit_name as cutting_rate_unit_name'
                 )
                 ->where('pricing.product_id', $data['product_id'])
                 ->first();
     
            
             $product_images = DB::table('product_images')
                 ->where('product_id', $data['product_id'])
                 ->pluck('image')->toArray();
     
             
             $product_images = array_map(function($image) use ($default_logo) {
                 return url('products/uploads/' . $image) ?: $default_logo; 
             }, $product_images);
     
            
             $warehouses = DB::table('warehouse_products')
                 ->leftJoin('warehouses', 'warehouses.id', '=', 'warehouse_products.warehouse')
                 ->where('warehouse_products.product_id', $data['product_id'])
                 ->select('warehouses.warehouse_name', 'warehouse_products.cost_price')
                 ->get();
                 
                  $variants = DB::table('product_variant')
                 ->where('product_id', $data['product_id'])
                ->select('id as varient_id','varient_code','varient_name','varient_image','varient_color')
                 ->get();
     
            
             foreach ($variants as $variant) {
                 if ($variant->varient_image) {
                     $variant->varient_image = url('products/uploads/' . $variant->varient_image);
                 } else {
                     $variant->varient_image = $default_logo; // Set default if no image exists
                 }
             }
     
     
             
             $product->images = $product_images;
             $product->pricing = $pricing;
             $product->warehouses = $warehouses;
             $product->variants = $variants;
             
             unset(
                 $product->colors,
                 $product->price,
                 $product->warehouse_id,
                 $product->company_id,
                 $product->supplier_id,
                 $product->brand_id,
                 $product->unit_id,
                 $product->category_id,
                 $product->sub_category_id,
                 $product->deleted_at,
                 $product->warehouse_name
             );
     
            
             if ($product->pricing) {
                 unset(
                     $product->pricing->product_variant_id,
                     $product->pricing->landing_cost_unit,
                     $product->pricing->mrp_unit,
                     $product->pricing->retail_price_unit,
                     $product->pricing->wholesale_price_unit,
                     $product->pricing->cutting_rate_unit,
                     $product->pricing->updated_at,
                     $product->pricing->created_at,
                     $product->pricing->deleted_at,
                     $product->pricing->id,
                     $product->pricing->status,
                     $product->pricing->product_id
                 );
             }
     
             return $this->sendResponse($product, 'Product details retrieved successfully.');
         }
     }*/
	
	
	public function product_details(Request $request)
     {
         $data = $request->all();
     
         $rules = array(
             'product_id' => 'required',
         );
     
         $validator = Validator::make($data, $rules);
     
         if ($validator->fails()) {
             return $this->sendError($validator->errors()->first());
         } else {
             $default_logo = url('uploads/images.jpg');
     
             
             $product = DB::table('products')
                 ->leftJoin('categories', 'categories.id', '=', 'products.category_id')
                 ->leftJoin('sub_categories', 'sub_categories.id', '=', 'products.sub_category_id')
                 ->leftJoin('brands', 'brands.id', '=', 'products.brand_id')
                 ->leftJoin('units', 'units.id', '=', 'products.unit_id')
                 ->leftJoin('companies', 'companies.id', '=', 'products.company_id')
                 ->leftJoin('suppliers', 'suppliers.id', '=', 'products.supplier_id')
                 ->leftJoin('pricing', 'products.id', '=', 'pricing.product_id')
                  ->leftJoin('inventory', 'products.id', '=', 'inventory.product_id')
                   ->leftJoin('rolls', 'inventory.id', '=', 'rolls.inward_id')
                 ->select(
                     'products.id as product_id',
                     'products.roll_size',
                     'products.product_name',
                     'products.description',
                     'products.technical_details',
                      'products.quantityroll',
                     'categories.category_name',
                      'sub_categories.id as subcategory_id',
                     'sub_categories.sub_category_name',
                     'brands.brand_name',
                     'units.unit_name',
                     'companies.company_name',
                     'suppliers.supplier_name',
                     'pricing.purchase_cost',
                     'pricing.retail_price',
                     'pricing.converted_price as persqftprice',
                    //   DB::raw('CASE 
                    //         WHEN products.quantityroll > 0 
                    //         THEN CONCAT(FORMAT(pricing.converted_price / products.quantityroll, 2), "/", units.unit_name) 
                    //         ELSE "0" 
                    //     END as persqftprice')
                 )
                 ->where('products.id', $data['product_id'])
                 ->whereNull('products.deleted_at')
                 ->first();
     
             if (!$product) {
                 return $this->sendError('Product not found.');
             }
     
           
             $product->description = html_entity_decode(strip_tags($product->description));
           $technical_details = html_entity_decode($product->technical_details);
    
	   
	  //  $technical_details = str_replace(['<br>', '<p>', '</p>'], ["\n", "\n", "\n"], $technical_details);
	    
	   
	    $product->technical_details = strip_tags($technical_details);

		
     
            
            /* $variants = DB::table('product_variant')
                 ->select('id', 'varient_code', 'varient_name','varient_image')
                 ->where('product_id', $data['product_id'])
                 ->get()->map(function($product) use ($default_logo) {
                     $product->varient_image = $product->varient_image 
                         ? url('uploads/products/' . $product->varient_image) 
                         : url($default_logo);
                     return $product;
                 });*/
                 
                 
           $variants = DB::table('product_variant')
            ->select('id', 'varient_code', 'varient_name', 'varient_image', 'product_id')
            ->where('product_id', $data['product_id'])
            ->get()
            ->map(function ($variant) use ($default_logo) {

                $warehouseAvailability = DB::table('rolls')
                    ->leftJoin('warehouses', 'rolls.warehouse_id', '=', 'warehouses.id')
                    ->join('warehouse_products', function ($join) use ($variant) {
                        $join->on('rolls.warehouse_id', '=', 'warehouse_products.warehouse')
                            ->where('warehouse_products.product_id', $variant->product_id);
                    })
                    ->select(
                        'rolls.warehouse_id',
                        'warehouses.warehouse_name',
                        DB::raw('SUM(rolls.availability) as total_availability'),
                        'warehouse_products.pack_amt as roll_rate',
                        'warehouse_products.cut_amt as cut_roll_rate'
                    )
                    ->where('rolls.varient_id', $variant->id)
                    ->where('rolls.defective_status', 0)
                    ->groupBy(
                        'rolls.warehouse_id',
                        'warehouses.warehouse_name',
                        'warehouse_products.pack_amt',
                        'warehouse_products.cut_amt'
                    )
                 ->get();

                // Skip variant if no warehouse availability
                if ($warehouseAvailability->isEmpty()) {
                    return null;
                }

                $variant->varient_image = $variant->varient_image
                    ? url('uploads/products/' . $variant->varient_image)
                    : url($default_logo);

                $variant->warehouse_availability = $warehouseAvailability;

                return $variant;
                })
                ->filter() // Remove all nulls from map
                ->values(); // Optional: reset keys




                 
                 $shopbycategory = DB::table('categories')
                 ->select('id as category_id' , 'category_name', 'image')
                 ->where('deleted_at',null)
                 ->get()->map(function($product) use ($default_logo) {
                     $product->image = $product->image 
                         ? url('uploads/category/' . $product->image) 
                         : url($default_logo);
                     return $product;
                 });

                 $simmilar_products = DB::table('products')
                 ->join('sub_categories', 'products.sub_category_id', '=', 'sub_categories.id')
                 ->leftJoin('units', 'units.id', '=', 'products.unit_id')
                 ->leftJoin('pricing', 'products.id', '=', 'pricing.product_id')
                 ->leftJoin(DB::raw('(SELECT * FROM product_variant WHERE id IN (SELECT MIN(id) FROM product_variant GROUP BY product_id)) as first_variant'), 'products.id', '=', 'first_variant.product_id')
                 ->select(
                     'products.product_name',
                      'products.roll_size',
                     'products.product_code',
                     'products.product_image',
                     'sub_categories.sub_category_name',
                     'units.unit_name',
                     'pricing.retail_price',
                    
                 )
                 ->where('products.sub_category_id', $product->subcategory_id)
                 ->where('products.id','!=' ,$product->product_id)
                 ->get()->map(function($brand) use ($default_logo) {
             
                     $brand->product_image = ($brand->product_image && strtolower($brand->product_image) != 'null') 
                         ? url('/uploads/products/' . $brand->product_image)
                         : $default_logo;
                     return $brand;
                 });
     
           
             foreach ($variants as $variant) {
                 $variant->additional_images = DB::table('varient_images')
                     ->select('image')
                     ->where('varient_id', $variant->id)
                     ->get()->map(function($varient) use ($default_logo) {
                         $varient->image = $varient->image 
                             ? url('uploads/products/' . $varient->image) 
                             : url($default_logo);
                         return $varient;
                     });
             }
     
             
             $warehouses = DB::table('warehouse_products')
            ->leftJoin('warehouses', 'warehouses.id', '=', 'warehouse_products.warehouse')
            ->select(
                'warehouses.id as warehouse_id',
                'warehouses.warehouse_name',
                'warehouse_products.warehouse',
                'warehouse_products.cut_margin',
                'warehouse_products.pack_margin',
                'warehouse_products.product_id'
            )
            ->where('warehouse_products.product_id', $data['product_id'])
            ->get()
            ->map(function ($warehouse) use ($product) {
                $purchase_cost = $product->purchase_cost;

                $cut_margin = $purchase_cost * $warehouse->cut_margin / 100;
                $pack_margin = $purchase_cost * $warehouse->pack_margin / 100;

                $warehouse->cut_roll_rate = round($purchase_cost + $cut_margin, 2);
                $warehouse->roll_rate = round($purchase_cost + $pack_margin, 2);

                $warehouse->available_quantity = DB::table('rolls')
                    ->where('rolls.warehouse_id', $warehouse->warehouse)
                    ->where('rolls.product_id', $warehouse->product_id)
                    ->sum('rolls.availability');
                  //  dd($warehouse->product_id);

                return $warehouse;
            })
            ->filter(function ($warehouse) {
                return $warehouse->available_quantity > 0;
            })
            ->values() // Optional: reset keys
            ->map(function ($warehouse) {
                return [
                    'warehouse_id' => $warehouse->warehouse_id,
                    'warehouse_name' => $warehouse->warehouse_name,
                    'cut_roll_rate' => $warehouse->cut_roll_rate,
                    'roll_rate' => $warehouse->roll_rate,
                    'available_quantity' => $warehouse->available_quantity,
                ];
            });

             $product->variants = $variants;
             $product->warehouses = $warehouses;
              $product->shopbycategory = $shopbycategory;
             $product->simmilar_products = $simmilar_products;
     
             return $this->sendResponse($product, 'Product details retrieved successfully.');
         }
     }
     

	
	
	//cart function

    
     
     public function addToCart(Request $request)
{
   
    $data = $request->all();
    
   
    $rules = [
        'product_id' => 'required|exists:products,id',
        'varient_id' => 'required|exists:product_variant,id',
        'quantity' => 'required|integer|min:1', 
    ];

    
    $validator = Validator::make($data, $rules);

   
    if ($validator->fails()) {
        return $this->sendError($validator->errors()->first());
    }

    
    $product = DB::table('products')
        ->where('id', $request->product_id)
        ->whereNull('deleted_at') 
        ->first();

   
    if (!$product) {
        return response()->json(['message' => 'Product not found'], 404);
    }

   
    $userId = auth()->id();
    if (!$userId) {
        return response()->json(['message' => 'User not authenticated'], 401);
    }

    
    $cartItem = DB::table('carts')
        ->where('user_id', $userId)
        ->where('product_id', $request->product_id)
        ->where('varient_id', $request->varient_id)
        ->where('deleted_at',null)
        ->first();

    if ($cartItem) {
       
        DB::table('carts')
            ->where('id', $cartItem->id)
            ->update(['quantity' => $cartItem->quantity + $request->quantity]);
        $cartId = $cartItem->id;
    } else {
        
        $cartId = DB::table('carts')->insertGetId([
            'user_id' => $userId,
            'product_id' => $request->product_id,
            'varient_id' => $request->varient_id,
            'quantity' => $request->quantity, 
            'warehouse_id' => $request->warehouse_id,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    
    $datas = DB::table('carts')
        ->join('pricing', 'carts.product_id', '=', 'pricing.product_id') 
        ->select('carts.id', 'carts.product_id', 'carts.varient_id','carts.warehouse_id', 'carts.quantity', 'pricing.retail_price')
        ->where('carts.id', $cartId)
        ->first();

   
    return $this->sendResponse($datas, 'Product added to cart.');
}

 
    /* public function viewCart()
     {
         $userId = auth()->id();
         if (!$userId) {
             return response()->json(['message' => 'User not authenticated'], 401);
         }
   $default_logo = url('uploads/images.jpg');
         $cartItems = DB::table('carts')
             ->join('products', 'carts.product_id', '=', 'products.id')
              ->join('pricing', 'carts.product_id', '=', 'pricing.product_id')
             ->join('product_variant', 'carts.varient_id', '=', 'product_variant.id')
             ->select('carts.id as cart_id','carts.user_id','carts.product_id','carts.varient_id','carts.quantity','products.product_name', 'products.product_image','product_variant.varient_name','product_variant.varient_image','pricing.retail_price','pricing.converted_price',DB::raw('carts.quantity * pricing.converted_price as retail_subtotal')/*,DB::raw('carts.quantity * product_variant.wholesale_price as wholesale_subtotal')*)
              ->where('carts.deleted_at', null)
             ->where('carts.user_id', $userId)
             ->get()->map(function ($product) use ($default_logo) {
              
                $product->varient_image = ($product->varient_image && strtolower($product->varient_image) != 'null')
                    ? url('/uploads/products/' . $product->varient_image)
                    : $default_logo;
                return $product;
            });
 
         return response()->json(['cart' => $cartItems], 200);
     }*/
     
     
     public function viewCart()
{
    $userId = auth()->id();
   // dd($userId);
    if (!$userId) {
        return response()->json(['message' => 'User not authenticated'], 401);
    }

    $default_logo = url('uploads/images.jpg');

  /*  $cartItems = DB::table('carts')
        ->join('products', 'carts.product_id', '=', 'products.id')
        ->join('pricing', 'carts.product_id', '=', 'pricing.product_id')
        ->join('product_variant', 'carts.varient_id', '=', 'product_variant.id')
        ->join('warehouse_products', 'carts.product_id', '=', 'warehouse_products.product_id') 
        ->join('warehouses', 'warehouse_products.warehouse', '=', 'warehouses.id') 
        ->join('units', 'products.unit_id', '=', 'units.id')
        ->select(
            'carts.id as cart_id',
            'carts.user_id',
            'carts.product_id',
            'carts.varient_id',
            'carts.quantity',
            'products.product_name',
            'products.product_image',
            'product_variant.varient_name',
            'product_variant.varient_image',
            'pricing.retail_price',
            'pricing.converted_price',
            'warehouse_products.warehouse', 
            'warehouses.warehouse_name',
            'products.quantityroll', 
            'units.unit_name', 
            DB::raw('carts.quantity * pricing.converted_price as retail_subtotal'),
          DB::raw('CASE 
            WHEN products.quantityroll > 0 
            THEN CONCAT(FORMAT(pricing.converted_price / products.quantityroll, 2), "/", units.unit_name) 
            ELSE "0" 
         END as persqftprice')

        )
        ->whereNull('carts.deleted_at')
        ->where('carts.user_id', $userId)
        ->get()->map(function ($product) use ($default_logo) {
            $product->varient_image = ($product->varient_image && strtolower($product->varient_image) != 'null')
                ? url('/uploads/products/' . $product->varient_image)
                : $default_logo;
            return $product;
        });

    return response()->json(['cart' => $cartItems], 200);*/
    
    $cartItems = DB::table('carts')
    ->join('products', 'carts.product_id', '=', 'products.id')

    // No filter on price_type here
    ->join('pricing', 'carts.product_id', '=', 'pricing.product_id')

    ->join('product_variant', 'carts.varient_id', '=', 'product_variant.id')

    // ✅ Only join the warehouse that was selected during cart addition
    ->join('warehouse_products', function ($join) {
        $join->on('carts.product_id', '=', 'warehouse_products.product_id')
             ->whereColumn('carts.warehouse_id', 'warehouse_products.warehouse');
    })

    ->join('warehouses', 'carts.warehouse_id', '=', 'warehouses.id')
    ->join('units', 'products.unit_id', '=', 'units.id')

    ->whereNull('carts.deleted_at')
    ->where('carts.user_id', $userId)

    ->select(
        'carts.id as cart_id',
        'carts.user_id',
        'carts.product_id',
        'carts.varient_id',
        'carts.quantity',
        'products.product_name',
        'products.product_image',
        'product_variant.varient_name',
        'product_variant.varient_image',
        'pricing.retail_price',
        'pricing.converted_price as persqftprice',
        'carts.warehouse_id',
        'warehouses.warehouse_name',
        'products.quantityroll',
        'units.unit_name',
        'warehouse_products.pack_amt',
        'warehouse_products.cut_amt',
        DB::raw('carts.quantity * pricing.converted_price as retail_subtotal'),
        // DB::raw('CASE 
        //     WHEN products.quantityroll > 0 
        //     THEN CONCAT(FORMAT(pricing.converted_price / products.quantityroll, 2), "/", units.unit_name) 
        //     ELSE "0" 
        //  END as persqftprice')
    )
    ->groupBy(
        'carts.id', 'carts.user_id', 'carts.product_id', 'carts.varient_id', 'carts.quantity',
        'products.product_name', 'products.product_image', 'product_variant.varient_name', 
        'product_variant.varient_image', 'pricing.retail_price', 'pricing.converted_price',
        'carts.warehouse_id', 'warehouses.warehouse_name', 'products.quantityroll', 'units.unit_name','warehouse_products.pack_amt','warehouse_products.cut_amt'
    )
    ->get()
    ->map(function ($product) use ($default_logo) {
        $product->varient_image = ($product->varient_image && strtolower($product->varient_image) != 'null')
            ? url('/uploads/products/' . $product->varient_image)
            : $default_logo;
        return $product;
    });

return response()->json(['cart' => $cartItems], 200);

}


 
     public function updateCart(Request $request, $varientId)
     {
     
    
         $userId = auth()->id();
        
         if (!$userId) {
             return response()->json(['message' => 'User not authenticated'], 401);
         }
 
         $cartItem = DB::table('carts')->where('user_id', $userId)->where('product_id', $varientId)->first();
         
         if ($cartItem) {
             $rules = [
                 'quantity' => 'required|integer|min:1',
             ];
             $validator = Validator::make($request->all(), $rules);
 
             if ($validator->fails()) {
                 return $this->sendError($validator->errors()->first());
             }
             
             $quantity=$cartItem->quantity+$request->quantity;
              
             DB::table('carts')
                 ->where('id', $cartItem->id)
                 ->update(['quantity' => $quantity]);
                 
                 $datas=DB::table('carts')->where('id', $cartItem->id)->first();
 
             return response()->json(['message' => 'Cart updated', 'cart' => $datas], 200);
         }
 
         return response()->json(['message' => 'Product not found in cart'], 404);
     }
 
     public function removeFromCart(Request $request)
     {
      $cart_id=$request->cart_id;
      
     
     
      // $product_id=$request->product_id;
    // $varient_id=$request->varient_id;
         $userId = auth()->id();
         if (!$userId) {
             return response()->json(['message' => 'User not authenticated'], 401);
         }
 
         $cartItem = DB::table('carts')->where('id', $cart_id)->first();
         
 
         if ($cartItem) {
        
            DB::table('carts')->where('id', $cartItem->id)->update([ 'deleted_at'=>now()]);
             return response()->json(['message' => 'Item removed from cart'], 200);
         }else{
        
         return response()->json(['message' => 'Product not found in cart'], 404);
         }
 
        // return response()->json(['message' => 'Product not found in cart'], 404);
     }
 
     public function clearCart()
     {
         $userId = auth()->id();
         if (!$userId) {
             return response()->json(['message' => 'User not authenticated'], 401);
         }
 
         DB::table('carts')->where('user_id', $userId)->delete();
         return response()->json(['message' => 'Cart cleared'], 200);
     }   
     //end cart 
     
     
     //wishlist 
     
     public function addToWishlist(Request $request)
     {
         $data = $request->all();
         $rules = [
             'product_id' => 'required|exists:products,id',
           
         ];
 
         $validator = Validator::make($data, $rules);
 
         if ($validator->fails()) {
             return $this->sendError($validator->errors()->first());
         }
 
         $product = DB::table('products')->find($request->product_id);
 
         if (!$product) {
             return response()->json(['message' => 'Product not found'], 404);
         }
 
        
         $userId = auth()->id();
         if (!$userId) {
             return response()->json(['message' => 'User not authenticated'], 401);
         }
 
        
         $wishlist = DB::table('wishlist')
             ->where('user_id', $userId)
             ->where('product_id', $request->product_id)
             ->where('deleted_at',null)
             ->first();
 
         if ($wishlist) {
            return response()->json(['message' => 'Already added in wishlist'], 401);
           
         } else {
             $varient= DB::table('product_variant')->where('product_id',$request->product_id)->orderBy('id', 'asc')->first();
             $wishlistdata=DB::table('wishlist')->insertGetId([
                 'user_id' => $userId,
                 'product_id' => $request->product_id,
                 'varient_id'=>$varient->id ?? '',
                 'created_at' => now(),
                 'updated_at' => now(),
             ]);
             
             $wishlist_datas=DB::table('wishlist')->where('id',$wishlistdata)
             ->select('id as wishlist_id','product_id','varient_id','user_id')
             ->first();
         }
 
         return $this->sendResponse($wishlist_datas, 'Product added to wishlist.');
     }


     public function viewWishlist()
     {
         $userId = auth()->id();
         if (!$userId) {
             return response()->json(['message' => 'User not authenticated'], 401);
         }
         $default_logo = url('uploads/images.jpg');
         $wishlist = DB::table('wishlist')
             ->join('products', 'wishlist.product_id', '=', 'products.id')
             ->leftJoin('units', 'units.id', '=', 'products.unit_id')
             ->leftJoin('pricing', 'products.id', '=', 'pricing.product_id')
              //->leftJoin(DB::raw('(SELECT * FROM product_variant WHERE id IN (SELECT MIN(id) FROM product_variant GROUP BY product_id)) as first_variant'), 'products.id', '=', 'first_variant.product_id')
             ->select('wishlist.id as wishlist_id','wishlist.product_id','wishlist.varient_id','products.product_name', 'products.product_image','wishlist.cart_status','units.unit_name',
                'pricing.retail_price',
                /*'first_variant.retail_price',
                'first_variant.wholesale_price'*/)
             ->where('wishlist.user_id', $userId)
             ->where('wishlist.deleted_at', null)
             ->get()->map(function ($product) use ($default_logo) {
              
                $product->product_image = ($product->product_image && strtolower($product->product_image) != 'null')
                    ? url('/uploads/products/' . $product->product_image)
                    : $default_logo;
                return $product;
            });
 
         return response()->json(['wishlist' => $wishlist], 200);
     }

     public function removeFromWishlist(Request $request)
     {
     
     $id=$request->wishlist_id;
         $userId = auth()->id();
         if (!$userId) {
             return response()->json(['message' => 'User not authenticated'], 401);
         }
 
         $wishlist = DB::table('wishlist')
         ->where('id', $id)
         ->first();
 
         if ($wishlist) {
             DB::table('wishlist')->where('id', $wishlist->id)->update([ 'deleted_at'=>now()]);
             return response()->json(['message' => 'Item removed from wishlist'], 200);
         }else{
            return response()->json(['message' => 'Already removed from wishlist'], 404);
         }
 
         return response()->json(['message' => 'Product not found in wishlist'], 404);
     }


     public function clearWishlist()
     {
         $userId = auth()->id();
         if (!$userId) {
             return response()->json(['message' => 'User not authenticated'], 401);
         }
 
         DB::table('wishlist')->where('user_id', $userId)->update([ 'deleted_at'=>now()]);
         return response()->json(['message' => 'Wishlist cleared'], 200);
     }

//end wishlist


 /*public function order_save(Request $request)
     {
         $data = $request->all();
         
         
         $rules = [
             'company_id' => 'required',
             'order_items' => 'required|array',
             'order_items.*.product_id' => 'required',
             'order_items.*.varient_id' => 'required',
             'order_items.*.qty' => 'required',
             'order_items.*.price' => 'required',
         ];
         
         
         $validator = Validator::make($data, $rules);
         if ($validator->fails()) {
             return response()->json(['error' => $validator->errors()->first()], 400);
         }
     
         try {
             DB::beginTransaction();
     
             $lastOrder = DB::table('orders')->orderBy('id', 'desc')->first();
             $lastOrderCode = $lastOrder ? intval(substr($lastOrder->order_code, 3)) : 10000;
     
             // Generate the next order code
             $nextOrderCode = 'ORD' . ($lastOrderCode + 1);
             
               $order_amount = collect($request->order_items)->reduce(function ($total, $item) {
                return $total + ($item['qty'] * $item['price']);
            }, 0);
     
             $orderId = DB::table('orders')->insertGetId([
                'order_code'=>$nextOrderCode,
                 'company_id' => $request->company_id,
                 'customer_id' => auth()->id(),
                 'order_date' => date('Y-m-d'), 
                 'order_amount' => $order_amount, 
                 'status' => 'Ordered',
                 'created_at' => now(),
                 'updated_at' => now(),
             ]);
     
             
             $orderItems = [];
             foreach ($request->order_items as $item) {
                 $orderItems[] = [
                     'order_id' => $orderId,
                     'product_id' => $item['product_id'],
                     'varient_id' => $item['varient_id'],
                     'quantity' => $item['qty'],
                     'price' => $item['price'],
                     'created_at' => now(),
                     'updated_at' => now(),
                 ];
             }
     
            
             DB::table('order_items')->insert($orderItems);
             
              DB::table('track_orders')->insert([
                'order_id' => $orderId,
                'status' => 'Ordered',
                'created_at' => now(),
            ]);
     
             DB::commit();
     
             return response()->json(['success' => true, 'message' => 'Order and items saved successfully.'], 201);
     
         } catch (\Exception $e) {
             DB::rollBack();
             // Return the specific exception message for debugging
             return response()->json(['error' => 'Failed to save order: ' . $e->getMessage()], 500);
         }
     }*/
     
     //second function
    /* public function order_save(Request $request)
    {
        $data = $request->all();

        $rules = [
            'company_id' => 'required',
            'order_items' => 'required|array',
            'order_items.*.product_id' => 'required',
            'order_items.*.varient_id' => 'required',
            'order_items.*.qty' => 'required',
            'order_items.*.price' => 'required',
        ];

        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }

        try {
            DB::beginTransaction();

            // Generate a unique order code
        // $lastOrder = DB::table('orders')->orderBy('id', 'desc')->lockForUpdate()->first();
        // $lastOrderCode = $lastOrder ? intval(substr($lastOrder->order_code, 3)) : 10000;
        // $nextOrderCode = 'ORD' . ($lastOrderCode + 1);
            
            /* $lastCompany = DB::table('orders')->orderBy('order_code', 'desc')->first();
        // dd($lastCompany);
            if ($lastCompany) {
                $lastIdNumber = (int) substr($lastCompany->order_code, 2); 
                $newId = 'ORD' . str_pad($lastIdNumber + 1, 5, '0', STR_PAD_LEFT); 
            } else {
                $newId = 'ORD00001';
            }*
            
            
            $lastCompany = DB::table('orders')
            ->whereNull('deleted_at')
            ->orderBy('order_code', 'desc')
            ->first();

        if ($lastCompany) {
            $lastIdNumber = (int) substr($lastCompany->order_code, 3); // Extract numeric part correctly
            $newId = 'ORD' . str_pad($lastIdNumber + 1, 5, '0', STR_PAD_LEFT);
        } else {
            $newId = 'ORD00001';
        }
            
            
            

            // Calculate the total order amount
            $order_amount = collect($request->order_items)->reduce(function ($total, $item) {
                return $total + ($item['qty'] * $item['price']);
            }, 0);

            // Insert the order
            $orderId = DB::table('orders')->insertGetId([
                'order_code' => $newId,
                'company_id' => $request->company_id,
                'customer_id' => auth()->id(),
                'order_date' => date('Y-m-d'),
                'order_amount' => $order_amount,
                'tax_percent' => 0.00,
                'tax' => 0.00,
                'grandtotal' => $order_amount,
                'order_type'=>$request->order_type,
                'pickup_point'=>$request->pickup_point,
                'status' => 'Ordered',
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            // Prepare order items data
            $orderItems = [];
            foreach ($request->order_items as $item) {
                $orderItems[] = [
                    'order_id' => $orderId,
                    'product_id' => $item['product_id'],
                    'varient_id' => $item['varient_id'],
                    'quantity' => $item['qty'],
                    'price' => $item['price'],
                    'created_at' => now(),
                    'updated_at' => now(),
                ];
            }

            // Insert order items
            DB::table('order_items')->insert($orderItems);

            // Insert tracking data
            DB::table('track_orders')->insert([
                'order_id' => $orderId,
                'status' => 'Ordered',
                'message' => 'Your order has been placed',
                'created_at' => now(),
            ]);
            
            $varient_ids = collect($request->order_items)->pluck('varient_id')->toArray();
            DB::table('carts')->where('user_id', auth()->id())->whereIn('varient_id', $varient_ids)->delete();
            DB::table('wishlist')->where('user_id', auth()->id())->whereIn('varient_id', $varient_ids)->delete();

            DB::commit();

            return response()->json(['success' => true, 'message' => 'Order and items saved successfully.'], 201);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(['error' => 'Failed to save order: ' . $e->getMessage()], 500);
        }
    }*/


    //new function
    
 


    

     
     
        public function get_pickups(Request $request) {
        $productIds = $request->input('product_ids', []);
    
        if (empty($productIds)) {
            return response()->json([
                'status' => false,
                'message' => 'No product IDs provided.'
            ], 400);
        }
    
        $warehouses = DB::table('inventory')
            ->join('warehouses', 'inventory.warehouse_id', '=', 'warehouses.id')
            ->leftJoin('rolls', function ($join) {
                $join->on('inventory.id', '=', 'rolls.inward_id')
                     ->where('rolls.availability', '>', 10); 
            })
            ->whereIn('inventory.product_id', $productIds)
            ->select(
                'inventory.product_id',
                'warehouses.warehouse_name',
                DB::raw('COUNT(rolls.id) as available_rolls')              
            )
            ->groupBy('inventory.product_id', 'warehouses.warehouse_name')
            ->get()
            ->groupBy('product_id');
    
        return response()->json([
            'status' => true,
            'data' => $warehouses
        ]);
    }
     
     
    
	 
	
	
	 public function first_addtocart(Request $request)
     {
      
         $data = $request->all();
        
         $rules = [
             'product_id' => 'required',
           
         ];

         $validator = Validator::make($data, $rules);
 
         if ($validator->fails()) {
             return $this->sendError($validator->errors()->first());
         }
        
         $product = DB::table('products')
         ->where('id', $request->product_id)
         ->whereNull('deleted_at')
         ->first();
          if (!$product) {
             return response()->json(['message' => 'Product not found'], 404);
         }

         $first_var = DB::table('product_variant')
         ->where('product_id', $request->product_id)
         ->orderBy('id', 'asc') 
         ->whereNull('deleted_at')
         ->first();
         
         if (!$first_var) {
            return response()->json(['message' => 'varient not found'], 404);
        }
         $first_varient=$first_var->id;

 
        
         $userId = auth()->id();
         if (!$userId) {
             return response()->json(['message' => 'User not authenticated'], 401);
         }
 
       
         $cartItem = DB::table('carts')
             ->where('user_id', $userId)
             ->where('product_id', $request->product_id)
              ->where('varient_id', $first_varient)
              ->whereNull('deleted_at')
             ->first();
 
         if ($cartItem) {
            
             DB::table('carts')
                 ->where('id', $cartItem->id)
                 ->update(['quantity' => $cartItem->quantity + $request->quantity]);
                 $cartId = $cartItem->id;
         } else {
           // $varient= DB::table('product_variant')->where('product_id',$request->product_id)->orderBy('id', 'asc')->first();

           $cartId= DB::table('carts')->insertGetId([
                 'user_id' => $userId,
                 'product_id' => $request->product_id,
                  'varient_id'=>$first_varient,
                 'quantity' => 1,
                 'created_at' => now(),
                 'updated_at' => now(),
             ]);
             
              
         }
            $datas = DB::table('carts')
        ->join('pricing', 'carts.product_id', '=', 'pricing.product_id') 
        ->select('carts.id', 'carts.product_id', 'carts.varient_id','carts.warehouse_id','carts.quantity', 'pricing.retail_price')
        ->where('carts.id', $cartId)
        ->first();
         return $this->sendResponse($datas, 'Product added to cart.');
     }
 

     public function check_availability_varients(Request $request)
     {
         $varient_id = $request->varient_id;
         $requested_quantity = $request->quantity; // User-entered quantity
     
         $availability = DB::table('rolls')
             ->join('warehouses', 'rolls.warehouse_id', '=', 'warehouses.id')
             ->where('rolls.varient_id', $varient_id)
             ->select(
                 'rolls.product_id',
                 'rolls.varient_id',
                 'rolls.warehouse_id',
                 'warehouses.warehouse_name',
                 DB::raw('COUNT(rolls.id) as total_rolls'),
                 DB::raw('SUM(rolls.availability) as total_availability')
             )
             ->groupBy('rolls.product_id', 'rolls.varient_id', 'rolls.warehouse_id', 'warehouses.warehouse_name')
             ->get();
     
         if ($availability->isEmpty()) {
             return response()->json([
                 'status' => false,
                 'message' => "No stock available for this variant.",
                 'data' => []
             ]);
         }
     
         $lowStockMessages = [];
         $outOfStockMessages = [];
         $sufficientStock = false;
     
         foreach ($availability as $data) {
             if ($data->total_availability < 1) {
                 $outOfStockMessages[] = "Out of stock in warehouse '{$data->warehouse_name}'.";
             } elseif ($data->total_availability < 100) {
                 $lowStockMessages[] = "Low stock: Only {$data->total_availability} available in warehouse '{$data->warehouse_name}'.";
             }
     
             /*if ($requested_quantity <= $data->total_availability) {
                 $sufficientStock = true;
             }*/
             
             if ($requested_quantity <= $data->total_availability) {
		    $sufficientStock = true;
		} elseif ($requested_quantity > $data->total_availability) {
		    $sufficientStock = false; // Ensure false only when quantity is more
		}

         }
     
         if (!empty($outOfStockMessages)) {
             return response()->json([
                 'status' => false,
                 'message' => implode(" ", $outOfStockMessages),
                 'data' => $availability
             ]);
         }
     
         if (!empty($lowStockMessages)) {
             return response()->json([
                 'status' => true, // Still return true, but with a warning
                 'message' => implode(" ", $lowStockMessages),
                 'data' => $availability
             ]);
         }
     
         if (!$sufficientStock) {
             return response()->json([
                 'status' => false,
                 'message' => "Requested quantity exceeds available stock.",
                 'data' => $availability
             ]);
         }
     
         return response()->json([
             'status' => true,
             'message' => "Sufficient stock available.",
             'data' => $availability
         ]);
     }
     


     
     public function pickup_point_list(Request $request)
     {
         $product_id = $request->product_id;
         $warehouse_id = $request->warehouse_id;
         $varient_ids = $request->input('varient_id', []); 
        
     
         if (!is_array($varient_ids) || empty($varient_ids)) {
             return response()->json([
                 'status' => false,
                 'message' => "Invalid request format. Expected a non-empty array for varient_id.",
                 'data' => []
             ]);
         }
     
         $apiKey = env('GOOGLE_MAPS_API_KEY'); 
     
        	
         $warehouses = DB::table('rolls')
             ->join('warehouses', 'rolls.warehouse_id', '=', 'warehouses.id')
             ->whereIn('rolls.varient_id', $varient_ids)
             ->where('rolls.availability', '>', 0)
             ->select(
                 'rolls.warehouse_id',
                 'warehouses.warehouse_name',
                 'warehouses.address',
                  'warehouses.open_time',
                   'warehouses.close_time',
                 DB::raw('SUM(rolls.availability) as total_availability')
             )
             ->groupBy('rolls.warehouse_id', 'warehouses.warehouse_name', 'warehouses.address')
             ->get();

           
             
     
         if ($warehouses->isEmpty()) {
             return response()->json([
                 'status' => false,
                 'message' => "No pickup points found for the given variants.",
                 'data' => []
             ]);
         }
     
         // Step 2: Filter warehouses to include only those that have ALL requested variants
         $validWarehouses = [];
     
         foreach ($warehouses as $warehouse) {
             $variantCount = DB::table('rolls')
                 ->where('warehouse_id', $warehouse->warehouse_id)
                 ->whereIn('varient_id', $varient_ids)
                 ->distinct('varient_id')
                 ->count();
     
             // Only include warehouses that contain ALL requested variants
             if ($variantCount == count($varient_ids)) {
                 $validWarehouses[] = $warehouse;
             }
         }
     
         // Step 3: Fetch lat/lng for each valid warehouse
         foreach ($validWarehouses as $warehouse) {
             $warehouse->lat = null;
             $warehouse->lng = null;
     
             if (!empty($warehouse->address)) {
                 try {
                     $geoResponse = Http::get("https://maps.googleapis.com/maps/api/geocode/json", [
                         'address' => $warehouse->address,
                         'key' => $apiKey
                     ]);
     
                     $geoData = $geoResponse->json();
     
                     if ($geoData['status'] === 'OK') {
                         $warehouse->lat = $geoData['results'][0]['geometry']['location']['lat'];
                         $warehouse->lng = $geoData['results'][0]['geometry']['location']['lng'];
                     }
                 } catch (\Exception $e) {
                     // Handle API request failure
                     $warehouse->lat = null;
                     $warehouse->lng = null;
                 }
             }
         }
     
         if (empty($validWarehouses)) {
             return response()->json([
                 'status' => false,
                 'message' => "No common warehouses found for all variants.",
                 'data' => []
             ]);
         }
     
         return response()->json([
             'status' => true,
             'message' => "Common pickup points found.",
             'data' => $validWarehouses
         ]);
     }
     
}


