<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Http;
use App\Models\Customer;


class SearchController extends Controller
{
  
 public function search_by_all(Request $request)
{
    $searchTerm = $request->input('query'); 
     $default_logo = url('uploads/images.jpeg');

    if (!$searchTerm || strlen($searchTerm) < 2) {
        return response()->json(['error' => 'Please enter at least 2 characters to search.'], 400);
    }
    
   

    // Search in brands
    $brands = DB::table('brands')
        ->where('brand_name', 'LIKE', $searchTerm . '%')
        ->select('id as brand_id', 'brand_name','brand_logo as brand_image')
        ->where('deleted_at',null)
        ->get()
         ->map(function($brand) use ($default_logo) {
             
            $brand->brand_image = $brand->brand_image 
                ? url('uploads/brand/' . $brand->brand_image) 
                : url($default_logo);
            return $brand;
        });

    // Search in categories
    $categories = DB::table('categories')
        ->where('category_name', 'LIKE', $searchTerm . '%')
        ->select('id as category_id', 'category_name','image as category_image')
        ->where('deleted_at',null)
        ->get()
        ->map(function($category) use ($default_logo) {
             
            $category->category_image = $category->category_image 
                ? url('uploads/category/' . $category->category_image) 
                : url($default_logo);
            return $category;
        });
        
         // Search in subcategories
    $subcategories = DB::table('sub_categories')
        ->where('sub_category_name', 'LIKE', $searchTerm . '%')
        ->select('id as sub_category_id','category_id', 'sub_category_name','image as sub_category_image')
        ->where('deleted_at',null)
        ->get()
        ->map(function($subcategory) use ($default_logo) {
             
            $subcategory->sub_category_image = $subcategory->sub_category_image 
                ? url('uploads/subcategories/' . $subcategory->sub_category_image) 
                : url($default_logo);
            return $subcategory;
        });

    // Search in products
    $products = DB::table('products')
        ->where('product_name', 'LIKE', $searchTerm . '%')
        ->select('id as product_id', 'product_name', 'product_image')
        ->where('deleted_at',null)
        ->get()
         ->map(function($product) use ($default_logo) {
             
            $product->product_image = $product->product_image 
                ? url('uploads/products/' . $product->product_image) 
                : url($default_logo);
            return $product;
        });

    // Search in variants
    $variants = DB::table('product_variant')
        ->where('varient_name', 'LIKE', $searchTerm . '%')
        ->select('id as varient_id', 'varient_name', 'product_id','varient_image')
        ->where('deleted_at',null)
        ->get() 
        ->map(function($varient) use ($default_logo) {
             
            $varient->varient_image = $varient->varient_image 
                ? url('uploads/products/' . $varient->varient_image) 
                : url($default_logo);
            return $varient;
        });

    // Combine all results
    $result = [
        'brands' => $brands,
        'categories' => $categories,
         'sub_categories' => $subcategories,
        'products' => $products,
        'variants' => $variants,
    ];

    return response()->json(['success' => true, 'data' => $result], 200);
}

  
  public function search_by_product(Request $request)
{
    $searchTerm = $request->input('product_name'); 
     $default_logo = url('uploads/images.jpeg');

    if (!$searchTerm || strlen($searchTerm) < 2) {
        return response()->json(['error' => 'Please enter at least 2 characters to search.'], 400);
    }
    

    

    $products = DB::table('products')
        ->where('product_name', 'LIKE', $searchTerm . '%') // Search by first 3 letters
        ->select('id', 'product_name','product_image') // Select only necessary columns
        ->where('deleted_at',null)
        ->get()
       
        ->map(function($product) use ($default_logo) {
             
            $product->product_image = $product->product_image 
                ? url('uploads/products/' . $product->product_image) 
                : url($default_logo);
            return $product;
        });

    if ($products->isEmpty()) {
        return response()->json(['message' => 'No products found.'], 404);
    }

    return response()->json(['success' => true, 'products' => $products], 200);
}

  
   public function top_selling_product(Request $request){
   $default_logo = url('uploads/images.jpeg');
    $topSellingProduct = DB::table('order_items')
        ->join('products', 'order_items.product_id', '=', 'products.id')
         ->join('pricing', 'pricing.product_id', '=', 'products.id')
        ->join('product_variant', 'order_items.varient_id', '=', 'product_variant.id') 
        ->select('products.id', 'products.product_name', 'products.product_image','product_variant.varient_name',DB::raw('SUM(order_items.quantity) as total_sold_qty'))
        ->groupBy('products.id', 'products.product_name','products.product_image','product_variant.varient_name','pricing.retail_price')
        ->orderByDesc('total_sold_qty')
        ->limit(1) 
        ->get()
        ->map(function($product) use ($default_logo) {
             
            $product->product_image = $product->product_image 
                ? url('uploads/products/' . $product->product_image) 
                : url($default_logo);
            return $product;
        });
        
         return $this->sendResponse($topSellingProduct, 'Top Selling Products.');
  
  }
  
  
  public function search_history(Request $request){
  
    
  $searchhistory = DB::table('product_search_history')
        ->where('customer_id',auth()->id())
        ->where('deleted_at',null)
        ->orderBy('id', 'desc')
        ->get();
        
         if ($searchhistory->isEmpty()) {
        return response()->json(['message' => 'No History found.'], 404);
    }
        
     return $this->sendResponse($searchhistory, 'Search History.');
  }
  
  
	  public function storeSearchHistory(Request $request)
	{
	    $keyword = $request->input('keyword');
	    $search_id = $request->input('search_id');
	    $userId = auth()->check() ? auth()->id() : null;

	    $type = null;

	    if (DB::table('products')->where('product_name', 'like', '%' . $keyword . '%')->where('status',1)->where('deleted_at',null)->exists()) {
		$type = 'product';
	    } elseif (DB::table('product_variant')->where('varient_name', 'like', '%' . $keyword . '%')->where('status',1)->where('deleted_at',null)->exists()) {
		$type = 'variant';
	    } elseif (DB::table('categories')->where('category_name', 'like', '%' . $keyword . '%')->where('status',1)->where('deleted_at',null)->exists()) {
		$type = 'category';
	    } elseif (DB::table('sub_categories')->where('sub_category_name', 'like', '%' . $keyword . '%')->where('status',1)->where('deleted_at',null)->exists()) {
		$type = 'sub_category';
	    } elseif (DB::table('brands')->where('brand_name', 'like', '%' . $keyword . '%')->where('status',1)->where('deleted_at',null)->exists()) {
		$type = 'brand';
	    }

	    if ($type) {
	      $exists = DB::table('product_search_history')
            ->where('search_term', $keyword)
             ->where('search_id', $search_id)
            ->where('search_type', $type)
            ->where('customer_id', $userId)
            ->where('deleted_at',null)
            ->exists();
            
            if ($exists) {
           return response()->json(['success' => true, 'message' => 'Already Search history saved']);
        }
        

        if (!$exists) {
		DB::table('product_search_history')->insert([
		    'search_term' => $keyword,
		    'search_type' => $type,
		    'search_id'  => $search_id,
		    'customer_id' => $userId,
		    'created_at' => now(),
		    'updated_at' => now(),
		]);
		
		}
                
		return response()->json(['success' => true, 'message' => 'Search history saved']);
	    }
                 
	    return response()->json(['success' => true, 'message' => 'No match found']);
	}


      public function popular_search_history(Request $request){
      
     // dd('popular_search_history');
      
       $limit = $request->input('limit', 5); 

    $popularSearches = DB::table('product_search_history')
        ->select('search_term', 'search_type', 'search_id',DB::raw('COUNT(*) as total'))
        ->groupBy('search_term', 'search_type','search_id')
        ->orderByDesc('total')
        ->limit($limit)
        ->get();

    return response()->json([
        'success' => true,
        'data' => $popularSearches,
        'message' => 'Popular searches fetched successfully.',
    ]);
    
    
      
      }
      
      
     public function removeSearchHistory(Request $request)
	{
	    $id = $request->id;

	    $searchHistory = DB::table('product_search_history')->where('id', $id)->first();

	    if (!$searchHistory) {
		return response()->json(['message' => 'No history found.'], 404);
	    }

	    DB::table('product_search_history')->where('id', $id)->update(['deleted_at' => now()]);

	    return response()->json(['message' => 'Search history removed successfully.']);
	}

      
      public function removeAllHistory(Request $request)
	{
	    $id = auth()->id();

	    $searchHistory = DB::table('product_search_history')->where('customer_id', $id)->first();

	    if (!$searchHistory) {
		return response()->json(['message' => 'No customer history found.'], 404);
	    }

	    DB::table('product_search_history')->where('customer_id', $id)->update(['deleted_at' => now()]);

	    return response()->json(['message' => 'Removed  all history successfully.']);
	}
  

}
