<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;



class UserController extends Controller
{
    public function sign_in(Request $request)
{
  
    $request->validate([
        'email' => 'required',
        'password' => 'required',
         'customer_type' => 'required',
        
    ]);

    $credentials = $request->only('email', 'password','customer_type');
    
  
    $customer = DB::table('customers')->where('email', $credentials['email'])->first();

    
    if ($customer) {
        if ($customer->status == 1) {
        
         if ($customer->customer_type !== $credentials['customer_type']) {
                return $this->sendResponse([],'Invalid customer type for this account.');
            }
           
            if (Hash::check($credentials['password'], $customer->password)) {
                $token = Str::random(60);
                
                
                DB::table('customers')->where('email', $credentials['email'])->update(['api_token' => $token]);
                $updatedCustomer = DB::table('customers')->where('email', $credentials['email'])->first();

               
                return $this->sendResponse($updatedCustomer, 'User login successfully.');
            } else {
                return $this->sendError('Wrong password. Please try again.');
            }
        } else {
            return $this->sendError('You are not an active user. Please contact Admin.');
        }
    } else { 
        return $this->sendError('Wrong Credentials.');
    }
}
    

    public function sign_up(Request $request)
        {
                $data = $request->all();

               $rules = [
		    'name' => 'required',
		    'email' => [
			'required',
			'email',
			Rule::unique('customers')->whereNull('deleted_at'),
		    ],
		    'mobile' => [
			'required',
			'numeric',
			  'digits:10',
			Rule::unique('customers')->whereNull('deleted_at'),
		    ],
		    'password' => 'required|min:6|same:conf_password',
		    'conf_password' => 'required|min:6|same:password',
		    'customer_type' => 'required',
		];

                $validator = Validator::make($data, $rules);
                
                if ($validator->fails()) {
                    return $this->sendError($validator->errors()->first());
                } else {
                
                    //$otp = rand(1000, 9999);
                    $otp=1234;
                    
                     $lastCustomer = DB::table('customers')->orderBy('customer_id', 'desc')->first();

    
                    if ($lastCustomer) {
                        $lastIdNumber = (int) substr($lastCustomer->customer_id, 2); 
                        $newCustomerId = 'CU' . str_pad($lastIdNumber + 1, 6, '0', STR_PAD_LEFT); 
                    } else {
                        $newCustomerId = 'CU000001';
                    }
                    

                    
                    $customerId = DB::table('customers')->insertGetId([
                        'customer_type' => $data['customer_type'],
                        'customer_name' => $data['name'],
                         'customer_id'=>$newCustomerId,
                        'email' => $data['email'],
                        'otp' => $otp,
                        'mobile' => $data['mobile'],
                        'password' => bcrypt($data['password']), 
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                    ]);

                    
                    $customer = DB::table('customers')->where('id', $customerId)->first();

                    
                    $senderadmin = 'info@omsoftware.us';
                    $recieveradmin = $customer->email;
                    $fromNameadmin = 'Floor Factory';

                
                    $details = [
                        'customer_name' => $customer->customer_name,
                        'id' => $customer->id,
                        'otp' => $customer->otp,
                        'email' => $customer->email,
                        'mobile' => $customer->mobile,
                    ];

                   
                    /*Mail::send('emails.email_verification', ['details' => $details], function ($message) use ($recieveradmin, $senderadmin, $fromNameadmin) {
                        $message->to($recieveradmin)->subject('Email verification code');
                        $message->from($senderadmin, $fromNameadmin);
                    });*/

                    
                    return $this->sendResponse($customer, 'Customer registered successfully.');
                }
        }

        
    
     public function verify_email(Request $request){

        $data=$request->all();
        
     
      $rules = array(
      'customer_id' => 'required',
        'verify_code' => 'required',
        'email' => 'required',
       
      );
    
        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            return $this->sendError($validator->errors()->first());
        }else{
           
            $emails=DB::table('customers')->where('id',$data['customer_id'])->first();
           
            if($emails){
                 if($data['verify_code']==$emails->otp){
                    DB::table('customers')->where('email',$data['email'])->update([
                        'is_email_verified'=>1
                    ]);
                    $datas=DB::table('customers')->where('id',$data['customer_id'])->first();
                    return $this->sendResponse($datas, 'Email verification successfully.');
                 }else{
                    return $this->sendError('Wrong verification code.');
                 }
            }else{
                return $this->sendError('Email not exist.');
            }
        }

     }
     
     
     


    public function send_otp(Request $request)
     {
     // $otp = rand(1000, 9999);
      $otp=1234;
    
      if ($request->has('mobile') || $request->has('email')) {

       
        $customer = DB::table('customers')
            ->where('id', $request->customer_id)
            ->first();


        DB::table('customers')->where('id', $customer->id)->update(['otp' => $otp]);

        
        $senderadmin = 'info@omsoftware.us'; 
        $recieveradmin = $customer->email;
        $fromNameadmin = 'Floor Factory';

        $details = [
            'customer_name' => $customer->customer_name,
            'id' => $customer->id,
            'otp' => $otp, 
            'email' => $customer->email,
            'mobile' => $customer->mobile,
        ];

        
       /* Mail::send('emails.sendotp', ['details' => $details], function ($message) use ($recieveradmin, $senderadmin, $fromNameadmin) {
            $message->to($recieveradmin)->subject('OTP details');
            $message->from($senderadmin, $fromNameadmin);
        });*/

        return $this->sendResponse($customer, 'OTP sent successfully.');
     }

     return $this->sendError('Mobile or Email not provided.');
    }

     public function verify_otp(Request $request){
        $data=$request->all();
     
        $rules = array(
          'customer_id' => 'required',
          'otp' => 'required',
         
        );
      
          $validator = Validator::make($data, $rules);
          if ($validator->fails()) {
              return $this->sendError($validator->errors()->first());
          }else{

            $datas=DB::table('customers')->where('id',$data['customer_id'])->first();
          if($datas && $datas->otp == $data['otp']){
          
           $token= Str::random(60);
           
          DB::table('customers')->where('id',$data['customer_id'])->update(['api_token'=>$token]);
          
           $updatedatas=DB::table('customers')->where('id',$data['customer_id'])->first();
          
          return $this->sendResponse($updatedatas, 'Login successfully.');

          }else{
            return $this->sendError('Wrong OTP.Not verified!');

          }
             
     }
    }
    
    
    public function resend_email_code(Request $request){
    $data=$request->all();
    
    $rules = array(
        'customer_id' => 'required',
        'email' =>'required',
       
    );
    
    $validator = Validator::make($data, $rules);
    if ($validator->fails()) {
        return $this->sendError($validator->errors()->first());
    }else{
        //$otp = rand(1000, 9999);
         $otp=1234;
        DB::table('customers')->where('id',$data['customer_id'])->update(
            [
                'otp'=>$otp
            ]
        );

        $customer = DB::table('customers')->where('id', $data['customer_id'])->first();

        
        $senderadmin = 'info@omsoftware.us';
        $recieveradmin = $customer->email;
        $fromNameadmin = 'Floor Factory';

    
        $details = [
            'customer_name' => $customer->customer_name,
            'id' => $customer->id,
            'otp' => $customer->otp,
            'email' => $customer->email,
            'mobile' => $customer->mobile,
        ];

        
       /* Mail::send('emails.email_verification', ['details' => $details], function ($message) use ($recieveradmin, $senderadmin, $fromNameadmin) {
            $message->to($recieveradmin)->subject('Email verification code');
            $message->from($senderadmin, $fromNameadmin);
        });*/
        
        return $this->sendResponse($details, 'Code sent on your registered mail.');

    }
}
     

     public function update_business_details(Request $request)
{
    $data = $request->all();

    $rules = array(
        'customer_id' => 'required',
    );

    $validator = Validator::make($data, $rules);
    if ($validator->fails()) {
        return $this->sendError($validator->errors()->first());
    } else {
        $customerid = $data['customer_id'];
        $check = DB::table('customers')->where('id', $customerid)->first();
        
        if ($check) {
            $updateData = [];

         
            if (!empty($data['gst_number'])) {
                $updateData['gst_number'] = $data['gst_number'];
                 $updateData['is-business-user'] = 1;
            }

            
            if (empty($data['gst_number'])) {
                if (!empty($data['msme'])) {
                    $updateData['msme'] = $data['msme'];
                }
                if (!empty($data['address'])) {
                    $updateData['address'] = $data['address'];
                }
                if (!empty($data['city'])) {
                    $updateData['city'] = $data['city'];
                }
                if (!empty($data['state'])) {
                    $updateData['state'] = $data['state'];
                }
                if (!empty($data['company_name'])) {
                    $updateData['company_name'] = $data['company_name'];
                }
                if (!empty($data['zipcode'])) {
                    $updateData['zipcode'] = $data['zipcode'];
                }
                  if (!empty($data['phone1'])) {
                    $updateData['phone1'] = $data['phone1'];
                }
                  if (!empty($data['phone2'])) {
                    $updateData['phone2'] = $data['phone2'];
                }
            }

            if (!empty($updateData)) {
                DB::table('customers')->where('id', $customerid)->update($updateData);
            }

            $details = DB::table('customers')->where('id', $customerid)->first();
            return $this->sendResponse($details, 'Business details updated successfully.');
        } else {
            return $this->sendError('Customer not exist.');
        }
    }
}




 public function forgot_password(Request $request){
     $data=$request->all();
     
    // $otp = rand(1000, 9999);
      $otp=1234;
     $rules = array(
        'email' => 'required',
    );
    
    $validator = Validator::make($data, $rules);
    if ($validator->fails()) {
        return $this->sendError($validator->errors()->first());
    }else{

        $datas=DB::table('customers')->where('email',$data['email'])->first();

    if($datas->email == $data['email']){

        DB::table('customers')->where('id', $datas->id)->update(['otp' => $otp]);

        $newdata=DB::table('customers')->where('id', $datas->id)->first();

       
       $senderadmin = 'info@omsoftware.us';
        $recieveradmin = $datas->email;
        $fromNameadmin = 'Floor Factory';
        $details = [
            'customer_name' => $datas->customer_name,
            'id' => $datas->id,
            'otp' => $newdata->otp, 
            'email' => $datas->email,
            'mobile' => $datas->mobile,
        ];
        
       /* Mail::send('emails.forgotpassword', ['details' => $details], function ($message) use ($recieveradmin, $senderadmin, $fromNameadmin) {
                    $message->to($recieveradmin)->subject('Forgot Password OTP details');
                    $message->from($senderadmin, $fromNameadmin);
                });*/

       

        return $this->sendResponse($details, 'Kindly check your registered email.');
    }else{
        return $this->sendError('Email not exist.');

    }

    }
   }
   
   
   
   public function forgot_password_withmobile(Request $request){
    $data=$request->all();
    //dd($data);
    //$otp = rand(1000, 9999);
     $otp=1234;
    $rules = array(
        'mobile_no' => 'required',
    );

    $validator = Validator::make($data, $rules);
    if ($validator->fails()) {
        return $this->sendError($validator->errors()->first());
    }else{

    $datas=DB::table('customers')->where('mobile',$data['mobile_no'])->first();
    

    if($datas->mobile == $data['mobile_no']){

        DB::table('customers')->where('id', $datas->id)->update(['otp' => $otp]);

        $newdata=DB::table('customers')->where('id', $datas->id)->first();

       

        $details = [
            'customer_name' => $datas->customer_name,
            'id' => $datas->id,
            'otp' => $newdata->otp, 
            'email' => $datas->email,
            'mobile' => $datas->mobile,
        ];
        

        //$sid = "";
        //  $token = "";
        //  $client = new TwilioClient($sid, $token);
            
        //      $customerNumber = $client->lookups->v1->phoneNumbers("+91 $datas->mobile")->fetch();
        //      if ($customerNumber) {
        //          $client->messages->create(
        //              "+911234567890",
        //              [
        //                  'from' => '',
        //                  'body' => "Hi $datas->customer_name,Your Login OTP is $newdata->otp ."
        //              ]
        //          );
        //      }

        return $this->sendResponse($details, 'Kindly check your registered mobile number.');
    }else{
    
        return $this->sendError('Mobile no not exist.');

    }



}
}



public function verify_otp_forgotpassword(Request $request){
    $data=$request->all();
    
    $rules = array(
        'customer_id' => 'required',
        'otp' =>'required',
      
    );
    
    $validator = Validator::make($data, $rules);
    if ($validator->fails()) {
        return $this->sendError($validator->errors()->first());
    }else{
        $user=DB::table('customers')->where('id',$data['customer_id'])->first();
        if($data['otp'] == $user->otp ){

               return $this->sendResponse([], 'OTP matched.');
        }else{
            return $this->sendError('OTP not match');
        }
    }
   }



    public function reset_password(Request $request){
        $data=$request->all();
    
        $rules = array(
            'customer_id' => 'required',
            'new_password' =>'required|min:6',
        );
        
        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            return $this->sendError($validator->errors()->first());
        }else{
            $user=DB::table('customers')->where('id',$data['customer_id'])->first();
           if($user){
             DB::table('customers')->where('id',$data['customer_id'])->update([
              'password1' =>$data['new_password'],
                'password'=> bcrypt($data['new_password'])
             ]);
             return $this->sendResponse('','Password Reset Successfully.');
            }else{
                return $this->sendError('Customer not found');

            }
           

        }

    }


  public function login_with_otp(Request $request){
        $data = $request->all();
        $rules = array(
            'mobile_no' => 'required',
          //  'customer_type'=>'required'
             
        );

        $validator = Validator::make($data, $rules);
        
        if ($validator->fails()) {
            return $this->sendError($validator->errors()->first());
        } else {
         $datas=DB::table('customers')->where('mobile',$data['mobile_no'])->first();

        if($datas){
        
          if ($datas->customer_type !== $data['customer_type']) {
                return $this->sendResponse([],'Invalid customer type for this mobile number.');
            }
            
         $otp=1234;

          $updateotp=DB::table('customers')->where('id',$datas->id)->update([
             'otp'=>$otp
         ]);

        //  $sid = "";
        //  $token = "";
        //  $client = new TwilioClient($sid, $token);
 
       
            
        //      $customerNumber = $client->lookups->v1->phoneNumbers("+91 $datas->mobile")->fetch();
        //      if ($customerNumber) {
        //          $client->messages->create(
        //              "+917709697088",
        //              [
        //                  'from' => '',
        //                  'body' => "Hi $datas->customer_name,Your Login OTP is $otp ."
        //              ]
        //          );
        //      }

        
         $tech=DB::table('customers')->where('id', $datas->id)
         ->select('id as customer_id','customer_name','address','city','customer_type','mobile','created_at','updated_at','api_token')
         ->first();

        return $this->sendResponse($tech, 'OTP sent successfully.');
         

        }else{
            return $this->sendError('Mobile Number not exist.');
        }

    }

    }
/*public function login_with_otp(Request $request){
        $data = $request->all();
        $rules = array(
            'customer_id' => 'required',
            'otp' => 'required',
           
        );

        $validator = Validator::make($data, $rules);
        
        if ($validator->fails()) {
            return $this->sendError($validator->errors()->first());
        } else {
         $datas=DB::table('customers')->where('id',$data['customer_id'])->first();
         if($datas->otp == $data['otp']){
         $token= Str::random(60);
         
         DB::table('customers')->where('id',$data['customer_id'])->update(['api_token'=>$token]);
         $tech=DB::table('customers')->where('id', $data['customer_id'])->first();

        return $this->sendResponse($tech, 'User login successfully.');
         }else{
            return $this->sendError('OTP not matched.');

         }

        }
    }*/

    public function logout(Request $request)
     {
       
        
    $token = $request->header('Authorization');
   
    
    if ($token) {
      
        $token = str_replace('Bearer ', '', $token);

      
        $customer = DB::table('customers')->where('api_token', $token)->first();

        if ($customer) {
          
            DB::table('customers')->where('api_token', $token)->update(['api_token' => null]);

           
            return $this->sendResponse([], 'Logout successful.');
        } else {
            return $this->sendError('Invalid token or user not found.', 401);
        }
    } else {
        return $this->sendError('Authorization token not found.', 401);
    }
        
        
        
       // return $this->sendResponse([], 'User logged out successfully.');
         
     }
     
      public function login(){
    return $this->sendError('Token Mismatched.');

   }
   
   
   
   
   
   
   public function resend_otp(Request $request){
    $data = $request->all();
    $rules = array(
        'customer_id' => 'required',
        'mobile_no'=>'required',
    );

    $validator = Validator::make($data, $rules);
    
    if ($validator->fails()) {
        return $this->sendError($validator->errors()->first());
    } else {

        $datas=DB::table('customers')->where('id',$data['customer_id'])->first();

        if($datas){
        // $otp=1234;

        //  $updateotp=DB::table('customers')->where('id',$datas->id)->update([
        //     'otp'=>$otp
        //  ]);

        //  $sid = "";
        //  $token = "";
        //  $client = new TwilioClient($sid, $token);
 
       
            
        //      $customerNumber = $client->lookups->v1->phoneNumbers("+91 $datas->mobile")->fetch();
        //      if ($customerNumber) {
        //          $client->messages->create(
        //              "+911234567890",
        //              [
        //                  'from' => '',
        //                  'body' => "Hi $datas->customer_name,Your Login OTP is $otp ."
        //              ]
        //          );
        //      }

        
         $tech=DB::table('customers')->where('id', $datas->id)
         ->select('id as customer_id','customer_name','customer_type','address','city','mobile','created_at','updated_at')
         ->first();

        return $this->sendResponse($tech, 'OTP sent successfully.');
         


    }
}

}


    public function customer_profile(Request $request)
{
    $data = $request->all();
    $rules = array(
        'customer_id' => 'required',
    );

    $validator = Validator::make($data, $rules);

    if ($validator->fails()) {
        return $this->sendError($validator->errors()->first());
    } else {
        $id = $request->customer_id;

        $default_logo = url('uploads/user-profile/profile.png');

        $profile = DB::table('customers')->where('id', $id)->first();

        // Check if the profile exists
        if ($profile) {
            $profile->profile = ($profile->profile && strtolower($profile->profile) != 'null') 
                ? url('/uploads/user-profile/' . $profile->profile)
                : $default_logo;

            return $this->sendResponse($profile, 'Customer Profile retrieved successfully.');
        } else {
            return $this->sendError('Customer not found.');
        }
    }
}



public function update_customer_profile(Request $request)
{
    $data = $request->all();
    $rules = array(
        'customer_id' => 'required',
        
    );

    $validator = Validator::make($data, $rules);

    if ($validator->fails()) {
        return $this->sendError($validator->errors()->first());
    }

    $id = $request->customer_id;

    
    $customer = DB::table('customers')->where('id', $id)->first();
    if (!$customer) {
        return $this->sendError('Customer not found.');
    }

    
    $updateData = [
       
        'mobile' => $data['mobile'],
        'email' => $data['email'],
        'customer_name' => $data['customer_name'],
    ];

   
   
    
    $dms=DB::table('customers')->where('id',$id)->first();
        if($request->hasfile('profile_image')){
            $file = $request->file('profile_image');
            $extension = $file->getClientOriginalExtension();
            $profile = rand(11111111,99999999).'.'.$extension;
            $image_path = public_path('uploads/user-profile');
            $file->move($image_path,$profile);   
            $updateData['profile'] = $profile;         
        }else{
           $updateData['profile'] = $dms->profile;
        }
        

  
    DB::table('customers')->where('id', $id)->update($updateData);

    
    $updated = DB::table('customers')->where('id', $id)->first();

    
    $default_logo = url('uploads/user-profile/profile.png');
    $updated->profile = $updated->profile 
        ? url('/uploads/user-profile/' . $updated->profile) 
        : $default_logo;

    return $this->sendResponse($updated, 'Profile updated successfully.');
}



    public function change_password(Request $request){
        $data = $request->all();
        $rules = array(
            'customer_id' => 'required|exists:customers,id',
            'old_password' => 'required',
            'new_password' => 'required|min:6',
            'confirm_password' => 'required|same:new_password',
        );
    
       
        $validator = Validator::make($data, $rules);
        
        if ($validator->fails()) {
            return $this->sendError($validator->errors()->first());
        } else {
            $old_password = $request->old_password;
            $new_password = $request->new_password;
    
           
            $customer = DB::table('customers')->where('id', $data['customer_id'])->first();
    
          
            if (Hash::check($old_password, $customer->password)) {
               
                DB::table('customers')->where('id', $data['customer_id'])->update([
                    'password' => bcrypt($new_password),
                ]);
    
                return $this->sendResponse([], 'Password changed successfully.');
            } else {
                return $this->sendError('Old password does not match.');
            }
        }
    }



 public function delete_profilepicture(Request $request){
        $data = $request->all();
        $rules = array(
            'customer_id' => 'required',
        );
    
        $validator = Validator::make($data, $rules);
        
        if ($validator->fails()) {
            return $this->sendError($validator->errors()->first());
        } else {
    
            $datas=DB::table('customers')->where('id',$data['customer_id'])->update([
                'profile'=>url('uploads/user-profile/profile.png'),
            ]);
            $customer=DB::table('customers')->where('id',$data['customer_id'])->first();
            return $this->sendResponse($customer, 'Profile picture deleted successfully.');
    
        }
    }
    

 

}


