<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;


class UserController extends Controller
{
    public function sign_in(Request $request)
    {
        $credentials = $request->only('mobile', 'otp');
      
        
        
        $customer = DB::table('customers')->where('mobile', $credentials['mobile'])->first();
        
        
        if (!$customer) {
            return $this->sendError('Wrong Mobile No.');
        }
    
       
        if ($customer->otp !== $credentials['otp']) {
            return $this->sendError('Wrong OTP.');
        }
    
      
        if ($customer->status != 1) {
            return $this->sendError('You are not an active user.');
        }
    
       
        $token = Str::random(60);
        DB::table('customers')->where('mobile', $credentials['mobile'])->update(['remember_token' => $token]);
    
        session(['mobile' => $credentials['mobile']]);

        Log::info('Mobile stored in session: ' . session('mobile'));

        $updatedCustomer = DB::table('customers')->where('mobile', $credentials['mobile'])->first();

        return $this->sendResponse($updatedCustomer, 'User login successfully.');
    }
    

     public function sign_up(Request $request){
      $data=$request->all();
     
      $rules = array(
        'name' => 'required',
        'email' => 'required',
        'mobile' => 'required|numeric',
        'password' => 'required|same:conf_password',
    );
    
    $validator = Validator::make($data, $rules);
    if ($validator->fails()) {
        return $this->sendError($validator->errors()->first());
    }else{
      $datas= DB::table('customers')->insertGetId([
        'customer_name'=> $data['name'],
        'email'=> $data['email'],
        'mobile'=> $data['mobile'],
        'customer_type'=> $data['customer_type'],
        'password1'=> $data['password'],
        'password'=> bcrypt($data['conf_password']),
        'created_at' =>  date('Y-m-d H:i:s'),
        'updated_at' => date('Y-m-d H:i:s'),
      ]);
      $customer= DB::table('customers')->where('id',$datas)->first();
      return $this->sendResponse($customer, 'Customer registered successfully.');

      }
   
     }

     public function logout(Request $request)
     {
     
      //DB::table('customers')->where('mobile', $mobile)->update(['remember_token' => null]);
      return $this->sendResponse([], 'User logged out successfully.');
        
        /*if (session()->has('mobile')) {
            $mobile = session('mobile');
          
            Log::info('Logging out mobile: ' . $mobile);
            
            // Invalidate any token if needed (not necessary for session-based)
            DB::table('customers')->where('mobile', $mobile)->update(['remember_token' => null]);
            
            // Clear the session
            session()->forget('mobile');
            Log::info('Mobile removed from session.');

            return $this->sendResponse([], 'User logged out successfully.');
        } else {
            Log::warning('Logout attempt with no mobile in session.');
            return $this->sendError('User not found.');
        }*/
     }
     
     
     public function verify_email(Request $request){

        $data=$request->all();
     
      $rules = array(
        'verify_code' => 'required',
        'email' => 'required',
       
      );
    
        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            return $this->sendError($validator->errors()->first());
        }else{
           
            $emails=DB::table('customers')->where('email',$data['email'])->first();
            if($emails){
                 if($data['verify_code']==$emails->verify_code){
                    DB::table('customers')->where('email',$data['email'])->update([
                        'is_email_verified'=>1
                    ]);
                    return $this->sendResponse([], 'Email verification successfully.');
                 }else{
                    return $this->sendError('Wrong verification code.');
                 }
            }else{
                return $this->sendError('Email not exist.');
            }
        }

     }
     

     public function update_business_details(Request $request){
      $data=$request->all();

      $rules = array(
        'customer_id' => 'required',
        'gst_number' => 'required',
        'address' => 'required',
        'city' => 'required',
        'state' => 'required',
        'company_name' => 'required',
        'zipcode' => 'required',
        'msme' => 'required',
        
    );
    
    $validator = Validator::make($data, $rules);
    if ($validator->fails()) {
        return $this->sendError($validator->errors()->first());
    }else{

        $customerid=$data['customer_id'];
                $check=DB::table('customers')->where('id',$data['customer_id'])->first();
        if($check){
        
        

        DB::table('customers')->where('id',$customerid)->update([
            'gst_number'=>$data['gst_number'],
            'msme'=>$data['msme'],
            'address'=>$data['address'],
            'city'=>$data['city'],
            'state'=>$data['state'],
            'company_name'=>$data['company_name'],
            'zipcode'=>$data['zipcode'],
        ]);

        $details=DB::table('customers')->where('id',$data['customer_id'])->first();

        return $this->sendResponse($details, 'Business details updated successfully.');
        }else{
           return $this->sendError('Customer not exist.');
        }

     }

     }

    

}
