<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
    public function sendResponse($result, $message,$code = 200)
    {
    	$response = [
            'success' => true,
            'data'    => $result,
            'status' =>  $code,
            'message' => $message,
        ];


        return response()->json($response, 200);
    }
    public function sendResponse1($message)
    {
    	$response = [
            'success' => true,
            'message' => $message,
        ];


        return response()->json($response, 200);
    }


    /**
     * return error response.
     * @return \Illuminate\Http\Response
     */
    public function sendError($error, $errorMessages = [], $code = 400)
    {
    	$response = [
            'success' => false,
            'status'=>$code,
            'message' => $error,
            
        ];


        if(!empty($errorMessages)){
            $response['data'] = $errorMessages;
        }


        return response()->json($response, $code);
    }

    public function sendFilePathResponse($path, $message, $code = 200)
    {
        $response = [
            'success' => true,
            'data'    => ['path' => $path],
            'status'  => $code,
            'message' => $message,
        ];

        return response()->json($response, $code);
   }


}

