<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class InstallerController extends Controller
{

    public function installer_index(){
       
        $user = Auth::guard('installer')->user();
       
        return view('installer.installer_index',compact('user'));
    }
    public function dashboard(){

        dd('dashboard');
    }
  
   

    public function profile(){
        $user = Auth::guard('installer')->user();
        //dd($user->id);
        $profile=DB::table('users')->where('id',$user->id)->first();
        
        return view('installer.profile',compact('profile','user'));
    }

    public function update_profile(Request $request){
        //dd($request->all());
        $id=$request->id;
        $name=$request->full_name;
        $email=$request->email;
        $username=$request->username;
        $password=bcrypt($request->password);
        
         DB::table('users')->where('id', $id)->update([
                'full_name' => $name,
                'email' => $email,
                'username' => $username,
                'password' => $password,
                'updated_at' => date('Y-m-d H:i:s'),
            ]);
          return redirect()->back()->with('success', 'Profile updated successfully.');
        }


        
        public function change_password(Request $request){
            $user = Auth::guard('installer')->user();
            return view('installer.change_password',compact('user'));
           
        }


    public function update_password(Request $request){
        $data=$request->all();
        $rules = array(
            'id' => 'required|exists:users,id',
            'crpassword' => 'required',
            'password' => 'required',
            'cnfpassword' => 'required|same:password',
        );
       
        $validator = Validator::make($data, $rules);
        
        if ($validator->fails()) {
            return redirect()->back()->with('error', 'New Password and Confirm Password must match');
            
        } {

        $id=$request->id;
        $crpassword= $request->crpassword;
        $password= $request->password;
        

        $user = DB::table('users')->where('id', $id)->first();
    
          
        if (Hash::check($crpassword, $user->password)) {
           
            DB::table('users')->where('id', $id)->update([
                'password' => bcrypt($password),
            ]);
            return redirect()->back()->with('success','Password changed successfully.');
            
        } else {
            return redirect()->back()->with('error','Current password does not match.');
            
        }

        }

       
    }


    public function orders(Request $request)
    {
        //dd(5);
         $user = Auth::guard('installer')->user();
        
        $query = DB::table('orders')
            ->join('customers', 'customers.id', '=', 'orders.customer_id')
            ->leftJoin('companies', 'companies.id', '=', 'orders.company_id')
            ->select('orders.*', 'customers.customer_name', 'companies.company_name')
            ->whereNull('orders.deleted_at')
            ->where('orders.installer_id',$user->id)
            ->orderBy('id','desc');

        // Apply Filters
        if (!empty($request->customer_id)) {
            
            $query->where('orders.customer_id', $request->customer_id);
        }

        if (!empty($request->start_date)) {
            $query->whereDate('orders.order_date', '>=', $request->start_date);
        }

        if (!empty($request->end_date)) {
            $query->whereDate('orders.order_date', '<=', $request->end_date);
        }

        $orders = $query->get();

        if ($request->ajax()) {
            //dd($orders);
            return response()->json(['orders' => $orders]);
        }

        $customers = DB::table('customers')->whereNull('deleted_at')->get();
        return view('installer.orders', compact('orders', 'customers','user'));
    }

    public function view_order($id){
        $user = Auth::guard('installer')->user();
       
        $default_logo = url('uploads/images.jpg');
        $orderDetails = DB::table('orders')
        ->join('customers', 'customers.id', '=', 'orders.customer_id')
        ->where('orders.id', $id)
        ->select('orders.id as order_id', 'orders.order_code', 'orders.order_date','orders.updated_at','orders.order_amount','orders.payment_status', 'customers.customer_name','customers.email','customers.phone1','customers.phone2','customers.mobile','customers.address','orders.subtotal','orders.grandtotal','orders.transporter_id', 'orders.status')
        ->first();
       // dd($orderDetails);
        $orderItems = DB::table('order_items')
        ->join('products', 'products.id', '=', 'order_items.product_id')
        ->leftJoin('product_variant', 'product_variant.id', '=', 'order_items.varient_id')
        ->select('order_items.order_id', 'products.product_name', 'product_variant.varient_name', 'product_variant.varient_image','order_items.quantity','order_items.price')
        ->where('order_items.order_id', $id)
        ->get()
        ->map(function ($variant) use ($default_logo) {
            $variant->varient_image = $variant->varient_image
                ? url('uploads/products/' . $variant->varient_image)
                : $default_logo;
            return $variant;
        });
        $orderItemscount = DB::table('order_items')
        ->where('order_items.order_id', $id)
        ->count();
        
        $transporters =DB::table('transporters')->where('deleted_at',null)->get();
        $installer =DB::table('users')->where('type_id',5)->where('deleted_at',null)->get();
        
        $transporter_data =DB::table('transporters')->where('id',$orderDetails->transporter_id)->first();
       //dd($transporter_data);
        $response = [
            'order_details' => $orderDetails,
            'order_items' => $orderItems,
            'transporters' => $transporters,
            'transporter_data'=>$transporter_data,
            'orderItemscount'=>$orderItemscount,
            'installer'=>$installer,
            
        ];
       
        
       //dd($response);
       return view('installer.view_order',compact('response','user'));
   
    }

    public function getRollsmapping($order_id)
    {
     
        $rolls = DB::table('order_roll_mapping')
        ->join('customers', 'order_roll_mapping.customer_id', '=', 'customers.id')
        ->join('users', 'order_roll_mapping.installer_id', '=', 'users.id')
        ->join('order_items', 'order_roll_mapping.order_item_id', '=', 'order_items.id')
         ->join('orders', 'order_roll_mapping.order_id', '=', 'orders.id')
        ->join('product_variant', 'order_items.varient_id', '=', 'product_variant.id')
            ->where('order_roll_mapping.order_id',$order_id)
            ->orderBy('order_roll_mapping.id','asc')
            ->select('order_roll_mapping.*','orders.order_code','product_variant.varient_name','customers.customer_name as customer_name','users.full_name as installer_name')
            ->get();
          //dd($rolls);
        return response()->json($rolls);
    }

    public function updateRollStatus(Request $request)
    {
        try {
            $roll_id = $request->roll_id;
            $order_id = $request->order_id;
            $status = $request->status;
    
            // Start a database transaction
            DB::beginTransaction();
    
            // Check if the roll belongs to the given order
            $rollExists = DB::table('order_roll_mapping')
                ->where('roll_id', $roll_id)
                ->where('order_id', $order_id)
                ->exists();
    
            if (!$rollExists) {
                // Rollback the transaction if the roll does not exist
                DB::rollBack();
                return response()->json([
                    'success' => false,
                    'message' => 'Invalid roll_id or order_id!',
                ], 400);
            }
    
            // Update the roll status
            $updated = DB::table('order_roll_mapping')
                ->where('roll_id', $roll_id)
                ->update(['installer_status' => $status]);
    
            if (!$updated) {
                // Rollback the transaction if the update fails
                DB::rollBack();
                return response()->json([
                    'success' => false,
                    'message' => 'No records updated, check if roll_id exists.',
                ], 400);
            }
    
            // Check if all rolls for this order have the status 'cutting done'
            $allCuttingDone = DB::table('order_roll_mapping')
                ->where('order_id', $order_id)
                ->where('installer_status', '!=', 'Cutting Done')
                ->doesntExist();
    
            // If all rolls are marked as 'cutting done', update the order status to 'Cutting'
            if ($allCuttingDone) {
                DB::table('orders')
                    ->where('id', $order_id)
                    ->update(['status' => 'Cutting Done']);
                    
                    $exists = DB::table('track_orders')
                ->where('order_id', $order_id)
                ->where('status', 'Cutting Done')
                ->exists();
                
                if (!$exists) {
			   DB::table('track_orders')->insert([
				'order_id' => $order_id,
				'status' => 'Cutting Done',
				'message'=>'Your order is being cut',
				'created_at' => now()
				
			    ]);
			}

                
            }
    
            // Commit the transaction
            DB::commit();
    
            return response()->json([
                'success' => true,
                'message' => 'Roll status updated successfully!',
            ], 200);
        } catch (\Exception $e) {
            // Rollback the transaction in case of an exception
            DB::rollBack();
            return response()->json([
                'success' => false,
                'message' => 'Something went wrong: ' . $e->getMessage(),
            ], 500);
        }
    }
    
    


}
