<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Dompdf\Options;
use Barryvdh\DomPDF\Facade\Pdf;
use function Ramsey\Uuid\v1;

class InventoryController extends Controller
{


    
   
    public function purchase_orders(Request $request) {
        $title='Purchase Orders';
        $query = DB::table('purchase_orders')
            ->join('companies', 'purchase_orders.company_id', '=', 'companies.id')
            ->join('suppliers', 'purchase_orders.supplier_id', '=', 'suppliers.id')
            ->select('purchase_orders.*', 'companies.company_name', 'suppliers.supplier_name')
            ->whereNull('purchase_orders.deleted_at')
            ->orderBy('purchase_orders.po_number', 'desc');
            
    
    
        if (!empty($request->supplier_id)) {
            $query->where('purchase_orders.supplier_id', $request->supplier_id);
        }

        if (!empty($request->start_date)) {
            $query->whereDate('purchase_orders.po_date', '>=', $request->start_date);
        }

        if (!empty($request->end_date)) {
            $query->whereDate('purchase_orders.po_date', '<=', $request->end_date);
        }
    
        $purchase_orders = $query->get();

        if ($request->ajax()) {
            
            return response()->json(['purchase_orders' => $purchase_orders]);
        }

        $suppliers=DB::table('suppliers')->where('deleted_at',null)->get();

       // dd($purchase_orders);
    
        return view('admin.purchaselist', compact('purchase_orders','suppliers','title'));
    }
    

    public function add_purchase_order(Request $request){
        $title='Add Purchase Order';
        $lastCompany = DB::table('purchase_orders')->orderBy('po_number', 'desc')->where('deleted_at',null)->first();
        if ($lastCompany) {
            $lastIdNumber = (int) substr($lastCompany->po_number, 2); 
            $newPOId = 'PO' . str_pad($lastIdNumber + 1, 6, '0', STR_PAD_LEFT); 
        } else {
            $newPOId = 'PO000001';
        }
        $companies=DB::table('companies')->where('deleted_at',null)->get();
        $suppliers=DB::table('suppliers')->where('deleted_at',null)->get();
        $transporters=DB::table('transporters')->where('deleted_at',null)->get();
        $varients=DB::table('product_variant')->where('deleted_at',null)->get();
        $units=DB::table('units')->where('deleted_at',null)->get();

        return view('admin.add_purchase',compact('companies','title','suppliers','newPOId','transporters','varients','units'));
    }

    public function save_purchase_order(Request $request)
    {

        // Begin transaction
        DB::beginTransaction();
        
        

        try {
        
         $supplier = DB::table('suppliers')->where('id',$request->supplier)->first();
            // Create Purchase Order (Insert into purchase_orders table)
            
            $firstGstPercent = $request->gst_percent[0] ?? 0;
            
            $purchaseOrderId = DB::table('purchase_orders')->insertGetId([
                'po_number' => $request->po_number,
                'po_date' => $request->po_date,
                'company_id' => $request->company,
                'supplier_id' => $request->supplier,
                'product_id' => 0,
                'transporter_id' => $request->transporter,
                'subtotal' => $request->subtotal,
                'gst_amount' => $request->gst_amount_data,
                'grand_total' => $request->grand_total,
                'f_percent' => $request->f_percent,
                'f_amount' => $request->f_amount,
                'forwarding' => $request->forwarding,
                'gst_rate'=>$firstGstPercent,
                'note' => $request->note,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            // Loop through the items and save them
            foreach ($request->varient_id as $key => $varientId) {
                // Null-safe access to array elements
                  $product = $request->product_id[$key] ?? 0;
                $noOfRolls = $request->no_of_rolls[$key] ?? 0;
                $uom = $request->uom[$key] ?? null;
                $rate = $request->rate[$key] ?? 0;
                $quantity = $request->quantity[$key] ?? 0;
                $gstPercent = $request->gst_percent[$key] ?? 0;
                $total = $request->total[$key] ?? 0;
                $netTotal = $request->net_total[$key] ?? 0;

                // Insert into purchase_order_items table
               $poitemid = DB::table('purchase_order_items')->insertGetId([
                    'purchase_order_id' => $purchaseOrderId,
                    'product_id' => $product,
                    'varient_id' => $varientId,
                    'no_of_rolls' => $noOfRolls,
                    'uom' => $uom,
                    'rate' => $rate,
                    'quantity' => $quantity,
                    'gst_percent' => $gstPercent,
                    'total' => $total,
                    'net_total' => $netTotal,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);

                DB::table('estimation_po')->insert([
                    'po_id' => $purchaseOrderId,
                    'po_item_id' => $poitemid,
                    'varient_id' => $varientId,
                    'no_of_rolls' => $noOfRolls,
                    'unit_id' => $uom,
                    'quantity' => $quantity,
                    'rate' => $rate,
                    'total' => $total,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);

            }

            // Commit transaction
            DB::commit();
            
        //                 $senderadmin = 'info@rush.speakwise.site';
        //              //  $recieveradmin = $supplier->email;
        //                $recieveradmin ='rushikeshwakde.oms@gmail.com';
        //                $fromNameadmin = 'Floor Factory';
                    
        //                 // Generate the PDF content for the purchase order
           
        //       $purchaseOrder = DB::table('purchase_orders')
        //     ->join('companies','purchase_orders.company_id','=','companies.id')
        //     ->join('suppliers','purchase_orders.supplier_id','=','suppliers.id')
        //     ->join('transporters','purchase_orders.transporter_id','=','transporters.id')
        //     ->select('purchase_orders.*','companies.company_name','companies.address','suppliers.supplier_name','suppliers.address as supplier_address','transporters.transporter_name')
        //     ->where('purchase_orders.id', $purchaseOrderId)
        //     ->first();
            
            
        //       $purchaseOrderItems = DB::table('purchase_order_items')
        //      ->where('purchase_order_id', $purchaseOrderId)
        //      ->join('product_variant','purchase_order_items.varient_id','=','product_variant.id')
        //       ->join('products','purchase_order_items.product_id','=','products.id')
        //       ->join('units','purchase_order_items.uom','=','units.id')
        //      ->select('purchase_order_items.*','product_variant.id as varid','product_variant.varient_name','product_variant.varient_code','units.id as unit_id','units.unit_name as uom','products.product_name')
        //      ->get();
         
            
          

        //     $pdf = \PDF::loadView('emails.purchase_order', [
        //         'purchaseOrder' => $purchaseOrder,
        //         'supplier' => $supplier,
        //         'purchaseOrderItems' => $purchaseOrderItems
        //     ]);
            
        //     $emailContent = "Hello " . $purchaseOrder->supplier_name . ",<br><br>";
        // $emailContent .= "We are pleased to place an order with you. Please find the attached purchase order for your reference.<br><br>";
        // $emailContent .= "For any further queries, feel free to reach out.<br><br>";
        // $emailContent .= "Best regards,<br>";
        // $emailContent .= "Kukreja Interiors";

        
        
        
        //     Mail::send('emails.purchase_order_email', ['supplierName' => $purchaseOrder->supplier_name], function ($message) use ($pdf, $recieveradmin, $senderadmin, $fromNameadmin, $purchaseOrder) {
        //         $message->to($recieveradmin)
        //         ->subject('Purchase Order Invoice')
        //         ->from($senderadmin, $fromNameadmin)
        //         ->attachData($pdf->output(), 'purchase_order_' . $purchaseOrder->po_number . '.pdf', [
        //             'mime' => 'application/pdf'
        //         ]);
        //     });


            // Redirect or return response
            return redirect()->route('preview_purchase_order', ['id' => $purchaseOrderId])
               ->with('success', 'Purchase Order saved. Review and send mail.');

           
        } catch (\Exception $e) {
            // Rollback transaction in case of error
            DB::rollback();
            return back()->with('error', 'Error creating purchase order: ' . $e->getMessage());
        }
    }

    public function inwards(){
        $title='Inward List';
        $inwards = DB::table('inventory')
        ->join('products', 'inventory.product_id', '=', 'products.id')
         ->join('purchase_orders', 'inventory.po_number', '=', 'purchase_orders.id')
        ->join('product_variant', 'inventory.product_varient', '=', 'product_variant.id')
        ->join('companies', 'inventory.company_id', '=', 'companies.id')
        ->join('categories', 'inventory.category_id', '=', 'categories.id')
        ->join('units', 'inventory.unit_id', '=', 'units.id')
        ->join('warehouses', 'inventory.warehouse_id', '=', 'warehouses.id')
        ->join('suppliers', 'inventory.supplier_id', '=', 'suppliers.id')
        ->where('inventory.deleted_at', null)
        ->orderBy('inventory.id','desc')
        ->select('products.product_name','purchase_orders.po_number as purchase_order_number','product_variant.varient_name','companies.company_name','categories.category_name','units.unit_name',
        'warehouses.warehouse_name','suppliers.supplier_name','inventory.*') 
        ->get();
       
         $warehouses=DB::table('warehouses')->where('deleted_at',null)->get();
        return view('admin.inwards',compact('inwards','warehouses','title'));
    }

   /* public function edit_purchase_order($id) {
        // Fetch all companies and suppliers
        $companies = DB::table('companies')->whereNull('deleted_at')->get();
        $suppliers = DB::table('suppliers')->whereNull('deleted_at')->get();
        $transporters=DB::table('transporters')->where('deleted_at',null)->get();
        $products=DB::table('products')->where('deleted_at',null)->get();


       // $varients=DB::table('product_variant')->where('deleted_at',null)->get();

        $units=DB::table('units')->where('deleted_at',null)->get();

        // Fetch the main purchase order details
        $purchase_order = DB::table('purchase_orders')
            ->where('id', $id)
            ->first();

            $supplierId=$purchase_order->supplier_id;

        // Fetch the associated items for this purchase order
        $order_items = DB::table('purchase_order_items')
            ->where('purchase_order_id', $id)
            ->get();

        // Structure the data with order items as an array
        $po_details = [
            'id'=>$purchase_order->id,
            'po_number' => $purchase_order->po_number,
            'po_date' => $purchase_order->po_date,
            'company_id' => $purchase_order->company_id,
            'supplier_id' => $purchase_order->supplier_id,
            'transporter_id' => $purchase_order->transporter_id,
            'subtotal' => $purchase_order->subtotal,
            'gst_amount' => $purchase_order->gst_amount,
            'cgst_amount' => $purchase_order->cgst_amount,
            'sgst_amount' => $purchase_order->sgst_amount,
            'igst_amount' => $purchase_order->igst_amount,
            'f_percent' => $purchase_order->f_percent,
            'f_amount' => $purchase_order->f_amount,
            'forwarding' => $purchase_order->forwarding,
            'note' => $purchase_order->note,
            'grand_total' => $purchase_order->grand_total,
            'created_at' => $purchase_order->created_at,
            'updated_at' => $purchase_order->updated_at,
            'items' => $order_items,
        ];

        //dd($po_details);

        $varients = DB::table('product_variant')
        ->join('products', 'product_variant.product_id', '=', 'products.id')
        ->where('products.supplier_id', $supplierId)
        ->select('product_variant.id','product_variant.varient_name','product_variant.varient_code')
        ->get();


        return view('admin.edit_purchase_order', compact('units','po_details', 'suppliers', 'companies','transporters','varients','products'));
    }*/

   public function preview_purchase_order($id)
{
    $title='Preview Purchase Order';
    // Fetch all companies and suppliers
    $companies = DB::table('companies')->whereNull('deleted_at')->get();
    $suppliers = DB::table('suppliers')->whereNull('deleted_at')->get();
    $transporters = DB::table('transporters')->whereNull('deleted_at')->get();
    $units = DB::table('units')->whereNull('deleted_at')->get();

    // Fetch the main purchase order
    $purchase_order = DB::table('purchase_orders')->where('id', $id)->first();
    $supplierId = $purchase_order->supplier_id;

    // Fetch all products related to selected supplier
   $products = DB::table('products')
    ->whereNull('deleted_at')
    ->whereRaw('FIND_IN_SET(?, supplier_id)', [$supplierId])
    ->get();


    // Fetch the associated items with product_id included
    $order_items = DB::table('purchase_order_items')
        ->where('purchase_order_id', $id)
        ->get();
        

     

    // Fetch only variants that belong to the supplier's products
    $productIds = $products->pluck('id');
    $varients = DB::table('product_variant')
        ->whereIn('product_id', $productIds)
        ->whereNull('deleted_at')
        ->get();

    $variants_by_product = DB::table('product_variant')
    ->whereIn('product_id', $productIds)
    ->whereNull('deleted_at')
    ->get()
    ->groupBy('product_id');

    // Structure PO details
    $po_details = [
        'id' => $purchase_order->id,
        'po_number' => $purchase_order->po_number,
        'po_date' => $purchase_order->po_date,
        'company_id' => $purchase_order->company_id,
        'supplier_id' => $purchase_order->supplier_id,
        'transporter_id' => $purchase_order->transporter_id,
        'subtotal' => $purchase_order->subtotal,
        'gst_amount' => $purchase_order->gst_amount,
        'cgst_amount' => $purchase_order->cgst_amount,
        'sgst_amount' => $purchase_order->sgst_amount,
        'igst_amount' => $purchase_order->igst_amount,
        'f_percent' => $purchase_order->f_percent,
        'f_amount' => $purchase_order->f_amount,
        'forwarding' => $purchase_order->forwarding,
        'note' => $purchase_order->note,
        'grand_total' => $purchase_order->grand_total,
        'created_at' => $purchase_order->created_at,
        'updated_at' => $purchase_order->updated_at,
        'items' => $order_items,
    ];

    return view('admin.preview_purchase_order', compact(
        'units',
        'po_details',
        'suppliers',
        'companies',
        'transporters',
        'products',
        'varients',
        'variants_by_product',
        'title'
    ));
}

    public function edit_purchase_order($id)
    {
        $title='Edit Purchase Order';
        // Fetch all companies and suppliers
        $companies = DB::table('companies')->whereNull('deleted_at')->get();
        $suppliers = DB::table('suppliers')->whereNull('deleted_at')->get();
        $transporters = DB::table('transporters')->whereNull('deleted_at')->get();
        $units = DB::table('units')->whereNull('deleted_at')->get();

        // Fetch the main purchase order
        $purchase_order = DB::table('purchase_orders')->where('id', $id)->first();
        $supplierId = $purchase_order->supplier_id;

        // Fetch all products related to selected supplier
    $products = DB::table('products')
        ->whereNull('deleted_at')
        ->whereRaw('FIND_IN_SET(?, supplier_id)', [$supplierId])
        ->get();


        // Fetch the associated items with product_id included
        $order_items = DB::table('purchase_order_items')
            ->where('purchase_order_id', $id)
            ->get();
            

        

        // Fetch only variants that belong to the supplier's products
        $productIds = $products->pluck('id');
        $varients = DB::table('product_variant')
            ->whereIn('product_id', $productIds)
            ->whereNull('deleted_at')
            ->get();

        $variants_by_product = DB::table('product_variant')
        ->whereIn('product_id', $productIds)
        ->whereNull('deleted_at')
        ->get()
        ->groupBy('product_id');

        // Structure PO details
        $po_details = [
            'id' => $purchase_order->id,
            'po_number' => $purchase_order->po_number,
            'po_date' => $purchase_order->po_date,
            'company_id' => $purchase_order->company_id,
            'supplier_id' => $purchase_order->supplier_id,
            'transporter_id' => $purchase_order->transporter_id,
            'subtotal' => $purchase_order->subtotal,
            'gst_amount' => $purchase_order->gst_amount,
            'cgst_amount' => $purchase_order->cgst_amount,
            'sgst_amount' => $purchase_order->sgst_amount,
            'igst_amount' => $purchase_order->igst_amount,
            'f_percent' => $purchase_order->f_percent,
            'f_amount' => $purchase_order->f_amount,
            'forwarding' => $purchase_order->forwarding,
            'note' => $purchase_order->note,
            'grand_total' => $purchase_order->grand_total,
            'created_at' => $purchase_order->created_at,
            'updated_at' => $purchase_order->updated_at,
            'items' => $order_items,
        ];

        return view('admin.edit_purchase_order', compact(
            'units',
            'po_details',
            'suppliers',
            'companies',
            'transporters',
            'products',
            'varients',
            'variants_by_product',
            'title'
        ));
    }


    public function update_purchase_order(Request $request)
    {
        // dd($request->all());
        DB::beginTransaction();
        $id = $request->id; // Purchase order ID

        try {
        
            $supplier = DB::table('suppliers')->where('id',$request->supplier)->first();
         
            // Update the main Purchase Order in the `purchase_orders` table
            DB::table('purchase_orders')
                ->where('id', $id)
                ->update([
                    'po_date' => $request->po_date,
                    'po_number' => $request->po_number,
                    'company_id' => $request->company,
                    'supplier_id' => $request->supplier,
                    'transporter_id' => $request->transporter,
                    'subtotal' => $request->subtotal,
                    'gst_amount' => $request->gst_amount,
                    'f_percent' => $request->f_percent,
                    'f_amount' => $request->f_amount,
                    'forwarding' => $request->forwarding,
                    'grand_total' => $request->grand_total,
                    'note' => $request->note,
                    'updated_at' => now(),
                ]);

            // Remove old items before adding/updating
            DB::table('purchase_order_items')
                ->where('purchase_order_id', $id)
                ->delete();

             DB::table('estimation_po')->where('po_id', $id)->delete();
               


            // Loop through the updated items and insert them
            foreach ($request->varient_id as $key => $varientId) {
                $product = $request->product_id[$key] ?? 0;
                  $noOfRolls = $request->no_of_rolls[$key] ?? 0;
                $uom = $request->uom[$key] ?? null;
                $rate = $request->rate[$key] ?? 0;
                $quantity = $request->quantity[$key] ?? 0;
                $gstPercent = $request->gst_percent[$key] ?? 0;
                $total = $request->total[$key] ?? 0;
                $netTotal = $request->net_total[$key] ?? 0;

                // Insert the updated/new items
                 $poitemid =DB::table('purchase_order_items')->insertGetId([
                    'purchase_order_id' => $id, // Use the correct purchase order ID
                    'product_id' => $product,
                    'varient_id' => $varientId,
                    'no_of_rolls' => $noOfRolls,
                    'uom' => $uom,
                    'rate' => $rate,
                    'quantity' => $quantity,
                    'gst_percent' => $gstPercent,
                    'total' => $total,
                    'net_total' => $netTotal,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);


                DB::table('estimation_po')->insert([
                    'po_id' => $id,
                    'po_item_id' => $poitemid,
                    'varient_id' => $varientId,
                    'no_of_rolls' => $noOfRolls,
                    'unit_id' => $uom,
                    'quantity' => $quantity,
                    'rate' => $rate,
                    'total' => $total,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);

            }


            


            // Commit transaction
            DB::commit();
            
             $senderadmin = 'info@rush.speakwise.site';
                     //  $recieveradmin = $customer->email;
                       $recieveradmin ='rushikeshwakde.oms@gmail.com';
                       $fromNameadmin = 'Floor Factory';
                    
                    
                        
                        
                        // Generate the PDF content for the purchase order
           
              $purchaseOrder = DB::table('purchase_orders')
            ->join('companies','purchase_orders.company_id','=','companies.id')
            ->join('suppliers','purchase_orders.supplier_id','=','suppliers.id')
            ->join('transporters','purchase_orders.transporter_id','=','transporters.id')
            ->select('purchase_orders.*','companies.company_name','companies.address','suppliers.supplier_name','suppliers.address as supplier_address','transporters.transporter_name')
            ->where('purchase_orders.id', $id)
            ->first();
            
            
              $purchaseOrderItems = DB::table('purchase_order_items')
             ->where('purchase_order_id', $id)
             ->join('product_variant','purchase_order_items.varient_id','=','product_variant.id')
             ->join('products','purchase_order_items.product_id','=','products.id')
              ->join('units','purchase_order_items.uom','=','units.id')
             ->select('purchase_order_items.*','product_variant.id as varid','product_variant.varient_name','product_variant.varient_code','units.id as unit_id','units.unit_name as uom','products.product_name')
             ->get();
         
            
          

            $pdf = \PDF::loadView('emails.purchase_order', [
                'purchaseOrder' => $purchaseOrder,
                'supplier' => $supplier,
                'purchaseOrderItems' => $purchaseOrderItems
            ]);

            $emailContent = "Hello " . $purchaseOrder->supplier_name . ",<br><br>";
            $emailContent .= "We are pleased to place an order with you. Please find the attached purchase order for your reference.<br><br>";
            $emailContent .= "For any further queries, feel free to reach out.<br><br>";
            $emailContent .= "Best regards,<br>";
            $emailContent .= "Kukreja Interiors";

        
        
        
            Mail::send('emails.purchase_order_email', ['supplierName' => $purchaseOrder->supplier_name], function ($message) use ($pdf, $recieveradmin, $senderadmin, $fromNameadmin, $purchaseOrder) {
                $message->to($recieveradmin)
                    ->subject('Purchase Order Invoice')
                    ->from($senderadmin, $fromNameadmin)
                    ->attachData($pdf->output(), 'purchase_order_' . $purchaseOrder->po_number . '.pdf', [
                        'mime' => 'application/pdf'
                    ]);
            });

             if($request->preview == 1){

                $datas=DB::table('purchase_orders')->where('id',$id)->update([
                    'preview'=> 1
                ]);
            }


            // Redirect with a success message
            return redirect()->route('purchase_orders')->with('success', 'Purchase Order Updated Successfully! Mail sent to supplier');
        } catch (\Exception $e) {
            // Rollback transaction in case of error
            DB::rollback();

            // Redirect back with an error message
            return back()->with('error', 'Error updating purchase order: ' . $e->getMessage());
        }
    }

    public function add_inward(){
        $title='Add Inward';
        $purchase_orders=DB::table('purchase_orders')
        ->where('inward_status','<>',1)
        ->where('preview',1)
        ->where('deleted_at',null)->get();
    
     $brands=DB::table('brands')->where('deleted_at',null)->get();
     $companies=DB::table('companies')->where('deleted_at',null)->get();
     $suppliers=DB::table('suppliers')->where('deleted_at',null)->get();
     $warehouses=DB::table('warehouses')->where('deleted_at',null)->get();
     $units=DB::table('units')->where('deleted_at',null)->get();
     $categories=DB::table('categories')->where('deleted_at',null)->get();
     $subcategories=DB::table('sub_categories')->where('deleted_at',null)->get();
     $products=DB::table('products')->where('deleted_at',null)->get();
     $product_variant=DB::table('product_variant')->where('deleted_at',null)->get();
     $pricing=DB::table('pricing')->where('deleted_at',null)->get();
     $roll = DB::table('rolls')->whereNull('deleted_at')->orderBy('id', 'desc')->first();
     
      $rolls = DB::table('rolls')->join('companies', 'rolls.company_id', '=', 'companies.id')
     ->whereNull('rolls.deleted_at')
     ->where('rolls.inward_id',$roll->inward_id ?? '')
     ->orderBy('rolls.id','desc')
     ->select('rolls.*','companies.id as company_id','companies.company_id as cmpid','companies.company_name')
     ->get();
     
     //dd($roll);
     $lastCompany = DB::table('products')->orderBy('product_code', 'desc')->where('deleted_at',null)->first();

    
     if ($lastCompany) {
         $lastIdNumber = (int) substr($lastCompany->product_code, 2); 
         $newProductId = 'PR' . str_pad($lastIdNumber + 1, 6, '0', STR_PAD_LEFT);
     } else {
         $newProductId = 'PR000001';
     }
      
      
      $lastCompanypr = DB::table('product_variant')->orderBy('varient_code', 'desc')->where('deleted_at',null)->first();

    
     if ($lastCompanypr) {
         $lastIdNumberpr = (int) substr($lastCompanypr->varient_code, 2); 
         $newProductvarId = 'PV' . str_pad($lastIdNumberpr + 1, 6, '0', STR_PAD_LEFT); 
     } else {
         $newProductvarId = 'PV000001';
     }
     
      

 

        $inwards = DB::table('inventory')->orderBy('id', 'desc')->where('deleted_at',null)->first();
         
        if ($inwards) {
        $lastIdNumberinv = (int) substr($inwards->inward_no, 3); // Extract numeric part correctly
        $invno = 'INV' . str_pad($lastIdNumberinv + 1, 5, '0', STR_PAD_LEFT);
        } else {
        
        $invno = 'INV00001';
        }
     
     return view('admin.add_inventory',compact('purchase_orders','title','invno','companies','newProductId','newProductvarId','roll','brands','rolls','warehouses','suppliers','categories','subcategories','units','products','product_variant','pricing'));
   
    }


    public function view_inward_data($id){
         
            $title='View Inward Data';
            $item = DB::table('estimated_po')
            ->join('product_variant','estimated_po.varient_id','=','product_variant.id')
            ->join('units','estimated_po.unit','=','units.id')
            ->where('estimated_po.inward_id', $id)
            ->select('estimated_po.*','product_variant.id as varid','product_variant.varient_name','product_variant.varient_code','units.id as unit_id','units.unit_name as uom')
            ->first();
          
             return view('admin.view_inward_rolls',compact('item','title'));


        }

    

    public function save_inward(Request $request){
        $inward_no=$request->inward_no;
         $company_id=$request->company_id;
         $category_id=$request->category_id;
         $product_id=$request->product_id;
         $product_varient=$request->product_varient;
         $roll=$request->roll;
         $hsn_code=$request->hsn_code;
         $unit_id=$request->unit_id;
         $warehouse_id=$request->warehouse_id;
         $quantity=$request->quantity;
         $no_of_rolls=$request->no_of_rolls;
         $display=$request->display;
         $stock=$request->stock;
         $available_rolls=$request->available_rolls;
         $qunatity_on_hand=$request->qunatity_on_hand;
         $supplier_id=$request->supplier_id;
         $po_no=$request->po_no;
         $gst_rate=$request->gst_rate;
         $basic_cost=$request->basic_cost;
         $purchase_cost=$request->purchase_cost;
         $retail_profit_margin=$request->retail_profit_margin;
         $retail_price=$request->retail_price;
         $effective_date=$request->effective_date;
           
         
         
         $value=$request->value;

        $datas= DB::table('inventory')->insertGetId([
        'inward_no'=>$inward_no,
            'company_id' => $company_id,
            'category_id' => $category_id,
            'product_id' => $product_id,
            'product_varient' => $product_varient,
            'roll' => $roll,
            'hsn_code' => $hsn_code,
            'unit_id' => $unit_id,
            'warehouse_id' => $warehouse_id,
            'quantity' => $quantity,
            'no_of_rolls' => $no_of_rolls,
            'display' => $display,
            'stock' => $stock,
            'available_rolls' => $available_rolls,
            'qunatity_on_hand' => $qunatity_on_hand,
            'supplier_id' => $supplier_id,
            'po_number' => $po_no,
            'gst_rate' => $gst_rate,
            'basic_cost' => $basic_cost,
            'purchase_cost' => $purchase_cost,
            'retail_profit_margin' => $retail_profit_margin,
            'retail_price' => $retail_price,
            'effective_date' => $effective_date,
            'value' => $value,
            'created_at' => now(),
            'updated_at' => now(), 
        ]);

        for ($i = 1; $i <= $request->no_of_rolls; $i++) {
            DB::table('rolls')->insert([
                'inward_id' => $datas, 
                'roll_no' => $roll,  
                'company_id' => $company_id,  
                'mrp' => $retail_price,  
                'order_no' => '',  
                'inward_on' =>now(),  
                'remark' => 'New', 
                'quantity' => $quantity,  
                 'availability' => $quantity,  
                'created_at' => now(),
                
            ]);
        }
        return redirect()->back()->with('success', 'Inward added successfully');
    }

    public function edit_inward($id){
             
        $inward=DB::table('inventory')
        ->join('products', 'inventory.product_id', '=', 'products.id')
        ->join('product_variant', 'inventory.product_varient', '=', 'product_variant.id')
        ->join('companies', 'inventory.company_id', '=', 'companies.id')
        ->join('sub_categories', 'inventory.subcategory', '=', 'sub_categories.id')
        ->join('categories', 'inventory.category_id', '=', 'categories.id')
        ->join('units', 'inventory.unit_id', '=', 'units.id')
        ->join('warehouses', 'inventory.warehouse_id', '=', 'warehouses.id')
        ->join('suppliers', 'inventory.supplier_id', '=', 'suppliers.id')
        ->select('products.product_name','product_variant.varient_name','companies.company_name','categories.category_name','units.unit_name',
        'warehouses.warehouse_name','suppliers.supplier_name','inventory.*') 
        ->where('inventory.id',$id)
        ->first();

        $purchase_orders=DB::table('purchase_orders')->where('deleted_at',null)->get();

          
            $brands=DB::table('brands')->where('deleted_at',null)->get();
            $companies=DB::table('companies')->where('deleted_at',null)->get();
            $suppliers=DB::table('suppliers')->where('deleted_at',null)->get();
            $warehouses=DB::table('warehouses')->where('deleted_at',null)->get();
            $units=DB::table('units')->where('deleted_at',null)->get();
            $categories=DB::table('categories')->where('deleted_at',null)->get();
            $subcategories=DB::table('sub_categories')->where('deleted_at',null)->get();
            $products=DB::table('products')->where('category_id',$inward->category_id)->where('deleted_at',null)->get();
            $product_variant=DB::table('product_variant')->where('product_id',$inward->product_id)->where('deleted_at',null)->get();
            $pricing=DB::table('pricing')->where('deleted_at',null)->get();
            $roll = DB::table('rolls')->whereNull('deleted_at')->orderBy('roll_no', 'desc')->first();

            $rolls = DB::table('rolls')->join('companies', 'rolls.company_id', '=', 'companies.id')
            ->where('rolls.inward_id',$id)
            ->whereNull('rolls.deleted_at')
            ->orderBy('rolls.id','desc')
            ->select('rolls.*','companies.id as company_id','companies.company_id as cmpid','companies.company_name')
            ->get();
            

            $lastCompany = DB::table('products')->orderBy('product_code', 'desc')->first();

            
            if ($lastCompany) {
                $lastIdNumber = (int) substr($lastCompany->product_code, 2); 
                $newProductId = 'PR' . str_pad($lastIdNumber + 1, 6, '0', STR_PAD_LEFT); 
            } else {
                $newProductId = 'PR000001';
            }

            $lastCompanypr = DB::table('product_variant')->orderBy('varient_code', 'desc')->first();

            
            if ($lastCompanypr) {
                $lastIdNumberpr = (int) substr($lastCompanypr->varient_code, 2); 
                $newProductvarId = 'PV' . str_pad($lastIdNumberpr + 1, 6, '0', STR_PAD_LEFT); 
            } else {
                $newProductvarId = 'PV000001';
            }
        return view('admin.edit_inventory',compact('inward','purchase_orders','rolls','companies','newProductId','newProductvarId','brands','roll','warehouses','suppliers','categories','subcategories','units','products','product_variant','pricing'));
    }

    public function update_inward(Request $request){
        $id=$request->id;
        $company_id=$request->company_id;
        $category_id=$request->category_id;
        $product_id=$request->product_id;
        $product_varient=$request->product_varient;
        $roll=$request->roll;
        $hsn_code=$request->hsn_code;
        $unit_id=$request->unit_id;
        $warehouse_id=$request->warehouse_id;
        $qunatity=$request->qunatity;
        $no_of_rolls=$request->no_of_rolls;
        $display=$request->display;
        $stock=$request->stock;
        $available_rolls=$request->available_rolls;
        $qunatity_on_hand=$request->qunatity_on_hand;
        $supplier_id=$request->supplier_id;
        $po_no=$request->po_no;
        $gst_rate=$request->gst_rate;
        $basic_cost=$request->basic_cost;
        $purchase_cost=$request->purchase_cost;
        $retail_profit_margin=$request->retail_profit_margin;
        $retail_price=$request->retail_price;
        $effective_date=$request->effective_date;
        $value=$request->value;
        $brand_id=$request->brand_id;
   
        $datas= DB::table('inventory')->where('id',$id)->update([
           'company_id' => $company_id,
           'brand_id' => $brand_id,
           'category_id' => $category_id,
           'product_id' => $product_id,
           'product_varient' => $product_varient,
           'roll' => $roll,
           'hsn_code' => $hsn_code,
           'unit_id' => $unit_id,
           'warehouse_id' => $warehouse_id,
           'quantity' => $qunatity,
           'no_of_rolls' => $no_of_rolls,
           'display' => $display,
           'stock' => $stock,
           'available_rolls' => $available_rolls,
           'qunatity_on_hand' => $qunatity_on_hand,
           'supplier_id' => $supplier_id,
           'po_number' => $po_no,
           'gst_rate' => $gst_rate,
           'basic_cost' => $basic_cost,
           'purchase_cost' => $purchase_cost,
           'retail_profit_margin' => $retail_profit_margin,
           'retail_price' => $retail_price,
           'effective_date' => $effective_date,
           'value' => $value,
           'updated_at' => now(), 
       ]);
        
        return redirect()->route('inwards')->with([
            'success' => 'Inward updated successfully!'
        ]);
    
    }

    public function getProductsByCategory($categoryId){
        $products = DB::table('products')->where('category_id', $categoryId)->get();
        return response()->json($products);
    }

    public function getProductsVarient($productId){
        $product_variant = DB::table('product_variant')->where('product_id', $productId)->where('deleted_at',null)->get();
        
        return response()->json($product_variant);
    }
     

    public function getWarehouse($companyId){
      
        $warehouses = DB::table('warehouses')
        ->join('companies', function ($join) {
            $join->on(DB::raw('FIND_IN_SET(warehouses.id, companies.warehouse_id)'), '>', DB::raw('0'));
        })
        ->where('companies.id', $companyId)
        ->select('warehouses.id', 'warehouses.warehouse_name')
        ->get();
        return response()->json($warehouses);
    }
     
     
    public function store_category_ajax(Request $request){
        $name=$request->name;
        $datas=DB::table('categories')->insertGetId([
           'category_name'=>$name
        ]);

        $newdata=DB::table('categories')->where('id',$datas)->first();

        return response()->json([
            'success' => true,
            'category_id' => $newdata->id,
            'category_name' => $newdata->category_name,
        ]);
    }
    
     

    public function store_product_ajax(Request $request){
        $company_id=$request->company_id;
        $warehouse_id=$request->warehouse_id;
        $supplier_id=$request->supplier_id;
        $product_name=$request->product_name;
        $product_code=$request->product_code;
        $category=$request->category;
        $subcategory=$request->subcategory;
        $brand_id=$request->brand_id;
        $unit_id=$request->unit_id;
        $description=$request->description;
        $technical_details=$request->technical_details;

        

        if($request->hasfile('product_image')){
            $file = $request->file('product_image');
            $extension = $file->getClientOriginalExtension();
            $logo = rand(11111111,99999999).'.'.$extension;
            $image_path = public_path('uploads/products');
            $file->move($image_path,$logo);            
            }else{
                $logo = "Null";
            }

  
        $datas=DB::table('products')->insertGetId([
          'product_name'=>$product_name,
          'product_code'=>$product_code,
          'description'=>$description,
          'product_image'=>$logo,
          'company_id'=>$company_id,
          'supplier_id'=>implode(',',$supplier_id),
          'warehouse_id'=>$warehouse_id,
          'brand_id'=>$brand_id,
          'technical_details'=>$technical_details,
          'unit_id'=>$unit_id,
          'category_id'=>$category,
          'sub_category_id'=>$subcategory,
          'created_at' =>  date('Y-m-d H:i:s'),
          'updated_at' => date('Y-m-d H:i:s'),
        ]);
 
        $newdata=DB::table('products')->where('id',$datas)->first();

        return response()->json([
            'success' => true,
            'product_id' => $newdata->id,
            'product_name' => $newdata->product_name,
        ]);
    }
     
     
    public function store_product_varient_ajax(Request $request){
        //dd($request->all());
        $product_id=$request->product_id;
        $varient_name=$request->varient_name;
        $varient_code=$request->varient_code;
        $varient_details=$request->varient_details;
        $technical_details=$request->technical_details;
      
        if($request->hasfile('varient_image')){
            $file = $request->file('varient_image');
            $extension = $file->getClientOriginalExtension();
            $logo = rand(11111111,99999999).'.'.$extension;
            $image_path = public_path('uploads/products');
            $file->move($image_path,$logo);            
            }else{
                $logo = "Null";
            }


            $landing_cost=$request->landing_cost;
            $mrp=$request->mrp;
            $retail_price=$request->retail_price;
            $wholesale_price=$request->wholesale_price;
            $minimum_order_quantity_wholesale=$request->minimum_order_quantity_wholesale;
            $effective_date=$request->effective_date;

            $pro_var_id=DB::table('product_variant')->insertGetId([
                'product_id'=>$product_id,
                'varient_name' =>$varient_name,
                'varient_code'=>$varient_code,
                'varient_details'=>$varient_details,
                'technical_details'=>$technical_details,
                'varient_image'=>$logo,
                'created_at' =>  date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ]);
    
            
            //pricing
    
            DB::table('pricing')->insert([
                'product_id'=>$product_id,
                'product_variant_id' =>$pro_var_id,
                'landing_cost'=>$landing_cost,
                'mrp'=>$mrp,
                'retail_price'=>$retail_price,
                'wholesale_price'=>$wholesale_price,
                'minimum_order_quantity_wholesale'=>$minimum_order_quantity_wholesale,
                'effective_date'=>$effective_date,
                'created_at' =>  date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ]);

            

        $newdata=DB::table('product_variant')->where('id',$pro_var_id)->first();

        return response()->json([
            'success' => true,
            'product_id' => $newdata->id,
            'product_name' => $newdata->varient_name,
        ]);
    }
    

       public function view_inward($id){
        $title='View Inward';

             $inward=DB::table('estimated_po')
             ->join('inventory','inventory.id','=','estimated_po.inward_id')
             ->join('purchase_orders','purchase_orders.id','=','estimated_po.po_id')
              ->join('suppliers', 'purchase_orders.supplier_id', '=', 'suppliers.id')
             ->join('companies','purchase_orders.company_id','=','companies.id')
             ->join('product_variant','product_variant.id','=','estimated_po.varient_id')
             ->join('products','products.id','=','product_variant.product_id')
             ->join('warehouses','warehouses.id','=','estimated_po.warehouse_id')
             ->join('units','units.id','=','estimated_po.unit')
             ->where('estimated_po.inward_id',$id)
             ->select('estimated_po.*','inventory.inward_no','inventory.inward_date','products.product_name','purchase_orders.po_number','product_variant.varient_name','warehouses.warehouse_name','units.unit_name','companies.company_name','suppliers.supplier_name')
             ->first();

          // dd( $inward);
               
              return view('admin.view-inventory', compact('inward','title'));
    }
    
    // public function view_inward($id)
    // {
    //     // Get the main inward entry with all necessary joins
    //     $inward = DB::table('inventory')
    //         ->join('products', 'inventory.product_id', '=', 'products.id')
    //         ->join('product_variant', 'inventory.product_varient', '=', 'product_variant.id')
    //         ->join('companies', 'inventory.company_id', '=', 'companies.id')
    //         ->join('categories', 'inventory.category_id', '=', 'categories.id')
    //         ->join('sub_categories', 'inventory.subcategory', '=', 'sub_categories.id')
    //         ->join('brands', 'inventory.brand_id', '=', 'brands.id')
    //         ->join('units', 'inventory.unit_id', '=', 'units.id')
    //         ->join('warehouses', 'inventory.warehouse_id', '=', 'warehouses.id')
    //         ->join('suppliers', 'inventory.supplier_id', '=', 'suppliers.id')
    //         ->select(
    //             'inventory.*',
    //             'products.product_name',
    //             'product_variant.varient_name',
    //             'companies.company_name',
    //             'categories.category_name',
    //             'categories.category_name',
    //             'sub_categories.sub_category_name',
    //             'brands.brand_name',
    //             'units.unit_name',
    //             'warehouses.warehouse_name',
    //             'suppliers.supplier_name'
    //         )
    //         ->where('inventory.id', $id)
    //         ->first();

    //     // Defensive: If no record found
    //     if (!$inward) {
    //         return redirect()->back()->with('error', 'Inward record not found.');
    //     }

    //     // Count of available rolls
    //     $inward_available = DB::table('rolls')
    //         ->where('inward_id', $id)
    //         ->where('defective_status', 0)
    //         ->whereNull('deleted_at')
    //         ->count();

    //     // Sum of available quantity
    //     $inward_stock = DB::table('rolls')
    //         ->where('inward_id', $id)
    //         ->where('defective_status', 0)
    //         ->whereNull('deleted_at')
    //         ->sum('availability');

    //     // Fetch dropdown values (not all needed unless editing)
    //     $brands = DB::table('brands')->whereNull('deleted_at')->get();
    //     $companies = DB::table('companies')->whereNull('deleted_at')->get();
    //     $suppliers = DB::table('suppliers')->whereNull('deleted_at')->get();
    //     $warehouses = DB::table('warehouses')->whereNull('deleted_at')->get();
    //     $units = DB::table('units')->whereNull('deleted_at')->get();
    //     $categories = DB::table('categories')->whereNull('deleted_at')->get();
    //     $subcategories = DB::table('sub_categories')->whereNull('deleted_at')->get();
    //     $pricing = DB::table('pricing')->whereNull('deleted_at')->get();
    //     $purchase_orders = DB::table('purchase_orders')->whereNull('deleted_at')->get();

    //     // Product & variant options (for same category/product)
    //     $products = DB::table('products')
    //         ->where('category_id', $inward->category_id)
    //         ->whereNull('deleted_at')
    //         ->get();

    //     $product_variant = DB::table('product_variant')
    //         ->where('product_id', $inward->product_id)
    //         ->whereNull('deleted_at')
    //         ->get();

    //     // Last roll created (for roll number reference if needed)
    //     $roll = DB::table('rolls')
    //         ->whereNull('deleted_at')
    //         ->orderByDesc('roll_no')
    //         ->first();

    //     // All rolls belonging to this inward entry
    //     $rolls = DB::table('rolls')
    //         ->join('companies', 'rolls.company_id', '=', 'companies.id')
    //         ->where('rolls.inward_id', $id)
    //         ->whereNull('rolls.deleted_at')
    //         ->select('rolls.*', 'companies.id as company_id', 'companies.company_id as cmpid', 'companies.company_name')
    //         ->orderByDesc('rolls.id')
    //         ->get();
    //     // dd($subcategories);
    //     return view('admin.view-inventory', compact(
    //         'inward',
    //         'inward_available',
    //         'inward_stock',
    //         'rolls',
    //         'companies',
    //         'purchase_orders',
    //         'brands',
    //         'roll',
    //         'warehouses',
    //         'suppliers',
    //         'categories',
    //         'subcategories',
    //         'units',
    //         'products',
    //         'product_variant',
    //         'pricing'
    //     ));
    // }

    public function delete_inward($id){
        DB::table('inventory')->where('id', $id)->update(['deleted_at' => date('Y-m-d H:i:s')]);
        return response()->json(['success' => 'Inward deleted successfully']);
    }
    
    public function delete_purchase_order($id){
        DB::table('purchase_orders')->where('id', $id)->update(['deleted_at' => date('Y-m-d H:i:s')]);
        DB::table('purchase_order_items')->where('purchase_order_id', $id)->update(['deleted_at' => date('Y-m-d H:i:s')]);
        return response()->json(['success' => 'Purchase order deleted successfully']);
    }
    
    public function view_purchase_orders($id){
        $title='View Purchase Order';
        $purchase_order = DB::table('purchase_orders')
        ->join('companies','purchase_orders.company_id','=','companies.id')
        ->join('suppliers','purchase_orders.supplier_id','=','suppliers.id')
        ->select('purchase_orders.*','companies.company_name','companies.address','suppliers.supplier_name','suppliers.address as supplier_address')
        ->where('purchase_orders.id', $id)
        ->first();

       // Fetch the associated items for this purchase order
       $order_items = DB::table('purchase_order_items')
         ->where('purchase_order_id', $id)
         ->join('product_variant','purchase_order_items.varient_id','=','product_variant.id')
         ->join('products', 'product_variant.product_id', '=', 'products.id')
         ->join('units','purchase_order_items.uom','=','units.id')
         ->select('purchase_order_items.*','product_variant.id as varid','product_variant.varient_name','product_variant.varient_code','products.product_name','units.id as unit_id','units.unit_name as uom')
         ->get();
        //   dd($order_items);

         // Structure the data with order items as an array
         $po_details = [
            'id'=>$purchase_order->id,
            'po_number' => $purchase_order->po_number,
            'po_date' => $purchase_order->po_date,
            'company_name' => $purchase_order->company_name,
            'supplier_name' => $purchase_order->supplier_name,
            'company_address' => $purchase_order->address,
            'supplier_address' => $purchase_order->supplier_address,
            'company_id' => $purchase_order->company_id,
            'supplier_id' => $purchase_order->supplier_id,
            'transporter_id' => $purchase_order->transporter_id,
            'subtotal' => $purchase_order->subtotal,
            'gst_amount' => $purchase_order->gst_amount,
            'forwarding' => $purchase_order->f_amount,
            'note' => $purchase_order->note,
            'grand_total' => $purchase_order->grand_total,
            'created_at' => $purchase_order->created_at,
            'updated_at' => $purchase_order->updated_at,
            'items' => $order_items, 
         ];
        //  dd($order_items);
         return view('admin.view_purchase_order',compact('po_details','title'));
    }
    
    public function getPoDetails(Request $request)
    {
        $poDetails = DB::table('purchase_orders')
            ->join('purchase_order_items', 'purchase_orders.id', '=', 'purchase_order_items.purchase_order_id')
            ->join('product_variant', 'purchase_order_items.varient_id', '=', 'product_variant.id')
            ->join('products', 'product_variant.product_id', '=', 'products.id')
            ->join('pricing', 'pricing.product_id', '=', 'products.id')
            ->join('categories', 'products.category_id', '=', 'categories.id')
            ->leftJoin('sub_categories', 'products.sub_category_id', '=', 'sub_categories.id')
            ->join('brands', 'products.brand_id', '=', 'brands.id')
            ->join('units', 'products.unit_id', '=', 'units.id')
            ->select(
                'purchase_orders.company_id',
                'purchase_orders.supplier_id',
                'purchase_order_items.varient_id',
                'product_variant.varient_name',
                'products.id as product_id',
                'products.product_name',
                'categories.id as category_id',
                'categories.category_name',
                'sub_categories.id as subcategory_id',
                'sub_categories.sub_category_name as subcategory_name',
                'units.id as unit_id',
                'units.unit_name as unit',
                'brands.id as brand_id',
                'brands.brand_name as brand',
                'quantity',
                'no_of_rolls',
                'pricing.basic_cost',
                'pricing.gst_rate',
                'pricing.purchase_cost',
                'pricing.effective_date',
                'pricing.profit_margin',
                'pricing.retail_price'

            )
            ->where('purchase_orders.id', $request->po_no)
            ->orderBy('purchase_order_items.id', 'asc') // Ensures the first variant is fetched
            ->first();

        if ($poDetails) {
            return response()->json($poDetails);
        }

        return response()->json(['message' => 'No data found'], 404);
    }
    
    public function view_purchase_order_details(Request $request, $id){

        $rollNo = $request->query('roll_no');
        $inwardNo = $request->query('inward_no');
        $inwardDate = $request->query('inward_date');

        $purchase_order = DB::table('purchase_orders')
        ->where('id', $id)
        ->first();

        // Fetch the associated items for this purchase order
        $order_items = DB::table('purchase_order_items')
        ->where('purchase_order_id', $id)
        ->join('product_variant','purchase_order_items.varient_id','=','product_variant.id')
        ->join('units','purchase_order_items.uom','=','units.id')
        ->select('purchase_order_items.*','product_variant.id as varid','product_variant.varient_name','product_variant.varient_code','units.id as unit_id','units.unit_name as uom')
        ->get();
        // dd($order_items);

        $new_order_items = DB::table('estimation_po')
        ->where('po_id', $id)
        ->join('product_variant','estimation_po.varient_id','=','product_variant.id')
          ->join('products','product_variant.product_id','=','products.id')
          ->join('purchase_orders','estimation_po.po_id','=','purchase_orders.id')
        ->join('units','estimation_po.unit_id','=','units.id')
        ->select('estimation_po.*','product_variant.id as varid','products.product_name','purchase_orders.po_number as purchase_order_number','product_variant.varient_name','product_variant.varient_code','units.id as unit_id','units.unit_name as uom')
        ->get();

        // Structure the data with order items as an array
        $po_details = [
            'id'=>$purchase_order->id,
            'po_number' => $purchase_order->po_number,
            'po_date' => $purchase_order->po_date,
            'company_id' => $purchase_order->company_id,
            'supplier_id' => $purchase_order->supplier_id,
            'transporter_id' => $purchase_order->transporter_id,
            'subtotal' => $purchase_order->subtotal,
            'gst_amount' => $purchase_order->gst_amount,
            'forwarding' => $purchase_order->forwarding,
            'note' => $purchase_order->note,
            'grand_total' => $purchase_order->grand_total,
            'created_at' => $purchase_order->created_at,
            'updated_at' => $purchase_order->updated_at,
            'items' => $order_items, 
            'new_items'=>$new_order_items,
        ];
        // dd($po_details['items']);

        $inwards=[
            'roll_no'=>$rollNo,
            'inward_no'=>$inwardNo,
            'inward_date'=>$inwardDate
        ];

        //$warehouses=DB::table('warehouses')->where('deleted_at',null)->get();
        $prd=DB::table('product_variant')->where('id',$order_items[0]->varient_id)->first();
        
        $warehouses=DB::table('warehouse_products')
       ->join('warehouses','warehouse_products.warehouse','=','warehouses.id')
       ->select('warehouses.id','warehouses.warehouse_name','warehouse_products.product_id')
       ->where('warehouse_products.product_id',$prd->product_id)
       ->get();
     
        $units=DB::table('units')->where('deleted_at',null)->get();
        return view('admin.view_purchase_inward',compact('po_details','warehouses','inwards','units'));
    }

    /*public function store_warehouse_ajax(Request $request)
    {
          //dd($request->all());
          $roll=$request->roll_no;
          //$inward_no=$request->inward_no;
          $inward_date=$request->inward_date;
          $item_id=$request->item_id;

          $inwards = DB::table('inventory')->orderBy('id', 'desc')->where('deleted_at',null)->first();
             
            if ($inwards) {
            $lastIdNumberinv = (int) substr($inwards->inward_no, 3); // Extract numeric part correctly
            $inward_no = 'INV' . str_pad($lastIdNumberinv + 1, 5, '0', STR_PAD_LEFT);
            } else {
            
                $inward_no=$request->inward_no;
            }
        //dd($item_id);
          $warehouse=$request->warehouse;
          $datas=DB::table('purchase_order_items')->where('id',$item_id)->first();
          $po=DB::table('purchase_orders')->where('id',$datas->purchase_order_id)->first();
          //dd($po);
          $product_varient=DB::table('product_variant')->where('id',$datas->varient_id)->first();
          
          $product=DB::table('products')->where('id',$product_varient->product_id)->first();
         
          $pricing=DB::table('pricing')->where('product_id',$product_varient->product_id)->first();
         // dd($pricing); 
          $available_rolls=0;
          $display=0;
          
          $unit=$product->unit_id;

        if($unit == 5){
            $quantity_on_hand= $datas->no_of_rolls * $datas->quantity;
        }else{
           //echo 'other'; 
           //dd($unit);
           $unitname=DB::table('units')->where('id',$unit)->first();
         
           if($unitname->unit_name == 'sq.m.'){
            $conversionFactor=10.764; //Example: 1 Meter = 10.764 Sq.ft
            $quantity_on_hand = $datas->no_of_rolls * ($datas->quantity * $conversionFactor);
           }else{
            $quantity_on_hand= $datas->no_of_rolls * $datas->quantity;
           }
        }
     
        // $qunatity_on_hand= $datas->no_of_rolls * $datas->quantity;

        $inward_data= DB::table('inventory')->insertGetId([
         'company_id' => $po->company_id,
         'subcategory' => $product->sub_category_id,
         'category_id' => $product->category_id,
         'brand_id' => $product->brand_id,
         'product_id' => $product_varient->product_id,
         'product_varient' => $product_varient->id,
         'roll' => $roll,
         'inward_no' => $inward_no,
         'inward_date' => $inward_date,
         'hsn_code' => $product->hsn_code,  
         'unit_id' => $product->unit_id,
         'warehouse_id' => $warehouse,
         'quantity' => $datas->quantity,
         'no_of_rolls' => $datas->no_of_rolls,
         'available_rolls' => $available_rolls,
         'qunatity_on_hand' => $quantity_on_hand,
         'display' => $display,
         'stock' => $quantity_on_hand-$display,
         'supplier_id' => $po->supplier_id,
         'po_number' => $po->id,
         'po_item_id' => $item_id,
         'inward_status' => 1,
         'gst_rate'=>$pricing->gst_rate,
         'basic_cost' => $pricing->basic_cost,
         'purchase_cost' => $pricing->purchase_cost,
         'retail_profit_margin' => $pricing->profit_margin,
         'retail_price' => $pricing->retail_price,
         'effective_date' => $pricing->effective_date,
         'created_at' => now(),
         'updated_at' => now(), 
        ]);

          $inwards_data=DB::table('purchase_order_items')->where('id',$item_id)->update([
            'inward_status'=>1
          ]);

          $poss=DB::table('purchase_orders')->where('id',$item_id)->update([
            'inward_status'=>1
          ]);

          $estimated_po= DB::table('estimated_po')->insertGetId([

            'inward_id' =>  $inward_data,
            'po_id' => $request->item_id,
            'po_detail_id' => $request->po_id,
            'no_of_rolls' => $request->no_of_rolls,
            'quantity' => $request->quantity,
            'rate' => $request->rate,
            'unit' => $request->unit,
            'amount' => $request->amount,
            'warehouse_id' => $warehouse,
            'created_at' => now(),
            'updated_at' => now(), 
         ]);
        //dd($product->company_id);
        for ($i = 1; $i <= $datas->no_of_rolls; $i++) {
           // echo $warehouse;
            
            DB::table('rolls')->insert([
                'inward_id' => $inward_data, 
                'roll_no' => $roll,  
                'company_id' =>$po->company_id,  
                'mrp' => 0,  
                'order_no' => '',  
                'inward_on' =>now(),  
                'remark' => 'New', 
                'availability' => $datas->quantity,  
                'quantity' => $datas->quantity, 
                'product_id' => $product_varient->product_id,
                'varient_id' => $product_varient->id, 
                'warehouse_id'=>$warehouse,
                'created_at' => now(),  
                'updated_at' => now(),
            ]);
        }

    

         return redirect()->route('view-purchase-order-details', [
            'id' => $po->id,
            'roll_no' => $request->roll_no,
            'inward_no' => $request->inward_no,
            'inward_date' => $request->inward_date,
         ])->with('success','Varient inwarded successfully.');
    }*/

    public function store_warehouse_ajax(Request $request)
        {

            //dd($request->all());
            $roll = $request->roll_no;
            $inward_date = $request->inward_date;
            $item_id = $request->item_id;
            $no_of_rolls_to_receive = $request->no_of_rolls; 
            $supplier_invoice_no = $request->supplier_invoice_no;
            $unit=$request->unit;  
            $warehouse = $request->warehouse;
            $quantity=$request->quantity;
            //dd($item_id);
            $datas = DB::table('estimation_po')->where('po_item_id', $item_id)->first();
            $po = DB::table('purchase_orders')->where('id', $datas->po_id)->first();
           
            //dd($datas->varient_id);
            $product_varient = DB::table('product_variant')->where('id', $datas->varient_id)->first();
           
            $product = DB::table('products')->where('id', $product_varient->product_id)->first();
            $varient_id=$datas->varient_id;
            $product_id= $product_varient->product_id;
          
            $brand=$product->brand_id;
            $supplier=$product->supplier_id;
            $company=$product->company_id;
            $category=$product->category_id;
            $subcategory=$product->sub_category_id;

           
           // $pricing = DB::table('pricing')->where('product_id', $product_varient->product_id)->first();

           // $unit = $product->unit_id;

            // if ($unit == 5) {
            //     $quantity_on_hand = $no_of_rolls_to_receive * $datas->quantity;
            // } else {
            //     $unitname = DB::table('units')->where('id', $unit)->first();
            //     if ($unitname->unit_name == 'sq.m.') {
            //         $conversionFactor = 10.764;
            //         $quantity_on_hand = $no_of_rolls_to_receive * ($datas->quantity * $conversionFactor);
            //     } else {
            //         $quantity_on_hand = $no_of_rolls_to_receive * $datas->quantity;
            //     }
            // }

            $inwards = DB::table('inventory')->orderBy('id', 'desc')->where('deleted_at', null)->first();
            if ($inwards) {
                $lastIdNumberinv = (int) substr($inwards->inward_no, 3);
                $inward_no = 'INV' . str_pad($lastIdNumberinv + 1, 5, '0', STR_PAD_LEFT);
            } else {
                $inward_no = 'INV00001';
            }

             // dd($inward_no);

            $inward_data = DB::table('inventory')->insertGetId([
                'company_id' => $company,
                'subcategory' =>$subcategory,
                'category_id' => $category,
                'brand_id' => $brand,
                'product_id' => $product_id,
                'product_varient' => $varient_id,
                'roll' => $roll,
                'inward_no' => $inward_no,
                'inward_date' => $inward_date,
                'hsn_code' => $product->hsn_code,
                'unit_id' => $unit,
                'warehouse_id' => $warehouse,
                'quantity' => $quantity,
                 'supplier_invoice_no' => $supplier_invoice_no,
                'no_of_rolls' => $no_of_rolls_to_receive,
                'available_rolls' => 0,
                'qunatity_on_hand' => 1,
                'display' => 0,
                'stock' => 1,
                'supplier_id' => $supplier,
                'po_number' => $datas->po_id ?? '0',
                'po_item_id' => $datas->po_item_id,
                'inward_status' => 1,
                'gst_rate' => 1,
                'basic_cost' => 1,
                'purchase_cost' => 1,
                'retail_profit_margin' => 1,
                'retail_price' => 1,
                'effective_date' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);


              $estimated_po= DB::table('estimated_po')->insertGetId([
            'inward_id' =>  $inward_data,
            'po_id' => $datas->po_id,
            'po_detail_id' => $datas->po_item_id,
            'no_of_rolls' => $request->no_of_rolls,
            'quantity' => $request->quantity,
            'rate' => $request->rate,
            'unit' => $request->unit,
            'amount' => $request->amount,
            'warehouse_id' => $warehouse,
            'varient_id'=>$varient_id,
            'created_at' => now(),
            'updated_at' => now(),
         ]);


            // Add record to inward_items
            DB::table('inward_items')->insert([
                'purchase_order_item_id' => $item_id,
                'inventory_id' => $inward_data,
                'quantity' => $no_of_rolls_to_receive,
                'inward_date' => $inward_date,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            for ($i = 1; $i <= $no_of_rolls_to_receive; $i++) {
                DB::table('rolls')->insert([
                    'inward_id' => $inward_data,
                    'roll_no' => $roll,
                    'company_id' => $company,
                    'mrp' => 0,
                    'order_no' => '',
                    'inward_on' => now(),
                    'remark' => 'New',
                    'availability' => $request->quantity,
                    'quantity' => $request->quantity,
                    'product_id' => $product_id ?? 0,
                    'varient_id' => $varient_id,
                    'warehouse_id' => $warehouse,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }

           $used_rolls = DB::table('estimated_po')
                ->where('po_id', $po->id)
                ->sum('no_of_rolls');

            $total_rolls = DB::table('purchase_order_items')
                    ->where('purchase_order_id', $po->id)
                    ->sum('no_of_rolls');


                      //partial inward 
                    DB::table('purchase_orders')//partial inward
                        ->where('id', $datas->po_id)
                        ->update(['inward_status' => 2]);

             if ($total_rolls == $used_rolls) {
                    DB::table('purchase_orders')//full inward
                        ->where('id', $datas->po_id)
                        ->update(['inward_status' => 1]);
                }       
             //   dd($used_rolls);  


               //    //send mail
            $inward = DB::table('estimated_po')
                    ->join('inventory', 'inventory.id', '=', 'estimated_po.inward_id')
                    ->join('purchase_orders', 'purchase_orders.id', '=', 'estimated_po.po_id')
                    ->join('companies', 'purchase_orders.company_id', '=', 'companies.id')
                    ->join('suppliers', 'purchase_orders.supplier_id', '=', 'suppliers.id')
                    ->join('product_variant', 'product_variant.id', '=', 'estimated_po.varient_id')
                    ->join('products', 'products.id', '=', 'product_variant.product_id')
                    ->join('warehouses', 'warehouses.id', '=', 'estimated_po.warehouse_id')
                    ->join('units', 'units.id', '=', 'estimated_po.unit')
                    ->where('estimated_po.inward_id', $inward_data)
                    ->select(
                        'estimated_po.*',
                        'inventory.inward_no',
                        'inventory.inward_date',
                        'products.product_name',
                        'purchase_orders.po_number',
                        'product_variant.varient_name',
                        'warehouses.warehouse_name',
                        'units.unit_name',
                        'companies.company_name',
                        'suppliers.supplier_name'
                    )
                    ->first();

                // Generate the PDF
                $pdf = Pdf::loadView('emails.inward_mail', ['inward' => $inward]);

                // Compose email body
                $emailContent = "Hello " . $inward->supplier_name . ",<br><br>";
                $emailContent .= "We would like to inform you that we have received the inward goods as per the purchase order #" . $inward->po_number . ".<br><br>";
                $emailContent .= "Please find the inward details below for your reference:<br><br>";
                $emailContent .= "<strong>PO Number:</strong> " . $inward->po_number . "<br>";
                $emailContent .= "<strong>Inward Date:</strong> " . date('d/m/Y', strtotime($inward->inward_date)) . "<br>";
                $emailContent .= "<strong>Total Rolls Received:</strong> " . $inward->no_of_rolls . "<br>";
                $emailContent .= "<strong>Warehouse:</strong> " . $inward->warehouse_name . "<br><br>";
                $emailContent .= "If you have any queries regarding this inward, please feel free to contact us.<br><br>";
                $emailContent .= "Best regards,<br>";
                $emailContent .= "Kukreja Interiors";

                // Send mail with correct attachData method
                Mail::send([], [], function ($message) use ($emailContent, $pdf, $inward) {
                    $message->to('rushikeshwakde.oms@gmail.com')
                        ->from('info@rush.speakwise.site', 'Floor Factory')
                        ->subject('Inward Data Confirmation – PO #' . $inward->po_number . ' – ' . $inward->inward_date)
                        ->setBody($emailContent, 'text/html'); // Set HTML body

                    // Correct method to attach data
                    $message->attachData($pdf->output(), 'inward_data_' . $inward->inward_no . '.pdf', [
                        'mime' => 'application/pdf',
                    ]);
                });


             //end mail code


                $updated_po = DB::table('purchase_orders')->where('id', $datas->po_id)->first();

                $message = $updated_po->inward_status == 1
                ? 'Full inward completed successfully.'
                : 'Partial inward completed successfully.';

            return redirect()->route('view-purchase-order-details', [
                'id' => $datas->po_id,
                'roll_no' => $request->roll_no,
                'inward_no' => $inward_no,
                'inward_date' => $inward_date,
            ])->with('success', $message);
        }
    
    
    
public function download_po($id)
    {
  
         $purchase_order = DB::table('purchase_orders')
        ->join('companies','purchase_orders.company_id','=','companies.id')
        ->join('suppliers','purchase_orders.supplier_id','=','suppliers.id')
        ->select('purchase_orders.*','companies.company_name','companies.address','suppliers.supplier_name','suppliers.address as supplier_address')
        ->where('purchase_orders.id', $id)
        ->first();
    
        // Fetch the associated items for this purchase order
       $order_items = DB::table('purchase_order_items')
     ->where('purchase_order_id', $id)
     ->join('product_variant','purchase_order_items.varient_id','=','product_variant.id')
      ->join('units','purchase_order_items.uom','=','units.id')
     ->select('purchase_order_items.*','product_variant.id as varid','product_variant.varient_name','product_variant.varient_code','units.id as unit_id','units.unit_name as uom')
     ->get();
    
        // Structure the data with order items as an array
        $po_details = [
            'id' => $purchase_order->id,
            'po_number' => $purchase_order->po_number,
            'po_date' => $purchase_order->po_date,
            'company_name' => $purchase_order->company_name,
        'supplier_name' => $purchase_order->supplier_name,
        'company_address' => $purchase_order->address,
        'supplier_address' => $purchase_order->supplier_address,
            'company_id' => $purchase_order->company_id,
            'supplier_id' => $purchase_order->supplier_id,
            'transporter' => $purchase_order->transporter_name ?? '',
            'subtotal' => $purchase_order->subtotal,
            'gst_amount' => $purchase_order->gst_amount,
            'forwarding' => $purchase_order->forwarding,
            'note' => $purchase_order->note,
            'grand_total' => $purchase_order->grand_total,
            'created_at' => $purchase_order->created_at,
            'updated_at' => $purchase_order->updated_at,
            'items' => $order_items, 
        ];
       //  dd($po_details['currency']);
        // Load the view and pass the PO details directly
        

        //$options = new Options();
       // $options->set('defaultFont', 'DejaVu Sans');
       
        $pdf = \PDF::loadView('admin.purchase_order_pdf',['po_details' => $po_details]);
       
        // Return the PDF as a download
        return $pdf->download('purchase_order_' . $id . '.pdf');
    }
    
    
    public function stock_report(){

    $stockReport = DB::table('inventory')
            ->join('products', 'inventory.product_id', '=', 'products.id')
            ->join('units', 'inventory.unit_id', '=', 'units.id')
            ->join('product_variant', 'inventory.product_varient', '=', 'product_variant.id')
            ->select(
                'products.product_name',
                'product_variant.varient_name',
                'product_variant.varient_code',
                'inventory.no_of_rolls',
                'inventory.quantity',
                'units.unit_name',
                'inventory.available_rolls',
                'inventory.qunatity_on_hand'
               // DB::raw('SUM(inventory.quantity) as total_quantity')
            )
            //->groupBy('inventory.product_id', 'inventory.product_varient','products.product_name','product_variant.varient_name')
            ->get();

            //dd($stockReport);

     return view('admin.stock_report',compact('stockReport'));
   }
    
    
     public function getRollsData($inward_id)
    {
      // dd($inward_id);
        $rolls = DB::table('rolls')
        ->join('companies', 'rolls.company_id', '=', 'companies.id')
         ->join('warehouses', 'rolls.warehouse_id', '=', 'warehouses.id')
            ->where('rolls.inward_id',$inward_id)
            ->whereNull('rolls.deleted_at')
            ->orderBy('rolls.id','asc')
            ->select('rolls.*','companies.id as company_id','companies.company_id as cmpid','companies.company_name','warehouses.warehouse_name')
            ->get();
            //dd($rolls);
        return response()->json($rolls);
    }
    
    public function change_roll_status(Request $request)
    {
        $roll_id = $request->roll_id;
        $status = $request->status;

        //dd($request->all());
    
        $updated = DB::table('rolls')->where('id', $roll_id)->update([
            'remark' => 'Defective',
            'defective_status'=>1
        ]);
    
        if ($updated) {
            $roll = DB::table('rolls')->where('id', $roll_id)->first();
            return response()->json([
                'success' => true,
                'data' => $roll,
                'message' => 'Status updated successfully!'
            ]);
        }
    
        
    }
    
    
   

     public function getVariantWarehouses(Request $request)
    {
        $variantId = $request->variant_id;

        $warehouses = DB::table('warehouses')
        ->join('rolls', 'warehouses.id', '=', 'rolls.warehouse_id')
        ->where('rolls.varient_id', $variantId)
        ->where('rolls.availability', '>', 0)
        ->select(
            'warehouses.id',
            'warehouses.warehouse_name',
            DB::raw('SUM(rolls.availability) as total_availability')
        )
        ->groupBy('warehouses.id', 'warehouses.warehouse_name')
        ->get();


        return response()->json($warehouses);
    }


    public function getVariantWarehouseAvailability(Request $request)
    {
        $variantId = $request->variant_id;
        $warehouseId = $request->warehouse_id;

        $availability = DB::table('rolls')
            ->where('varient_id', $variantId)
            ->where('warehouse_id', $warehouseId)
            ->where('defective_status',0)
            ->sum('availability');

        return response()->json(['availability' => $availability]);
    }


    



   

    

    
    
    
        public function getOrderData($inward_id,$varient){
    
       // dd($orderDetails);
       $orderItems = DB::table('order_items')
       ->join('products', 'products.id', '=', 'order_items.product_id')
       ->leftJoin('product_variant', 'product_variant.id', '=', 'order_items.varient_id')
       ->join('orders', 'orders.id', '=', 'order_items.order_id') 
       ->join('customers', 'customers.id', '=', 'orders.customer_id') 
       ->select(
           'order_items.order_id',
           'products.product_name',
           'product_variant.varient_name',
           'product_variant.varient_image',
           'order_items.quantity',
           'order_items.price',
           'orders.status', 
           'orders.order_code',
           'orders.order_date', 
           'customers.customer_name'
       )
       ->where('order_items.varient_id', $varient)
       ->get();

       return response()->json([
        'success' => true,
        'data' => $orderItems,
        'message' => 'orders get successfully!'
    ]);
    // dd($orderItems);
    }
    
    
        
    public function stocks(Request $request) {

             $inventory = DB::table('inventory')
             ->join('product_variant', 'inventory.product_varient', '=', 'product_variant.id')
             ->join('warehouses', 'inventory.warehouse_id', '=', 'warehouses.id')
             ->join('companies', 'inventory.company_id', '=', 'companies.id')
             ->join('products', 'inventory.product_id', '=', 'products.id')
             ->join('units', 'inventory.unit_id', '=', 'units.id')
             ->leftJoin('rolls', function ($join) {
                $join->on('inventory.id', '=', 'rolls.inward_id')
                     ->where('rolls.availability', '>',0);
             })
             ->select(
                'inventory.id',
                'inventory.product_varient',
                'inventory.warehouse_id',
                'inventory.company_id',
                'inventory.product_id',
                'inventory.basic_cost',
                'inventory.unit_id',
                'inventory.no_of_rolls', 
                'product_variant.varient_code',
                'product_variant.varient_name',
                'warehouses.warehouse_name',
                'companies.company_name',
                'products.product_name',
                'units.unit_name',
                DB::raw('COUNT(rolls.id) as available_rolls')
            )
            ->whereNull('inventory.deleted_at')
            ->groupBy(
                'inventory.id',
                'inventory.product_varient',
                'inventory.warehouse_id',
                'inventory.company_id',
                'inventory.product_id',
                'inventory.basic_cost',
                'inventory.unit_id',
                'inventory.no_of_rolls',
                'product_variant.varient_code',
                'product_variant.varient_name',
                'warehouses.warehouse_name',
                'companies.company_name',
                'products.product_name',
                'units.unit_name'
            )
            ->get();
           
        
        return view('admin.stockdata', compact('inventory'));
    }
    


public function getRollDetails(Request $request)
    {
        $rolls = DB::table('rolls')
            ->where('varient_id', $request->varient_id)
            ->where('availability', '>', 0)
            ->where('defective_status',0)
            ->select('quantity', 'availability')
            ->orderBy('quantity', 'desc') // Prioritize larger rolls
            ->get();
    
        if ($rolls->isNotEmpty()) {
            return response()->json([
                'success' => true,
                'rolls' => $rolls
            ]);
        } else {
            return response()->json(['success' => false]);
        }
    }
    
    
    public function checkAvailability($variantId)
        {
           // dd($variantId);
           $available = DB::table('rolls')
           ->join('inventory', 'rolls.inward_id', '=', 'inventory.id')
           ->join('product_variant', 'rolls.varient_id', '=', 'product_variant.id')
           ->where('rolls.varient_id', $variantId)
           ->where('rolls.defective_status', 0)
           ->whereNull('inventory.deleted_at')
           ->whereNull('product_variant.deleted_at')
           ->where('product_variant.status', 1)
           ->sum('rolls.availability');
             //d($available);
            return response()->json(['available' => $available]);
        }
    
    
    
    
      public function getProductsBySupplier($id)
    {
        $products = DB::table('products')
             ->whereRaw('FIND_IN_SET(?, supplier_id)', [$id])
            ->whereNull('deleted_at')
            ->select('id', 'product_name')
            ->get();
            

        return response()->json(['products' => $products]);
    }
    
    
    public function getVariantsByProductPo(Request $request)
    {
            $productId = $request->product_id;
            
            $variants = DB::table('product_variant')
            ->join('products', 'product_variant.product_id', '=', 'products.id')
            ->where('product_variant.product_id',$productId)
            ->where('product_variant.deleted_at',null)
            ->select('product_variant.id','product_variant.varient_name','product_variant.varient_code')
            ->get();

             //dd($variants);

        return response()->json($variants);
    }



     public function getRollsByVariantWarehouse(Request $request)
    {
       
        $variantId = $request->variant_id;
       
        $warehouseId = $request->warehouse_id;

        $rolls = DB::table('rolls')
            ->join('product_variant','rolls.varient_id','=','product_variant.id')
             ->join('products','product_variant.product_id','=','products.id')
               ->join('pricing','products.id','=','pricing.product_id')
            ->where('rolls.varient_id', $variantId)
            ->where('rolls.warehouse_id', $warehouseId)
            ->where('rolls.defective_status',0)
             ->where('rolls.availability','>',0)
            ->select('rolls.id', 'rolls.roll_no','pricing.retail_price','rolls.availability','products.thickness','product_variant.varient_code') 
            ->get();

           

        return response()->json($rolls);
    }


    public function getInwardJson($id)
        {
            $inward = $inward=DB::table('estimated_po')
             ->join('inventory','inventory.id','=','estimated_po.inward_id')
            ->join('warehouses','warehouses.id','=','estimated_po.warehouse_id')
             ->join('units','units.id','=','estimated_po.unit')
            ->join('purchase_orders','purchase_orders.id','=','estimated_po.po_id')
            ->select('estimated_po.*','inventory.inward_no','inventory.inward_date','units.unit_name','warehouses.warehouse_name','purchase_orders.po_number as ponumber')
            ->where('estimated_po.inward_id',$id)
            ->first();

            return response()->json($inward);
        }

      

        public function updateinward(Request $request, $id)
        {
           
         //dd($request->all());
            DB::table('inventory')
                ->where('id', $id)
                ->update([
                    'warehouse_id'  => $request->warehouse_id,
                    // 'no_of_rolls'   => $request->no_of_rolls,
                    // 'quantity'      => $request->quantity,
                    // 'rate'          => $request->rate,
                    // 'unit_id'          => $request->unit,
                    // 'amount'        => $request->amount,
                    'updated_at'    => now(), 
                ]);

                 DB::table('estimated_po')
                ->where('inward_id', $id)
                ->update([
                    'warehouse_id'  => $request->warehouse_id,
                    // 'no_of_rolls'   => $request->no_of_rolls,
                    // 'quantity'      => $request->quantity,
                    // 'rate'          => $request->rate,
                    // 'unit'          => $request->unit,
                    // 'amount'        => $request->amount,
                    'updated_at'    => now(), 
                ]);

                 DB::table('rolls')
                    ->where('inward_id', $id)
                    ->update([
                        'warehouse_id'  => $request->warehouse_id,
                        'updated_at'    => now(), 
                    ]);


            return response()->json(['success' => true, 'message' => 'Inward updated successfully']);
        }


           public function view_all_inwards($id){
        

            $inwards = DB::table('inventory')
            ->join('products', 'inventory.product_id', '=', 'products.id')
            ->join('purchase_orders', 'inventory.po_number', '=', 'purchase_orders.id')
            ->join('product_variant', 'inventory.product_varient', '=', 'product_variant.id')
            ->join('companies', 'inventory.company_id', '=', 'companies.id')
            ->join('categories', 'inventory.category_id', '=', 'categories.id')
            ->join('units', 'inventory.unit_id', '=', 'units.id')
            ->join('warehouses', 'inventory.warehouse_id', '=', 'warehouses.id')
            ->join('suppliers', 'inventory.supplier_id', '=', 'suppliers.id')
            ->where('inventory.po_number', $id)
            ->orderBy('inventory.id','desc')
            ->select('products.product_name','purchase_orders.po_number as purchase_order_number','product_variant.varient_name','companies.company_name','categories.category_name','units.unit_name',
            'warehouses.warehouse_name','suppliers.supplier_name','inventory.*') 
             ->get();
        //dd( $inwards );
       
        $warehouses=DB::table('warehouses')->where('deleted_at',null)->get();
        return view('admin.view-all-inwards',compact('inwards','warehouses'));
    }


    
 public function getVariantsByProduct($id)
    {
        $variants = DB::table('product_variant')
            ->join('rolls', 'rolls.varient_id', '=', 'product_variant.id')
            ->where('product_variant.product_id', $id)
            ->where('rolls.availability', '>', 0) // Only variants with available rolls
            ->whereNull('product_variant.deleted_at')
            ->select('product_variant.id', 'product_variant.varient_code', 'product_variant.varient_name')
            ->groupBy('product_variant.id', 'product_variant.varient_code', 'product_variant.varient_name') // Avoid duplicates
            ->get();

        return response()->json(['variants' => $variants]);
    }

     public function getProductsBySupplierreportsection($id)
        {
            $products = DB::table('products')
                ->join('inventory', 'inventory.product_id', '=', 'products.id')
                ->join('rolls', 'rolls.inward_id', '=', 'inventory.id')
                ->whereRaw('FIND_IN_SET(?, inventory.supplier_id)', [$id])
                ->whereNull('products.deleted_at')
                ->where('rolls.availability', '>', 0) // Only rolls with availability
                ->select('products.id', 'products.product_name')
                ->groupBy('products.id', 'products.product_name') // Avoid duplicates
                ->get();

            return response()->json(['products' => $products]);
        }
     
    
}
