<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Dompdf\Options;
class InvoiceController extends Controller
{
    
    // function to show all invoices 
    public function index()
	{
	    // Step 1: Join orders and order_items to get product and customer mapping
	    $orderItems = DB::table('order_items')
	        ->join('orders', 'order_items.order_id', '=', 'orders.id')
	        ->select('order_items.product_id', 'orders.customer_id')
	        // ->distinct()
	        ->get();
	     
	    // Step 2: Get product IDs and map them to customers
	    $productIds = $orderItems->pluck('product_id');
	    
	    // Step 3: Fetch products that were actually ordered
	    $products = DB::table('products')
	        ->whereIn('id', $productIds)
	        ->get();
	        
	    // Step 4: Return to the view
	    return view('admin.all-invoices', compact('products'));
	}





    // function to show view invoice page
    public function viewInvoice($productId)
	{
	    // 1. Join all the required tables
	    $invoiceData = DB::table('order_items')
	        ->join('orders', 'order_items.order_id', '=', 'orders.id') 
	        ->join('products', 'order_items.product_id', '=', 'products.id') 
	        ->leftJoin('product_variant', 'order_items.varient_id', '=', 'product_variant.id')
	        ->join('customers', 'orders.customer_id', '=', 'customers.id') 
	        ->where('order_items.product_id', $productId)
	        ->select(
	            'order_items.id as order_item_id',
	            'order_items.quantity',
	            'order_items.price',
	            'orders.id as order_id',
	            'orders.order_date',
	            'products.id as product_id',
	            'products.product_name',
	            'products.hsn_code',
	            'product_variant.varient_name',
	            'product_variant.varient_code',
	            'customers.customer_name',
            	'customers.address',
            	'customers.city',
            	'customers.mobile',
            	'customers.state',
            	'customers.email',
	        )
	        ->get();
	    // 2. Group data for easier processing in the view
	    $groupedData = $invoiceData->groupBy('order_id');

	    // 3. Return view with data
	    return view('admin.view-invoice', [
	        'groupedData' => $groupedData,
	    ]);
	}







    // function to download invoice page
    public function downloadInvoice($productId)
	{
	    // 1. Fetch the invoice data (same as viewInvoice function)
	    $invoiceData = DB::table('order_items')
	        ->join('orders', 'order_items.order_id', '=', 'orders.id') 
	        ->join('products', 'order_items.product_id', '=', 'products.id') 
	        ->leftJoin('product_variant', 'order_items.varient_id', '=', 'product_variant.id')
	        ->join('customers', 'orders.customer_id', '=', 'customers.id') 
	        ->where('order_items.product_id', $productId)
	        ->select(
	            'order_items.id as order_item_id',
	            'order_items.quantity',
	            'order_items.price',
	            'orders.id as order_id',
	            'orders.order_date',
	            'products.id as product_id',
	            'products.product_name',
	            'products.hsn_code',
	            'product_variant.varient_name',
	            'product_variant.varient_code',
	            'customers.customer_name',
	            'customers.address',
	            'customers.city',
	            'customers.mobile',
	            'customers.state',
	            'customers.email',
	        )
	        ->get();

	    // 2. Group data for easier processing in the view
	    $groupedData = $invoiceData->groupBy('order_id');

	    // 3. Load the view into a PDF
	    $pdf = \PDF::loadView('admin.download-invoice',  ['groupedData' => $groupedData,]);

	    // preview the pdf 
	    // return $pdf->stream('invoice_' . $productId . '.pdf', ['Attachment' => false]);

	    // 4. Download the PDF
	    return $pdf->download('invoice_' . $productId . '.pdf');
	}

}
