<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;
use App\Models\Admin;

class LoginController extends Controller
{
       public function login(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);

        $credentials = $request->only('email', 'password');

        // Check if the user exists
        $user = DB::table('users')->where('email', $request->email)->first();

        if (!$user) {
            return redirect()->back()->with('error', 'Invalid Credentials, Login Failed');
        }

     
        $guard = ($user->type_id == 1) ? 'admin' : 'installer';

        // Attempt login
        if (Auth::guard($guard)->attempt($credentials, $request->remember)) {
            $authUser = Auth::guard($guard)->user();
            // dd($authUser);
            DB::table('users')->where('id', $authUser->id)->update(['last_login' => now()]);
            if ($authUser->type_id === 1) {
                return redirect()->route('index')->with('success', 'Welcome Admin');
            } elseif ($authUser->type_id === 5) {
                //dd(Auth::user());
                return redirect()->route('installer.profile')->with('success', 'Welcome Installer');
            }
        }

        return redirect()->back()->with('error', 'Invalid Credentials, Login Failed');
    }

    public function profile(){
        $title='Admin Profile';
      $profile=DB::table('users')->where('id',Auth::user()->id)->first();
        return view('admin.profile',compact('profile','title'));
    }
    
    public function update_profile(Request $request){
    $id=$request->id;
    $name=$request->full_name;
    $email=$request->email;
    $username=$request->username;
    $password=bcrypt($request->password);
    
     DB::table('users')->where('id', $id)->update([
            'full_name' => $name,
            'email' => $email,
            'username' => $username,
            'password1'=>$request->password,
            'password' => $password,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
      return redirect()->back()->with('success', 'Profile updated successfully.');
    }

    public function logout(Request $request)
    {
        
        Auth::guard('admin')->logout();
        return redirect('/');
    }
    
    public function installer_logout(Request $request)
    {
        
        Auth::guard('installer')->logout();
        return redirect('/');
    }
    
    
    /*  public function login(Request $request)
{
   
    $request->validate([
        'email' => 'required|email',
        'password' => 'required',
    ]);

    
    $credentials = $request->only('email', 'password');

    
    if (Auth::guard('admin')->attempt($credentials, $request->remember)) {
        
        $user = Auth::guard('admin')->user();

       
        if ($user->status === 1) {
           
            DB::table('users')->where('id', $user->id)->update(['last_login' => now()]);

            
            return redirect('index')->with('success', 'Welcome to Dashboard');
        } else {
            
            Auth::guard('admin')->logout();
            return redirect()->back()->with('error', 'Your account is inactive.');
        }
    } else {
        
        return redirect()->back()->with('error', 'Invalid credentials. Login failed.');
    }
}*/
  
  
}
