<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Dompdf\Options;
use Barryvdh\DomPDF\Facade\Pdf;
use function Ramsey\Uuid\v1;

class OrderController extends Controller
{
    //   public function orders(Request $request)
    // {
      
    //     $query = DB::table('orders')
    //         ->join('customers', 'customers.id', '=', 'orders.customer_id')
    //         ->leftJoin('companies', 'companies.id', '=', 'orders.company_id')
    //         ->leftJoin('order_items', 'order_items.order_id', '=', 'orders.id') // Join order_items
    //         ->leftJoin('products', 'products.id', '=', 'order_items.product_id') // Join products via product_id
    //         ->select(
    //             'orders.*',
    //             'customers.customer_name',
    //             'companies.company_name',
    //             'products.id as product_id',
    //             'products.product_name'
    //         )
    //          ->groupBy('orders.id', 'customers.customer_name', 'companies.company_name', 'products.id', 'products.product_name') //if remove show order list as per order item count
    //         ->orderBy('orders.id', 'desc')
    //         ->whereNull('orders.deleted_at');


    //     // Apply Filters
    //     if (!empty($request->customer_id)) {
    //        // dd($request->customer_id);
    //         $query->where('orders.customer_id', $request->customer_id);
    //     }
        
    //     if (!empty($request->order_status)) {
    //         // dd($request->customer_id);
    //          $query->where('orders.status', $request->order_status);
    //      }

    //      if (!empty($request->payment_status)) {
    //         // dd($request->customer_id);
    //          $query->where('orders.payment_status', $request->payment_status);
    //      }

    //      if (!empty($request->order_type)) {
    //         // dd($request->customer_id);
    //          $query->where('orders.order_type', $request->order_type);
    //      }
 

    //     if (!empty($request->start_date)) {
    //         $query->whereDate('orders.order_date', '>=', $request->start_date);
    //     }

    //     if (!empty($request->end_date)) {
    //         $query->whereDate('orders.order_date', '<=', $request->end_date);
    //     }

    //     $orders = $query->get();
         
    //     if ($request->ajax()) {
          
    //         return response()->json(['orders' => $orders]);
    //     }

    //     $customers = DB::table('customers')->whereNull('deleted_at')->get();
    //     return view('admin.orders', compact('orders', 'customers'));
    // }

       public function orders(Request $request)
    {
        $title='Orders';
        $query = DB::table('orders')
            ->join('customers', 'customers.id', '=', 'orders.customer_id')
            ->leftJoin('companies', 'companies.id', '=', 'orders.company_id')
            ->leftJoin('order_items', 'order_items.order_id', '=', 'orders.id')
            ->leftJoin('products', 'products.id', '=', 'order_items.product_id')
             ->leftJoin(DB::raw("
                    (
                        SELECT ot.order_id, ot.remaining_amount
                        FROM order_transaction ot
                        WHERE ot.id = (
                            SELECT MAX(id)
                            FROM order_transaction
                            WHERE order_id = ot.order_id
                        )
                    ) as latest_trans
                 "), 'latest_trans.order_id', '=', 'orders.id')
            ->select(
                'orders.*',
                'customers.customer_name',
                'companies.company_name',
                DB::raw('GROUP_CONCAT(products.product_name SEPARATOR ", ") as product_names'),
                  DB::raw('latest_trans.remaining_amount')
            )
            ->whereNull('orders.deleted_at')
            ->groupBy('orders.id', 'customers.customer_name', 'companies.company_name','latest_trans.remaining_amount')
            ->orderBy('orders.id', 'desc');

        // Apply Filters
        if (!empty($request->customer_id)) {
            $query->where('orders.customer_id', $request->customer_id);
        }

        if (!empty($request->order_status)) {
            $query->where('orders.status', $request->order_status);
        }

        if (!empty($request->payment_status)) {
            $query->where('orders.payment_status', $request->payment_status);
        }

        if (!empty($request->order_type)) {
            $query->where('orders.order_type', $request->order_type);
        }

        if (!empty($request->start_date)) {
            $query->whereDate('orders.order_date', '>=', $request->start_date);
        }

        if (!empty($request->end_date)) {
            $query->whereDate('orders.order_date', '<=', $request->end_date);
        }

        $orders = $query->get();

        if ($request->ajax()) {
            return response()->json(['orders' => $orders]);
        }

        $customers = DB::table('customers')->whereNull('deleted_at')->get();
    

        return view('admin.orders', compact('orders', 'customers','title'));
    }

    public function view_order($id){
        $title='View Order';
        $default_logo = url('uploads/images.jpg');
        $orderDetails = DB::table('orders')
        ->join('customers', 'customers.id', '=', 'orders.customer_id')
         ->leftJoin('invoice_nos', 'orders.id', '=', 'invoice_nos.order_id')
        ->leftJoin('users as installer', 'installer.id', '=', 'orders.installer_id')
        ->leftJoin('users as staff', 'staff.id', '=', 'orders.staff_id')
        ->leftJoin('transporters', 'transporters.id', '=', 'orders.transporter_id')
        ->where('orders.id', $id)
        ->select('orders.id as order_id','orders.bill_generate','invoice_nos.invoice_no as bill_no', 'orders.refund_status','orders.order_code','transporters.transporter_name','installer.full_name as installer','staff.full_name as staff','orders.updated_at', 'orders.order_date','orders.subtotal','orders.grandtotal','orders.pickup_point','orders.order_type', 'customers.customer_name','orders.address_id','orders.discount','orders.customer_id','orders.customer_discount_amount','orders.payment_method','orders.order_type','customers.address','customers.email','customers.mobile','customers.phone1','customers.phone2','orders.subtotal','orders.grandtotal','orders.payment_status','orders.transporter_id', 'orders.status')
        ->first();
       //dd($orderDetails);
      $order_receipt=DB::table('order_receipt')->where('order_id',$id)->first();
      // $pickup_point=DB::table('warehouses')->where('id',$orderDetails->pickup_point)->first();
       $pickup_point = DB::table('warehouses')
        ->where('id', $orderDetails->pickup_point ?? 0)
        ->first();

        $orderItems = DB::table('order_items')
        ->join('products', 'products.id', '=', 'order_items.product_id')
        ->join('orders', 'orders.id', '=', 'order_items.order_id')
         ->join('order_roll_mapping', 'order_items.id', '=', 'order_roll_mapping.order_item_id')
        ->leftJoin('product_variant', 'product_variant.id', '=', 'order_items.varient_id')
        ->select('order_items.order_id','orders.status','order_roll_mapping.installer_status', 'products.product_name', 'product_variant.varient_name', 'product_variant.varient_code', 'product_variant.varient_image','order_items.quantity','order_items.price')
        ->where('order_items.order_id', $id)
        ->get()
        ->map(function ($variant) use ($default_logo) {
            $variant->varient_image = $variant->varient_image
                ? url('uploads/products/' . $variant->varient_image)
                : $default_logo;
            return $variant;
        });
        
    
        
         $orderItemscount = DB::table('order_items')
        ->where('order_items.order_id', $id)
        ->count();

        $transporters =DB::table('transporters')->where('deleted_at',null)->get();
        $transporter_data =DB::table('transporters')->where('id',$orderDetails->transporter_id)->first();
        $installer =DB::table('users')->where('type_id',5)->where('deleted_at',null)->get();

        /*$installer = DB::table('users')
            ->join('installer_charges', 'installer_charges.user_id', '=', 'users.id')
            ->join('order_items', 'order_items.product_id', '=', 'installer_charges.product_id')
            ->where('users.type_id', 5)
            ->whereNull('users.deleted_at')
            ->where('order_items.order_id', $id)
            ->select('users.id', 'users.full_name')
            ->distinct()
            ->get();*/
            
        $banks =DB::table('banks')->where('deleted_at',null)->get();
        $customers =DB::table('customers')->where('deleted_at',null)->get();
        $lastCompany = DB::table('customers')->orderBy('customer_id', 'desc')->where('deleted_at',null)->first();

    
        if ($lastCompany) {
            $lastIdNumber = (int) substr($lastCompany->customer_id, 2); // Get numeric part
            $newCustomerId = 'CU' . str_pad($lastIdNumber + 1, 6, '0', STR_PAD_LEFT); // Increment and format with leading zeros
        } else {
            $newCustomerId = 'CU000001';
        }
        //dd($orderItems);

         $payment_summary=DB::table('order_transaction')
        ->join('orders','order_transaction.order_id','=','orders.id')
          ->leftJoin('banks','order_transaction.bank_name','=','banks.id')
         ->join('order_receipt','order_transaction.order_receipt_id','=','order_receipt.id')
         ->select('order_transaction.*','orders.order_date','order_receipt.receipt_id','banks.bank_name')
         ->where('orders.id',$id)
         ->get();


        $response = [
            'order_details' => $orderDetails,
            'order_items' => $orderItems,
            'transporters' => $transporters,
            'transporter_data'=>$transporter_data,
            'installer'=>$installer,
            'orderItemscount'=>$orderItemscount,
            'banks'=>$banks,
            'pickup_point'=>$pickup_point,
            'customers' => $customers,
            'newCustomerId' => $newCustomerId,
             'order_receipt'=>$order_receipt,
               'payment_summary'=>$payment_summary
        ];
        
        // dd($response);
       return view('admin.view_order',compact('response','title'));
   
    }


     public function getOrderDetails(Request $request)
    {
        //dd($request->all());
        $orderId = $request->order_id;

        // Fetch order receipt details
       $orderReceipt = DB::table('order_receipt')
        ->join('orders','orders.id','=','order_receipt.order_id')
          ->join('customers','customers.id','=','orders.customer_id')
          ->select('order_receipt.*','customers.customer_name','customers.id as customer_id')
        ->where('order_receipt.order_id', $orderId)
        ->first();
        //dd($orderReceipt);
        // Fetch order transaction details
        $orderTransaction = DB::table('order_transaction')
        ->where('order_id', $orderId)
        ->orderBy('created_at','desc')
        ->get();

        if ($orderReceipt && $orderTransaction) {
            return response()->json([
                'success' => true,
                'data' => [
                    'order_receipt' => $orderReceipt,
                    'order_transaction' => $orderTransaction
                ]
            ]);
        } else {
            return response()->json(['success' => false, 'message' => 'Order details not found'], 404);
        }
    }


     public function changeStatus(Request $request)
    {
        try {
            $order = DB::table('orders')->where('id', $request->id)->first();

            if($order->payment_status == 'Partially Paid'){
            return response()->json(['success' => false, 'message' => 'Full payment not done yet'], 404);
            }

            if (!$order) {
                return response()->json(['success' => false, 'message' => 'Order not found'], 404);
            }

            // Define status flow and messages
            $statusFlow = [
                'Ordered', 'Measurement', 'Cutting Done', 'Payment Done', 'Packed', 'Shipped', 'Delivered'
            ];

            $statusMessages = [
                'Ordered' => 'Your order has been placed',
                'Measurement' => 'Your order has been taken for measurement',
                'Cutting Done' => 'Your order is being cut',
                'Payment Done' => 'Your payment has been processed',
                'Packed' => 'Your order has been packed',
                'Shipped' => 'Your order has been shipped',
                'Delivered' => 'Your order has been delivered',
            ];

            // Fetch the latest status from track_orders
            $lastTrackedStatus = DB::table('track_orders')
                ->where('order_id', $order->id)
                ->orderBy('id', 'desc')
                ->value('status'); 

        //dd($lastTrackedStatus);
            $lastTrackedStatus = $lastTrackedStatus ?? 'Ordered';

            $startIndex = array_search($lastTrackedStatus, $statusFlow);
            $endIndex = array_search($request->status, $statusFlow);

            // If the requested status is before the last tracked status, return an error
            if ($startIndex === false || $endIndex === false || $endIndex <= $startIndex) {
                return response()->json(['success' => false, 'message' => 'Invalid status update']);
            }

            $statusesToInsert = [];

            for ($i = $startIndex + 1; $i <= $endIndex; $i++) {
                $status = $statusFlow[$i];
            
                
                $exists = DB::table('track_orders')
                    ->where('order_id', $order->id)
                    ->where('status', $status)
                    ->exists();
            
                if (!$exists) {
                    $statusesToInsert[] = [
                        'order_id' => $order->id,
                        'status' => $status,
                        'message' => $statusMessages[$status] ?? '',
                        'created_at' => now(),
                    ];
                }
            }
            

            // Insert all missing statuses
            DB::table('track_orders')->insert($statusesToInsert);

            // Update order status
            if($request->status == 'Delivered'){
            DB::table('orders')->where('id', $order->id)->update([
                'status' => $request->status,
                'payment_status'=>'Paid'
            ]);
            }else{
            DB::table('orders')->where('id', $order->id)->update([
                'status' => $request->status
            ]);
            }
            

            return response()->json(['success' => true, 'message' => 'Status updated successfully']);

        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => 'Failed to update status', 'error' => $e->getMessage()]);
        }
    }


     public function add_new_order(){
        
       /* $lastCompany = DB::table('orders')->orderBy('order_code', 'desc')->first();
       // dd($lastCompany);
        if ($lastCompany) {
           $lastIdNumber = (int) substr($lastCompany->order_code, 3);
            $newId = 'ORD' . str_pad($lastIdNumber + 1, 6, '0', STR_PAD_LEFT); 
        } else {
            $newId = 'ORD000001';
        }*/

            $title='Add New Order';
        
        $lastCompany = DB::table('orders')
        ->whereNull('deleted_at')
        ->orderBy('order_code', 'desc')
        ->first();

     if ($lastCompany) {
        $lastIdNumber = (int) substr($lastCompany->order_code, 3); // Extract numeric part correctly
        $newId = 'ORD' . str_pad($lastIdNumber + 1, 5, '0', STR_PAD_LEFT);
     } else {
        $newId = 'ORD00001';
     }

    
        
        // dd($newId);
        $companies=DB::table('companies')->where('deleted_at',null)->get();
        $customers=DB::table('customers')->where('deleted_at',null)->get();
         $installers=DB::table('users')->where('type_id',5)->where('deleted_at',null)->get();
        $transporters=DB::table('transporters')->where('deleted_at',null)->get();
         $staffs=DB::table('staffs')->join('users','staffs.user_id','=','users.id')->where('staffs.deleted_at',null)->select('staffs.*','users.full_name')->get();
        $varients=DB::table('product_variant')->where('deleted_at',null)->get();
        $units=DB::table('units')->where('deleted_at',null)->get();
        return view('admin.add-new-order', compact('units','customers','staffs','title', 'companies','transporters','varients','newId','installers'));

    }


      public function save_new_order(Request $request){

       // dd($request->all());
        DB::beginTransaction();
    
        try {
            // Insert order details
            
            //$customer=DB::table('customers')->where('id',$request->customer_id)->first();
           
            
            $OrderId = DB::table('orders')->insertGetId([
                'order_code' => $request->order_code,
                'order_date' => $request->order_date,
                'company_id' => $request->company_id,
                'customer_id' => $request->customer_id,
                'transporter_id' => $request->transporter_id,
                 'staff_id' => $request->staff_id,
                'order_amount' => $request->subtotal,
                'subtotal' => $request->subtotal,
                'tax_percent' => $request->t_percent,
                'tax' => $request->t_amount,
                'grandtotal' => $request->grand_total,
                'advance'=>$request->advance,
                'note' => $request->note,
                'status' =>'Ordered',
                'installer_id'=>$request->installer_id ?? '',
                'address_id' => $request->address_id,
                'payment_method' => 'Cash On Delivery',
                'order_type'=>'Delivery',
                'discount_percentage' => $request->disc_percent,
                'customer_discount_amount' => $request->discount_amount,
                'order_from'=> 0,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
    
            // Process Order Items
            foreach ($request->varient_id as $key => $varientId) {
                $productid = $request->product_id[$key] ?? null;
                $availability = $request->availability[$key] ?? null;
                $warehouse = $request->warehouse_id[$key] ?? null;
                $uom = $request->uom[$key] ?? null;
                $rate = $request->rate[$key] ?? 0;
                $quantity = $request->quantity[$key] ?? 0;
                $total = $request->total[$key] ?? 0;
                $roll_no = $request->roll_no[$key] ?? 0;
    
                // $productid = DB::table('product_variant')->where('id', $varientId)->value('product_id');
    
                // Insert into order_items table
                $orderItemId=DB::table('order_items')->insertGetId([
                    'order_id' => $OrderId,
                    'product_id' => $productid,
                    'varient_id' => $varientId,
                    'uom' => $uom,
                    'price' => $rate,
                    'quantity' => $quantity,
                    'total' => $total,
                     'availability' => $availability,
                    'warehouse_id' => $warehouse,
                    'roll_no' => $roll_no,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
    
                // Process Rolls for Order Mapping
                $requiredQuantity = $quantity; 
                $totalUsed = 0;
    
                // Fetch rolls with availability greater than 0
                $rolldata = DB::table('rolls')
                  ->where('id', $roll_no)
                    ->where('varient_id', $varientId)
                     ->where('warehouse_id', $warehouse)
                    ->where('availability', '>', 0)
                      ->where('defective_status',0)
                    ->orderBy('availability', 'desc') // Use largest available roll first
                    ->get();
    
                foreach ($rolldata as $row) {
                    if ($totalUsed >= $requiredQuantity) break; // Stop when required quantity is met
    
                    $remainingToRemove = $requiredQuantity - $totalUsed;
                    $usedQty = min($row->availability, $remainingToRemove);
                    $newAvailability = $row->availability - $usedQty;
                    
                     $roll_price=$rate*$usedQty;
    
                    // Insert into order_mapping table **exactly as per expected format**
                    DB::table('order_roll_mapping')->insert([
                        'roll_id' => $row->id,
                        'customer_id' => $request->customer_id,
                         'order_item_id' =>$orderItemId,
                        'order_id' => $OrderId,
                        'installer_id' => $request->installer_id ?? '',
                        'installer_status' => 'Measurement',
                        'order_receipt' => null,
                        'total_quantity' => $row->quantity,
                        'roll_quantity'=>$row->availability, 
                        'used_quantity'=>$usedQty,
                        'available_quantity' => $newAvailability, 
                        'roll_price'=>$roll_price,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
    
                    // Update rolls table
                    DB::table('rolls')->where('id', $row->id)->update([
                        'availability' => $newAvailability,
                        'remark' => ($newAvailability == 0) ? 'sold' : 'partial sold',
                        'updated_at' => now(),
                    ]);
    
                    $totalUsed += $usedQty;
                }
            }
    
            DB::commit();


             $senderadmin = 'info@rush.speakwise.site';
                     //  $recieveradmin = $supplier->email;
                       $recieveradmin ='rushikeshwakde.oms@gmail.com';
                       $fromNameadmin = 'Floor Factory';
                    
                        // Generate the PDF content for the purchase order
           
                $Orders = DB::table('orders')
            ->join('companies', 'orders.company_id', '=', 'companies.id')
            ->join('customers', 'orders.customer_id', '=', 'customers.id')
            ->select('orders.*', 'companies.company_name', 'customers.customer_name', 'customers.email as customer_email', 'companies.email as company_email','companies.address','customers.address as customeraddress') // Added company & customer emails
            ->where('orders.id', $OrderId)
            ->first();
            
              $OrderItems = DB::table('order_items')
             ->join('product_variant','order_items.varient_id','=','product_variant.id')
             ->join('products','order_items.product_id','=','products.id')
              ->join('units','order_items.uom','=','units.id')
               ->join('warehouses','order_items.warehouse_id','=','warehouses.id')
               ->where('order_items.order_id', $OrderId)
             ->select('order_items.*','product_variant.id as varid','products.product_name','product_variant.varient_name','product_variant.varient_code','units.id as unit_id','units.unit_name as uom','warehouses.warehouse_name')
             ->get();

           //  dd($OrderId);
         
            
          

            $pdf = \PDF::loadView('emails.saleorder_pdf', [
                'Orders' => $Orders,
                'OrderItems' => $OrderItems
            ]);
            
          $emailContent = "Hello " . $Orders->customer_name . ",<br><br>";
            $emailContent .= "Thank you for your order! We’re excited to let you know that your sales order has been successfully received.<br><br>";
            $emailContent .= "Please find the details of your order in the attached document for your reference.<br><br>";
            $emailContent .= "If you have any questions or need further assistance, feel free to contact us at any time.<br><br>";
            $emailContent .= "Best regards,<br>";
            $emailContent .= "Floor Factory";


        
        
        
            Mail::send('emails.sale_order_email', ['customerName' => $Orders->customer_name], function ($message) use ($pdf, $recieveradmin, $senderadmin, $fromNameadmin, $Orders) {
                $message->to($recieveradmin)
                ->subject('Sale Order Invoice')
                ->from($senderadmin, $fromNameadmin)
                ->attachData($pdf->output(), 'sale_order_' . $Orders->order_code . '.pdf', [
                    'mime' => 'application/pdf'
                ]);
            });
            
            
               /*  $senderadmin = 'info@rush.speakwise.site';
        // $recieveradmin = $customer->email;
        $recieveradmin = 'rushikeshwakde.oms@gmail.com';
        $fromNameadmin = 'Floor Factory';

        $orders = DB::table('orders')
            ->join('companies', 'orders.company_id', '=', 'companies.id')
            ->join('customers', 'orders.customer_id', '=', 'customers.id')
            ->select('orders.*', 'companies.company_name', 'customers.customer_name', 'customers.email as customer_email', 'companies.email as company_email') // Added company & customer emails
            ->where('orders.id', $OrderId)
            ->first(); // Use `get()` if expecting multiple orders

        if ($orders) {
            // Send email to Customer
            Mail::send('emails.order_customer_email', ['orders' => $orders], function ($message) use ($orders, $senderadmin, $fromNameadmin) {
            $message->to($orders->customer_email) // Sending to the customer
                ->subject('Your Order Confirmation')
                ->from($senderadmin, $fromNameadmin);
            });

            // Send email to Company
            Mail::send('emails.order_company_email', ['orders' => $orders], function ($message) use ($orders, $senderadmin, $fromNameadmin) {
            $message->to($orders->company_email) // Sending to the company
                ->subject('New Order Received')
                ->from($senderadmin, $fromNameadmin);
            });

            // Send email to Admin
            Mail::send('emails.order_admin_email', ['orders' => $orders], function ($message) use ($recieveradmin, $senderadmin, $fromNameadmin) {
            $message->to($recieveradmin) // Sending to Admin
                ->subject('New Order Notification')
                ->from($senderadmin, $fromNameadmin);
            });
        }*/




            return redirect()->route('orders')->with('success', 'Order Created Successfully!');
        } catch (\Exception $e) {
            DB::rollback();
            return back()->with('error', 'Error creating order: ' . $e->getMessage());
        }
    }



 public function edit_new_order($id){
        
        $title='Edit New Order';
        $companies=DB::table('companies')->where('deleted_at',null)->get();
        $customers=DB::table('customers')->where('deleted_at',null)->get();
      
        $transporters=DB::table('transporters')->where('deleted_at',null)->get();
        $staffs=DB::table('staffs')->join('users','staffs.user_id','=','users.id')->where('staffs.deleted_at',null)->select('staffs.*','users.full_name')->get();
        $units=DB::table('units')->where('deleted_at',null)->get();

        
        $order = DB::table('orders')
        ->where('id', $id)
        ->first();
       

        $company_id=$order->company_id;

        $varients = DB::table('product_variant')
        ->join('products', 'product_variant.product_id', '=', 'products.id')
        ->where('products.company_id', $company_id)
        ->where('product_variant.deleted_at',null)
        ->select('product_variant.id','product_variant.varient_name','product_variant.varient_code')
        ->get();

        $products = DB::table('products')
            ->where('company_id', $company_id)
            ->whereNull('deleted_at')
            ->select('id as product_id', 'product_name')
            ->get();
       
      

       // Fetch the associated items for this purchase order
       $order_items = DB::table('order_items')
       ->join('warehouses','order_items.warehouse_id','=','warehouses.id')
       ->join('orders','orders.id','=','order_items.order_id')
        ->join('products','products.id','=','order_items.product_id')
         ->join('product_variant','product_variant.id','=','order_items.varient_id')
        ->join('units','order_items.uom','=','units.id')
       ->select('order_items.*','warehouses.warehouse_name','units.unit_name','orders.order_code','products.product_name','product_variant.varient_name','product_variant.varient_code')
        ->where('order_items.order_id', $id)
        ->get();

       // dd($id);

     // Structure the data with order items as an array
     $order_details = [
        'id'=>$order->id,
        'company_id' => $order->company_id,
        'customer_id' => $order->customer_id,
        'transporter_id' => $order->transporter_id,
         'staff_id' => $order->staff_id,
        'order_date' => $order->order_date,
        'order_code' => $order->order_code,
        'payment_status' => $order->payment_status,
        'tax' => $order->tax,
        'tax_percent' => $order->tax_percent,
        'discount' => $order->discount,
        'customer_discount_amount' => $order->customer_discount_amount,
        'discount_percentage' => $order->discount_percentage,
        'note' => $order->note,
        'subtotal' => $order->subtotal,
        'status'=>$order->status,
        'grandtotal' => $order->grandtotal,
        'created_at' => $order->created_at,
        'updated_at' => $order->updated_at,
        'items' => $order_items, 
     ];
     // dd( $order_items);
     return view('admin.edit-new-order', compact('units','title','staffs','customers', 'companies','transporters','varients','products','order_details','order'));

    }

 public function update_new_order(Request $request)
    {
        DB::beginTransaction();
        $id = $request->id;

        try {
            // Update the order
            DB::table('orders')->where('id', $id)->update([
                'order_date' => $request->order_date,
                'order_code' => $request->order_code,
                'company_id' => $request->company_id,
                'transporter_id' => $request->transporter_id,
                 'staff_id' => $request->staff_id,
                'subtotal' => $request->subtotal,
                'tax_percent' => 0,
                'tax' => 0,
                'grandtotal' => $request->grand_total,
                'discount_percentage' => $request->disc_percent,
                'customer_discount_amount' => $request->discount_amount,
                'advance' => $request->advance,
                'note' => $request->note,
                'updated_at' => now(),
            ]);

            // Optional: Restore old roll availability from previous mapping
            $oldMappings = DB::table('order_roll_mapping')->where('order_id', $id)->get();
            foreach ($oldMappings as $map) {
                DB::table('rolls')->where('id', $map->roll_id)->increment('availability', $map->used_quantity);
                DB::table('rolls')->where('id', $map->roll_id)->update([
                    'remark' => 'restored',
                    'updated_at' => now(),
                ]);
            }

            // Clean old records
            DB::table('order_items')->where('order_id', $id)->delete();
            DB::table('order_roll_mapping')->where('order_id', $id)->delete();

            // Re-insert new order items and roll mappings
            foreach ($request->varient_id as $key => $varientId) {
                $product_id = $request->product_id[$key] ?? null;
                $availability = $request->availability[$key] ?? null;
                $warehouse = $request->warehouse_id[$key] ?? null;
                $uom = $request->uom[$key] ?? null;
                $rate = $request->rate[$key] ?? 0;
                $quantity = $request->quantity[$key] ?? 0;
                $total = $request->total[$key] ?? 0;
                 $roll_no = $request->roll_no[$key] ?? 0;

                $orderItemId = DB::table('order_items')->insertGetId([
                    'order_id' => $id,
                    'product_id' => $product_id,
                    'varient_id' => $varientId,
                    'uom' => $uom,
                    'price' => $rate,
                    'quantity' => $quantity,
                    'total' => $total,
                    'warehouse_id' => $warehouse,
                     'roll_no' => $roll_no,
                    'availability' => $availability,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);

                // Roll mapping
                $requiredQuantity = $quantity;
                $totalUsed = 0;

                $rolldata = DB::table('rolls')
                   ->where('id',$roll_no)
                    ->where('varient_id', $varientId)
                    ->where('warehouse_id', $warehouse)
                    ->where('availability', '>', 0)
                    ->where('defective_status', 0)
                    ->orderBy('availability', 'desc')
                    ->get();

                foreach ($rolldata as $row) {
                    $remainingToRemove = $requiredQuantity - $totalUsed;
                    $usedQty = min($row->availability, $remainingToRemove);
                    $newAvailability = $row->availability - $usedQty;
                    $roll_price = $rate * $usedQty;

                    DB::table('order_roll_mapping')->insert([
                        'roll_id' => $row->id,
                        'customer_id' => $request->customer_id,
                        'order_item_id' => $orderItemId,
                        'order_id' => $id,
                        'installer_id' => $request->installer_id ?? '',
                        'installer_status' => 'Measurement',
                        'order_receipt' => null,
                        'total_quantity' => $row->quantity,
                        'used_quantity' => $usedQty,
                        'available_quantity' => $newAvailability,
                        'roll_price' => $roll_price,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);

                    DB::table('rolls')->where('id', $row->id)->update([
                        'availability' => $newAvailability,
                        'remark' => ($newAvailability == 0) ? 'sold' : 'partial sold',
                        'updated_at' => now(),
                    ]);

                    $totalUsed += $usedQty;
                    if ($totalUsed >= $requiredQuantity) break;
                }
            }

            DB::commit();
            return redirect()->route('orders')->with('success', 'Order Updated Successfully!');
        } catch (\Exception $e) {
            DB::rollback();
            return back()->with('error', 'Error updating order: ' . $e->getMessage());
        }
    }



     public function store_order_reciept(Request $request)
    {
        //dd($request->all());
        DB::beginTransaction();

        try {
            // Generate receipt ID
            $date = date('Ymd');
            $last = DB::table('order_receipt')
                ->where('receipt_id', 'like', "REC-$date-%")
                ->orderBy('receipt_id', 'desc')
                ->first();

            $nextSeq = $last 
                ? str_pad(((int)substr($last->receipt_id, -3)) + 1, 3, '0', STR_PAD_LEFT)
                : '001';
            $receipt_id = "REC-$date-$nextSeq";

            // Determine payment vs order status
            $total = (float) $request->total_amount_new;
            $paid = (float) $request->pay_amount;
            if ($total >  $paid) {
                $paymentStatus = 'Partially Paid';
                $orderStatus   = 'Cutting Done';
            } else {
                $paymentStatus = 'Paid';
                $orderStatus   = 'Payment Done';
            }
            
          

            // Insert receipt
            $receiptId = DB::table('order_receipt')->insertGetId([
                'receipt_id'      => $receipt_id,
                'order_id'        => $request->order_id,
                'receipt_type'    => $request->receipt_type,
                'customer_name'   => $request->customer_name,
                'customer_email'  => $request->customer_email,
                'customer_phone'  => $request->customer_phone,
                'order_date'      => $request->order_date,
                'transaction_date' => $request->transaction_date,
                'payment_method'  => $request->payment_method,
                'total_amount'    => $total,
                'paid_amount'     => $paid,
                'remaining_amount'=> $total - $paid,
                'payment_status'  => $paymentStatus,
                'remark'          => $request->remark,
                'order_status'    => $orderStatus,
                'shipping_address'=> $request->shipping_address,
                'items_ordered'   => $request->items_ordered,
                'created_at'      => now(),
                'updated_at'      => now(),
            ]);

            // Update main orders table
            DB::table('orders')->where('id', $request->order_id)
                ->update(['status' => $orderStatus, 'payment_status' => $paymentStatus]);

            // Link receipt to rolls
            DB::table('order_roll_mapping')->where('order_id', $request->order_id)
                ->update(['order_receipt' => $receipt_id]);

            // Track order status
            if (!DB::table('track_orders')
                ->where('order_id', $request->order_id)
                ->where('status', $orderStatus)
                ->exists()) {
                DB::table('track_orders')->insert([
                    'order_id'  => $request->order_id,
                    'status'    => $orderStatus,
                    'message'   => $paymentStatus === 'Paid'
                        ? 'Your payment has been received in full.'
                        : 'Your payment has been processed partially.',
                    'created_at'=> now()
                ]);
            }

            // Log transaction
            DB::table('order_transaction')->insert([
                'order_receipt_id' => $receiptId,
                'order_id'         => $request->order_id,
                'payment_mode'     => $request->payment_method,
                'bank_name'        => $request->bank_name,
                'ifsc_code'        => $request->ifsc_code,
                'account_number'   => $request->account_number,
                'payment_status'   => $paymentStatus,
                'order_amount'      => $total,
                'amount_paid'      =>  $total,
                'pay_amount'      => $paid,
                'remaining_amount'  => $total-$paid,
                'transaction_date' => $request->transaction_date ?? now(),
                'cheque_number'    => $request->cheque_number,
                'cheque_date'    => $request->cheque_date,
                'reference_id'     => $request->reference_id,
                 'remark'          => $request->remark,
                'created_at'       => now(),
                'updated_at'       => now(),
            ]);

            // All good? commit
            DB::commit();

            $recieptData = DB::table('order_receipt')->where('id', $receiptId)->first();

            return response()->json([
                'success'      => true,
                'receipt_data' => $recieptData,
                'paymentStatus'=> $paymentStatus,
                'orderStatus'  => $orderStatus,
                'message'      => 'Order receipt stored successfully.'
            ]);
        } catch (\Throwable $e) {
            DB::rollback();
            return response()->json([
                'success' => false,
                'error'   => $e->getMessage()
            ], 500);
        }
    }
    
     public function update_order_reciept(Request $request)
     {
       // dd($request->all());

        
           $newdata=DB::table('order_receipt')->where('order_id',$request->order_id)->first();
       

            $paid_amount = $newdata->paid_amount + $request->pay_amount;
            $remaining_amount = $request->total_amount - $paid_amount;

          // dd(  $paid_amount);
          // dd(  $remaining_amount );
            $updateData = [ 
                'receipt_type'     => $request->receipt_type,
                'remark'           => $request->remark,
                'customer_name'    => $request->customer_name,
                'customer_email'   => $request->customer_email,
                'customer_phone'   => $request->customer_phone,
                'order_date'       => $request->order_date,
                'transaction_date' => $request->transaction_date,
                'payment_method'   => $request->payment_method,
                'total_amount'     => $request->total_amount,
                'paid_amount'      => $paid_amount,
                'remaining_amount' => $remaining_amount,
                'shipping_address' => $request->shipping_address,
                'items_ordered'    => $request->items_ordered,
                'updated_at'       => date('Y-m-d H:i:s'),
            ];

            // Only set status as paid if remaining is 0
            if ($remaining_amount == 0) {
                $updateData['order_status'] = 'Payment Done';
                $updateData['payment_status'] = 'Paid';

                 $paystatus=DB::table('orders')->where('id',$request->order_id)->update([
                'status'=>'Payment Done',
                'payment_status'=>'Paid'
                ]);
                
            }

              $data = DB::table('order_receipt')
                ->where('order_id', $request->order_id)
                ->update($updateData);

           

        // if ($remaining_amount == 0) {
        //     $paystatus=DB::table('orders')->where('id',$request->order_id)->update([
        //         'status'=>'Payment Done',
        //         'payment_status'=>'Paid'
        //     ]);
        // }
        

        //order transaction

           $total = (float) $request->total_amount;
            $paid = (float) $request->paid_amount;
            if ($total >  $paid) {
                $paymentStatus = 'Partially Paid';
              
            } else {
                $paymentStatus = 'Paid';
               
            }


          DB::table('order_transaction')->insert([
                'order_receipt_id' => $newdata->id,
                'order_id'         => $request->order_id,
                'payment_mode'     => $request->payment_method,
                'bank_name'        => $request->bank_name ?? '',
                'account_number'   => $request->account_number ?? '',
                'payment_status'   => $paymentStatus,
                'order_amount'      => $total,
                'amount_paid'      => $request->remaining_amount,
                'pay_amount'=>$request->pay_amount,
                'remaining_amount'  => $request->remaining_amount-$request->pay_amount,
                'transaction_date' => $request->transaction_date,
                'cheque_number'    => $request->cheque_number ?? '',
                'ifsc_code'         => $request->ifsc_code ?? '',
                'reference_id'     => $request->reference_id ?? '',
                 'remark'          => $request->remark,
                'created_at'       => now(),
                'updated_at'       => now(),
            ]);


        // $transaction=DB::table('order_transaction')->where('order_id',$request->order_id)->update(
        //     [ 
        //     'payment_mode'=>$request->payment_method,
        //     'bank_name'=>$request->bank_name ?? '',
        //     'account_number'=>$request->account_number ?? '',
        //     'payment_status'=>$request->pay_status,
        //     'amount_paid'=>$request->total_amount ?? '',
        //     'transaction_date'=>$request->transaction_date ?? '',
        //     'cheque_number'=>$request->cheque_number ?? '',
        //     'reference_id'=>$request->reference_id ?? '',
        //         'updated_at' => date('Y-m-d H:i:s'),
        //     ]
        //     );
            

            return response()->json([
                'success' => true,
                'message' => 'Order receipt updated successfully' 
            ]);
            

     }




    public function generate_orderreceipt($id)
    {
    
   
        $orders=DB::table('orders')
        ->join('customers','customers.id','=','orders.customer_id')
        ->leftJoin('companies','companies.id','=','orders.company_id')
        ->select('orders.*','customers.customer_name','customers.email','customers.mobile','customers.address','companies.company_name')
        ->where('orders.id',$id)
        ->first();
    
        
        $order_items = DB::table('order_items')
            ->where('order_id', $id)
            ->join('product_variant','order_items.varient_id','=','product_variant.id')
            ->join('products','order_items.product_id','=','products.id')
            ->select('order_items.*','products.product_name','product_variant.id as varid','product_variant.varient_name','product_variant.varient_code')
            ->get();

         $order_receipt=DB::table('order_receipt')->where('order_id',$id)->first();   
         $order_transaction=DB::table('order_transaction')->where('order_id',$id)->first();   
          $order_transaction_bank=DB::table('order_transaction')
         ->join('banks','order_transaction.bank_name','=','banks.id')
         ->select('order_transaction.*','banks.bank_name')
         ->where('order_id',$id)->first(); 

          $payment_summary=DB::table('order_transaction')
         ->join('orders','order_transaction.order_id','=','orders.id')
         ->leftJoin('banks','order_transaction.bank_name','=','banks.id')
         ->join('order_receipt','order_transaction.order_receipt_id','=','order_receipt.id')
         ->select('order_transaction.*','orders.order_date','order_receipt.receipt_id','banks.bank_name')
         ->where('orders.id',$id)
         ->get();
       // dd($order_transaction);
        // Structure the data with order items as an array
        $ord_details = [
            'id' => $orders->id,
            'order_code' => $orders->order_code,
            'receipt_id'=>$order_receipt->receipt_id,
            'customer_name' => $orders->customer_name,
            'customer_email' => $orders->email,
            'customer_address' => $orders->address,
             'shipping_address' => $order_receipt->shipping_address,
            'customer_mobile' => $orders->mobile,
            'company_name' => $orders->company_name,
            'order_date' => $orders->order_date,
            'order_amount' => $orders->order_amount,
             'subtotal' => $orders->subtotal,
            'discount' => $orders->discount,
            'customer_discount_amount' => $orders->customer_discount_amount,
            'status' => $orders->status,
            'subtotal' => $orders->subtotal,
            'grandtotal' => $orders->grandtotal,
            'payment_status' => $orders->payment_status,
            'receipt_type' => $order_receipt->receipt_type,
            'remark' => $order_receipt->remark,
            'payment_method' => $order_receipt->payment_method,
             'bank_name' => $order_transaction_bank->bank_name ?? '',
             'account_number' => $order_transaction_bank->account_number ?? '',
             'reference_id' => $order_transaction_bank->reference_id ?? '',
             'cheque_number' => $order_transaction->cheque_number ?? '',
            'created_at' => $orders->created_at,
            'updated_at' => $orders->updated_at,
            'items' => $order_items, 
             'payment_summary' => $payment_summary
        ];
           //dd($ord_details);
        // Load the view and pass the PO details directly
        

        //$options = new Options();
       // $options->set('defaultFont', 'DejaVu Sans');

     //  return view('admin.order-receipt-pdf',['ord_details' => $ord_details]);
       
       $pdf = \PDF::loadView('admin.order-receipt-pdf',['ord_details' => $ord_details]);
      return $pdf->download('order_receipt' . $ord_details['receipt_id'] . '.pdf');
    }


    public function cancel_order(Request $request, $id)
    {
        DB::beginTransaction();

        try {
            $order = DB::table('orders')->where('id', $id)->first();

            if (!$order) {
                return response()->json(['message' => 'Order not found.'], 404);
            }

            if (!in_array($order->status, ['Ordered', 'Measurement', 'Cutting Done', 'Payment Done', 'Packed'])) {
                return response()->json(['message' => 'Order cannot be cancelled at this stage.'], 403);
            }

            // Cancel the order
            DB::table('orders')->where('id', $id)->update([
                'status' => 'Cancelled',
                'cancel_reason' => $request->cancel_reason ?? null,
                'updated_at' => now(),
            ]);

            // Revert roll availability
            $rollMappings = DB::table('order_roll_mapping')->where('order_id', $id)->get();

            foreach ($rollMappings as $map) {
                DB::table('rolls')->where('id', $map->roll_id)->increment('availability', $map->used_quantity);
                $roll = DB::table('rolls')->where('id', $map->roll_id)->first();
                $remark = ($roll->availability == $roll->quantity) ? 'unsold' : 'partial sold';

                DB::table('rolls')->where('id', $map->roll_id)->update([
                    'remark' => $remark,
                    'updated_at' => now()
                ]);
            }

            DB::commit();

            // If already paid, show refund modal
            if ($order->status === 'Payment Done') {
                $receipt = DB::table('order_receipt')->where('order_id', $id)->first();

                return response()->json([
                    'message' => 'Order cancelled. Refund required.',
                    'refund_required' => true,
                    'receipt_id' => $receipt->id ?? null,
                    'refund_amount' => $receipt->paid_amount ?? 0
                ]);
            }

            return response()->json(['message' => 'Order cancelled successfully.', 'refund_required' => false]);

        } catch (\Exception $e) {
            DB::rollback();
            return response()->json(['message' => 'Error cancelling order: ' . $e->getMessage()], 500);
        }
    }


    public function process_refund(Request $request)
    {
       $receipt=DB::table('order_receipt')->where('id', $request->order_receipt_id)->first();

       $data=DB::table('orders')->where('id',$receipt->order_id)->update(['refund_status'=> 1]);

        try {
            DB::table('order_transaction')->insert([
                'order_receipt_id'     => $request->order_receipt_id,
                'order_id'             => $request->order_id ?? $receipt->order_id,
                'refund_amount'        => $request->refund_amount,
                'refund_mode'          => $request->refund_mode,
                'refunded_at'          => now(),
                'payment_status'       => 'Refunded',
                'remark'               => $request->remark,
                'bank_name'            => $request->bank_name,
                'ifsc_code'            => $request->ifsc_code,
                'account_number'       => $request->account_number,
                'created_at'           => now(),
                'updated_at'           => now(),
            ]);

            return response()->json(['message' => 'Refund processed successfully.']);
        } catch (\Exception $e) {
            return response()->json(['message' => 'Refund failed: ' . $e->getMessage()], 500);
        }
    }


    
    public function getRollsmappingadmin($order_id)
    {
     
        $rolls = DB::table('order_roll_mapping')
        ->join('customers', 'order_roll_mapping.customer_id', '=', 'customers.id')
        ->join('users', 'order_roll_mapping.installer_id', '=', 'users.id')
        ->join('order_items', 'order_roll_mapping.order_item_id', '=', 'order_items.id')
         ->join('orders', 'order_roll_mapping.order_id', '=', 'orders.id')
        ->join('product_variant', 'order_items.varient_id', '=', 'product_variant.id')
         ->join('products', 'products.id', '=', 'product_variant.product_id')
            ->where('order_roll_mapping.order_id',$order_id)
            ->orderBy('order_roll_mapping.id','asc')
            ->select('order_roll_mapping.*','orders.order_code','products.product_name','product_variant.varient_name','product_variant.varient_code','customers.customer_name as customer_name','users.full_name as installer_name')
            ->get();
          //dd($rolls);
        return response()->json($rolls);
    }


     public function updateRollStatusadmin(Request $request)
    {
        try {
            $roll_id = $request->roll_id;
            $order_id = $request->order_id;
            $status = $request->status;
    
            // Start a database transaction
            DB::beginTransaction();
    
            // Check if the roll belongs to the given order
            $rollExists = DB::table('order_roll_mapping')
                ->where('roll_id', $roll_id)
                ->where('order_id', $order_id)
                ->exists();
    
            if (!$rollExists) {
                // Rollback the transaction if the roll does not exist
                DB::rollBack();
                return response()->json([
                    'success' => false,
                    'message' => 'Invalid roll_id or order_id!',
                ], 400);
            }
    
            // Update the roll status
            $updated = DB::table('order_roll_mapping')
                ->where('roll_id', $roll_id)
                ->update(['installer_status' => $status]);
    
            if (!$updated) {
                // Rollback the transaction if the update fails
                DB::rollBack();
                return response()->json([
                    'success' => false,
                    'message' => 'No records updated, check if roll_id exists.',
                ], 400);
            }
    
            // Check if all rolls for this order have the status 'cutting done'
            $allCuttingDone = DB::table('order_roll_mapping')
                ->where('order_id', $order_id)
                ->where('installer_status', '!=', 'Cutting Done')
                ->doesntExist();
    
            // If all rolls are marked as 'cutting done', update the order status to 'Cutting'
            if ($allCuttingDone) {
                DB::table('orders')
                    ->where('id', $order_id)
                    ->update(['status' => 'Cutting Done']);
                    
                    $exists = DB::table('track_orders')
                ->where('order_id', $order_id)
                ->where('status', 'Cutting Done')
                ->exists();
                
                if (!$exists) {
			   DB::table('track_orders')->insert([
				'order_id' => $order_id,
				'status' => 'Cutting Done',
				'message'=>'Your order is being cut',
				'created_at' => now()
				
			    ]);
			}

                
            }
    
            // Commit the transaction
            DB::commit();
    
            return response()->json([
                'success' => true,
                'message' => 'Roll status updated successfully!',
            ], 200);
        } catch (\Exception $e) {
            // Rollback the transaction in case of an exception
            DB::rollBack();
            return response()->json([
                'success' => false,
                'message' => 'Something went wrong: ' . $e->getMessage(),
            ], 500);
        }
    }

     public function cutAllRollsAdmin(Request $request)
    {
        try {
            $rollIds = $request->input('roll_ids', []);
            $orderId = $request->input('order_id');

            if (empty($rollIds)) {
                return response()->json(['success' => false, 'message' => 'No rolls to update.']);
            }

            DB::beginTransaction();

            DB::table('order_roll_mapping')
                ->whereIn('roll_id', $rollIds)
                ->update(['installer_status' => 'Cutting Done']);

            // Check if all rolls for this order are now cut
            $allCut = DB::table('order_roll_mapping')
                ->where('order_id', $orderId)
                ->where('installer_status', '!=', 'Cutting Done')
                ->doesntExist();

            if ($allCut) {
                DB::table('orders')->where('id', $orderId)->update(['status' => 'Cutting Done']);

                $exists = DB::table('track_orders')
                    ->where('order_id', $orderId)
                    ->where('status', 'Cutting Done')
                    ->exists();

                if (!$exists) {
                    DB::table('track_orders')->insert([
                        'order_id' => $orderId,
                        'status' => 'Cutting Done',
                        'message' => 'Your order is being cut',
                        'created_at' => now()
                    ]);
                }
            }

            DB::commit();

            return response()->json([
                'success' => true,
                'message' => 'All selected rolls have been cut successfully.',
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'success' => false,
                'message' => 'Error: ' . $e->getMessage(),
            ], 500);
        }
    }



    
    public function generate_taxinvoice($id)
    {
       
        $lastInvoice=DB::table('invoice_nos')->orderBy('id','desc')->first();

        if ($lastInvoice) {
            $invoiceNo = $lastInvoice->invoice_no + 1;
        } else {
            $invoiceNo = 100000;
        }


        $order = DB::table('orders')
         ->join('customers', 'orders.customer_id', '=', 'customers.id')
         ->select(
             'orders.*',
            'customers.id as customer_id',
            'customers.customer_name',
            'customers.gst_number'
         )
         ->where('orders.id', $id)
         ->first();
      
         $customers=DB::table('customers')->where('deleted_at',null)->get();


          $orderItems = DB::table('order_items')
                ->join('products', 'order_items.product_id', '=', 'products.id')
                 ->join('pricing', 'pricing.product_id', '=', 'products.id')
                 ->join('units', 'order_items.uom', '=', 'units.id')
                ->leftJoin('product_variant', 'order_items.varient_id', '=', 'product_variant.id')
                ->select(
                    'order_items.*',
                    'products.product_name',
                    'product_variant.varient_code',
                     'product_variant.varient_name',
                    'products.hsn_code',
                    'units.unit_name',
                    'pricing.gst_rate'
                )
                ->where('order_items.order_id', $id)
                ->get();
              //dd($orderItems);
             

         
        
        return view('admin.generate_taxinvoice',compact('invoiceNo','order','customers','orderItems'));
    }


    public function save_taxinvoice(Request $request){

     
      $order_id = $request->order_id;
      $invoice_no = $request->invoice_no;
      $customer_id = $request->customer_id;
      $gst_5 = $request->gst_5;
      $gst_12 = $request->gst_12;
      $gst_18 = $request->gst_18;
      $gst_28 = $request->gst_28;
      $total_amount = $request->total_amount;
      $base_amount = $request->base_amount;
      $discount = $request->discount;
      $gst_amount = $request->gst_amount;
      $net_amount = $request->net_amount;

      $data = DB::table('invoice_nos')->insert([
            'order_id'      => $request->order_id ?? 0,
            'invoice_no'    => $request->invoice_no ?? 0,
            'customer_id'   => $request->customer_id ?? 0,
            'gst_5'         => $request->gst_5 ?? 0,
            'gst_12'        => $request->gst_12 ?? 0,
            'gst_18'        => $request->gst_18 ?? 0,
            'gst_28'        => $request->gst_28 ?? 0,
            'gst_amount'     => $request->gst_amount ?? 0,
            'base_amount'   => $request->base_amount ?? 0,
            'total_amount'  => $request->total_amount ?? 0,
            'discount'  => $request->discount ?? 0,
            'net_amount'    => $request->net_amount ?? 0,
            'created_at'    => now(),
            'created_at'    => now(),

      ]);

      $orders= DB::table('orders')->where('id',$order_id)->update([
        'bill_generate' => 1
      ]);

      return redirect()->route('view_order', ['id' => $order_id])->with('success', 'Tax invoice generated successfully');

    }
    

}
