<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ProductController extends Controller
{
    public function product_list(){
        $title='Product List';
        $products=DB::table('products')
        ->leftJoin('brands','brands.id','=','products.brand_id')
        ->leftJoin('units','units.id','=','products.unit_id')
        ->leftJoin('companies','companies.id','=','products.company_id')
        ->leftJoin('warehouses','warehouses.id','=','products.warehouse_id')
        ->leftJoin('categories','categories.id','=','products.category_id')
        ->leftJoin('sub_categories','sub_categories.id','=','products.sub_category_id')
        ->select('products.id','products.product_name','products.product_image','products.product_code','products.status','products.description','products.technical_details','products.deleted_at',
        'brands.brand_name','units.unit_name','categories.category_name','sub_categories.sub_category_name','warehouses.warehouse_name','companies.company_name')
        ->where('products.deleted_at',null)
       
         ->orderBy('products.id','desc')
        ->get();
        
        return view('admin.product-list',compact('products','title'));
    }



    public function product_details(){
        return view('admin.product-details');
    }

    public function edit_product($id){
        $title='Edit Product';
        $category=DB::table('categories')->where('deleted_at',null)->where('status',1)->get();
        $company=DB::table('companies')->where('deleted_at',null)->where('status',1)->get();
        $warehouses=DB::table('warehouses')->where('deleted_at',null)->where('status',1)->get();
        $suppliers=DB::table('suppliers')->where('deleted_at',null)->where('status',1)->get();
        $pricing=DB::table('pricing')->where('product_id',$id)->where('status',1)->first();
     
        $brands=DB::table('brands')->where('deleted_at',null)->where('status',1)->get();
        $units=DB::table('units')->where('deleted_at',null)->where('status',1)->get();
        $product_images=DB::table('product_images')->where('product_id',$id)->where('deleted_at',null)->get();
        $warehouse_products=DB::table('warehouse_products')->where('product_id',$id)->get();
        $product=DB::table('products')
        ->leftJoin('brands','brands.id','=','products.brand_id')
        ->leftJoin('units','units.id','=','products.unit_id')
        ->leftJoin('companies','companies.id','=','products.company_id')
        ->leftJoin('warehouses','warehouses.id','=','products.warehouse_id')
        ->leftJoin('categories','categories.id','=','products.category_id')
        ->leftJoin('sub_categories','sub_categories.id','=','products.sub_category_id')
        ->select('products.*','brands.brand_name','units.unit_name','units.id as unitid','brands.id as brandid','categories.id as categoryid','sub_categories.id as subcategory_id','warehouses.id as warehouseid','companies.id as companyid','categories.category_name','sub_categories.sub_category_name','warehouses.warehouse_name','companies.company_name')
        ->where('products.id',$id)
        ->first();
        $subcategory = DB::table('sub_categories')->where('category_id', $product->category_id)->where('status',1)->get();

        return view('admin.edit-product',compact('product','title','product_images','warehouse_products','pricing','brands','suppliers','units','category','subcategory','company','warehouses'));
    }

public function update_product(Request $request)
{
    // dd($request->all());
    // Initial data
    $id = $request->id;
    $company_id = $request->company_id;
    $warehousedata = $request->warehouse;
    $pack_margin = $request->pack_margin;
    $cut_margin = $request->cut_margin;
    $cut_amt=$request->cut_margin_amt;
    $pack_amt=$request->pack_margin_amt;
    $supplier_id = $request->supplier_id;
    $product_name = $request->product_name;
    $product_code = $request->product_code;
    $category = $request->category;
    $subcategory = $request->subcategory;
    $brand_id = $request->brand_id;
    $unit_id = $request->unit_id;
    $description = $request->description;
    $technical_details = $request->technical_details;
    $cut_amt = $request->cut_margin_amt;
    $pack_amt = $request->pack_margin_amt;
    $hsn_code=$request->hsn_code;
    $quantityroll=$request->quantityroll;
    $thickness = $request->thickness;
    $roll_size=$request->roll_size;
    $cgst_rate=$request->cgst_rate;
    $sgst_rate=$request->sgst_rate;
    $igst_rate=$request->igst_rate;

    // Ensure cut_amt and pack_amt are arrays
    if (!is_array($cut_amt)) {
        $cut_amt = [$cut_amt];
    }
    if (!is_array($pack_amt)) {
        $pack_amt = [$pack_amt];
    }
    if (!is_array($warehousedata)) {
        $warehousedata = [$warehousedata];
    }
    if (!is_array($pack_margin)) {
        $pack_margin = [$pack_margin];
    }
    if (!is_array($cut_margin)) {
        $cut_margin = [$cut_margin];
    }
    if (!is_array($cut_amt)) {
            $cut_amt = [$cut_amt]; 
        }
        if (!is_array($pack_amt)) {
            $pack_amt = [$pack_amt]; 
        }

    // Fetch the product
    $product = DB::table('products')->where('id', $id)->first();

    // Handling the product image
    if ($request->hasFile('product_image')) {
        $file = $request->file('product_image');
        $extension = $file->getClientOriginalExtension();
        $logo = rand(11111111, 99999999) . '.' . $extension;
        $image_path = public_path('uploads/products');
        $file->move($image_path, $logo);
    } else {
        $logo = $product->product_image;
    }

    // Update the product table
    DB::table('products')->where('id', $id)->update([
        'product_name' => $product_name,
        'product_code' => $product_code,
        'product_image' => $logo,
        'company_id' => $company_id,
        'supplier_id' => implode(',', $supplier_id),
        'category_id' => $category,
        'sub_category_id' => $subcategory,
        'brand_id' => $brand_id,
        'unit_id' => $unit_id,
        'description' => $description,
        'technical_details' => $technical_details,
        'quantityroll'=>$quantityroll,
        'hsn_code'=>$hsn_code,
        'thickness'=>$thickness,
        'roll_size'=>$roll_size,
        'updated_at' => now(),
    ]);

    // Update the pricing table
    $landing_cost = $request->basic_cost;
    $gst_rate = $request->gst_rate;
    $purchase_cost = $request->purchase_cost;
    $mrp_rate = $request->profit_margin;
    $mrp = $request->retail_price;
    $cutting_rate = $request->cutting_rate;
    $moq = $request->moq;
    $effective_date = $request->effective_date;

     $unitdata=DB::table('units')->where('id',$unit_id)->first();
       
        if($unitdata->unit_name == 'sqm'){
            //1 sqm = 10.76sqft
         $converted_price = $mrp*10.76;
        }
        else
        {
            $converted_price = $mrp;
        }
        

    DB::table('pricing')->where('product_id', $id)->update([
        'basic_cost' => $landing_cost,
        'gst_rate' => $gst_rate,
        'cgst_rate' => $cgst_rate,
        'sgst_rate' => $sgst_rate,
        'igst_rate' => $igst_rate,
        'retail_price' => $mrp,
        'converted_price' => $converted_price,
        'profit_margin' => $mrp_rate,
        'purchase_cost' => $purchase_cost,
        'moq' => $moq,
        'cutting_rate' => $cutting_rate,
        'effective_date' => $effective_date,
        'updated_at' => now(),
    ]);

    // Update warehouse-specific data
    if (!empty($warehousedata)) {
        // First, delete the warehouse records that are no longer in the request
        DB::table('warehouse_products')
            ->where('product_id', $id)
            ->whereNotIn('warehouse', $warehousedata)
            ->delete();

        // Now, handle adding/updating the warehouse data
        foreach ($warehousedata as $index => $warehouse) {
            // Check if the warehouse already exists for this product
            $existingWarehouse = DB::table('warehouse_products')
                ->where('product_id', $id)
                ->where('warehouse', $warehouse)
                ->first();

            if ($existingWarehouse) {
                // Update existing warehouse data
                DB::table('warehouse_products')
                    ->where('id', $existingWarehouse->id)
                    ->update([
                        'pack_margin' => $pack_margin[$index],
                        'cut_margin' => $cut_margin[$index],
                        'pack_amt' => $pack_amt[$index],
                         'cut_amt' => $cut_amt[$index], 
                        'updated_at' => now(),
                    ]);
            } else {
                // Insert new warehouse data
                DB::table('warehouse_products')->insert([
                    'product_id' => $id,
                    'warehouse' => $warehouse,
                    'pack_margin' => $pack_margin[$index],
                    'cut_margin' => $cut_margin[$index],
                    'pack_amt' => $pack_amt[$index],
                    'cut_amt' => $cut_amt[$index],
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }

    return redirect()->route('product_list')->with('success', 'Product updated successfully');
}


    public function add_product(){
        $title='Add New Product';
        $category=DB::table('categories')->where('deleted_at',null)->where('status',1)->get();
        $company=DB::table('companies')->where('deleted_at',null)->where('status',1)->get();
        $warehouses=DB::table('warehouses')->where('deleted_at',null)->where('status',1)->get();
        $subcategory=DB::table('sub_categories')->where('deleted_at',null)->where('status',1)->get();
        $brands=DB::table('brands')->where('deleted_at',null)->where('status',1)->get();
        $suppliers=DB::table('suppliers')->where('deleted_at',null)->where('status',1)->get();
        $units=DB::table('units')->where('deleted_at',null)->where('status',1)->get();
        
        $lastCompany = DB::table('products')->orderBy('product_code', 'desc')->where('deleted_at',null)->first();

    
        if ($lastCompany) {
            $lastIdNumber = (int) substr($lastCompany->product_code, 2);
            $newProductId = 'PR' . str_pad($lastIdNumber + 1, 6, '0', STR_PAD_LEFT);
        } else {
            $newProductId = 'PR000001';
        }
        
        
        return view('admin.add-product',compact('category','title','subcategory','brands','units','company','warehouses','suppliers','newProductId'));

    }

   
        public function getSubcategories($category_id)
        {
            
            $subcategories = DB::table('sub_categories')
                                ->where('category_id', $category_id)
                                ->whereNull('deleted_at')
                                ->where('status',1)
                                ->get();
                            
            return response()->json($subcategories);
        }

    

  public function store_product(Request $request){
   //dd($request->all());
        $company_id=$request->company_id;
        $supplier_id=$request->supplier_id;
        $warehousedata=$request->warehouse;
         $pack_margin=$request->pack_margin;
        $cut_margin=$request->cut_margin;
        $cut_amt=$request->cut_margin_amt;
        $pack_amt=$request->pack_margin_amt;
         $hsn_code=$request->hsn_code;
        $quantityroll=$request->quantityroll;
        $thickness = $request->thickness;
        $roll_size=$request->roll_size;
        $cgst_rate=$request->cgst_rate;
        $sgst_rate=$request->sgst_rate;
        $igst_rate=$request->igst_rate;

        if (!is_array($supplier_id)) {
            $supplier_id = [$supplier_id]; 
        }

        if (!is_array($warehousedata)) {
            $warehousedata = [$warehousedata]; 
        }

       if (!is_array($pack_margin)) {
            $pack_margin = [$pack_margin]; 
        }

        if (!is_array($cut_margin)) {
            $cut_margin = [$cut_margin]; 
        }
      
      
       if (!is_array($cut_amt)) {
            $cut_amt = [$cut_amt]; 
        }
        if (!is_array($pack_amt)) {
            $pack_amt = [$pack_amt]; 
        }

        $product_name=$request->product_name;
        $product_code=$request->product_code;
        $category=$request->category;
        $subcategory=$request->subcategory;
        $brand_id=$request->brand_id;
        $unit_id=$request->unit_id;
        $description=$request->description;
        $technical_details=$request->technical_details;

         if($request->hasfile('product_image')){
            $file = $request->file('product_image');
            $extension = $file->getClientOriginalExtension();
            $logo = rand(11111111,99999999).'.'.$extension;
            $image_path = public_path('uploads/products');
            $file->move($image_path,$logo);            
            }else{
                $logo = "Null";
            }

        
  
        $datas= DB::table('products')->insertGetId([
          'product_name'=>$product_name,
          'product_code'=>$product_code,
          'description'=>$description,
          'roll_size'=>$roll_size,
          'product_image'=>$logo,
          'company_id'=>$company_id,
          'supplier_id'=>implode(',',$supplier_id),
          'brand_id'=>$brand_id,
          'technical_details'=>$technical_details,
          'unit_id'=>$unit_id,
          'category_id'=>$category,
          'sub_category_id'=>$subcategory,
          'quantityroll'=>$quantityroll,
           'hsn_code'=>$hsn_code,
           'thickness'=>$thickness,
          'created_at' =>  date('Y-m-d H:i:s'),
          'updated_at' => date('Y-m-d H:i:s'),
      ]);

      $landing_cost=$request->basic_cost;
      $gst_rate=$request->gst_rate;
      $purchase_cost=$request->purchase_cost;
      $mrp_rate=$request->profit_margin;
      $mrp=$request->retail_price;
      $cutting_rate=$request->cutting_rate;
      $moq=$request->moq;
      $effective_date=$request->effective_date;

      $unitdata=DB::table('units')->where('id',$unit_id)->first();
          if($unitdata->unit_name == 'Sqm' ||  $unitdata->unit_name == 'Sqmt'  ||  $unitdata->unit_name == 'SQMT' ){
      
            //1 sqm = 10.76sqft
         $converted_price = $mrp*10.76;
        }
        else
        {
            $converted_price = $mrp;
        }
        
      DB::table('pricing')->insert([
        'product_id'=>$datas,
        'basic_cost'=>$landing_cost,
        'gst_rate'=>$gst_rate,
        'cgst_rate' => $cgst_rate,
        'sgst_rate' => $sgst_rate,
        'igst_rate' => $igst_rate,
        'retail_price'=>$mrp,
        'converted_price'=>$converted_price,
        'purchase_cost'=>$purchase_cost,
        'profit_margin'=>$mrp_rate,
        'moq'=>$moq,
        'cutting_rate'=>$cutting_rate,
        'effective_date'=>$effective_date,
        'created_at' =>  date('Y-m-d H:i:s'),
        'updated_at' => date('Y-m-d H:i:s'),
     ]);


     foreach($warehousedata as $index => $warehouse) {
        DB::table('warehouse_products')->insert([
            'product_id' => $datas, 
            'warehouse' => $warehouse,
            'pack_margin' => $pack_margin[$index],
            'cut_margin' => $cut_margin[$index], 
            'pack_amt' => $pack_amt[$index],
            'cut_amt' => $cut_amt[$index], 
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
     }
    
      return redirect()->route('product_list')->with('success','Product added successfully');
    }

    public function delete_product($id){
        DB::table('products')->where('id', $id)->update(['deleted_at' => date('Y-m-d H:i:s')]);
        return response()->json(['success' => 'Product deleted successfully']);
    }

    public function inactive_product($id){
        DB::table('products')->where('id', $id)->update([
            'status' => 0,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Product status changed successfully');
    }

    public function active_product($id){
        DB::table('products')->where('id', $id)->update([
            'status' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Product status changed successfully');
    }

    public function expired_products(){
        return view('admin.expired-products');
    }
    public function low_stocks(){
        return view('admin.low-stocks');
    }
    
    public function product_varient(){

        $title='Product Varient';
       /* $products_varient=DB::table('product_variant')
        ->leftJoin('products','products.id','=','product_variant.product_id')
        ->select('product_variant.*','products.id as product_id','products.product_name')
        ->where('product_variant.deleted_at',null)
        ->get();*/
        
       $products_varient=  DB::table('product_variant')
	    ->leftJoin('products', 'products.id', '=', 'product_variant.product_id')
	    ->leftJoin('brands', 'brands.id', '=', 'products.brand_id')  // Join brands table
	    ->leftJoin('categories', 'categories.id', '=', 'products.category_id')  // Join categories table
	    ->leftJoin('sub_categories', 'sub_categories.id', '=', 'products.sub_category_id')  // Join subcategories table
	    ->select(
		'product_variant.*',
		'products.id as product_id',
		'products.product_name',
		'brands.brand_name',              
		'categories.category_name',      
		'sub_categories.sub_category_name'   
	    )
	    ->whereNull('product_variant.deleted_at')
	    ->orderBy('product_variant.id','desc')
	    ->get();
	    
	    

        
        return view('admin.products_varient',compact('products_varient','title'));
    }

    public function add_product_varient(){
        $title='Add Product Varient';
        $products=DB::table('products')->where('deleted_at',null)->where('status',1)->get();
        $varients=DB::table('product_variant')->where('deleted_at',null)->get();

         $lastCompany = DB::table('product_variant')->orderBy('varient_code', 'desc')->where('deleted_at',null)->first();

    
        if ($lastCompany) {
            $lastIdNumber = (int) substr($lastCompany->varient_code, 2); // Get numeric part
            $newProductId = 'PV' . str_pad($lastIdNumber + 1, 6, '0', STR_PAD_LEFT); // Increment and format with leading zeros
        } else {
            $newProductId = 'PV000001';
        }
        
        
        return view('admin.add-product-varient',compact('products','newProductId','varients','title'));

    }

    public function edit_product_varient($id){
        $title='Edit Product Varient';
        $products=DB::table('products')->where('deleted_at',null)->where('status',1)->get();
        $product_varient=DB::table('product_variant')->where('id',$id)->first();
        $pricing=DB::table('pricing')->where('product_variant_id',$id)->first();
        $varient_images=DB::table('varient_images')->where('varient_id',$id)->where('deleted_at',null)->get();
        return view('admin.edit-product-varient',compact('products','title','product_varient','pricing','varient_images'));
    }

  public function store_product_varient(Request $request) {
        
        //$product_id = $request->product_id;
    
        
        foreach ($request->varient_name as $index => $varient_name) {
              $product_id = $request->product_id[$index];
            $varient_name = $request->varient_name[$index];
            $varient_code = $request->varient_code[$index];
           // $discount = $request->discount[$index];
           // $retail_price = $request->retail_price[$index];
           // $wholesale_price = $request->wholesale_price[$index];
            $imageName = null;
    
           
            if ($request->hasFile('varient_image') && isset($request->varient_image[$index])) {
                $file = $request->file('varient_image')[$index];
                $extension = $file->getClientOriginalExtension();
                $imageName = rand(11111111, 99999999) . '.' . $extension;
                $image_path = public_path('uploads/products');
                $file->move($image_path, $imageName);
            }
    
           
            $varid = DB::table('product_variant')->insertGetId([
                'product_id' => $product_id,
                'varient_name' => $varient_name,
                'varient_code' => $varient_code,
                'discount' => 0,
                'retail_price' => 0,
                'wholesale_price' => 0,
                'varient_image' => $imageName,
                'created_at' => now(), 
                'updated_at' => now(),
            ]);
           
         
            if ($request->hasFile('more_image_'.$index)) {
                
                
                foreach ($request->file('more_image_'.$index) as $file) {
                   
                    $extension = $file->getClientOriginalExtension();
                    $imageName = rand(11111111, 99999999) . '.' . $extension;
                    $image_path = public_path('uploads/products');
                    $file->move($image_path, $imageName);
    
                  
                    DB::table('varient_images')->insert([
                        'varient_id' => $varid, 
                        'image' => $imageName,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }
        }
    
        return redirect()->route('product_varient')->with('success', 'Product Variant added successfully');
    }

   public function update_product_varient(Request $request)
{
    $id = $request->id;
    $product_id = $request->product_id;
    $varient_name = $request->varient_name;
    $varient_code = $request->varient_code;

      $product = DB::table('product_variant')->where('id', $id)->first(); 
        
        
        if ($request->hasFile('single_image')) {
            $file = $request->file('single_image');
            $extension = $file->getClientOriginalExtension();
            $logo = rand(11111111, 99999999) . '.' . $extension;
            $image_path = public_path('uploads/products');
            $file->move($image_path, $logo);
        } else {
            $logo = $product->varient_image; 
        }
    

    // Update product variant details
    DB::table('product_variant')->where('id', $id)->update([
        'product_id' => $product_id,
        'varient_name' => $varient_name,
        'varient_code' => $varient_code,
        'varient_image' => $logo,
        'updated_at' => now(),
    ]);

    // Handle removed images
    if ($request->has('removed_images')) {
        $removedImages = explode(',', $request->removed_images);
        foreach ($removedImages as $imageId) {
            // Fetch image path
            $image = DB::table('varient_images')->where('id', $imageId)->first();
            if ($image) {
                // Delete the file from the server
                $imagePath = public_path('uploads/products/' . $image->image);
                if (file_exists($imagePath)) {
                    unlink($imagePath);
                }

                // Delete the record from the database
                DB::table('varient_images')->where('id', $imageId)->delete();
            }
        }
    }

    // Handle uploaded images
    if ($request->hasFile('varient_image')) {
        foreach ($request->file('varient_image') as $file) {
            $extension = $file->getClientOriginalExtension();
            $imageName = rand(11111111, 99999999) . '.' . $extension;
            $imagePath = public_path('uploads/products');
            $file->move($imagePath, $imageName);

            // Insert new image record
            DB::table('varient_images')->insert([
                'varient_id' => $id,
                'image' => $imageName,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }

    return redirect()->route('product_varient')->with('success', 'Product Variant updated successfully');
}

    public function inactive_product_varient($id){
        DB::table('product_variant')->where('id', $id)->update([
            'status' => 0,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Product Varient status changed successfully');
    }

    public function active_product_varient($id){
        DB::table('product_variant')->where('id', $id)->update([
            'status' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->back()->with('success', 'Product Varient status changed successfully');
    }

    public function delete_product_varient($id){
        DB::table('product_variant')->where('id', $id)->update(['deleted_at' => date('Y-m-d H:i:s')]);
        return response()->json(['success' => 'Product Varient deleted successfully']);
    }
    
    public function checkProductCode(Request $request)
    {
        $productCode = $request->input('product_code');
        $exists = DB::table('products')->where('product_code', $productCode)->exists();
        return response()->json(['exists' => $exists]);
    }
    
    public function view_product_details($id)
    {
        $title='View Product Detail';
        $product=DB::table('products')
        ->leftJoin('brands','brands.id','=','products.brand_id')
        ->leftJoin('units','units.id','=','products.unit_id')
        ->leftJoin('companies','companies.id','=','products.company_id')
        ->leftJoin('warehouses','warehouses.id','=','products.warehouse_id')
        ->leftJoin('categories','categories.id','=','products.category_id')
        ->leftJoin('suppliers','suppliers.id','=','products.supplier_id')
        ->leftJoin('sub_categories','sub_categories.id','=','products.sub_category_id')
        ->select('products.*','brands.brand_name','units.unit_name','units.id as unitid','brands.id as brandid','categories.id as categoryid','sub_categories.id as subcategory_id','warehouses.id as warehouseid','companies.id as companyid','categories.category_name','sub_categories.sub_category_name','warehouses.warehouse_name','companies.company_name','suppliers.supplier_name')
        ->where('products.id',$id)
        ->first();
        $images=DB::table('product_images')->where('product_id',$id)->where('deleted_at',null)->get();

        $varients=DB::table('product_variant')->where('product_id',$id)->where('deleted_at',null)->get();
        
         $pricing=DB::table('pricing')->where('product_id',$id)->first();
         
        $varient_code=DB::table('product_variant')->orderBy('varient_code','desc')->first();
        $warehouses=DB::table('warehouses')->where('deleted_at',null)->get();
      return view('admin.view_product_details',compact('product','warehouses','title','varients','varient_code','images','pricing'));
    }
    
       public function getImages($id)
    {
        $images = DB::table('varient_images')
                    ->where('varient_id', $id)
                    ->whereNull('deleted_at')
                    ->get();
        
        return response()->json(['images' => $images]);
    }
    
    
    
  
    
  


    
    
    public function getVariantDetails(Request $request)
{
     $variantId = $request->id;
  
     $variant = DB::table('product_variant')
     ->join('products', 'product_variant.product_id', '=', 'products.id') 
     ->join('suppliers', 'suppliers.id', '=', 'products.supplier_id') 
     ->join('pricing', 'pricing.product_id', '=', 'product_variant.product_id') 
     ->select(
      'product_variant.id as varient_id',
      'product_variant.product_id',
      'product_variant.varient_name',
      'product_variant.varient_code',
      'pricing.basic_cost',
       'pricing.retail_price',
      'pricing.gst_rate',
      'products.quantityroll',
      'products.unit_id',
      'products.hsn_code',
      'suppliers.top',
      DB::raw('ROUND((pricing.retail_price / NULLIF(products.quantityroll, 0)), 2) as persqftprice')
     )
     ->where('product_variant.id', $variantId)
     ->first();

      //dd($variant);


     if ($variant) {
        return response()->json([
            'rate' => $variant->basic_cost,
            'quantity' => $variant->quantityroll,
            'uom_id' => $variant->unit_id, 
            'gst_rate' => $variant->gst_rate, 
            'new_rate'=>$variant->persqftprice,
            'hsn_code'=>$variant->hsn_code,
            'top'=>$variant->top,
        ]);
     }

    return response()->json(['error' => 'Variant not found'], 404);
}

 public function getVariantDetailsorder(Request $request)
{
    $variantId = $request->id;
    $variant = DB::table('product_variant')
    ->join('products', 'product_variant.product_id', '=', 'products.id') 
    ->join('pricing', 'pricing.product_id', '=', 'product_variant.product_id') 
      ->join('units', 'products.unit_id', '=', 'units.id') 
    ->join('rolls','rolls.varient_id','=','product_variant.id')
    ->select(
        'product_variant.id as varient_id',
        'product_variant.product_id',
        'product_variant.varient_name',
        'product_variant.varient_code',
        'pricing.basic_cost',
        'pricing.retail_price',
        'pricing.gst_rate',
        'products.quantityroll',
        'products.unit_id',
         'units.unit_name',
        DB::raw('pricing.retail_price as persqftprice'),
        DB::raw('SUM(rolls.availability) as total_availability')
    )
    ->where('product_variant.id', $variantId)
    ->groupBy(
        'product_variant.id',
        'product_variant.product_id',
        'product_variant.varient_name',
        'product_variant.varient_code',
        'pricing.basic_cost',
        'pricing.retail_price',
        'pricing.gst_rate',
        'products.quantityroll',
        'products.unit_id',
         'units.unit_name',
    )
    ->first();

  /*$variant = DB::table('product_variant')
  ->join('products', 'product_variant.product_id', '=', 'products.id') 
  ->join('pricing', 'pricing.product_id', '=', 'product_variant.product_id') 
  ->select(
      'product_variant.id as varient_id',
      'product_variant.product_id',
      'product_variant.varient_name',
      'product_variant.varient_code',
      'pricing.basic_cost',
       'pricing.retail_price',
      'pricing.gst_rate',
      'products.quantityroll',
      'products.unit_id',
       DB::raw('ROUND((pricing.retail_price / NULLIF(products.quantityroll, 0)), 2) as persqftprice')
  )
  ->where('product_variant.id', $variantId)
  ->first();*/

 //dd($variant);


    if ($variant) {
        return response()->json([
            'rate_old' => $variant->retail_price,
            'quantity' => $variant->quantityroll,
            'uom_id' => $variant->unit_id, 
            'gst_rate' => $variant->gst_rate,
            'rate'=>$variant->persqftprice, 
            'availability'=>$variant->total_availability,
        ]);
    }

    return response()->json(['error' => 'Variant not found'], 404);
}


public function getVariantsBySupplier(Request $request)
    {
        $supplierId = $request->supplier_id;

        // Fetch variants related to the supplier
         $variants = DB::table('product_variant')
            ->join('products', 'product_variant.product_id', '=', 'products.id')
            //->where('products.supplier_id', $supplierId)
             ->whereRaw("FIND_IN_SET(?, products.supplier_id)", [$supplierId])
             ->where('product_variant.deleted_at',null)
            ->select('product_variant.id','product_variant.varient_name','product_variant.varient_code')
            ->get();


        return response()->json($variants);
    }
    
    
    public function assign_transporter(Request $request){
        //dd($request->all());
        $id=$request->id;
        $transporter=$request->transporter;

        $dbs=DB::table('orders')->where('id',$id)->update([
            'transporter_id'=>$transporter,
            'status'=>'Shipped'
        ]);
        $datas=DB::table('orders')->where('id',$id)->first();
        $transporter_data =DB::table('transporters')->where('id',$datas->transporter_id)->first();
        
        return response()->json([
            'success' => true,
            'status' => 'Shipped',
            'transporter_data'=>$transporter_data,
            'message' => 'Transporter assigned successfully' 
        ]);
       
    }
    
public function convertUnit(Request $request)
            {
                $unitId = $request->id;
                $rate = $request->rate;
                $quantity = $request->quantity;
                $no_of_rolls=$request->no_of_rolls;
                $units = DB::table('units')->where('id', $unitId)->first();

                if ($units->unit_name=='Sqft' || $units->unit_name=='sqft' || $units->unit_name=='SQFT' ) {
                    // Currently in sqm -> convert to sqft
                    $newRate = $rate / 10.764;
                    $newQty = $quantity * 10.764;
                } 
                elseif ($units->unit_name=='Sqm' || $units->unit_name=='sqmt' || $units->unit_name=='SQMT') {
                    // Currently in sqft -> convert to sqm
                    $newRate = $rate * 10.764;
                    $newQty = $quantity / 10.764;
                }elseif ($units->unit_name=='Nos') {
                  
                    $newRate = $rate * $no_of_rolls ;
                    $newQty =$no_of_rolls;
                   
                }

                return response()->json([
                    'rate'      => round($newRate, 2),
                    'quantity'  => round($newQty, 2),
                    'uom_id'    => $unitId,
                    'unit_name' => $units->unit_name,
                    'no_of_roll'=>$no_of_rolls
                ]);
            }


    
         public function convertunit_inward(Request $request){
           //dd($request->all());
            $unitid=$request->id;
            $rate = $request->rate;
            $quantity = $request->quantity;
            $rolls=$request->rolls;
            $units=DB::table('units')->where('id',$unitid)->first();
            
            $newrate = $rate;
            $newQty = $quantity;

        

                if ($units->unit_name=='Sqft' || $units->unit_name=='sqft' || $units->unit_name=='SQFT' ) {
                // Currently in sqm -> convert to sqft
                $newRate = $rate / 10.764;
                $newQty = $quantity * 10.764;
                } 
                elseif ($units->unit_name=='Sqm' || $units->unit_name=='sqmt' || $units->unit_name=='SQMT') {
                    // Currently in sqft -> convert to sqm
                    $newRate = $rate * 10.764;
                    $newQty = $quantity / 10.764;
                }elseif ($units->unit_name=='Nos') {
                   
                    $newRate = $rate * $no_of_rolls ;
                    $newQty =$no_of_rolls;
                   
                }
            

            // dd($newrate);
            
            
            // dd($newqty);
            return response()->json([
                'rate' =>round($newRate, 2),
                'quantity' => round($newQty, 2),
                'uom_id' => $unitid, 
                'unit_name'=>$units->unit_name,
                'no_of_roll'=>$rolls
                
            ]);
            return response()->json(['error' => 'error'], 404);



        }
        
        
         public function getProductsByCompany(Request $request)
    {
        $company_id = $request->companyid;

        $products = DB::table('products')
            ->where('company_id', $company_id)
            ->whereNull('deleted_at')
            ->select('id as product_id', 'product_name')
            ->get();

        return response()->json($products);
    }
    

    
       public function getVariantsByCompany(Request $request)
    {
        $company_id = $request->companyid;

        // Fetch variants related to the supplier
         $variants = DB::table('product_variant')
            ->join('products', 'product_variant.product_id', '=', 'products.id')
            ->where('products.company_id', $company_id)
            ->where('product_variant.deleted_at',null)
            ->select('product_variant.id','product_variant.varient_name','product_variant.varient_code')
            ->get();
        //dd($variants);

        return response()->json($variants);
    }

    
    
    public function update_order_installer(Request $request)
    {
        try {
            $order_id = $request->order_ins_id;
            $installer_id = $request->installer_id;
    
            $updated = DB::table('order_roll_mapping')
                ->where('order_id', $order_id)
                ->update(['installer_id' => $installer_id,
                  'installer_status'=>'Measurement']);

                $updated = DB::table('orders')
                ->where('id', $order_id)
                ->update(['status' => 'Measurement',
                           'installer_id' =>$installer_id]);
                           
                            $exists = DB::table('track_orders')
                ->where('order_id', $order_id)
                ->where('status', 'Measurement')
                ->exists();
                
                if (!$exists) {
			   DB::table('track_orders')->insert([
				'order_id' => $order_id,
				'status' => 'Measurement',
				'message'=>'Your order has been taken for measurement',
				'created_at' => now()
				
			    ]);
			}
			
    
            if ($updated) {
                return response()->json([
                    'success' => true,
                    'message' => 'Installer assigned successfully!',
                ], 200);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => 'No records updated, check if order_id exists.',
                ], 400);
            }
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Something went wrong: ' . $e->getMessage(),
            ], 500);
        }
    }
    
    
   
    
    
    
     
   



   
    




    
    
    public function get_customerdetails(Request $request)
   {
    
          $customerid = $request->customerid;
  
	  $customer = DB::table('customers')
	  ->where('id', $customerid)
	  ->where('customer_type','Wholesale')
	  ->first();

	    if ($customer) {
		return response()->json([
		    'customer_discount' => $customer->customer_discount,
		    'customer_type' => $customer->customer_type,
		    'id' => $customer->id, 
		    'customer_name' => $customer->customer_name, 
		   
		]);
	    }

    return response()->json(['error' => 'Customer not found'], 404);
   }
   
   
   public function getVariantsByProduct(Request $request)
    {
            $productId = $request->product_id;
            
            $variants = DB::table('product_variant')
            ->join('products', 'product_variant.product_id', '=', 'products.id')
            ->join('rolls','product_variant.id','=','rolls.varient_id')
            ->where('product_variant.product_id',$productId)
            ->where('rolls.defective_status',0)
            ->where('product_variant.deleted_at',null)
            ->groupBy('product_variant.id','product_variant.varient_name','product_variant.varient_code','rolls.varient_id')
            ->select('product_variant.id','product_variant.varient_name','product_variant.varient_code','rolls.varient_id')
            ->get();

             //dd($variants);

        return response()->json($variants);
    }
    

    
    
   
}
