<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Models\User;
use App\Models\Order;
use App\Models\Customer;
use DB;
use Carbon\Carbon;

class ReportController extends Controller
{
    public function billNotUpdated(){

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes
        
        $order_receipts = DB::table('order_receipt')
                            ->leftJoin('orders', 'orders.id', '=', 'order_receipt.order_id')
                            ->leftJoin('order_transaction', 'order_transaction.order_receipt_id', '=', 'order_receipt.id')
                            ->leftJoin('customers','customers.id', '=', 'order_receipt.customer_name')
                            ->leftJoin('banks','banks.id', '=', 'order_transaction.bank_name')
                            ->orderBy('order_receipt.id', 'desc')
                            ->get();
                            
        // Fetch Kukreja Interiors company details
        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
            ->first();

       return view('reportstemplate.billnotupdated', [
        'order_receipts' => $order_receipts,
        'company' => $company,
        'is_pdf' => false // Not a PDF
        ]);
    }

    public function billNotUpdatedpdf(){

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes
        
        $order_receipts = DB::table('order_receipt')
                            ->leftJoin('orders', 'orders.id', '=', 'order_receipt.order_id')
                            ->leftJoin('order_transaction', 'order_transaction.order_receipt_id', '=', 'order_receipt.id')
                            ->leftJoin('customers','customers.id', '=', 'order_receipt.customer_name')
                            ->leftJoin('banks','banks.id', '=', 'order_transaction.bank_name')
                            ->orderBy('order_receipt.id', 'desc')
                            ->get();
                            
        // Fetch Kukreja Interiors company details
        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
            ->first();

         $pdf = PDF::loadView('reportstemplate.billnotupdated', [
                'order_receipts' => $order_receipts,
                'company' => $company,
                'is_pdf' => true // Pass flag
            ]);

        return $pdf->download('bill_report.pdf'); 
    }

    public function creditReport() {

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        // Fetch all orders with customer details
        $order_data_raw = DB::table('orders')
            ->join('customers', 'orders.customer_id', '=', 'customers.id')
            ->select(
                'orders.*',
                'customers.customer_name',
                'customers.mobile'
            )
            ->orderBy('customers.customer_name')
            ->get();

        // Group orders by customer name
        $order_data = [];

        foreach ($order_data_raw as $order) {
            $order_data[$order->customer_name][] = $order;
        }
        
        // Fetch Kukreja Interiors company details
        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state', 'phone1', 'gst_no')
            ->first();

      
        return view('reportstemplate.creditreport', [
            'order_data' => $order_data,
            'company' => $company,
            'is_pdf' => false // Not a PDF
            ]);

    }

     public function creditReportpdf() {

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        // Fetch all orders with customer details
        $order_data_raw = DB::table('orders')
            ->join('customers', 'orders.customer_id', '=', 'customers.id')
            ->select(
                'orders.*',
                'customers.customer_name',
                'customers.mobile'
            )
            ->orderBy('customers.customer_name')
            ->get();

        // Group orders by customer name
        $order_data = [];

        foreach ($order_data_raw as $order) {
            $order_data[$order->customer_name][] = $order;
        }
        
        // Fetch Kukreja Interiors company details
        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state', 'phone1', 'gst_no')
            ->first();

         $pdf = PDF::loadView('reportstemplate.creditreport', [
        'order_data' => $order_data,
        'company' => $company,
        'is_pdf' => true
       ]);

        return $pdf->download('credit_report.pdf');
    }

    public function customerReceiptDetails(){

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        $receipts = DB::table('order_receipt')
            ->leftJoin('order_transaction', 'order_transaction.order_receipt_id', '=', 'order_receipt.id')
            ->leftJoin('customers', 'customers.id', '=', 'order_receipt.customer_name')
            ->leftJoin('orders', 'order_receipt.order_id', '=', 'orders.id')
            ->leftJoin('banks', 'banks.id', '=', 'order_transaction.bank_name')
            ->select('order_receipt.*','orders.order_code', 'banks.bank_name as bank_name', 'order_transaction.cheque_number','customers.customer_name')
            ->orderBy('order_receipt.created_at', 'desc') 
            ->get();

        // Group first by date, then by customer name
        $groupedReceipts = $receipts->groupBy(function ($receipt) {
            return Carbon::parse($receipt->created_at)->format('Y-m-d'); // Group by date
        })->map(function ($dateGroup) {
            return $dateGroup->groupBy('customer_name'); // Group each date group by customer
        });

        // dd($groupedReceipts);

        
          return view('reportstemplate.customerreceiptdetails', [
            'groupedReceipts' => $groupedReceipts,
            'is_pdf' => false 
            ]);

    }

     public function customerReceiptDetailspdf(){

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        $receipts = DB::table('order_receipt')
            ->leftJoin('order_transaction', 'order_transaction.order_receipt_id', '=', 'order_receipt.id')
            ->leftJoin('customers', 'customers.id', '=', 'order_receipt.customer_name')
            ->leftJoin('orders', 'order_receipt.order_id', '=', 'orders.id')
            ->leftJoin('banks', 'banks.id', '=', 'order_transaction.bank_name')
            ->select('order_receipt.*', 'orders.order_code','banks.bank_name as bank_name', 'order_transaction.cheque_number','customers.customer_name')
            ->orderBy('order_receipt.created_at', 'desc') 
            ->get();

        // Group first by date, then by customer name
        $groupedReceipts = $receipts->groupBy(function ($receipt) {
            return Carbon::parse($receipt->created_at)->format('Y-m-d'); // Group by date
        })->map(function ($dateGroup) {
            return $dateGroup->groupBy('customer_name'); // Group each date group by customer
        });

        // dd($groupedReceipts);

        

         $pdf = PDF::loadView('reportstemplate.customerreceiptdetails', [
        'groupedReceipts' => $groupedReceipts,
        'is_pdf' => true // Pass flag
       ])->setPaper('a3', 'portrait');

        $filename = 'customer_receipt_' . Carbon::now()->format('d_M_Y') . '.pdf';
        return $pdf->download($filename);   

    }

    public function daySales(){

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        $order_receipts = DB::table('order_receipt')
        ->leftJoin('order_transaction', 'order_transaction.order_receipt_id', '=', 'order_receipt.id')
          ->leftJoin('orders', 'order_receipt.order_id', '=', 'orders.id')
        ->leftJoin('customers', 'customers.id', '=', 'order_receipt.customer_name')
            ->select(
                'order_receipt.*',
                 'orders.order_code',
                'order_transaction.bank_name',
                'order_transaction.amount_paid',
                'order_transaction.cheque_number',
                'customers.customer_name'
            )
            ->whereDate('order_receipt.created_at', today()) 
            ->orderBy('payment_method') 
            ->orderBy('customers.customer_name') 
            ->orderBy('order_receipt.order_id') 
            ->get();
        // dd($order_receipts);
        $grouped_data = [];

        foreach ($order_receipts as $receipt) {
            $payment_method = $receipt->payment_method;
            $customer = $receipt->customer_name;

            if (!isset($grouped_data[$payment_method])) {
                $grouped_data[$payment_method] = [];
            }

            if (!isset($grouped_data[$payment_method][$customer])) {
                $grouped_data[$payment_method][$customer] = [
                    'total_amount' => 0,
                    'orders' => []
                ];
            }

            $grouped_data[$payment_method][$customer]['orders'][] = [
                'order_id' => $receipt->order_code,
                'amount' => number_format($receipt->amount_paid, 2),
                'receipt_id' => $receipt->receipt_id,
                'bank' => $receipt->bank_name,
                'remark' => $receipt->remark,
                'cheq_no' => $receipt->cheque_number,
                'rcpt_type' => $receipt->receipt_type
            ];

            $grouped_data[$payment_method][$customer]['total_amount'] += $receipt->amount_paid;
        }

        // 3. Fetch Kukreja Interiors company details
        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
            ->first();

        return view('reportstemplate.daysales', [
            'grouped_data' => $grouped_data,
            'company'=>$company,
            'is_pdf' => false // Not a PDF
            ]);

    }

    public function daySalespdf(){

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        $order_receipts = DB::table('order_receipt')
        ->leftJoin('order_transaction', 'order_transaction.order_receipt_id', '=', 'order_receipt.id')
          ->leftJoin('orders', 'order_receipt.order_id', '=', 'orders.id')
        ->leftJoin('customers', 'customers.id', '=', 'order_receipt.customer_name')
            ->select(
                'order_receipt.*',
                 'orders.order_code',
                'order_transaction.bank_name',
                'order_transaction.amount_paid',
                'order_transaction.cheque_number',
                'customers.customer_name'
            )
            ->whereDate('order_receipt.created_at', today()) 
            ->orderBy('payment_method') 
            ->orderBy('customers.customer_name') 
            ->orderBy('order_receipt.order_id') 
            ->get();
        // dd($order_receipts);
        $grouped_data = [];

        foreach ($order_receipts as $receipt) {
            $payment_method = $receipt->payment_method;
            $customer = $receipt->customer_name;

            if (!isset($grouped_data[$payment_method])) {
                $grouped_data[$payment_method] = [];
            }

            if (!isset($grouped_data[$payment_method][$customer])) {
                $grouped_data[$payment_method][$customer] = [
                    'total_amount' => 0,
                    'orders' => []
                ];
            }

            $grouped_data[$payment_method][$customer]['orders'][] = [
                'order_id' => $receipt->order_code,
                'amount' => number_format($receipt->amount_paid, 2),
                'receipt_id' => $receipt->receipt_id,
                'bank' => $receipt->bank_name,
                'remark' => $receipt->remark,
                'cheq_no' => $receipt->cheque_number,
                'rcpt_type' => $receipt->receipt_type
            ];

            $grouped_data[$payment_method][$customer]['total_amount'] += $receipt->amount_paid;
        }

        // 3. Fetch Kukreja Interiors company details
        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
            ->first();

        $pdf = PDF::loadView('reportstemplate.daysales', [
        'grouped_data' => $grouped_data,
        'company' => $company,
            'is_pdf' => true 
        ]);
        return $pdf->download('day_sales.pdf'); 
    }

    public function invSales(){

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes


        // Get all necessary order item data, joined with related tables
        $orderItems = DB::table('order_items')
            ->join('orders', 'orders.id', '=', 'order_items.order_id')
            ->join('order_receipt', 'order_receipt.order_id', '=', 'orders.id')
            ->join('customers', 'customers.id', '=', 'orders.customer_id')
            ->join('products', 'products.id', '=', 'order_items.product_id')
            ->join('pricing', 'pricing.product_id', '=', 'products.id')
            ->select(
                'order_receipt.order_date as invoice_date',
                'orders.id as invoice_id',
                'customers.customer_name as customer_name',
                'customers.gst_number',
                'pricing.gst_rate',
               // 'pricing.basic_cost as base_amount',
                'orders.subtotal as base_amount',
                'products.hsn_code'
            )
            ->get();


            // Step 2: Add calculated tax amounts
            foreach ($orderItems as $item) {
                $gstRate = $item->gst_rate;
                $base = $item->base_amount;

                // Calculate SGST and CGST as 50% of GST each (intra-state)
                $item->sgst_amount = round(($base * $gstRate) / 2 / 100, 2);
                $item->cgst_amount = round(($base * $gstRate) / 2 / 100, 2);
                $item->igst_amount = 0; // Update if IGST logic is needed
            }

            // Step 3: Group by GST rate
            $groupedData = [];
            foreach ($orderItems as $item) {
                $gstRate = $item->gst_rate;

                if (!isset($groupedData[$gstRate])) {
                    $groupedData[$gstRate] = [
                        'percentage' => $gstRate,
                        'sales_items' => []
                    ];
                }

                $groupedData[$gstRate]['sales_items'][] = $item;
            }

            // 3. Fetch Kukreja Interiors company details
            $company = DB::table('companies')
                ->where('company_name', 'Kukreja Interiors')
                ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
                ->first();

            $salesdata = array_values($groupedData); // Reset array keys
            $gst_summary = [];


       return view('reportstemplate.invsales', [
            'salesdata' => $salesdata,
            'gst_summary' => $gst_summary,
            'company'=>$company,
            'is_pdf' => false 
            ]); 
    }

    public function invSalespdf(){

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes


        // Get all necessary order item data, joined with related tables
        $orderItems = DB::table('order_items')
            ->join('orders', 'orders.id', '=', 'order_items.order_id')
            ->join('order_receipt', 'order_receipt.order_id', '=', 'orders.id')
            ->join('customers', 'customers.id', '=', 'orders.customer_id')
            ->join('products', 'products.id', '=', 'order_items.product_id')
            ->join('pricing', 'pricing.product_id', '=', 'products.id')
            ->select(
                'order_receipt.order_date as invoice_date',
                'orders.id as invoice_id',
                'customers.customer_name as customer_name',
                'customers.gst_number',
                'pricing.gst_rate',
               // 'pricing.basic_cost as base_amount',
                'orders.subtotal as base_amount',
                'products.hsn_code'
            )
            ->get();


            // Step 2: Add calculated tax amounts
            foreach ($orderItems as $item) {
                $gstRate = $item->gst_rate;
                $base = $item->base_amount;

                // Calculate SGST and CGST as 50% of GST each (intra-state)
                $item->sgst_amount = round(($base * $gstRate) / 2 / 100, 2);
                $item->cgst_amount = round(($base * $gstRate) / 2 / 100, 2);
                $item->igst_amount = 0; // Update if IGST logic is needed
            }

            // Step 3: Group by GST rate
            $groupedData = [];
            foreach ($orderItems as $item) {
                $gstRate = $item->gst_rate;

                if (!isset($groupedData[$gstRate])) {
                    $groupedData[$gstRate] = [
                        'percentage' => $gstRate,
                        'sales_items' => []
                    ];
                }

                $groupedData[$gstRate]['sales_items'][] = $item;
            }

            // 3. Fetch Kukreja Interiors company details
            $company = DB::table('companies')
                ->where('company_name', 'Kukreja Interiors')
                ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
                ->first();

            $salesdata = array_values($groupedData); // Reset array keys
            $gst_summary = [];


        $pdf = PDF::loadView('reportstemplate.invsales', [
        'salesdata' => $salesdata,
        'gst_summary' => $gst_summary,
        'company'=>$company,
            'is_pdf' => true 
        ]);
        return $pdf->download('inv_sales.pdf'); 
    }

    public function labourWorkdowns()
    {
        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
            ->first();

        $labourData = DB::table('order_items')
            ->join('orders', 'orders.id', '=', 'order_items.order_id')
            ->join('customers', 'customers.id', '=', 'orders.customer_id')
            // ->join('installers', 'installers.id', '=', 'orders.installer_id')
            // ->join('users', 'users.id', '=', 'installers.user_id')
            ->select(
                'order_items.order_id',
                'order_items.updated_at',
                'orders.order_code',
                'customers.customer_name',
                'order_items.quantity',
                'order_items.price',
                // 'installers.status',
                // 'users.full_name as labour_name'
            )
            ->get();
            // ->groupBy('labour_name');

        $workdowns = [
            [
                'labour' => 'All Work',
                'workdown_items' => $labourData
            ]
        ];  
      
         return view('reportstemplate.labourworkdowns', [
            'workdowns' => $workdowns,
            'company'=>$company,
            'is_pdf' => false 
            ]);
    }

      public function labourWorkdownspdf()
    {
        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
            ->first();

        $labourData = DB::table('order_items')
            ->join('orders', 'orders.id', '=', 'order_items.order_id')
            ->join('customers', 'customers.id', '=', 'orders.customer_id')
            // ->join('installers', 'installers.id', '=', 'orders.installer_id')
            // ->join('users', 'users.id', '=', 'installers.user_id')
            ->select(
                'order_items.order_id',
                'order_items.updated_at',
                'orders.order_code',
                'customers.customer_name',
                'order_items.quantity',
                'order_items.price',
                // 'installers.status',
                // 'users.full_name as labour_name'
            )
            ->get();
            // ->groupBy('labour_name');

        $workdowns = [
            [
                'labour' => 'All Work',
                'workdown_items' => $labourData
            ]
        ];  

         $pdf = PDF::loadView('reportstemplate.labourworkdowns', [
        'workdowns' => $workdowns,
        'company'=>$company,
            'is_pdf' => true 
        ]);

        return $pdf->download('labour_workdowns.pdf');
    }


    public function productSupplier()
    {
        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        // Get distinct suppliers from inventory
        $suppliers = DB::table('inventory')
            ->leftJoin('suppliers', 'suppliers.id', 'inventory.supplier_id')
            ->select('suppliers.id', 'suppliers.supplier_name')
            ->distinct('supplier_name')
            ->get();

        $product_items = [];

        foreach ($suppliers as $supplier) {
            // Get all inventory inwards for this supplier with warehouse name joined
            $inwards = DB::table('inventory')
                ->where('supplier_id', $supplier->id)
                ->leftJoin('warehouses', 'warehouses.id', '=', 'inventory.warehouse_id')
                ->select('inventory.*', 'warehouses.warehouse_name')
                ->get();

            foreach ($inwards as $inward) {
                // Get rolls for this inward along with product variant info
                $rolls = DB::table('rolls')
                    ->where('inward_id', $inward->id)
                    ->leftJoin('product_variant', 'product_variant.id', 'rolls.varient_id')
                      ->leftJoin('products', 'product_variant.product_id', 'products.id')
                    ->select(
                        'rolls.id',
                        'rolls.availability',
                        'products.product_name',
                        'product_variant.varient_code',
                        'product_variant.varient_name'
                    )
                    ->get();

                $product_items[] = [
                    'supplier_name' => $supplier->supplier_name,
                    'warehouse' => $inward->warehouse_name ?? '-',  // warehouse name from join
                    'rolls' => $rolls
                ];
            }
        }

        // Get company details
        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state', 'phone1', 'gst_no')
            ->first();
           

           return view('reportstemplate.productsuppliermapping', [
            'product_items' => $product_items,
            'company'=>$company,
            'is_pdf' => false 
            ]);
    }
    

    public function productSupplierpdf()
    {
        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        // Get distinct suppliers from inventory
        $suppliers = DB::table('inventory')
            ->leftJoin('suppliers', 'suppliers.id', 'inventory.supplier_id')
            ->select('suppliers.id', 'suppliers.supplier_name')
            ->distinct('supplier_name')
            ->get();

        $product_items = [];

        foreach ($suppliers as $supplier) {
            // Get all inventory inwards for this supplier with warehouse name joined
            $inwards = DB::table('inventory')
                ->where('supplier_id', $supplier->id)
                ->leftJoin('warehouses', 'warehouses.id', '=', 'inventory.warehouse_id')
                ->select('inventory.*', 'warehouses.warehouse_name')
                ->get();

            foreach ($inwards as $inward) {
                // Get rolls for this inward along with product variant info
                $rolls = DB::table('rolls')
                    ->where('inward_id', $inward->id)
                    ->leftJoin('product_variant', 'product_variant.id', 'rolls.varient_id')
                      ->leftJoin('products', 'product_variant.product_id', 'products.id')
                    ->select(
                        'rolls.id',
                        'rolls.availability',
                        'products.product_name',
                        'product_variant.varient_code',
                        'product_variant.varient_name'
                    )
                    ->get();

                $product_items[] = [
                    'supplier_name' => $supplier->supplier_name,
                    'warehouse' => $inward->warehouse_name ?? '-',  // warehouse name from join
                    'rolls' => $rolls
                ];
            }
        }

        // Get company details
        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state', 'phone1', 'gst_no')
            ->first();

         $pdf = PDF::loadView('reportstemplate.productsuppliermapping', [
            'product_items' => $product_items,
            'company'=>$company,
                'is_pdf' => true 
            ]);

        return $pdf->download('product_supplier.pdf');
    }



    public function reservedStocks(){

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        $orders = DB::table('orders')
            ->whereIn('orders.status', ['Ordered', 'Measurement'])
            ->get();

        $order_items = [];
        foreach ($orders as $order) {
            $order_data = DB::table('orders')
                ->where('orders.id', $order->id) // Specify table name for 'id'
                ->leftJoin('order_roll_mapping', 'order_roll_mapping.order_id', 'orders.id')
                ->leftJoin('customers', 'customers.id', 'orders.customer_id')
                ->leftJoin('order_items', 'order_items.id', 'order_roll_mapping.order_item_id')
                ->leftJoin('product_variant', 'product_variant.id', 'order_items.varient_id')
                ->select(
                    'orders.id',
                    'orders.status',
                    'orders.order_code',
                    'customers.customer_name',
                    'order_roll_mapping.roll_id',
                    'order_roll_mapping.total_quantity',
                    'order_roll_mapping.installer_status',
                    'product_variant.varient_name'
                )
                ->get();

            $order_items[] = [
                'order_id' => $order->order_code,
                'order_items' => $order_data
            ];
        }
        // dd($order_items);
        // return view('reportstemplate.reservedstocks',compact('order_items'));
         // 3. Fetch Kukreja Interiors company details
        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
            ->first();
        return view('reportstemplate.reservedstocks', [
            'order_items' => $order_items,
            'company'=>$company,
            'is_pdf' => false 
            ]);
    }

    public function reservedStockspdf(){

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        $orders = DB::table('orders')
            ->whereIn('orders.status', ['Ordered', 'Measurement'])
            ->get();

        $order_items = [];
        foreach ($orders as $order) {
            $order_data = DB::table('orders')
                ->where('orders.id', $order->id) // Specify table name for 'id'
                ->leftJoin('order_roll_mapping', 'order_roll_mapping.order_id', 'orders.id')
                ->leftJoin('customers', 'customers.id', 'orders.customer_id')
                ->leftJoin('order_items', 'order_items.id', 'order_roll_mapping.order_item_id')
                ->leftJoin('product_variant', 'product_variant.id', 'order_items.varient_id')
                ->select(
                    'orders.id',
                    'orders.status',
                    'customers.customer_name',
                    'order_roll_mapping.roll_id',
                    'order_roll_mapping.total_quantity',
                    'order_roll_mapping.installer_status',
                    'product_variant.varient_name'
                )
                ->get();

            $order_items[] = [
                'order_id' => $order->id,
                'order_items' => $order_data
            ];
        }
        // dd($order_items);
        // return view('reportstemplate.reservedstocks',compact('order_items'));
         // 3. Fetch Kukreja Interiors company details
        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
            ->first();
        $pdf = PDF::loadView('reportstemplate.reservedstocks', [
            'order_items' => $order_items,
            'company'=>$company,
                'is_pdf' => true 
            ]);
        return $pdf->download('reserved_stocks.pdf'); 
    }

    public function stockSupply(){

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        $products = DB::table('inventory')
        ->leftJoin('products', 'products.id', 'inventory.product_id')
        ->select('inventory.product_id', 'product_name')
        ->groupBy('inventory.product_id', 'products.product_name')
        ->get();
        // dd($products);
        $product_items = [];
        foreach($products as $product){
            $items = DB::table('inventory')
            ->where('inventory.product_id', $product->product_id)
            ->leftJoin('product_variant', 'product_variant.id', 'inventory.product_varient')
            ->leftJoin('pricing', 'product_variant.product_id', 'pricing.product_id')
            ->select('inventory.quantity', 'qunatity_on_hand', 'pricing.basic_cost', 'pricing.purchase_cost', 'product_variant.varient_code as varient_code', 'product_variant.varient_name  as varient_name')
            ->get();
            $product_items[] = [
                'product_name' => $product->product_name,
                'items' => $items
                
            ];
        }
        // dd($product_items);
        // return view('reportstemplate.stocksupply', compact('product_items'));
             $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
            ->first();
         return view('reportstemplate.stocksupply', [
            'product_items' => $product_items,
            'company'=>$company,
            'is_pdf' => false 
            ]);
    }

    public function stockSupplypdf(){

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        $products = DB::table('inventory')
        ->leftJoin('products', 'products.id', 'inventory.product_id')
        ->select('inventory.product_id', 'product_name')
        ->groupBy('inventory.product_id', 'products.product_name')
        ->get();
        // dd($products);
        $product_items = [];
        foreach($products as $product){
            $items = DB::table('inventory')
            ->where('inventory.product_id', $product->product_id)
            ->leftJoin('product_variant', 'product_variant.id', 'inventory.product_varient')
             ->leftJoin('pricing', 'product_variant.product_id', 'pricing.product_id')
            ->select('inventory.quantity', 'qunatity_on_hand', 'pricing.basic_cost', 'pricing.purchase_cost', 'product_variant.varient_code as varient_code', 'product_variant.varient_name  as varient_name')
            ->get();
            $product_items[] = [
                'product_name' => $product->product_name,
                'items' => $items
                
            ];
        }
        // dd($product_items);
        // return view('reportstemplate.stocksupply', compact('product_items'));

         // Fetch Kukreja Interiors company details
        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
            ->first();

         $pdf = PDF::loadView('reportstemplate.stocksupply', [
            'product_items' => $product_items,
            'company'=>$company,
                'is_pdf' => true 
            ]);
        return $pdf->download('stock_supply.pdf'); 
    }

    public function supplierStockReport()
    {
        // Increase limits for large data processing
        ini_set('memory_limit', '1024M'); // 1 GB
        set_time_limit(300);              // 5 minutes

        // Fetch inwards with related supplier, warehouse, and PO data
        $inwards = DB::table('inventory')
            ->leftJoin('suppliers', 'suppliers.id', 'inventory.supplier_id')
            ->leftJoin('warehouses', 'warehouses.id', 'inventory.warehouse_id')
            ->leftJoin('purchase_orders', 'purchase_orders.po_number', 'inventory.po_number')
            ->select(
                'inventory.id as inward_id',
                'supplier_name',
                'warehouse_name',
                'purchase_orders.grand_total'
            )
            ->get();

        $inward_items = [];
        foreach ($inwards as $inward) {
            $rolls = DB::table('rolls')
                ->where('inward_id', $inward->inward_id)
                ->leftJoin('product_variant', 'product_variant.id', 'rolls.varient_id')
                  ->leftJoin('products', 'product_variant.product_id', 'products.id')
                ->select(
                    'rolls.*',
                    'products.product_name',
                    'product_variant.varient_name',
                    'product_variant.varient_code'
                )
                ->get();

            $inward_items[] = [
                'inward_id' => $inward->inward_id,
                'supplier_name' => $inward->supplier_name,
                'warehouse' => $inward->warehouse_name,
                'grand_total' => $inward->grand_total,
                'items' => $rolls
            ];
        }

        // Company info for header
        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state', 'phone1', 'gst_no')
            ->first();
            
        return view('reportstemplate.supplierstockreport', [
            'inward_items' => $inward_items,
            'company'=>$company,
            'is_pdf' => false 
            ]);
    }

    public function supplierStockReportpdf()
    {
        // Increase limits for large data processing
        ini_set('memory_limit', '1024M'); // 1 GB
        set_time_limit(300);              // 5 minutes

        // Fetch inwards with related supplier, warehouse, and PO data
        $inwards = DB::table('inventory')
            ->leftJoin('suppliers', 'suppliers.id', 'inventory.supplier_id')
            ->leftJoin('warehouses', 'warehouses.id', 'inventory.warehouse_id')
            ->leftJoin('purchase_orders', 'purchase_orders.po_number', 'inventory.po_number')
            ->select(
                'inventory.id as inward_id',
                'supplier_name',
                'warehouse_name',
                'purchase_orders.grand_total'
            )
            ->get();

        $inward_items = [];
        foreach ($inwards as $inward) {
            $rolls = DB::table('rolls')
                ->where('inward_id', $inward->inward_id)
                ->leftJoin('product_variant', 'product_variant.id', 'rolls.varient_id')
                 ->leftJoin('products', 'product_variant.product_id', 'products.id')
                ->select(
                    'rolls.*',
                    'products.product_name',
                    'product_variant.varient_name',
                    'product_variant.varient_code'
                )
                ->get();

            $inward_items[] = [
                'inward_id' => $inward->inward_id,
                'supplier_name' => $inward->supplier_name,
                'warehouse' => $inward->warehouse_name,
                'grand_total' => $inward->grand_total,
                'items' => $rolls
            ];
        }

        // Company info for header
        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state', 'phone1', 'gst_no')
            ->first();
            
        $pdf = PDF::loadView('reportstemplate.supplierstockreport', [
            'inward_items' => $inward_items,
            'company'=>$company,
                'is_pdf' => true 
            ]);


        return $pdf->download('supplier_stock_report.pdf');
    }


    public function todaysCutting(){

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        $orders = DB::table('orders')
        ->whereDate('orders.updated_at', date('Y-m-d'))
        ->leftJoin('customers', 'customers.id', 'orders.customer_id')
        ->select('orders.id', 'customers.customer_name','orders.order_code')
        ->get();

        
        $order_receipts = [];
        foreach ($orders as $order) {
            
            $order_items = DB::table('order_items')
                    ->leftJoin('order_roll_mapping', 'order_roll_mapping.order_item_id', 'order_items.id')
                      ->leftJoin('orders','order_items.order_id','=','orders.id')
                    ->where('order_items.order_id', $order->id)
                    ->whereDate('order_items.updated_at', date('Y-m-d'))
                    ->where('order_roll_mapping.installer_status', 'Cutting Done')
                    ->get();

            if ($order_items->isNotEmpty()) {
                $order_receipts[] = (object) [
                    'id' => $order->order_code,
                    'customer_name' => $order->customer_name,
                    'order_items' => $order_items
                ];
            }
            
        }

        // dd($order_receipts);
        // return view('reportstemplate.todayscutting', compact('order_receipts'));

         // Fetch Kukreja Interiors company details
        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
            ->first();

          return view('reportstemplate.todayscutting', [
            'order_receipts' => $order_receipts,
            'company'=>$company,
            'is_pdf' => false 
            ]);
    }

      public function todaysCuttingpdf(){

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        $orders = DB::table('orders')
        ->whereDate('orders.updated_at', date('Y-m-d'))
        ->leftJoin('customers', 'customers.id', 'orders.customer_id')
        ->select('orders.id', 'customers.customer_name','orders.order_code')
        ->get();

        
        $order_receipts = [];
        foreach ($orders as $order) {
            
            $order_items = DB::table('order_items')
                    ->leftJoin('order_roll_mapping', 'order_roll_mapping.order_item_id', 'order_items.id')
                      ->leftJoin('orders','order_items.order_id','=','orders.id')
                    ->where('order_items.order_id', $order->id)
                    ->whereDate('order_items.updated_at', date('Y-m-d'))
                    ->where('order_roll_mapping.installer_status', 'Cutting Done')
                    ->get();

            if ($order_items->isNotEmpty()) {
                $order_receipts[] = (object) [
                    'id' => $order->order_code,
                    'customer_name' => $order->customer_name,
                    'order_items' => $order_items
                ];
            }
            
        }

        // dd($order_receipts);
        // return view('reportstemplate.todayscutting', compact('order_receipts'));

         // Fetch Kukreja Interiors company details
        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
            ->first();

       $pdf = PDF::loadView('reportstemplate.todayscutting', [
            'order_receipts' => $order_receipts,
            'company'=>$company,
                'is_pdf' => true 
            ]);

        return $pdf->download('todays_cutting.pdf'); 
    }

    public function todaysCash(){

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        $order_receipts = DB::table('order_receipt')
        ->leftJoin('order_transaction', 'order_transaction.order_receipt_id', '=', 'order_receipt.id')
         ->leftJoin('orders','order_receipt.order_id','=','orders.id')
        ->leftJoin('banks', 'banks.id', '=', 'order_transaction.bank_name')
        ->leftJoin('customers', 'customers.id', '=', 'order_receipt.customer_name')
            ->select(
                'order_receipt.*',
                'orders.order_code',
                'order_transaction.bank_name',
                'order_transaction.amount_paid',
                'order_transaction.cheque_number',
                'customers.customer_name',
                'banks.bank_name'
            )
            ->where('order_receipt.payment_method', 'Cash') 
            ->whereDate('order_receipt.created_at', today())
            ->orderBy('payment_method') // Order by Payment Method first
            ->orderBy('customers.customer_name') // Then order by Customer Name
            ->orderBy('order_receipt.order_id') // Order by Order No
            ->get();
        // dd($order_receipts);
        $grouped_data = [];

        foreach ($order_receipts as $receipt) {
            $payment_method = $receipt->payment_method;
            $customer = $receipt->customer_name;

            if (!isset($grouped_data[$payment_method])) {
                $grouped_data[$payment_method] = [];
            }

            if (!isset($grouped_data[$payment_method][$customer])) {
                $grouped_data[$payment_method][$customer] = [
                    'total_amount' => 0,
                    'orders' => []
                ];
            }

            $grouped_data[$payment_method][$customer]['orders'][] = [
                'order_id' => $receipt->order_code,
                'amount' => number_format($receipt->amount_paid, 2),
                'receipt_id' => $receipt->receipt_id,
                'bank' => $receipt->bank_name,
                'remark' => $receipt->remark,
                'cheq_no' => $receipt->cheque_number,
                'rcpt_type' => $receipt->receipt_type
            ];

            $grouped_data[$payment_method][$customer]['total_amount'] += $receipt->amount_paid;
        }

        // dd($grouped_data);
        // return view('reportstemplate.todayscash', compact('grouped_data'));
         // Fetch Kukreja Interiors company details
        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
            ->first();

        return view('reportstemplate.todayscash', [
            'grouped_data' => $grouped_data,
            'company'=>$company,
            'is_pdf' => false 
            ]);
    }

     public function todaysCashpdf(){

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        $order_receipts = DB::table('order_receipt')
        ->leftJoin('order_transaction', 'order_transaction.order_receipt_id', '=', 'order_receipt.id')
          ->leftJoin('orders','order_receipt.order_id','=','orders.id')
        ->leftJoin('banks', 'banks.id', '=', 'order_transaction.bank_name')
        ->leftJoin('customers', 'customers.id', '=', 'order_receipt.customer_name')
            ->select(
                'order_receipt.*',
                 'orders.order_code',
                'order_transaction.bank_name',
                'order_transaction.amount_paid',
                'order_transaction.cheque_number',
                'customers.customer_name',
                'banks.bank_name'
            )
            ->where('order_receipt.payment_method', 'Cash') 
            ->whereDate('order_receipt.created_at', today())
            ->orderBy('payment_method') // Order by Payment Method first
            ->orderBy('customers.customer_name') // Then order by Customer Name
            ->orderBy('order_receipt.order_id') // Order by Order No
            ->get();
        // dd($order_receipts);
        $grouped_data = [];

        foreach ($order_receipts as $receipt) {
            $payment_method = $receipt->payment_method;
            $customer = $receipt->customer_name;

            if (!isset($grouped_data[$payment_method])) {
                $grouped_data[$payment_method] = [];
            }

            if (!isset($grouped_data[$payment_method][$customer])) {
                $grouped_data[$payment_method][$customer] = [
                    'total_amount' => 0,
                    'orders' => []
                ];
            }

            $grouped_data[$payment_method][$customer]['orders'][] = [
                'order_id' => $receipt->order_code,
                'amount' => number_format($receipt->amount_paid, 2),
                'receipt_id' => $receipt->receipt_id,
                'bank' => $receipt->bank_name,
                'remark' => $receipt->remark,
                'cheq_no' => $receipt->cheque_number,
                'rcpt_type' => $receipt->receipt_type
            ];

            $grouped_data[$payment_method][$customer]['total_amount'] += $receipt->amount_paid;
        }

        // dd($grouped_data);
        // return view('reportstemplate.todayscash', compact('grouped_data'));
         // Fetch Kukreja Interiors company details
        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
            ->first();

       $pdf = PDF::loadView('reportstemplate.todayscash', [
            'grouped_data' => $grouped_data,
            'company'=>$company,
                'is_pdf' => true 
            ]);
        return $pdf->download('todays_cash.pdf'); 
    }

    public function todaysCollection(){

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        $order_receipts = DB::table('order_receipt')
        ->leftJoin('order_transaction', 'order_transaction.order_receipt_id', '=', 'order_receipt.id')
         ->leftJoin('orders', 'order_receipt.order_id', '=', 'orders.id')
        ->leftJoin('banks', 'banks.id', '=', 'order_transaction.bank_name')
        ->leftJoin('customers', 'customers.id', '=', 'order_receipt.customer_name')
            ->select(
                'order_receipt.*',
                 'orders.order_code',
                'order_transaction.bank_name',
                'order_transaction.amount_paid',
                'order_transaction.cheque_number',
                'customers.customer_name',
                'banks.bank_name'
            )
            // ->whereDate('created_at', today()) // Filter for today's date
            ->orderBy('payment_method') // Order by Payment Method first
            ->orderBy('customers.customer_name') // Then order by Customer Name
            ->orderBy('order_receipt.order_id') // Order by Order No
            ->get();
        // dd($order_receipts);
        $grouped_data = [];

        foreach ($order_receipts as $receipt) {
            $payment_method = $receipt->payment_method;
            $customer = $receipt->customer_name;

            if (!isset($grouped_data[$payment_method])) {
                $grouped_data[$payment_method] = [];
            }

            if (!isset($grouped_data[$payment_method][$customer])) {
                $grouped_data[$payment_method][$customer] = [
                    'total_amount' => 0,
                    'orders' => []
                ];
            }

            $grouped_data[$payment_method][$customer]['orders'][] = [
                'order_id' => $receipt->order_code,
                'amount' => number_format($receipt->amount_paid, 2),
                'receipt_id' => $receipt->receipt_id,
                'bank' => $receipt->bank_name,
                'remark' => $receipt->remark,
                'cheq_no' => $receipt->cheque_number,
                'rcpt_type' => $receipt->receipt_type
            ];

            $grouped_data[$payment_method][$customer]['total_amount'] += $receipt->amount_paid;
        }

        // dd($grouped_data);

         // Fetch Kukreja Interiors company details
        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
            ->first();

        return view('reportstemplate.todayscollections', [
            'grouped_data' => $grouped_data,
            'company'=>$company,
            'is_pdf' => false 
            ]);
    }


     public function todaysCollectionpdf(){

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        $order_receipts = DB::table('order_receipt')
        ->leftJoin('order_transaction', 'order_transaction.order_receipt_id', '=', 'order_receipt.id')
          ->leftJoin('orders', 'order_receipt.order_id', '=', 'orders.id')
        ->leftJoin('banks', 'banks.id', '=', 'order_transaction.bank_name')
        ->leftJoin('customers', 'customers.id', '=', 'order_receipt.customer_name')
            ->select(
                'order_receipt.*',
                  'orders.order_code',
                'order_transaction.bank_name',
                'order_transaction.amount_paid',
                'order_transaction.cheque_number',
                'customers.customer_name',
                'banks.bank_name'
            )
            // ->whereDate('created_at', today()) // Filter for today's date
            ->orderBy('payment_method') // Order by Payment Method first
            ->orderBy('customers.customer_name') // Then order by Customer Name
            ->orderBy('order_receipt.order_id') // Order by Order No
            ->get();
        // dd($order_receipts);
        $grouped_data = [];

        foreach ($order_receipts as $receipt) {
            $payment_method = $receipt->payment_method;
            $customer = $receipt->customer_name;

            if (!isset($grouped_data[$payment_method])) {
                $grouped_data[$payment_method] = [];
            }

            if (!isset($grouped_data[$payment_method][$customer])) {
                $grouped_data[$payment_method][$customer] = [
                    'total_amount' => 0,
                    'orders' => []
                ];
            }

            $grouped_data[$payment_method][$customer]['orders'][] = [
                'order_id' => $receipt->order_code,
                'amount' => number_format($receipt->amount_paid, 2),
                'receipt_id' => $receipt->receipt_id,
                'bank' => $receipt->bank_name,
                'remark' => $receipt->remark,
                'cheq_no' => $receipt->cheque_number,
                'rcpt_type' => $receipt->receipt_type
            ];

            $grouped_data[$payment_method][$customer]['total_amount'] += $receipt->amount_paid;
        }

        // dd($grouped_data);

         // Fetch Kukreja Interiors company details
        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
            ->first();

         $pdf = PDF::loadView('reportstemplate.todayscollections', [
            'grouped_data' => $grouped_data,
            'company'=>$company,
                'is_pdf' => true 
            ]);
        return $pdf->download('todays_collection.pdf'); 
    }

//   public function todaysInward(){

//         // Safely handle large data
//         ini_set('memory_limit', '1024M'); // Increase memory limit
//         set_time_limit(300);              // Increase max execution time to 5 minutes

//         $inward_company = DB::table('inventory')
//         ->whereDate('inward_date', '=', date('Y-m-d'))
//         ->leftJoin('companies', 'companies.id', '=', 'inventory.company_id')
//         ->select('inventory.company_id', 'companies.company_name')
//         ->groupBy('company_id', 'company_name')
//         ->get();

//         $inward_data = [];
        
//         foreach ($inward_company as $company) {
//             $inward_items = DB::table('inventory')
//                 ->whereDate('inward_date', '=', date('Y-m-d'))
//                 ->where('inventory.company_id', $company->company_id)
//                 ->leftJoin('purchase_orders', 'purchase_orders.id', '=', 'inventory.po_number')
//                 ->leftJoin('inward_invoice', 'inward_invoice.inward_id', '=', 'inventory.id')
//                 ->leftJoin('products', 'products.id', '=', 'inventory.product_id')
//                 ->leftJoin('warehouses', 'warehouses.id', '=', 'inventory.warehouse_id')
//                 ->select(
//                     'inventory.*',
//                     'inventory.supplier_id', // Needed for grouping
//                     'inward_invoice.invoice_id',
//                     'products.product_name',
//                     'purchase_orders.id as purchase_order_id',
//                     'warehouses.warehouse_name'
//                 )
//                 ->get();
                
//             // Grouping by company
//             if (!isset($inward_data[$company->company_name])) {
//                 $inward_data[$company->company_name] = [];
//             }
        
//             foreach ($inward_items as $item) {
//                 $supplier_id = $item->invoice_id;
//                 $purchase_order_id = $item->purchase_order_id;
        
//                 // Initialize supplier group if not set
//                 if (!isset($inward_data[$company->company_name][$supplier_id])) {
//                     $inward_data[$company->company_name][$supplier_id] = [
//                         'supplier_id' => $supplier_id,
//                         'warehouse' => $item->warehouse_name,
//                         'purchase_orders' => []
//                     ];
//                 }
        
//                 // Initialize purchase order group inside supplier
//                 if (!isset($inward_data[$company->company_name][$supplier_id]['purchase_orders'][$purchase_order_id])) {
//                     $inward_data[$company->company_name][$supplier_id]['purchase_orders'][$purchase_order_id] = [
//                         'purchase_order_id' => $purchase_order_id,
//                         'items' => []
//                     ];
//                 }
        
//                 // Fetch related purchase order items for the current inward item
//                 $purchase_order_items = DB::table('purchase_order_items')
//                     ->leftJoin('product_variant', 'product_variant.id', '=', 'purchase_order_items.varient_id')
//                     ->leftJoin('units', 'units.id', '=', 'purchase_order_items.uom')
//                     ->where('purchase_order_items.purchase_order_id', $purchase_order_id)
//                     ->select(
//                         'purchase_order_items.quantity',
//                         'purchase_order_items.no_of_rolls',
//                         'units.unit_name',
//                         'product_variant.varient_name',
//                         'purchase_order_items.gst_percent',
//                         'purchase_order_items.rate',
//                         'purchase_order_items.total',
//                         'purchase_order_items.no_of_rolls'
//                     )
//                     ->get();
                
//                 // Add item inside the purchase order group
//                 $inward_data[$company->company_name][$supplier_id]['purchase_orders'][$purchase_order_id]['items'][] = [
//                     'id' => $item->id,
//                     'invoice_id' => $item->invoice_id,
//                     'product_name' => $item->product_name,
//                     'purchase_order_items' => $purchase_order_items, // Nested array of items
//                 ];
//             }
//         }
        
//         // dd($inward_data);
//          // Fetch Kukreja Interiors company details
//         $company = DB::table('companies')
//             ->where('company_name', 'Kukreja Interiors')
//             ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
//             ->first();

//          return view('reportstemplate.todaysInward', [
//             'inward_data' => $inward_data,
//             'company'=>$company,
//             'is_pdf' => false 
//             ]);
// }

// public function todaysInwardpdf(){

//         // Safely handle large data
//         ini_set('memory_limit', '1024M'); // Increase memory limit
//         set_time_limit(300);              // Increase max execution time to 5 minutes

//         $inward_company = DB::table('inventory')
//         ->whereDate('inward_date', '=', date('Y-m-d'))
//         ->leftJoin('companies', 'companies.id', '=', 'inventory.company_id')
//         ->select('inventory.company_id', 'companies.company_name')
//         ->groupBy('company_id', 'company_name')
//         ->get();

//         $inward_data = [];
        
//         foreach ($inward_company as $company) {
//             $inward_items = DB::table('inventory')
//                 ->whereDate('inward_date', '=', date('Y-m-d'))
//                 ->where('inventory.company_id', $company->company_id)
//                 ->leftJoin('purchase_orders', 'purchase_orders.id', '=', 'inventory.po_number')
//                 ->leftJoin('inward_invoice', 'inward_invoice.inward_id', '=', 'inventory.id')
//                 ->leftJoin('products', 'products.id', '=', 'inventory.product_id')
//                 ->leftJoin('warehouses', 'warehouses.id', '=', 'inventory.warehouse_id')
//                 ->select(
//                     'inventory.*',
//                     'inventory.supplier_id', // Needed for grouping
//                     'inward_invoice.invoice_id',
//                     'products.product_name',
//                     'purchase_orders.id as purchase_order_id',
//                     'warehouses.warehouse_name'
//                 )
//                 ->get();
                
//             // Grouping by company
//             if (!isset($inward_data[$company->company_name])) {
//                 $inward_data[$company->company_name] = [];
//             }
        
//             foreach ($inward_items as $item) {
//                 $supplier_id = $item->invoice_id;
//                 $purchase_order_id = $item->purchase_order_id;
        
//                 // Initialize supplier group if not set
//                 if (!isset($inward_data[$company->company_name][$supplier_id])) {
//                     $inward_data[$company->company_name][$supplier_id] = [
//                         'supplier_id' => $supplier_id,
//                         'warehouse' => $item->warehouse_name,
//                         'purchase_orders' => []
//                     ];
//                 }
        
//                 // Initialize purchase order group inside supplier
//                 if (!isset($inward_data[$company->company_name][$supplier_id]['purchase_orders'][$purchase_order_id])) {
//                     $inward_data[$company->company_name][$supplier_id]['purchase_orders'][$purchase_order_id] = [
//                         'purchase_order_id' => $purchase_order_id,
//                         'items' => []
//                     ];
//                 }
        
//                 // Fetch related purchase order items for the current inward item
//                 $purchase_order_items = DB::table('purchase_order_items')
//                     ->leftJoin('product_variant', 'product_variant.id', '=', 'purchase_order_items.varient_id')
//                     ->leftJoin('units', 'units.id', '=', 'purchase_order_items.uom')
//                     ->where('purchase_order_items.purchase_order_id', $purchase_order_id)
//                     ->select(
//                         'purchase_order_items.quantity',
//                         'purchase_order_items.no_of_rolls',
//                         'units.unit_name',
//                         'product_variant.varient_name',
//                         'purchase_order_items.gst_percent',
//                         'purchase_order_items.rate',
//                         'purchase_order_items.total',
//                         'purchase_order_items.no_of_rolls'
//                     )
//                     ->get();
                
//                 // Add item inside the purchase order group
//                 $inward_data[$company->company_name][$supplier_id]['purchase_orders'][$purchase_order_id]['items'][] = [
//                     'id' => $item->id,
//                     'invoice_id' => $item->invoice_id,
//                     'product_name' => $item->product_name,
//                     'purchase_order_items' => $purchase_order_items, // Nested array of items
//                 ];
//             }
//         }
        
//         // dd($inward_data);
//          // Fetch Kukreja Interiors company details
//         $company = DB::table('companies')
//             ->where('company_name', 'Kukreja Interiors')
//             ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
//             ->first();

//         $pdf = PDF::loadView('reportstemplate.todaysInward', [
//             'inward_data' => $inward_data,
//             'company'=>$company,
//                 'is_pdf' => true 
//             ]);
//         return $pdf->download('todays_inward.pdf'); 
// }


   public function todaysInward(Request $request)
    {
        ini_set('memory_limit', '1024M');
        set_time_limit(300);

        $startDate = $request->input('start_date') ?? date('Y-m-d');
        $endDate = $request->input('end_date') ?? date('Y-m-d');

        // Fetch inward companies
        $inward_company = DB::table('inventory')
            ->whereBetween('inward_date', [$startDate, $endDate])
            ->leftJoin('companies', 'companies.id', '=', 'inventory.company_id')
            ->select('inventory.company_id', 'companies.company_name')
            ->groupBy('company_id', 'company_name')
            ->get();

        $inward_data = [];

        foreach ($inward_company as $company) {
            $inward_items = DB::table('inventory')
                ->whereBetween('inward_date', [$startDate, $endDate])
                ->where('inventory.company_id', $company->company_id)
                ->leftJoin('purchase_orders', 'purchase_orders.id', '=', 'inventory.po_number')
                ->leftJoin('estimated_po', 'estimated_po.inward_id', '=', 'inventory.id')
                ->leftJoin('products', 'products.id', '=', 'inventory.product_id')
                ->leftJoin('warehouses', 'warehouses.id', '=', 'inventory.warehouse_id')
                ->select(
                    'inventory.*',
                    'inventory.supplier_id', 
                    'inventory.inward_no',
                    'products.product_name',
                    'purchase_orders.id as purchase_order_id',
                    'warehouses.warehouse_name'
                )
                ->get();

            if (!isset($inward_data[$company->company_name])) {
                $inward_data[$company->company_name] = [];
            }

            foreach ($inward_items as $item) {
                $supplier_id = $item->inward_no;
                $purchase_order_id = $item->purchase_order_id;

                if (!isset($inward_data[$company->company_name][$supplier_id])) {
                    $inward_data[$company->company_name][$supplier_id] = [
                        'supplier_id' => $supplier_id,
                        'warehouse' => $item->warehouse_name,
                         'inward_date' => $item->inward_date,
                        'purchase_orders' => []
                    ];
                }

                if (!isset($inward_data[$company->company_name][$supplier_id]['purchase_orders'][$purchase_order_id])) {
                    $inward_data[$company->company_name][$supplier_id]['purchase_orders'][$purchase_order_id] = [
                        'purchase_order_id' => $purchase_order_id,
                        'items' => []
                    ];
                }

                $purchase_order_items = DB::table('estimated_po')
                    ->leftJoin('purchase_order_items', 'estimated_po.po_detail_id', '=', 'purchase_order_items.id')
                    ->leftJoin('product_variant', 'product_variant.id', '=', 'estimated_po.varient_id')
                    ->leftJoin('units', 'units.id', '=', 'estimated_po.unit')
                    ->where('estimated_po.po_id', $purchase_order_id)
                    ->where('estimated_po.inward_id', $item->id)  
                    ->select(
                        'estimated_po.quantity',
                        'estimated_po.no_of_rolls',
                        'units.unit_name',
                        'product_variant.varient_name',
                         'product_variant.varient_code',
                        'purchase_order_items.gst_percent',
                        'estimated_po.rate',
                        'estimated_po.amount as total',
                        'estimated_po.no_of_rolls'
                    )
                    ->get();

                $inward_data[$company->company_name][$supplier_id]['purchase_orders'][$purchase_order_id]['items'][] = [
                    'id' => $item->id,
                    'invoice_id' => $item->inward_no,
                    'product_name' => $item->product_name,
                    'purchase_order_items' => $purchase_order_items,
                ];
            }
        }

        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
            ->first();

        return view('reportstemplate.todaysInward', [
            'inward_data' => $inward_data,
            'company' => $company,
            'is_pdf' => false
        ]);
    }


 public function todaysInwardpdf(Request $request){

         ini_set('memory_limit', '1024M');
        set_time_limit(300);

        $startDate = $request->input('start_date') ?? date('Y-m-d');
        $endDate = $request->input('end_date') ?? date('Y-m-d');

        // Fetch inward companies
        $inward_company = DB::table('inventory')
            ->whereBetween('inward_date', [$startDate, $endDate])
            ->leftJoin('companies', 'companies.id', '=', 'inventory.company_id')
            ->select('inventory.company_id', 'companies.company_name')
            ->groupBy('company_id', 'company_name')
            ->get();

        $inward_data = [];

        foreach ($inward_company as $company) {
            $inward_items = DB::table('inventory')
                ->whereBetween('inward_date', [$startDate, $endDate])
                ->where('inventory.company_id', $company->company_id)
                ->leftJoin('purchase_orders', 'purchase_orders.id', '=', 'inventory.po_number')
                ->leftJoin('estimated_po', 'estimated_po.inward_id', '=', 'inventory.id')
                ->leftJoin('products', 'products.id', '=', 'inventory.product_id')
                ->leftJoin('warehouses', 'warehouses.id', '=', 'inventory.warehouse_id')
                ->select(
                    'inventory.*',
                    'inventory.supplier_id', 
                    'inventory.inward_no',
                    'products.product_name',
                    'purchase_orders.id as purchase_order_id',
                    'warehouses.warehouse_name'
                )
                ->get();

            if (!isset($inward_data[$company->company_name])) {
                $inward_data[$company->company_name] = [];
            }

            foreach ($inward_items as $item) {
                $supplier_id = $item->inward_no;
                $purchase_order_id = $item->purchase_order_id;

                if (!isset($inward_data[$company->company_name][$supplier_id])) {
                    $inward_data[$company->company_name][$supplier_id] = [
                        'supplier_id' => $supplier_id,
                        'warehouse' => $item->warehouse_name,
                         'inward_date' => $item->inward_date,
                        'purchase_orders' => []
                    ];
                }

                if (!isset($inward_data[$company->company_name][$supplier_id]['purchase_orders'][$purchase_order_id])) {
                    $inward_data[$company->company_name][$supplier_id]['purchase_orders'][$purchase_order_id] = [
                        'purchase_order_id' => $purchase_order_id,
                        'items' => []
                    ];
                }

                $purchase_order_items = DB::table('estimated_po')
                    ->leftJoin('purchase_order_items', 'estimated_po.po_detail_id', '=', 'purchase_order_items.id')
                    ->leftJoin('product_variant', 'product_variant.id', '=', 'estimated_po.varient_id')
                    ->leftJoin('units', 'units.id', '=', 'estimated_po.unit')
                    ->where('estimated_po.po_id', $purchase_order_id)
                    ->where('estimated_po.inward_id', $item->id)  
                    ->select(
                        'estimated_po.quantity',
                        'estimated_po.no_of_rolls',
                        'units.unit_name',
                        'product_variant.varient_name',
                         'product_variant.varient_code',
                        'purchase_order_items.gst_percent',
                        'estimated_po.rate',
                        'estimated_po.amount as total',
                        'estimated_po.no_of_rolls'
                    )
                    ->get();

                $inward_data[$company->company_name][$supplier_id]['purchase_orders'][$purchase_order_id]['items'][] = [
                    'id' => $item->id,
                    'invoice_id' => $item->inward_no,
                    'product_name' => $item->product_name,
                    'purchase_order_items' => $purchase_order_items,
                ];
            }
        }

        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
            ->first();



        $pdf = PDF::loadView('reportstemplate.todaysInward', [
            'inward_data' => $inward_data,
            'company'=>$company,
                'is_pdf' => true 
            ]);
        return $pdf->download('todays_inward.pdf'); 
}

    public function todaysOrder(){

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        $orders = DB::table('orders')
        ->where('order_date', date('Y-m-d'))
        ->leftJoin('customers', 'customers.id', 'orders.customer_id')
        ->select('orders.*', 'customers.customer_name')
        ->get();
        // return view('reportstemplate.todaysOrder', compact('orders'));

         // Fetch Kukreja Interiors company details
        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
            ->first();

        return view('reportstemplate.todaysOrder', [
            'orders' => $orders,
            'company'=>$company,
            'is_pdf' => false 
            ]);
    }

     public function todaysOrderpdf(){

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        $orders = DB::table('orders')
        ->where('order_date', date('Y-m-d'))
        ->leftJoin('customers', 'customers.id', 'orders.customer_id')
        ->select('orders.*', 'customers.customer_name')
        ->get();
        // return view('reportstemplate.todaysOrder', compact('orders'));

         // Fetch Kukreja Interiors company details
        $company = DB::table('companies')
            ->where('company_name', 'Kukreja Interiors')
            ->select('company_name', 'address', 'city', 'state','phone1','gst_no')
            ->first();

         $pdf = PDF::loadView('reportstemplate.todaysOrder', [
            'orders' => $orders,
            'company'=>$company,
                'is_pdf' => true 
            ]);
        return $pdf->download('todays_order.pdf'); 
    }

    public function inwardInvoice(Request $request){

        // Safely handle large data
        ini_set('memory_limit', '1024M'); // Increase memory limit
        set_time_limit(300);              // Increase max execution time to 5 minutes

        $inward_invoice = DB::table('inward_invoice')->where('inward_id', $request->id)->first();
        $inward = DB::table('inventory')->find($request->id);
        $company = DB::table('companies')->find($inward->company_id);
        $po = DB::table('purchase_orders')->where('po_number', $inward_invoice->po_no)->first();
        $po_items = DB::table('purchase_order_items')
        ->leftJoin('product_variant', 'product_variant.id', '=', 'purchase_order_items.varient_id')
        ->where('purchase_order_id', $po->id)
        ->select('purchase_order_items.*', 'product_variant.varient_name')
        ->get();
        $supplier = DB::table('suppliers')->find($po->supplier_id);

        $pdf = PDF::loadView('admin.inward_invoice', compact('inward_invoice', 'inward', 'company', 'supplier', 'po', 'po_items'));

        return $pdf->download('inward_invoice.pdf');
        // return $supplier;
        // return view('admin.inward_invoice', compact('inward_invoice', 'inward', 'company', 'supplier', 'po', 'po_items'));
    }

    public function checkInvoice(Request $request){
        $id = $request->id;
        $checkinvoice = DB::table('inward_invoice')->where('inward_id',$id)->first(); 
        if($checkinvoice){
            $invoicestatus=1;
        }else{
            $invoicestatus=0; 
        }
        return $invoicestatus;
    }

    public function generateInvoice(Request $request){
        $id = $request->id;
        $inward = DB::table('inventory')->find($id); 

        $lastCompany = DB::table('purchase_orders')->orderBy('po_number', 'desc')->where('deleted_at',null)->first();

        if ($lastCompany) {
            $lastIdNumber = (int) substr($lastCompany->po_number, 2); 
            $newPOId = 'PO' . str_pad($lastIdNumber, 6, '0', STR_PAD_LEFT); 
        } else {
            $newPOId = 'PO000001';
        }
        // Get the current timestamp
        $currentTimestamp = Carbon::now();

        // Generate invoice number with timestamp format
        $newInvoiceNumber = 'INV' . $currentTimestamp->format('YmdHis');
        // return $newInvoiceNumber;
        // Insert new invoice into database
        $inward = DB::table('inward_invoice')->insert([
            'invoice_id' => $newInvoiceNumber,
            'inward_id' => $id,
            'po_number' => $inward->po_number, // Replace with actual PO ID
            'created_at' => now(),
            'updated_at' => now(),
            'po_no'      => $newPOId
        ]);

        return $inward;
        
    }
}
