@include('layouts.header')
		<!-- /Header -->
		@include('layouts.sidebar')

		<div class="page-wrapper">
			<div class="content">
				<div class="page-header">
					<div class="add-item d-flex">
						<div class="page-title">
							<h4>Add Godown Manager</h4>
							<h6>Create new godown manager</h6>
						</div>
					</div>
					<ul class="table-top-head">
						<li>
							<div class="page-btn">
								<a href="{{ route('godown_manager')}}" class="btn btn-secondary"><i data-feather="arrow-left" class="me-2"></i>Back to Godown Manager</a>
							</div>
						</li>
						<li>
							<a data-bs-toggle="tooltip" data-bs-placement="top" title="Collapse" id="collapse-header"><i data-feather="chevron-up" class="feather-chevron-up"></i></a>
						</li>
					</ul>
					
				</div>
				@if(session()->has('success'))
							<div class="alert alert-success">
								{{ session()->get('success') }}
							</div>
							@endif
							@if(session()->has('error'))
							<div class="alert alert-danger">
								{{ session()->get('error') }}
							</div>
						    @endif
				<!-- /add -->
				<form action="{{ route('save_godown_manager')}}" method="post" id="myForm">
					@csrf
					<div class="card">
						<div class="card-body add-product pb-0">
							<div class="accordion-card-one accordion" id="accordionExample">
								<div class="accordion-item">
									<div class="accordion-header" id="headingOne">
										<div class="accordion-button" data-bs-toggle="collapse" data-bs-target="#collapseOne"  aria-controls="collapseOne">
											<div class="addproduct-icon">
												<h5><i data-feather="info" class="add-info"></i><span>Godown Manager Information</span></h5>
												<a href="javascript:void(0);"><i data-feather="chevron-down" class="chevron-down-add"></i></a>
											</div>
										</div>
									</div>
									<div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
									<div class="accordion-body">
										
										<div class="row">
										<div class="col-lg-6 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Godown Manager ID </label>
													<input type="text" name="godown_manager_id"  class="form-control" value="{{ $newGodownmangerId}}" readonly>
												</div>
											</div>
											<div class="col-lg-6 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<div class="add-newplus">
														<label class="form-label">Godown Manager</label>
														<a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#add-units-brand"><i data-feather="plus-circle" class="plus-down-add"></i><span>Add New</span></a>
													</div>
													<select name="user_id" class="form-control"  required>
                                                        <option value="">Select</option>
														@foreach($users as $row)
														<option value="{{ $row->id}}">{{ $row->full_name}}</option>
														@endforeach
													</select>
												</div>
											</div>
										
											
										</div>

										<div class="row">
											
											
											<div class="col-lg-6 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Phone1</label>
													<input type="text" name="phone1" class="form-control" placeholder="Enter Phone1" onkeypress="return event.charCode >= 48 && event.charCode <= 57" required>
												</div>
											</div>
											<div class="col-lg-6 col-sm-6 col-12">
												<div class="input-blocks add-product list">
													<label class="form-label">Phone2</label>
													<input type="text" name="phone2" class="form-control list" placeholder="Enter Phone2" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
													
												</div>
											</div>
											
										</div>
										<div class="row">
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">City</label>
													<input type="text" name="city" class="form-control" placeholder="Enter City">
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">State</label>
													<input type="text" name="state" class="form-control" placeholder="Enter State">
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">PIN Code</label>
													<input type="text" name="pincode" class="form-control" placeholder="Enter PIN Code">
												</div>
											</div>
										</div>
										
										<!-- Editor -->
                                        <div class="col-lg-12">
                                            <div class="input-blocks summer-description-box transfer mb-3">
                                                <label>Address</label>
                                                <textarea class="form-control h-100" rows="5" required name="address" placeholder="Enter Address"></textarea>
                                            </div>
                                        </div>
                                        <!-- /Editor -->
									</div>
									</div>
								</div>
							</div>
							
						</div>
					</div>
					<div class="col-lg-12">
						<div class="btn-addproduct mb-4">
							<a href="{{ url('godown-manager')}}" class="btn btn-cancel me-2">Cancel</a>
							<button type="submit" class="btn btn-submit" id="submitBtn">Save Godown Manager</button>
						</div>
					</div>
				</form>
			<!-- /add -->

		</div>
	</div>
	</div>

    <div class="modal fade" id="add-units-brand">
		<div class="modal-dialog modal-dialog-centered custom-modal-two">
			<div class="modal-content">
				<div class="page-wrapper-new p-0">
					<div class="content">
						<div class="modal-header border-0 custom-modal-header">
							<div class="page-title">
								<h4>Add New Godown Manager</h4>
							</div>
							<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body custom-modal-body">
							<form id="addGodownmanagerForm">
							@csrf
							<div class="mb-3">
								<label class="form-label">Godown Manager</label>
								<input type="text" name="name" id="godownmanager_name" class="form-control" required> <small id="godownmanager-error" style="color: red; display: none;">This godown manager  is already added!</small>
							</div>
							<div class="mb-3">
								<label class="form-label">Email</label>
								<input type="email" name="email" id="email" class="form-control" required> 
							</div>
							<div class="mb-3">
								<label class="form-label">Password</label>
								<input type="password" name="password" id="password" class="form-control" required> 
							</div>
							<div class="modal-footer-btn">
								<a href="javascript:void(0);" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</a>
								<input type="submit" id="submitgmngrBtn"  class="btn btn-submit" name="submit" value="Submit"><p id="message" style="color: red;">
							</div>
						</form>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- /Main Wrapper -->
	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script type="text/javascript">
	
	//let lastProductNumber = 1; // Initialize with the starting value

	/*function generateProductCode(name, lastNumber = lastProductNumber) {
		const words = name.split(" ");
		let initials = '';
	
		// Get the first letter of each word
		words.forEach(word => {
			if (word.length > 0) {
				initials += word[0].toUpperCase();
			}
		});
	
		// Increment the last number and pad with zeros if needed
		let incrementedNumber = String(lastNumber).padStart(2, '0');
		return '#' + initials + incrementedNumber;
	}
	
	// Function to check if the product code already exists
	function checkProductCode(productName, lastNumber) {
		const productCode = generateProductCode(productName, lastNumber);
	
		return $.ajax({
			url: "{{ route('check.product.code') }}", // URL to your Laravel route
			type: "POST",
			data: {
				_token: "{{ csrf_token() }}",
				product_code: productCode
			},
			dataType: "json"
		}).then(response => {
			if (response.exists) {
				// If the product code exists, increment the number and try again
				return checkProductCode(productName, lastNumber + 1);
			} else {
				// If the product code doesn't exist, return the unique code
				return productCode;
			}
		});
	}
	
	// Event listener for the product name input
	document.getElementById('user_id').addEventListener('input', function() {
		const productName = this.value.trim();
	
		if (productName.length > 0) {
			checkProductCode(productName, lastProductNumber)
				.then(uniqueProductCode => {
					// Set the unique product code
					document.getElementById('godown_manager_id').value = uniqueProductCode;
					lastProductNumber++; // Update the last product number for the next product
				})
				.catch(error => {
					console.error('Error checking product code:', error);
				});
		} else {
			document.getElementById('godown_manager_id').value = ''; // Clear the product code if the product name is empty
		}
	});*/

    $('#addGodownmanagerForm').submit(function(e) {
			e.preventDefault(); // Prevent the default form submission

			// Get the brand name value
			var installerName = $('#godownmanager_name').val();
			var email = $('#email').val();
			var password = $('#password').val();
			
			//alert(installerName);

			// Make the AJAX request to add the brand
			$.ajax({
				url: "{{ route('add_godownmanager') }}", // Your route for adding the brand
				method: 'POST',
				data: {
					_token: '{{ csrf_token() }}', // Add CSRF token
					name: installerName,
					email: email,
					password: password,
				},
				success: function(response) {
					
					if (response.success) {
						
						$('#add-units-brand').modal('hide');

						
						$('#addGodownmanagerForm')[0].reset();

					
						$('select[name="user_id"]').append('<option value="' + response.godownmanager.id + '" selected>' + response.godownmanager.full_name + '</option>');

					
					
					} else {
						alert('Failed to add godown manager!');
					}
				},
				error: function() {
					alert('An error occurred while adding the brand.');
				}
			});
		});
		
		document.getElementById("myForm").addEventListener("submit", function(event) {
        let submitBtn = document.getElementById("submitBtn");
        
        if (submitBtn.disabled) {
            event.preventDefault(); // Prevent form resubmission
            alert("Please wait, your info is submitted.");
        } else {
            submitBtn.disabled = true;
            submitBtn.innerText = "Submitting...";
        }
    });
    
    document.getElementById("addGodownmanagerForm").addEventListener("submit", function(event) {
        let submitBtn = document.getElementById("submitgmngrBtn");
        
        if (submitBtn.disabled) {
            event.preventDefault(); // Prevent form resubmission
            alert("Please wait, your info is submitted.");
        } else {
            submitBtn.disabled = true;
            submitBtn.innerText = "Submitting...";
        }
    });
    
    $("#godownmanager_name").on("keyup blur", function (e) { 
        let godownmanager = $(this).val();
       
            $.ajax({
                url: "{{ route('check_gmanager_exists') }}",
                type: "POST",
                data: {
                    godownmanager: godownmanager,
                    _token: "{{ csrf_token() }}"
                },
                success: function (response) {
                    if (response.exists) {
                        $("#godownmanager-error").show(); 
                        $("#godownmanager_name").addClass("error-field"); 
                        $("#godownmanager_name").focus(); 
                         $("#submitgmngrBtn").prop("disabled", true);
                        $("#message")
            .text("This godown manager  name is already used, try another.")
            .css({ "color": "red", "font-weight": "bold", "display": "block", "visibility": "visible" })
            .show();
                    } else {
                        $("#godownmanager-error").hide(); 
                        $("#godownmanager_name").removeClass("error-field"); 
                    }
                }
            });
            $("#submitgmngrBtn").prop("disabled", false);
         $("#message").hide();
        
    });
    
    $("#godownmanager_name").on("keydown", function (e) {
        if (e.key === "Tab" && $("#godownmanager-error").is(":visible")) {
            e.preventDefault(); 
        }
    });
    
</script>	
	
	@include('layouts.footer')
