@include('layouts.header')
<style>
	.select2-selection__choice{
		background:blueviolet !important;
	}
	.select2-container--default .select2-selection--single {
		
		border: 1px solid #e9edf6 !important;
		height:40px !important; 
	   
	}
	..select2-container--default .select2-selection--multiple{
		border: 1px solid #e9edf6 !important;


	}
	.select2-container .select2-selection--single .select2-selection__arrow {
		height: 100% !important;
		position: absolute !important;
		top: 0 !important;
		right: 0 !important;
		width: 20px !important; 
		background-color: transparent !important;
		border-left: 1px solid #aaa !important; 
	}
	
	.select2-container .select2-selection__arrow b {
	  
		border-width: 5px 5px 0 5px !important; 
		border-style: solid !important;
		display: inline-block !important;
		margin-top: 5px !important;
		vertical-align: middle !important;
	}
	
	.select2-container--default .select2-selection--single .select2-selection__arrow 
	{
		display: none !important;
	}
	.select2-selection__clear{
		display: none !important;
		/* color:#aaa; */
	}
	
	</style>
		<!-- /Header -->
		@include('layouts.sidebar')

		<div class="page-wrapper">
			<div class="content">
				<div class="page-header">
					<div class="add-item d-flex">
						<div class="page-title">
							<h4>New Product</h4>
							<h6>Create new product</h6>
						</div>
					</div>
					<ul class="table-top-head">
						<li>
							<div class="page-btn">
								<a href="{{ route('product_list')}}" class="btn btn-secondary"><i data-feather="arrow-left" class="me-2"></i>Back to Product</a>
							</div>
						</li>
						<li>
							<a data-bs-toggle="tooltip" data-bs-placement="top" title="Collapse" id="collapse-header"><i data-feather="chevron-up" class="feather-chevron-up"></i></a>
						</li>
					</ul>
					
				</div>
				<!-- /add -->
				@if(session()->has('success'))
                    <div class="alert alert-success">
                        {{ session()->get('success') }}
                    </div>
					@endif
					@if(session()->has('error'))
					<div class="alert alert-danger">
						{{ session()->get('error') }}
					</div>
				    @endif
				<form action="{{ route('store_product')}}" id="myForm" method="post" enctype="multipart/form-data">
					@csrf
					<div class="card">
						<div class="card-body add-product pb-0">
							<div class="accordion-card-one accordion" id="accordionExample">
								<div class="accordion-item">
									<div class="accordion-header" id="headingOne">
										<div class="accordion-button" data-bs-toggle="collapse" data-bs-target="#collapseOne"  aria-controls="collapseOne">
											<div class="addproduct-icon">
												<h5><i data-feather="info" class="add-info"></i><span>Product Information</span></h5>
												<a href="javascript:void(0);"><i data-feather="chevron-down" class="chevron-down-add"></i></a>
											</div>
										</div>
									</div>
									<div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
									<div class="accordion-body">
										<div class="row">
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label  class="form-label">Product Code</label>
													<input type="text" name="product_code" value="{{ $newProductId}}" readonly class="form-control list" placeholder="Enter Code">
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label"> Buyer Company</label>
													<select class="form-control" name="company_id" id="company_id">
														<option value="">Select</option>
														@foreach($company as $row)
														<option value="{{ $row->id}}">{{ $row->company_name}}</option>
														@endforeach 
													
													</select>
												</div>
											</div>
											
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<div class="add-newplus">
															<label class="form-label">Suppliers</label>
															<a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#add-supplier"><i data-feather="plus-circle" class="plus-down-add"></i><span>Add
																New</span></a>
														</div>
													<select class="select" name="supplier_id[]" multiple>
														<option value="" disabled>select</option>
														@foreach($suppliers as $row)
														<option value="{{ $row->id}}">{{ $row->supplier_name}}</option>
														@endforeach 
													</select>
												</div>
											</div>
											
										</div>
										
										<div class="addservice-info">
											<div class="row">
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<div class="add-newplus">
															<label class="form-label">Category</label>
															<a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#add-category"><i data-feather="plus-circle" class="plus-down-add"></i><span>Add
																New</span></a>
														</div>
														<select class="form-control" name="category" id="category">
															<option value="">Select</option>
															@foreach($category as $row)
															<option value="{{ $row->id}}">{{ $row->category_name}}</option>
															@endforeach
														</select>
													</div>
												</div>
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<div class="add-newplus">
														<label class="form-label">Sub Category</label>
												     	<a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#add-sub-category"><i data-feather="plus-circle" class="plus-down-add"></i><span>Add
															New</span></a>
														</div>
														<select class="form-control" name="subcategory" id="subcategory">
                                                            <option value="">Select</option>
														</select>
													</div>
												</div>

												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<div class="add-newplus">
															<label class="form-label">Brand</label>
															<a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#add-units-brand"><i data-feather="plus-circle" class="plus-down-add"></i><span>Add New</span></a>
														</div>
														<select class="form-control" name="brand_id" id="brand">
															<option value="">Select</option>	
															@foreach($brands as $row)
															<option value="{{ $row->id}}">{{ $row->brand_name}}</option>
															@endforeach
														</select>
													</div>
												</div>
												
											</div>
											<div class="row">
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Product Name</label>
														<input type="text"  name="product_name" id="product_name" class="form-control" placeholder="Enter Product Name">
													</div>
												</div>
												
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
					
														<div class="add-newplus">
															<label class="form-label">Selling Unit</label>
															<a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#add-unit"><i data-feather="plus-circle" class="plus-down-add"></i><span>Add New</span></a>
														</div>
														<select class="form-control" id="unit_id" name="unit_id">
															<option value="">Select</option>
															@foreach($units as $row)
															<option value="{{ $row->id}}">{{ $row->unit_name}}</option>
															@endforeach
														</select>
													</div>
												</div>
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Roll Size</label>
														<input type="text"  name="roll_size" id="roll_size" class="form-control" placeholder="Enter Roll Size 1500 X 200 format">
													</div>
												</div>
												
											
											
											</div>
										</div>
										<div class="add-product-new">
											<div class="row">
												

												<div class="col-lg-2 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Thickness</label>
														<input type="text"  name="thickness" id="thickness" class="form-control" placeholder="Enter Thickness in mm" oninput="this.value = this.value.replace(/[^0-9.]/g, '')"
       pattern="^\d*\.?\d*$">
													</div>
												</div>
												<div class="col-lg-3 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">HSN Code</label>
														<input type="text"  name="hsn_code" placeholder="Enter HSN Code" class="form-control" onkeypress="return event.charCode >= 48 && event.charCode <= 57" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 8);">
													</div>
												</div>
												<div class="col-lg-3 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Quantity/Roll</label>
														<input type="text"  name="quantityroll"  placeholder="Enter Quantity/Roll" class="form-control" oninput="this.value = this.value.replace(/[^0-9.]/g, '')"
       pattern="^\d*\.?\d*$" >
													</div>
												</div>
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Product Display Image</label>
														<input type="file"  accept=".png,.jpg,.jpeg" id="imageInput"  name="product_image" class="form-control" required>
												 <img id="imagePreview" src="" alt="Preview" style="display:none; margin-top:10px; max-width:150px;height:100px; border:1px solid #ddd; padding:5px; border-radius:5px;">

													</div>
												</div>
												
											</div>
										</div>			
										
										<!-- Editor -->
										<div class="row">
                                        <div class="col-lg-6">
                                            <div class="input-blocks summer-description-box transfer mb-3">
                                                <label>Description</label>
                                                <textarea class="form-control h-100" id="description"  rows="5" name="description" placeholder="Enter Description"></textarea>
                                               
                                            </div>
                                        </div>

										<div class="col-lg-6">
                                            <div class="input-blocks summer-description-box transfer mb-3">
                                                <label>Product Technical Detail</label>
                                                <textarea class="form-control h-100" id="summernote" rows="5" name="technical_details" placeholder="Enter technical details"></textarea>
                                               
                                            </div>
                                        </div>
									</div>

									
                                        <!-- /Editor -->
									</div>
									</div>
								</div>
							</div>
							
						</div>
					</div>

					<div class="card">
						<div class="card-body add-product pb-0">
							<div class="accordion-card-one accordion" id="pricing">
								<div class="accordion-item">
									<div class="accordion-header" id="headingOne">
										<div class="accordion-button" data-bs-toggle="collapse" data-bs-target="#collapseTwo"  aria-controls="collapseTwo">
											<div class="addproduct-icon">
												<h5><i data-feather="info" class="add-info"></i><span>Pricing Details</span></h5>
												<a href="javascript:void(0);"><i data-feather="chevron-down" class="chevron-down-add"></i></a>
											</div>
										</div>
									</div>
								<div id="collapseTwo" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#pricing">
									<div class="accordion-body">
										<div class="row">
										
											
                                            <div class=" col-lg-4 col-sm-6">
												<div class="mb-3 add-product">
													<label class="form-label">Basic Cost</label>
													<input type="text"  name="basic_cost" id="basic_cost" class="form-control" required placeholder="Enter Basic Cost" step="0.01" min="0" oninput="this.value = this.value.replace(/[^0-9.]/g, '')"
       pattern="^\d*\.?\d*$">
												</div>
											</div>  
											<div class=" col-lg-4 col-sm-6">
												<div class="mb-3 add-product">
													<label class="form-label">% GST</label>
													<input type="text"  name="gst_rate" id="gst_percent"  class="form-control" required placeholder="Enter GST in %" oninput="this.value = this.value.replace(/[^0-9.]/g, '')"
       pattern="^\d*\.?\d*$">
												</div>
											</div>  
										
											<div class=" col-lg-4 col-sm-6">
												<div class="mb-3 add-product">
													<label class="form-label">Purchase Cost (Including GST)</label>
													<input type="text"  name="purchase_cost" id="purchase_cost"  class="form-control" required placeholder="Enter Purchase Cost" oninput="this.value = this.value.replace(/[^0-9.]/g, '')"
       pattern="^\d*\.?\d*$" readonly>
												</div>
											</div> 
											
											
										</div>
										<div class="row">
											<div class=" col-lg-4 col-sm-6">
												<div class="mb-3 add-product">
													<label class="form-label">% Retail Profit Margin</label>
													<input type="text"  name="profit_margin"  class="form-control" id="profit_margin" required placeholder="Enter Profit Margin" oninput="this.value = this.value.replace(/[^0-9.]/g, '')"
       pattern="^\d*\.?\d*$" >
												</div>
											</div> 
											<div class=" col-lg-4 col-sm-6">
												<div class="mb-3 add-product">
													<label class="form-label">Retail Price</label>
													<input type="text"  name="retail_price"  class="form-control" id="retail_price" required placeholder="Enter Retail Price" readonly onkeypress="return event.charCode >= 48 && event.charCode <= 57" >
												</div>
											</div>  
											
											<div class=" col-lg-4 col-sm-6">
												<div class="mb-3 add-product">
													<label class="form-label">Effective Date</label>
													<input type="date"  name="effective_date"  class="form-control" required placeholder="Enter Effective Date"  onkeypress="return event.charCode >= 48 && event.charCode <= 57" >
												</div>
											</div>  
										</div>	
											
										
                                        <!-- /Editor -->
									</div>
								</div>
								</div>
							</div>
						</div>
					</div>	

					 <div class="card">
						<div class="card-body add-product pb-0">
							<div class="accordion-card-one accordion" id="warehouse">
								<div class="accordion-item">
									<div class="accordion-header" id="headingOne">
										<div class="accordion-button" data-bs-toggle="collapse" data-bs-target="#collapseThree"  aria-controls="collapseTwo">
											<div class="addproduct-icon">
												<h5><i data-feather="info" class="add-info"></i><span>Warehouse Details</span></h5>
												<a href="javascript:void(0);"><i data-feather="chevron-down" class="chevron-down-add"></i></a>
											</div>
										</div>
									</div>
								<div id="collapseThree" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#warehouse">
									<div class="accordion-body">
										<div class="row">
										
										
										</div>
										<div class="row">
											<div class="card">
												<div class="card-body">

														<div class="productdetails">
															<div class="input-group mb-3 datas" id="subcategory-0">
							
																<div class="add-icon">
																<a href="#" class="remove-subcategory" title="Remove" style="color:white;background:red">
																	<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-minus-circle minus">
																		<circle cx="12" cy="12" r="10"></circle>
																		<line x1="8" y1="12" x2="16" y2="12"></line>
																	</svg>
																</a></div>
																<select class="form-control warehouse-select" name="warehouse[]" required style="margin-right: 10px">
																	<option value="">Select Warehouse</option>
																	
																</select>
																<input type="text" class="form-control pack_margin_percentage" placeholder="Enter Pack Margin in %" id="pack_margin_percentage" oninput="this.value = this.value.replace(/[^0-9.]/g, '')"
       pattern="^\d*\.?\d*$" name="pack_margin[]" style="margin-right: 10px" required />
																<input type="text" class="form-control pack_margin_amt"  id="pack_margin_amt"  oninput="this.value = this.value.replace(/[^0-9.]/g, '')"
       pattern="^\d*\.?\d*$" name="pack_margin_amt[]" style="margin-right: 10px" readonly />
																<input type="text" class="form-control cut_margin_percentage" placeholder="Enter Cut Margin in %"  id="cut_margin_percentage"  oninput="this.value = this.value.replace(/[^0-9.]/g, '')"
       pattern="^\d*\.?\d*$" name="cut_margin[]" style="margin-right: 10px" required />
																<input type="text" class="form-control cut_margin_amt"  id="cut_margin_amt" oninput="this.value = this.value.replace(/[^0-9.]/g, '')"
       pattern="^\d*\.?\d*$" name="cut_margin_amt[]" style="margin-right: 10px" readonly />

																
															</div>
														</div>
														<div id="additional-subcategories"></div>
														<div class="add-icon">
															<a href="#" title="Add" class="choose-add" id="add-subcategory" style="color:white;background:green;">
																<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus-circle plus">
																	<circle cx="12" cy="12" r="10"></circle>
																	<line x1="12" y1="8" x2="12" y2="16"></line>
																	<line x1="8" y1="12" x2="16" y2="12"></line>
																</svg>
															</a>
														</div>
														
													
												</div>
											</div>
										
										</div>
										
											
										
                                        <!-- /Editor -->
									</div>
								</div>
								</div>
							</div>
						</div>
					</div>	 

					<div class="col-lg-12">
						<div class="btn-addproduct mb-4">
							<a href="{{ url('product-list')}}" class="btn btn-cancel me-2">Cancel</a>
							<button type="submit" id="submitBtn"  class="btn btn-submit">Save Product</button>
						</div>
					</div>
				</form>
			<!-- /add -->

		</div>
	</div>
	</div>
	<!-- /Main Wrapper -->

	

	<!-- Add Category -->
	<div class="modal fade" id="add-category">
		<div class="modal-dialog modal-dialog-centered custom-modal-two">
			<div class="modal-content">
				<div class="page-wrapper-new p-0">
					<div class="content">
						<div class="modal-header border-0 custom-modal-header">
							<div class="page-title">
								<h4>Add New Category</h4>
							</div>
							<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body custom-modal-body">
							<form  id="addCategoryForm">
								@csrf
							<div class="mb-3">
								<label class="form-label">Name</label>
								<input type="text" name="name" id="category_name" class="form-control" required><small id="category-error" style="color: red; display: none;">This category is already added!</small>
							</div>
							<div class="modal-footer-btn">
								<a href="javascript:void(0);" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</a>
								<input type="submit" class="btn btn-submit"  id="submitcategory" name="submit" value="Submit"><p id="categorymessage" style="color: red;">
							</div>
						</form>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- /Add Category -->


<!-- /Add Supllier -->
	 <div class="modal fade" id="add-supplier">
    <div class="modal-dialog modal-dialog-centered custom-modal-two">
        <div class="modal-content">
            <div class="page-wrapper-new p-0">
                <div class="content">
                    <div class="modal-header border-0 custom-modal-header">
                        <div class="page-title">
                            <h4>Add New Supplier</h4>
                        </div>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body custom-modal-body">
                     <form id="addSupplierForm">
                            @csrf
                            <!-- Transporter Name -->
                            <div class="mb-3">
                                <label class="form-label">Supplier Name</label>
                                <input type="text" name="supplier_name" id="supplier_name" class="form-control" required>
                            </div>

							
								<div class="mb-3 add-product">
									<label class="form-label">Warehouse (can select multiple)</label>
									<select class="select" name="swarehouse_id[]" id="swarehouse_id" required multiple>
									
										<option value="">Choose</option>
										@foreach($warehouses as $row)
										<option value="{{ $row->id}}">{{ $row->warehouse_name}}</option>
										@endforeach
									</select>
								</div>
											

                            <!-- Contact Person & Email -->
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">Contact Person</label>
                                    <input type="text" name="scontact_person" class="form-control" id="scontact_person" placeholder="Enter Contact Person">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Email</label>
                                    <input type="text" name="semail" class="form-control" id="semail" placeholder="Enter Email">
                                </div>
                            </div>

                            <!-- GST No & MSME -->
                            <div class="row mb-3">
                                <div class="col-md-5">
                                    <label class="form-label">GST No</label>
                                    <input type="text" name="sgst_no" class="form-control" id="sgst_no" oninput="validateGST(this)" placeholder="Enter GST No">
                                    <small id="gst-error" class="text-danger"></small>
                                </div>
								 <div class="col-md-2">
                                    <label class="form-label">Top</label>
                                    <input type="text" name="stop" class="form-control" id="stop" readonly>
                                  
                                </div>
                                <div class="col-md-5">
                                    <label class="form-label">MSME</label>
                                    <input type="text" name="smsme" class="form-control" id="smsme" oninput="validateMSME(this)" placeholder="Enter MSME">
                                    <small id="msme-error" class="text-danger"></small>
                                </div>
                            </div>

                            <!-- Phone1 & Phone2 -->
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">Phone1</label>
                                    <input type="text" name="sphone1" class="form-control" id="sphone1" onkeypress="return event.charCode >= 48 && event.charCode <= 57" placeholder="Enter Phone">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Mobile No</label>
                                    <input type="text" name="smobile" id="smobile" class="form-control" onkeypress="return event.charCode >= 48 && event.charCode <= 57" placeholder="Enter Mobile No">
                                </div>
                            </div>

                            <!-- Address -->
                            <div class="mb-3">
                                <label>Address</label>
                                <textarea class="form-control h-100" rows="3" id="saddress" name="saddress" placeholder="Enter Address"></textarea>
                            </div>

                            <!-- City, State, PIN Code -->
                            <div class="row mb-3">
                                <div class="col-md-4">
                                    <label class="form-label">City</label>
                                    <input type="text" name="scity" id="scity" class="form-control" placeholder="Enter City">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">State</label>
                                    <input type="text" name="sstate" id="sstate" class="form-control" placeholder="Enter State">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">PIN Code</label>
                                    <input type="text" name="spincode" id="spincode" onkeypress="return event.charCode >= 48 && event.charCode <= 57" class="form-control" placeholder="Enter PIN Code">
                                </div>
                            </div>

                            <!-- Footer Buttons -->
                            <div class="modal-footer-btn">
                                <a href="javascript:void(0);" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</a>
                                <input type="submit" class="btn btn-submit" name="submit" value="Submit">
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

	
	<!-- Add Sub Category -->
	<div class="modal fade" id="add-sub-category">
		<div class="modal-dialog modal-dialog-centered custom-modal-two">
			<div class="modal-content">
				<div class="page-wrapper-new p-0">
					<div class="content">
						<div class="modal-header border-0 custom-modal-header">
							<div class="page-title">
								<h4>Add New Sub Category</h4>
							</div>
							<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body custom-modal-body">
							<form  id="addSubCategoryForm">
								@csrf
								<div class="mb-3">
									<label class="form-label">Category</label>
									<select name="category" class="form-control"  id="category_id" required>
                                      <option value="">Select</option>
									  @foreach($category as $row)
									  <option value="{{ $row->id}}">{{ $row->category_name}}</option>
									  @endforeach
									</select>
								</div>
							<div class="mb-3">
								<label class="form-label">Subcategory</label>
								<input type="text" name="subcategory_name" id="subcategory_name" class="form-control" required><small id="subcategory-error" style="color: red; display: none;">This sub category is already added!</small>
							</div>
							<div class="modal-footer-btn">
								<a href="javascript:void(0);" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</a>
								<input type="submit" class="btn btn-submit"  id="submitsubcategory" name="submit" value="Submit">
							</div>
						</form>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- /Add Sub Category -->

	<!-- Add Brand -->
	<div class="modal fade" id="add-units-brand">
		<div class="modal-dialog modal-dialog-centered custom-modal-two">
			<div class="modal-content">
				<div class="page-wrapper-new p-0">
					<div class="content">
						<div class="modal-header border-0 custom-modal-header">
							<div class="page-title">
								<h4>Add New Brand</h4>
							</div>
							<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body custom-modal-body">
							<form id="addBrandForm">
							@csrf
							<div class="mb-3">
								<label class="form-label">Brand</label>
								<input type="text" name="name" id="brand_name" class="form-control" required> <small id="brand-error" style="color: red; display: none;">This brand is already added!</small>
							</div>
							<div class="modal-footer-btn">
								<a href="javascript:void(0);" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</a>
								<input type="submit" class="btn btn-submit"  id="submitbrand" name="submit" value="Submit"><p id="brandmessage" style="color: red;">
							</div>
						</form>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- /Add Brand -->

	<!-- Add Unit -->
	<div class="modal fade" id="add-unit">
		<div class="modal-dialog modal-dialog-centered custom-modal-two">
			<div class="modal-content">
				<div class="page-wrapper-new p-0">
					<div class="content">
						<div class="modal-header border-0 custom-modal-header">
							<div class="page-title">
								<h4>Add Unit</h4>
							</div>
							<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body custom-modal-body">
							<form id="addUnitForm" >
							@csrf
							<div class="mb-3">
								<label class="form-label">Unit</label>
								<input type="text" name="name" id="unit_name"  class="form-control" required><small id="unit-error" style="color: red; display: none;">This unit is already added!</small>
							</div>
							<div class="modal-footer-btn">
								<a href="javascript:void(0);" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</a>
								<input type="submit" class="btn btn-submit" id="submitunit" name="submit" value="Submit"></button><p id="unitmessage" style="color: red;">
							</div>
						</form>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- /Add Unit -->


	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
		<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script> 
	<link href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote.css" rel="stylesheet">
    
   <script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote-bs4.min.js"></script>
	<script type="text/javascript">
    $(document).ready(function() {

		$('textarea[name="description"]').summernote({
            height: 300, 
            placeholder: 'Enter Description', 
            tabsize: 2
        });

		$('textarea[name="technical_details"]').summernote({
            height: 300, 
            placeholder: 'Enter Technical Description', 
            tabsize: 2
        });

        $('#category').on('change', function() {
            var category_id = $(this).val();
			
            if (category_id) {
                $.ajax({
                    url: '/get-subcategories/' + category_id,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        $('#subcategory').empty();
                        $('#subcategory').append('<option value="">Select Subcategory</option>');
                        $.each(data, function(key, value) {
                            $('#subcategory').append('<option value="' + value.id + '">' + value.sub_category_name + '</option>');
                        });
                    }
                });
            } else {
                $('#subcategory').empty();
                $('#subcategory').append('<option value="">Select Subcategory</option>');
            }
        });

			$('#addBrandForm').submit(function(e) {
			e.preventDefault(); 

			
			var brandName = $('#brand_name').val();
			

			
			$.ajax({
				url: "{{ route('add_brand_dynamic') }}", 
				method: 'POST',
				data: {
					_token: '{{ csrf_token() }}',
					name: brandName
				},
				success: function(response) {
					if (response.success) {
						
						$('#add-units-brand').modal('hide');

						$('#addBrandForm')[0].reset();

					
						$('select[name="brand_id"]').append('<option value="' + response.brand.id + '" selected>' + response.brand.brand_name + '</option>');

					
						alert('Brand added successfully!');
					} else {
						alert('Failed to add brand!');
					}
				},
				error: function() {
					alert('An error occurred while adding the brand.');
				}
			});
		});
	
		$('#addUnitForm').submit(function(e) {
			e.preventDefault(); 

			
			var unitName = $('#unit_name').val();
			

		
			$.ajax({
				url: "{{ route('add_unit_dynamic') }}", 
				method: 'POST',
				data: {
					_token: '{{ csrf_token() }}', 
					name: unitName
				},
				success: function(response) {
					if (response.success) {
						
						$('#add-unit').modal('hide');

						
						$('#addUnitForm')[0].reset();

						
						$('select[name="unit_id"]').append('<option value="' + response.unit.id + '" selected>' + response.unit.unit_name + '</option>');

						
						alert('Unit added successfully!');
					} else {
						alert('Failed to add brand!');
					}
				},
				error: function() {
					alert('An error occurred while adding the brand.');
				}
			});
		});

		$('#addCategoryForm').submit(function(e) {
			e.preventDefault(); 

			
			var categoryName = $('#category_name').val();
			

		
			$.ajax({
				url: "{{ route('add_category_dynamic') }}", 
				method: 'POST',
				data: {
					_token: '{{ csrf_token() }}', 
					name: categoryName
				},
				success: function(response) {
					if (response.success) {
						
						$('#add-category').modal('hide');

						
						$('#addCategoryForm')[0].reset();

						
						$('select[name="category"]').append('<option value="' + response.category.id + '" selected>' + response.category.category_name + '</option>');

						
						alert('Category added successfully!');
					} else {
						alert('Failed to add category!');
					}
				},
				error: function() {
					alert('An error occurred while adding the brand.');
				}
			});
		});


		$('#addSubCategoryForm').submit(function(e) {
			e.preventDefault(); 

			
			var categoryName = $('#category_id').val();
			
			var subcategoryName = $('#subcategory_name').val();

		
			$.ajax({
				url: "{{ route('add_subcategory_dynamic') }}", 
				method: 'POST',
				data: {
					_token: '{{ csrf_token() }}', 
					category: categoryName,
					subcategory: subcategoryName
				},
				success: function(response) {
					if (response.success) {
						
						$('#add-sub-category').modal('hide');

						
						$('#addSubCategoryForm')[0].reset();

						
						$('select[name="subcategory"]').append('<option value="' + response.subcategory.id + '" selected>' + response.subcategory.sub_category_name + '</option>');

						
						alert('Sub Category added successfully!');
					} else {
						alert('Failed to add Subcategory!');
					}
				},
				error: function() {
					alert('An error occurred while adding the brand.');
				}
			});
		});


		let subcategoryCount = 0;
				
		
		let selectedWarehouses = new Set();
// Change event for company_id dropdown
$('#company_id').change(function() {
    let companyId = $(this).val();
    if (companyId) {
        // Fetch warehouses based on the selected company
        fetchWarehouses(companyId, $('.warehouse-select:first'));
    } else {
        $('.warehouse-select').html('<option value="">Select Warehouse</option>');
		selectedWarehouses.clear();
    }
});

// Function to fetch warehouses based on company_id
function fetchWarehouses(companyId, warehouseSelectElement) {
    $.ajax({
        url: '/get-warehouse/' + companyId,
        type: 'GET',
        success: function(data) {
            warehouseSelectElement.empty();
            warehouseSelectElement.append('<option value="">Select Warehouse</option>');
            $.each(data, function(key, value) {
                warehouseSelectElement.append('<option value="' + value.id + '">' + value.warehouse_name + '</option>');
            });
			updateWarehouseDropdowns();
			
        },
        error: function(xhr, status, error) {
            console.log(xhr.responseText);
        }
    });
}

function calculatePackMarginAmount($row) {
    const packMarginPercentage = parseFloat($row.find('.pack_margin_percentage').val()) || 0;
    const purchaseCost = parseFloat($('#purchase_cost').val()) || 0;
    const retailAmount = (packMarginPercentage / 100) * purchaseCost;
    const packMarginAmount = purchaseCost + retailAmount;
    $row.find('.pack_margin_amt').val(packMarginAmount.toFixed(2));
}

function calculateCutMarginAmount($row) {
    const cutMarginPercentage = parseFloat($row.find('.cut_margin_percentage').val()) || 0;
    const purchaseCost = parseFloat($('#purchase_cost').val()) || 0;
    const retailAmount = (cutMarginPercentage / 100) * purchaseCost;
    const cutMarginAmount = purchaseCost + retailAmount;
    $row.find('.cut_margin_amt').val(cutMarginAmount.toFixed(2));
}


// Event delegation for pack margin percentage calculation
/*$(document).on('input', '.pack_margin_percentage', function () {
	
    const $row = $(this).closest('.datas'); // Get the current row
	
    calculatePackMarginAmount($row);
    updateWarehouseMargins();
});

// Event delegation for cut margin percentage calculation
$(document).on('input', '.cut_margin_percentage', function () {
	
    const $row = $(this).closest('.datas'); // Get the current row
    calculateCutMarginAmount($row);
});*/		








// Function to add a new subcategory row
function addSubcategoryRow() {
    const lastPackMargin = $('input[name="pack_margin[]"]').last().val();
    const lastWarehouse = $('select[name="warehouse[]"]').last().val();

    if (!lastPackMargin || !lastWarehouse) {
        Swal.fire({
            title: 'Validation Error',
            text: 'Please fill in the pack margin and warehouse before adding another.',
            icon: 'warning',
            confirmButtonText: 'Okay'
        });
        return; 
    }

    subcategoryCount++;

    $('#additional-subcategories').append(`
        <div class="input-group datas mb-3" id="subcategory-${subcategoryCount}">
        <div class="add-icon">
			<a href="#" class="remove-subcategory" title="Remove" style="color:white;background:red">
																	<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-minus-circle minus">
																		<circle cx="12" cy="12" r="10"></circle>
																		<line x1="8" y1="12" x2="16" y2="12"></line>
																	</svg>
																</a>
																</div>
            <select class="form-control warehouse-select" name="warehouse[]" required style="margin-right: 10px">
                <option value="">Select Warehouse</option>
            </select>
            <input type="text" class="form-control pack_margin_percentage"  placeholder="Enter Pack Margin in %" onkeypress="return event.charCode >= 48 && event.charCode <= 57" name="pack_margin[]" style="margin-right: 10px" required />
			<input type="text" class="form-control pack_margin_amt" onkeypress="return event.charCode >= 48 && event.charCode <= 57" name="pack_margin_amt[]" style="margin-right: 10px" readonly />
            <input type="text" class="form-control cut_margin_percentage" placeholder="Enter Cut Margin in %" onkeypress="return event.charCode >= 48 && event.charCode <= 57" name="cut_margin[]" style="margin-right: 10px" required />
            <input type="text" class="form-control cut_margin_amt"  onkeypress="return event.charCode >= 48 && event.charCode <= 57" name="cut_margin_amt[]" style="margin-right: 10px" readony />

			
        </div>
    `);

    let companyId = $('#company_id').val();
    if (companyId) {
        // Fetch warehouses for the new subcategory row
        fetchWarehouses(companyId, $(`#subcategory-${subcategoryCount} .warehouse-select`));
    }

    // Update the last add icon to be a remove icon
    $('.add-icon a').not(':last').replaceWith(`
        <a href="#" class="remove-subcategory" title="Remove" style="color:white;background:red">
            <svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-minus-circle minus">
                <circle cx="12" cy="12" r="10"></circle>
                <line x1="8" y1="12" x2="16" y2="12"></line>
            </svg>
        </a>
    `);
}

// Event handlers
// $(document).on('change', '.warehouse-select', function() {
//     let selectedWarehouse = $(this).val(); 
// });


// Event listener for warehouse selection
$(document).on('change', '.warehouse-select', function () {
    const selectedValue = $(this).val();
    if (selectedValue) {
        selectedWarehouses.add(selectedValue);
    } else {
        selectedWarehouses.delete($(this).data('prevValue'));
    }
    $(this).data('prevValue', selectedValue);
    updateWarehouseDropdowns();
});

// Function to update dropdowns to exclude selected warehouses
function updateWarehouseDropdowns() {
    $('.warehouse-select').each(function () {
        const currentSelect = $(this);
        const currentValue = currentSelect.val();
        currentSelect.find('option').each(function () {
            const optionValue = $(this).val();
            if (optionValue && selectedWarehouses.has(optionValue) && optionValue !== currentValue) {
                $(this).hide();
            } else {
                $(this).show();
            }
        });
    });
}


$(document).on('click', '#add-subcategory, .choose-add', function(e) {
    e.preventDefault();
    addSubcategoryRow();
    updateWarehouseMargins();
});

$(document).on('click', '.remove-subcategory', function(e) {
    e.preventDefault();
    $(this).closest('.input-group').remove();
});


 
	/*	function calculatePurchaseCost() {
				var basicCost = parseFloat($('#basic_cost').val()) || 0;
				var gstRate = parseFloat($('#gst_percent').val()) || 0;
			
				var gstAmount = (gstRate / 100) * basicCost;
				var purchaseCost = basicCost + gstAmount;

				
				$('#purchase_cost').val(purchaseCost.toFixed(2));
          }

		  

   
		$('#gst_percent').on('input', function() {
			calculatePurchaseCost();
		});


		function calculateRetailprice() {
			var profit_margin = parseFloat($('#profit_margin').val()) || 0;
			var purchase_cost = parseFloat($('#purchase_cost').val()) || 0;
			var retailAmount = (profit_margin / 100) * purchase_cost;
			var retailprice = purchase_cost + retailAmount;
			$('#retail_price').val(retailprice.toFixed(2));
		}

   
		$('#profit_margin').on('input', function() {
			calculateRetailprice();
		});

		$('#pack_margin_percentage').on('input', function() {
		
			pricewithpackmargin();
		});

		function pricewithpackmargin() {
		
			var pack_margin_percentage = parseFloat($('#pack_margin_percentage').val()) || 0;
			var purchase_cost = parseFloat($('#purchase_cost').val()) || 0;
			var retailAmount = (pack_margin_percentage / 100) * purchase_cost;
			var retailprice_withpackmargin = purchase_cost + retailAmount;
			$('#pack_margin_amt').val(retailprice_withpackmargin.toFixed(2));
		}

			$('#cut_margin_percentage').on('input', function() {
			pricewithcutmargin();
		});

		function pricewithcutmargin() {
			var cut_margin_percentage = parseFloat($('#cut_margin_percentage').val()) || 0;
			var purchase_cost = parseFloat($('#purchase_cost').val()) || 0;
			var retailAmount = (cut_margin_percentage / 100) * purchase_cost;
			var retailprice_withcutmargin = purchase_cost + retailAmount;
			$('#cut_margin_amt').val(retailprice_withcutmargin.toFixed(2));
		}*/
		
		
		//price calculation
		function calculatePackMarginAmount($row) {
		    const packMarginPercentage = parseFloat($row.find('.pack_margin_percentage').val()) || 0;
		    const purchaseCost = parseFloat($('#purchase_cost').val()) || 0;

		    const retailAmount = (packMarginPercentage / 100) * purchaseCost;
		    const packMarginAmount = purchaseCost + retailAmount;
		    $row.find('.pack_margin_amt').val(packMarginAmount.toFixed(2));
		}


		function calculateCutMarginAmount($row) {
		    const cutMarginPercentage = parseFloat($row.find('.cut_margin_percentage').val()) || 0;
		    const purchaseCost = parseFloat($('#purchase_cost').val()) || 0;

		    const retailAmount = (cutMarginPercentage / 100) * purchaseCost;
		    const cutMarginAmount = purchaseCost + retailAmount;
		    $row.find('.cut_margin_amt').val(cutMarginAmount.toFixed(2));
		}


		// Event delegation for pack margin percentage calculation
		$(document).on('input', '.pack_margin_percentage', function () {
		    const $row = $(this).closest('.input-group'); // Corrected row selector

		    calculatePackMarginAmount($row);
		});

		// Event delegation for cut margin percentage calculation

		$(document).on('input', '.cut_margin_percentage', function () {
		    const $row = $(this).closest('.input-group'); // Corrected row selector
		    calculateCutMarginAmount($row);
		});




		function calculatePurchaseCost() {
			var landingCost = parseFloat($('#basic_cost').val()) || 0;
			var gstRate = parseFloat($('#gst_percent').val()) || 0;

		
			var gstAmount = (gstRate / 100) * landingCost;
			var purchaseCost = landingCost + gstAmount;

			
			$('#purchase_cost').val(purchaseCost.toFixed(2));
		  }
		  
		  
		  $('#basic_cost').on('input', function() {
			calculatePurchaseCost();
			calculateRetailprice();
			updateWarehouseMargins();
		});

   
		$('#gst_percent').on('input', function() {
			calculatePurchaseCost();
			calculateRetailprice();
			updateWarehouseMargins()
		});


		function calculateRetailprice() {
			var profit_margin = parseFloat($('#profit_margin').val()) || 0;
			var purchase_cost = parseFloat($('#purchase_cost').val()) || 0;
			var retailAmount = (profit_margin / 100) * purchase_cost;
			var retailprice = purchase_cost + retailAmount;
			$('#retail_price').val(retailprice.toFixed(2));
		}

   
		$('#profit_margin').on('input', function() {
			calculateRetailprice();
			//updateWarehouseMargins()
		});
		
		
		
		function updateWarehouseMargins() {
	let purchaseCost = parseFloat($('#purchase_cost').val()) || 0;

	$('.datas').each(function () {
		let packMargin = parseFloat($(this).find('.pack_margin_percentage').val()) || 0;
		let cutMargin = parseFloat($(this).find('.cut_margin_percentage').val()) || 0;

		let packAmt = (purchaseCost * packMargin / 100) + purchaseCost;
		let cutAmt = (purchaseCost * cutMargin / 100) + purchaseCost;

		$(this).find('.pack_margin_amt').val(packAmt.toFixed(2));
		$(this).find('.cut_margin_amt').val(cutAmt.toFixed(2));
	});
}



	    $(document).on('input', '.pack_margin_percentage, .cut_margin_percentage', function () {
		updateWarehouseMargins();
	    });
    
		
		
		
		
		//end

		




		$('#company_id').select2({
        placeholder: "Select Company",   
        allowClear: true,
		search:true,
		          
    });

	$('#brand').select2({
        placeholder: "Select Brand",   
        allowClear: true,
		search:true,
		          
    });

	$('#unit_id').select2({
        placeholder: "Select Unit",   
        allowClear: true,
		search:true,
		          
    });

	$('#category').select2({
        placeholder: "Select Category",   
        allowClear: true,
		search:true,
		          
    });
	
	$('#subcategory').select2({
        placeholder: "Select Sub Category",   
        allowClear: true,
		search:true,
		          
    });
	


     });
	

 function validateDecimal(input) {
        // Ensure the value is a valid decimal number
        var value = input.value;
        var regex = /^\d*\.?\d{0,2}$/; // regex to allow two decimal places
        if (!regex.test(value)) {
            input.setCustomValidity("Please enter a valid decimal value with up to two decimal places.");
        } else {
            input.setCustomValidity("");
        }
    }

 document.getElementById("myForm").addEventListener("submit", function(event) {
        let submitBtn = document.getElementById("submitBtn");
        
        if (submitBtn.disabled) {
            event.preventDefault(); // Prevent form resubmission
            alert("Please wait, your info is submitted.");
        } else {
            submitBtn.disabled = true;
            submitBtn.innerText = "Submitting...";
        }
    });
    
    
    
               $("#unit_name").on("keyup blur", function (e) { 
        let unit = $(this).val();
       
            $.ajax({
                url: "{{ route('check_unit_exists') }}",
                type: "POST",
                data: {
                    unit: unit,
                    _token: "{{ csrf_token() }}"
                },
                success: function (response) {
                    if (response.exists) {
                        $("#unit-error").show(); 
                        $("#unit_name").addClass("error-field"); 
                        $("#unit_name").focus(); 
                        $("#submitunit").prop("disabled", true);
                        $("#unitmessage")
            .text("This unit is already used, try another.")
            .css({ "color": "red", "font-weight": "bold", "display": "block", "visibility": "visible" })
            .show();
                    } else {
                        $("#unit-error").hide(); 
                        $("#unit_name").removeClass("error-field"); 
                    }
                }
            });
         $("#submitunit").prop("disabled", false);
         $("#unitmessage").hide();
    });
    
    $("#unit_name").on("keydown", function (e) {
        if (e.key === "Tab" && $("#unit-error").is(":visible")) {
            e.preventDefault(); 
        }
    });
    
     document.getElementById("addUnitForm").addEventListener("submit", function(event) {
        let submitunit = document.getElementById("submitunit");

        
        if (submitunit.disabled) {
            event.preventDefault(); // Prevent form resubmission
            alert("Please wait, your info is submitted.");

        } else {
            submitunit.disabled = true;
            submitunit.innerText = "Submitting...";
        }
    });
    
    
           $("#brand_name").on("keyup blur", function (e) { 
        let brand = $(this).val();
       
            $.ajax({
                url: "{{ route('check_brand_exists') }}",
                type: "POST",
                data: {
                    brand: brand,
                    _token: "{{ csrf_token() }}"
                },
                success: function (response) {
                    if (response.exists) {
                        $("#brand-error").show(); 
                        $("#brand_name").addClass("error-field"); 
                        $("#brand_name").focus(); 
                        $("#submitbrand").prop("disabled", true);
                        $("#brandmessage")
            .text("This brand is already used, try another.")
            .css({ "color": "red", "font-weight": "bold", "display": "block", "visibility": "visible" })
            .show();
                    } else {
                        $("#brand-error").hide(); 
                        $("#brand_name").removeClass("error-field"); 
                    }
                }
            });
             $("#submitbrand").prop("disabled", false);
         $("#brandmessage").hide();
        
    });
    
    $("#brand_name").on("keydown", function (e) {
        if (e.key === "Tab" && $("#brand-error").is(":visible")) {
            e.preventDefault(); 
        }
    });
    
      document.getElementById("addBrandForm").addEventListener("submit", function(event) {
        let submitbrand = document.getElementById("submitbrand");
        
        if (submitbrand.disabled) {
            event.preventDefault(); // Prevent form resubmission
            alert("Please wait, your info is submitted.");
        } else {
            submitbrand.disabled = true;
            submitbrand.innerText = "Submitting...";
        }
    });
    
    
          $("#category_name").on("keyup blur", function (e) { 
        let category = $(this).val();
       
            $.ajax({
                url: "{{ route('check_category_exists') }}",
                type: "POST",
                data: {
                    category: category,
                    _token: "{{ csrf_token() }}"
                },
                success: function (response) {
                    if (response.exists) {
                        $("#category-error").show(); 
                        $("#category_name").addClass("error-field"); 
                        $("#category_name").focus(); 
                        $("#submitcategory").prop("disabled", true);
                        $("#categorymessage")
            .text("This category is already used, try another.")
            .css({ "color": "red", "font-weight": "bold", "display": "block", "visibility": "visible" })
            .show();
                    } else {
                        $("#category-error").hide(); 
                        $("#category_name").removeClass("error-field"); 
                    }
                }
            });
            $("#submitcategory").prop("disabled", false);
         $("#categorymessage").hide();
        
    });
    $("#category_name").on("keydown", function (e) {
        if (e.key === "Tab" && $("#category-error").is(":visible")) {
            e.preventDefault(); 
        }
    });
    
    document.getElementById("addCategoryForm").addEventListener("submit", function(event) {
        let submitcategory = document.getElementById("submitcategory");
        
        if (submitcategory.disabled) {
            event.preventDefault(); // Prevent form resubmission
            alert("Please wait, your info is submitted.");
        } else {
            submitcategory.disabled = true;
            submitcategory.innerText = "Submitting...";
        }
    });
    
     document.getElementById("addSubCategoryForm").addEventListener("submit", function(event) {
        let submitsubcategory = document.getElementById("submitsubcategory");
        
        if (submitsubcategory.disabled) {
            event.preventDefault(); // Prevent form resubmission
            alert("Please wait, your info is submitted.");
        } else {
            submitsubcategory.disabled = true;
            submitsubcategory.innerText = "Submitting...";
        }
    });
    
    
    
      $('#addSupplierForm').submit(function(e) {
    e.preventDefault(); 

    var supplierName = $('#supplier_name').val();
    var contact_person = $('#scontact_person').val();
	 var warehouse_id = $('#swarehouse_id').val();
    var email = $('#semail').val();
    var phone1 = $('#sphone1').val();
    var mobile = $('#smobile').val();
    var pincode = $('#spincode').val();
    var city = $('#scity').val();
    var state = $('#sstate').val();
    var address = $('#saddress').val();
    var gst_no = $('#sgst_no').val();
    var msme = $('#smsme').val();

    $.ajax({
        url: "{{ route('add_supplier_dynamic') }}",
        method: 'POST',
        data: {
            _token: '{{ csrf_token() }}',
            supplier_name: supplierName,
            contact_person: contact_person,
			warehouse_id:warehouse_id,
            email: email,
            phone1: phone1,
            mobile: mobile,
            city: city,
            state: state,
            pincode: pincode,
            address: address,
            gst_no: gst_no,
            msme: msme
        },
        success: function(response) {
            if (response.success) {
                $('#add-supplier').modal('hide');
                $('#addSupplierForm')[0].reset();
                var newOption = new Option(response.supplier.supplier_name, response.supplier.id, true, true);
                $('select[name="supplier_id[]"]').append(newOption).trigger('change'); // if using Select2
                Swal.fire({
                    icon: 'success',
                    title: 'Supplier added successfully!',
                    showConfirmButton: false,
                    timer: 2000
                });
            } else {
                alert('Failed to add supplier!');
            }
        },
        error: function(err) {
            console.log(err);
            alert('An error occurred while adding the supplier.');
        }
    });
});

</script>
<script>
function validateGST(input) {
    const gstRegex = /^[0-9]{2}[A-Z]{5}[0-9]{4}[A-Z]{1}[0-9]{1}[A-Z]{2}$/;
    const gstValue = input.value;

    if (gstValue.length < 15) {
        // Show error if user typed something but less than 15 chars
        if (gstValue.length > 0) {
            document.getElementById("gst-error").style.display = "block";
            document.getElementById("gst-error").textContent = "GSTIN must be 15 characters.";
            input.style.borderColor = "red";
        } else {
            document.getElementById("gst-error").style.display = "none";
            input.style.borderColor = "";
        }
        return;
    }

    if (gstRegex.test(gstValue)) {
        // Valid GST
        document.getElementById("gst-error").style.display = "none";
        input.style.borderColor = "#28a745";
    } else {
        // Invalid GST
        document.getElementById("gst-error").style.display = "block";
        input.style.borderColor = "red";
        input.value = ""; // Clear input

        // Force focus back
        setTimeout(() => {
            input.focus();
        }, 0);
    }
}
function validateMSME(input) {
    const msmeRegex = /^UDYAM-[A-Z]{2}-\d{2}-\d{7}$/;
    let msmeValue = input.value.trim().toUpperCase();
    input.value = msmeValue; // Always uppercase

    if (msmeValue.length === 0) {
        document.getElementById("msme-error").style.display = "none";
        input.style.borderColor = "";
        return;
    }

    if (msmeRegex.test(msmeValue)) {
        document.getElementById("msme-error").style.display = "none";
        input.style.borderColor = "#28a745";

        // Optional: Check uniqueness via AJAX
       
    } else {
        document.getElementById("msme-error").style.display = "block";
        document.getElementById("msme-error").textContent = "Invalid format. Use UDYAM-XX-00-0000000";
        input.style.borderColor = "red";
    }
}
</script>


	<script>
		$(document).ready(function() {
       
        $('#stop').val('');
        
      
        $('#sgst_no').on('input', function() {
            var gstNo = $(this).val(); 

            if (gstNo.length === 0) {
                
                $('#stop').val('');
            } else if (gstNo.includes('27')) {
               
                $('#stop').val('MSP');
            } else {
                
                $('#stop').val('OMS');
            }
        });
    });
	
	
	document.getElementById('imageInput').addEventListener('change', function (event) {
    const file = event.target.files[0];
    const preview = document.getElementById('imagePreview');

    if (file) {
        const reader = new FileReader();
        reader.onload = function (e) {
            preview.src = e.target.result;
            preview.style.display = 'block';
        };
        reader.readAsDataURL(file);
    } else {
        preview.src = '';
        preview.style.display = 'none';
    }
});
	</script>


	@include('layouts.footer')
