@include('layouts.header')
<!-- /Header -->
@include('layouts.sidebar')
<style>
    .select2-container--default .select2-selection--single {
        
        border: 1px solid #e9edf6 !important;
        height:40px !important; 
       
    }
    .select2-container .select2-selection--single .select2-selection__arrow {
        height: 100% !important;
        position: absolute !important;
        top: 0 !important;
        right: 0 !important;
        width: 20px !important; 
        background-color: transparent !important;
        border-left: 1px solid #aaa !important; 
    }
    
    .select2-container .select2-selection__arrow b {
      
        border-width: 5px 5px 0 5px !important; 
        border-style: solid !important;
        display: inline-block !important;
        margin-top: 5px !important;
        vertical-align: middle !important;
    }
    
    .select2-container--default .select2-selection--single .select2-selection__arrow 
    {
        display: none !important;
    }
    .select2-selection__clear{
        display: none !important;
        /* color:#aaa; */
    }
    
    </style>
    
<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="add-item d-flex">
                <div class="page-title">
                    <h4>Add Purchase Order</h4>
                    <h6>Create new purchase order</h6>
                </div>
            </div>
            <ul class="table-top-head">
                <li>
                    <div class="page-btn">
                        <a href="{{ route('purchase_orders') }}" class="btn btn-secondary"><i data-feather="arrow-left" class="me-2"></i>Back to Purchases</a>
                    </div>
                </li>
            </ul>
        </div>

        @if(session()->has('success'))
            <div class="alert alert-success">{{ session()->get('success') }}</div>
        @endif
        @if(session()->has('error'))
            <div class="alert alert-danger">{{ session()->get('error') }}</div>
        @endif

        <form action="{{ route('save_purchase_order')}}" method="post">
            @csrf
            <div class="card">
                <div class="card-body add-product pb-0">
                    <div class="accordion-card-one accordion" id="accordionExample">
                        <div class="accordion-item">
                            <div class="accordion-header" id="headingOne">
                                <div class="accordion-button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-controls="collapseOne">
                                    {{-- <h5><i data-feather="info"></i><span>Add Purchase</span></h5> --}}
                                </div>
                            </div>
                            <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="row">
                                        <div class="col-lg-2 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">PO Number</label>
                                                <input type="text" name="po_number" class="form-control" value="{{ $newPOId }}" readonly>
                                            </div>
                                        </div>
                                        <div class="col-lg-2 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">PO Date</label>
                                                <input type="date" name="po_date" class="form-control" >
                                            </div>
                                        </div>
                                        <div class="col-lg-2 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">Company</label>
                                                <select class="form-control" name="company">
                                                    <option value="">Select</option>
                                                    @foreach($companies as $row)
                                                        <option value="{{ $row->id }}">{{ $row->company_name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-3 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">Supplier</label>
                                                <select class="form-control" name="supplier" >
                                                    <option value="">Select</option>
                                                    @foreach($suppliers as $row)
                                                        <option value="{{ $row->id }}" data-top="{{ $row->top }}">{{ $row->supplier_name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-3 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">Transporter</label>
                                                <select class="form-control" name="transporter" >
                                                    <option value="">Select</option>
                                                    @foreach($transporters as $row)
                                                        <option value="{{ $row->id }}" >{{ $row->transporter_name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <div class="col-12">
                                            <h5>Order Items</h5>
                                            <div class="table-responsive">
                                                <table class="table table-bordered" id="order-items">
                                                    <thead>
                                                        <tr>
                                                            <th>Action</th>
                                                            <th>Design/Varient No</th>
                                                            <th>No Of Rolls</th>
                                                            <th>Quantity /Roll</th>
                                                            <th>Rate /Unit</th>
                                                            <th style="width: 30%">UOM</th>
                                                            <th>% GST</th>.
                                                            <th style="width: 60%">Amount</th>
                                                            <th>Net Amount</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr class="order-row">
                                                           
                                                                <td>
                                                                    <a href="#" class="btn btn-success add-item" style="color:white;background:green"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus-circle plus">
                                                                        <circle cx="12" cy="12" r="10"></circle>
                                                                        <line x1="12" y1="8" x2="12" y2="16"></line>
                                                                        <line x1="8" y1="12" x2="16" y2="12"></line>
                                                                    </svg></a>
                                                                </td>
                                                            
                                                            <td>
                                                                <select name="varient_id[]" class="form-control"  required>
                                                                <option value="">Select Varient</option>
                                                                @foreach($varients as $row)
                                                                <option value="{{ $row->id }}">{{ $row->varient_name}}-{{ $row->varient_code}}</option>
                                                                @endforeach    
                                                                </select>
                                                            </td>
                                                            <td><input type="text" name="no_of_rolls[]" class="form-control no_of_rolls"></td>
                                                            <td><input type="text" name="rate[]" onkeypress="return event.charCode >= 48 && event.charCode <= 57" class="form-control rate" required></td>
                                                            <td><input type="text" name="quantity[]" onkeypress="return event.charCode >= 48 && event.charCode <= 57" class="form-control quantity" required></td>
                                                            <td>
                                                                {{-- <input type="text" name="uom[]" class="form-control" > --}}
                                                                <select name="uom[]" class="form-control"  required>
                                                                    <option value="">Select Units</option>
                                                                    @foreach($units as $row)
                                                                    <option value="{{ $row->id }}">{{ $row->unit_name}}</option>
                                                                    @endforeach    
                                                                    </select>

                                                            </td>
                                                            <td><input type="text" name="gst_percent[]" class="form-control gst_percent" onkeypress="return event.charCode >= 48 && event.charCode <= 57" ></td>
                                                            <td><input type="text" name="total[]" class="form-control total" readonly></td>
                                                            <td><input type="text" name="net_total[]" class="form-control total" readonly></td>

                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <!-- Gross Total -->
                                        <div class="col-lg-4 offset-lg-8">
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">Gross Total:</label>
                                                <input type="number" name="subtotal" class="form-control" readonly>
                                            </div>
                                        </div>
                                        
                                        <!-- Forwarding Percentage and Amount -->
                                        <div class="col-lg-4 offset-lg-8">
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">Forwarding:</label>
                                                <div class="input-group" style="width: 50%;">
                                                    <input type="text" class="form-control forwarding_percent"  name="f_percent" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                                                    <span class="input-group-text">%</span>
                                                </div>
                                                <input type="text" name="f_amount" class="form-control ms-3 f_amount"  style="width: 50%;" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                                            </div>
                                        </div>
                                    
                                        <!-- Forwarding Amount -->
                                        <div class="col-lg-4 offset-lg-8">
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;margin-left: -55px">Forwarding Amount:</label>
                                                <input type="text" name="forwarding" class="form-control forwarding" readonly>
                                            </div>
                                        </div>
                                        
                                        <!-- GST Amount -->
                                        <div class="col-lg-4 offset-lg-8">
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;margin-left:-10px">GST Amount:</label>
                                                <input type="number" name="gst_amount" class="form-control" readonly>
                                            </div>
                                        </div>
                                    
                                        <!-- Final Amount -->
                                        <div class="col-lg-4 offset-lg-8">
                                            <div class="d-flex align-items-center">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;margin-left:-12px">Final Amount:</label>
                                                <input type="number" name="grand_total" class="form-control" readonly>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    
                                    <hr>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="d-flex align-items-center mb-2">
                                                <label class="form-label me-2">Note:</label>
                                                <input type="text" name="note" class="form-control"  >
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="btn-addproduct mb-4">
                    <a href="{{ route('purchase_orders') }}" class="btn btn-cancel me-2">Cancel</a>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </div>
        </form>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

{{-- <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>  --}}


@include('layouts.footer')

<script>
$(document).ready(function () {



    // Add Item Event
    $(document).on('click', '.add-item', function (e) {
        e.preventDefault();

        // Get the current row and update its button to 'Remove'
        let currentRow = $(this).closest('tr');
        currentRow.find('.add-item').replaceWith('<a href="#" class="btn btn-danger remove-item" style="color: white;"><svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-minus-circle minus"><circle cx="12" cy="12" r="10"></circle><line x1="8" y1="12" x2="16" y2="12"></line></svg></a>');

        // Clone the first row for a new entry
        let newRow = $('#order-items tbody tr:first').clone();
        newRow.find('input').val(''); // Clear input fields in the new row

        // Add the 'Add' button back for the new row
        newRow.find('.remove-item').replaceWith('<a href="#" class="btn btn-success add-item" style="color: white;">' +
            '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus-circle plus">' +
            '<circle cx="12" cy="12" r="10"></circle>' +
            '<line x1="12" y1="8" x2="12" y2="16"></line>' +
            '<line x1="8" y1="12" x2="16" y2="12"></line>' +
            '</svg>' +
            '</a>');
        // Append the new row to the table
        $('#order-items tbody').append(newRow);
    });

    // Remove Item Event
    $(document).on('click', '.remove-item', function (e) {
        e.preventDefault();
        $(this).closest('tr').remove();
        recalculateGstAmount();
        calculateTotal();
    });

    // Recalculate GST Amount for all rows
    function recalculateGstAmount() {
        let totalGSTAmount = 0;
        $('.gst_percent').each(function () {
            let row = $(this).closest('tr');
            let rowAmount = parseFloat(row.find('input[name="total[]"]').val()) || 0;
            let rowGstPercent = parseFloat($(this).val()) || 0;
            totalGSTAmount += rowAmount * rowGstPercent / 100;
        });

        $('input[name="gst_amount"]').val(totalGSTAmount.toFixed(2));
    }

    

      

    $(document).on('input', '.gst_percent', function () {
        // Get the current row
        let row = $(this).closest('tr');
        
        // Fetch amount and GST percentage values
        let amount = parseFloat(row.find('input[name="total[]"]').val()) || 0;
        let gstPercent = parseFloat($(this).val()) || 0;

        // Calculate net amount
        let netAmount = amount + (amount * gstPercent / 100);

        // Update the Net Amount field
        row.find('input[name="net_total[]"]').val(netAmount.toFixed(2));

        let totalGSTAmount = 0;
     $('.gst_percent').each(function () {
        let row = $(this).closest('tr');
        let rowAmount = parseFloat(row.find('input[name="total[]"]').val()) || 0;
        let rowGstPercent = parseFloat($(this).val()) || 0;
        totalGSTAmount += rowAmount * rowGstPercent / 100;
     });

     // Update the GST Amount field
     $('input[name="gst_amount"]').val(totalGSTAmount.toFixed(2));
     calculateTotal();
    });
    

    // Rate and Quantity Input Event
    $(document).on('input', '.no_of_rolls,.rate, .quantity', function () {
        let row = $(this).closest('tr');
        let no_of_rolls = parseFloat(row.find('.no_of_rolls').val()) || 0;
        let rate = parseFloat(row.find('.rate').val()) || 0;
        let quantity = parseFloat(row.find('.quantity').val()) || 0;
        let total = rate * quantity * no_of_rolls;
        row.find('.total').val(total.toFixed(2));
        
        calculateTotal();
    });

    $('input[name="forwarding"]').on('input', function () {
        calculateTotal();
   });


   $('input[name="forwarding_percent"], input[name="f_amount"]').on('input', function () {
    var forwarding_percent = parseFloat($('input[name="f_percent"]').val()) || 0; 
    var f_amount = parseFloat($('input[name="f_amount"]').val()) || 0;

    // Calculate the forwarding amount
    var forwarding = f_amount + (f_amount * forwarding_percent / 100);

  
    $('input[name="forwarding"]').val(forwarding.toFixed(2)); 
    calculateTotal();
 });

  
    function calculateTotal() {
        let subtotal = 0;
        $('#order-items tbody tr').each(function () {
            let total = parseFloat($(this).find('.total').val()) || 0;
            subtotal += total;
        });

        // Update subtotal
        $('input[name="subtotal"]').val(subtotal.toFixed(2));

        let forwarding = parseFloat($('input[name="forwarding"]').val()) || 0;
        let gst_amount = parseFloat($('input[name="gst_amount"]').val()) || 0;
        let grandTotal = subtotal + forwarding + gst_amount;


        $('input[name="grand_total"]').val(grandTotal.toFixed(2));
    }



    // $('#varient_id').select2({
    //     placeholder: "Select Varient",   
    //     allowClear: true,
	// 	search:true,
	// 	width:'100%',
	// 	height:'500px'                
    // });
});

</script>

