@include('layouts.header')
		<!-- /Header -->
		@include('layouts.sidebar')

		<div class="page-wrapper">
			<div class="content">
				<div class="page-header">
					<div class="add-item d-flex">
						<div class="page-title">
							<h4>Add Transporter</h4>
							<h6>Create new transporter</h6>
						</div>
					</div>
					<ul class="table-top-head">
						<li>
							<div class="page-btn">
								<a href="{{ route('transporters')}}" class="btn btn-secondary"><i data-feather="arrow-left" class="me-2"></i>Back to Transporter</a>
							</div>
						</li>
						<li>
							<a data-bs-toggle="tooltip" data-bs-placement="top" title="Collapse" id="collapse-header"><i data-feather="chevron-up" class="feather-chevron-up"></i></a>
						</li>
					</ul>
					
				</div>
				@if(session()->has('success'))
							<div class="alert alert-success">
								{{ session()->get('success') }}
							</div>
							@endif
							@if(session()->has('error'))
							<div class="alert alert-danger">
								{{ session()->get('error') }}
							</div>
						    @endif
				<!-- /add -->
				<form action="{{ route('save_transporter')}}" id="myForm" method="post">
					@csrf
					<div class="card">
						<div class="card-body add-product pb-0">
							<div class="accordion-card-one accordion" id="accordionExample">
								<div class="accordion-item">
									<div class="accordion-header" id="headingOne">
										<div class="accordion-button" data-bs-toggle="collapse" data-bs-target="#collapseOne"  aria-controls="collapseOne">
											<div class="addproduct-icon">
												<h5><i data-feather="info" class="add-info"></i><span>Transporter Information</span></h5>
												<a href="javascript:void(0);"><i data-feather="chevron-down" class="chevron-down-add"></i></a>
											</div>
										</div>
									</div>
									<div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
									<div class="accordion-body">
										
										<div class="row">
										<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Tranporter ID</label>
													<input type="text" name="transporter_id" class="form-control" value="{{ $newTransporter}}" readonly>
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Tranporter Name</label>
													<input type="text" name="transporter_name" class="form-control" id="transporter" placeholder="Enter Transporter Name" required><small id="transporter-error" style="color: red; display: none;">This transporter is already added!</small>
												</div>
											</div>
											
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Contact Person</label>
													<input type="text" name="contact_person" class="form-control" placeholder="Enter Contact Person" required>
												</div>
											</div>

											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Email</label>
													<input type="text" name="email" class="form-control" placeholder="Enter Email" required>
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Phone1</label>
													<input type="text" name="phone1" onkeypress="return event.charCode >= 48 && event.charCode <= 57 && this.value.length < 10" class="form-control" placeholder="Enter Phone1" required>
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="input-blocks add-product list">
													<label class="form-label">Phone2</label>
													<input type="text" name="phone2" class="form-control list" placeholder="Enter Phone2" onkeypress="return event.charCode >= 48 && event.charCode <= 57 && this.value.length < 10">
													
												</div>
											</div>

											
											 <div class="col-lg-3 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">GST No</label>
													
													<input type="text"   name="gst_no" class="form-control" id="gst_no" placeholder="Enter GST No" maxlength="15"  oninput="validateGST(this)">
												 <small id="gst-error" style="color:red; display:none;">Invalid GSTIN format</small>
												</div>
											</div>
										
											<div class="col-lg-3 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">MSME</label>
													<input type="text" name="msme" id="msme_number" class="form-control" placeholder="Enter MSME" >
												<small id="msme-error" class="text-danger"></small>
												</div>
											</div>
										 
                                            <div class="col-lg-12">
                                                <div class="input-blocks summer-description-box transfer mb-3">
                                                    <label>Address</label>
                                                    <textarea class="form-control h-100" rows="5" name="address" placeholder="Enter Address" required></textarea>
                                                    
                                                </div>
                                            </div>

											
											
											
											
										</div>


										<div class="row">
											<div class="col-lg-3 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">City</label>
													<input type="text" name="city" class="form-control" placeholder="Enter City" >
												</div>
											</div>
											<div class="col-lg-3 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">State</label>
													<input type="text" name="state" class="form-control" placeholder="Enter State" >
												</div>
											</div>
											<div class="col-lg-3 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">PIN Code</label>
													<input type="text" name="pincode" class="form-control" placeholder="Enter PIN Code" >
												</div>
											</div>
											
											
											
                                            <div class="col-lg-3 col-sm-6 col-12">
												<div class="input-blocks add-product list">
                                                    <label class="form-label">Status</label>
                                            <select class="select" name="status">
                                                <option>Choose Status</option>
                                                <option value="1">Active</option>
                                                <option value="0">Inactive</option>
                                            </select>
                                        </div>
                                    </div>
										</div>

									

									
									</div>
									</div>
								</div>
							</div>
							
						</div>
					</div>
					<div class="col-lg-12">
						<div class="btn-addproduct mb-4">
							<a href="{{ route('transporters') }}" class="btn btn-cancel me-2">Cancel</a>
							<button type="submit" id="submitBtn" class="btn btn-submit">Save Transporter</button><p id="message" style="color: red;">
						</div>
					</div>
				</form>
			<!-- /add -->

		</div>
	</div>
	</div>
	<!-- /Main Wrapper -->
	@include('layouts.footer')
<script>
	 document.getElementById("myForm").addEventListener("submit", function(event) {
        let submitBtn = document.getElementById("submitBtn");
        
        if (submitBtn.disabled) {
            event.preventDefault(); // Prevent form resubmission
            alert("Please wait, your info is submitted.");
        } else {
            submitBtn.disabled = true;
            submitBtn.innerText = "Submitting...";
        }
    });
    
     $("#transporter").on("keyup blur", function (e) { 
        let transporter = $(this).val();
        // alert(transporter);
       
            $.ajax({
                url: "{{ route('check_transporter_exists') }}",
                type: "POST",
                data: {
                    transporter: transporter,
                    _token: "{{ csrf_token() }}"
                },
                success: function (response) {
                    if (response.exists) {
                        $("#transporter-error").show(); 
                        $("#transporter").addClass("error-field"); 
                        $("#transporter").focus(); 
                         $("#submitBtn").prop("disabled", true);
                        $("#message")
            .text("This transporter  name is already used, try another.")
            .css({ "color": "red", "font-weight": "bold", "display": "block", "visibility": "visible" })
            .show();
                    } else {
                        $("#transporter-error").hide(); 
                        $("#transporter").removeClass("error-field"); 
                    }
                }
            });
            $("#submitBtn").prop("disabled", false);
         $("#message").hide();
        
    });
    
    $("#transporter").on("keydown", function (e) {
        if (e.key === "Tab" && $("#transporter-error").is(":visible")) {
            e.preventDefault(); 
        }
    });
    
    </script>

	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

	<script>
		$(document).ready(function() {
       
        $('#top').val('');
        
      
        $('#gst_no').on('input', function() {
            var gstNo = $(this).val(); 

            if (gstNo.length === 0) {
                
                $('#top').val('');
            } else if (gstNo.includes('27')) {
               
                $('#top').val('MSP');
            } else {
                
                $('#top').val('OMS');
            }
        });
    });	</script>
    <script>
document.getElementById("gst_no").addEventListener("input", function() {
    if (this.value.length > 15) {
        alert("GST No length is 15.");
        this.value = this.value.substring(0, 15);
       
    }
});

document.getElementById("gst_no").addEventListener("blur", function() {
    if (this.value.length !== 15) {
        if (!this.dataset.alertShown) { 
            alert("GST number must be exactly 15 characters.");
            this.dataset.alertShown = "true"; 
        }
        this.focus();
    } else {
        this.dataset.alertShown = ""; 
    }
});

document.addEventListener("DOMContentLoaded", function () {
    const textbox = document.getElementById("myTextbox");
    if (textbox) {
        textbox.addEventListener("input", function () {
            this.dataset.alertShown = "";
        });
    } else {
        console.error("Element with ID 'myTextbox' not found!");
    }
});


</script>

	<script>
function validateGST(input) {
    input.value = input.value.toUpperCase().replace(/[^0-9A-Z]/g, '');

    const gstRegex = /^[0-9]{2}[A-Z]{5}[0-9]{4}[A-Z]{1}[0-9]{1}[A-Z]{2}$/;
    const gstValue = input.value;

    const errorBox = document.getElementById("gst-error");

    if (gstValue.length < 15) {
        if (gstValue.length > 0) {
            errorBox.style.display = "block";
            errorBox.textContent = "GSTIN must be 15 characters.";
            input.style.borderColor = "red";
        } else {
            errorBox.style.display = "none";
            input.style.borderColor = "";
        }
        return;
    }

    if (gstRegex.test(gstValue)) {
        // Call backend to check for duplicates
        fetch(`/check-gst-exists-transporter/${gstValue}`)
            .then(response => response.json())
            .then(data => {
                if (data.exists) {
                    errorBox.style.display = "block";
                    errorBox.textContent = "This GSTIN is already in use.";
                    input.style.borderColor = "red";

                    // Show alert
                    alert("This GSTIN is already registered!");

                    // Clear input
                    input.value = "";
                    setTimeout(() => input.focus(), 0);
                } else {
                    errorBox.style.display = "none";
                    input.style.borderColor = "#28a745";
                }
            })
            .catch(() => {
                errorBox.style.display = "block";
                errorBox.textContent = "Error checking GSTIN.";
                input.style.borderColor = "red";
            });

    } else {
        errorBox.style.display = "block";
        errorBox.textContent = "Invalid GSTIN format.";
        input.style.borderColor = "red";
        input.value = "";
        setTimeout(() => input.focus(), 0);
    }
}

</script>
<script>
 const pattern = /^UDYAM-[A-Z]{2}-\d{2}-\d{7}$/;

// Convert input to uppercase while typing
$('#msme_number').on('input', function () {
    this.value = this.value.toUpperCase();
    $('#msme-error').text('');
    $('#submitBtn').prop('disabled', true); // Always disable while typing
});

// Validate on blur
$('#msme_number').on('blur', function () {
    const msme = $(this).val().trim();
    $('#msme-error').text('');
    $('#submitBtn').prop('disabled', true); // Disable initially

    // Format check
    if (!pattern.test(msme)) {
        $('#msme-error').text('Invalid format. Use UDYAM-XX-00-0000000');
        return;
    }

    // AJAX check if MSME already exists
    $.ajax({
        url: '/check-msme-transporter',
        type: 'POST',
        data: {
            _token: '{{ csrf_token() }}',
            msme_number: msme
        },
        success: function (response) {
            if (response.exists) {
                $('#msme-error').text('MSME/Udyam number already exists.');
                $('#submitBtn').prop('disabled', true);
            } else {
                $('#submitBtn').prop('disabled', false); // ✅ Enable if valid and unique
            }
        },
        error: function () {
            $('#msme-error').text('Server error occurred.');
            $('#submitBtn').prop('disabled', true);
        }
    });
});

</script>
