@include('layouts.header')
@include('layouts.sidebar')


<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="add-item d-flex">
                <div class="page-title">
                    <h4>All Invoices</h4>
                    <h6>Manage Your Invoices</h6>
                </div>
            </div>
           <!--  <ul class="table-top-head">
                <li>
                    <div class="page-btn">
                        <a href="{{ route('invoices') }}" class="btn btn-secondary"><i data-feather="arrow-left" class="me-2"></i>Back to Invoices</a>
                    </div>
                </li>
            </ul> -->
        </div>

        @if(session()->has('success'))
            <div class="alert alert-success">{{ session()->get('success') }}</div>
        @endif
        @if(session()->has('error'))
            <div class="alert alert-danger">{{ session()->get('error') }}</div>
        @endif



        <div class="table-responsive">
		    <table class="table table-hover" id="invoiceTable">
		        <thead>
		            <tr>
		            	<th>Actions</th>
		                <th>Sr.No</th>
		                <!-- <th>Product Image</th> -->
		                <th>Product Name</th>
		                <th>HSN Code</th>
		                <!-- <th>Description</th> -->
		                <th>Roll Size</th>
		                <th>Thickness</th>
		                <th>Roll Quantity</th>
		            </tr>
		        </thead>
		        <tbody>
		            @forelse($products as $index => $product)
		                <tr>
		                	<td class="action-table-data">
								<div class="edit-delete-action">
									<a class="me-2 p-2" href="{{ url('view-invoice/'.$product->id)}}" title="View Invoice">

										<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-eye action-eye"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle></svg>
									</a>
									<!-- <a class="confirm-text p-2 delete-action" data-id="" href="javascript:void(0);">
										<i data-feather="trash-2" class="feather-trash-2"></i>
									</a> -->
								</div>
												
							</td>
		                    <td>{{ $index + 1 }}</td>

		                    <!-- {{-- Product Image --}}
		                    <td>
		                        @if(!empty($product->product_image))
		                            <img src="{{ asset('uploads/products/' . $product->product_image) }}" alt="Product Image" width="60">
		                        @else
		                            <img src="{{ asset('assets/img/no-image.png') }}" alt="No Image" width="60">
		                        @endif
		                    </td> -->

		                    {{-- Product Name --}}
		                    <td>{{ $product->product_name ?? 'N/A' }}</td>

		                    {{-- HSN Code --}}
		                    <td>{{ $product->hsn_code ?? 'N/A' }}</td>

		                   <!--  {{-- Description --}}
							<td style="max-width: 550px; white-space: normal; word-wrap: break-word;">
							    {!! \Illuminate\Support\Str::limit($product->description ?? 'N/A', 10) !!}
							</td> -->

		                    {{-- Roll Size --}}
		                    <td>{{ $product->roll_size ?? 'N/A' }}</td>

		                    {{-- Thickness --}}
		                    <td>{{ $product->thickness ?? 'N/A' }}</td>

		                    {{-- Quantity --}}
		                    <td>{{ $product->quantityroll ?? '0' }}</td>
		                </tr>
		            @empty
		                <tr>
		                    <td colspan="8" class="text-center text-muted">No products found.</td>
		                </tr>
		            @endforelse
		        </tbody>
		    </table>
		</div>
    </div>
</div>
@include('layouts.footer')
<script>
    $(document).ready(function () {
        $('.table').DataTable({
            pageLength: 10,
            ordering: true,
            searching: true,
            responsive: true
        });
    });
</script>


