@include('layouts.header')			
		@include('layouts.sidebar')
			
			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>Company List</h4>
								<h6>Manage your Company</h6>
							</div>
						</div>
						{{-- <ul class="table-top-head">
							<li>
								<a data-bs-toggle="tooltip" data-bs-placement="top" title="Pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
							</li>
							<li>
								<a data-bs-toggle="tooltip" data-bs-placement="top" title="Excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
							</li>
							<li>
								<a data-bs-toggle="tooltip" data-bs-placement="top" title="Print"><i data-feather="printer" class="feather-rotate-ccw"></i></a>
							</li>
							<li>
								<a data-bs-toggle="tooltip" data-bs-placement="top" title="Refresh"><i data-feather="rotate-ccw" class="feather-rotate-ccw"></i></a>
							</li>
							<li>
								<a data-bs-toggle="tooltip" data-bs-placement="top" title="Collapse" id="collapse-header"><i data-feather="chevron-up" class="feather-chevron-up"></i></a>
							</li>
						</ul> --}}
						<div class="page-btn">
							<a href="{{ route('add_company')}}" class="btn btn-added"><i data-feather="plus-circle" class="me-2"></i>Add New Company</a>
						</div>	
						{{-- <div class="page-btn import">
							<a href="#" class="btn btn-added color" data-bs-toggle="modal" data-bs-target="#view-notes"><i
								data-feather="download" class="me-2"></i>Import Company</a>
						</div> --}}
					</div>
					
					<!-- /Company list -->
					<div class="card table-list-card">
						<div class="card-body">
							<div class="table-top">
								<div class="search-set">
									<div class="search-input">
										<a href="javascript:void(0);" class="btn btn-searchset"><i data-feather="search" class="feather-search"></i></a>
									</div>
								</div>
								<!--<div class="search-path">
									<a class="btn btn-filter" id="filter_search">
										<i data-feather="filter" class="filter-icon"></i>
										<span><img src="assets/img/icons/closes.svg" alt="img"></span>
									</a>
								</div>
								<div class="form-sort">
									<i data-feather="sliders" class="info-img"></i>
									<select class="select">
										<option>Sort by Date</option>
										<option>14 09 23</option>
										<option>11 09 23</option>
									</select>
								</div>-->
							</div>
							<!-- /Filter -->
							<div class="card mb-0" id="filter_inputs">
								<div class="card-body pb-0">
									<div class="row">
										<div class="col-lg-12 col-sm-12">
											<div class="row">
												<div class="col-lg-2 col-sm-6 col-12">
													<div class="input-blocks">
														<i data-feather="box" class="info-img"></i>
														<select class="select">
															<option>Choose Company</option>
															<option>
																Lenovo 3rd Generation</option>
															<option>Nike Jordan</option>
														</select>
													</div>
												</div>
												<div class="col-lg-2 col-sm-6 col-12">
													<div class="input-blocks">
														<i data-feather="stop-circle" class="info-img"></i>
														<select class="select">
															<option>Choose Categroy</option>
															<option>Laptop</option>
															<option>Shoe</option>
														</select>
													</div>
												</div>
												
												<div class="col-lg-2 col-sm-6 col-12">
													<div class="input-blocks">
														<i data-feather="git-merge" class="info-img"></i>
														<select class="select">
															<option>Choose Sub Category</option>
															<option>Computers</option>
															<option>Fruits</option>
														</select>
													</div>
												</div>
												
												<div class="col-lg-2 col-sm-6 col-12">
													<div class="input-blocks">
														<i data-feather="stop-circle" class="info-img"></i>
														<select class="select">
															<option>All Brand</option>
															<option>Lenovo</option>
															<option>Nike</option>
														</select>
													</div>
												</div>
												
												<div class="col-lg-2 col-sm-6 col-12">
													<div class="input-blocks">
														<i class="fas fa-money-bill info-img"></i>
														<select class="select">
															<option>Price</option>
															<option>$12500.00</option>
															<option>$12500.00</option>
														</select>
													</div>
												</div>
												<div class="col-lg-2 col-sm-6 col-12">
													<div class="input-blocks">
														<a class="btn btn-filters ms-auto"> <i data-feather="search" class="feather-search"></i> Search </a>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>

							@if(session()->has('success'))
							<div class="alert alert-success">
								{{ session()->get('success') }}
							</div>
							@endif
							@if(session()->has('error'))
							<div class="alert alert-danger">
								{{ session()->get('error') }}
							</div>
						    @endif
							<!-- /Filter -->
							<div class="table-responsive Company-list">
								<table class="table datanew">
									<thead>
										<tr>
										<th class="no-sort">Action</th>
											<th>Company Code</th>
											<th>Name</th>
											<th>City</th>
											<!--<th>Address</th>-->
											<th>Phone</th>
											<!--<th>Warehouse</th>-->
											<th>Status</th>
											
										</tr>
									</thead>
									<tbody>
										@foreach($companies as $row)
										<?php
										
										$warehouses = DB::table('warehouse_company')
											->join('warehouses', 'warehouse_company.warehouse_id', '=', 'warehouses.id')
											->where('warehouse_company.company_id', $row->id)
											->pluck('warehouses.warehouse_name')
											->toArray(); 
										?>
										<tr>
													
											<td class="action-table-data">
												<div class="edit-delete-action">
													 <a class="me-2 edit-icon p-2" href="{{ url('view-company/'.$row->id)}}" Title="View">
														<i data-feather="eye" class="action-eye"></i>
													</a> 
													<a class="me-2 p-2" href="{{ url('edit-company/'.$row->id)}}" Title="Edit">
														<i data-feather="edit" class="feather-edit"></i>
													</a>
													<a class="confirm-text p-2 delete-action" data-id="{{ $row->id}}" href="javascript:void(0);" Title="Delete">
														<i data-feather="trash-2" class="feather-trash-2"></i>
													</a>
												</div>	
											</td>
											<td>{{ $row->company_id}}</td>
											<td>{{ $row->company_name}}</td>
											<td>{{ $row->city}}</td>
						
											<!--<td>{{ $row->address}}</td>-->
											<td>{{ $row->phone1}}</td>
											<!--<td>{{ implode(', ', $warehouses) }}</td>-->
											<td>@if($row->status==1)<a href="{{ url('inactive_company/'.$row->id)}}"><span class="badge badge-linesuccess">Active</span></a>@else
                                                <a href="{{ url('active_company/'.$row->id)}}"><span class="badge badge-linedanger">Inactive</span></a>
                                            @endif</td>
									
										</tr>
										@endforeach
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<!-- /Company list -->
				</div>
			</div>
        </div>
		<!-- /Main Wrapper -->
		<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
		<script>
			$(document).ready(function () {

				$.ajaxSetup({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					}
				});

				$(document).on('click', '.delete-action', function (e) {
					
					e.preventDefault();
					var userId = $(this).data('id');
					
					var deleteUrl = "{{ url('delete-company') }}/" + userId;

					Swal.fire({
						title: 'Are you sure?',
						text: "You won't be able to revert this!",
						icon: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Yes, delete it!'
					}).then((result) => {
						if (result.isConfirmed) {
							$.ajax({

								
								url: deleteUrl,
								method: 'DELETE',
								success: function (response) {
									Swal.fire(
										'Deleted!',
										'Company has been deleted.',
										'success'
									).then(() => {
										location.reload(); // Refresh the page to reflect the changes
									});
								},
								error: function (xhr, status, error) {
									Swal.fire(
										'Error!',
										'There was a problem deleting the user.',
										'error'
									);
								}
							});
						}
					});
				});

			});
		</script>	
		
		@include('layouts.footer')
