@include('layouts.header')			
		@include('layouts.sidebar')
			
			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>Coupons</h4>
								<h6>Manage your Coupons</h6>
							</div>
						</div>
						
						<div class="page-btn">
							<a href="{{ route('add_coupon')}}" class="btn btn-added"><i data-feather="plus-circle" class="me-2"></i>Add New Coupon</a>
						</div>	
						
					</div>
					
					<!-- /Company list -->
					<div class="card table-list-card">
						<div class="card-body">
							<div class="table-top">
								<div class="search-set">
									<div class="search-input">
										<a href="javascript:void(0);" class="btn btn-searchset"><i data-feather="search" class="feather-search"></i></a>
									</div>
								</div>
								
							</div>
							<!-- /Filter -->
							

							@if(session()->has('success'))
							<div class="alert alert-success">
								{{ session()->get('success') }}
							</div>
							@endif
							@if(session()->has('error'))
							<div class="alert alert-danger">
								{{ session()->get('error') }}
							</div>
						    @endif
							<!-- /Filter -->
							<div class="table-responsive Company-list">
								<table class="table datanew">
									<thead>
										<tr>
										<th class="no-sort">Action</th>
											<th>Coupon Code</th>
											<th>Image</th>
											<th>Start Date</th>
											<th>End Date</th>
											<th>Discount Type</th>
											<th>Discount Value</th>
											<th>status</th>
											
										</tr>
									</thead>
									<tbody>
										@foreach($coupons as $row)
										
										<tr>
										<td class="action-table-data">
												<div class="edit-delete-action">
													
													<a class="me-2 p-2" href="{{ url('edit-coupon/'.$row->id)}}">
														<i data-feather="edit" class="feather-edit"></i>	
													</a>
													<a class="confirm-text p-2 delete-action" data-id="{{ $row->id}}" href="javascript:void(0);">
														<i data-feather="trash-2" class="feather-trash-2"></i>
													</a>
												</div>	
											</td>
											
											<td>{{ $row->coupon_code}}</td>
											<td><img src="{{ url('uploads/coupons/'.$row->coupon_image)}}" style="height:50px;width:100px"></td>
											<td>{{ \Carbon\Carbon::parse($row->start_date)->format('d-m-Y') }}
                                            </td>
											<td>{{ \Carbon\Carbon::parse($row->end_date)->format('d-m-Y') }}
                                            </td>
											<td>{{ $row->discount_type}}</td>
											<td><?php if($row->discount_type=='percentage'){ echo $row->discount_value.'%';}else{ echo $row->discount_value;}?></td>
											<td>@if($row->is_active==1)<a href="{{ url('inactive_coupon/'.$row->id)}}"><span class="badge badge-linesuccess">Active</span></a>@else
                                                <a href="{{ url('active_coupon/'.$row->id)}}"><span class="badge badge-linedanger">Inactive</span></a>
                                            @endif</td>
											
											
										</tr>
										@endforeach
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<!-- /Company list -->
				</div>
			</div>
        </div>
		<!-- /Main Wrapper -->
		<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
		<script>
			$(document).ready(function () {

				$.ajaxSetup({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					}
				});

				$(document).on('click', '.delete-action', function (e) {
					
					e.preventDefault();
					var userId = $(this).data('id');
					
					var deleteUrl = "{{ url('delete-coupon') }}/" + userId;

					Swal.fire({
						title: 'Are you sure?',
						text: "You won't be able to revert this!",
						icon: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Yes, delete it!'
					}).then((result) => {
						if (result.isConfirmed) {
							$.ajax({

								
								url: deleteUrl,
								method: 'DELETE',
								success: function (response) {
									Swal.fire(
										'Deleted!',
										'Coupon has been deleted.',
										'success'
									).then(() => {
										location.reload(); // Refresh the page to reflect the changes
									});
								},
								error: function (xhr, status, error) {
									Swal.fire(
										'Error!',
										'There was a problem deleting the user.',
										'error'
									);
								}
							});
						}
					});
				});

			});
		</script>	
		
		@include('layouts.footer')
