@include('layouts.header')
		<!-- /Header -->
		@include('layouts.sidebar')

		<div class="page-wrapper">
			<div class="content">
				<div class="page-header">
					<div class="add-item d-flex">
						<div class="page-title">
							<h4>Edit Installer</h4>
							
						</div>
					</div>
					<ul class="table-top-head">
						<li>
							<div class="page-btn">
								<a href="{{ route('installer')}}" class="btn btn-secondary"><i data-feather="arrow-left" class="me-2"></i>Back to Installer</a>
							</div>
						</li>
						<li>
							<a data-bs-toggle="tooltip" data-bs-placement="top" title="Collapse" id="collapse-header"><i data-feather="chevron-up" class="feather-chevron-up"></i></a>
						</li>
					</ul>
					
				</div>
				@if(session()->has('success'))
							<div class="alert alert-success">
								{{ session()->get('success') }}
							</div>
							@endif
							@if(session()->has('error'))
							<div class="alert alert-danger">
								{{ session()->get('error') }}
							</div>
						    @endif
				<!-- /add -->
				<form action="{{ route('update_installer')}}" method="post">
					@csrf
                    <input type="hidden" name="id" value="{{ $installer->id}}">
					<div class="card">
						<div class="card-body add-product pb-0">
							<div class="accordion-card-one accordion" id="accordionExample">
								<div class="accordion-item">
									<div class="accordion-header" id="headingOne">
										<div class="accordion-button" data-bs-toggle="collapse" data-bs-target="#collapseOne"  aria-controls="collapseOne">
											<div class="addproduct-icon">
												<h5><i data-feather="info" class="add-info"></i><span>Installer Information</span></h5>
												<a href="javascript:void(0);"><i data-feather="chevron-down" class="chevron-down-add"></i></a>
											</div>
										</div>
									</div>
									<div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
									<div class="accordion-body">
										
										<div class="row">
												<div class="col-lg-6 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Installer ID </label>
													<input type="text" name="installer_id" id="installer_id" class="form-control" value="{{$installer->installer_id}}" readonly>
												</div>
											</div>
											<div class="col-lg-6 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<div class="add-newplus">
														<label class="form-label">Installer</label>
														<!-- <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#add-units-brand"><i data-feather="plus-circle" class="plus-down-add"></i><span>Add New</span></a> -->
													</div>
													<input name="user_id" type="hidden" class="form-control" value="{{ $installer->user_id }}">
													<select class="form-control" disabled>
														<option value="">Select</option>
														@foreach($users as $row)
															<option value="{{ $row->id }}" {{ (int)$installer->user_id === (int)$row->id ? 'selected' : '' }}>
																{{ $row->full_name }}
															</option>
														@endforeach
													</select>

												</div>
											</div>
										
										
											
											
											
										</div>

										<div class="row">
											
											
											<div class="col-lg-6 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Phone1</label>
													<input type="text" name="phone1" class="form-control" value="{{ $installer->phone1 }}" onkeypress="return event.charCode >= 48 && event.charCode <= 57" required>
												</div>
											</div>
											<div class="col-lg-6 col-sm-6 col-12">
												<div class="input-blocks add-product list">
													<label class="form-label">Phone2</label>
													<input type="text" name="phone2" class="form-control list" value="{{ $installer->phone2}}" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
													
												</div>
											</div>
											
										</div>
										<!-- Editor -->
                                        <div class="col-lg-12">
                                            <div class="input-blocks summer-description-box transfer mb-3">
                                                <label>Address</label>
                                                <textarea class="form-control h-100" rows="5" required name="address" placeholder="Enter Address">{{$installer->address}}</textarea>
                                                <p class="mt-1">Maximum 60 Characters</p>
                                            </div>
                                        </div>
                                        <!-- /Editor -->
										<div class="row">
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">City</label>
													<input type="text" name="city" class="form-control" value="{{ $installer->city}}">
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">State</label>
													<input type="text" name="state" class="form-control" value="{{ $installer->state}}">
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">PIN Code</label>
													<input type="text" name="pincode" class="form-control" value="{{ $installer->pincode}}" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
												</div>
											</div>
										</div>
										
										

										     <div class="row mb-3">
												<div class="col-12">
													<h5>Installer Charges </h5><br>
													
													<div class="table-responsive">
														<table class="table table-bordered" id="order-items">
															<thead>
																<tr>
																	<th>Action</th>
																	<th>Product</th>
																	<th>Rate/SqFt</th>
																
																	
																</tr>
															</thead>
															<tbody>

																@foreach($charges as $item)
															
																<tr class="order-row">
																
																		<td>
																			<a href="#" class="btn btn-success add-item" style="color:white;background:green"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus-circle plus">
																				<circle cx="12" cy="12" r="10"></circle>
																				<line x1="12" y1="8" x2="12" y2="16"></line>
																				<line x1="8" y1="12" x2="16" y2="12"></line>
																			</svg></a>
																		</td>
																		<td>
																		<select name="product_id[]" class="form-control product-select" required>
																		<option value="">Select Product</option>
																		@foreach($products as $product)
								
																		<option value="{{ $product->id }}" {{ $item->product_id == $product->id ? 'selected' : '' }}>
																				{{ $product->product_name }}
																			</option>
																		@endforeach
																	
																		</select>
																	</td> 
																	
																		<td>
																			<input type="text" name="rate[]"  class="form-control rate" step="0.01" oninput="this.value = this.value.replace(/[^0-9.]/g, '')"
                                                              pattern="^\d*\.?\d*$" value="{{ $item->rate}}"  required>
																		</td>
																		
																</tr>
																@endforeach
															</tbody>
														</table>
													</div>
												</div>
											</div>
										
									</div>
									</div>
								</div>
							</div>
							
						</div>
					</div>
					<div class="col-lg-12">
						<div class="btn-addproduct mb-4">
							<a href="{{ url('installer')}}" class="btn btn-cancel me-2">Cancel</a>
							<button type="submit" class="btn btn-submit">Update Installer</button>
						</div>
					</div>
				</form>
			<!-- /add -->

		</div>
	</div>
	</div>

	<div class="modal fade" id="add-units-brand">
		<div class="modal-dialog modal-dialog-centered custom-modal-two">
			<div class="modal-content">
				<div class="page-wrapper-new p-0">
					<div class="content">
						<div class="modal-header border-0 custom-modal-header">
							<div class="page-title">
								<h4>Add New Installer</h4>
							</div>
							<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body custom-modal-body">
							<form id="addInstallerForm">
							@csrf
							<div class="mb-3">
								<label class="form-label">Installer</label>
								<input type="text" name="name" id="installer_name" class="form-control" required> 
							</div>
							<div class="modal-footer-btn">
								<a href="javascript:void(0);" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</a>
								<input type="submit" class="btn btn-submit" name="submit" value="Submit">
							</div>
						</form>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- /Main Wrapper -->
	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script type="text/javascript">
$(document).ready(function () {

    // Replace all existing Add buttons with Remove buttons except the last add-row
    $('#order-items tbody tr').each(function () {
        $(this).find('.add-item').replaceWith('<a href="#" class="btn btn-danger remove-item" style="color: white;"><svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-minus-circle minus"><circle cx="12" cy="12" r="10"></circle><line x1="8" y1="12" x2="16" y2="12"></line></svg></a>');
    });

    const initialRow = '<tr class="add-row">' +
        '<td>' +
        '<a href="#" class="btn btn-success add-item" style="color: white;">' +
        '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus-circle plus">' +
        '<circle cx="12" cy="12" r="10"></circle>' +
        '<line x1="12" y1="8" x2="12" y2="16"></line>' +
        '<line x1="8" y1="12" x2="16" y2="12"></line>' +
        '</svg>' +
        '</a>' +
        '</td>' +
        '</tr>';

    // Append the initial row with only the Add button
    $('#order-items tbody').append(initialRow);

    // Function to create the new row with input fields
    const addItemRow = function () {
        return '<tr class="order-row">' +
            '<td>' +
            '<a href="#" class="btn btn-danger remove-item" style="color: white;">' +
            '<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-minus-circle minus">' +
            '<circle cx="12" cy="12" r="10"></circle>' +
            '<line x1="8" y1="12" x2="16" y2="12"></line>' +
            '</svg>' +
            '</a>' +
            '</td>' +
            '<td><select name="product_id[]" class="form-control product-select" required>' +
            '<option value="">Select Product</option>' +
            '@foreach($products as $row)<option value="{{ $row->id }}">{{ $row->product_name }}</option>@endforeach' +
            '</select></td>' +
            '<td><input type="text" name="rate[]" class="form-control rate" step="0.01" required oninput="this.value = this.value.replace(/[^0-9.]/g, \'\')"></td>' +
            '</tr>';
    };

    // Function to update product options dynamically
    function updateProductOptions() {
        var selectedProducts = [];

        // Collect all selected products
        $('.product-select').each(function () {
            if ($(this).val()) {
                selectedProducts.push($(this).val());
            }
        });

        // Update options for all selects
        $('.product-select').each(function () {
            var currentVal = $(this).val();

            $(this).find('option').each(function () {
                var optionVal = $(this).val();

                if (optionVal && optionVal !== currentVal && selectedProducts.includes(optionVal)) {
                    $(this).hide(); // Hide if already selected in another row
                } else {
                    $(this).show(); // Show if not selected
                }
            });
        });
    }

    // Add Item Event
    $(document).on('click', '.add-item', function (e) {
        e.preventDefault();

        let newRow = addItemRow();
        $('.add-row').before(newRow);
        updateProductOptions();
    });

    // Remove Item Event
    $(document).on('click', '.remove-item', function (e) {
        e.preventDefault();
        $(this).closest('tr').remove();
        updateProductOptions();
    });

    // When product changes, update dropdowns
    $(document).on('change', '.product-select', function () {
        updateProductOptions();
    });

    // Initial call
    updateProductOptions();

    // Existing code for product code generation and installer AJAX remains unchanged...
});
</script>
	
	
	@include('layouts.footer')
