
@include('layouts.header')
@include('layouts.sidebar')

		<div class="page-wrapper">
			<div class="content">
				<div class="row">
					<div class="col-xl-3 col-sm-6 col-12 d-flex">
						<div class="dash-widget w-100">
							<div class="dash-widgetimg">
								<span><img src="assets/img/icons/dash1.svg" alt="img"></span>
							</div>
							<div class="dash-widgetcontent">
								<h5><span class="counters" data-count="{{$purchase_orders ?? '0'}}">{{$purchase_orders ?? '0'}}</span></h5>
								<h6>Total Purchase </h6>
							</div>
						</div>
					</div>
					<div class="col-xl-3 col-sm-6 col-12 d-flex">
						<div class="dash-widget dash1 w-100">
							<div class="dash-widgetimg">
								<span><img src="assets/img/icons/dash2.svg" alt="img"></span>
							</div>
							<div class="dash-widgetcontent">
								<h5><span class="counters" data-count="{{$orders ?? '0'}}">{{$orders ?? '0'}}</span></h5>
								<h6>Total Sales </h6>
							</div>
						</div>
					</div>
					<div class="col-xl-3 col-sm-6 col-12 d-flex">
						<div class="dash-widget dash2 w-100">
							<div class="dash-widgetimg">
								<span><img src="assets/img/icons/dash3.svg" alt="img"></span>
							</div>
							<div class="dash-widgetcontent">
								<h5>₹ <span class="counters" data-count="{{ $totalPurchaseAmount}}">{{number_format($totalPurchaseAmount, 2) }}</span></h5>
								<h6>Total Purchase Amount</h6>
							</div>
						</div>
					</div>
					<div class="col-xl-3 col-sm-6 col-12 d-flex">
						<div class="dash-widget dash3 w-100">
							<div class="dash-widgetimg">
								<span><img src="assets/img/icons/dash4.svg" alt="img"></span>
							</div>
							<div class="dash-widgetcontent">
								<h5>₹ <span class="counters" data-count="{{$totalSaleAmount}}">{{$totalSaleAmount}}</span></h5>
								<h6>Total Sale Amount</h6>
							</div>
						</div>
					</div>
					<div class="col-xl-3 col-sm-6 col-12 d-flex">
						<div class="dash-count">
							<div class="dash-counts">
								<h4>{{$customers}}</h4>
								<h5>Customers</h5>
							</div>
							<div class="dash-imgs">
								<i data-feather="user"></i>
							</div>
						</div>
					</div>
					<div class="col-xl-3 col-sm-6 col-12 d-flex">
						<div class="dash-count das1">
							<div class="dash-counts">
								<h4>{{$suppliers}}</h4>
								<h5>Suppliers</h5>
							</div>
							<div class="dash-imgs">
								<i data-feather="user-check"></i>
							</div>
						</div>
					</div>
					<div class="col-xl-3 col-sm-6 col-12 d-flex">
						<div class="dash-count das2">
							<div class="dash-counts">
								<h4>{{$purchase_invoice}}</h4>
								<h5>Purchase Invoice</h5>
							</div>
							<div class="dash-imgs">
								<img src="assets/img/icons/file-text-icon-01.svg" class="img-fluid" alt="icon">
							</div>
						</div>
					</div>
					<div class="col-xl-3 col-sm-6 col-12 d-flex">
						<div class="dash-count das3">
							<div class="dash-counts">
								<h4>{{$sale_invoice}}</h4>
								<h5>Sales Invoice</h5>
							</div>
							<div class="dash-imgs">
								<i data-feather="file"></i>
							</div>
						</div>
					</div>
				</div>
				<!-- Button trigger modal -->

				<div class="row">
						<div class="col-xl-7 col-sm-12 col-12 d-flex">
							<div class="card flex-fill">
								<div class="card-header d-flex justify-content-between align-items-center">
									<h5 class="card-title mb-0">Purchase & Sales</h5>
									<div class="graph-sets">
										<ul class="mb-0">
											 <li>
												<span>Sales</span>
											</li>
											<li>
												<span>Purchase</span>
											</li> 
										</ul>
										{{-- <div class="dropdown dropdown-wraper">
											<button class="btn btn-light btn-sm dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
												2025
											</button>
											<ul class="dropdown-menu" aria-labelledby="dropdownMenuButton" id="yearDropdown">
												<li>
													<a href="javascript:void(0);" class="dropdown-item">2025</a>
												</li>
												<li>
													<a href="javascript:void(0);" class="dropdown-item">2024</a>
												</li>
												<li>
													<a href="javascript:void(0);" class="dropdown-item">2023</a>
												</li>
											</ul>
										</div> --}}
										<div class="dropdown dropdown-wraper">
											<button class="btn btn-light btn-sm dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
												2025
											</button>
											<ul class="dropdown-menu" aria-labelledby="dropdownMenuButton" id="yearDropdown">
												<li><a href="javascript:void(0);" class="dropdown-item">2025</a></li>
												<li><a href="javascript:void(0);" class="dropdown-item">2024</a></li>
												<li><a href="javascript:void(0);" class="dropdown-item">2023</a></li>
											</ul>
										</div>
										
										
									</div>
								</div>
								<div class="card-body">
									<div id="sales_charts"></div>
								</div>
							</div>
						</div>
					<div class="col-xl-5 col-sm-12 col-12 d-flex">
						<div class="card flex-fill default-cover mb-4">
							<div class="card-header d-flex justify-content-between align-items-center">
								<h4 class="card-title mb-0">Top Products</h4>
								<div class="view-all-link">
									{{-- <a href="javascript:void(0);" class="view-all d-flex align-items-center">
										View All<span class="ps-2 d-flex align-items-center"><i data-feather="arrow-right" class="feather-16"></i></span>
									</a> --}}
								</div>
							</div>
							<div class="card-body">
								<div class="table-responsive dataview">
									<table class="table dashboard-recent-products">
										<thead>
											<tr>
												<th>#</th>
												<th>Products</th>
												<!--<th>Price</th>-->
												<th>Quantity</th>
											</tr>
										</thead>
										<tbody>
											@php $i=1 @endphp
											@foreach($topSellingProduct as $row)
											<tr>
												<td>{{ $i++}}</td>
												<td class="productimgname">
													<a href="" class="product-img">
														<img src="{{ $row->product_image}}" alt="Product Image" style="height:50px;width:100px;" onerror="this.onerror=null;this.src='{{ url('uploads/images.jpeg') }}';">
													</a>
													<a href="">{{ $row->product_name}}</a>
												</td>
												<!--<td>₹ {{ $row->retail_price}}</td>-->
												<td> {{ $row->total_sold}}</td>
											</tr>
											@endforeach
										</tbody>
									</table>
								</div>
							</div>
						</div>
					</div>
				</div>
			
			</div>
		</div>

		{{-- <div class="customizer-links" id="setdata">
			<ul class="sticky-sidebar">
				<li class="sidebar-icons">
					<a href="#" class="navigation-add" data-bs-toggle="tooltip" data-bs-placement="left" data-bs-original-title="Theme">
						<i data-feather="settings" class="feather-five"></i>
					</a>
				</li>
			</ul>
		</div> --}}

	</div>
	<!-- /Main Wrapper -->
	<!-- <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script> -->

	<script src="{{ url('assets/plugins/apexchart/apexcharts.min.js')}}"></script>

	
	<script>
		document.addEventListener("DOMContentLoaded", function () {
			let selectedYear = 2025; // Default year
			var chart
			if($('#sales_charts').length > 0) {
				
				function fetchChartData(year) {
					console.log("Fetching data for year:", year); // Debug log
					fetch(`/get-sales-purchase-data?year=${year}`)
						.then(response => response.json())
						.then(data => {
							console.log("Received data:", data); // Debug response
							data.purchase = data.purchase.map(val => -parseFloat(val) || 0);
							let options = {
								
								series: [{
									name: 'Sales',
									data: data.sales,
								}, {
									name: 'Purchase',
									// Convert purchase strings to negative numbers
									data: data.purchase,

								}],
								colors: ['#28C76F', '#EA5455'],
									chart: {
									type: 'bar',
									height: 320,
									stacked: true,
									
									zoom: {
									enabled: true
									}
								},
								responsive: [{
									breakpoint: 280,
									options: {
									legend: {
										position: 'bottom',
										offsetY: 0
									}
									}
								}],
								plotOptions: {
									bar: {
									horizontal: false,
									borderRadius: 4,
									borderRadiusApplication: "end", // "around" / "end" 
									borderRadiusWhenStacked: "all", // "all"/"last"
									columnWidth: '20%',
									},
								},
								dataLabels: {
								enabled: false
								},
								// stroke: {
								//     width: 5,
								//     colors: ['#fff']
								//   },
								yaxis: {
									min: -200,
									max: 300,
									tickAmount: 5,
									},
								xaxis: {
									categories: [' Jan ', 'Feb', 'Mar', 'Apr',
									'May', 'Jun' , 'Jul' , 'Aug', 'Sep'
									],
								},
								legend: {show: false},
								fill: {
									opacity: 1
								}
							};

		
							if (chart) {
								chart.updateOptions(options);
							} else {

								chart = new ApexCharts(document.querySelector("#sales_charts"), options);
								chart.render();
							}
						})

						.catch(error => console.error("Error fetching chart data:", error));
				}
				
			}
		


			// Load initial data for default year (2025)

			fetchChartData(selectedYear);
			document.getElementById("dropdownMenuButton").innerText = selectedYear;
	
			// Fix dropdown click listener

			document.getElementById("yearDropdown").addEventListener("click", function (event) {
				if (event.target.classList.contains("dropdown-item")) {
					selectedYear = event.target.innerText.trim(); // Get selected year
					console.log("Year selected:", selectedYear); // Debug log

	
					document.getElementById("dropdownMenuButton").innerText = selectedYear; // Update button text
					fetchChartData(selectedYear); // Fetch new data
				}

			});
		
			function animateCounters() {
				document.querySelectorAll(".counters").forEach(counter => {
					let target = parseFloat(counter.getAttribute("data-count")); // Convert to number
					let count = 0;
					let increment = target / 100; // Adjust speed
	
					function updateCounter() {
						count += increment;
						if (count < target) {
							counter.innerText = Math.floor(count);
							requestAnimationFrame(updateCounter);
						} else {
							counter.innerText = target.toLocaleString(); // Final value
						}
					}
	
					updateCounter();
				});
			}
	
			// Ensure function runs after data is fully loaded
			setTimeout(animateCounters, 500); // Delay to allow dynamic data load
		});
	</script>
	
	@include('layouts.footer')
