<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Receipt</title>
    <style>
  body {
            font-family: Arial, sans-serif;
            margin: 5px;
            padding: 0;
        }
        .receipt-container {
            max-width: 800px;
            margin: auto;
            padding: 20px;
            border: 1px solid #ddd;
            box-shadow: 2px 2px 10px rgba(0, 0, 0, 0.1);
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        .header h2 {
            margin: 0;
        }
        .logo img {
            max-height: 60px;
            max-width: 150px;
            float: right;
            margin-top:-20px;
        }
        .company-receipt {
            width: 100%;
            margin-bottom: 20px;
        }
        .company-info {
            text-align: left;
            width: 50%;
        }
        .receipt-info {
          float:right;
            width: 50%;
            margin-right: -90px;
            margin-top: -130px;
        }
        .bill-ship-info, .order-summary, .payment-details {
            margin-bottom: 20px;
        }
        .info-table {
            width: 100%;
           
        }
        .info-table td {
            padding: 5px;
            vertical-align: top;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        table, th, td {
            border: 1px solid #ddd;
            text-align: left;
            padding: 8px;
        }
      
        .total {
            font-weight: bold;
            text-align: right;
        }  
        .info-table {
        width: 100%;
        border: none;
    }

    .info-table td {
        border: none; 
        padding: 5px; 
        vertical-align: top;
    }

        
        </style>
</head>
<body>
    <div class="receipt-container">
        <div class="header">
            <h2>RECEIPT</h2>
            <div class="logo">
                <img src="assets/img/logo.png" alt="Company Logo">
            </div>
        </div>

        <div class="company-details">
            <div class="company-info">
                <h3>Kukreja Interiors</h3>
                <p>A-45, R Quarters, Near Sai Chowk, Pimpri Pune 411017</p>
                <p>9665065522 /25 /34 | kukreja_interiors@yahoo.com</p>
            </div>
            <div class="receipt-info">
                <p><strong>Receipt No: {{$inward_invoice->invoice_id}}</strong> </p>
                <p><strong>Payment Date: {{\Carbon\Carbon::parse($inward_invoice->created_at)->format('Y-m-d')}}</strong> </p>
            </div>
        </div>

        <div class="bill-ship-info">
            <h3>Bill To:</h3>
            <table class="info-table" >
                <tr>
                    <td><strong>Supplier Name: {{$supplier->supplier_name}}</strong></td>
                    <td><strong>Ship To: {{$supplier->address}}</strong> </td>
                </tr>
                <tr>
                    <td><strong>Address: {{$supplier->address}}</strong> </td>
                    <td><strong>Phone: {{$supplier->mobile}}</strong> </td>
                </tr>
                <tr>
                    <td><strong>Email: {{$supplier->email}}</strong> </td>
                </tr>
            </table>
        </div>

        <div class="order-summary">
            <h3>Order Summary</h3>
            <table>
                <tr style="background:#9E00D7;color:white">
                   <th>Product Name</th>
                    <th>Varient Name</th>
                    <th>Quantity/roll</th>
                    <th>Unit</th>
                    <th>No of roll</th>
                    <th>Unit Price</th>
                    <th>Total</th>
                </tr>
                @if(isset($po_items) && count($po_items) > 0)
                @foreach($po_items as $items)
                <tr>
                   <td>{{$items->product_name}}</td>
                    <td>{{$items->varient_name}}</td>
                    <td>{{$items->quantity}}</td>
                    <td>{{$items->unit_name}}</td>
                    <td>{{$items->no_of_rolls}}</td>
                    <td>{{$items->rate}}</td>
                    <td>{{$items->amount}}</td>
                </tr>
                @endforeach
                @endif
                <!-- <tr>
                    <td colspan="4">Forwarding</td>
                    <td class="text-dark">{{$po->f_amount}}</td>
                </tr>
                <tr>
                    <td colspan="4">GST Amount</td>
                    <td> {{$po->gst_amount}}</td>
                </tr> -->
                <tr>
                    <td colspan="6" class="total"><strong>Grand Total </strong></td>
                    <td><strong>{{$items->amount}}</strong></td>
                </tr>
            </table>
        </div>

        

    </div>
</body>
</html>

